/*
 * Decompiled with CFR 0.152.
 */
package ui.debugger;

import ui.SystemUI;

public class BreakPoint {
    private Variable var;
    private Object value;
    private boolean enabled;
    private static SystemUI sys;
    private static Object[] lastcpudata;
    private static Object[] lastppudata;

    public BreakPoint(Variable var, Object value) {
        this.var = var;
        this.value = value;
        this.enabled = true;
    }

    public static void setsystem(SystemUI s) {
        sys = s;
    }

    public static void updateData() {
        lastcpudata = BreakPoint.sys.nes.getCPUDebugInfo();
        lastppudata = BreakPoint.sys.nes.getPPUDebugInfo();
    }

    public void toggleEnable() {
        this.enabled = !this.enabled;
    }

    public boolean checkbreakpoint() {
        if (this.enabled) {
            switch (this.var) {
                case ProgramCounter: {
                    return ((Integer)lastcpudata[0]).intValue() == ((Integer)this.value).intValue();
                }
                case A: {
                    return ((Integer)lastcpudata[4]).intValue() == ((Integer)this.value).intValue();
                }
                case X: {
                    return ((Integer)lastcpudata[5]).intValue() == ((Integer)this.value).intValue();
                }
                case Y: {
                    return ((Integer)lastcpudata[6]).intValue() == ((Integer)this.value).intValue();
                }
                case SP: {
                    return ((Integer)lastcpudata[3]).intValue() == ((Integer)this.value).intValue();
                }
                case Nflag: {
                    return ((Boolean)lastcpudata[7]).booleanValue() == ((Boolean)this.value).booleanValue();
                }
                case Vflag: {
                    return ((Boolean)lastcpudata[8]).booleanValue() == ((Boolean)this.value).booleanValue();
                }
                case Dflag: {
                    return ((Boolean)lastcpudata[9]).booleanValue() == ((Boolean)this.value).booleanValue();
                }
                case Iflag: {
                    return ((Boolean)lastcpudata[10]).booleanValue() == ((Boolean)this.value).booleanValue();
                }
                case Zflag: {
                    return ((Boolean)lastcpudata[11]).booleanValue() == ((Boolean)this.value).booleanValue();
                }
                case Cflag: {
                    return ((Boolean)lastcpudata[12]).booleanValue() == ((Boolean)this.value).booleanValue();
                }
                case Scanline: {
                    return ((Integer)lastppudata[1]).intValue() == ((Integer)this.value).intValue();
                }
                case ppucycle: {
                    return ((Integer)lastppudata[0]).intValue() == ((Integer)this.value).intValue();
                }
                case Verticalblank: {
                    return ((Boolean)lastppudata[2]).booleanValue() == ((Boolean)this.value).booleanValue();
                }
                case Sprite0: {
                    return ((Boolean)lastppudata[4]).booleanValue() == ((Boolean)this.value).booleanValue();
                }
                case Spriteoverflow: {
                    return ((Boolean)lastppudata[3]).booleanValue() == ((Boolean)this.value).booleanValue();
                }
                case Irqexternal: {
                    return ((boolean[])lastcpudata[13])[0] == (Boolean)this.value;
                }
                case Irqframe: {
                    return ((boolean[])lastcpudata[13])[1] == (Boolean)this.value;
                }
                case Irqdmc: {
                    return ((boolean[])lastcpudata[13])[2] == (Boolean)this.value;
                }
                case Nmi: {
                    return ((Boolean)lastcpudata[14]).booleanValue() == ((Boolean)this.value).booleanValue();
                }
            }
        }
        return false;
    }

    public String toString() {
        String val = this.value + "";
        if (!val.equals("true") && !val.equals(false)) {
            val = "$" + Integer.toHexString((Integer)this.value);
        }
        return "Variable: " + (Object)((Object)this.var) + "  Value: " + val + "  Enabled: " + this.enabled;
    }

    public static enum Variable {
        ProgramCounter,
        A,
        X,
        Y,
        SP,
        Nflag,
        Vflag,
        Dflag,
        Iflag,
        Zflag,
        Cflag,
        Scanline,
        ppucycle,
        Verticalblank,
        Sprite0,
        Spriteoverflow,
        Irqexternal,
        Irqframe,
        Irqdmc,
        Nmi;

    }
}

