/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Machine;
import gui.OsUtils;
import gui.TelnetClient;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class CAPEGUI
extends JFrame
implements ActionListener {
    static JFrame frameNewMachine;
    static Machine mMachine;
    static OsUtils osUtils;
    static TelnetClient telnetClient;
    static Timer timer;
    static final String VERSION = "0.6";
    JLabel lblClassValue;
    JLabel lblNameValue;
    PrintStream printStream;
    JComboBox classList;
    JComboBox processorList;
    JCheckBox cbxFPU;
    JCheckBox cbxBIOS;
    JComboBox videoList1;
    JComboBox videoList2;
    JComboBox filterList;
    JComboBox scalerList;
    JComboBox biosList;
    JComboBox biosType;
    JComboBox timingList;
    JButton exitButton;
    JButton runButton;
    JButton rebootButton;
    JButton quitButton;
    JButton playButton;
    JButton pauseButton;
    JTextField txtMachineName;
    JTextField txtMemory;
    JTextField txtMemoryWaitStates;
    JTextField txtVidMemory;
    JTextField txtVidBIOS;
    JTextField txtVidMemory2;
    JTextField txtVidBIOS2;
    JTextField txtProcFreq;
    JFileChooser fileChooser;
    JTextField txtDisk0;
    JTextField txtDisk1;
    JTextField txtFloppy0;
    JTextField txtFloppy1;
    JTextField txtBASIC;
    JTextField txtBIOSSingle;
    JTextField txtBIOSEven;
    JTextField txtBIOSOdd;
    JTextField txtBIOSLow;
    JTextField txtBIOSHigh;
    JLabel lblVideoMem;
    JLabel lblVideoBIOS;
    JLabel lblVideoMem2;
    JLabel lblVideoBIOS2;
    JCheckBox cbxDSS;
    JCheckBox cbxSpeaker;
    JCheckBox cbxAdLib;
    JCheckBox cbxMouseCOM1;
    JButton btnSingle;
    JButton btnEven;
    JButton btnOdd;
    JButton btnLow;
    JButton btnHigh;
    JButton btnBASIC;
    boolean bConnectedToEmulator;

    public CAPEGUI() {
        mMachine = new Machine();
        this.initUI();
        telnetClient = new TelnetClient();
        this.setTimer();
        this.syncUIWithMachine();
        this.bConnectedToEmulator = false;
    }

    private void setCPUList(int n) {
        this.processorList.removeAllItems();
        String[] stringArray = mMachine.getSupportedCPU(n);
        for (int i = 0; i < stringArray.length; ++i) {
            this.processorList.addItem(stringArray[i]);
        }
        this.processorList.setSelectedIndex(0);
    }

    private JPanel createMachineConfigPanel() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Machine Configuration");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        Object object = new JLabel("Class:");
        jPanel2.add((Component)object);
        Object object2 = new String[]{"Generic XT", "IBM PC XT (5160)", "Generic AT", "IBM PC XT 286 (5162)", "IBM PC/AT (5170)", "IBM PC Jr (Experimental)"};
        this.classList = new JComboBox<String>((E[])object2);
        this.classList.setSelectedIndex(CAPEGUI.mMachine.mMachineClass);
        this.classList.addActionListener(this);
        jPanel2.add(this.classList);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        object = new JLabel("BASIC:");
        jPanel2.add((Component)object);
        this.txtBASIC = new JTextField(20);
        this.txtBASIC.setText(CAPEGUI.mMachine.mBASICPath);
        jPanel2.add(this.txtBASIC);
        this.btnBASIC = new JButton("Browse...");
        this.btnBASIC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CAPEGUI.this.browseForFiles(CAPEGUI.this.txtBASIC, 5);
                mMachine.saveToFile();
            }
        });
        jPanel2.add(this.btnBASIC);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        object = new JLabel("Processor:");
        jPanel2.add((Component)object);
        object2 = new String[]{"8086", "V20", "80186", "80286", "80386"};
        this.processorList = new JComboBox<String>((E[])object2);
        this.processorList.setSelectedIndex(CAPEGUI.mMachine.mMachineCPU);
        this.setCPUList(CAPEGUI.mMachine.mMachineClass);
        this.processorList.addActionListener(this);
        jPanel2.add(this.processorList);
        jPanel2.add(new JLabel("Freq (Mhz):"));
        this.txtProcFreq = new JTextField(5);
        this.txtProcFreq.setColumns(5);
        this.txtProcFreq.setText(Float.toString(CAPEGUI.mMachine.mMachineProcFreq));
        this.txtProcFreq.addActionListener(this);
        jPanel2.add(this.txtProcFreq);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Timing model:"));
        object = new String[]{"Cycle Based"};
        this.timingList = new JComboBox<String>((E[])object);
        this.timingList.setSelectedIndex(0);
        this.timingList.addActionListener(this);
        jPanel2.add(this.timingList);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        object = new JLabel("FPU:");
        ((JComponent)object).setEnabled(false);
        jPanel2.add((Component)object);
        this.cbxFPU = new JCheckBox("Enabled", CAPEGUI.mMachine.mMachineFPU);
        this.cbxFPU.addActionListener(this);
        this.cbxFPU.setEnabled(false);
        jPanel2.add(this.cbxFPU);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        object = new JLabel("RAM");
        jPanel2.add((Component)object);
        object2 = new JLabel("Size (Kb):");
        jPanel2.add((Component)object2);
        this.txtMemory = new JTextField(5);
        this.txtMemory.setColumns(5);
        this.txtMemory.setText(Integer.toString(CAPEGUI.mMachine.mMachineRAM));
        this.txtMemory.addActionListener(this);
        jPanel2.add(this.txtMemory);
        JComponent jComponent = new JLabel("Wait States:");
        jPanel2.add(jComponent);
        this.txtMemoryWaitStates = new JTextField(3);
        this.txtMemoryWaitStates.setColumns(3);
        this.txtMemoryWaitStates.setText(Integer.toString(CAPEGUI.mMachine.mMachineRAMWaitStates));
        this.txtMemoryWaitStates.addActionListener(this);
        jPanel2.add(this.txtMemoryWaitStates);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        object = new JLabel("Video card 1:");
        jPanel2.add((Component)object);
        object2 = new String[]{"IBM MDA", "IBM CGA", "Hercules", "IBM EGA", "None"};
        this.videoList1 = new JComboBox<String>((E[])object2);
        this.videoList1.setSelectedIndex(CAPEGUI.mMachine.mMachineVideo);
        this.videoList1.addActionListener(this);
        jPanel2.add(this.videoList1);
        this.lblVideoMem = new JLabel("Video RAM (Kb):");
        jPanel2.add(this.lblVideoMem);
        this.txtVidMemory = new JTextField(3);
        this.txtVidMemory.setText(Integer.toString(CAPEGUI.mMachine.mMachineVRAM));
        this.txtVidMemory.setColumns(3);
        jPanel2.add(this.txtVidMemory);
        this.txtVidMemory.setEnabled(false);
        this.lblVideoMem.setEnabled(false);
        jPanel.add(jPanel2);
        object = new JPanel();
        this.lblVideoBIOS = new JLabel("Video 1 BIOS:");
        ((Container)object).add(this.lblVideoBIOS);
        this.txtVidBIOS = new JTextField(20);
        this.txtVidBIOS.setText(CAPEGUI.mMachine.mVideoBIOS);
        ((Container)object).add(this.txtVidBIOS);
        this.txtVidBIOS.setEnabled(false);
        this.lblVideoBIOS.setEnabled(false);
        jPanel.add((Component)object);
        object2 = new JPanel();
        jComponent = new JLabel("Video card 2:");
        ((Container)object2).add(jComponent);
        Object object3 = new String[]{"IBM MDA", "IBM CGA", "Hercules", "IBM EGA", "None"};
        this.videoList2 = new JComboBox<String>((E[])object3);
        this.videoList2.setSelectedIndex(4);
        this.videoList2.addActionListener(this);
        ((Container)object2).add(this.videoList2);
        this.lblVideoMem2 = new JLabel("Video RAM (Kb):");
        ((Container)object2).add(this.lblVideoMem2);
        this.txtVidMemory2 = new JTextField(3);
        this.txtVidMemory2.setText(Integer.toString(CAPEGUI.mMachine.mMachineVRAM));
        this.txtVidMemory2.setColumns(3);
        ((Container)object2).add(this.txtVidMemory2);
        this.txtVidMemory2.setEnabled(false);
        this.lblVideoMem2.setEnabled(false);
        jPanel.add((Component)object2);
        jComponent = new JPanel();
        this.lblVideoBIOS2 = new JLabel("Video 2 BIOS:");
        jComponent.add(this.lblVideoBIOS2);
        this.txtVidBIOS2 = new JTextField(20);
        this.txtVidBIOS2.setText(CAPEGUI.mMachine.mVideoBIOS2);
        jComponent.add(this.txtVidBIOS2);
        this.txtVidBIOS2.setEnabled(false);
        this.lblVideoBIOS2.setEnabled(false);
        jPanel.add(jComponent);
        object3 = new JPanel();
        JLabel jLabel = new JLabel("Sound:");
        ((Container)object3).add(jLabel);
        this.cbxSpeaker = new JCheckBox("Speaker", true);
        this.cbxSpeaker.addActionListener(this);
        this.cbxAdLib = new JCheckBox("AdLib", false);
        this.cbxAdLib.setEnabled(false);
        this.cbxAdLib.addActionListener(this);
        this.cbxDSS = new JCheckBox("Sound Source", false);
        this.cbxDSS.setEnabled(false);
        this.cbxDSS.addActionListener(this);
        ((Container)object3).add(this.cbxSpeaker);
        ((Container)object3).add(this.cbxAdLib);
        ((Container)object3).add(this.cbxDSS);
        jPanel.add((Component)object3);
        object3 = new JPanel();
        jLabel = new JLabel("Mouse:");
        ((Container)object3).add(jLabel);
        this.cbxMouseCOM1 = new JCheckBox("COM1", true);
        this.cbxMouseCOM1.addActionListener(this);
        ((Container)object3).add(this.cbxMouseCOM1);
        jPanel.add((Component)object3);
        return jPanel;
    }

    private JPanel createStoragePanel() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Floppy/HDD");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("FDD 0:");
        jPanel2.add(jLabel);
        this.txtFloppy0 = new JTextField(20);
        this.txtFloppy0.setText(CAPEGUI.mMachine.mFDD0);
        jPanel2.add(this.txtFloppy0);
        JButton jButton = new JButton("Insert");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CAPEGUI.this.browseForFiles(CAPEGUI.this.txtFloppy0, 2);
                mMachine.saveToFile();
                CAPEGUI.this.insertOrEjectFloppy(0, CAPEGUI.this.txtFloppy0.getText(), true);
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("Eject");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CAPEGUI.this.insertOrEjectFloppy(0, CAPEGUI.this.txtFloppy0.getText(), false);
                CAPEGUI.this.txtFloppy0.setText("");
            }
        });
        jPanel2.add(jButton2);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jLabel = new JLabel("FDD 1:");
        jPanel2.add(jLabel);
        this.txtFloppy1 = new JTextField(20);
        this.txtFloppy1.setText(CAPEGUI.mMachine.mFDD1);
        jPanel2.add(this.txtFloppy1);
        jButton = new JButton("Insert");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CAPEGUI.this.browseForFiles(CAPEGUI.this.txtFloppy1, 3);
                mMachine.saveToFile();
                CAPEGUI.this.insertOrEjectFloppy(1, CAPEGUI.this.txtFloppy1.getText(), true);
            }
        });
        jPanel2.add(jButton);
        jButton2 = new JButton("Eject");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CAPEGUI.this.insertOrEjectFloppy(1, CAPEGUI.this.txtFloppy1.getText(), false);
                CAPEGUI.this.txtFloppy1.setText("");
            }
        });
        jPanel2.add(jButton2);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jLabel = new JLabel("HDD 0:");
        jPanel2.add(jLabel);
        this.txtDisk0 = new JTextField(20);
        this.txtDisk0.setText(CAPEGUI.mMachine.mHDD0);
        jPanel2.add(this.txtDisk0);
        jButton = new JButton("Browse");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CAPEGUI.this.browseForFiles(CAPEGUI.this.txtDisk0, 0);
                mMachine.saveToFile();
            }
        });
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jLabel = new JLabel("HDD 1:");
        jPanel2.add(jLabel);
        this.txtDisk1 = new JTextField(20);
        this.txtDisk1.setText(CAPEGUI.mMachine.mHDD1);
        jPanel2.add(this.txtDisk1);
        jButton = new JButton("Browse");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CAPEGUI.this.browseForFiles(CAPEGUI.this.txtDisk1, 1);
                mMachine.saveToFile();
            }
        });
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel createPanelRender() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Render Configuration");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("Filter:");
        jPanel2.add(jLabel);
        String[] stringArray = new String[]{"Passthrough", "B&W", "Green", "Amber"};
        this.filterList = new JComboBox<String>(stringArray);
        this.filterList.setSelectedIndex(CAPEGUI.mMachine.mRenderFilter);
        this.filterList.addActionListener(this);
        jPanel2.add(this.filterList);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jLabel = new JLabel("Scaler:");
        jPanel2.add(jLabel);
        stringArray = new String[]{"Normal2X", "Scale2X", "Scale3X"};
        this.scalerList = new JComboBox<String>(stringArray);
        this.scalerList.setSelectedIndex(CAPEGUI.mMachine.mRenderScaler);
        this.scalerList.addActionListener(this);
        jPanel2.add(this.scalerList);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel createBIOSPanel() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("BIOS/ROM");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("ROM Type");
        jPanel2.add(jLabel);
        String[] stringArray = new String[]{"Single", "Even/Odd", "Low/High"};
        this.biosType = new JComboBox<String>(stringArray);
        this.biosType.setSelectedIndex(CAPEGUI.mMachine.mMachineClass);
        this.biosType.addActionListener(this);
        jPanel2.add(this.biosType);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jLabel = new JLabel("Single");
        jPanel2.add(jLabel);
        this.txtBIOSSingle = new JTextField(20);
        this.txtBIOSSingle.setText(CAPEGUI.mMachine.mBIOSPath);
        jPanel2.add(this.txtBIOSSingle);
        this.btnSingle = new JButton("Browse...");
        this.btnSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CAPEGUI.this.browseForFiles(CAPEGUI.this.txtBIOSSingle, 4);
                mMachine.saveToFile();
            }
        });
        jPanel2.add(this.btnSingle);
        this.btnSingle.setEnabled(true);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jLabel = new JLabel("Even");
        jPanel2.add(jLabel);
        this.txtBIOSEven = new JTextField(20);
        this.txtBIOSEven.setText(CAPEGUI.mMachine.mBIOSPath);
        this.txtBIOSEven.setEnabled(false);
        jPanel2.add(this.txtBIOSEven);
        this.btnEven = new JButton("Browse...");
        this.btnEven.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CAPEGUI.this.browseForFiles(CAPEGUI.this.txtBIOSEven, 5);
                mMachine.saveToFile();
            }
        });
        jPanel2.add(this.btnEven);
        this.btnEven.setEnabled(false);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jLabel = new JLabel("Odd");
        jPanel2.add(jLabel);
        this.txtBIOSOdd = new JTextField(20);
        this.txtBIOSOdd.setText(CAPEGUI.mMachine.mBIOSPath);
        this.txtBIOSOdd.setEnabled(false);
        jPanel2.add(this.txtBIOSOdd);
        this.btnOdd = new JButton("Browse...");
        this.btnOdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CAPEGUI.this.browseForFiles(CAPEGUI.this.txtBIOSOdd, 6);
                mMachine.saveToFile();
            }
        });
        jPanel2.add(this.btnOdd);
        this.btnOdd.setEnabled(false);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jLabel = new JLabel("Low");
        jPanel2.add(jLabel);
        this.txtBIOSLow = new JTextField(20);
        this.txtBIOSLow.setText(CAPEGUI.mMachine.mBIOSPath);
        this.txtBIOSLow.setEnabled(false);
        jPanel2.add(this.txtBIOSLow);
        this.btnLow = new JButton("Browse...");
        this.btnLow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CAPEGUI.this.browseForFiles(CAPEGUI.this.txtBIOSLow, 7);
                mMachine.saveToFile();
            }
        });
        jPanel2.add(this.btnLow);
        this.btnLow.setEnabled(false);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jLabel = new JLabel("High");
        jPanel2.add(jLabel);
        this.txtBIOSHigh = new JTextField(20);
        this.txtBIOSHigh.setText(CAPEGUI.mMachine.mBIOSPath);
        this.txtBIOSHigh.setEnabled(false);
        jPanel2.add(this.txtBIOSHigh);
        this.btnHigh = new JButton("Browse...");
        this.btnHigh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CAPEGUI.this.browseForFiles(CAPEGUI.this.txtBIOSHigh, 8);
                mMachine.saveToFile();
            }
        });
        jPanel2.add(this.btnHigh);
        this.btnHigh.setEnabled(false);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void initUI() {
        System.out.print("Found OS: ");
        System.out.println(System.getProperty("os.name"));
        this.createMenuBar();
        this.createToolBar();
        this.fileChooser = new JFileChooser(".");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new EmptyBorder(new Insets(0, 0, 20, 20)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        JPanel jPanel4 = this.createMachineConfigPanel();
        jPanel2.add(jPanel4);
        JPanel jPanel5 = this.createBIOSPanel();
        jPanel2.add(jPanel5);
        JPanel jPanel6 = this.createStoragePanel();
        jPanel3.add(jPanel6);
        JPanel jPanel7 = this.createPanelRender();
        jPanel3.add(jPanel7);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        this.add(jPanel);
        this.pack();
        this.setTitle("CAPE GUI 0.6");
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    private void browseForFiles(JTextField jTextField, int n) {
        if (this.fileChooser.showOpenDialog(this) == 0) {
            jTextField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void insertOrEjectFloppy(int n, String string, boolean bl) {
        if (this.bConnectedToEmulator) {
            if (bl) {
                telnetClient.sendCommand("insert " + (n == 1 ? "B" : "A") + " " + string + "\n");
            } else {
                telnetClient.sendCommand("eject " + (n == 1 ? "B" : "A") + "\n");
            }
        }
    }

    private void createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Load Machine", 76);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Save Machine", 83);
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Load Snapshot", 80);
        jMenuItem3.addActionListener(this);
        jMenuItem3.setEnabled(false);
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Save Snapshot", 83);
        jMenuItem4.addActionListener(this);
        jMenuItem4.setEnabled(false);
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        JMenuItem jMenuItem5 = new JMenuItem("Exit");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem5);
    }

    public void runCommandLine(String string, String string2, String string3) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(string2, string3);
        processBuilder.directory(new File(string));
        Process process = processBuilder.start();
        Thread thread = new Thread(() -> {
            try {
                String string;
                InputStream inputStream = process.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                System.out.printf("Output of running is:", new Object[0]);
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(string);
                }
                System.out.printf("task done", new Object[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        thread.setDaemon(true);
        thread.start();
        System.out.println("Task Dispatched");
    }

    private void createToolBar() {
        JToolBar jToolBar = new JToolBar();
        ImageIcon imageIcon = new ImageIcon("images/capegui_exit.png");
        this.exitButton = new JButton(imageIcon);
        this.exitButton.setToolTipText("Exit GUI");
        jToolBar.add(this.exitButton);
        jToolBar.addSeparator();
        imageIcon = new ImageIcon("images/capegui_run.png");
        this.runButton = new JButton(imageIcon);
        this.runButton.setToolTipText("Run emulator");
        jToolBar.add(this.runButton);
        imageIcon = new ImageIcon("images/capegui_reboot.png");
        this.rebootButton = new JButton(imageIcon);
        this.rebootButton.setToolTipText("Reboot emulator");
        this.rebootButton.setEnabled(false);
        jToolBar.add(this.rebootButton);
        imageIcon = new ImageIcon("images/capegui_stop.png");
        this.quitButton = new JButton(imageIcon);
        this.quitButton.setToolTipText("Quit emulator");
        this.quitButton.setEnabled(false);
        jToolBar.add(this.quitButton);
        imageIcon = new ImageIcon("images/capegui_play.png");
        this.playButton = new JButton(imageIcon);
        this.playButton.setToolTipText("Play emulator");
        this.playButton.setEnabled(false);
        jToolBar.add(this.playButton);
        imageIcon = new ImageIcon("images/capegui_pause.png");
        this.pauseButton = new JButton(imageIcon);
        this.pauseButton.setToolTipText("Pause emulator");
        this.pauseButton.setEnabled(false);
        jToolBar.add(this.pauseButton);
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CAPEGUI.this.bConnectedToEmulator) {
                    telnetClient.sendCommand("quit\n");
                    telnetClient.close();
                }
                System.exit(0);
            }
        });
        this.rebootButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                telnetClient.sendCommand("reboot\n");
            }
        });
        this.quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                telnetClient.sendCommand("quit\n");
                CAPEGUI.this.rebootButton.setEnabled(false);
                CAPEGUI.this.quitButton.setEnabled(false);
                CAPEGUI.this.playButton.setEnabled(false);
                CAPEGUI.this.pauseButton.setEnabled(false);
                CAPEGUI.this.runButton.setEnabled(true);
            }
        });
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                telnetClient.sendCommand("go\n");
            }
        });
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                telnetClient.sendCommand("pause\n");
            }
        });
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CAPEGUI.this.bConnectedToEmulator) {
                    return;
                }
                CAPEGUI.this.syncMachineWithUI();
                mMachine.saveToFile();
                try {
                    String string = osUtils.isWindows() ? "CAPE.exe" : "./CAPE";
                    System.out.println("Launching " + string + " " + CAPEGUI.mMachine.mName);
                    CAPEGUI.this.runCommandLine(".", string, CAPEGUI.mMachine.mName);
                }
                catch (Exception exception) {
                    System.err.println("Error launching emulator: " + exception.getMessage());
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                telnetClient.connect();
                CAPEGUI.this.rebootButton.setEnabled(true);
                CAPEGUI.this.quitButton.setEnabled(true);
                CAPEGUI.this.playButton.setEnabled(true);
                CAPEGUI.this.pauseButton.setEnabled(true);
            }
        });
        this.add((Component)jToolBar, "North");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem.getText() == "Load Machine") {
                int n = this.fileChooser.showOpenDialog(this);
                if (n == 0) {
                    File file = this.fileChooser.getSelectedFile();
                    mMachine.loadFromFile(file.getAbsolutePath());
                    this.syncUIWithMachine();
                }
            } else if (jMenuItem.getText() == "Save Machine") {
                this.fileChooser.setSelectedFile(new File(CAPEGUI.mMachine.mName));
                int n = this.fileChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = this.fileChooser.getSelectedFile();
                    CAPEGUI.mMachine.mName = file.getAbsolutePath();
                    mMachine.saveToFile();
                    this.syncUIWithMachine();
                }
            }
        } else if (actionEvent.getSource() == this.classList) {
            CAPEGUI.mMachine.mMachineClass = this.classList.getSelectedIndex();
            this.setCPUList(CAPEGUI.mMachine.mMachineClass);
            if (CAPEGUI.mMachine.mMachineClass == 1) {
                this.txtMemory.setText("640");
            }
            mMachine.setClass(CAPEGUI.mMachine.mMachineClass);
            this.txtBASIC.setEnabled(CAPEGUI.mMachine.mMachineClass <= 1);
            this.btnBASIC.setEnabled(CAPEGUI.mMachine.mMachineClass <= 1);
            CAPEGUI.mMachine.mBASICROM = CAPEGUI.mMachine.mMachineClass <= 1;
            this.syncUIWithMachine();
        } else if (actionEvent.getSource() == this.biosType) {
            this.btnSingle.setEnabled(this.biosType.getSelectedIndex() == 0);
            this.txtBIOSSingle.setEnabled(this.biosType.getSelectedIndex() == 0);
            this.btnEven.setEnabled(this.biosType.getSelectedIndex() == 1);
            this.txtBIOSEven.setEnabled(this.biosType.getSelectedIndex() == 1);
            this.btnOdd.setEnabled(this.biosType.getSelectedIndex() == 1);
            this.txtBIOSOdd.setEnabled(this.biosType.getSelectedIndex() == 1);
            this.btnLow.setEnabled(this.biosType.getSelectedIndex() == 2);
            this.txtBIOSLow.setEnabled(this.biosType.getSelectedIndex() == 2);
            this.btnHigh.setEnabled(this.biosType.getSelectedIndex() == 2);
            this.txtBIOSHigh.setEnabled(this.biosType.getSelectedIndex() == 2);
        } else if (actionEvent.getSource() == this.processorList) {
            if (this.processorList.getSelectedItem() != null) {
                String string = this.processorList.getSelectedItem().toString();
                if (string.equals("8086")) {
                    CAPEGUI.mMachine.mMachineCPU = 0;
                }
                if (string.equals("8088")) {
                    CAPEGUI.mMachine.mMachineCPU = 1;
                } else if (string.equals("80186")) {
                    CAPEGUI.mMachine.mMachineCPU = 2;
                } else if (string.equals("80188")) {
                    CAPEGUI.mMachine.mMachineCPU = 3;
                } else if (string.equals("80286")) {
                    CAPEGUI.mMachine.mMachineCPU = 4;
                }
            }
        } else if (actionEvent.getSource() == this.cbxFPU) {
            CAPEGUI.mMachine.mMachineFPU = this.cbxFPU.isSelected();
        } else if (actionEvent.getSource() == this.videoList1) {
            CAPEGUI.mMachine.mMachineVideo = this.videoList1.getSelectedIndex();
            if (this.videoList1.getSelectedIndex() < 3) {
                this.txtVidMemory.setEnabled(false);
                this.lblVideoMem.setEnabled(false);
            } else {
                this.txtVidMemory.setEnabled(true);
                this.lblVideoMem.setEnabled(true);
            }
            mMachine.setVideo(1, this.videoList1.getSelectedIndex());
            this.txtVidBIOS.setText(CAPEGUI.mMachine.mVideoBIOS);
        } else if (actionEvent.getSource() == this.videoList2) {
            CAPEGUI.mMachine.mMachineVideo2 = this.videoList2.getSelectedIndex();
            if (this.videoList2.getSelectedIndex() < 3) {
                this.txtVidMemory2.setEnabled(false);
                this.lblVideoMem2.setEnabled(false);
            } else {
                this.txtVidMemory2.setEnabled(true);
                this.lblVideoMem2.setEnabled(true);
            }
            mMachine.setVideo(2, this.videoList2.getSelectedIndex());
            this.txtVidBIOS2.setText(CAPEGUI.mMachine.mVideoBIOS2);
        } else if (actionEvent.getSource() == this.biosList) {
            if (this.cbxBIOS != null) {
                this.cbxBIOS.setSelected(CAPEGUI.mMachine.mBASICROM);
            }
        } else if (actionEvent.getSource() == this.txtMemory) {
            CAPEGUI.mMachine.mMachineRAM = Integer.parseInt(this.txtMemory.getText());
        } else if (actionEvent.getSource() == this.timingList) {
            String string;
            if (this.timingList.getSelectedItem() != null && (string = this.timingList.getSelectedItem().toString()).equals("Cycle Based")) {
                CAPEGUI.mMachine.mMachineTimingModel = 0;
            }
        } else if (actionEvent.getSource() == this.scalerList) {
            CAPEGUI.mMachine.mRenderScaler = this.scalerList.getSelectedIndex();
        } else if (actionEvent.getSource() == this.filterList) {
            CAPEGUI.mMachine.mRenderFilter = this.filterList.getSelectedIndex();
        } else if (actionEvent.getSource() == this.cbxSpeaker) {
            CAPEGUI.mMachine.mMachineSpeaker = this.cbxSpeaker.isSelected();
        } else if (actionEvent.getSource() == this.cbxMouseCOM1) {
            CAPEGUI.mMachine.mMouseType = this.cbxMouseCOM1.isSelected() ? 1 : 0;
        }
    }

    void setTimer() {
        timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!telnetClient.sendCommand("ping")) {
                    CAPEGUI.this.bConnectedToEmulator = false;
                    CAPEGUI.this.rebootButton.setEnabled(false);
                    CAPEGUI.this.quitButton.setEnabled(false);
                    CAPEGUI.this.playButton.setEnabled(false);
                    CAPEGUI.this.pauseButton.setEnabled(false);
                    CAPEGUI.this.runButton.setEnabled(true);
                    CAPEGUI.this.setTitle("CAPE GUI 0.6");
                } else {
                    CAPEGUI.this.bConnectedToEmulator = true;
                    CAPEGUI.this.rebootButton.setEnabled(true);
                    CAPEGUI.this.quitButton.setEnabled(true);
                    CAPEGUI.this.playButton.setEnabled(true);
                    CAPEGUI.this.pauseButton.setEnabled(true);
                    CAPEGUI.this.runButton.setEnabled(false);
                    CAPEGUI.this.setTitle("CAPE GUI - Connected to Emulator 0.6");
                }
            }
        }, 1000L, 1000L);
    }

    void syncUIWithMachine() {
        this.classList.setSelectedIndex(CAPEGUI.mMachine.mMachineClass);
        if (CAPEGUI.mMachine.mBIOSType.equals("BIOS")) {
            this.txtBIOSSingle.setText(CAPEGUI.mMachine.mBIOSPath);
            this.biosType.setSelectedIndex(0);
        } else if (CAPEGUI.mMachine.mBIOSType.equals("BIOSEVENODD")) {
            this.biosType.setSelectedIndex(1);
            this.txtBIOSEven.setText(CAPEGUI.mMachine.mBIOSPath);
            this.txtBIOSOdd.setText(CAPEGUI.mMachine.mBIOSPath2);
        } else if (CAPEGUI.mMachine.mBIOSType.equals("BIOSLOWUP")) {
            this.biosType.setSelectedIndex(2);
            this.txtBIOSLow.setText(CAPEGUI.mMachine.mBIOSPath);
            this.txtBIOSHigh.setText(CAPEGUI.mMachine.mBIOSPath2);
        }
        this.txtBASIC.setText(CAPEGUI.mMachine.mBASICPath);
        this.processorList.setSelectedIndex(0);
        this.txtProcFreq.setText(Float.toString(CAPEGUI.mMachine.mMachineProcFreq));
        this.timingList.setSelectedIndex(CAPEGUI.mMachine.mMachineTimingModel);
        this.cbxFPU.setEnabled(CAPEGUI.mMachine.mMachineFPU);
        this.txtMemory.setText(Integer.toString(CAPEGUI.mMachine.mMachineRAM));
        this.txtMemoryWaitStates.setText(Integer.toString(CAPEGUI.mMachine.mMachineRAMWaitStates));
        this.videoList1.setSelectedIndex(CAPEGUI.mMachine.mMachineVideo);
        this.txtDisk0.setText(CAPEGUI.mMachine.mHDD0);
        this.txtDisk1.setText(CAPEGUI.mMachine.mHDD1);
        this.txtFloppy0.setText(CAPEGUI.mMachine.mFDD0);
        this.txtFloppy1.setText(CAPEGUI.mMachine.mFDD1);
        this.filterList.setSelectedIndex(CAPEGUI.mMachine.mRenderFilter);
        this.scalerList.setSelectedIndex(CAPEGUI.mMachine.mRenderScaler);
        this.cbxSpeaker.setSelected(CAPEGUI.mMachine.mMachineSpeaker);
        this.cbxMouseCOM1.setSelected(CAPEGUI.mMachine.mMouseType == 1);
    }

    int getProcessorID() {
        if (this.processorList.getSelectedItem().toString().equals("8086")) {
            return 0;
        }
        if (this.processorList.getSelectedItem().toString().equals("8088")) {
            return 1;
        }
        if (this.processorList.getSelectedItem().toString().equals("80186")) {
            return 2;
        }
        if (this.processorList.getSelectedItem().toString().equals("80188")) {
            return 3;
        }
        if (this.processorList.getSelectedItem().toString().equals("80286")) {
            return 4;
        }
        return 0;
    }

    void syncMachineWithUI() {
        CAPEGUI.mMachine.mMachineClass = this.classList.getSelectedIndex();
        if (this.biosType.getSelectedIndex() == 0) {
            CAPEGUI.mMachine.mBIOSType = "BIOS";
            CAPEGUI.mMachine.mBIOSPath = this.txtBIOSSingle.getText();
        } else if (this.biosType.getSelectedIndex() == 1) {
            CAPEGUI.mMachine.mBIOSType = "BIOSEVENODD";
            CAPEGUI.mMachine.mBIOSPath = this.txtBIOSEven.getText();
            CAPEGUI.mMachine.mBIOSPath2 = this.txtBIOSOdd.getText();
        } else if (this.biosType.getSelectedIndex() == 2) {
            CAPEGUI.mMachine.mBIOSType = "BIOSLOWUP";
            CAPEGUI.mMachine.mBIOSPath = this.txtBIOSLow.getText();
            CAPEGUI.mMachine.mBIOSPath2 = this.txtBIOSHigh.getText();
        }
        CAPEGUI.mMachine.mBASICPath = this.txtBASIC.getText();
        CAPEGUI.mMachine.mMachineCPU = this.getProcessorID();
        CAPEGUI.mMachine.mMachineRAM = Integer.parseInt(this.txtMemory.getText());
        CAPEGUI.mMachine.mMachineProcFreq = Float.parseFloat(this.txtProcFreq.getText());
        CAPEGUI.mMachine.mMachineFPU = this.cbxFPU.isSelected();
        CAPEGUI.mMachine.mMachineVideo = this.videoList1.getSelectedIndex();
        CAPEGUI.mMachine.mHDD0 = this.txtDisk0.getText();
        CAPEGUI.mMachine.mHDD1 = this.txtDisk1.getText();
        CAPEGUI.mMachine.mFDD0 = this.txtFloppy0.getText();
        CAPEGUI.mMachine.mFDD1 = this.txtFloppy1.getText();
        CAPEGUI.mMachine.mRenderFilter = this.filterList.getSelectedIndex();
        CAPEGUI.mMachine.mRenderScaler = this.scalerList.getSelectedIndex();
        CAPEGUI.mMachine.mMachineSpeaker = this.cbxSpeaker.isSelected();
        CAPEGUI.mMachine.mMouseType = this.cbxMouseCOM1.isSelected() ? 1 : 0;
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CAPEGUI cAPEGUI = new CAPEGUI();
                cAPEGUI.setVisible(true);
            }
        });
    }
}

