/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class Machine {
    public String mName;
    public String mDescription;
    public int mMachineClass = 0;
    public int mMachineCPU = 0;
    public boolean mMachineFPU = false;
    public int mMachineRAM = 1024;
    public int mMachineRAMWaitStates = 0;
    public int mMachineVideo = 1;
    public int mMachineVRAM = 256;
    public String mVideoBIOS;
    public int mMachineVideo2 = 4;
    public int mMachineVRAM2;
    public String mVideoBIOS2;
    public boolean mMachineSpeaker = true;
    public boolean mMachineAdLib = false;
    public boolean mMachineDSS = false;
    public String mBIOSPath;
    public String mBIOSPath2;
    public String mBIOSType = "BIOS";
    public String mHDD0;
    public String mHDD1;
    public String mFDD0;
    public String mFDD1;
    public String mBASICPath;
    public boolean mBASICROM = true;
    public float mMachineProcFreq = 4.78f;
    public int mMachineTimingModel;
    public int mRenderScaler = 0;
    public int mRenderFilter = 0;
    public int mMouseType = 0;
    public final String biosTURBOXT = new String("bios/pcxtbios.bin");
    public final String biosAMI = new String("BIOSEVENODD=bios/AMI_5170/BIOS_5170_30APR89_U27_AMI_27256.BIN,bios/AMI_5170/BIOS_5170_30APR89_U47_AMI_27256.BIN");
    public final String biosBOCHS = new String("BIOS=bios/bochs/BIOS-bochs-latest");

    public Machine() {
        this.mName = new String("config.cfg");
        this.mDescription = new String("Add description here.");
        this.mBIOSPath = this.biosTURBOXT;
        this.mBIOSPath2 = this.biosTURBOXT;
        this.mVideoBIOS = new String("bios/ibm_6277356_ega_card_u44_27128.bin");
        this.mHDD0 = new String("");
        this.mHDD1 = new String("");
        this.mFDD0 = new String("disks/fd.img");
        this.mFDD1 = new String("");
        this.mBASICPath = new String("bios/BASICC11.BIN");
    }

    public void setClass(int n) {
        this.mMachineClass = n;
        switch (this.mMachineClass) {
            case 0: 
            case 1: {
                this.mBIOSPath = new String("bios/pcxtbios.bin");
                this.mBIOSPath2 = new String("");
                this.mBIOSType = "BIOS";
                this.mMachineCPU = 1;
                this.mMachineProcFreq = 4.78f;
                this.mMachineFPU = false;
                this.mMachineRAM = 640;
                this.mMachineRAMWaitStates = 0;
                this.mMachineVideo = 1;
                this.mMachineSpeaker = true;
                this.mMachineAdLib = false;
                this.mMachineDSS = false;
                this.mBASICROM = true;
                this.mMachineVRAM = 256;
                this.mMouseType = 0;
                break;
            }
            case 3: {
                this.mBIOSPath = new String("bios/BIOS_5162_21APR86_U34_78X7460_27256.BIN");
                this.mBIOSPath2 = new String("bios/BIOS_5162_21APR86_U35_78X7461_27256.BIN");
                this.mBIOSType = "BIOSEVENODD";
                this.mMachineCPU = 4;
                this.mMachineProcFreq = 6.0f;
                this.mMachineFPU = false;
                this.mMachineRAM = 640;
                this.mMachineRAMWaitStates = 0;
                this.mMachineVideo = 1;
                this.mMachineSpeaker = true;
                this.mMachineAdLib = false;
                this.mMachineDSS = false;
                this.mBASICROM = true;
                this.mMachineVRAM = 256;
                this.mMouseType = 0;
                break;
            }
            case 2: {
                this.mBIOSType = "BIOSEVENODD";
                this.mBIOSPath = new String("bios/BIOS_5162_21APR86_U34_78X7460_27256.BIN");
                this.mBIOSPath2 = new String("bios/BIOS_5162_21APR86_U35_78X7461_27256.BIN");
                this.mMachineCPU = 4;
                this.mMachineProcFreq = 12.0f;
                this.mMachineFPU = false;
                this.mMachineRAM = 2048;
                this.mMachineRAMWaitStates = 1;
                this.mMachineVideo = 1;
                this.mMachineSpeaker = true;
                this.mMachineAdLib = false;
                this.mMachineDSS = false;
                this.mBASICROM = true;
                this.mMachineVRAM = 256;
                this.mMouseType = 0;
                break;
            }
            case 4: {
                this.mBIOSType = "BIOSEVENODD";
                this.mBIOSPath = new String("bios/BIOS_5170_10JAN84_U27_6181028_27256_6MHZ.BIN");
                this.mBIOSPath2 = new String("bios/BIOS_5170_10JAN84_U47_6181029_27256_6MHZ.BIN");
                this.mMachineCPU = 4;
                this.mMachineProcFreq = 6.0f;
                this.mMachineFPU = false;
                this.mMachineRAM = 640;
                this.mMachineRAMWaitStates = 1;
                this.mMachineVideo = 1;
                this.mMachineSpeaker = true;
                this.mMachineAdLib = false;
                this.mMachineDSS = false;
                this.mBASICROM = true;
                this.mMachineVRAM = 256;
                this.mMouseType = 0;
            }
        }
    }

    public void setVideo(int n, int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                if (n == 1) {
                    this.mVideoBIOS = new String("");
                    break;
                }
                this.mVideoBIOS2 = new String("");
                break;
            }
            case 3: {
                if (n == 1) {
                    this.mVideoBIOS = new String("bios/ibm_6277356_ega_card_u44_27128.bin");
                    break;
                }
                this.mVideoBIOS2 = new String("bios/ibm_6277356_ega_card_u44_27128.bin");
            }
        }
    }

    public String[] getSupportedCPU(int n) {
        String[] stringArray = null;
        switch (n) {
            case 5: {
                stringArray = new String[]{new String("8088")};
                break;
            }
            case 0: {
                stringArray = new String[]{new String("8086"), new String("8088"), new String("80186"), new String("80188")};
                break;
            }
            case 1: {
                stringArray = new String[]{new String("8088")};
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                stringArray = new String[]{new String("80286")};
            }
        }
        return stringArray;
    }

    public String getClassName() {
        switch (this.mMachineClass) {
            case 0: 
            case 1: {
                return new String("XT");
            }
            case 2: 
            case 3: 
            case 4: {
                return new String("AT");
            }
            case 5: {
                return new String("PCJr");
            }
        }
        return new String("Unknown");
    }

    public String getCPUName() {
        switch (this.mMachineCPU) {
            case 0: {
                return new String("8086");
            }
            case 1: {
                return new String("8088");
            }
            case 2: {
                return new String("80186");
            }
            case 3: {
                return new String("80188");
            }
            case 4: {
                return new String("80286");
            }
        }
        return new String("Unknown");
    }

    public String getVideoName(int n) {
        if (n == 1) {
            switch (this.mMachineVideo) {
                case 0: {
                    return new String("MDA");
                }
                case 2: {
                    return new String("HERCULES");
                }
                case 1: {
                    return new String("CGA");
                }
                case 3: {
                    return new String("EGA");
                }
            }
        } else {
            switch (this.mMachineVideo2) {
                case 4: {
                    return new String("None");
                }
                case 0: {
                    return new String("MDA");
                }
                case 2: {
                    return new String("HERCULES");
                }
                case 1: {
                    return new String("CGA");
                }
                case 3: {
                    return new String("EGA");
                }
            }
        }
        return new String("Unknown");
    }

    public String getRenderScalerName() {
        switch (this.mRenderScaler) {
            case 0: {
                return new String("Normal2X");
            }
            case 1: {
                return new String("Scale2X");
            }
            case 2: {
                return new String("Scale3X");
            }
        }
        return new String("Unknown");
    }

    public String getRenderFilterName() {
        switch (this.mRenderFilter) {
            case 0: {
                return new String("Passthrough");
            }
            case 1: {
                return new String("BW");
            }
            case 2: {
                return new String("Green");
            }
            case 3: {
                return new String("Amber");
            }
        }
        return new String("Unknown");
    }

    public String getTimingModelName() {
        switch (this.mMachineTimingModel) {
            case 0: {
                return new String("CycleExact");
            }
        }
        return new String("Unknown");
    }

    public String getMouseName() {
        switch (this.mMouseType) {
            case 1: {
                return new String("COM1");
            }
        }
        return new String("None");
    }

    public void saveToFile() {
        try {
            File file = new File(this.mName);
            file.createNewFile();
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("; " + this.mDescription + "\n");
            fileWriter.write("Class=" + this.getClassName() + "\n");
            fileWriter.write("Processor=" + this.getCPUName() + "\n");
            fileWriter.write("TimingModel=" + this.getTimingModelName() + "\n");
            fileWriter.write("Frequency=" + Float.toString(this.mMachineProcFreq) + "\n");
            fileWriter.write("FPU=" + (this.mMachineFPU ? "8087" : "None") + "\n");
            fileWriter.write("Memory=" + Integer.toString(this.mMachineRAM) + "\n");
            fileWriter.write("RAMWaitStates=" + Integer.toString(this.mMachineRAMWaitStates) + "\n");
            fileWriter.write("Video=" + this.getVideoName(1) + "\n");
            if (this.mMachineVideo == 3) {
                fileWriter.write("VideoBIOSReversed=bios/ibm_6277356_ega_card_u44_27128.bin\n");
            }
            if (this.mMachineVideo2 != 4) {
                fileWriter.write("Video2=" + this.getVideoName(2) + "\n");
                if (this.mMachineVideo2 == 3) {
                    fileWriter.write("VideoBIOSReversed2=bios/ibm_6277356_ega_card_u44_27128.bin\n");
                }
            }
            if (this.mBIOSType.equals("BIOS")) {
                fileWriter.write(this.mBIOSType + "=" + this.mBIOSPath + "\n");
            } else {
                fileWriter.write(this.mBIOSType + "=" + this.mBIOSPath + "," + this.mBIOSPath2 + "\n");
            }
            fileWriter.write("FloppyDriveA=" + this.mFDD0 + "\n");
            fileWriter.write("FloppyDriveB=" + this.mFDD1 + "\n");
            fileWriter.write("HDD=" + this.mHDD0 + "\n");
            fileWriter.write("HDD1=" + this.mHDD1 + "\n");
            if (this.mBASICPath != "" && this.mBASICROM) {
                fileWriter.write("BASIC=" + this.mBASICPath + "\n");
            }
            fileWriter.write("Mouse=" + this.getMouseName() + "\n");
            if (this.mMachineSpeaker || this.mMachineAdLib || this.mMachineDSS) {
                fileWriter.write("Sound=" + (this.mMachineSpeaker ? "Speaker" : "") + "\n");
            }
            fileWriter.write("Filter=" + this.getRenderFilterName() + "\n");
            fileWriter.write("Scaler=" + this.getRenderScalerName() + "\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Error saving file.");
        }
    }

    public void loadFromFile(String string) {
        this.mMachineSpeaker = false;
        try {
            File file = new File(string);
            System.out.println(string);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                String string3 = "=";
                String[] stringArray = string2.split(string3);
                if (!stringArray[0].startsWith(";") && string2.indexOf("=") != -1 && !stringArray[0].equals("Class")) {
                    if (stringArray[0].equals("Processor")) {
                        if (stringArray[1].equals("8088")) {
                            this.mMachineCPU = 1;
                        } else if (stringArray[1].equals("8086")) {
                            this.mMachineCPU = 0;
                        } else if (stringArray[1].equals("80186")) {
                            this.mMachineCPU = 2;
                        } else if (stringArray[1].equals("80188")) {
                            this.mMachineCPU = 3;
                        }
                    } else if (stringArray[0].equals("Frequency")) {
                        this.mMachineProcFreq = Float.parseFloat(stringArray[1]);
                    } else if (!(stringArray[0].equals("TimingModel") || stringArray[0].equals("FPU") || stringArray[0].equals("Memory") || stringArray[0].equals("Video") || stringArray[0].equals("BIOS"))) {
                        if (stringArray[0].equals("FloppyDriveA")) {
                            this.mFDD0 = stringArray[1];
                        } else if (stringArray[0].equals("FloppyDriveB")) {
                            this.mFDD1 = stringArray[1];
                        } else if (stringArray[0].equals("HDD")) {
                            this.mHDD0 = stringArray[1];
                        } else if (stringArray[0].equals("HDD1")) {
                            this.mHDD1 = stringArray[1];
                        } else if (!stringArray[0].equals("BASIC")) {
                            if (stringArray[0].equals("Filter")) {
                                if (stringArray[1].equals("Passthrough")) {
                                    this.mRenderFilter = 0;
                                } else if (stringArray[1].equals("BW")) {
                                    this.mRenderFilter = 1;
                                } else if (stringArray[1].equals("Green")) {
                                    this.mRenderFilter = 2;
                                } else if (stringArray[1].equals("Amber")) {
                                    this.mRenderFilter = 3;
                                }
                            } else if (stringArray[0].equals("Scaler")) {
                                if (stringArray[1].equals("Normal2X")) {
                                    this.mRenderScaler = 0;
                                } else if (stringArray[1].equals("Scale2X")) {
                                    this.mRenderScaler = 1;
                                } else if (stringArray[1].equals("Scale3X")) {
                                    this.mRenderScaler = 2;
                                }
                            } else if (stringArray[0].equals("Sound")) {
                                if (stringArray[1].equals("Speaker")) {
                                    this.mMachineSpeaker = true;
                                }
                            } else {
                                System.out.println("Unknown setting: " + stringArray[0]);
                            }
                        }
                    }
                }
                string2 = bufferedReader.readLine();
            }
            fileReader.close();
        }
        catch (Exception exception) {
            System.out.println("Error opening file.");
        }
    }

    public class MachineMouseType {
        public static final int MouseNone = 0;
        public static final int MouseSerial = 1;
    }

    public class MachineRenderFilter {
        public static final int FilterPassthrough = 0;
        public static final int FilterBW = 1;
        public static final int FilterGreen = 2;
        public static final int FilterAmber = 3;
    }

    public class MachineRenderScaler {
        public static final int Normal2X = 0;
        public static final int Scale2X = 1;
        public static final int Scale3X = 2;
    }

    public class MachineTimingModel {
        public static final int CycleBased = 0;
    }

    public class MachineVideo {
        public static final int MDA = 0;
        public static final int CGA = 1;
        public static final int HERCULES = 2;
        public static final int EGA = 3;
        public static final int NONE = 4;
    }

    public class MachineCPU {
        public static final int Proc8086 = 0;
        public static final int Proc8088 = 1;
        public static final int Proc80186 = 2;
        public static final int Proc80188 = 3;
        public static final int Proc80286 = 4;
        public static final int ProcNumber = 5;
    }

    public class MachineClass {
        public static final int GenericXT = 0;
        public static final int IBMPCXT5160 = 1;
        public static final int GenericAT = 2;
        public static final int IBMPCXT5162 = 3;
        public static final int IBMPCAT5170 = 4;
        public static final int IBMPCJR = 5;
    }
}

