/*
 * Decompiled with CFR 0.152.
 */
package v9t9.launch;

import java.io.File;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;

public class JarUtils {
    public static JarFile getJarFile(URL jarUrl) {
        if (jarUrl.getProtocol().equals("file")) {
            try {
                File file = new File(jarUrl.toURI());
                if (file.isDirectory()) {
                    return null;
                }
                return new JarFile(file);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get JarFile from file: " + jarUrl, e);
            }
        }
        try {
            URLConnection conn = jarUrl.openConnection();
            JarURLConnection jarUrlConnection = (JarURLConnection)conn;
            JarFile jarFile = jarUrlConnection.getJarFile();
            if (jarFile == null) {
                jarFile = JarUtils.getJarFileByReflection(jarUrlConnection);
            }
            return jarFile;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to get JarFile from jarUrlConnection", t);
        }
    }

    private static JarFile getJarFileByReflection(JarURLConnection jarUrlConnection) throws Exception {
        Field jarFileField;
        Class<?> jnlpConnectionClass = Class.forName("com.sun.jnlp.JNLPCachedJarURLConnection");
        try {
            jarFileField = jnlpConnectionClass.getDeclaredField("jarFile");
        }
        catch (Throwable t) {
            jarFileField = jnlpConnectionClass.getDeclaredField("_jarFile");
        }
        jarUrlConnection.connect();
        jarFileField.setAccessible(true);
        return (JarFile)jarFileField.get(jarUrlConnection);
    }
}

