///////////////////////////////////////////////////////////////////////////
// JABAWAPE v0.8 by D. Finck (extended by Thomas Strathmann)             //
// Just Another Beginner's Attempt to Write A Phoenix Emulator           //
// --------------------------------------------------------------------- //
// File: graphics.h  -  contents: void DrawScreen()                      //
//                                void DrawCharA(int pos)                //
//                                void DrawCharB(int pos)                //
///////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////
// DrawScreen handles... drawing the screen //
//////////////////////////////////////////////
void DrawScreen() {
  int x,y,pos,temp;                           //declare the vars needed...
  int scroll = RAM[0x5800];                   //scroll row position
  if(skip--) return;                          //skip frames to speed up
  skip = frameskip;                           //reset skip counter
  for (pos=0;pos<832;pos++) {                 //for each byte in video
    if (DirtyCharA[pos]) {                    //if is is marked...
      DirtyCharA[pos]=0;                      //...unmark it...
      DrawCharA(pos);                         //...and draw to bitmap
    }
    if (DirtyCharB[pos]) {                    //also do the same for
      DirtyCharB[pos]=0;                      //the background plane
      DrawCharB(pos);                         //while we're at it
    }
  }
  temp=256-scroll;                            //split line
  set_clip(bm3,0,8,208,256);                  //dont show top 8 raster lines
  blit(bm2,bm3,0,scroll,0,0,208,temp);        //blit scrolling bg...
  blit(bm2,bm3,0,0,0,temp,208,scroll);        //...in two parts
  set_clip(bm3,0,0,208,256);                  //allow whole bitmap now
  masked_blit(bm1,bm3,0,0,0,0,208,256);       //blit foregrnd over bkgrnd

  blit(bm3,screen,0,0,76,4,208,256);          //finally to the screen
  return;
}

//////////////////////////////////////////////////////
// DrawCharA draws one character to buffer bitmap 1 //
//////////////////////////////////////////////////////
void DrawCharA(int pos) {
  int x = 25-(pos/32);                          //calculate x and
  int y = pos%32;                               //y coordinates of pos
  unsigned int cx,cy;                           //local char coords
  unsigned char chr,b1,b2,col,col2;             //other vars
  chr=RAM[0x04000+(25-x)*32+y];                 //char code from RAM
  col=4*(chr>>5);                               //calc "base" color index
  for (cx=0;cx<8;cx++) {                        //loop through columns
    b1=CharA[chr*8+cx];                         //byte from char ROMs
    b2=CharA[chr*8+cx+0x0800];                  //byte from char ROMs
    for (cy=0;cy<8;cy++) {                      //loop through each bit
      if((b1>>cy)&1 || (b2>>cy)&1) {            //check status of bits
        col2=col+2*((b1>>cy)&1);                //adjust color index
        col2+=(b2>>cy)&1;                       //accordingly
        bm1->line[(y*8)+cy][(x*8)+(7-cx)]=col2; //direct memory access
      }                                         //to the bitmap is
      else                                      //supposedly faster
        bm1->line[(y*8)+cy][(x*8)+(7-cx)]=0;    //else, draw color 0
    }                                           //so background will
  }                                             //show through
}

//////////////////////////////////////////////////////
// DrawCharB draws one character to buffer bitmap 2 //
//////////////////////////////////////////////////////
void DrawCharB(int pos) {
  int x = 25-(pos/32);                          //calculate x and
  int y = pos%32;                               //y coordinates
  unsigned int cx,cy;                           //local char coords
  unsigned int chr,b1,b2,col,col2;              //
  chr=RAM[0x04800+(25-x)*32+y];                 //char code from RAM
  col=4*(chr>>5)+32;                            //calc "base" color
  for (cx=0;cx<8;cx++) {                        //loop through columns
    b1=CharB[chr*8+cx];                         //bytes from char ROMs
    b2=CharB[chr*8+cx+0x0800];                  //other bitplane
    for (cy=0;cy<8;cy++) {                      //loop through each bit
        col2=col+2*((b1>>cy)&1);                //adjust color per
        col2+=(b2>>cy)&1;                       //bits from char ROMs
        bm2->line[(y*8)+cy][(x*8)+(7-cx)]=col2; //draw pixel on bitmap
    }                                           
  }
}
