///////////////////////////////////////////////////////////////////////////
// JABAWAPE v0.8 by D. Finck (extended by Thomas Strathmann)             //
// Just Another Beginner's Attempt to Write A Phoenix Emulator           //
// --------------------------------------------------------------------- //
// File: jabawape.c  -  contents: void main()                            //
///////////////////////////////////////////////////////////////////////////

///////////////////////Header Files///////////////////////
#include <stdio.h>                              //for most anything
#include "allegro.h"                            //for the Allegro library
DECLARE_GFX_DRIVER_LIST( GFX_DRIVER_MODEX )     //these help keep the .exe
DECLARE_COLOR_DEPTH_LIST( COLOR_DEPTH_8 )       //file size to a minimum
                                                //read about it in the
                                                //Allegro docs                                                
#include "z80\z80.h"                            //for the CPU emulator
#include "def.h"                                //global definitions
#include "graphics.h"                           //for the graphics
#include "sound.h"                              //for some prelimary sound
#include "memory.h"                             //things to do with memory
#include "pallete.h"                            //the two pallete definitions
#include "misc.h"                               //some other functions

//////////////////////////////////////////////////////////
//                      M A I N                         //
//////////////////////////////////////////////////////////
int main(int argc, char *argv[]) {
  reg R;                                      //declare Z80 Registers
  CmdLine(argc, argv);                        //get command line arguments
  clrscr();                                   //clear the screen
  printf("JABAWAPE v0.8 by Darren Finck and Thomas Strathmann\n\n");
  AllocateMem();                              //allocate memory   
  SetupPalletes();                            //self explanitory
  ReadROMs(Game);                             //go get the ROMs, we'll need 'em
  ResetZ80(&R);                               //initalize CPU
  StartMessage();                             //info to user
  allegro_init();                             //initalize Allegro
  install_keyboard();                         //Allegro's key handler
  set_gfx_mode(GFX_MODEX,360,270,0,0);        //set graphics mode
  set_pallete(pal1);                          //set the pallete
  clear(screen);                              //and clear the screen
  delay(500);                                 //wait half a sec
  Z80(R);                                     //let the emulation begin! (:
  set_gfx_mode(GFX_TEXT,80,25,0,0);           //back to text mode
  printf("Exiting Emulator...");              //now for the graceful exit
  outp( 0x61, 0 );                            //turn off any sound
  free(RAM);free(CharA);free(CharB);          //un-allocate memory
  return 0;                                   //let the emulation end. ):
                                              //(Allegro cleans up after
                                              //itself upon exit)
}

