///////////////////////////////////////////////////////////////////////////
// JABAWAPE v0.8 by D. Finck (extended by Thomas Strathmann)             //
// Just Another Beginner's Attempt to Write A Phoenix Emulator           //
// --------------------------------------------------------------------- //
// File: memory.h  -  contents: void AllocateMem()                       //
//                              void ResetMachine(reg R)                 //
//                              void M_WRMEM(word A, byte W)             //
//                              byte M_RDMEM(word A)                     //
///////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////
// AllocateMem allocates memory ROM data and video buffers //
/////////////////////////////////////////////////////////////
void AllocateMem() {
  word count;                                 //we'll need a variable
  printf("Allocating Memory\n");              //be polite
  RAM = malloc(0x8000);                       //allocate memory for "RAM"
  CharA = malloc(0x1000);                     //and for gfx characters
  CharB = malloc(0x1000);                     //for more gfx data
  if (!RAM || !CharA || !CharB) {             //if those didn't work
    printf("Error allocating memory\n");      //mention the problem
    exit(1);                                  //and get outta here
  }
  for (count=0x0000;count<0x8000;count++)     
    RAM[count]=0;                             //fill memory with 0's
  bm1=create_bitmap(208,256);                 //create a bitmaps
  bm2=create_bitmap(208,256);                 //for 2 gfx planes and
  bm3=create_bitmap(208,256);                 //final image
  clear(bm1); clear(bm2); clear(bm3);         //clear them all
  return;
}

///////////////////////////////////////////////
// ResetMachine resets the emulator (F3 key) //
///////////////////////////////////////////////
void ResetMachine(reg R)
{
  word count;
  for (count=0x4000;count<0x8000;count++)     
    RAM[count]=0;                                    //delete contents of RAM
  clear(bm1); clear(bm2); clear(bm3); clear(screen); //delete all graphics
  ResetZ80(&R);                                      //reset processor
}

///////////////////////////////////////////////////////////////////
// M_WRMEM handles Writing to "Memory", as required by the "CPU" //
///////////////////////////////////////////////////////////////////
void M_WRMEM(word A, byte V) {
  if (A<0x4000||A>=0x8000) return;            //don't write on ROMs...
  if (A>=0x4000 && A<0x4340 && RAM[A]!=V)     //writing to video A?
    DirtyCharA[A-0x4000]=1;                   //keep track of changes
  if (A>=0x4800 && A<0x4B40 && RAM[A]!=V)     //for both planes
    DirtyCharB[A-0x4800]=1;                   //of video memory
  if (A>=0x5800 && A<0x5C00) RAM[0x5800]=V;   //mirror scroll register
  if (A>=0x5000 && A<0x5400 && (RAM[0x5000]&2)!=(V&2)) { //if changing video reg  
    if (V&2) {                                //raised bit 1?
      vsync();                                //to prevent "snow"
      set_pallete(pal2);                      //select alternate pallete
    }
    else {                                    //must've unset bit 1...
      vsync();                                //to prevent snow
      set_pallete(pal1);                      //select primary pallete
    }
    RAM[0x5000]=V;                            //store byte at "base" addr
  }
  RAM[A]=V;                                   //OK--put byte in memory
  if (!soundon) return;                       //unless sound is on get outta here
  if (A>=0x6000 && A<0x6400)                  //writing to sound reg A?
    MakeSoundA(V);                            //make some beeps
  if (A>=0x6800 && A<0x6C00)                  //sound register B?
    MakeSoundB(V);                            //make some noise
  if (RAM[0x6000]&0x30 || RAM[0x6800]&0x30)   //if sound is on
    return;                                   //don't cut it off
  outp( 0x61, 0 );                            //otherwise turn off any sound
  return;               
}                                             //I realise this function is
                                              //most likely very poorly
                                              //programmed, but hey--it works

////////////////////////////////////////////////////////////////////
// M_RDMEM handles Fetching Data Stored in "Memory" for the "CPU" //
////////////////////////////////////////////////////////////////////
byte M_RDMEM(word A) {
  if (A>=0x7800 && A<0x7C00) {                //reading dipswitches?
    if(RAM[0x7800]&0x80) {                    //if sync bit of switch high
      RAM[0x7800]&=~0x80;                     //clear the bit
      return (RAM[0x7800]|0x80);              //return value with bit 7 high
    }                           //I don't completely understand the above
                                //but I works... I think Phoenix is very
                                //unusual in this respect, anyway
    else return RAM[0x7800];                  //return value from memory
  }
  else if (A>=0x7000 && A<0x7400) {           //if reading input area...
    UserInput();                              //..get some input...
    return RAM[0x7000];                       //...and return this byte
  }                                           //(this achieves "mirroring")
  return RAM[A];                              //isn't that simple?
}

/////////////////////////////////////////////
// ReadROMs reads the game ROMs from files //
/////////////////////////////////////////////
void ReadROMs(int game) {
  printf("Reading ROMs...\n");

  switch(game) {
    case 1:
            LoadRom("roms/ic45", RAM, 0x0000, 0x800);
            LoadRom("roms/ic46", RAM, 0x0800, 0x800);  
            LoadRom("roms/ic47", RAM, 0x1000, 0x800);
            LoadRom("roms/ic48", RAM, 0x1800, 0x800);  
            LoadRom("roms/ic49", RAM, 0x2000, 0x800);
            LoadRom("roms/ic50", RAM, 0x2800, 0x800);  
            LoadRom("roms/ic51", RAM, 0x3000, 0x800);
            LoadRom("roms/ic52", RAM, 0x3800, 0x800);
            LoadRom("roms/ic39", CharA, 0x0000, 0x800);
            LoadRom("roms/ic40", CharA, 0x0800, 0x800);  
            LoadRom("roms/ic23", CharB, 0x0000, 0x800);
            LoadRom("roms/ic24", CharB, 0x0800, 0x800);
  }
  return;
}

//////////////////////////////////////////////////////////
// LoadRom loads one ROM into the given memory location //
//////////////////////////////////////////////////////////
void LoadRom(char *name, char *loc, word pos, word len)
{
  fp=fopen(name, "rb");
  if(!fp) {
    printf("Error loading ROM: %s\n",name);
    printf("Please provide the above mentioned file to run the emulator.\n");
    exit(1);
  }
  fread(&loc[pos], len, 1, fp);
  fclose(fp);
  return;
}
