///////////////////////////////////////////////////////////////////////////
// JABAWAPE v0.8 by D. Finck (extended by Thomas Strathmann)             //
// Just Another Beginner's Attempt to Write A Phoenix Emulator           //
// --------------------------------------------------------------------- //
// File: mis.h  -  contents: void StartMessage()                         //
//                           void UserInput()                            //
//                           void CmdLine(int argc, char **argv)         //
//                           some other non-important, empty functions   //   
///////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
// StartMessage prints a message to the user upon startup //
////////////////////////////////////////////////////////////
void StartMessage() {
  printf("\nKeys:\n");
  printf("   LEFT    = left\n");
  printf("   RIGHT   = right\n");
  printf(" LFT CTRL  = shield\n");
  printf(" LFT ALT   = fire\n");
  printf("   F 3     = reset emulator\n");
  printf("    P      = pause\n");
  printf("    S      = sound\n");
  printf("    F      = frameskip\n");
  printf("    H      = hiscore save\n");
  printf("    L      = hiscore load\n");
  printf("    D      = dump ram\n");
  /*printf("    R      = restore ram\n");*/
  printf("    B      = capture screen\n");
  printf("Center Joystick and press a KEY\n");//prompt user...
  getch();                                    //...and wait for a key
  joy_type=JOY_TYPE_4BUTTON;                  //should work for most joys
  initialise_joystick();                      //Allegro function
  return;
}

//////////////////////////////////////////////////////
// UserInput retrieves and acts upon keyboard input //
//////////////////////////////////////////////////////
void UserInput() {
  poll_joystick();                            //get joystick stuff
  RAM[0x7000]=0xFF;                           //clear input (all bits high)
  if(key[KEY_ESC]) CPURunning=0;              //stop everything          
  if(key[KEY_3]) RAM[0x7000]&=~0x01;          //insert coin      (bit 0 low)
  if(key[KEY_1]) RAM[0x7000]&=~0x02;          //press 1PL button (bit 1 low)
  if(key[KEY_2]) RAM[0x7000]&=~0x04;          //press 2PL button (bit 2 low)
  if(key[KEY_ALT]     || joy_b1)
    RAM[0x7000]&=~0x10;                       //press FIRE button(bit 4 low)
  if(key[KEY_RIGHT]   || joy_right || joy_x> 50)
    RAM[0x7000]&=~0x20;                       //joystick right   (bit 5 low)
  if(key[KEY_LEFT]    || joy_left  || joy_x<(-50))
    RAM[0x7000]&=~0x40;                       //joystick left    (bit 6 low)
  if(key[KEY_CONTROL] || joy_b2)
    RAM[0x7000]&=~0x80;                       //shield button    (bit 7 low)
  if(key[KEY_S]) {                            //if S is pressed...
    if(soundon) {                             //if sound is on...
      soundon=0;                              //...turn it off
      outp( 0x61, 0 );                        //shut up!
      textout_centre(screen,font," SOUND OFF ",SCREEN_W/2,SCREEN_H-10,2);
    }
    else {                                    //if it's off...
      soundon=1;                              //...turn it on
      textout_centre(screen,font," SOUND ON  ",SCREEN_W/2,SCREEN_H-10,2);
    }
    clear_keybuf();                           //clear keyboard buffer
  }
  if(key[KEY_F]) {                            //if F is pressed...
    frameskip++;                              //increment frameskip
    if(frameskip>fskipmax) frameskip=0;       //wraparound at max
    sprintf(msg,"FRAMESKIP=%d",frameskip);    //display on screen
    textout_centre(screen,font,msg,SCREEN_W/2,SCREEN_H-10,2);
    clear_keybuf();                           //clear keyboard buffer
  }
  if(key[KEY_P]) {                            //if P is pressed...
    outp( 0x61, 0 );                          //silence, please
    textout_centre(screen, font, "   PAUSED   ",SCREEN_W/2,SCREEN_H-10,2);
    clear_keybuf();
    readkey();                                //wait for keypress
    textout_centre(screen, font, "   PAUSED   ",SCREEN_W/2,SCREEN_H-10,0);
    clear_keybuf();
  }
  if(key[KEY_H]) {                      //saves the current hiscore to
    byte count=0;                       //the file "HISCORE.DAT"
    fp=fopen("hiscore.dat","w");
    while(count!=0xC) {
      putc(RAM[0x4380+count],fp);
      count++;
    }
    fclose(fp);
  }
  if(key[KEY_L]) {                      //restores the saved hiscore from
    byte count=0;                       //file "HISCORE.DAT"
    fp=fopen("hiscore.dat","r");
    while(count!=0xC) {
      RAM[0x4380+count]=getc(fp);
      count++;
    }
    fclose(fp);
  }
  if(key[KEY_D]) {                      //dumps the RAM contents to the
    word count=0x4000;                  //file "RAM.BIN"
    fp=fopen("ram.bin","wb");
    while(count!=0x8000) {
      putc(RAM[count],fp);
      count++;
    }
    fclose(fp);
  }
 /*if(key[KEY_R]) {                     //restores the dumped RAM contents   
    word count=0x4000;                  //from "RAM.BIN"
    ResetMachine(R);
    fp=fopen("ram.bin","rb");
    while(count!=0x8000) {
      RAM[count]=getc(fp);
      count++;
    }
    fclose(fp);
    DrawScreen();
  }*/
  if(key[KEY_B]) {                      //saves a screenshot to "SCREEN.PCX"
    get_pallete(palc);
    bmc=create_sub_bitmap(screen,76,0,208,255);
    save_bitmap("screen.pcx", bmc, palc);
    destroy_bitmap(bmc);
  }
  if(key[KEY_F3]) {                     //resets the whole emulator
    ResetMachine(R);
  }
  return;
}

////////////////////////////////////////////////
// CmdLine checks for command line arguments  //
////////////////////////////////////////////////
void CmdLine(int argc, char **argv)       
{
  int i;
  char attr[50],val[50];
  char *p;

  if (argc < 2) {
    printf("\nUsage: JABAWAPE [Game]\n");
    printf("Use LIST for a list of supported games.\n");
    exit(1);   
  }
  if(!strcmp((char*)strlwr(argv[1]), "list")) {
    printf("JABAWAPE currently supports the following games\n");
    printf("Phoenix (Amstar)\n");
    exit(0);
  }
  if(!strcmp((char*)strlwr(argv[1]), "phoenix")) { Game=1; }
  else {
    printf("Unsopported game\n");
    printf("Use LIST for a list of supported games.\n");
    exit(1);
  }
}

///////////////////////////////////////////////////////////////////////////////
//The following "do-nothing" functions must exist to satisfy the Z80 emulator//
///////////////////////////////////////////////////////////////////////////////
byte DoIn(byte Port) {return(0);}
void DoOut(byte Port, byte value) {}
void Patch(reg *R) {}
word Interrupt(reg *R) {return(0);}

