static const unsigned short jis2uft16[][2] = {

/*    JIS,    UTF-16,          区-点  SJIS     */
	{ 0x2121, 0x3000, },	/* 01-01  8140  　 */
	{ 0x2122, 0x3001, },	/* 01-02  8141  、 */
	{ 0x2123, 0x3002, },	/* 01-03  8142  。 */
	{ 0x2124, 0xFF0C, },	/* 01-04  8143  ， */
	{ 0x2125, 0xFF0E, },	/* 01-05  8144  ． */
	{ 0x2126, 0x30FB, },	/* 01-06  8145  ・ */
	{ 0x2127, 0xFF1A, },	/* 01-07  8146  ： */
	{ 0x2128, 0xFF1B, },	/* 01-08  8147  ； */
	{ 0x2129, 0xFF1F, },	/* 01-09  8148  ？ */
	{ 0x212A, 0xFF01, },	/* 01-10  8149  ！ */
	{ 0x212B, 0x309B, },	/* 01-11  814A  ゛ */
	{ 0x212B, 0x3099, },	/* 01-11  814A  ゙ [結合文字] */
	{ 0x212C, 0x309C, },	/* 01-12  814B  ゜ */
	{ 0x212C, 0x309A, },	/* 01-12  814B  ゚ [結合文字] */
	{ 0x212D, 0x00B4, },	/* 01-13  814C  ´ */
	{ 0x212E, 0xFF40, },	/* 01-14  814D  ｀ */
	{ 0x212F, 0x00A8, },	/* 01-15  814E  ¨ */
	{ 0x2130, 0xFF3E, },	/* 01-16  814F  ＾ */
	{ 0x2131, 0xFFE3, },	/* 01-17  8150  ￣ */
	{ 0x2132, 0xFF3F, },	/* 01-18  8151  ＿ */
	{ 0x2133, 0x30FD, },	/* 01-19  8152  ヽ */
	{ 0x2134, 0x30FE, },	/* 01-20  8153  ヾ */
	{ 0x2135, 0x309D, },	/* 01-21  8154  ゝ */
	{ 0x2136, 0x309E, },	/* 01-22  8155  ゞ */
	{ 0x2137, 0x3003, },	/* 01-23  8156  〃 */
	{ 0x2138, 0x4EDD, },	/* 01-24  8157  仝 */
	{ 0x2139, 0x3005, },	/* 01-25  8158  々 */
	{ 0x213A, 0x3006, },	/* 01-26  8159  〆 */
	{ 0x213B, 0x3007, },	/* 01-27  815A  〇 */
	{ 0x213C, 0x30FC, },	/* 01-28  815B  ー */
	{ 0x213D, 0x2015, },	/* 01-29  815C  ― [HORIZONTAL BAR] */
	{ 0x213E, 0x2010, },	/* 01-30  815D  ‐ */
	{ 0x213F, 0xFF0F, },	/* 01-31  815E  ／ */
	{ 0x2140, 0xFF3C, },	/* 01-32  815F  ＼ */
	{ 0x2141, 0x301C, },	/* 01-33  8160  ～ [WAVE DASH] */
	{ 0x2142, 0x2016, },	/* 01-34  8161  ‖ [DOUBLE VERTICAL LINE] */
	{ 0x2143, 0xFF5C, },	/* 01-35  8162  ｜ */
	{ 0x2144, 0x2026, },	/* 01-36  8163  … */
	{ 0x2145, 0x2025, },	/* 01-37  8164  ‥ */
	{ 0x2146, 0x2018, },	/* 01-38  8165  ‘ */
	{ 0x2147, 0x2019, },	/* 01-39  8166  ’ */
	{ 0x2148, 0x201C, },	/* 01-40  8167  “ */
	{ 0x2149, 0x201D, },	/* 01-41  8168  ” */
	{ 0x214A, 0xFF08, },	/* 01-42  8169  （ */
	{ 0x214B, 0xFF09, },	/* 01-43  816A  ） */
	{ 0x214C, 0x3014, },	/* 01-44  816B  〔 */
	{ 0x214D, 0x3015, },	/* 01-45  816C  〕 */
	{ 0x214E, 0xFF3B, },	/* 01-46  816D  ［ */
	{ 0x214F, 0xFF3D, },	/* 01-47  816E  ］ */
	{ 0x2150, 0xFF5B, },	/* 01-48  816F  ｛ */
	{ 0x2151, 0xFF5D, },	/* 01-49  8170  ｝ */
	{ 0x2152, 0x3008, },	/* 01-50  8171  〈 */
	{ 0x2153, 0x3009, },	/* 01-51  8172  〉 */
	{ 0x2154, 0x300A, },	/* 01-52  8173  《 */
	{ 0x2155, 0x300B, },	/* 01-53  8174  》 */
	{ 0x2156, 0x300C, },	/* 01-54  8175  「 */
	{ 0x2157, 0x300D, },	/* 01-55  8176  」 */
	{ 0x2158, 0x300E, },	/* 01-56  8177  『 */
	{ 0x2159, 0x300F, },	/* 01-57  8178  』 */
	{ 0x215A, 0x3010, },	/* 01-58  8179  【 */
	{ 0x215B, 0x3011, },	/* 01-59  817A  】 */
	{ 0x215C, 0xFF0B, },	/* 01-60  817B  ＋ */
	{ 0x215D, 0x2212, },	/* 01-61  817C  − [MINUS SIGN] */
	{ 0x215E, 0x00B1, },	/* 01-62  817D  ± */
	{ 0x215F, 0x00D7, },	/* 01-63  817E  × */
	{ 0x2160, 0x00F7, },	/* 01-64  8180  ÷ */
	{ 0x2161, 0xFF1D, },	/* 01-65  8181  ＝ */
	{ 0x2162, 0x2260, },	/* 01-66  8182  ≠ */
	{ 0x2163, 0xFF1C, },	/* 01-67  8183  ＜ */
	{ 0x2164, 0xFF1E, },	/* 01-68  8184  ＞ */
	{ 0x2165, 0x2266, },	/* 01-69  8185  ≦ */
	{ 0x2166, 0x2267, },	/* 01-70  8186  ≧ */
	{ 0x2167, 0x221E, },	/* 01-71  8187  ∞ */
	{ 0x2168, 0x2234, },	/* 01-72  8188  ∴ */
	{ 0x2169, 0x2642, },	/* 01-73  8189  ♂ */
	{ 0x216A, 0x2640, },	/* 01-74  818A  ♀ */
	{ 0x216B, 0x00B0, },	/* 01-75  818B  ° */
	{ 0x216C, 0x2032, },	/* 01-76  818C  ′ */
	{ 0x216D, 0x2033, },	/* 01-77  818D  ″ */
	{ 0x216E, 0x2103, },	/* 01-78  818E  ℃ */
	{ 0x216F, 0xFFE5, },	/* 01-79  818F  ￥ */
	{ 0x2170, 0xFF04, },	/* 01-80  8190  ＄ */
	{ 0x2171, 0x00A2, },	/* 01-81  8191  ¢ [CENT SIGN] */
	{ 0x2171, 0xFFE0, },	/* 01-81  8191  ￠ [FULLWIDTH CENT SIGN] */
	{ 0x2172, 0x00A3, },	/* 01-82  8192  £ [POUND SIGN] */
	{ 0x2172, 0xFFE1, },	/* 01-82  8192  ￡ [FULLWIDTH POUND SIGN] */
	{ 0x2173, 0xFF05, },	/* 01-83  8193  ％ */
	{ 0x2174, 0xFF03, },	/* 01-84  8194  ＃ */
	{ 0x2175, 0xFF06, },	/* 01-85  8195  ＆ */
	{ 0x2176, 0xFF0A, },	/* 01-86  8196  ＊ */
	{ 0x2177, 0xFF20, },	/* 01-87  8197  ＠ */
	{ 0x2178, 0x00A7, },	/* 01-88  8198  § */
	{ 0x2179, 0x2606, },	/* 01-89  8199  ☆ */
	{ 0x217A, 0x2605, },	/* 01-90  819A  ★ */
	{ 0x217B, 0x25CB, },	/* 01-91  819B  ○ */
	{ 0x217C, 0x25CF, },	/* 01-92  819C  ● */
	{ 0x217D, 0x25CE, },	/* 01-93  819D  ◎ */
	{ 0x217E, 0x25C7, },	/* 01-94  819E  ◇ */
	{ 0x2221, 0x25C6, },	/* 02-01  819F  ◆ */
	{ 0x2222, 0x25A1, },	/* 02-02  81A0  □ */
	{ 0x2223, 0x25A0, },	/* 02-03  81A1  ■ */
	{ 0x2224, 0x25B3, },	/* 02-04  81A2  △ */
	{ 0x2225, 0x25B2, },	/* 02-05  81A3  ▲ */
	{ 0x2226, 0x25BD, },	/* 02-06  81A4  ▽ */
	{ 0x2227, 0x25BC, },	/* 02-07  81A5  ▼ */
	{ 0x2228, 0x203B, },	/* 02-08  81A6  ※ */
	{ 0x2229, 0x3012, },	/* 02-09  81A7  〒 */
	{ 0x222A, 0x2192, },	/* 02-10  81A8  → */
	{ 0x222B, 0x2190, },	/* 02-11  81A9  ← */
	{ 0x222C, 0x2191, },	/* 02-12  81AA  ↑ */
	{ 0x222D, 0x2193, },	/* 02-13  81AB  ↓ */
	{ 0x222E, 0x3013, },	/* 02-14  81AC  〓 */
	{ 0x223A, 0x2208, },	/* 02-26  81B8  ∈ */
	{ 0x223B, 0x220B, },	/* 02-27  81B9  ∋ */
	{ 0x223C, 0x2286, },	/* 02-28  81BA  ⊆ */
	{ 0x223D, 0x2287, },	/* 02-29  81BB  ⊇ */
	{ 0x223E, 0x2282, },	/* 02-30  81BC  ⊂ */
	{ 0x223F, 0x2283, },	/* 02-31  81BD  ⊃ */
	{ 0x2240, 0x222A, },	/* 02-32  81BE  ∪ */
	{ 0x2241, 0x2229, },	/* 02-33  81BF  ∩ */
	{ 0x224A, 0x2227, },	/* 02-42  81C8  ∧ */
	{ 0x224B, 0x2228, },	/* 02-43  81C9  ∨ */
	{ 0x224C, 0x00AC, },	/* 02-44  81CA  ¬ [NOT SIGN] */
	{ 0x224C, 0xFFE2, },	/* 02-44  81CA  ￢ [FULLWIDTH NOT SIGN] */
	{ 0x224D, 0x21D2, },	/* 02-45  81CB  ⇒ */
	{ 0x224E, 0x21D4, },	/* 02-46  81CC  ⇔ */
	{ 0x224F, 0x2200, },	/* 02-47  81CD  ∀ */
	{ 0x2250, 0x2203, },	/* 02-48  81CE  ∃ */
	{ 0x225C, 0x2220, },	/* 02-60  81DA  ∠ */
	{ 0x225D, 0x22A5, },	/* 02-61  81DB  ⊥ */
	{ 0x225E, 0x2312, },	/* 02-62  81DC  ⌒ */
	{ 0x225F, 0x2202, },	/* 02-63  81DD  ∂ */
	{ 0x2260, 0x2207, },	/* 02-64  81DE  ∇ */
	{ 0x2261, 0x2261, },	/* 02-65  81DF  ≡ */
	{ 0x2262, 0x2252, },	/* 02-66  81E0  ≒ */
	{ 0x2263, 0x226A, },	/* 02-67  81E1  ≪ */
	{ 0x2264, 0x226B, },	/* 02-68  81E2  ≫ */
	{ 0x2265, 0x221A, },	/* 02-69  81E3  √ */
	{ 0x2266, 0x223D, },	/* 02-70  81E4  ∽ */
	{ 0x2267, 0x221D, },	/* 02-71  81E5  ∝ */
	{ 0x2268, 0x2235, },	/* 02-72  81E6  ∵ */
	{ 0x2269, 0x222B, },	/* 02-73  81E7  ∫ */
	{ 0x226A, 0x222C, },	/* 02-74  81E8  ∬ */
	{ 0x2272, 0x212B, },	/* 02-82  81F0  Å */
	{ 0x2273, 0x2030, },	/* 02-83  81F1  ‰ */
	{ 0x2274, 0x266F, },	/* 02-84  81F2  ♯ */
	{ 0x2275, 0x266D, },	/* 02-85  81F3  ♭ */
	{ 0x2276, 0x266A, },	/* 02-86  81F4  ♪ */
	{ 0x2277, 0x2020, },	/* 02-87  81F5  † */
	{ 0x2278, 0x2021, },	/* 02-88  81F6  ‡ */
	{ 0x2279, 0x00B6, },	/* 02-89  81F7  ¶ */
	{ 0x227E, 0x25EF, },	/* 02-94  81FC  ◯ */
	{ 0x2330, 0xFF10, },	/* 03-16  824F  ０ */
	{ 0x2331, 0xFF11, },	/* 03-17  8250  １ */
	{ 0x2332, 0xFF12, },	/* 03-18  8251  ２ */
	{ 0x2333, 0xFF13, },	/* 03-19  8252  ３ */
	{ 0x2334, 0xFF14, },	/* 03-20  8253  ４ */
	{ 0x2335, 0xFF15, },	/* 03-21  8254  ５ */
	{ 0x2336, 0xFF16, },	/* 03-22  8255  ６ */
	{ 0x2337, 0xFF17, },	/* 03-23  8256  ７ */
	{ 0x2338, 0xFF18, },	/* 03-24  8257  ８ */
	{ 0x2339, 0xFF19, },	/* 03-25  8258  ９ */
	{ 0x2341, 0xFF21, },	/* 03-33  8260  Ａ */
	{ 0x2342, 0xFF22, },	/* 03-34  8261  Ｂ */
	{ 0x2343, 0xFF23, },	/* 03-35  8262  Ｃ */
	{ 0x2344, 0xFF24, },	/* 03-36  8263  Ｄ */
	{ 0x2345, 0xFF25, },	/* 03-37  8264  Ｅ */
	{ 0x2346, 0xFF26, },	/* 03-38  8265  Ｆ */
	{ 0x2347, 0xFF27, },	/* 03-39  8266  Ｇ */
	{ 0x2348, 0xFF28, },	/* 03-40  8267  Ｈ */
	{ 0x2349, 0xFF29, },	/* 03-41  8268  Ｉ */
	{ 0x234A, 0xFF2A, },	/* 03-42  8269  Ｊ */
	{ 0x234B, 0xFF2B, },	/* 03-43  826A  Ｋ */
	{ 0x234C, 0xFF2C, },	/* 03-44  826B  Ｌ */
	{ 0x234D, 0xFF2D, },	/* 03-45  826C  Ｍ */
	{ 0x234E, 0xFF2E, },	/* 03-46  826D  Ｎ */
	{ 0x234F, 0xFF2F, },	/* 03-47  826E  Ｏ */
	{ 0x2350, 0xFF30, },	/* 03-48  826F  Ｐ */
	{ 0x2351, 0xFF31, },	/* 03-49  8270  Ｑ */
	{ 0x2352, 0xFF32, },	/* 03-50  8271  Ｒ */
	{ 0x2353, 0xFF33, },	/* 03-51  8272  Ｓ */
	{ 0x2354, 0xFF34, },	/* 03-52  8273  Ｔ */
	{ 0x2355, 0xFF35, },	/* 03-53  8274  Ｕ */
	{ 0x2356, 0xFF36, },	/* 03-54  8275  Ｖ */
	{ 0x2357, 0xFF37, },	/* 03-55  8276  Ｗ */
	{ 0x2358, 0xFF38, },	/* 03-56  8277  Ｘ */
	{ 0x2359, 0xFF39, },	/* 03-57  8278  Ｙ */
	{ 0x235A, 0xFF3A, },	/* 03-58  8279  Ｚ */
	{ 0x2361, 0xFF41, },	/* 03-65  8281  ａ */
	{ 0x2362, 0xFF42, },	/* 03-66  8282  ｂ */
	{ 0x2363, 0xFF43, },	/* 03-67  8283  ｃ */
	{ 0x2364, 0xFF44, },	/* 03-68  8284  ｄ */
	{ 0x2365, 0xFF45, },	/* 03-69  8285  ｅ */
	{ 0x2366, 0xFF46, },	/* 03-70  8286  ｆ */
	{ 0x2367, 0xFF47, },	/* 03-71  8287  ｇ */
	{ 0x2368, 0xFF48, },	/* 03-72  8288  ｈ */
	{ 0x2369, 0xFF49, },	/* 03-73  8289  ｉ */
	{ 0x236A, 0xFF4A, },	/* 03-74  828A  ｊ */
	{ 0x236B, 0xFF4B, },	/* 03-75  828B  ｋ */
	{ 0x236C, 0xFF4C, },	/* 03-76  828C  ｌ */
	{ 0x236D, 0xFF4D, },	/* 03-77  828D  ｍ */
	{ 0x236E, 0xFF4E, },	/* 03-78  828E  ｎ */
	{ 0x236F, 0xFF4F, },	/* 03-79  828F  ｏ */
	{ 0x2370, 0xFF50, },	/* 03-80  8290  ｐ */
	{ 0x2371, 0xFF51, },	/* 03-81  8291  ｑ */
	{ 0x2372, 0xFF52, },	/* 03-82  8292  ｒ */
	{ 0x2373, 0xFF53, },	/* 03-83  8293  ｓ */
	{ 0x2374, 0xFF54, },	/* 03-84  8294  ｔ */
	{ 0x2375, 0xFF55, },	/* 03-85  8295  ｕ */
	{ 0x2376, 0xFF56, },	/* 03-86  8296  ｖ */
	{ 0x2377, 0xFF57, },	/* 03-87  8297  ｗ */
	{ 0x2378, 0xFF58, },	/* 03-88  8298  ｘ */
	{ 0x2379, 0xFF59, },	/* 03-89  8299  ｙ */
	{ 0x237A, 0xFF5A, },	/* 03-90  829A  ｚ */
	{ 0x2421, 0x3041, },	/* 04-01  829F  ぁ */
	{ 0x2422, 0x3042, },	/* 04-02  82A0  あ */
	{ 0x2423, 0x3043, },	/* 04-03  82A1  ぃ */
	{ 0x2424, 0x3044, },	/* 04-04  82A2  い */
	{ 0x2425, 0x3045, },	/* 04-05  82A3  ぅ */
	{ 0x2426, 0x3046, },	/* 04-06  82A4  う */
	{ 0x2427, 0x3047, },	/* 04-07  82A5  ぇ */
	{ 0x2428, 0x3048, },	/* 04-08  82A6  え */
	{ 0x2429, 0x3049, },	/* 04-09  82A7  ぉ */
	{ 0x242A, 0x304A, },	/* 04-10  82A8  お */
	{ 0x242B, 0x304B, },	/* 04-11  82A9  か */
	{ 0x242C, 0x304C, },	/* 04-12  82AA  が */
	{ 0x242D, 0x304D, },	/* 04-13  82AB  き */
	{ 0x242E, 0x304E, },	/* 04-14  82AC  ぎ */
	{ 0x242F, 0x304F, },	/* 04-15  82AD  く */
	{ 0x2430, 0x3050, },	/* 04-16  82AE  ぐ */
	{ 0x2431, 0x3051, },	/* 04-17  82AF  け */
	{ 0x2432, 0x3052, },	/* 04-18  82B0  げ */
	{ 0x2433, 0x3053, },	/* 04-19  82B1  こ */
	{ 0x2434, 0x3054, },	/* 04-20  82B2  ご */
	{ 0x2435, 0x3055, },	/* 04-21  82B3  さ */
	{ 0x2436, 0x3056, },	/* 04-22  82B4  ざ */
	{ 0x2437, 0x3057, },	/* 04-23  82B5  し */
	{ 0x2438, 0x3058, },	/* 04-24  82B6  じ */
	{ 0x2439, 0x3059, },	/* 04-25  82B7  す */
	{ 0x243A, 0x305A, },	/* 04-26  82B8  ず */
	{ 0x243B, 0x305B, },	/* 04-27  82B9  せ */
	{ 0x243C, 0x305C, },	/* 04-28  82BA  ぜ */
	{ 0x243D, 0x305D, },	/* 04-29  82BB  そ */
	{ 0x243E, 0x305E, },	/* 04-30  82BC  ぞ */
	{ 0x243F, 0x305F, },	/* 04-31  82BD  た */
	{ 0x2440, 0x3060, },	/* 04-32  82BE  だ */
	{ 0x2441, 0x3061, },	/* 04-33  82BF  ち */
	{ 0x2442, 0x3062, },	/* 04-34  82C0  ぢ */
	{ 0x2443, 0x3063, },	/* 04-35  82C1  っ */
	{ 0x2444, 0x3064, },	/* 04-36  82C2  つ */
	{ 0x2445, 0x3065, },	/* 04-37  82C3  づ */
	{ 0x2446, 0x3066, },	/* 04-38  82C4  て */
	{ 0x2447, 0x3067, },	/* 04-39  82C5  で */
	{ 0x2448, 0x3068, },	/* 04-40  82C6  と */
	{ 0x2449, 0x3069, },	/* 04-41  82C7  ど */
	{ 0x244A, 0x306A, },	/* 04-42  82C8  な */
	{ 0x244B, 0x306B, },	/* 04-43  82C9  に */
	{ 0x244C, 0x306C, },	/* 04-44  82CA  ぬ */
	{ 0x244D, 0x306D, },	/* 04-45  82CB  ね */
	{ 0x244E, 0x306E, },	/* 04-46  82CC  の */
	{ 0x244F, 0x306F, },	/* 04-47  82CD  は */
	{ 0x2450, 0x3070, },	/* 04-48  82CE  ば */
	{ 0x2451, 0x3071, },	/* 04-49  82CF  ぱ */
	{ 0x2452, 0x3072, },	/* 04-50  82D0  ひ */
	{ 0x2453, 0x3073, },	/* 04-51  82D1  び */
	{ 0x2454, 0x3074, },	/* 04-52  82D2  ぴ */
	{ 0x2455, 0x3075, },	/* 04-53  82D3  ふ */
	{ 0x2456, 0x3076, },	/* 04-54  82D4  ぶ */
	{ 0x2457, 0x3077, },	/* 04-55  82D5  ぷ */
	{ 0x2458, 0x3078, },	/* 04-56  82D6  へ */
	{ 0x2459, 0x3079, },	/* 04-57  82D7  べ */
	{ 0x245A, 0x307A, },	/* 04-58  82D8  ぺ */
	{ 0x245B, 0x307B, },	/* 04-59  82D9  ほ */
	{ 0x245C, 0x307C, },	/* 04-60  82DA  ぼ */
	{ 0x245D, 0x307D, },	/* 04-61  82DB  ぽ */
	{ 0x245E, 0x307E, },	/* 04-62  82DC  ま */
	{ 0x245F, 0x307F, },	/* 04-63  82DD  み */
	{ 0x2460, 0x3080, },	/* 04-64  82DE  む */
	{ 0x2461, 0x3081, },	/* 04-65  82DF  め */
	{ 0x2462, 0x3082, },	/* 04-66  82E0  も */
	{ 0x2463, 0x3083, },	/* 04-67  82E1  ゃ */
	{ 0x2464, 0x3084, },	/* 04-68  82E2  や */
	{ 0x2465, 0x3085, },	/* 04-69  82E3  ゅ */
	{ 0x2466, 0x3086, },	/* 04-70  82E4  ゆ */
	{ 0x2467, 0x3087, },	/* 04-71  82E5  ょ */
	{ 0x2468, 0x3088, },	/* 04-72  82E6  よ */
	{ 0x2469, 0x3089, },	/* 04-73  82E7  ら */
	{ 0x246A, 0x308A, },	/* 04-74  82E8  り */
	{ 0x246B, 0x308B, },	/* 04-75  82E9  る */
	{ 0x246C, 0x308C, },	/* 04-76  82EA  れ */
	{ 0x246D, 0x308D, },	/* 04-77  82EB  ろ */
	{ 0x246E, 0x308E, },	/* 04-78  82EC  ゎ */
	{ 0x246F, 0x308F, },	/* 04-79  82ED  わ */
	{ 0x2470, 0x3090, },	/* 04-80  82EE  ゐ */
	{ 0x2471, 0x3091, },	/* 04-81  82EF  ゑ */
	{ 0x2472, 0x3092, },	/* 04-82  82F0  を */
	{ 0x2473, 0x3093, },	/* 04-83  82F1  ん */
	{ 0x2521, 0x30A1, },	/* 05-01  8340  ァ */
	{ 0x2522, 0x30A2, },	/* 05-02  8341  ア */
	{ 0x2523, 0x30A3, },	/* 05-03  8342  ィ */
	{ 0x2524, 0x30A4, },	/* 05-04  8343  イ */
	{ 0x2525, 0x30A5, },	/* 05-05  8344  ゥ */
	{ 0x2526, 0x30A6, },	/* 05-06  8345  ウ */
	{ 0x2527, 0x30A7, },	/* 05-07  8346  ェ */
	{ 0x2528, 0x30A8, },	/* 05-08  8347  エ */
	{ 0x2529, 0x30A9, },	/* 05-09  8348  ォ */
	{ 0x252A, 0x30AA, },	/* 05-10  8349  オ */
	{ 0x252B, 0x30AB, },	/* 05-11  834A  カ */
	{ 0x252C, 0x30AC, },	/* 05-12  834B  ガ */
	{ 0x252D, 0x30AD, },	/* 05-13  834C  キ */
	{ 0x252E, 0x30AE, },	/* 05-14  834D  ギ */
	{ 0x252F, 0x30AF, },	/* 05-15  834E  ク */
	{ 0x2530, 0x30B0, },	/* 05-16  834F  グ */
	{ 0x2531, 0x30B1, },	/* 05-17  8350  ケ */
	{ 0x2532, 0x30B2, },	/* 05-18  8351  ゲ */
	{ 0x2533, 0x30B3, },	/* 05-19  8352  コ */
	{ 0x2534, 0x30B4, },	/* 05-20  8353  ゴ */
	{ 0x2535, 0x30B5, },	/* 05-21  8354  サ */
	{ 0x2536, 0x30B6, },	/* 05-22  8355  ザ */
	{ 0x2537, 0x30B7, },	/* 05-23  8356  シ */
	{ 0x2538, 0x30B8, },	/* 05-24  8357  ジ */
	{ 0x2539, 0x30B9, },	/* 05-25  8358  ス */
	{ 0x253A, 0x30BA, },	/* 05-26  8359  ズ */
	{ 0x253B, 0x30BB, },	/* 05-27  835A  セ */
	{ 0x253C, 0x30BC, },	/* 05-28  835B  ゼ */
	{ 0x253D, 0x30BD, },	/* 05-29  835C  ソ */
	{ 0x253E, 0x30BE, },	/* 05-30  835D  ゾ */
	{ 0x253F, 0x30BF, },	/* 05-31  835E  タ */
	{ 0x2540, 0x30C0, },	/* 05-32  835F  ダ */
	{ 0x2541, 0x30C1, },	/* 05-33  8360  チ */
	{ 0x2542, 0x30C2, },	/* 05-34  8361  ヂ */
	{ 0x2543, 0x30C3, },	/* 05-35  8362  ッ */
	{ 0x2544, 0x30C4, },	/* 05-36  8363  ツ */
	{ 0x2545, 0x30C5, },	/* 05-37  8364  ヅ */
	{ 0x2546, 0x30C6, },	/* 05-38  8365  テ */
	{ 0x2547, 0x30C7, },	/* 05-39  8366  デ */
	{ 0x2548, 0x30C8, },	/* 05-40  8367  ト */
	{ 0x2549, 0x30C9, },	/* 05-41  8368  ド */
	{ 0x254A, 0x30CA, },	/* 05-42  8369  ナ */
	{ 0x254B, 0x30CB, },	/* 05-43  836A  ニ */
	{ 0x254C, 0x30CC, },	/* 05-44  836B  ヌ */
	{ 0x254D, 0x30CD, },	/* 05-45  836C  ネ */
	{ 0x254E, 0x30CE, },	/* 05-46  836D  ノ */
	{ 0x254F, 0x30CF, },	/* 05-47  836E  ハ */
	{ 0x2550, 0x30D0, },	/* 05-48  836F  バ */
	{ 0x2551, 0x30D1, },	/* 05-49  8370  パ */
	{ 0x2552, 0x30D2, },	/* 05-50  8371  ヒ */
	{ 0x2553, 0x30D3, },	/* 05-51  8372  ビ */
	{ 0x2554, 0x30D4, },	/* 05-52  8373  ピ */
	{ 0x2555, 0x30D5, },	/* 05-53  8374  フ */
	{ 0x2556, 0x30D6, },	/* 05-54  8375  ブ */
	{ 0x2557, 0x30D7, },	/* 05-55  8376  プ */
	{ 0x2558, 0x30D8, },	/* 05-56  8377  ヘ */
	{ 0x2559, 0x30D9, },	/* 05-57  8378  ベ */
	{ 0x255A, 0x30DA, },	/* 05-58  8379  ペ */
	{ 0x255B, 0x30DB, },	/* 05-59  837A  ホ */
	{ 0x255C, 0x30DC, },	/* 05-60  837B  ボ */
	{ 0x255D, 0x30DD, },	/* 05-61  837C  ポ */
	{ 0x255E, 0x30DE, },	/* 05-62  837D  マ */
	{ 0x255F, 0x30DF, },	/* 05-63  837E  ミ */
	{ 0x2560, 0x30E0, },	/* 05-64  8380  ム */
	{ 0x2561, 0x30E1, },	/* 05-65  8381  メ */
	{ 0x2562, 0x30E2, },	/* 05-66  8382  モ */
	{ 0x2563, 0x30E3, },	/* 05-67  8383  ャ */
	{ 0x2564, 0x30E4, },	/* 05-68  8384  ヤ */
	{ 0x2565, 0x30E5, },	/* 05-69  8385  ュ */
	{ 0x2566, 0x30E6, },	/* 05-70  8386  ユ */
	{ 0x2567, 0x30E7, },	/* 05-71  8387  ョ */
	{ 0x2568, 0x30E8, },	/* 05-72  8388  ヨ */
	{ 0x2569, 0x30E9, },	/* 05-73  8389  ラ */
	{ 0x256A, 0x30EA, },	/* 05-74  838A  リ */
	{ 0x256B, 0x30EB, },	/* 05-75  838B  ル */
	{ 0x256C, 0x30EC, },	/* 05-76  838C  レ */
	{ 0x256D, 0x30ED, },	/* 05-77  838D  ロ */
	{ 0x256E, 0x30EE, },	/* 05-78  838E  ヮ */
	{ 0x256F, 0x30EF, },	/* 05-79  838F  ワ */
	{ 0x2570, 0x30F0, },	/* 05-80  8390  ヰ */
	{ 0x2571, 0x30F1, },	/* 05-81  8391  ヱ */
	{ 0x2572, 0x30F2, },	/* 05-82  8392  ヲ */
	{ 0x2573, 0x30F3, },	/* 05-83  8393  ン */
	{ 0x2574, 0x30F4, },	/* 05-84  8394  ヴ */
	{ 0x2575, 0x30F5, },	/* 05-85  8395  ヵ */
	{ 0x2576, 0x30F6, },	/* 05-86  8396  ヶ */
	{ 0x2621, 0x0391, },	/* 06-01  839F  Α */
	{ 0x2622, 0x0392, },	/* 06-02  83A0  Β */
	{ 0x2623, 0x0393, },	/* 06-03  83A1  Γ */
	{ 0x2624, 0x0394, },	/* 06-04  83A2  Δ */
	{ 0x2625, 0x0395, },	/* 06-05  83A3  Ε */
	{ 0x2626, 0x0396, },	/* 06-06  83A4  Ζ */
	{ 0x2627, 0x0397, },	/* 06-07  83A5  Η */
	{ 0x2628, 0x0398, },	/* 06-08  83A6  Θ */
	{ 0x2629, 0x0399, },	/* 06-09  83A7  Ι */
	{ 0x262A, 0x039A, },	/* 06-10  83A8  Κ */
	{ 0x262B, 0x039B, },	/* 06-11  83A9  Λ */
	{ 0x262C, 0x039C, },	/* 06-12  83AA  Μ */
	{ 0x262D, 0x039D, },	/* 06-13  83AB  Ν */
	{ 0x262E, 0x039E, },	/* 06-14  83AC  Ξ */
	{ 0x262F, 0x039F, },	/* 06-15  83AD  Ο */
	{ 0x2630, 0x03A0, },	/* 06-16  83AE  Π */
	{ 0x2631, 0x03A1, },	/* 06-17  83AF  Ρ */
	{ 0x2632, 0x03A3, },	/* 06-18  83B0  Σ */
	{ 0x2633, 0x03A4, },	/* 06-19  83B1  Τ */
	{ 0x2634, 0x03A5, },	/* 06-20  83B2  Υ */
	{ 0x2635, 0x03A6, },	/* 06-21  83B3  Φ */
	{ 0x2636, 0x03A7, },	/* 06-22  83B4  Χ */
	{ 0x2637, 0x03A8, },	/* 06-23  83B5  Ψ */
	{ 0x2638, 0x03A9, },	/* 06-24  83B6  Ω */
	{ 0x2641, 0x03B1, },	/* 06-33  83BF  α */
	{ 0x2642, 0x03B2, },	/* 06-34  83C0  β */
	{ 0x2643, 0x03B3, },	/* 06-35  83C1  γ */
	{ 0x2644, 0x03B4, },	/* 06-36  83C2  δ */
	{ 0x2645, 0x03B5, },	/* 06-37  83C3  ε */
	{ 0x2646, 0x03B6, },	/* 06-38  83C4  ζ */
	{ 0x2647, 0x03B7, },	/* 06-39  83C5  η */
	{ 0x2648, 0x03B8, },	/* 06-40  83C6  θ */
	{ 0x2649, 0x03B9, },	/* 06-41  83C7  ι */
	{ 0x264A, 0x03BA, },	/* 06-42  83C8  κ */
	{ 0x264B, 0x03BB, },	/* 06-43  83C9  λ */
	{ 0x264C, 0x03BC, },	/* 06-44  83CA  μ */
	{ 0x264D, 0x03BD, },	/* 06-45  83CB  ν */
	{ 0x264E, 0x03BE, },	/* 06-46  83CC  ξ */
	{ 0x264F, 0x03BF, },	/* 06-47  83CD  ο */
	{ 0x2650, 0x03C0, },	/* 06-48  83CE  π */
	{ 0x2651, 0x03C1, },	/* 06-49  83CF  ρ */
	{ 0x2652, 0x03C3, },	/* 06-50  83D0  σ */
	{ 0x2653, 0x03C4, },	/* 06-51  83D1  τ */
	{ 0x2654, 0x03C5, },	/* 06-52  83D2  υ */
	{ 0x2655, 0x03C6, },	/* 06-53  83D3  φ */
	{ 0x2656, 0x03C7, },	/* 06-54  83D4  χ */
	{ 0x2657, 0x03C8, },	/* 06-55  83D5  ψ */
	{ 0x2658, 0x03C9, },	/* 06-56  83D6  ω */
	{ 0x2721, 0x0410, },	/* 07-01  8440  А */
	{ 0x2722, 0x0411, },	/* 07-02  8441  Б */
	{ 0x2723, 0x0412, },	/* 07-03  8442  В */
	{ 0x2724, 0x0413, },	/* 07-04  8443  Г */
	{ 0x2725, 0x0414, },	/* 07-05  8444  Д */
	{ 0x2726, 0x0415, },	/* 07-06  8445  Е */
	{ 0x2727, 0x0401, },	/* 07-07  8446  Ё */
	{ 0x2728, 0x0416, },	/* 07-08  8447  Ж */
	{ 0x2729, 0x0417, },	/* 07-09  8448  З */
	{ 0x272A, 0x0418, },	/* 07-10  8449  И */
	{ 0x272B, 0x0419, },	/* 07-11  844A  Й */
	{ 0x272C, 0x041A, },	/* 07-12  844B  К */
	{ 0x272D, 0x041B, },	/* 07-13  844C  Л */
	{ 0x272E, 0x041C, },	/* 07-14  844D  М */
	{ 0x272F, 0x041D, },	/* 07-15  844E  Н */
	{ 0x2730, 0x041E, },	/* 07-16  844F  О */
	{ 0x2731, 0x041F, },	/* 07-17  8450  П */
	{ 0x2732, 0x0420, },	/* 07-18  8451  Р */
	{ 0x2733, 0x0421, },	/* 07-19  8452  С */
	{ 0x2734, 0x0422, },	/* 07-20  8453  Т */
	{ 0x2735, 0x0423, },	/* 07-21  8454  У */
	{ 0x2736, 0x0424, },	/* 07-22  8455  Ф */
	{ 0x2737, 0x0425, },	/* 07-23  8456  Х */
	{ 0x2738, 0x0426, },	/* 07-24  8457  Ц */
	{ 0x2739, 0x0427, },	/* 07-25  8458  Ч */
	{ 0x273A, 0x0428, },	/* 07-26  8459  Ш */
	{ 0x273B, 0x0429, },	/* 07-27  845A  Щ */
	{ 0x273C, 0x042A, },	/* 07-28  845B  Ъ */
	{ 0x273D, 0x042B, },	/* 07-29  845C  Ы */
	{ 0x273E, 0x042C, },	/* 07-30  845D  Ь */
	{ 0x273F, 0x042D, },	/* 07-31  845E  Э */
	{ 0x2740, 0x042E, },	/* 07-32  845F  Ю */
	{ 0x2741, 0x042F, },	/* 07-33  8460  Я */
	{ 0x2751, 0x0430, },	/* 07-49  8470  а */
	{ 0x2752, 0x0431, },	/* 07-50  8471  б */
	{ 0x2753, 0x0432, },	/* 07-51  8472  в */
	{ 0x2754, 0x0433, },	/* 07-52  8473  г */
	{ 0x2755, 0x0434, },	/* 07-53  8474  д */
	{ 0x2756, 0x0435, },	/* 07-54  8475  е */
	{ 0x2757, 0x0451, },	/* 07-55  8476  ё */
	{ 0x2758, 0x0436, },	/* 07-56  8477  ж */
	{ 0x2759, 0x0437, },	/* 07-57  8478  з */
	{ 0x275A, 0x0438, },	/* 07-58  8479  и */
	{ 0x275B, 0x0439, },	/* 07-59  847A  й */
	{ 0x275C, 0x043A, },	/* 07-60  847B  к */
	{ 0x275D, 0x043B, },	/* 07-61  847C  л */
	{ 0x275E, 0x043C, },	/* 07-62  847D  м */
	{ 0x275F, 0x043D, },	/* 07-63  847E  н */
	{ 0x2760, 0x043E, },	/* 07-64  8480  о */
	{ 0x2761, 0x043F, },	/* 07-65  8481  п */
	{ 0x2762, 0x0440, },	/* 07-66  8482  р */
	{ 0x2763, 0x0441, },	/* 07-67  8483  с */
	{ 0x2764, 0x0442, },	/* 07-68  8484  т */
	{ 0x2765, 0x0443, },	/* 07-69  8485  у */
	{ 0x2766, 0x0444, },	/* 07-70  8486  ф */
	{ 0x2767, 0x0445, },	/* 07-71  8487  х */
	{ 0x2768, 0x0446, },	/* 07-72  8488  ц */
	{ 0x2769, 0x0447, },	/* 07-73  8489  ч */
	{ 0x276A, 0x0448, },	/* 07-74  848A  ш */
	{ 0x276B, 0x0449, },	/* 07-75  848B  щ */
	{ 0x276C, 0x044A, },	/* 07-76  848C  ъ */
	{ 0x276D, 0x044B, },	/* 07-77  848D  ы */
	{ 0x276E, 0x044C, },	/* 07-78  848E  ь */
	{ 0x276F, 0x044D, },	/* 07-79  848F  э */
	{ 0x2770, 0x044E, },	/* 07-80  8490  ю */
	{ 0x2771, 0x044F, },	/* 07-81  8491  я */
	{ 0x2821, 0x2500, },	/* 08-01  849F  ─ */
	{ 0x2822, 0x2502, },	/* 08-02  84A0  │ */
	{ 0x2823, 0x250C, },	/* 08-03  84A1  ┌ */
	{ 0x2824, 0x2510, },	/* 08-04  84A2  ┐ */
	{ 0x2825, 0x2518, },	/* 08-05  84A3  ┘ */
	{ 0x2826, 0x2514, },	/* 08-06  84A4  └ */
	{ 0x2827, 0x251C, },	/* 08-07  84A5  ├ */
	{ 0x2828, 0x252C, },	/* 08-08  84A6  ┬ */
	{ 0x2829, 0x2524, },	/* 08-09  84A7  ┤ */
	{ 0x282A, 0x2534, },	/* 08-10  84A8  ┴ */
	{ 0x282B, 0x253C, },	/* 08-11  84A9  ┼ */
	{ 0x282C, 0x2501, },	/* 08-12  84AA  ━ */
	{ 0x282D, 0x2503, },	/* 08-13  84AB  ┃ */
	{ 0x282E, 0x250F, },	/* 08-14  84AC  ┏ */
	{ 0x282F, 0x2513, },	/* 08-15  84AD  ┓ */
	{ 0x2830, 0x251B, },	/* 08-16  84AE  ┛ */
	{ 0x2831, 0x2517, },	/* 08-17  84AF  ┗ */
	{ 0x2832, 0x2523, },	/* 08-18  84B0  ┣ */
	{ 0x2833, 0x2533, },	/* 08-19  84B1  ┳ */
	{ 0x2834, 0x252B, },	/* 08-20  84B2  ┫ */
	{ 0x2835, 0x253B, },	/* 08-21  84B3  ┻ */
	{ 0x2836, 0x254B, },	/* 08-22  84B4  ╋ */
	{ 0x2837, 0x2520, },	/* 08-23  84B5  ┠ */
	{ 0x2838, 0x252F, },	/* 08-24  84B6  ┯ */
	{ 0x2839, 0x2528, },	/* 08-25  84B7  ┨ */
	{ 0x283A, 0x2537, },	/* 08-26  84B8  ┷ */
	{ 0x283B, 0x253F, },	/* 08-27  84B9  ┿ */
	{ 0x283C, 0x251D, },	/* 08-28  84BA  ┝ */
	{ 0x283D, 0x2530, },	/* 08-29  84BB  ┰ */
	{ 0x283E, 0x2525, },	/* 08-30  84BC  ┥ */
	{ 0x283F, 0x2538, },	/* 08-31  84BD  ┸ */
	{ 0x2840, 0x2542, },	/* 08-32  84BE  ╂ */
	{ 0x3021, 0x4E9C, },	/* 16-01  889F  亜 */
	{ 0x3022, 0x5516, },	/* 16-02  88A0  唖 */
	{ 0x3023, 0x5A03, },	/* 16-03  88A1  娃 */
	{ 0x3024, 0x963F, },	/* 16-04  88A2  阿 */
	{ 0x3025, 0x54C0, },	/* 16-05  88A3  哀 */
	{ 0x3026, 0x611B, },	/* 16-06  88A4  愛 */
	{ 0x3027, 0x6328, },	/* 16-07  88A5  挨 */
	{ 0x3028, 0x59F6, },	/* 16-08  88A6  姶 */
	{ 0x3029, 0x9022, },	/* 16-09  88A7  逢 */
	{ 0x302A, 0x8475, },	/* 16-10  88A8  葵 */
	{ 0x302B, 0x831C, },	/* 16-11  88A9  茜 */
	{ 0x302C, 0x7A50, },	/* 16-12  88AA  穐 */
	{ 0x302D, 0x60AA, },	/* 16-13  88AB  悪 */
	{ 0x302E, 0x63E1, },	/* 16-14  88AC  握 */
	{ 0x302F, 0x6E25, },	/* 16-15  88AD  渥 */
	{ 0x3030, 0x65ED, },	/* 16-16  88AE  旭 */
	{ 0x3031, 0x8466, },	/* 16-17  88AF  葦 */
	{ 0x3032, 0x82A6, },	/* 16-18  88B0  芦 */
	{ 0x3033, 0x9BF5, },	/* 16-19  88B1  鯵 */
	{ 0x3034, 0x6893, },	/* 16-20  88B2  梓 */
	{ 0x3035, 0x5727, },	/* 16-21  88B3  圧 */
	{ 0x3036, 0x65A1, },	/* 16-22  88B4  斡 */
	{ 0x3037, 0x6271, },	/* 16-23  88B5  扱 */
	{ 0x3038, 0x5B9B, },	/* 16-24  88B6  宛 */
	{ 0x3039, 0x59D0, },	/* 16-25  88B7  姐 */
	{ 0x303A, 0x867B, },	/* 16-26  88B8  虻 */
	{ 0x303B, 0x98F4, },	/* 16-27  88B9  飴 */
	{ 0x303C, 0x7D62, },	/* 16-28  88BA  絢 */
	{ 0x303D, 0x7DBE, },	/* 16-29  88BB  綾 */
	{ 0x303E, 0x9B8E, },	/* 16-30  88BC  鮎 */
	{ 0x303F, 0x6216, },	/* 16-31  88BD  或 */
	{ 0x3040, 0x7C9F, },	/* 16-32  88BE  粟 */
	{ 0x3041, 0x88B7, },	/* 16-33  88BF  袷 */
	{ 0x3042, 0x5B89, },	/* 16-34  88C0  安 */
	{ 0x3043, 0x5EB5, },	/* 16-35  88C1  庵 */
	{ 0x3044, 0x6309, },	/* 16-36  88C2  按 */
	{ 0x3045, 0x6697, },	/* 16-37  88C3  暗 */
	{ 0x3046, 0x6848, },	/* 16-38  88C4  案 */
	{ 0x3047, 0x95C7, },	/* 16-39  88C5  闇 */
	{ 0x3048, 0x978D, },	/* 16-40  88C6  鞍 */
	{ 0x3049, 0x674F, },	/* 16-41  88C7  杏 */
	{ 0x304A, 0x4EE5, },	/* 16-42  88C8  以 */
	{ 0x304B, 0x4F0A, },	/* 16-43  88C9  伊 */
	{ 0x304C, 0x4F4D, },	/* 16-44  88CA  位 */
	{ 0x304D, 0x4F9D, },	/* 16-45  88CB  依 */
	{ 0x304E, 0x5049, },	/* 16-46  88CC  偉 */
	{ 0x304F, 0x56F2, },	/* 16-47  88CD  囲 */
	{ 0x3050, 0x5937, },	/* 16-48  88CE  夷 */
	{ 0x3051, 0x59D4, },	/* 16-49  88CF  委 */
	{ 0x3052, 0x5A01, },	/* 16-50  88D0  威 */
	{ 0x3053, 0x5C09, },	/* 16-51  88D1  尉 */
	{ 0x3054, 0x60DF, },	/* 16-52  88D2  惟 */
	{ 0x3055, 0x610F, },	/* 16-53  88D3  意 */
	{ 0x3056, 0x6170, },	/* 16-54  88D4  慰 */
	{ 0x3057, 0x6613, },	/* 16-55  88D5  易 */
	{ 0x3058, 0x6905, },	/* 16-56  88D6  椅 */
	{ 0x3059, 0x70BA, },	/* 16-57  88D7  為 */
	{ 0x305A, 0x754F, },	/* 16-58  88D8  畏 */
	{ 0x305B, 0x7570, },	/* 16-59  88D9  異 */
	{ 0x305C, 0x79FB, },	/* 16-60  88DA  移 */
	{ 0x305D, 0x7DAD, },	/* 16-61  88DB  維 */
	{ 0x305E, 0x7DEF, },	/* 16-62  88DC  緯 */
	{ 0x305F, 0x80C3, },	/* 16-63  88DD  胃 */
	{ 0x3060, 0x840E, },	/* 16-64  88DE  萎 */
	{ 0x3061, 0x8863, },	/* 16-65  88DF  衣 */
	{ 0x3062, 0x8B02, },	/* 16-66  88E0  謂 */
	{ 0x3063, 0x9055, },	/* 16-67  88E1  違 */
	{ 0x3064, 0x907A, },	/* 16-68  88E2  遺 */
	{ 0x3065, 0x533B, },	/* 16-69  88E3  医 */
	{ 0x3066, 0x4E95, },	/* 16-70  88E4  井 */
	{ 0x3067, 0x4EA5, },	/* 16-71  88E5  亥 */
	{ 0x3068, 0x57DF, },	/* 16-72  88E6  域 */
	{ 0x3069, 0x80B2, },	/* 16-73  88E7  育 */
	{ 0x306A, 0x90C1, },	/* 16-74  88E8  郁 */
	{ 0x306B, 0x78EF, },	/* 16-75  88E9  磯 */
	{ 0x306C, 0x4E00, },	/* 16-76  88EA  一 */
	{ 0x306D, 0x58F1, },	/* 16-77  88EB  壱 */
	{ 0x306E, 0x6EA2, },	/* 16-78  88EC  溢 */
	{ 0x306F, 0x9038, },	/* 16-79  88ED  逸 */
	{ 0x3070, 0x7A32, },	/* 16-80  88EE  稲 */
	{ 0x3071, 0x8328, },	/* 16-81  88EF  茨 */
	{ 0x3072, 0x828B, },	/* 16-82  88F0  芋 */
	{ 0x3073, 0x9C2F, },	/* 16-83  88F1  鰯 */
	{ 0x3074, 0x5141, },	/* 16-84  88F2  允 */
	{ 0x3075, 0x5370, },	/* 16-85  88F3  印 */
	{ 0x3076, 0x54BD, },	/* 16-86  88F4  咽 */
	{ 0x3077, 0x54E1, },	/* 16-87  88F5  員 */
	{ 0x3078, 0x56E0, },	/* 16-88  88F6  因 */
	{ 0x3079, 0x59FB, },	/* 16-89  88F7  姻 */
	{ 0x307A, 0x5F15, },	/* 16-90  88F8  引 */
	{ 0x307B, 0x98F2, },	/* 16-91  88F9  飲 */
	{ 0x307C, 0x6DEB, },	/* 16-92  88FA  淫 */
	{ 0x307D, 0x80E4, },	/* 16-93  88FB  胤 */
	{ 0x307E, 0x852D, },	/* 16-94  88FC  蔭 */
	{ 0x3121, 0x9662, },	/* 17-01  8940  院 */
	{ 0x3122, 0x9670, },	/* 17-02  8941  陰 */
	{ 0x3123, 0x96A0, },	/* 17-03  8942  隠 */
	{ 0x3124, 0x97FB, },	/* 17-04  8943  韻 */
	{ 0x3125, 0x540B, },	/* 17-05  8944  吋 */
	{ 0x3126, 0x53F3, },	/* 17-06  8945  右 */
	{ 0x3127, 0x5B87, },	/* 17-07  8946  宇 */
	{ 0x3128, 0x70CF, },	/* 17-08  8947  烏 */
	{ 0x3129, 0x7FBD, },	/* 17-09  8948  羽 */
	{ 0x312A, 0x8FC2, },	/* 17-10  8949  迂 */
	{ 0x312B, 0x96E8, },	/* 17-11  894A  雨 */
	{ 0x312C, 0x536F, },	/* 17-12  894B  卯 */
	{ 0x312D, 0x9D5C, },	/* 17-13  894C  鵜 */
	{ 0x312E, 0x7ABA, },	/* 17-14  894D  窺 */
	{ 0x312F, 0x4E11, },	/* 17-15  894E  丑 */
	{ 0x3130, 0x7893, },	/* 17-16  894F  碓 */
	{ 0x3131, 0x81FC, },	/* 17-17  8950  臼 */
	{ 0x3132, 0x6E26, },	/* 17-18  8951  渦 */
	{ 0x3133, 0x5618, },	/* 17-19  8952  嘘 */
	{ 0x3134, 0x5504, },	/* 17-20  8953  唄 */
	{ 0x3135, 0x6B1D, },	/* 17-21  8954  欝 */
	{ 0x3136, 0x851A, },	/* 17-22  8955  蔚 */
	{ 0x3137, 0x9C3B, },	/* 17-23  8956  鰻 */
	{ 0x3138, 0x59E5, },	/* 17-24  8957  姥 */
	{ 0x3139, 0x53A9, },	/* 17-25  8958  厩 */
	{ 0x313A, 0x6D66, },	/* 17-26  8959  浦 */
	{ 0x313B, 0x74DC, },	/* 17-27  895A  瓜 */
	{ 0x313C, 0x958F, },	/* 17-28  895B  閏 */
	{ 0x313D, 0x5642, },	/* 17-29  895C  噂 */
	{ 0x313E, 0x4E91, },	/* 17-30  895D  云 */
	{ 0x313F, 0x904B, },	/* 17-31  895E  運 */
	{ 0x3140, 0x96F2, },	/* 17-32  895F  雲 */
	{ 0x3141, 0x834F, },	/* 17-33  8960  荏 */
	{ 0x3142, 0x990C, },	/* 17-34  8961  餌 */
	{ 0x3143, 0x53E1, },	/* 17-35  8962  叡 */
	{ 0x3144, 0x55B6, },	/* 17-36  8963  営 */
	{ 0x3145, 0x5B30, },	/* 17-37  8964  嬰 */
	{ 0x3146, 0x5F71, },	/* 17-38  8965  影 */
	{ 0x3147, 0x6620, },	/* 17-39  8966  映 */
	{ 0x3148, 0x66F3, },	/* 17-40  8967  曳 */
	{ 0x3149, 0x6804, },	/* 17-41  8968  栄 */
	{ 0x314A, 0x6C38, },	/* 17-42  8969  永 */
	{ 0x314B, 0x6CF3, },	/* 17-43  896A  泳 */
	{ 0x314C, 0x6D29, },	/* 17-44  896B  洩 */
	{ 0x314D, 0x745B, },	/* 17-45  896C  瑛 */
	{ 0x314E, 0x76C8, },	/* 17-46  896D  盈 */
	{ 0x314F, 0x7A4E, },	/* 17-47  896E  穎 */
	{ 0x3150, 0x9834, },	/* 17-48  896F  頴 */
	{ 0x3151, 0x82F1, },	/* 17-49  8970  英 */
	{ 0x3152, 0x885B, },	/* 17-50  8971  衛 */
	{ 0x3153, 0x8A60, },	/* 17-51  8972  詠 */
	{ 0x3154, 0x92ED, },	/* 17-52  8973  鋭 */
	{ 0x3155, 0x6DB2, },	/* 17-53  8974  液 */
	{ 0x3156, 0x75AB, },	/* 17-54  8975  疫 */
	{ 0x3157, 0x76CA, },	/* 17-55  8976  益 */
	{ 0x3158, 0x99C5, },	/* 17-56  8977  駅 */
	{ 0x3159, 0x60A6, },	/* 17-57  8978  悦 */
	{ 0x315A, 0x8B01, },	/* 17-58  8979  謁 */
	{ 0x315B, 0x8D8A, },	/* 17-59  897A  越 */
	{ 0x315C, 0x95B2, },	/* 17-60  897B  閲 */
	{ 0x315D, 0x698E, },	/* 17-61  897C  榎 */
	{ 0x315E, 0x53AD, },	/* 17-62  897D  厭 */
	{ 0x315F, 0x5186, },	/* 17-63  897E  円 */
	{ 0x3160, 0x5712, },	/* 17-64  8980  園 */
	{ 0x3161, 0x5830, },	/* 17-65  8981  堰 */
	{ 0x3162, 0x5944, },	/* 17-66  8982  奄 */
	{ 0x3163, 0x5BB4, },	/* 17-67  8983  宴 */
	{ 0x3164, 0x5EF6, },	/* 17-68  8984  延 */
	{ 0x3165, 0x6028, },	/* 17-69  8985  怨 */
	{ 0x3166, 0x63A9, },	/* 17-70  8986  掩 */
	{ 0x3167, 0x63F4, },	/* 17-71  8987  援 */
	{ 0x3168, 0x6CBF, },	/* 17-72  8988  沿 */
	{ 0x3169, 0x6F14, },	/* 17-73  8989  演 */
	{ 0x316A, 0x708E, },	/* 17-74  898A  炎 */
	{ 0x316B, 0x7114, },	/* 17-75  898B  焔 */
	{ 0x316C, 0x7159, },	/* 17-76  898C  煙 */
	{ 0x316D, 0x71D5, },	/* 17-77  898D  燕 */
	{ 0x316E, 0x733F, },	/* 17-78  898E  猿 */
	{ 0x316F, 0x7E01, },	/* 17-79  898F  縁 */
	{ 0x3170, 0x8276, },	/* 17-80  8990  艶 */
	{ 0x3171, 0x82D1, },	/* 17-81  8991  苑 */
	{ 0x3172, 0x8597, },	/* 17-82  8992  薗 */
	{ 0x3173, 0x9060, },	/* 17-83  8993  遠 */
	{ 0x3174, 0x925B, },	/* 17-84  8994  鉛 */
	{ 0x3175, 0x9D1B, },	/* 17-85  8995  鴛 */
	{ 0x3176, 0x5869, },	/* 17-86  8996  塩 */
	{ 0x3177, 0x65BC, },	/* 17-87  8997  於 */
	{ 0x3178, 0x6C5A, },	/* 17-88  8998  汚 */
	{ 0x3179, 0x7525, },	/* 17-89  8999  甥 */
	{ 0x317A, 0x51F9, },	/* 17-90  899A  凹 */
	{ 0x317B, 0x592E, },	/* 17-91  899B  央 */
	{ 0x317C, 0x5965, },	/* 17-92  899C  奥 */
	{ 0x317D, 0x5F80, },	/* 17-93  899D  往 */
	{ 0x317E, 0x5FDC, },	/* 17-94  899E  応 */
	{ 0x3221, 0x62BC, },	/* 18-01  899F  押 */
	{ 0x3222, 0x65FA, },	/* 18-02  89A0  旺 */
	{ 0x3223, 0x6A2A, },	/* 18-03  89A1  横 */
	{ 0x3224, 0x6B27, },	/* 18-04  89A2  欧 */
	{ 0x3225, 0x6BB4, },	/* 18-05  89A3  殴 */
	{ 0x3226, 0x738B, },	/* 18-06  89A4  王 */
	{ 0x3227, 0x7FC1, },	/* 18-07  89A5  翁 */
	{ 0x3228, 0x8956, },	/* 18-08  89A6  襖 */
	{ 0x3229, 0x9D2C, },	/* 18-09  89A7  鴬 */
	{ 0x322A, 0x9D0E, },	/* 18-10  89A8  鴎 */
	{ 0x322B, 0x9EC4, },	/* 18-11  89A9  黄 */
	{ 0x322C, 0x5CA1, },	/* 18-12  89AA  岡 */
	{ 0x322D, 0x6C96, },	/* 18-13  89AB  沖 */
	{ 0x322E, 0x837B, },	/* 18-14  89AC  荻 */
	{ 0x322F, 0x5104, },	/* 18-15  89AD  億 */
	{ 0x3230, 0x5C4B, },	/* 18-16  89AE  屋 */
	{ 0x3231, 0x61B6, },	/* 18-17  89AF  憶 */
	{ 0x3232, 0x81C6, },	/* 18-18  89B0  臆 */
	{ 0x3233, 0x6876, },	/* 18-19  89B1  桶 */
	{ 0x3234, 0x7261, },	/* 18-20  89B2  牡 */
	{ 0x3235, 0x4E59, },	/* 18-21  89B3  乙 */
	{ 0x3236, 0x4FFA, },	/* 18-22  89B4  俺 */
	{ 0x3237, 0x5378, },	/* 18-23  89B5  卸 */
	{ 0x3238, 0x6069, },	/* 18-24  89B6  恩 */
	{ 0x3239, 0x6E29, },	/* 18-25  89B7  温 */
	{ 0x323A, 0x7A4F, },	/* 18-26  89B8  穏 */
	{ 0x323B, 0x97F3, },	/* 18-27  89B9  音 */
	{ 0x323C, 0x4E0B, },	/* 18-28  89BA  下 */
	{ 0x323D, 0x5316, },	/* 18-29  89BB  化 */
	{ 0x323E, 0x4EEE, },	/* 18-30  89BC  仮 */
	{ 0x323F, 0x4F55, },	/* 18-31  89BD  何 */
	{ 0x3240, 0x4F3D, },	/* 18-32  89BE  伽 */
	{ 0x3241, 0x4FA1, },	/* 18-33  89BF  価 */
	{ 0x3242, 0x4F73, },	/* 18-34  89C0  佳 */
	{ 0x3243, 0x52A0, },	/* 18-35  89C1  加 */
	{ 0x3244, 0x53EF, },	/* 18-36  89C2  可 */
	{ 0x3245, 0x5609, },	/* 18-37  89C3  嘉 */
	{ 0x3246, 0x590F, },	/* 18-38  89C4  夏 */
	{ 0x3247, 0x5AC1, },	/* 18-39  89C5  嫁 */
	{ 0x3248, 0x5BB6, },	/* 18-40  89C6  家 */
	{ 0x3249, 0x5BE1, },	/* 18-41  89C7  寡 */
	{ 0x324A, 0x79D1, },	/* 18-42  89C8  科 */
	{ 0x324B, 0x6687, },	/* 18-43  89C9  暇 */
	{ 0x324C, 0x679C, },	/* 18-44  89CA  果 */
	{ 0x324D, 0x67B6, },	/* 18-45  89CB  架 */
	{ 0x324E, 0x6B4C, },	/* 18-46  89CC  歌 */
	{ 0x324F, 0x6CB3, },	/* 18-47  89CD  河 */
	{ 0x3250, 0x706B, },	/* 18-48  89CE  火 */
	{ 0x3251, 0x73C2, },	/* 18-49  89CF  珂 */
	{ 0x3252, 0x798D, },	/* 18-50  89D0  禍 */
	{ 0x3253, 0x79BE, },	/* 18-51  89D1  禾 */
	{ 0x3254, 0x7A3C, },	/* 18-52  89D2  稼 */
	{ 0x3255, 0x7B87, },	/* 18-53  89D3  箇 */
	{ 0x3256, 0x82B1, },	/* 18-54  89D4  花 */
	{ 0x3257, 0x82DB, },	/* 18-55  89D5  苛 */
	{ 0x3258, 0x8304, },	/* 18-56  89D6  茄 */
	{ 0x3259, 0x8377, },	/* 18-57  89D7  荷 */
	{ 0x325A, 0x83EF, },	/* 18-58  89D8  華 */
	{ 0x325B, 0x83D3, },	/* 18-59  89D9  菓 */
	{ 0x325C, 0x8766, },	/* 18-60  89DA  蝦 */
	{ 0x325D, 0x8AB2, },	/* 18-61  89DB  課 */
	{ 0x325E, 0x5629, },	/* 18-62  89DC  嘩 */
	{ 0x325F, 0x8CA8, },	/* 18-63  89DD  貨 */
	{ 0x3260, 0x8FE6, },	/* 18-64  89DE  迦 */
	{ 0x3261, 0x904E, },	/* 18-65  89DF  過 */
	{ 0x3262, 0x971E, },	/* 18-66  89E0  霞 */
	{ 0x3263, 0x868A, },	/* 18-67  89E1  蚊 */
	{ 0x3264, 0x4FC4, },	/* 18-68  89E2  俄 */
	{ 0x3265, 0x5CE8, },	/* 18-69  89E3  峨 */
	{ 0x3266, 0x6211, },	/* 18-70  89E4  我 */
	{ 0x3267, 0x7259, },	/* 18-71  89E5  牙 */
	{ 0x3268, 0x753B, },	/* 18-72  89E6  画 */
	{ 0x3269, 0x81E5, },	/* 18-73  89E7  臥 */
	{ 0x326A, 0x82BD, },	/* 18-74  89E8  芽 */
	{ 0x326B, 0x86FE, },	/* 18-75  89E9  蛾 */
	{ 0x326C, 0x8CC0, },	/* 18-76  89EA  賀 */
	{ 0x326D, 0x96C5, },	/* 18-77  89EB  雅 */
	{ 0x326E, 0x9913, },	/* 18-78  89EC  餓 */
	{ 0x326F, 0x99D5, },	/* 18-79  89ED  駕 */
	{ 0x3270, 0x4ECB, },	/* 18-80  89EE  介 */
	{ 0x3271, 0x4F1A, },	/* 18-81  89EF  会 */
	{ 0x3272, 0x89E3, },	/* 18-82  89F0  解 */
	{ 0x3273, 0x56DE, },	/* 18-83  89F1  回 */
	{ 0x3274, 0x584A, },	/* 18-84  89F2  塊 */
	{ 0x3275, 0x58CA, },	/* 18-85  89F3  壊 */
	{ 0x3276, 0x5EFB, },	/* 18-86  89F4  廻 */
	{ 0x3277, 0x5FEB, },	/* 18-87  89F5  快 */
	{ 0x3278, 0x602A, },	/* 18-88  89F6  怪 */
	{ 0x3279, 0x6094, },	/* 18-89  89F7  悔 */
	{ 0x327A, 0x6062, },	/* 18-90  89F8  恢 */
	{ 0x327B, 0x61D0, },	/* 18-91  89F9  懐 */
	{ 0x327C, 0x6212, },	/* 18-92  89FA  戒 */
	{ 0x327D, 0x62D0, },	/* 18-93  89FB  拐 */
	{ 0x327E, 0x6539, },	/* 18-94  89FC  改 */
	{ 0x3321, 0x9B41, },	/* 19-01  8A40  魁 */
	{ 0x3322, 0x6666, },	/* 19-02  8A41  晦 */
	{ 0x3323, 0x68B0, },	/* 19-03  8A42  械 */
	{ 0x3324, 0x6D77, },	/* 19-04  8A43  海 */
	{ 0x3325, 0x7070, },	/* 19-05  8A44  灰 */
	{ 0x3326, 0x754C, },	/* 19-06  8A45  界 */
	{ 0x3327, 0x7686, },	/* 19-07  8A46  皆 */
	{ 0x3328, 0x7D75, },	/* 19-08  8A47  絵 */
	{ 0x3329, 0x82A5, },	/* 19-09  8A48  芥 */
	{ 0x332A, 0x87F9, },	/* 19-10  8A49  蟹 */
	{ 0x332B, 0x958B, },	/* 19-11  8A4A  開 */
	{ 0x332C, 0x968E, },	/* 19-12  8A4B  階 */
	{ 0x332D, 0x8C9D, },	/* 19-13  8A4C  貝 */
	{ 0x332E, 0x51F1, },	/* 19-14  8A4D  凱 */
	{ 0x332F, 0x52BE, },	/* 19-15  8A4E  劾 */
	{ 0x3330, 0x5916, },	/* 19-16  8A4F  外 */
	{ 0x3331, 0x54B3, },	/* 19-17  8A50  咳 */
	{ 0x3332, 0x5BB3, },	/* 19-18  8A51  害 */
	{ 0x3333, 0x5D16, },	/* 19-19  8A52  崖 */
	{ 0x3334, 0x6168, },	/* 19-20  8A53  慨 */
	{ 0x3335, 0x6982, },	/* 19-21  8A54  概 */
	{ 0x3336, 0x6DAF, },	/* 19-22  8A55  涯 */
	{ 0x3337, 0x788D, },	/* 19-23  8A56  碍 */
	{ 0x3338, 0x84CB, },	/* 19-24  8A57  蓋 */
	{ 0x3339, 0x8857, },	/* 19-25  8A58  街 */
	{ 0x333A, 0x8A72, },	/* 19-26  8A59  該 */
	{ 0x333B, 0x93A7, },	/* 19-27  8A5A  鎧 */
	{ 0x333C, 0x9AB8, },	/* 19-28  8A5B  骸 */
	{ 0x333D, 0x6D6C, },	/* 19-29  8A5C  浬 */
	{ 0x333E, 0x99A8, },	/* 19-30  8A5D  馨 */
	{ 0x333F, 0x86D9, },	/* 19-31  8A5E  蛙 */
	{ 0x3340, 0x57A3, },	/* 19-32  8A5F  垣 */
	{ 0x3341, 0x67FF, },	/* 19-33  8A60  柿 */
	{ 0x3342, 0x86CE, },	/* 19-34  8A61  蛎 */
	{ 0x3343, 0x920E, },	/* 19-35  8A62  鈎 */
	{ 0x3344, 0x5283, },	/* 19-36  8A63  劃 */
	{ 0x3345, 0x5687, },	/* 19-37  8A64  嚇 */
	{ 0x3346, 0x5404, },	/* 19-38  8A65  各 */
	{ 0x3347, 0x5ED3, },	/* 19-39  8A66  廓 */
	{ 0x3348, 0x62E1, },	/* 19-40  8A67  拡 */
	{ 0x3349, 0x64B9, },	/* 19-41  8A68  撹 */
	{ 0x334A, 0x683C, },	/* 19-42  8A69  格 */
	{ 0x334B, 0x6838, },	/* 19-43  8A6A  核 */
	{ 0x334C, 0x6BBB, },	/* 19-44  8A6B  殻 */
	{ 0x334D, 0x7372, },	/* 19-45  8A6C  獲 */
	{ 0x334E, 0x78BA, },	/* 19-46  8A6D  確 */
	{ 0x334F, 0x7A6B, },	/* 19-47  8A6E  穫 */
	{ 0x3350, 0x899A, },	/* 19-48  8A6F  覚 */
	{ 0x3351, 0x89D2, },	/* 19-49  8A70  角 */
	{ 0x3352, 0x8D6B, },	/* 19-50  8A71  赫 */
	{ 0x3353, 0x8F03, },	/* 19-51  8A72  較 */
	{ 0x3354, 0x90ED, },	/* 19-52  8A73  郭 */
	{ 0x3355, 0x95A3, },	/* 19-53  8A74  閣 */
	{ 0x3356, 0x9694, },	/* 19-54  8A75  隔 */
	{ 0x3357, 0x9769, },	/* 19-55  8A76  革 */
	{ 0x3358, 0x5B66, },	/* 19-56  8A77  学 */
	{ 0x3359, 0x5CB3, },	/* 19-57  8A78  岳 */
	{ 0x335A, 0x697D, },	/* 19-58  8A79  楽 */
	{ 0x335B, 0x984D, },	/* 19-59  8A7A  額 */
	{ 0x335C, 0x984E, },	/* 19-60  8A7B  顎 */
	{ 0x335D, 0x639B, },	/* 19-61  8A7C  掛 */
	{ 0x335E, 0x7B20, },	/* 19-62  8A7D  笠 */
	{ 0x335F, 0x6A2B, },	/* 19-63  8A7E  樫 */
	{ 0x3360, 0x6A7F, },	/* 19-64  8A80  橿 */
	{ 0x3361, 0x68B6, },	/* 19-65  8A81  梶 */
	{ 0x3362, 0x9C0D, },	/* 19-66  8A82  鰍 */
	{ 0x3363, 0x6F5F, },	/* 19-67  8A83  潟 */
	{ 0x3364, 0x5272, },	/* 19-68  8A84  割 */
	{ 0x3365, 0x559D, },	/* 19-69  8A85  喝 */
	{ 0x3366, 0x6070, },	/* 19-70  8A86  恰 */
	{ 0x3367, 0x62EC, },	/* 19-71  8A87  括 */
	{ 0x3368, 0x6D3B, },	/* 19-72  8A88  活 */
	{ 0x3369, 0x6E07, },	/* 19-73  8A89  渇 */
	{ 0x336A, 0x6ED1, },	/* 19-74  8A8A  滑 */
	{ 0x336B, 0x845B, },	/* 19-75  8A8B  葛 */
	{ 0x336C, 0x8910, },	/* 19-76  8A8C  褐 */
	{ 0x336D, 0x8F44, },	/* 19-77  8A8D  轄 */
	{ 0x336E, 0x4E14, },	/* 19-78  8A8E  且 */
	{ 0x336F, 0x9C39, },	/* 19-79  8A8F  鰹 */
	{ 0x3370, 0x53F6, },	/* 19-80  8A90  叶 */
	{ 0x3371, 0x691B, },	/* 19-81  8A91  椛 */
	{ 0x3372, 0x6A3A, },	/* 19-82  8A92  樺 */
	{ 0x3373, 0x9784, },	/* 19-83  8A93  鞄 */
	{ 0x3374, 0x682A, },	/* 19-84  8A94  株 */
	{ 0x3375, 0x515C, },	/* 19-85  8A95  兜 */
	{ 0x3376, 0x7AC3, },	/* 19-86  8A96  竃 */
	{ 0x3377, 0x84B2, },	/* 19-87  8A97  蒲 */
	{ 0x3378, 0x91DC, },	/* 19-88  8A98  釜 */
	{ 0x3379, 0x938C, },	/* 19-89  8A99  鎌 */
	{ 0x337A, 0x565B, },	/* 19-90  8A9A  噛 */
	{ 0x337B, 0x9D28, },	/* 19-91  8A9B  鴨 */
	{ 0x337C, 0x6822, },	/* 19-92  8A9C  栢 */
	{ 0x337D, 0x8305, },	/* 19-93  8A9D  茅 */
	{ 0x337E, 0x8431, },	/* 19-94  8A9E  萱 */
	{ 0x3421, 0x7CA5, },	/* 20-01  8A9F  粥 */
	{ 0x3422, 0x5208, },	/* 20-02  8AA0  刈 */
	{ 0x3423, 0x82C5, },	/* 20-03  8AA1  苅 */
	{ 0x3424, 0x74E6, },	/* 20-04  8AA2  瓦 */
	{ 0x3425, 0x4E7E, },	/* 20-05  8AA3  乾 */
	{ 0x3426, 0x4F83, },	/* 20-06  8AA4  侃 */
	{ 0x3427, 0x51A0, },	/* 20-07  8AA5  冠 */
	{ 0x3428, 0x5BD2, },	/* 20-08  8AA6  寒 */
	{ 0x3429, 0x520A, },	/* 20-09  8AA7  刊 */
	{ 0x342A, 0x52D8, },	/* 20-10  8AA8  勘 */
	{ 0x342B, 0x52E7, },	/* 20-11  8AA9  勧 */
	{ 0x342C, 0x5DFB, },	/* 20-12  8AAA  巻 */
	{ 0x342D, 0x559A, },	/* 20-13  8AAB  喚 */
	{ 0x342E, 0x582A, },	/* 20-14  8AAC  堪 */
	{ 0x342F, 0x59E6, },	/* 20-15  8AAD  姦 */
	{ 0x3430, 0x5B8C, },	/* 20-16  8AAE  完 */
	{ 0x3431, 0x5B98, },	/* 20-17  8AAF  官 */
	{ 0x3432, 0x5BDB, },	/* 20-18  8AB0  寛 */
	{ 0x3433, 0x5E72, },	/* 20-19  8AB1  干 */
	{ 0x3434, 0x5E79, },	/* 20-20  8AB2  幹 */
	{ 0x3435, 0x60A3, },	/* 20-21  8AB3  患 */
	{ 0x3436, 0x611F, },	/* 20-22  8AB4  感 */
	{ 0x3437, 0x6163, },	/* 20-23  8AB5  慣 */
	{ 0x3438, 0x61BE, },	/* 20-24  8AB6  憾 */
	{ 0x3439, 0x63DB, },	/* 20-25  8AB7  換 */
	{ 0x343A, 0x6562, },	/* 20-26  8AB8  敢 */
	{ 0x343B, 0x67D1, },	/* 20-27  8AB9  柑 */
	{ 0x343C, 0x6853, },	/* 20-28  8ABA  桓 */
	{ 0x343D, 0x68FA, },	/* 20-29  8ABB  棺 */
	{ 0x343E, 0x6B3E, },	/* 20-30  8ABC  款 */
	{ 0x343F, 0x6B53, },	/* 20-31  8ABD  歓 */
	{ 0x3440, 0x6C57, },	/* 20-32  8ABE  汗 */
	{ 0x3441, 0x6F22, },	/* 20-33  8ABF  漢 */
	{ 0x3442, 0x6F97, },	/* 20-34  8AC0  澗 */
	{ 0x3443, 0x6F45, },	/* 20-35  8AC1  潅 */
	{ 0x3444, 0x74B0, },	/* 20-36  8AC2  環 */
	{ 0x3445, 0x7518, },	/* 20-37  8AC3  甘 */
	{ 0x3446, 0x76E3, },	/* 20-38  8AC4  監 */
	{ 0x3447, 0x770B, },	/* 20-39  8AC5  看 */
	{ 0x3448, 0x7AFF, },	/* 20-40  8AC6  竿 */
	{ 0x3449, 0x7BA1, },	/* 20-41  8AC7  管 */
	{ 0x344A, 0x7C21, },	/* 20-42  8AC8  簡 */
	{ 0x344B, 0x7DE9, },	/* 20-43  8AC9  緩 */
	{ 0x344C, 0x7F36, },	/* 20-44  8ACA  缶 */
	{ 0x344D, 0x7FF0, },	/* 20-45  8ACB  翰 */
	{ 0x344E, 0x809D, },	/* 20-46  8ACC  肝 */
	{ 0x344F, 0x8266, },	/* 20-47  8ACD  艦 */
	{ 0x3450, 0x839E, },	/* 20-48  8ACE  莞 */
	{ 0x3451, 0x89B3, },	/* 20-49  8ACF  観 */
	{ 0x3452, 0x8ACC, },	/* 20-50  8AD0  諌 */
	{ 0x3453, 0x8CAB, },	/* 20-51  8AD1  貫 */
	{ 0x3454, 0x9084, },	/* 20-52  8AD2  還 */
	{ 0x3455, 0x9451, },	/* 20-53  8AD3  鑑 */
	{ 0x3456, 0x9593, },	/* 20-54  8AD4  間 */
	{ 0x3457, 0x9591, },	/* 20-55  8AD5  閑 */
	{ 0x3458, 0x95A2, },	/* 20-56  8AD6  関 */
	{ 0x3459, 0x9665, },	/* 20-57  8AD7  陥 */
	{ 0x345A, 0x97D3, },	/* 20-58  8AD8  韓 */
	{ 0x345B, 0x9928, },	/* 20-59  8AD9  館 */
	{ 0x345C, 0x8218, },	/* 20-60  8ADA  舘 */
	{ 0x345D, 0x4E38, },	/* 20-61  8ADB  丸 */
	{ 0x345E, 0x542B, },	/* 20-62  8ADC  含 */
	{ 0x345F, 0x5CB8, },	/* 20-63  8ADD  岸 */
	{ 0x3460, 0x5DCC, },	/* 20-64  8ADE  巌 */
	{ 0x3461, 0x73A9, },	/* 20-65  8ADF  玩 */
	{ 0x3462, 0x764C, },	/* 20-66  8AE0  癌 */
	{ 0x3463, 0x773C, },	/* 20-67  8AE1  眼 */
	{ 0x3464, 0x5CA9, },	/* 20-68  8AE2  岩 */
	{ 0x3465, 0x7FEB, },	/* 20-69  8AE3  翫 */
	{ 0x3466, 0x8D0B, },	/* 20-70  8AE4  贋 */
	{ 0x3467, 0x96C1, },	/* 20-71  8AE5  雁 */
	{ 0x3468, 0x9811, },	/* 20-72  8AE6  頑 */
	{ 0x3469, 0x9854, },	/* 20-73  8AE7  顔 */
	{ 0x346A, 0x9858, },	/* 20-74  8AE8  願 */
	{ 0x346B, 0x4F01, },	/* 20-75  8AE9  企 */
	{ 0x346C, 0x4F0E, },	/* 20-76  8AEA  伎 */
	{ 0x346D, 0x5371, },	/* 20-77  8AEB  危 */
	{ 0x346E, 0x559C, },	/* 20-78  8AEC  喜 */
	{ 0x346F, 0x5668, },	/* 20-79  8AED  器 */
	{ 0x3470, 0x57FA, },	/* 20-80  8AEE  基 */
	{ 0x3471, 0x5947, },	/* 20-81  8AEF  奇 */
	{ 0x3472, 0x5B09, },	/* 20-82  8AF0  嬉 */
	{ 0x3473, 0x5BC4, },	/* 20-83  8AF1  寄 */
	{ 0x3474, 0x5C90, },	/* 20-84  8AF2  岐 */
	{ 0x3475, 0x5E0C, },	/* 20-85  8AF3  希 */
	{ 0x3476, 0x5E7E, },	/* 20-86  8AF4  幾 */
	{ 0x3477, 0x5FCC, },	/* 20-87  8AF5  忌 */
	{ 0x3478, 0x63EE, },	/* 20-88  8AF6  揮 */
	{ 0x3479, 0x673A, },	/* 20-89  8AF7  机 */
	{ 0x347A, 0x65D7, },	/* 20-90  8AF8  旗 */
	{ 0x347B, 0x65E2, },	/* 20-91  8AF9  既 */
	{ 0x347C, 0x671F, },	/* 20-92  8AFA  期 */
	{ 0x347D, 0x68CB, },	/* 20-93  8AFB  棋 */
	{ 0x347E, 0x68C4, },	/* 20-94  8AFC  棄 */
	{ 0x3521, 0x6A5F, },	/* 21-01  8B40  機 */
	{ 0x3522, 0x5E30, },	/* 21-02  8B41  帰 */
	{ 0x3523, 0x6BC5, },	/* 21-03  8B42  毅 */
	{ 0x3524, 0x6C17, },	/* 21-04  8B43  気 */
	{ 0x3525, 0x6C7D, },	/* 21-05  8B44  汽 */
	{ 0x3526, 0x757F, },	/* 21-06  8B45  畿 */
	{ 0x3527, 0x7948, },	/* 21-07  8B46  祈 */
	{ 0x3528, 0x5B63, },	/* 21-08  8B47  季 */
	{ 0x3529, 0x7A00, },	/* 21-09  8B48  稀 */
	{ 0x352A, 0x7D00, },	/* 21-10  8B49  紀 */
	{ 0x352B, 0x5FBD, },	/* 21-11  8B4A  徽 */
	{ 0x352C, 0x898F, },	/* 21-12  8B4B  規 */
	{ 0x352D, 0x8A18, },	/* 21-13  8B4C  記 */
	{ 0x352E, 0x8CB4, },	/* 21-14  8B4D  貴 */
	{ 0x352F, 0x8D77, },	/* 21-15  8B4E  起 */
	{ 0x3530, 0x8ECC, },	/* 21-16  8B4F  軌 */
	{ 0x3531, 0x8F1D, },	/* 21-17  8B50  輝 */
	{ 0x3532, 0x98E2, },	/* 21-18  8B51  飢 */
	{ 0x3533, 0x9A0E, },	/* 21-19  8B52  騎 */
	{ 0x3534, 0x9B3C, },	/* 21-20  8B53  鬼 */
	{ 0x3535, 0x4E80, },	/* 21-21  8B54  亀 */
	{ 0x3536, 0x507D, },	/* 21-22  8B55  偽 */
	{ 0x3537, 0x5100, },	/* 21-23  8B56  儀 */
	{ 0x3538, 0x5993, },	/* 21-24  8B57  妓 */
	{ 0x3539, 0x5B9C, },	/* 21-25  8B58  宜 */
	{ 0x353A, 0x622F, },	/* 21-26  8B59  戯 */
	{ 0x353B, 0x6280, },	/* 21-27  8B5A  技 */
	{ 0x353C, 0x64EC, },	/* 21-28  8B5B  擬 */
	{ 0x353D, 0x6B3A, },	/* 21-29  8B5C  欺 */
	{ 0x353E, 0x72A0, },	/* 21-30  8B5D  犠 */
	{ 0x353F, 0x7591, },	/* 21-31  8B5E  疑 */
	{ 0x3540, 0x7947, },	/* 21-32  8B5F  祇 */
	{ 0x3541, 0x7FA9, },	/* 21-33  8B60  義 */
	{ 0x3542, 0x87FB, },	/* 21-34  8B61  蟻 */
	{ 0x3543, 0x8ABC, },	/* 21-35  8B62  誼 */
	{ 0x3544, 0x8B70, },	/* 21-36  8B63  議 */
	{ 0x3545, 0x63AC, },	/* 21-37  8B64  掬 */
	{ 0x3546, 0x83CA, },	/* 21-38  8B65  菊 */
	{ 0x3547, 0x97A0, },	/* 21-39  8B66  鞠 */
	{ 0x3548, 0x5409, },	/* 21-40  8B67  吉 */
	{ 0x3549, 0x5403, },	/* 21-41  8B68  吃 */
	{ 0x354A, 0x55AB, },	/* 21-42  8B69  喫 */
	{ 0x354B, 0x6854, },	/* 21-43  8B6A  桔 */
	{ 0x354C, 0x6A58, },	/* 21-44  8B6B  橘 */
	{ 0x354D, 0x8A70, },	/* 21-45  8B6C  詰 */
	{ 0x354E, 0x7827, },	/* 21-46  8B6D  砧 */
	{ 0x354F, 0x6775, },	/* 21-47  8B6E  杵 */
	{ 0x3550, 0x9ECD, },	/* 21-48  8B6F  黍 */
	{ 0x3551, 0x5374, },	/* 21-49  8B70  却 */
	{ 0x3552, 0x5BA2, },	/* 21-50  8B71  客 */
	{ 0x3553, 0x811A, },	/* 21-51  8B72  脚 */
	{ 0x3554, 0x8650, },	/* 21-52  8B73  虐 */
	{ 0x3555, 0x9006, },	/* 21-53  8B74  逆 */
	{ 0x3556, 0x4E18, },	/* 21-54  8B75  丘 */
	{ 0x3557, 0x4E45, },	/* 21-55  8B76  久 */
	{ 0x3558, 0x4EC7, },	/* 21-56  8B77  仇 */
	{ 0x3559, 0x4F11, },	/* 21-57  8B78  休 */
	{ 0x355A, 0x53CA, },	/* 21-58  8B79  及 */
	{ 0x355B, 0x5438, },	/* 21-59  8B7A  吸 */
	{ 0x355C, 0x5BAE, },	/* 21-60  8B7B  宮 */
	{ 0x355D, 0x5F13, },	/* 21-61  8B7C  弓 */
	{ 0x355E, 0x6025, },	/* 21-62  8B7D  急 */
	{ 0x355F, 0x6551, },	/* 21-63  8B7E  救 */
	{ 0x3560, 0x673D, },	/* 21-64  8B80  朽 */
	{ 0x3561, 0x6C42, },	/* 21-65  8B81  求 */
	{ 0x3562, 0x6C72, },	/* 21-66  8B82  汲 */
	{ 0x3563, 0x6CE3, },	/* 21-67  8B83  泣 */
	{ 0x3564, 0x7078, },	/* 21-68  8B84  灸 */
	{ 0x3565, 0x7403, },	/* 21-69  8B85  球 */
	{ 0x3566, 0x7A76, },	/* 21-70  8B86  究 */
	{ 0x3567, 0x7AAE, },	/* 21-71  8B87  窮 */
	{ 0x3568, 0x7B08, },	/* 21-72  8B88  笈 */
	{ 0x3569, 0x7D1A, },	/* 21-73  8B89  級 */
	{ 0x356A, 0x7CFE, },	/* 21-74  8B8A  糾 */
	{ 0x356B, 0x7D66, },	/* 21-75  8B8B  給 */
	{ 0x356C, 0x65E7, },	/* 21-76  8B8C  旧 */
	{ 0x356D, 0x725B, },	/* 21-77  8B8D  牛 */
	{ 0x356E, 0x53BB, },	/* 21-78  8B8E  去 */
	{ 0x356F, 0x5C45, },	/* 21-79  8B8F  居 */
	{ 0x3570, 0x5DE8, },	/* 21-80  8B90  巨 */
	{ 0x3571, 0x62D2, },	/* 21-81  8B91  拒 */
	{ 0x3572, 0x62E0, },	/* 21-82  8B92  拠 */
	{ 0x3573, 0x6319, },	/* 21-83  8B93  挙 */
	{ 0x3574, 0x6E20, },	/* 21-84  8B94  渠 */
	{ 0x3575, 0x865A, },	/* 21-85  8B95  虚 */
	{ 0x3576, 0x8A31, },	/* 21-86  8B96  許 */
	{ 0x3577, 0x8DDD, },	/* 21-87  8B97  距 */
	{ 0x3578, 0x92F8, },	/* 21-88  8B98  鋸 */
	{ 0x3579, 0x6F01, },	/* 21-89  8B99  漁 */
	{ 0x357A, 0x79A6, },	/* 21-90  8B9A  禦 */
	{ 0x357B, 0x9B5A, },	/* 21-91  8B9B  魚 */
	{ 0x357C, 0x4EA8, },	/* 21-92  8B9C  亨 */
	{ 0x357D, 0x4EAB, },	/* 21-93  8B9D  享 */
	{ 0x357E, 0x4EAC, },	/* 21-94  8B9E  京 */
	{ 0x3621, 0x4F9B, },	/* 22-01  8B9F  供 */
	{ 0x3622, 0x4FA0, },	/* 22-02  8BA0  侠 */
	{ 0x3623, 0x50D1, },	/* 22-03  8BA1  僑 */
	{ 0x3624, 0x5147, },	/* 22-04  8BA2  兇 */
	{ 0x3625, 0x7AF6, },	/* 22-05  8BA3  競 */
	{ 0x3626, 0x5171, },	/* 22-06  8BA4  共 */
	{ 0x3627, 0x51F6, },	/* 22-07  8BA5  凶 */
	{ 0x3628, 0x5354, },	/* 22-08  8BA6  協 */
	{ 0x3629, 0x5321, },	/* 22-09  8BA7  匡 */
	{ 0x362A, 0x537F, },	/* 22-10  8BA8  卿 */
	{ 0x362B, 0x53EB, },	/* 22-11  8BA9  叫 */
	{ 0x362C, 0x55AC, },	/* 22-12  8BAA  喬 */
	{ 0x362D, 0x5883, },	/* 22-13  8BAB  境 */
	{ 0x362E, 0x5CE1, },	/* 22-14  8BAC  峡 */
	{ 0x362F, 0x5F37, },	/* 22-15  8BAD  強 */
	{ 0x3630, 0x5F4A, },	/* 22-16  8BAE  彊 */
	{ 0x3631, 0x602F, },	/* 22-17  8BAF  怯 */
	{ 0x3632, 0x6050, },	/* 22-18  8BB0  恐 */
	{ 0x3633, 0x606D, },	/* 22-19  8BB1  恭 */
	{ 0x3634, 0x631F, },	/* 22-20  8BB2  挟 */
	{ 0x3635, 0x6559, },	/* 22-21  8BB3  教 */
	{ 0x3636, 0x6A4B, },	/* 22-22  8BB4  橋 */
	{ 0x3637, 0x6CC1, },	/* 22-23  8BB5  況 */
	{ 0x3638, 0x72C2, },	/* 22-24  8BB6  狂 */
	{ 0x3639, 0x72ED, },	/* 22-25  8BB7  狭 */
	{ 0x363A, 0x77EF, },	/* 22-26  8BB8  矯 */
	{ 0x363B, 0x80F8, },	/* 22-27  8BB9  胸 */
	{ 0x363C, 0x8105, },	/* 22-28  8BBA  脅 */
	{ 0x363D, 0x8208, },	/* 22-29  8BBB  興 */
	{ 0x363E, 0x854E, },	/* 22-30  8BBC  蕎 */
	{ 0x363F, 0x90F7, },	/* 22-31  8BBD  郷 */
	{ 0x3640, 0x93E1, },	/* 22-32  8BBE  鏡 */
	{ 0x3641, 0x97FF, },	/* 22-33  8BBF  響 */
	{ 0x3642, 0x9957, },	/* 22-34  8BC0  饗 */
	{ 0x3643, 0x9A5A, },	/* 22-35  8BC1  驚 */
	{ 0x3644, 0x4EF0, },	/* 22-36  8BC2  仰 */
	{ 0x3645, 0x51DD, },	/* 22-37  8BC3  凝 */
	{ 0x3646, 0x5C2D, },	/* 22-38  8BC4  尭 */
	{ 0x3647, 0x6681, },	/* 22-39  8BC5  暁 */
	{ 0x3648, 0x696D, },	/* 22-40  8BC6  業 */
	{ 0x3649, 0x5C40, },	/* 22-41  8BC7  局 */
	{ 0x364A, 0x66F2, },	/* 22-42  8BC8  曲 */
	{ 0x364B, 0x6975, },	/* 22-43  8BC9  極 */
	{ 0x364C, 0x7389, },	/* 22-44  8BCA  玉 */
	{ 0x364D, 0x6850, },	/* 22-45  8BCB  桐 */
	{ 0x364E, 0x7C81, },	/* 22-46  8BCC  粁 */
	{ 0x364F, 0x50C5, },	/* 22-47  8BCD  僅 */
	{ 0x3650, 0x52E4, },	/* 22-48  8BCE  勤 */
	{ 0x3651, 0x5747, },	/* 22-49  8BCF  均 */
	{ 0x3652, 0x5DFE, },	/* 22-50  8BD0  巾 */
	{ 0x3653, 0x9326, },	/* 22-51  8BD1  錦 */
	{ 0x3654, 0x65A4, },	/* 22-52  8BD2  斤 */
	{ 0x3655, 0x6B23, },	/* 22-53  8BD3  欣 */
	{ 0x3656, 0x6B3D, },	/* 22-54  8BD4  欽 */
	{ 0x3657, 0x7434, },	/* 22-55  8BD5  琴 */
	{ 0x3658, 0x7981, },	/* 22-56  8BD6  禁 */
	{ 0x3659, 0x79BD, },	/* 22-57  8BD7  禽 */
	{ 0x365A, 0x7B4B, },	/* 22-58  8BD8  筋 */
	{ 0x365B, 0x7DCA, },	/* 22-59  8BD9  緊 */
	{ 0x365C, 0x82B9, },	/* 22-60  8BDA  芹 */
	{ 0x365D, 0x83CC, },	/* 22-61  8BDB  菌 */
	{ 0x365E, 0x887F, },	/* 22-62  8BDC  衿 */
	{ 0x365F, 0x895F, },	/* 22-63  8BDD  襟 */
	{ 0x3660, 0x8B39, },	/* 22-64  8BDE  謹 */
	{ 0x3661, 0x8FD1, },	/* 22-65  8BDF  近 */
	{ 0x3662, 0x91D1, },	/* 22-66  8BE0  金 */
	{ 0x3663, 0x541F, },	/* 22-67  8BE1  吟 */
	{ 0x3664, 0x9280, },	/* 22-68  8BE2  銀 */
	{ 0x3665, 0x4E5D, },	/* 22-69  8BE3  九 */
	{ 0x3666, 0x5036, },	/* 22-70  8BE4  倶 */
	{ 0x3667, 0x53E5, },	/* 22-71  8BE5  句 */
	{ 0x3668, 0x533A, },	/* 22-72  8BE6  区 */
	{ 0x3669, 0x72D7, },	/* 22-73  8BE7  狗 */
	{ 0x366A, 0x7396, },	/* 22-74  8BE8  玖 */
	{ 0x366B, 0x77E9, },	/* 22-75  8BE9  矩 */
	{ 0x366C, 0x82E6, },	/* 22-76  8BEA  苦 */
	{ 0x366D, 0x8EAF, },	/* 22-77  8BEB  躯 */
	{ 0x366E, 0x99C6, },	/* 22-78  8BEC  駆 */
	{ 0x366F, 0x99C8, },	/* 22-79  8BED  駈 */
	{ 0x3670, 0x99D2, },	/* 22-80  8BEE  駒 */
	{ 0x3671, 0x5177, },	/* 22-81  8BEF  具 */
	{ 0x3672, 0x611A, },	/* 22-82  8BF0  愚 */
	{ 0x3673, 0x865E, },	/* 22-83  8BF1  虞 */
	{ 0x3674, 0x55B0, },	/* 22-84  8BF2  喰 */
	{ 0x3675, 0x7A7A, },	/* 22-85  8BF3  空 */
	{ 0x3676, 0x5076, },	/* 22-86  8BF4  偶 */
	{ 0x3677, 0x5BD3, },	/* 22-87  8BF5  寓 */
	{ 0x3678, 0x9047, },	/* 22-88  8BF6  遇 */
	{ 0x3679, 0x9685, },	/* 22-89  8BF7  隅 */
	{ 0x367A, 0x4E32, },	/* 22-90  8BF8  串 */
	{ 0x367B, 0x6ADB, },	/* 22-91  8BF9  櫛 */
	{ 0x367C, 0x91E7, },	/* 22-92  8BFA  釧 */
	{ 0x367D, 0x5C51, },	/* 22-93  8BFB  屑 */
	{ 0x367E, 0x5C48, },	/* 22-94  8BFC  屈 */
	{ 0x3721, 0x6398, },	/* 23-01  8C40  掘 */
	{ 0x3722, 0x7A9F, },	/* 23-02  8C41  窟 */
	{ 0x3723, 0x6C93, },	/* 23-03  8C42  沓 */
	{ 0x3724, 0x9774, },	/* 23-04  8C43  靴 */
	{ 0x3725, 0x8F61, },	/* 23-05  8C44  轡 */
	{ 0x3726, 0x7AAA, },	/* 23-06  8C45  窪 */
	{ 0x3727, 0x718A, },	/* 23-07  8C46  熊 */
	{ 0x3728, 0x9688, },	/* 23-08  8C47  隈 */
	{ 0x3729, 0x7C82, },	/* 23-09  8C48  粂 */
	{ 0x372A, 0x6817, },	/* 23-10  8C49  栗 */
	{ 0x372B, 0x7E70, },	/* 23-11  8C4A  繰 */
	{ 0x372C, 0x6851, },	/* 23-12  8C4B  桑 */
	{ 0x372D, 0x936C, },	/* 23-13  8C4C  鍬 */
	{ 0x372E, 0x52F2, },	/* 23-14  8C4D  勲 */
	{ 0x372F, 0x541B, },	/* 23-15  8C4E  君 */
	{ 0x3730, 0x85AB, },	/* 23-16  8C4F  薫 */
	{ 0x3731, 0x8A13, },	/* 23-17  8C50  訓 */
	{ 0x3732, 0x7FA4, },	/* 23-18  8C51  群 */
	{ 0x3733, 0x8ECD, },	/* 23-19  8C52  軍 */
	{ 0x3734, 0x90E1, },	/* 23-20  8C53  郡 */
	{ 0x3735, 0x5366, },	/* 23-21  8C54  卦 */
	{ 0x3736, 0x8888, },	/* 23-22  8C55  袈 */
	{ 0x3737, 0x7941, },	/* 23-23  8C56  祁 */
	{ 0x3738, 0x4FC2, },	/* 23-24  8C57  係 */
	{ 0x3739, 0x50BE, },	/* 23-25  8C58  傾 */
	{ 0x373A, 0x5211, },	/* 23-26  8C59  刑 */
	{ 0x373B, 0x5144, },	/* 23-27  8C5A  兄 */
	{ 0x373C, 0x5553, },	/* 23-28  8C5B  啓 */
	{ 0x373D, 0x572D, },	/* 23-29  8C5C  圭 */
	{ 0x373E, 0x73EA, },	/* 23-30  8C5D  珪 */
	{ 0x373F, 0x578B, },	/* 23-31  8C5E  型 */
	{ 0x3740, 0x5951, },	/* 23-32  8C5F  契 */
	{ 0x3741, 0x5F62, },	/* 23-33  8C60  形 */
	{ 0x3742, 0x5F84, },	/* 23-34  8C61  径 */
	{ 0x3743, 0x6075, },	/* 23-35  8C62  恵 */
	{ 0x3744, 0x6176, },	/* 23-36  8C63  慶 */
	{ 0x3745, 0x6167, },	/* 23-37  8C64  慧 */
	{ 0x3746, 0x61A9, },	/* 23-38  8C65  憩 */
	{ 0x3747, 0x63B2, },	/* 23-39  8C66  掲 */
	{ 0x3748, 0x643A, },	/* 23-40  8C67  携 */
	{ 0x3749, 0x656C, },	/* 23-41  8C68  敬 */
	{ 0x374A, 0x666F, },	/* 23-42  8C69  景 */
	{ 0x374B, 0x6842, },	/* 23-43  8C6A  桂 */
	{ 0x374C, 0x6E13, },	/* 23-44  8C6B  渓 */
	{ 0x374D, 0x7566, },	/* 23-45  8C6C  畦 */
	{ 0x374E, 0x7A3D, },	/* 23-46  8C6D  稽 */
	{ 0x374F, 0x7CFB, },	/* 23-47  8C6E  系 */
	{ 0x3750, 0x7D4C, },	/* 23-48  8C6F  経 */
	{ 0x3751, 0x7D99, },	/* 23-49  8C70  継 */
	{ 0x3752, 0x7E4B, },	/* 23-50  8C71  繋 */
	{ 0x3753, 0x7F6B, },	/* 23-51  8C72  罫 */
	{ 0x3754, 0x830E, },	/* 23-52  8C73  茎 */
	{ 0x3755, 0x834A, },	/* 23-53  8C74  荊 */
	{ 0x3756, 0x86CD, },	/* 23-54  8C75  蛍 */
	{ 0x3757, 0x8A08, },	/* 23-55  8C76  計 */
	{ 0x3758, 0x8A63, },	/* 23-56  8C77  詣 */
	{ 0x3759, 0x8B66, },	/* 23-57  8C78  警 */
	{ 0x375A, 0x8EFD, },	/* 23-58  8C79  軽 */
	{ 0x375B, 0x981A, },	/* 23-59  8C7A  頚 */
	{ 0x375C, 0x9D8F, },	/* 23-60  8C7B  鶏 */
	{ 0x375D, 0x82B8, },	/* 23-61  8C7C  芸 */
	{ 0x375E, 0x8FCE, },	/* 23-62  8C7D  迎 */
	{ 0x375F, 0x9BE8, },	/* 23-63  8C7E  鯨 */
	{ 0x3760, 0x5287, },	/* 23-64  8C80  劇 */
	{ 0x3761, 0x621F, },	/* 23-65  8C81  戟 */
	{ 0x3762, 0x6483, },	/* 23-66  8C82  撃 */
	{ 0x3763, 0x6FC0, },	/* 23-67  8C83  激 */
	{ 0x3764, 0x9699, },	/* 23-68  8C84  隙 */
	{ 0x3765, 0x6841, },	/* 23-69  8C85  桁 */
	{ 0x3766, 0x5091, },	/* 23-70  8C86  傑 */
	{ 0x3767, 0x6B20, },	/* 23-71  8C87  欠 */
	{ 0x3768, 0x6C7A, },	/* 23-72  8C88  決 */
	{ 0x3769, 0x6F54, },	/* 23-73  8C89  潔 */
	{ 0x376A, 0x7A74, },	/* 23-74  8C8A  穴 */
	{ 0x376B, 0x7D50, },	/* 23-75  8C8B  結 */
	{ 0x376C, 0x8840, },	/* 23-76  8C8C  血 */
	{ 0x376D, 0x8A23, },	/* 23-77  8C8D  訣 */
	{ 0x376E, 0x6708, },	/* 23-78  8C8E  月 */
	{ 0x376F, 0x4EF6, },	/* 23-79  8C8F  件 */
	{ 0x3770, 0x5039, },	/* 23-80  8C90  倹 */
	{ 0x3771, 0x5026, },	/* 23-81  8C91  倦 */
	{ 0x3772, 0x5065, },	/* 23-82  8C92  健 */
	{ 0x3773, 0x517C, },	/* 23-83  8C93  兼 */
	{ 0x3774, 0x5238, },	/* 23-84  8C94  券 */
	{ 0x3775, 0x5263, },	/* 23-85  8C95  剣 */
	{ 0x3776, 0x55A7, },	/* 23-86  8C96  喧 */
	{ 0x3777, 0x570F, },	/* 23-87  8C97  圏 */
	{ 0x3778, 0x5805, },	/* 23-88  8C98  堅 */
	{ 0x3779, 0x5ACC, },	/* 23-89  8C99  嫌 */
	{ 0x377A, 0x5EFA, },	/* 23-90  8C9A  建 */
	{ 0x377B, 0x61B2, },	/* 23-91  8C9B  憲 */
	{ 0x377C, 0x61F8, },	/* 23-92  8C9C  懸 */
	{ 0x377D, 0x62F3, },	/* 23-93  8C9D  拳 */
	{ 0x377E, 0x6372, },	/* 23-94  8C9E  捲 */
	{ 0x3821, 0x691C, },	/* 24-01  8C9F  検 */
	{ 0x3822, 0x6A29, },	/* 24-02  8CA0  権 */
	{ 0x3823, 0x727D, },	/* 24-03  8CA1  牽 */
	{ 0x3824, 0x72AC, },	/* 24-04  8CA2  犬 */
	{ 0x3825, 0x732E, },	/* 24-05  8CA3  献 */
	{ 0x3826, 0x7814, },	/* 24-06  8CA4  研 */
	{ 0x3827, 0x786F, },	/* 24-07  8CA5  硯 */
	{ 0x3828, 0x7D79, },	/* 24-08  8CA6  絹 */
	{ 0x3829, 0x770C, },	/* 24-09  8CA7  県 */
	{ 0x382A, 0x80A9, },	/* 24-10  8CA8  肩 */
	{ 0x382B, 0x898B, },	/* 24-11  8CA9  見 */
	{ 0x382C, 0x8B19, },	/* 24-12  8CAA  謙 */
	{ 0x382D, 0x8CE2, },	/* 24-13  8CAB  賢 */
	{ 0x382E, 0x8ED2, },	/* 24-14  8CAC  軒 */
	{ 0x382F, 0x9063, },	/* 24-15  8CAD  遣 */
	{ 0x3830, 0x9375, },	/* 24-16  8CAE  鍵 */
	{ 0x3831, 0x967A, },	/* 24-17  8CAF  険 */
	{ 0x3832, 0x9855, },	/* 24-18  8CB0  顕 */
	{ 0x3833, 0x9A13, },	/* 24-19  8CB1  験 */
	{ 0x3834, 0x9E78, },	/* 24-20  8CB2  鹸 */
	{ 0x3835, 0x5143, },	/* 24-21  8CB3  元 */
	{ 0x3836, 0x539F, },	/* 24-22  8CB4  原 */
	{ 0x3837, 0x53B3, },	/* 24-23  8CB5  厳 */
	{ 0x3838, 0x5E7B, },	/* 24-24  8CB6  幻 */
	{ 0x3839, 0x5F26, },	/* 24-25  8CB7  弦 */
	{ 0x383A, 0x6E1B, },	/* 24-26  8CB8  減 */
	{ 0x383B, 0x6E90, },	/* 24-27  8CB9  源 */
	{ 0x383C, 0x7384, },	/* 24-28  8CBA  玄 */
	{ 0x383D, 0x73FE, },	/* 24-29  8CBB  現 */
	{ 0x383E, 0x7D43, },	/* 24-30  8CBC  絃 */
	{ 0x383F, 0x8237, },	/* 24-31  8CBD  舷 */
	{ 0x3840, 0x8A00, },	/* 24-32  8CBE  言 */
	{ 0x3841, 0x8AFA, },	/* 24-33  8CBF  諺 */
	{ 0x3842, 0x9650, },	/* 24-34  8CC0  限 */
	{ 0x3843, 0x4E4E, },	/* 24-35  8CC1  乎 */
	{ 0x3844, 0x500B, },	/* 24-36  8CC2  個 */
	{ 0x3845, 0x53E4, },	/* 24-37  8CC3  古 */
	{ 0x3846, 0x547C, },	/* 24-38  8CC4  呼 */
	{ 0x3847, 0x56FA, },	/* 24-39  8CC5  固 */
	{ 0x3848, 0x59D1, },	/* 24-40  8CC6  姑 */
	{ 0x3849, 0x5B64, },	/* 24-41  8CC7  孤 */
	{ 0x384A, 0x5DF1, },	/* 24-42  8CC8  己 */
	{ 0x384B, 0x5EAB, },	/* 24-43  8CC9  庫 */
	{ 0x384C, 0x5F27, },	/* 24-44  8CCA  弧 */
	{ 0x384D, 0x6238, },	/* 24-45  8CCB  戸 */
	{ 0x384E, 0x6545, },	/* 24-46  8CCC  故 */
	{ 0x384F, 0x67AF, },	/* 24-47  8CCD  枯 */
	{ 0x3850, 0x6E56, },	/* 24-48  8CCE  湖 */
	{ 0x3851, 0x72D0, },	/* 24-49  8CCF  狐 */
	{ 0x3852, 0x7CCA, },	/* 24-50  8CD0  糊 */
	{ 0x3853, 0x88B4, },	/* 24-51  8CD1  袴 */
	{ 0x3854, 0x80A1, },	/* 24-52  8CD2  股 */
	{ 0x3855, 0x80E1, },	/* 24-53  8CD3  胡 */
	{ 0x3856, 0x83F0, },	/* 24-54  8CD4  菰 */
	{ 0x3857, 0x864E, },	/* 24-55  8CD5  虎 */
	{ 0x3858, 0x8A87, },	/* 24-56  8CD6  誇 */
	{ 0x3859, 0x8DE8, },	/* 24-57  8CD7  跨 */
	{ 0x385A, 0x9237, },	/* 24-58  8CD8  鈷 */
	{ 0x385B, 0x96C7, },	/* 24-59  8CD9  雇 */
	{ 0x385C, 0x9867, },	/* 24-60  8CDA  顧 */
	{ 0x385D, 0x9F13, },	/* 24-61  8CDB  鼓 */
	{ 0x385E, 0x4E94, },	/* 24-62  8CDC  五 */
	{ 0x385F, 0x4E92, },	/* 24-63  8CDD  互 */
	{ 0x3860, 0x4F0D, },	/* 24-64  8CDE  伍 */
	{ 0x3861, 0x5348, },	/* 24-65  8CDF  午 */
	{ 0x3862, 0x5449, },	/* 24-66  8CE0  呉 */
	{ 0x3863, 0x543E, },	/* 24-67  8CE1  吾 */
	{ 0x3864, 0x5A2F, },	/* 24-68  8CE2  娯 */
	{ 0x3865, 0x5F8C, },	/* 24-69  8CE3  後 */
	{ 0x3866, 0x5FA1, },	/* 24-70  8CE4  御 */
	{ 0x3867, 0x609F, },	/* 24-71  8CE5  悟 */
	{ 0x3868, 0x68A7, },	/* 24-72  8CE6  梧 */
	{ 0x3869, 0x6A8E, },	/* 24-73  8CE7  檎 */
	{ 0x386A, 0x745A, },	/* 24-74  8CE8  瑚 */
	{ 0x386B, 0x7881, },	/* 24-75  8CE9  碁 */
	{ 0x386C, 0x8A9E, },	/* 24-76  8CEA  語 */
	{ 0x386D, 0x8AA4, },	/* 24-77  8CEB  誤 */
	{ 0x386E, 0x8B77, },	/* 24-78  8CEC  護 */
	{ 0x386F, 0x9190, },	/* 24-79  8CED  醐 */
	{ 0x3870, 0x4E5E, },	/* 24-80  8CEE  乞 */
	{ 0x3871, 0x9BC9, },	/* 24-81  8CEF  鯉 */
	{ 0x3872, 0x4EA4, },	/* 24-82  8CF0  交 */
	{ 0x3873, 0x4F7C, },	/* 24-83  8CF1  佼 */
	{ 0x3874, 0x4FAF, },	/* 24-84  8CF2  侯 */
	{ 0x3875, 0x5019, },	/* 24-85  8CF3  候 */
	{ 0x3876, 0x5016, },	/* 24-86  8CF4  倖 */
	{ 0x3877, 0x5149, },	/* 24-87  8CF5  光 */
	{ 0x3878, 0x516C, },	/* 24-88  8CF6  公 */
	{ 0x3879, 0x529F, },	/* 24-89  8CF7  功 */
	{ 0x387A, 0x52B9, },	/* 24-90  8CF8  効 */
	{ 0x387B, 0x52FE, },	/* 24-91  8CF9  勾 */
	{ 0x387C, 0x539A, },	/* 24-92  8CFA  厚 */
	{ 0x387D, 0x53E3, },	/* 24-93  8CFB  口 */
	{ 0x387E, 0x5411, },	/* 24-94  8CFC  向 */
	{ 0x3921, 0x540E, },	/* 25-01  8D40  后 */
	{ 0x3922, 0x5589, },	/* 25-02  8D41  喉 */
	{ 0x3923, 0x5751, },	/* 25-03  8D42  坑 */
	{ 0x3924, 0x57A2, },	/* 25-04  8D43  垢 */
	{ 0x3925, 0x597D, },	/* 25-05  8D44  好 */
	{ 0x3926, 0x5B54, },	/* 25-06  8D45  孔 */
	{ 0x3927, 0x5B5D, },	/* 25-07  8D46  孝 */
	{ 0x3928, 0x5B8F, },	/* 25-08  8D47  宏 */
	{ 0x3929, 0x5DE5, },	/* 25-09  8D48  工 */
	{ 0x392A, 0x5DE7, },	/* 25-10  8D49  巧 */
	{ 0x392B, 0x5DF7, },	/* 25-11  8D4A  巷 */
	{ 0x392C, 0x5E78, },	/* 25-12  8D4B  幸 */
	{ 0x392D, 0x5E83, },	/* 25-13  8D4C  広 */
	{ 0x392E, 0x5E9A, },	/* 25-14  8D4D  庚 */
	{ 0x392F, 0x5EB7, },	/* 25-15  8D4E  康 */
	{ 0x3930, 0x5F18, },	/* 25-16  8D4F  弘 */
	{ 0x3931, 0x6052, },	/* 25-17  8D50  恒 */
	{ 0x3932, 0x614C, },	/* 25-18  8D51  慌 */
	{ 0x3933, 0x6297, },	/* 25-19  8D52  抗 */
	{ 0x3934, 0x62D8, },	/* 25-20  8D53  拘 */
	{ 0x3935, 0x63A7, },	/* 25-21  8D54  控 */
	{ 0x3936, 0x653B, },	/* 25-22  8D55  攻 */
	{ 0x3937, 0x6602, },	/* 25-23  8D56  昂 */
	{ 0x3938, 0x6643, },	/* 25-24  8D57  晃 */
	{ 0x3939, 0x66F4, },	/* 25-25  8D58  更 */
	{ 0x393A, 0x676D, },	/* 25-26  8D59  杭 */
	{ 0x393B, 0x6821, },	/* 25-27  8D5A  校 */
	{ 0x393C, 0x6897, },	/* 25-28  8D5B  梗 */
	{ 0x393D, 0x69CB, },	/* 25-29  8D5C  構 */
	{ 0x393E, 0x6C5F, },	/* 25-30  8D5D  江 */
	{ 0x393F, 0x6D2A, },	/* 25-31  8D5E  洪 */
	{ 0x3940, 0x6D69, },	/* 25-32  8D5F  浩 */
	{ 0x3941, 0x6E2F, },	/* 25-33  8D60  港 */
	{ 0x3942, 0x6E9D, },	/* 25-34  8D61  溝 */
	{ 0x3943, 0x7532, },	/* 25-35  8D62  甲 */
	{ 0x3944, 0x7687, },	/* 25-36  8D63  皇 */
	{ 0x3945, 0x786C, },	/* 25-37  8D64  硬 */
	{ 0x3946, 0x7A3F, },	/* 25-38  8D65  稿 */
	{ 0x3947, 0x7CE0, },	/* 25-39  8D66  糠 */
	{ 0x3948, 0x7D05, },	/* 25-40  8D67  紅 */
	{ 0x3949, 0x7D18, },	/* 25-41  8D68  紘 */
	{ 0x394A, 0x7D5E, },	/* 25-42  8D69  絞 */
	{ 0x394B, 0x7DB1, },	/* 25-43  8D6A  綱 */
	{ 0x394C, 0x8015, },	/* 25-44  8D6B  耕 */
	{ 0x394D, 0x8003, },	/* 25-45  8D6C  考 */
	{ 0x394E, 0x80AF, },	/* 25-46  8D6D  肯 */
	{ 0x394F, 0x80B1, },	/* 25-47  8D6E  肱 */
	{ 0x3950, 0x8154, },	/* 25-48  8D6F  腔 */
	{ 0x3951, 0x818F, },	/* 25-49  8D70  膏 */
	{ 0x3952, 0x822A, },	/* 25-50  8D71  航 */
	{ 0x3953, 0x8352, },	/* 25-51  8D72  荒 */
	{ 0x3954, 0x884C, },	/* 25-52  8D73  行 */
	{ 0x3955, 0x8861, },	/* 25-53  8D74  衡 */
	{ 0x3956, 0x8B1B, },	/* 25-54  8D75  講 */
	{ 0x3957, 0x8CA2, },	/* 25-55  8D76  貢 */
	{ 0x3958, 0x8CFC, },	/* 25-56  8D77  購 */
	{ 0x3959, 0x90CA, },	/* 25-57  8D78  郊 */
	{ 0x395A, 0x9175, },	/* 25-58  8D79  酵 */
	{ 0x395B, 0x9271, },	/* 25-59  8D7A  鉱 */
	{ 0x395C, 0x783F, },	/* 25-60  8D7B  砿 */
	{ 0x395D, 0x92FC, },	/* 25-61  8D7C  鋼 */
	{ 0x395E, 0x95A4, },	/* 25-62  8D7D  閤 */
	{ 0x395F, 0x964D, },	/* 25-63  8D7E  降 */
	{ 0x3960, 0x9805, },	/* 25-64  8D80  項 */
	{ 0x3961, 0x9999, },	/* 25-65  8D81  香 */
	{ 0x3962, 0x9AD8, },	/* 25-66  8D82  高 */
	{ 0x3963, 0x9D3B, },	/* 25-67  8D83  鴻 */
	{ 0x3964, 0x525B, },	/* 25-68  8D84  剛 */
	{ 0x3965, 0x52AB, },	/* 25-69  8D85  劫 */
	{ 0x3966, 0x53F7, },	/* 25-70  8D86  号 */
	{ 0x3967, 0x5408, },	/* 25-71  8D87  合 */
	{ 0x3968, 0x58D5, },	/* 25-72  8D88  壕 */
	{ 0x3969, 0x62F7, },	/* 25-73  8D89  拷 */
	{ 0x396A, 0x6FE0, },	/* 25-74  8D8A  濠 */
	{ 0x396B, 0x8C6A, },	/* 25-75  8D8B  豪 */
	{ 0x396C, 0x8F5F, },	/* 25-76  8D8C  轟 */
	{ 0x396D, 0x9EB9, },	/* 25-77  8D8D  麹 */
	{ 0x396E, 0x514B, },	/* 25-78  8D8E  克 */
	{ 0x396F, 0x523B, },	/* 25-79  8D8F  刻 */
	{ 0x3970, 0x544A, },	/* 25-80  8D90  告 */
	{ 0x3971, 0x56FD, },	/* 25-81  8D91  国 */
	{ 0x3972, 0x7A40, },	/* 25-82  8D92  穀 */
	{ 0x3973, 0x9177, },	/* 25-83  8D93  酷 */
	{ 0x3974, 0x9D60, },	/* 25-84  8D94  鵠 */
	{ 0x3975, 0x9ED2, },	/* 25-85  8D95  黒 */
	{ 0x3976, 0x7344, },	/* 25-86  8D96  獄 */
	{ 0x3977, 0x6F09, },	/* 25-87  8D97  漉 */
	{ 0x3978, 0x8170, },	/* 25-88  8D98  腰 */
	{ 0x3979, 0x7511, },	/* 25-89  8D99  甑 */
	{ 0x397A, 0x5FFD, },	/* 25-90  8D9A  忽 */
	{ 0x397B, 0x60DA, },	/* 25-91  8D9B  惚 */
	{ 0x397C, 0x9AA8, },	/* 25-92  8D9C  骨 */
	{ 0x397D, 0x72DB, },	/* 25-93  8D9D  狛 */
	{ 0x397E, 0x8FBC, },	/* 25-94  8D9E  込 */
	{ 0x3A21, 0x6B64, },	/* 26-01  8D9F  此 */
	{ 0x3A22, 0x9803, },	/* 26-02  8DA0  頃 */
	{ 0x3A23, 0x4ECA, },	/* 26-03  8DA1  今 */
	{ 0x3A24, 0x56F0, },	/* 26-04  8DA2  困 */
	{ 0x3A25, 0x5764, },	/* 26-05  8DA3  坤 */
	{ 0x3A26, 0x58BE, },	/* 26-06  8DA4  墾 */
	{ 0x3A27, 0x5A5A, },	/* 26-07  8DA5  婚 */
	{ 0x3A28, 0x6068, },	/* 26-08  8DA6  恨 */
	{ 0x3A29, 0x61C7, },	/* 26-09  8DA7  懇 */
	{ 0x3A2A, 0x660F, },	/* 26-10  8DA8  昏 */
	{ 0x3A2B, 0x6606, },	/* 26-11  8DA9  昆 */
	{ 0x3A2C, 0x6839, },	/* 26-12  8DAA  根 */
	{ 0x3A2D, 0x68B1, },	/* 26-13  8DAB  梱 */
	{ 0x3A2E, 0x6DF7, },	/* 26-14  8DAC  混 */
	{ 0x3A2F, 0x75D5, },	/* 26-15  8DAD  痕 */
	{ 0x3A30, 0x7D3A, },	/* 26-16  8DAE  紺 */
	{ 0x3A31, 0x826E, },	/* 26-17  8DAF  艮 */
	{ 0x3A32, 0x9B42, },	/* 26-18  8DB0  魂 */
	{ 0x3A33, 0x4E9B, },	/* 26-19  8DB1  些 */
	{ 0x3A34, 0x4F50, },	/* 26-20  8DB2  佐 */
	{ 0x3A35, 0x53C9, },	/* 26-21  8DB3  叉 */
	{ 0x3A36, 0x5506, },	/* 26-22  8DB4  唆 */
	{ 0x3A37, 0x5D6F, },	/* 26-23  8DB5  嵯 */
	{ 0x3A38, 0x5DE6, },	/* 26-24  8DB6  左 */
	{ 0x3A39, 0x5DEE, },	/* 26-25  8DB7  差 */
	{ 0x3A3A, 0x67FB, },	/* 26-26  8DB8  査 */
	{ 0x3A3B, 0x6C99, },	/* 26-27  8DB9  沙 */
	{ 0x3A3C, 0x7473, },	/* 26-28  8DBA  瑳 */
	{ 0x3A3D, 0x7802, },	/* 26-29  8DBB  砂 */
	{ 0x3A3E, 0x8A50, },	/* 26-30  8DBC  詐 */
	{ 0x3A3F, 0x9396, },	/* 26-31  8DBD  鎖 */
	{ 0x3A40, 0x88DF, },	/* 26-32  8DBE  裟 */
	{ 0x3A41, 0x5750, },	/* 26-33  8DBF  坐 */
	{ 0x3A42, 0x5EA7, },	/* 26-34  8DC0  座 */
	{ 0x3A43, 0x632B, },	/* 26-35  8DC1  挫 */
	{ 0x3A44, 0x50B5, },	/* 26-36  8DC2  債 */
	{ 0x3A45, 0x50AC, },	/* 26-37  8DC3  催 */
	{ 0x3A46, 0x518D, },	/* 26-38  8DC4  再 */
	{ 0x3A47, 0x6700, },	/* 26-39  8DC5  最 */
	{ 0x3A48, 0x54C9, },	/* 26-40  8DC6  哉 */
	{ 0x3A49, 0x585E, },	/* 26-41  8DC7  塞 */
	{ 0x3A4A, 0x59BB, },	/* 26-42  8DC8  妻 */
	{ 0x3A4B, 0x5BB0, },	/* 26-43  8DC9  宰 */
	{ 0x3A4C, 0x5F69, },	/* 26-44  8DCA  彩 */
	{ 0x3A4D, 0x624D, },	/* 26-45  8DCB  才 */
	{ 0x3A4E, 0x63A1, },	/* 26-46  8DCC  採 */
	{ 0x3A4F, 0x683D, },	/* 26-47  8DCD  栽 */
	{ 0x3A50, 0x6B73, },	/* 26-48  8DCE  歳 */
	{ 0x3A51, 0x6E08, },	/* 26-49  8DCF  済 */
	{ 0x3A52, 0x707D, },	/* 26-50  8DD0  災 */
	{ 0x3A53, 0x91C7, },	/* 26-51  8DD1  采 */
	{ 0x3A54, 0x7280, },	/* 26-52  8DD2  犀 */
	{ 0x3A55, 0x7815, },	/* 26-53  8DD3  砕 */
	{ 0x3A56, 0x7826, },	/* 26-54  8DD4  砦 */
	{ 0x3A57, 0x796D, },	/* 26-55  8DD5  祭 */
	{ 0x3A58, 0x658E, },	/* 26-56  8DD6  斎 */
	{ 0x3A59, 0x7D30, },	/* 26-57  8DD7  細 */
	{ 0x3A5A, 0x83DC, },	/* 26-58  8DD8  菜 */
	{ 0x3A5B, 0x88C1, },	/* 26-59  8DD9  裁 */
	{ 0x3A5C, 0x8F09, },	/* 26-60  8DDA  載 */
	{ 0x3A5D, 0x969B, },	/* 26-61  8DDB  際 */
	{ 0x3A5E, 0x5264, },	/* 26-62  8DDC  剤 */
	{ 0x3A5F, 0x5728, },	/* 26-63  8DDD  在 */
	{ 0x3A60, 0x6750, },	/* 26-64  8DDE  材 */
	{ 0x3A61, 0x7F6A, },	/* 26-65  8DDF  罪 */
	{ 0x3A62, 0x8CA1, },	/* 26-66  8DE0  財 */
	{ 0x3A63, 0x51B4, },	/* 26-67  8DE1  冴 */
	{ 0x3A64, 0x5742, },	/* 26-68  8DE2  坂 */
	{ 0x3A65, 0x962A, },	/* 26-69  8DE3  阪 */
	{ 0x3A66, 0x583A, },	/* 26-70  8DE4  堺 */
	{ 0x3A67, 0x698A, },	/* 26-71  8DE5  榊 */
	{ 0x3A68, 0x80B4, },	/* 26-72  8DE6  肴 */
	{ 0x3A69, 0x54B2, },	/* 26-73  8DE7  咲 */
	{ 0x3A6A, 0x5D0E, },	/* 26-74  8DE8  崎 */
	{ 0x3A6B, 0x57FC, },	/* 26-75  8DE9  埼 */
	{ 0x3A6C, 0x7895, },	/* 26-76  8DEA  碕 */
	{ 0x3A6D, 0x9DFA, },	/* 26-77  8DEB  鷺 */
	{ 0x3A6E, 0x4F5C, },	/* 26-78  8DEC  作 */
	{ 0x3A6F, 0x524A, },	/* 26-79  8DED  削 */
	{ 0x3A70, 0x548B, },	/* 26-80  8DEE  咋 */
	{ 0x3A71, 0x643E, },	/* 26-81  8DEF  搾 */
	{ 0x3A72, 0x6628, },	/* 26-82  8DF0  昨 */
	{ 0x3A73, 0x6714, },	/* 26-83  8DF1  朔 */
	{ 0x3A74, 0x67F5, },	/* 26-84  8DF2  柵 */
	{ 0x3A75, 0x7A84, },	/* 26-85  8DF3  窄 */
	{ 0x3A76, 0x7B56, },	/* 26-86  8DF4  策 */
	{ 0x3A77, 0x7D22, },	/* 26-87  8DF5  索 */
	{ 0x3A78, 0x932F, },	/* 26-88  8DF6  錯 */
	{ 0x3A79, 0x685C, },	/* 26-89  8DF7  桜 */
	{ 0x3A7A, 0x9BAD, },	/* 26-90  8DF8  鮭 */
	{ 0x3A7B, 0x7B39, },	/* 26-91  8DF9  笹 */
	{ 0x3A7C, 0x5319, },	/* 26-92  8DFA  匙 */
	{ 0x3A7D, 0x518A, },	/* 26-93  8DFB  冊 */
	{ 0x3A7E, 0x5237, },	/* 26-94  8DFC  刷 */
	{ 0x3B21, 0x5BDF, },	/* 27-01  8E40  察 */
	{ 0x3B22, 0x62F6, },	/* 27-02  8E41  拶 */
	{ 0x3B23, 0x64AE, },	/* 27-03  8E42  撮 */
	{ 0x3B24, 0x64E6, },	/* 27-04  8E43  擦 */
	{ 0x3B25, 0x672D, },	/* 27-05  8E44  札 */
	{ 0x3B26, 0x6BBA, },	/* 27-06  8E45  殺 */
	{ 0x3B27, 0x85A9, },	/* 27-07  8E46  薩 */
	{ 0x3B28, 0x96D1, },	/* 27-08  8E47  雑 */
	{ 0x3B29, 0x7690, },	/* 27-09  8E48  皐 */
	{ 0x3B2A, 0x9BD6, },	/* 27-10  8E49  鯖 */
	{ 0x3B2B, 0x634C, },	/* 27-11  8E4A  捌 */
	{ 0x3B2C, 0x9306, },	/* 27-12  8E4B  錆 */
	{ 0x3B2D, 0x9BAB, },	/* 27-13  8E4C  鮫 */
	{ 0x3B2E, 0x76BF, },	/* 27-14  8E4D  皿 */
	{ 0x3B2F, 0x6652, },	/* 27-15  8E4E  晒 */
	{ 0x3B30, 0x4E09, },	/* 27-16  8E4F  三 */
	{ 0x3B31, 0x5098, },	/* 27-17  8E50  傘 */
	{ 0x3B32, 0x53C2, },	/* 27-18  8E51  参 */
	{ 0x3B33, 0x5C71, },	/* 27-19  8E52  山 */
	{ 0x3B34, 0x60E8, },	/* 27-20  8E53  惨 */
	{ 0x3B35, 0x6492, },	/* 27-21  8E54  撒 */
	{ 0x3B36, 0x6563, },	/* 27-22  8E55  散 */
	{ 0x3B37, 0x685F, },	/* 27-23  8E56  桟 */
	{ 0x3B38, 0x71E6, },	/* 27-24  8E57  燦 */
	{ 0x3B39, 0x73CA, },	/* 27-25  8E58  珊 */
	{ 0x3B3A, 0x7523, },	/* 27-26  8E59  産 */
	{ 0x3B3B, 0x7B97, },	/* 27-27  8E5A  算 */
	{ 0x3B3C, 0x7E82, },	/* 27-28  8E5B  纂 */
	{ 0x3B3D, 0x8695, },	/* 27-29  8E5C  蚕 */
	{ 0x3B3E, 0x8B83, },	/* 27-30  8E5D  讃 */
	{ 0x3B3F, 0x8CDB, },	/* 27-31  8E5E  賛 */
	{ 0x3B40, 0x9178, },	/* 27-32  8E5F  酸 */
	{ 0x3B41, 0x9910, },	/* 27-33  8E60  餐 */
	{ 0x3B42, 0x65AC, },	/* 27-34  8E61  斬 */
	{ 0x3B43, 0x66AB, },	/* 27-35  8E62  暫 */
	{ 0x3B44, 0x6B8B, },	/* 27-36  8E63  残 */
	{ 0x3B45, 0x4ED5, },	/* 27-37  8E64  仕 */
	{ 0x3B46, 0x4ED4, },	/* 27-38  8E65  仔 */
	{ 0x3B47, 0x4F3A, },	/* 27-39  8E66  伺 */
	{ 0x3B48, 0x4F7F, },	/* 27-40  8E67  使 */
	{ 0x3B49, 0x523A, },	/* 27-41  8E68  刺 */
	{ 0x3B4A, 0x53F8, },	/* 27-42  8E69  司 */
	{ 0x3B4B, 0x53F2, },	/* 27-43  8E6A  史 */
	{ 0x3B4C, 0x55E3, },	/* 27-44  8E6B  嗣 */
	{ 0x3B4D, 0x56DB, },	/* 27-45  8E6C  四 */
	{ 0x3B4E, 0x58EB, },	/* 27-46  8E6D  士 */
	{ 0x3B4F, 0x59CB, },	/* 27-47  8E6E  始 */
	{ 0x3B50, 0x59C9, },	/* 27-48  8E6F  姉 */
	{ 0x3B51, 0x59FF, },	/* 27-49  8E70  姿 */
	{ 0x3B52, 0x5B50, },	/* 27-50  8E71  子 */
	{ 0x3B53, 0x5C4D, },	/* 27-51  8E72  屍 */
	{ 0x3B54, 0x5E02, },	/* 27-52  8E73  市 */
	{ 0x3B55, 0x5E2B, },	/* 27-53  8E74  師 */
	{ 0x3B56, 0x5FD7, },	/* 27-54  8E75  志 */
	{ 0x3B57, 0x601D, },	/* 27-55  8E76  思 */
	{ 0x3B58, 0x6307, },	/* 27-56  8E77  指 */
	{ 0x3B59, 0x652F, },	/* 27-57  8E78  支 */
	{ 0x3B5A, 0x5B5C, },	/* 27-58  8E79  孜 */
	{ 0x3B5B, 0x65AF, },	/* 27-59  8E7A  斯 */
	{ 0x3B5C, 0x65BD, },	/* 27-60  8E7B  施 */
	{ 0x3B5D, 0x65E8, },	/* 27-61  8E7C  旨 */
	{ 0x3B5E, 0x679D, },	/* 27-62  8E7D  枝 */
	{ 0x3B5F, 0x6B62, },	/* 27-63  8E7E  止 */
	{ 0x3B60, 0x6B7B, },	/* 27-64  8E80  死 */
	{ 0x3B61, 0x6C0F, },	/* 27-65  8E81  氏 */
	{ 0x3B62, 0x7345, },	/* 27-66  8E82  獅 */
	{ 0x3B63, 0x7949, },	/* 27-67  8E83  祉 */
	{ 0x3B64, 0x79C1, },	/* 27-68  8E84  私 */
	{ 0x3B65, 0x7CF8, },	/* 27-69  8E85  糸 */
	{ 0x3B66, 0x7D19, },	/* 27-70  8E86  紙 */
	{ 0x3B67, 0x7D2B, },	/* 27-71  8E87  紫 */
	{ 0x3B68, 0x80A2, },	/* 27-72  8E88  肢 */
	{ 0x3B69, 0x8102, },	/* 27-73  8E89  脂 */
	{ 0x3B6A, 0x81F3, },	/* 27-74  8E8A  至 */
	{ 0x3B6B, 0x8996, },	/* 27-75  8E8B  視 */
	{ 0x3B6C, 0x8A5E, },	/* 27-76  8E8C  詞 */
	{ 0x3B6D, 0x8A69, },	/* 27-77  8E8D  詩 */
	{ 0x3B6E, 0x8A66, },	/* 27-78  8E8E  試 */
	{ 0x3B6F, 0x8A8C, },	/* 27-79  8E8F  誌 */
	{ 0x3B70, 0x8AEE, },	/* 27-80  8E90  諮 */
	{ 0x3B71, 0x8CC7, },	/* 27-81  8E91  資 */
	{ 0x3B72, 0x8CDC, },	/* 27-82  8E92  賜 */
	{ 0x3B73, 0x96CC, },	/* 27-83  8E93  雌 */
	{ 0x3B74, 0x98FC, },	/* 27-84  8E94  飼 */
	{ 0x3B75, 0x6B6F, },	/* 27-85  8E95  歯 */
	{ 0x3B76, 0x4E8B, },	/* 27-86  8E96  事 */
	{ 0x3B77, 0x4F3C, },	/* 27-87  8E97  似 */
	{ 0x3B78, 0x4F8D, },	/* 27-88  8E98  侍 */
	{ 0x3B79, 0x5150, },	/* 27-89  8E99  児 */
	{ 0x3B7A, 0x5B57, },	/* 27-90  8E9A  字 */
	{ 0x3B7B, 0x5BFA, },	/* 27-91  8E9B  寺 */
	{ 0x3B7C, 0x6148, },	/* 27-92  8E9C  慈 */
	{ 0x3B7D, 0x6301, },	/* 27-93  8E9D  持 */
	{ 0x3B7E, 0x6642, },	/* 27-94  8E9E  時 */
	{ 0x3C21, 0x6B21, },	/* 28-01  8E9F  次 */
	{ 0x3C22, 0x6ECB, },	/* 28-02  8EA0  滋 */
	{ 0x3C23, 0x6CBB, },	/* 28-03  8EA1  治 */
	{ 0x3C24, 0x723E, },	/* 28-04  8EA2  爾 */
	{ 0x3C25, 0x74BD, },	/* 28-05  8EA3  璽 */
	{ 0x3C26, 0x75D4, },	/* 28-06  8EA4  痔 */
	{ 0x3C27, 0x78C1, },	/* 28-07  8EA5  磁 */
	{ 0x3C28, 0x793A, },	/* 28-08  8EA6  示 */
	{ 0x3C29, 0x800C, },	/* 28-09  8EA7  而 */
	{ 0x3C2A, 0x8033, },	/* 28-10  8EA8  耳 */
	{ 0x3C2B, 0x81EA, },	/* 28-11  8EA9  自 */
	{ 0x3C2C, 0x8494, },	/* 28-12  8EAA  蒔 */
	{ 0x3C2D, 0x8F9E, },	/* 28-13  8EAB  辞 */
	{ 0x3C2E, 0x6C50, },	/* 28-14  8EAC  汐 */
	{ 0x3C2F, 0x9E7F, },	/* 28-15  8EAD  鹿 */
	{ 0x3C30, 0x5F0F, },	/* 28-16  8EAE  式 */
	{ 0x3C31, 0x8B58, },	/* 28-17  8EAF  識 */
	{ 0x3C32, 0x9D2B, },	/* 28-18  8EB0  鴫 */
	{ 0x3C33, 0x7AFA, },	/* 28-19  8EB1  竺 */
	{ 0x3C34, 0x8EF8, },	/* 28-20  8EB2  軸 */
	{ 0x3C35, 0x5B8D, },	/* 28-21  8EB3  宍 */
	{ 0x3C36, 0x96EB, },	/* 28-22  8EB4  雫 */
	{ 0x3C37, 0x4E03, },	/* 28-23  8EB5  七 */
	{ 0x3C38, 0x53F1, },	/* 28-24  8EB6  叱 */
	{ 0x3C39, 0x57F7, },	/* 28-25  8EB7  執 */
	{ 0x3C3A, 0x5931, },	/* 28-26  8EB8  失 */
	{ 0x3C3B, 0x5AC9, },	/* 28-27  8EB9  嫉 */
	{ 0x3C3C, 0x5BA4, },	/* 28-28  8EBA  室 */
	{ 0x3C3D, 0x6089, },	/* 28-29  8EBB  悉 */
	{ 0x3C3E, 0x6E7F, },	/* 28-30  8EBC  湿 */
	{ 0x3C3F, 0x6F06, },	/* 28-31  8EBD  漆 */
	{ 0x3C40, 0x75BE, },	/* 28-32  8EBE  疾 */
	{ 0x3C41, 0x8CEA, },	/* 28-33  8EBF  質 */
	{ 0x3C42, 0x5B9F, },	/* 28-34  8EC0  実 */
	{ 0x3C43, 0x8500, },	/* 28-35  8EC1  蔀 */
	{ 0x3C44, 0x7BE0, },	/* 28-36  8EC2  篠 */
	{ 0x3C45, 0x5072, },	/* 28-37  8EC3  偲 */
	{ 0x3C46, 0x67F4, },	/* 28-38  8EC4  柴 */
	{ 0x3C47, 0x829D, },	/* 28-39  8EC5  芝 */
	{ 0x3C48, 0x5C61, },	/* 28-40  8EC6  屡 */
	{ 0x3C49, 0x854A, },	/* 28-41  8EC7  蕊 */
	{ 0x3C4A, 0x7E1E, },	/* 28-42  8EC8  縞 */
	{ 0x3C4B, 0x820E, },	/* 28-43  8EC9  舎 */
	{ 0x3C4C, 0x5199, },	/* 28-44  8ECA  写 */
	{ 0x3C4D, 0x5C04, },	/* 28-45  8ECB  射 */
	{ 0x3C4E, 0x6368, },	/* 28-46  8ECC  捨 */
	{ 0x3C4F, 0x8D66, },	/* 28-47  8ECD  赦 */
	{ 0x3C50, 0x659C, },	/* 28-48  8ECE  斜 */
	{ 0x3C51, 0x716E, },	/* 28-49  8ECF  煮 */
	{ 0x3C52, 0x793E, },	/* 28-50  8ED0  社 */
	{ 0x3C53, 0x7D17, },	/* 28-51  8ED1  紗 */
	{ 0x3C54, 0x8005, },	/* 28-52  8ED2  者 */
	{ 0x3C55, 0x8B1D, },	/* 28-53  8ED3  謝 */
	{ 0x3C56, 0x8ECA, },	/* 28-54  8ED4  車 */
	{ 0x3C57, 0x906E, },	/* 28-55  8ED5  遮 */
	{ 0x3C58, 0x86C7, },	/* 28-56  8ED6  蛇 */
	{ 0x3C59, 0x90AA, },	/* 28-57  8ED7  邪 */
	{ 0x3C5A, 0x501F, },	/* 28-58  8ED8  借 */
	{ 0x3C5B, 0x52FA, },	/* 28-59  8ED9  勺 */
	{ 0x3C5C, 0x5C3A, },	/* 28-60  8EDA  尺 */
	{ 0x3C5D, 0x6753, },	/* 28-61  8EDB  杓 */
	{ 0x3C5E, 0x707C, },	/* 28-62  8EDC  灼 */
	{ 0x3C5F, 0x7235, },	/* 28-63  8EDD  爵 */
	{ 0x3C60, 0x914C, },	/* 28-64  8EDE  酌 */
	{ 0x3C61, 0x91C8, },	/* 28-65  8EDF  釈 */
	{ 0x3C62, 0x932B, },	/* 28-66  8EE0  錫 */
	{ 0x3C63, 0x82E5, },	/* 28-67  8EE1  若 */
	{ 0x3C64, 0x5BC2, },	/* 28-68  8EE2  寂 */
	{ 0x3C65, 0x5F31, },	/* 28-69  8EE3  弱 */
	{ 0x3C66, 0x60F9, },	/* 28-70  8EE4  惹 */
	{ 0x3C67, 0x4E3B, },	/* 28-71  8EE5  主 */
	{ 0x3C68, 0x53D6, },	/* 28-72  8EE6  取 */
	{ 0x3C69, 0x5B88, },	/* 28-73  8EE7  守 */
	{ 0x3C6A, 0x624B, },	/* 28-74  8EE8  手 */
	{ 0x3C6B, 0x6731, },	/* 28-75  8EE9  朱 */
	{ 0x3C6C, 0x6B8A, },	/* 28-76  8EEA  殊 */
	{ 0x3C6D, 0x72E9, },	/* 28-77  8EEB  狩 */
	{ 0x3C6E, 0x73E0, },	/* 28-78  8EEC  珠 */
	{ 0x3C6F, 0x7A2E, },	/* 28-79  8EED  種 */
	{ 0x3C70, 0x816B, },	/* 28-80  8EEE  腫 */
	{ 0x3C71, 0x8DA3, },	/* 28-81  8EEF  趣 */
	{ 0x3C72, 0x9152, },	/* 28-82  8EF0  酒 */
	{ 0x3C73, 0x9996, },	/* 28-83  8EF1  首 */
	{ 0x3C74, 0x5112, },	/* 28-84  8EF2  儒 */
	{ 0x3C75, 0x53D7, },	/* 28-85  8EF3  受 */
	{ 0x3C76, 0x546A, },	/* 28-86  8EF4  呪 */
	{ 0x3C77, 0x5BFF, },	/* 28-87  8EF5  寿 */
	{ 0x3C78, 0x6388, },	/* 28-88  8EF6  授 */
	{ 0x3C79, 0x6A39, },	/* 28-89  8EF7  樹 */
	{ 0x3C7A, 0x7DAC, },	/* 28-90  8EF8  綬 */
	{ 0x3C7B, 0x9700, },	/* 28-91  8EF9  需 */
	{ 0x3C7C, 0x56DA, },	/* 28-92  8EFA  囚 */
	{ 0x3C7D, 0x53CE, },	/* 28-93  8EFB  収 */
	{ 0x3C7E, 0x5468, },	/* 28-94  8EFC  周 */
	{ 0x3D21, 0x5B97, },	/* 29-01  8F40  宗 */
	{ 0x3D22, 0x5C31, },	/* 29-02  8F41  就 */
	{ 0x3D23, 0x5DDE, },	/* 29-03  8F42  州 */
	{ 0x3D24, 0x4FEE, },	/* 29-04  8F43  修 */
	{ 0x3D25, 0x6101, },	/* 29-05  8F44  愁 */
	{ 0x3D26, 0x62FE, },	/* 29-06  8F45  拾 */
	{ 0x3D27, 0x6D32, },	/* 29-07  8F46  洲 */
	{ 0x3D28, 0x79C0, },	/* 29-08  8F47  秀 */
	{ 0x3D29, 0x79CB, },	/* 29-09  8F48  秋 */
	{ 0x3D2A, 0x7D42, },	/* 29-10  8F49  終 */
	{ 0x3D2B, 0x7E4D, },	/* 29-11  8F4A  繍 */
	{ 0x3D2C, 0x7FD2, },	/* 29-12  8F4B  習 */
	{ 0x3D2D, 0x81ED, },	/* 29-13  8F4C  臭 */
	{ 0x3D2E, 0x821F, },	/* 29-14  8F4D  舟 */
	{ 0x3D2F, 0x8490, },	/* 29-15  8F4E  蒐 */
	{ 0x3D30, 0x8846, },	/* 29-16  8F4F  衆 */
	{ 0x3D31, 0x8972, },	/* 29-17  8F50  襲 */
	{ 0x3D32, 0x8B90, },	/* 29-18  8F51  讐 */
	{ 0x3D33, 0x8E74, },	/* 29-19  8F52  蹴 */
	{ 0x3D34, 0x8F2F, },	/* 29-20  8F53  輯 */
	{ 0x3D35, 0x9031, },	/* 29-21  8F54  週 */
	{ 0x3D36, 0x914B, },	/* 29-22  8F55  酋 */
	{ 0x3D37, 0x916C, },	/* 29-23  8F56  酬 */
	{ 0x3D38, 0x96C6, },	/* 29-24  8F57  集 */
	{ 0x3D39, 0x919C, },	/* 29-25  8F58  醜 */
	{ 0x3D3A, 0x4EC0, },	/* 29-26  8F59  什 */
	{ 0x3D3B, 0x4F4F, },	/* 29-27  8F5A  住 */
	{ 0x3D3C, 0x5145, },	/* 29-28  8F5B  充 */
	{ 0x3D3D, 0x5341, },	/* 29-29  8F5C  十 */
	{ 0x3D3E, 0x5F93, },	/* 29-30  8F5D  従 */
	{ 0x3D3F, 0x620E, },	/* 29-31  8F5E  戎 */
	{ 0x3D40, 0x67D4, },	/* 29-32  8F5F  柔 */
	{ 0x3D41, 0x6C41, },	/* 29-33  8F60  汁 */
	{ 0x3D42, 0x6E0B, },	/* 29-34  8F61  渋 */
	{ 0x3D43, 0x7363, },	/* 29-35  8F62  獣 */
	{ 0x3D44, 0x7E26, },	/* 29-36  8F63  縦 */
	{ 0x3D45, 0x91CD, },	/* 29-37  8F64  重 */
	{ 0x3D46, 0x9283, },	/* 29-38  8F65  銃 */
	{ 0x3D47, 0x53D4, },	/* 29-39  8F66  叔 */
	{ 0x3D48, 0x5919, },	/* 29-40  8F67  夙 */
	{ 0x3D49, 0x5BBF, },	/* 29-41  8F68  宿 */
	{ 0x3D4A, 0x6DD1, },	/* 29-42  8F69  淑 */
	{ 0x3D4B, 0x795D, },	/* 29-43  8F6A  祝 */
	{ 0x3D4C, 0x7E2E, },	/* 29-44  8F6B  縮 */
	{ 0x3D4D, 0x7C9B, },	/* 29-45  8F6C  粛 */
	{ 0x3D4E, 0x587E, },	/* 29-46  8F6D  塾 */
	{ 0x3D4F, 0x719F, },	/* 29-47  8F6E  熟 */
	{ 0x3D50, 0x51FA, },	/* 29-48  8F6F  出 */
	{ 0x3D51, 0x8853, },	/* 29-49  8F70  術 */
	{ 0x3D52, 0x8FF0, },	/* 29-50  8F71  述 */
	{ 0x3D53, 0x4FCA, },	/* 29-51  8F72  俊 */
	{ 0x3D54, 0x5CFB, },	/* 29-52  8F73  峻 */
	{ 0x3D55, 0x6625, },	/* 29-53  8F74  春 */
	{ 0x3D56, 0x77AC, },	/* 29-54  8F75  瞬 */
	{ 0x3D57, 0x7AE3, },	/* 29-55  8F76  竣 */
	{ 0x3D58, 0x821C, },	/* 29-56  8F77  舜 */
	{ 0x3D59, 0x99FF, },	/* 29-57  8F78  駿 */
	{ 0x3D5A, 0x51C6, },	/* 29-58  8F79  准 */
	{ 0x3D5B, 0x5FAA, },	/* 29-59  8F7A  循 */
	{ 0x3D5C, 0x65EC, },	/* 29-60  8F7B  旬 */
	{ 0x3D5D, 0x696F, },	/* 29-61  8F7C  楯 */
	{ 0x3D5E, 0x6B89, },	/* 29-62  8F7D  殉 */
	{ 0x3D5F, 0x6DF3, },	/* 29-63  8F7E  淳 */
	{ 0x3D60, 0x6E96, },	/* 29-64  8F80  準 */
	{ 0x3D61, 0x6F64, },	/* 29-65  8F81  潤 */
	{ 0x3D62, 0x76FE, },	/* 29-66  8F82  盾 */
	{ 0x3D63, 0x7D14, },	/* 29-67  8F83  純 */
	{ 0x3D64, 0x5DE1, },	/* 29-68  8F84  巡 */
	{ 0x3D65, 0x9075, },	/* 29-69  8F85  遵 */
	{ 0x3D66, 0x9187, },	/* 29-70  8F86  醇 */
	{ 0x3D67, 0x9806, },	/* 29-71  8F87  順 */
	{ 0x3D68, 0x51E6, },	/* 29-72  8F88  処 */
	{ 0x3D69, 0x521D, },	/* 29-73  8F89  初 */
	{ 0x3D6A, 0x6240, },	/* 29-74  8F8A  所 */
	{ 0x3D6B, 0x6691, },	/* 29-75  8F8B  暑 */
	{ 0x3D6C, 0x66D9, },	/* 29-76  8F8C  曙 */
	{ 0x3D6D, 0x6E1A, },	/* 29-77  8F8D  渚 */
	{ 0x3D6E, 0x5EB6, },	/* 29-78  8F8E  庶 */
	{ 0x3D6F, 0x7DD2, },	/* 29-79  8F8F  緒 */
	{ 0x3D70, 0x7F72, },	/* 29-80  8F90  署 */
	{ 0x3D71, 0x66F8, },	/* 29-81  8F91  書 */
	{ 0x3D72, 0x85AF, },	/* 29-82  8F92  薯 */
	{ 0x3D73, 0x85F7, },	/* 29-83  8F93  藷 */
	{ 0x3D74, 0x8AF8, },	/* 29-84  8F94  諸 */
	{ 0x3D75, 0x52A9, },	/* 29-85  8F95  助 */
	{ 0x3D76, 0x53D9, },	/* 29-86  8F96  叙 */
	{ 0x3D77, 0x5973, },	/* 29-87  8F97  女 */
	{ 0x3D78, 0x5E8F, },	/* 29-88  8F98  序 */
	{ 0x3D79, 0x5F90, },	/* 29-89  8F99  徐 */
	{ 0x3D7A, 0x6055, },	/* 29-90  8F9A  恕 */
	{ 0x3D7B, 0x92E4, },	/* 29-91  8F9B  鋤 */
	{ 0x3D7C, 0x9664, },	/* 29-92  8F9C  除 */
	{ 0x3D7D, 0x50B7, },	/* 29-93  8F9D  傷 */
	{ 0x3D7E, 0x511F, },	/* 29-94  8F9E  償 */
	{ 0x3E21, 0x52DD, },	/* 30-01  8F9F  勝 */
	{ 0x3E22, 0x5320, },	/* 30-02  8FA0  匠 */
	{ 0x3E23, 0x5347, },	/* 30-03  8FA1  升 */
	{ 0x3E24, 0x53EC, },	/* 30-04  8FA2  召 */
	{ 0x3E25, 0x54E8, },	/* 30-05  8FA3  哨 */
	{ 0x3E26, 0x5546, },	/* 30-06  8FA4  商 */
	{ 0x3E27, 0x5531, },	/* 30-07  8FA5  唱 */
	{ 0x3E28, 0x5617, },	/* 30-08  8FA6  嘗 */
	{ 0x3E29, 0x5968, },	/* 30-09  8FA7  奨 */
	{ 0x3E2A, 0x59BE, },	/* 30-10  8FA8  妾 */
	{ 0x3E2B, 0x5A3C, },	/* 30-11  8FA9  娼 */
	{ 0x3E2C, 0x5BB5, },	/* 30-12  8FAA  宵 */
	{ 0x3E2D, 0x5C06, },	/* 30-13  8FAB  将 */
	{ 0x3E2E, 0x5C0F, },	/* 30-14  8FAC  小 */
	{ 0x3E2F, 0x5C11, },	/* 30-15  8FAD  少 */
	{ 0x3E30, 0x5C1A, },	/* 30-16  8FAE  尚 */
	{ 0x3E31, 0x5E84, },	/* 30-17  8FAF  庄 */
	{ 0x3E32, 0x5E8A, },	/* 30-18  8FB0  床 */
	{ 0x3E33, 0x5EE0, },	/* 30-19  8FB1  廠 */
	{ 0x3E34, 0x5F70, },	/* 30-20  8FB2  彰 */
	{ 0x3E35, 0x627F, },	/* 30-21  8FB3  承 */
	{ 0x3E36, 0x6284, },	/* 30-22  8FB4  抄 */
	{ 0x3E37, 0x62DB, },	/* 30-23  8FB5  招 */
	{ 0x3E38, 0x638C, },	/* 30-24  8FB6  掌 */
	{ 0x3E39, 0x6377, },	/* 30-25  8FB7  捷 */
	{ 0x3E3A, 0x6607, },	/* 30-26  8FB8  昇 */
	{ 0x3E3B, 0x660C, },	/* 30-27  8FB9  昌 */
	{ 0x3E3C, 0x662D, },	/* 30-28  8FBA  昭 */
	{ 0x3E3D, 0x6676, },	/* 30-29  8FBB  晶 */
	{ 0x3E3E, 0x677E, },	/* 30-30  8FBC  松 */
	{ 0x3E3F, 0x68A2, },	/* 30-31  8FBD  梢 */
	{ 0x3E40, 0x6A1F, },	/* 30-32  8FBE  樟 */
	{ 0x3E41, 0x6A35, },	/* 30-33  8FBF  樵 */
	{ 0x3E42, 0x6CBC, },	/* 30-34  8FC0  沼 */
	{ 0x3E43, 0x6D88, },	/* 30-35  8FC1  消 */
	{ 0x3E44, 0x6E09, },	/* 30-36  8FC2  渉 */
	{ 0x3E45, 0x6E58, },	/* 30-37  8FC3  湘 */
	{ 0x3E46, 0x713C, },	/* 30-38  8FC4  焼 */
	{ 0x3E47, 0x7126, },	/* 30-39  8FC5  焦 */
	{ 0x3E48, 0x7167, },	/* 30-40  8FC6  照 */
	{ 0x3E49, 0x75C7, },	/* 30-41  8FC7  症 */
	{ 0x3E4A, 0x7701, },	/* 30-42  8FC8  省 */
	{ 0x3E4B, 0x785D, },	/* 30-43  8FC9  硝 */
	{ 0x3E4C, 0x7901, },	/* 30-44  8FCA  礁 */
	{ 0x3E4D, 0x7965, },	/* 30-45  8FCB  祥 */
	{ 0x3E4E, 0x79F0, },	/* 30-46  8FCC  称 */
	{ 0x3E4F, 0x7AE0, },	/* 30-47  8FCD  章 */
	{ 0x3E50, 0x7B11, },	/* 30-48  8FCE  笑 */
	{ 0x3E51, 0x7CA7, },	/* 30-49  8FCF  粧 */
	{ 0x3E52, 0x7D39, },	/* 30-50  8FD0  紹 */
	{ 0x3E53, 0x8096, },	/* 30-51  8FD1  肖 */
	{ 0x3E54, 0x83D6, },	/* 30-52  8FD2  菖 */
	{ 0x3E55, 0x848B, },	/* 30-53  8FD3  蒋 */
	{ 0x3E56, 0x8549, },	/* 30-54  8FD4  蕉 */
	{ 0x3E57, 0x885D, },	/* 30-55  8FD5  衝 */
	{ 0x3E58, 0x88F3, },	/* 30-56  8FD6  裳 */
	{ 0x3E59, 0x8A1F, },	/* 30-57  8FD7  訟 */
	{ 0x3E5A, 0x8A3C, },	/* 30-58  8FD8  証 */
	{ 0x3E5B, 0x8A54, },	/* 30-59  8FD9  詔 */
	{ 0x3E5C, 0x8A73, },	/* 30-60  8FDA  詳 */
	{ 0x3E5D, 0x8C61, },	/* 30-61  8FDB  象 */
	{ 0x3E5E, 0x8CDE, },	/* 30-62  8FDC  賞 */
	{ 0x3E5F, 0x91A4, },	/* 30-63  8FDD  醤 */
	{ 0x3E60, 0x9266, },	/* 30-64  8FDE  鉦 */
	{ 0x3E61, 0x937E, },	/* 30-65  8FDF  鍾 */
	{ 0x3E62, 0x9418, },	/* 30-66  8FE0  鐘 */
	{ 0x3E63, 0x969C, },	/* 30-67  8FE1  障 */
	{ 0x3E64, 0x9798, },	/* 30-68  8FE2  鞘 */
	{ 0x3E65, 0x4E0A, },	/* 30-69  8FE3  上 */
	{ 0x3E66, 0x4E08, },	/* 30-70  8FE4  丈 */
	{ 0x3E67, 0x4E1E, },	/* 30-71  8FE5  丞 */
	{ 0x3E68, 0x4E57, },	/* 30-72  8FE6  乗 */
	{ 0x3E69, 0x5197, },	/* 30-73  8FE7  冗 */
	{ 0x3E6A, 0x5270, },	/* 30-74  8FE8  剰 */
	{ 0x3E6B, 0x57CE, },	/* 30-75  8FE9  城 */
	{ 0x3E6C, 0x5834, },	/* 30-76  8FEA  場 */
	{ 0x3E6D, 0x58CC, },	/* 30-77  8FEB  壌 */
	{ 0x3E6E, 0x5B22, },	/* 30-78  8FEC  嬢 */
	{ 0x3E6F, 0x5E38, },	/* 30-79  8FED  常 */
	{ 0x3E70, 0x60C5, },	/* 30-80  8FEE  情 */
	{ 0x3E71, 0x64FE, },	/* 30-81  8FEF  擾 */
	{ 0x3E72, 0x6761, },	/* 30-82  8FF0  条 */
	{ 0x3E73, 0x6756, },	/* 30-83  8FF1  杖 */
	{ 0x3E74, 0x6D44, },	/* 30-84  8FF2  浄 */
	{ 0x3E75, 0x72B6, },	/* 30-85  8FF3  状 */
	{ 0x3E76, 0x7573, },	/* 30-86  8FF4  畳 */
	{ 0x3E77, 0x7A63, },	/* 30-87  8FF5  穣 */
	{ 0x3E78, 0x84B8, },	/* 30-88  8FF6  蒸 */
	{ 0x3E79, 0x8B72, },	/* 30-89  8FF7  譲 */
	{ 0x3E7A, 0x91B8, },	/* 30-90  8FF8  醸 */
	{ 0x3E7B, 0x9320, },	/* 30-91  8FF9  錠 */
	{ 0x3E7C, 0x5631, },	/* 30-92  8FFA  嘱 */
	{ 0x3E7D, 0x57F4, },	/* 30-93  8FFB  埴 */
	{ 0x3E7E, 0x98FE, },	/* 30-94  8FFC  飾 */
	{ 0x3F21, 0x62ED, },	/* 31-01  9040  拭 */
	{ 0x3F22, 0x690D, },	/* 31-02  9041  植 */
	{ 0x3F23, 0x6B96, },	/* 31-03  9042  殖 */
	{ 0x3F24, 0x71ED, },	/* 31-04  9043  燭 */
	{ 0x3F25, 0x7E54, },	/* 31-05  9044  織 */
	{ 0x3F26, 0x8077, },	/* 31-06  9045  職 */
	{ 0x3F27, 0x8272, },	/* 31-07  9046  色 */
	{ 0x3F28, 0x89E6, },	/* 31-08  9047  触 */
	{ 0x3F29, 0x98DF, },	/* 31-09  9048  食 */
	{ 0x3F2A, 0x8755, },	/* 31-10  9049  蝕 */
	{ 0x3F2B, 0x8FB1, },	/* 31-11  904A  辱 */
	{ 0x3F2C, 0x5C3B, },	/* 31-12  904B  尻 */
	{ 0x3F2D, 0x4F38, },	/* 31-13  904C  伸 */
	{ 0x3F2E, 0x4FE1, },	/* 31-14  904D  信 */
	{ 0x3F2F, 0x4FB5, },	/* 31-15  904E  侵 */
	{ 0x3F30, 0x5507, },	/* 31-16  904F  唇 */
	{ 0x3F31, 0x5A20, },	/* 31-17  9050  娠 */
	{ 0x3F32, 0x5BDD, },	/* 31-18  9051  寝 */
	{ 0x3F33, 0x5BE9, },	/* 31-19  9052  審 */
	{ 0x3F34, 0x5FC3, },	/* 31-20  9053  心 */
	{ 0x3F35, 0x614E, },	/* 31-21  9054  慎 */
	{ 0x3F36, 0x632F, },	/* 31-22  9055  振 */
	{ 0x3F37, 0x65B0, },	/* 31-23  9056  新 */
	{ 0x3F38, 0x664B, },	/* 31-24  9057  晋 */
	{ 0x3F39, 0x68EE, },	/* 31-25  9058  森 */
	{ 0x3F3A, 0x699B, },	/* 31-26  9059  榛 */
	{ 0x3F3B, 0x6D78, },	/* 31-27  905A  浸 */
	{ 0x3F3C, 0x6DF1, },	/* 31-28  905B  深 */
	{ 0x3F3D, 0x7533, },	/* 31-29  905C  申 */
	{ 0x3F3E, 0x75B9, },	/* 31-30  905D  疹 */
	{ 0x3F3F, 0x771F, },	/* 31-31  905E  真 */
	{ 0x3F40, 0x795E, },	/* 31-32  905F  神 */
	{ 0x3F41, 0x79E6, },	/* 31-33  9060  秦 */
	{ 0x3F42, 0x7D33, },	/* 31-34  9061  紳 */
	{ 0x3F43, 0x81E3, },	/* 31-35  9062  臣 */
	{ 0x3F44, 0x82AF, },	/* 31-36  9063  芯 */
	{ 0x3F45, 0x85AA, },	/* 31-37  9064  薪 */
	{ 0x3F46, 0x89AA, },	/* 31-38  9065  親 */
	{ 0x3F47, 0x8A3A, },	/* 31-39  9066  診 */
	{ 0x3F48, 0x8EAB, },	/* 31-40  9067  身 */
	{ 0x3F49, 0x8F9B, },	/* 31-41  9068  辛 */
	{ 0x3F4A, 0x9032, },	/* 31-42  9069  進 */
	{ 0x3F4B, 0x91DD, },	/* 31-43  906A  針 */
	{ 0x3F4C, 0x9707, },	/* 31-44  906B  震 */
	{ 0x3F4D, 0x4EBA, },	/* 31-45  906C  人 */
	{ 0x3F4E, 0x4EC1, },	/* 31-46  906D  仁 */
	{ 0x3F4F, 0x5203, },	/* 31-47  906E  刃 */
	{ 0x3F50, 0x5875, },	/* 31-48  906F  塵 */
	{ 0x3F51, 0x58EC, },	/* 31-49  9070  壬 */
	{ 0x3F52, 0x5C0B, },	/* 31-50  9071  尋 */
	{ 0x3F53, 0x751A, },	/* 31-51  9072  甚 */
	{ 0x3F54, 0x5C3D, },	/* 31-52  9073  尽 */
	{ 0x3F55, 0x814E, },	/* 31-53  9074  腎 */
	{ 0x3F56, 0x8A0A, },	/* 31-54  9075  訊 */
	{ 0x3F57, 0x8FC5, },	/* 31-55  9076  迅 */
	{ 0x3F58, 0x9663, },	/* 31-56  9077  陣 */
	{ 0x3F59, 0x976D, },	/* 31-57  9078  靭 */
	{ 0x3F5A, 0x7B25, },	/* 31-58  9079  笥 */
	{ 0x3F5B, 0x8ACF, },	/* 31-59  907A  諏 */
	{ 0x3F5C, 0x9808, },	/* 31-60  907B  須 */
	{ 0x3F5D, 0x9162, },	/* 31-61  907C  酢 */
	{ 0x3F5E, 0x56F3, },	/* 31-62  907D  図 */
	{ 0x3F5F, 0x53A8, },	/* 31-63  907E  厨 */
	{ 0x3F60, 0x9017, },	/* 31-64  9080  逗 */
	{ 0x3F61, 0x5439, },	/* 31-65  9081  吹 */
	{ 0x3F62, 0x5782, },	/* 31-66  9082  垂 */
	{ 0x3F63, 0x5E25, },	/* 31-67  9083  帥 */
	{ 0x3F64, 0x63A8, },	/* 31-68  9084  推 */
	{ 0x3F65, 0x6C34, },	/* 31-69  9085  水 */
	{ 0x3F66, 0x708A, },	/* 31-70  9086  炊 */
	{ 0x3F67, 0x7761, },	/* 31-71  9087  睡 */
	{ 0x3F68, 0x7C8B, },	/* 31-72  9088  粋 */
	{ 0x3F69, 0x7FE0, },	/* 31-73  9089  翠 */
	{ 0x3F6A, 0x8870, },	/* 31-74  908A  衰 */
	{ 0x3F6B, 0x9042, },	/* 31-75  908B  遂 */
	{ 0x3F6C, 0x9154, },	/* 31-76  908C  酔 */
	{ 0x3F6D, 0x9310, },	/* 31-77  908D  錐 */
	{ 0x3F6E, 0x9318, },	/* 31-78  908E  錘 */
	{ 0x3F6F, 0x968F, },	/* 31-79  908F  随 */
	{ 0x3F70, 0x745E, },	/* 31-80  9090  瑞 */
	{ 0x3F71, 0x9AC4, },	/* 31-81  9091  髄 */
	{ 0x3F72, 0x5D07, },	/* 31-82  9092  崇 */
	{ 0x3F73, 0x5D69, },	/* 31-83  9093  嵩 */
	{ 0x3F74, 0x6570, },	/* 31-84  9094  数 */
	{ 0x3F75, 0x67A2, },	/* 31-85  9095  枢 */
	{ 0x3F76, 0x8DA8, },	/* 31-86  9096  趨 */
	{ 0x3F77, 0x96DB, },	/* 31-87  9097  雛 */
	{ 0x3F78, 0x636E, },	/* 31-88  9098  据 */
	{ 0x3F79, 0x6749, },	/* 31-89  9099  杉 */
	{ 0x3F7A, 0x6919, },	/* 31-90  909A  椙 */
	{ 0x3F7B, 0x83C5, },	/* 31-91  909B  菅 */
	{ 0x3F7C, 0x9817, },	/* 31-92  909C  頗 */
	{ 0x3F7D, 0x96C0, },	/* 31-93  909D  雀 */
	{ 0x3F7E, 0x88FE, },	/* 31-94  909E  裾 */
	{ 0x4021, 0x6F84, },	/* 32-01  909F  澄 */
	{ 0x4022, 0x647A, },	/* 32-02  90A0  摺 */
	{ 0x4023, 0x5BF8, },	/* 32-03  90A1  寸 */
	{ 0x4024, 0x4E16, },	/* 32-04  90A2  世 */
	{ 0x4025, 0x702C, },	/* 32-05  90A3  瀬 */
	{ 0x4026, 0x755D, },	/* 32-06  90A4  畝 */
	{ 0x4027, 0x662F, },	/* 32-07  90A5  是 */
	{ 0x4028, 0x51C4, },	/* 32-08  90A6  凄 */
	{ 0x4029, 0x5236, },	/* 32-09  90A7  制 */
	{ 0x402A, 0x52E2, },	/* 32-10  90A8  勢 */
	{ 0x402B, 0x59D3, },	/* 32-11  90A9  姓 */
	{ 0x402C, 0x5F81, },	/* 32-12  90AA  征 */
	{ 0x402D, 0x6027, },	/* 32-13  90AB  性 */
	{ 0x402E, 0x6210, },	/* 32-14  90AC  成 */
	{ 0x402F, 0x653F, },	/* 32-15  90AD  政 */
	{ 0x4030, 0x6574, },	/* 32-16  90AE  整 */
	{ 0x4031, 0x661F, },	/* 32-17  90AF  星 */
	{ 0x4032, 0x6674, },	/* 32-18  90B0  晴 */
	{ 0x4033, 0x68F2, },	/* 32-19  90B1  棲 */
	{ 0x4034, 0x6816, },	/* 32-20  90B2  栖 */
	{ 0x4035, 0x6B63, },	/* 32-21  90B3  正 */
	{ 0x4036, 0x6E05, },	/* 32-22  90B4  清 */
	{ 0x4037, 0x7272, },	/* 32-23  90B5  牲 */
	{ 0x4038, 0x751F, },	/* 32-24  90B6  生 */
	{ 0x4039, 0x76DB, },	/* 32-25  90B7  盛 */
	{ 0x403A, 0x7CBE, },	/* 32-26  90B8  精 */
	{ 0x403B, 0x8056, },	/* 32-27  90B9  聖 */
	{ 0x403C, 0x58F0, },	/* 32-28  90BA  声 */
	{ 0x403D, 0x88FD, },	/* 32-29  90BB  製 */
	{ 0x403E, 0x897F, },	/* 32-30  90BC  西 */
	{ 0x403F, 0x8AA0, },	/* 32-31  90BD  誠 */
	{ 0x4040, 0x8A93, },	/* 32-32  90BE  誓 */
	{ 0x4041, 0x8ACB, },	/* 32-33  90BF  請 */
	{ 0x4042, 0x901D, },	/* 32-34  90C0  逝 */
	{ 0x4043, 0x9192, },	/* 32-35  90C1  醒 */
	{ 0x4044, 0x9752, },	/* 32-36  90C2  青 */
	{ 0x4045, 0x9759, },	/* 32-37  90C3  静 */
	{ 0x4046, 0x6589, },	/* 32-38  90C4  斉 */
	{ 0x4047, 0x7A0E, },	/* 32-39  90C5  税 */
	{ 0x4048, 0x8106, },	/* 32-40  90C6  脆 */
	{ 0x4049, 0x96BB, },	/* 32-41  90C7  隻 */
	{ 0x404A, 0x5E2D, },	/* 32-42  90C8  席 */
	{ 0x404B, 0x60DC, },	/* 32-43  90C9  惜 */
	{ 0x404C, 0x621A, },	/* 32-44  90CA  戚 */
	{ 0x404D, 0x65A5, },	/* 32-45  90CB  斥 */
	{ 0x404E, 0x6614, },	/* 32-46  90CC  昔 */
	{ 0x404F, 0x6790, },	/* 32-47  90CD  析 */
	{ 0x4050, 0x77F3, },	/* 32-48  90CE  石 */
	{ 0x4051, 0x7A4D, },	/* 32-49  90CF  積 */
	{ 0x4052, 0x7C4D, },	/* 32-50  90D0  籍 */
	{ 0x4053, 0x7E3E, },	/* 32-51  90D1  績 */
	{ 0x4054, 0x810A, },	/* 32-52  90D2  脊 */
	{ 0x4055, 0x8CAC, },	/* 32-53  90D3  責 */
	{ 0x4056, 0x8D64, },	/* 32-54  90D4  赤 */
	{ 0x4057, 0x8DE1, },	/* 32-55  90D5  跡 */
	{ 0x4058, 0x8E5F, },	/* 32-56  90D6  蹟 */
	{ 0x4059, 0x78A9, },	/* 32-57  90D7  碩 */
	{ 0x405A, 0x5207, },	/* 32-58  90D8  切 */
	{ 0x405B, 0x62D9, },	/* 32-59  90D9  拙 */
	{ 0x405C, 0x63A5, },	/* 32-60  90DA  接 */
	{ 0x405D, 0x6442, },	/* 32-61  90DB  摂 */
	{ 0x405E, 0x6298, },	/* 32-62  90DC  折 */
	{ 0x405F, 0x8A2D, },	/* 32-63  90DD  設 */
	{ 0x4060, 0x7A83, },	/* 32-64  90DE  窃 */
	{ 0x4061, 0x7BC0, },	/* 32-65  90DF  節 */
	{ 0x4062, 0x8AAC, },	/* 32-66  90E0  説 */
	{ 0x4063, 0x96EA, },	/* 32-67  90E1  雪 */
	{ 0x4064, 0x7D76, },	/* 32-68  90E2  絶 */
	{ 0x4065, 0x820C, },	/* 32-69  90E3  舌 */
	{ 0x4066, 0x8749, },	/* 32-70  90E4  蝉 */
	{ 0x4067, 0x4ED9, },	/* 32-71  90E5  仙 */
	{ 0x4068, 0x5148, },	/* 32-72  90E6  先 */
	{ 0x4069, 0x5343, },	/* 32-73  90E7  千 */
	{ 0x406A, 0x5360, },	/* 32-74  90E8  占 */
	{ 0x406B, 0x5BA3, },	/* 32-75  90E9  宣 */
	{ 0x406C, 0x5C02, },	/* 32-76  90EA  専 */
	{ 0x406D, 0x5C16, },	/* 32-77  90EB  尖 */
	{ 0x406E, 0x5DDD, },	/* 32-78  90EC  川 */
	{ 0x406F, 0x6226, },	/* 32-79  90ED  戦 */
	{ 0x4070, 0x6247, },	/* 32-80  90EE  扇 */
	{ 0x4071, 0x64B0, },	/* 32-81  90EF  撰 */
	{ 0x4072, 0x6813, },	/* 32-82  90F0  栓 */
	{ 0x4073, 0x6834, },	/* 32-83  90F1  栴 */
	{ 0x4074, 0x6CC9, },	/* 32-84  90F2  泉 */
	{ 0x4075, 0x6D45, },	/* 32-85  90F3  浅 */
	{ 0x4076, 0x6D17, },	/* 32-86  90F4  洗 */
	{ 0x4077, 0x67D3, },	/* 32-87  90F5  染 */
	{ 0x4078, 0x6F5C, },	/* 32-88  90F6  潜 */
	{ 0x4079, 0x714E, },	/* 32-89  90F7  煎 */
	{ 0x407A, 0x717D, },	/* 32-90  90F8  煽 */
	{ 0x407B, 0x65CB, },	/* 32-91  90F9  旋 */
	{ 0x407C, 0x7A7F, },	/* 32-92  90FA  穿 */
	{ 0x407D, 0x7BAD, },	/* 32-93  90FB  箭 */
	{ 0x407E, 0x7DDA, },	/* 32-94  90FC  線 */
	{ 0x4121, 0x7E4A, },	/* 33-01  9140  繊 */
	{ 0x4122, 0x7FA8, },	/* 33-02  9141  羨 */
	{ 0x4123, 0x817A, },	/* 33-03  9142  腺 */
	{ 0x4124, 0x821B, },	/* 33-04  9143  舛 */
	{ 0x4125, 0x8239, },	/* 33-05  9144  船 */
	{ 0x4126, 0x85A6, },	/* 33-06  9145  薦 */
	{ 0x4127, 0x8A6E, },	/* 33-07  9146  詮 */
	{ 0x4128, 0x8CCE, },	/* 33-08  9147  賎 */
	{ 0x4129, 0x8DF5, },	/* 33-09  9148  践 */
	{ 0x412A, 0x9078, },	/* 33-10  9149  選 */
	{ 0x412B, 0x9077, },	/* 33-11  914A  遷 */
	{ 0x412C, 0x92AD, },	/* 33-12  914B  銭 */
	{ 0x412D, 0x9291, },	/* 33-13  914C  銑 */
	{ 0x412E, 0x9583, },	/* 33-14  914D  閃 */
	{ 0x412F, 0x9BAE, },	/* 33-15  914E  鮮 */
	{ 0x4130, 0x524D, },	/* 33-16  914F  前 */
	{ 0x4131, 0x5584, },	/* 33-17  9150  善 */
	{ 0x4132, 0x6F38, },	/* 33-18  9151  漸 */
	{ 0x4133, 0x7136, },	/* 33-19  9152  然 */
	{ 0x4134, 0x5168, },	/* 33-20  9153  全 */
	{ 0x4135, 0x7985, },	/* 33-21  9154  禅 */
	{ 0x4136, 0x7E55, },	/* 33-22  9155  繕 */
	{ 0x4137, 0x81B3, },	/* 33-23  9156  膳 */
	{ 0x4138, 0x7CCE, },	/* 33-24  9157  糎 */
	{ 0x4139, 0x564C, },	/* 33-25  9158  噌 */
	{ 0x413A, 0x5851, },	/* 33-26  9159  塑 */
	{ 0x413B, 0x5CA8, },	/* 33-27  915A  岨 */
	{ 0x413C, 0x63AA, },	/* 33-28  915B  措 */
	{ 0x413D, 0x66FE, },	/* 33-29  915C  曾 */
	{ 0x413E, 0x66FD, },	/* 33-30  915D  曽 */
	{ 0x413F, 0x695A, },	/* 33-31  915E  楚 */
	{ 0x4140, 0x72D9, },	/* 33-32  915F  狙 */
	{ 0x4141, 0x758F, },	/* 33-33  9160  疏 */
	{ 0x4142, 0x758E, },	/* 33-34  9161  疎 */
	{ 0x4143, 0x790E, },	/* 33-35  9162  礎 */
	{ 0x4144, 0x7956, },	/* 33-36  9163  祖 */
	{ 0x4145, 0x79DF, },	/* 33-37  9164  租 */
	{ 0x4146, 0x7C97, },	/* 33-38  9165  粗 */
	{ 0x4147, 0x7D20, },	/* 33-39  9166  素 */
	{ 0x4148, 0x7D44, },	/* 33-40  9167  組 */
	{ 0x4149, 0x8607, },	/* 33-41  9168  蘇 */
	{ 0x414A, 0x8A34, },	/* 33-42  9169  訴 */
	{ 0x414B, 0x963B, },	/* 33-43  916A  阻 */
	{ 0x414C, 0x9061, },	/* 33-44  916B  遡 */
	{ 0x414D, 0x9F20, },	/* 33-45  916C  鼠 */
	{ 0x414E, 0x50E7, },	/* 33-46  916D  僧 */
	{ 0x414F, 0x5275, },	/* 33-47  916E  創 */
	{ 0x4150, 0x53CC, },	/* 33-48  916F  双 */
	{ 0x4151, 0x53E2, },	/* 33-49  9170  叢 */
	{ 0x4152, 0x5009, },	/* 33-50  9171  倉 */
	{ 0x4153, 0x55AA, },	/* 33-51  9172  喪 */
	{ 0x4154, 0x58EE, },	/* 33-52  9173  壮 */
	{ 0x4155, 0x594F, },	/* 33-53  9174  奏 */
	{ 0x4156, 0x723D, },	/* 33-54  9175  爽 */
	{ 0x4157, 0x5B8B, },	/* 33-55  9176  宋 */
	{ 0x4158, 0x5C64, },	/* 33-56  9177  層 */
	{ 0x4159, 0x531D, },	/* 33-57  9178  匝 */
	{ 0x415A, 0x60E3, },	/* 33-58  9179  惣 */
	{ 0x415B, 0x60F3, },	/* 33-59  917A  想 */
	{ 0x415C, 0x635C, },	/* 33-60  917B  捜 */
	{ 0x415D, 0x6383, },	/* 33-61  917C  掃 */
	{ 0x415E, 0x633F, },	/* 33-62  917D  挿 */
	{ 0x415F, 0x63BB, },	/* 33-63  917E  掻 */
	{ 0x4160, 0x64CD, },	/* 33-64  9180  操 */
	{ 0x4161, 0x65E9, },	/* 33-65  9181  早 */
	{ 0x4162, 0x66F9, },	/* 33-66  9182  曹 */
	{ 0x4163, 0x5DE3, },	/* 33-67  9183  巣 */
	{ 0x4164, 0x69CD, },	/* 33-68  9184  槍 */
	{ 0x4165, 0x69FD, },	/* 33-69  9185  槽 */
	{ 0x4166, 0x6F15, },	/* 33-70  9186  漕 */
	{ 0x4167, 0x71E5, },	/* 33-71  9187  燥 */
	{ 0x4168, 0x4E89, },	/* 33-72  9188  争 */
	{ 0x4169, 0x75E9, },	/* 33-73  9189  痩 */
	{ 0x416A, 0x76F8, },	/* 33-74  918A  相 */
	{ 0x416B, 0x7A93, },	/* 33-75  918B  窓 */
	{ 0x416C, 0x7CDF, },	/* 33-76  918C  糟 */
	{ 0x416D, 0x7DCF, },	/* 33-77  918D  総 */
	{ 0x416E, 0x7D9C, },	/* 33-78  918E  綜 */
	{ 0x416F, 0x8061, },	/* 33-79  918F  聡 */
	{ 0x4170, 0x8349, },	/* 33-80  9190  草 */
	{ 0x4171, 0x8358, },	/* 33-81  9191  荘 */
	{ 0x4172, 0x846C, },	/* 33-82  9192  葬 */
	{ 0x4173, 0x84BC, },	/* 33-83  9193  蒼 */
	{ 0x4174, 0x85FB, },	/* 33-84  9194  藻 */
	{ 0x4175, 0x88C5, },	/* 33-85  9195  装 */
	{ 0x4176, 0x8D70, },	/* 33-86  9196  走 */
	{ 0x4177, 0x9001, },	/* 33-87  9197  送 */
	{ 0x4178, 0x906D, },	/* 33-88  9198  遭 */
	{ 0x4179, 0x9397, },	/* 33-89  9199  鎗 */
	{ 0x417A, 0x971C, },	/* 33-90  919A  霜 */
	{ 0x417B, 0x9A12, },	/* 33-91  919B  騒 */
	{ 0x417C, 0x50CF, },	/* 33-92  919C  像 */
	{ 0x417D, 0x5897, },	/* 33-93  919D  増 */
	{ 0x417E, 0x618E, },	/* 33-94  919E  憎 */
	{ 0x4221, 0x81D3, },	/* 34-01  919F  臓 */
	{ 0x4222, 0x8535, },	/* 34-02  91A0  蔵 */
	{ 0x4223, 0x8D08, },	/* 34-03  91A1  贈 */
	{ 0x4224, 0x9020, },	/* 34-04  91A2  造 */
	{ 0x4225, 0x4FC3, },	/* 34-05  91A3  促 */
	{ 0x4226, 0x5074, },	/* 34-06  91A4  側 */
	{ 0x4227, 0x5247, },	/* 34-07  91A5  則 */
	{ 0x4228, 0x5373, },	/* 34-08  91A6  即 */
	{ 0x4229, 0x606F, },	/* 34-09  91A7  息 */
	{ 0x422A, 0x6349, },	/* 34-10  91A8  捉 */
	{ 0x422B, 0x675F, },	/* 34-11  91A9  束 */
	{ 0x422C, 0x6E2C, },	/* 34-12  91AA  測 */
	{ 0x422D, 0x8DB3, },	/* 34-13  91AB  足 */
	{ 0x422E, 0x901F, },	/* 34-14  91AC  速 */
	{ 0x422F, 0x4FD7, },	/* 34-15  91AD  俗 */
	{ 0x4230, 0x5C5E, },	/* 34-16  91AE  属 */
	{ 0x4231, 0x8CCA, },	/* 34-17  91AF  賊 */
	{ 0x4232, 0x65CF, },	/* 34-18  91B0  族 */
	{ 0x4233, 0x7D9A, },	/* 34-19  91B1  続 */
	{ 0x4234, 0x5352, },	/* 34-20  91B2  卒 */
	{ 0x4235, 0x8896, },	/* 34-21  91B3  袖 */
	{ 0x4236, 0x5176, },	/* 34-22  91B4  其 */
	{ 0x4237, 0x63C3, },	/* 34-23  91B5  揃 */
	{ 0x4238, 0x5B58, },	/* 34-24  91B6  存 */
	{ 0x4239, 0x5B6B, },	/* 34-25  91B7  孫 */
	{ 0x423A, 0x5C0A, },	/* 34-26  91B8  尊 */
	{ 0x423B, 0x640D, },	/* 34-27  91B9  損 */
	{ 0x423C, 0x6751, },	/* 34-28  91BA  村 */
	{ 0x423D, 0x905C, },	/* 34-29  91BB  遜 */
	{ 0x423E, 0x4ED6, },	/* 34-30  91BC  他 */
	{ 0x423F, 0x591A, },	/* 34-31  91BD  多 */
	{ 0x4240, 0x592A, },	/* 34-32  91BE  太 */
	{ 0x4241, 0x6C70, },	/* 34-33  91BF  汰 */
	{ 0x4242, 0x8A51, },	/* 34-34  91C0  詑 */
	{ 0x4243, 0x553E, },	/* 34-35  91C1  唾 */
	{ 0x4244, 0x5815, },	/* 34-36  91C2  堕 */
	{ 0x4245, 0x59A5, },	/* 34-37  91C3  妥 */
	{ 0x4246, 0x60F0, },	/* 34-38  91C4  惰 */
	{ 0x4247, 0x6253, },	/* 34-39  91C5  打 */
	{ 0x4248, 0x67C1, },	/* 34-40  91C6  柁 */
	{ 0x4249, 0x8235, },	/* 34-41  91C7  舵 */
	{ 0x424A, 0x6955, },	/* 34-42  91C8  楕 */
	{ 0x424B, 0x9640, },	/* 34-43  91C9  陀 */
	{ 0x424C, 0x99C4, },	/* 34-44  91CA  駄 */
	{ 0x424D, 0x9A28, },	/* 34-45  91CB  騨 */
	{ 0x424E, 0x4F53, },	/* 34-46  91CC  体 */
	{ 0x424F, 0x5806, },	/* 34-47  91CD  堆 */
	{ 0x4250, 0x5BFE, },	/* 34-48  91CE  対 */
	{ 0x4251, 0x8010, },	/* 34-49  91CF  耐 */
	{ 0x4252, 0x5CB1, },	/* 34-50  91D0  岱 */
	{ 0x4253, 0x5E2F, },	/* 34-51  91D1  帯 */
	{ 0x4254, 0x5F85, },	/* 34-52  91D2  待 */
	{ 0x4255, 0x6020, },	/* 34-53  91D3  怠 */
	{ 0x4256, 0x614B, },	/* 34-54  91D4  態 */
	{ 0x4257, 0x6234, },	/* 34-55  91D5  戴 */
	{ 0x4258, 0x66FF, },	/* 34-56  91D6  替 */
	{ 0x4259, 0x6CF0, },	/* 34-57  91D7  泰 */
	{ 0x425A, 0x6EDE, },	/* 34-58  91D8  滞 */
	{ 0x425B, 0x80CE, },	/* 34-59  91D9  胎 */
	{ 0x425C, 0x817F, },	/* 34-60  91DA  腿 */
	{ 0x425D, 0x82D4, },	/* 34-61  91DB  苔 */
	{ 0x425E, 0x888B, },	/* 34-62  91DC  袋 */
	{ 0x425F, 0x8CB8, },	/* 34-63  91DD  貸 */
	{ 0x4260, 0x9000, },	/* 34-64  91DE  退 */
	{ 0x4261, 0x902E, },	/* 34-65  91DF  逮 */
	{ 0x4262, 0x968A, },	/* 34-66  91E0  隊 */
	{ 0x4263, 0x9EDB, },	/* 34-67  91E1  黛 */
	{ 0x4264, 0x9BDB, },	/* 34-68  91E2  鯛 */
	{ 0x4265, 0x4EE3, },	/* 34-69  91E3  代 */
	{ 0x4266, 0x53F0, },	/* 34-70  91E4  台 */
	{ 0x4267, 0x5927, },	/* 34-71  91E5  大 */
	{ 0x4268, 0x7B2C, },	/* 34-72  91E6  第 */
	{ 0x4269, 0x918D, },	/* 34-73  91E7  醍 */
	{ 0x426A, 0x984C, },	/* 34-74  91E8  題 */
	{ 0x426B, 0x9DF9, },	/* 34-75  91E9  鷹 */
	{ 0x426C, 0x6EDD, },	/* 34-76  91EA  滝 */
	{ 0x426D, 0x7027, },	/* 34-77  91EB  瀧 */
	{ 0x426E, 0x5353, },	/* 34-78  91EC  卓 */
	{ 0x426F, 0x5544, },	/* 34-79  91ED  啄 */
	{ 0x4270, 0x5B85, },	/* 34-80  91EE  宅 */
	{ 0x4271, 0x6258, },	/* 34-81  91EF  托 */
	{ 0x4272, 0x629E, },	/* 34-82  91F0  択 */
	{ 0x4273, 0x62D3, },	/* 34-83  91F1  拓 */
	{ 0x4274, 0x6CA2, },	/* 34-84  91F2  沢 */
	{ 0x4275, 0x6FEF, },	/* 34-85  91F3  濯 */
	{ 0x4276, 0x7422, },	/* 34-86  91F4  琢 */
	{ 0x4277, 0x8A17, },	/* 34-87  91F5  託 */
	{ 0x4278, 0x9438, },	/* 34-88  91F6  鐸 */
	{ 0x4279, 0x6FC1, },	/* 34-89  91F7  濁 */
	{ 0x427A, 0x8AFE, },	/* 34-90  91F8  諾 */
	{ 0x427B, 0x8338, },	/* 34-91  91F9  茸 */
	{ 0x427C, 0x51E7, },	/* 34-92  91FA  凧 */
	{ 0x427D, 0x86F8, },	/* 34-93  91FB  蛸 */
	{ 0x427E, 0x53EA, },	/* 34-94  91FC  只 */
	{ 0x4321, 0x53E9, },	/* 35-01  9240  叩 */
	{ 0x4322, 0x4F46, },	/* 35-02  9241  但 */
	{ 0x4323, 0x9054, },	/* 35-03  9242  達 */
	{ 0x4324, 0x8FB0, },	/* 35-04  9243  辰 */
	{ 0x4325, 0x596A, },	/* 35-05  9244  奪 */
	{ 0x4326, 0x8131, },	/* 35-06  9245  脱 */
	{ 0x4327, 0x5DFD, },	/* 35-07  9246  巽 */
	{ 0x4328, 0x7AEA, },	/* 35-08  9247  竪 */
	{ 0x4329, 0x8FBF, },	/* 35-09  9248  辿 */
	{ 0x432A, 0x68DA, },	/* 35-10  9249  棚 */
	{ 0x432B, 0x8C37, },	/* 35-11  924A  谷 */
	{ 0x432C, 0x72F8, },	/* 35-12  924B  狸 */
	{ 0x432D, 0x9C48, },	/* 35-13  924C  鱈 */
	{ 0x432E, 0x6A3D, },	/* 35-14  924D  樽 */
	{ 0x432F, 0x8AB0, },	/* 35-15  924E  誰 */
	{ 0x4330, 0x4E39, },	/* 35-16  924F  丹 */
	{ 0x4331, 0x5358, },	/* 35-17  9250  単 */
	{ 0x4332, 0x5606, },	/* 35-18  9251  嘆 */
	{ 0x4333, 0x5766, },	/* 35-19  9252  坦 */
	{ 0x4334, 0x62C5, },	/* 35-20  9253  担 */
	{ 0x4335, 0x63A2, },	/* 35-21  9254  探 */
	{ 0x4336, 0x65E6, },	/* 35-22  9255  旦 */
	{ 0x4337, 0x6B4E, },	/* 35-23  9256  歎 */
	{ 0x4338, 0x6DE1, },	/* 35-24  9257  淡 */
	{ 0x4339, 0x6E5B, },	/* 35-25  9258  湛 */
	{ 0x433A, 0x70AD, },	/* 35-26  9259  炭 */
	{ 0x433B, 0x77ED, },	/* 35-27  925A  短 */
	{ 0x433C, 0x7AEF, },	/* 35-28  925B  端 */
	{ 0x433D, 0x7BAA, },	/* 35-29  925C  箪 */
	{ 0x433E, 0x7DBB, },	/* 35-30  925D  綻 */
	{ 0x433F, 0x803D, },	/* 35-31  925E  耽 */
	{ 0x4340, 0x80C6, },	/* 35-32  925F  胆 */
	{ 0x4341, 0x86CB, },	/* 35-33  9260  蛋 */
	{ 0x4342, 0x8A95, },	/* 35-34  9261  誕 */
	{ 0x4343, 0x935B, },	/* 35-35  9262  鍛 */
	{ 0x4344, 0x56E3, },	/* 35-36  9263  団 */
	{ 0x4345, 0x58C7, },	/* 35-37  9264  壇 */
	{ 0x4346, 0x5F3E, },	/* 35-38  9265  弾 */
	{ 0x4347, 0x65AD, },	/* 35-39  9266  断 */
	{ 0x4348, 0x6696, },	/* 35-40  9267  暖 */
	{ 0x4349, 0x6A80, },	/* 35-41  9268  檀 */
	{ 0x434A, 0x6BB5, },	/* 35-42  9269  段 */
	{ 0x434B, 0x7537, },	/* 35-43  926A  男 */
	{ 0x434C, 0x8AC7, },	/* 35-44  926B  談 */
	{ 0x434D, 0x5024, },	/* 35-45  926C  値 */
	{ 0x434E, 0x77E5, },	/* 35-46  926D  知 */
	{ 0x434F, 0x5730, },	/* 35-47  926E  地 */
	{ 0x4350, 0x5F1B, },	/* 35-48  926F  弛 */
	{ 0x4351, 0x6065, },	/* 35-49  9270  恥 */
	{ 0x4352, 0x667A, },	/* 35-50  9271  智 */
	{ 0x4353, 0x6C60, },	/* 35-51  9272  池 */
	{ 0x4354, 0x75F4, },	/* 35-52  9273  痴 */
	{ 0x4355, 0x7A1A, },	/* 35-53  9274  稚 */
	{ 0x4356, 0x7F6E, },	/* 35-54  9275  置 */
	{ 0x4357, 0x81F4, },	/* 35-55  9276  致 */
	{ 0x4358, 0x8718, },	/* 35-56  9277  蜘 */
	{ 0x4359, 0x9045, },	/* 35-57  9278  遅 */
	{ 0x435A, 0x99B3, },	/* 35-58  9279  馳 */
	{ 0x435B, 0x7BC9, },	/* 35-59  927A  築 */
	{ 0x435C, 0x755C, },	/* 35-60  927B  畜 */
	{ 0x435D, 0x7AF9, },	/* 35-61  927C  竹 */
	{ 0x435E, 0x7B51, },	/* 35-62  927D  筑 */
	{ 0x435F, 0x84C4, },	/* 35-63  927E  蓄 */
	{ 0x4360, 0x9010, },	/* 35-64  9280  逐 */
	{ 0x4361, 0x79E9, },	/* 35-65  9281  秩 */
	{ 0x4362, 0x7A92, },	/* 35-66  9282  窒 */
	{ 0x4363, 0x8336, },	/* 35-67  9283  茶 */
	{ 0x4364, 0x5AE1, },	/* 35-68  9284  嫡 */
	{ 0x4365, 0x7740, },	/* 35-69  9285  着 */
	{ 0x4366, 0x4E2D, },	/* 35-70  9286  中 */
	{ 0x4367, 0x4EF2, },	/* 35-71  9287  仲 */
	{ 0x4368, 0x5B99, },	/* 35-72  9288  宙 */
	{ 0x4369, 0x5FE0, },	/* 35-73  9289  忠 */
	{ 0x436A, 0x62BD, },	/* 35-74  928A  抽 */
	{ 0x436B, 0x663C, },	/* 35-75  928B  昼 */
	{ 0x436C, 0x67F1, },	/* 35-76  928C  柱 */
	{ 0x436D, 0x6CE8, },	/* 35-77  928D  注 */
	{ 0x436E, 0x866B, },	/* 35-78  928E  虫 */
	{ 0x436F, 0x8877, },	/* 35-79  928F  衷 */
	{ 0x4370, 0x8A3B, },	/* 35-80  9290  註 */
	{ 0x4371, 0x914E, },	/* 35-81  9291  酎 */
	{ 0x4372, 0x92F3, },	/* 35-82  9292  鋳 */
	{ 0x4373, 0x99D0, },	/* 35-83  9293  駐 */
	{ 0x4374, 0x6A17, },	/* 35-84  9294  樗 */
	{ 0x4375, 0x7026, },	/* 35-85  9295  瀦 */
	{ 0x4376, 0x732A, },	/* 35-86  9296  猪 */
	{ 0x4377, 0x82E7, },	/* 35-87  9297  苧 */
	{ 0x4378, 0x8457, },	/* 35-88  9298  著 */
	{ 0x4379, 0x8CAF, },	/* 35-89  9299  貯 */
	{ 0x437A, 0x4E01, },	/* 35-90  929A  丁 */
	{ 0x437B, 0x5146, },	/* 35-91  929B  兆 */
	{ 0x437C, 0x51CB, },	/* 35-92  929C  凋 */
	{ 0x437D, 0x558B, },	/* 35-93  929D  喋 */
	{ 0x437E, 0x5BF5, },	/* 35-94  929E  寵 */
	{ 0x4421, 0x5E16, },	/* 36-01  929F  帖 */
	{ 0x4422, 0x5E33, },	/* 36-02  92A0  帳 */
	{ 0x4423, 0x5E81, },	/* 36-03  92A1  庁 */
	{ 0x4424, 0x5F14, },	/* 36-04  92A2  弔 */
	{ 0x4425, 0x5F35, },	/* 36-05  92A3  張 */
	{ 0x4426, 0x5F6B, },	/* 36-06  92A4  彫 */
	{ 0x4427, 0x5FB4, },	/* 36-07  92A5  徴 */
	{ 0x4428, 0x61F2, },	/* 36-08  92A6  懲 */
	{ 0x4429, 0x6311, },	/* 36-09  92A7  挑 */
	{ 0x442A, 0x66A2, },	/* 36-10  92A8  暢 */
	{ 0x442B, 0x671D, },	/* 36-11  92A9  朝 */
	{ 0x442C, 0x6F6E, },	/* 36-12  92AA  潮 */
	{ 0x442D, 0x7252, },	/* 36-13  92AB  牒 */
	{ 0x442E, 0x753A, },	/* 36-14  92AC  町 */
	{ 0x442F, 0x773A, },	/* 36-15  92AD  眺 */
	{ 0x4430, 0x8074, },	/* 36-16  92AE  聴 */
	{ 0x4431, 0x8139, },	/* 36-17  92AF  脹 */
	{ 0x4432, 0x8178, },	/* 36-18  92B0  腸 */
	{ 0x4433, 0x8776, },	/* 36-19  92B1  蝶 */
	{ 0x4434, 0x8ABF, },	/* 36-20  92B2  調 */
	{ 0x4435, 0x8ADC, },	/* 36-21  92B3  諜 */
	{ 0x4436, 0x8D85, },	/* 36-22  92B4  超 */
	{ 0x4437, 0x8DF3, },	/* 36-23  92B5  跳 */
	{ 0x4438, 0x929A, },	/* 36-24  92B6  銚 */
	{ 0x4439, 0x9577, },	/* 36-25  92B7  長 */
	{ 0x443A, 0x9802, },	/* 36-26  92B8  頂 */
	{ 0x443B, 0x9CE5, },	/* 36-27  92B9  鳥 */
	{ 0x443C, 0x52C5, },	/* 36-28  92BA  勅 */
	{ 0x443D, 0x6357, },	/* 36-29  92BB  捗 */
	{ 0x443E, 0x76F4, },	/* 36-30  92BC  直 */
	{ 0x443F, 0x6715, },	/* 36-31  92BD  朕 */
	{ 0x4440, 0x6C88, },	/* 36-32  92BE  沈 */
	{ 0x4441, 0x73CD, },	/* 36-33  92BF  珍 */
	{ 0x4442, 0x8CC3, },	/* 36-34  92C0  賃 */
	{ 0x4443, 0x93AE, },	/* 36-35  92C1  鎮 */
	{ 0x4444, 0x9673, },	/* 36-36  92C2  陳 */
	{ 0x4445, 0x6D25, },	/* 36-37  92C3  津 */
	{ 0x4446, 0x589C, },	/* 36-38  92C4  墜 */
	{ 0x4447, 0x690E, },	/* 36-39  92C5  椎 */
	{ 0x4448, 0x69CC, },	/* 36-40  92C6  槌 */
	{ 0x4449, 0x8FFD, },	/* 36-41  92C7  追 */
	{ 0x444A, 0x939A, },	/* 36-42  92C8  鎚 */
	{ 0x444B, 0x75DB, },	/* 36-43  92C9  痛 */
	{ 0x444C, 0x901A, },	/* 36-44  92CA  通 */
	{ 0x444D, 0x585A, },	/* 36-45  92CB  塚 */
	{ 0x444E, 0x6802, },	/* 36-46  92CC  栂 */
	{ 0x444F, 0x63B4, },	/* 36-47  92CD  掴 */
	{ 0x4450, 0x69FB, },	/* 36-48  92CE  槻 */
	{ 0x4451, 0x4F43, },	/* 36-49  92CF  佃 */
	{ 0x4452, 0x6F2C, },	/* 36-50  92D0  漬 */
	{ 0x4453, 0x67D8, },	/* 36-51  92D1  柘 */
	{ 0x4454, 0x8FBB, },	/* 36-52  92D2  辻 */
	{ 0x4455, 0x8526, },	/* 36-53  92D3  蔦 */
	{ 0x4456, 0x7DB4, },	/* 36-54  92D4  綴 */
	{ 0x4457, 0x9354, },	/* 36-55  92D5  鍔 */
	{ 0x4458, 0x693F, },	/* 36-56  92D6  椿 */
	{ 0x4459, 0x6F70, },	/* 36-57  92D7  潰 */
	{ 0x445A, 0x576A, },	/* 36-58  92D8  坪 */
	{ 0x445B, 0x58F7, },	/* 36-59  92D9  壷 */
	{ 0x445C, 0x5B2C, },	/* 36-60  92DA  嬬 */
	{ 0x445D, 0x7D2C, },	/* 36-61  92DB  紬 */
	{ 0x445E, 0x722A, },	/* 36-62  92DC  爪 */
	{ 0x445F, 0x540A, },	/* 36-63  92DD  吊 */
	{ 0x4460, 0x91E3, },	/* 36-64  92DE  釣 */
	{ 0x4461, 0x9DB4, },	/* 36-65  92DF  鶴 */
	{ 0x4462, 0x4EAD, },	/* 36-66  92E0  亭 */
	{ 0x4463, 0x4F4E, },	/* 36-67  92E1  低 */
	{ 0x4464, 0x505C, },	/* 36-68  92E2  停 */
	{ 0x4465, 0x5075, },	/* 36-69  92E3  偵 */
	{ 0x4466, 0x5243, },	/* 36-70  92E4  剃 */
	{ 0x4467, 0x8C9E, },	/* 36-71  92E5  貞 */
	{ 0x4468, 0x5448, },	/* 36-72  92E6  呈 */
	{ 0x4469, 0x5824, },	/* 36-73  92E7  堤 */
	{ 0x446A, 0x5B9A, },	/* 36-74  92E8  定 */
	{ 0x446B, 0x5E1D, },	/* 36-75  92E9  帝 */
	{ 0x446C, 0x5E95, },	/* 36-76  92EA  底 */
	{ 0x446D, 0x5EAD, },	/* 36-77  92EB  庭 */
	{ 0x446E, 0x5EF7, },	/* 36-78  92EC  廷 */
	{ 0x446F, 0x5F1F, },	/* 36-79  92ED  弟 */
	{ 0x4470, 0x608C, },	/* 36-80  92EE  悌 */
	{ 0x4471, 0x62B5, },	/* 36-81  92EF  抵 */
	{ 0x4472, 0x633A, },	/* 36-82  92F0  挺 */
	{ 0x4473, 0x63D0, },	/* 36-83  92F1  提 */
	{ 0x4474, 0x68AF, },	/* 36-84  92F2  梯 */
	{ 0x4475, 0x6C40, },	/* 36-85  92F3  汀 */
	{ 0x4476, 0x7887, },	/* 36-86  92F4  碇 */
	{ 0x4477, 0x798E, },	/* 36-87  92F5  禎 */
	{ 0x4478, 0x7A0B, },	/* 36-88  92F6  程 */
	{ 0x4479, 0x7DE0, },	/* 36-89  92F7  締 */
	{ 0x447A, 0x8247, },	/* 36-90  92F8  艇 */
	{ 0x447B, 0x8A02, },	/* 36-91  92F9  訂 */
	{ 0x447C, 0x8AE6, },	/* 36-92  92FA  諦 */
	{ 0x447D, 0x8E44, },	/* 36-93  92FB  蹄 */
	{ 0x447E, 0x9013, },	/* 36-94  92FC  逓 */
	{ 0x4521, 0x90B8, },	/* 37-01  9340  邸 */
	{ 0x4522, 0x912D, },	/* 37-02  9341  鄭 */
	{ 0x4523, 0x91D8, },	/* 37-03  9342  釘 */
	{ 0x4524, 0x9F0E, },	/* 37-04  9343  鼎 */
	{ 0x4525, 0x6CE5, },	/* 37-05  9344  泥 */
	{ 0x4526, 0x6458, },	/* 37-06  9345  摘 */
	{ 0x4527, 0x64E2, },	/* 37-07  9346  擢 */
	{ 0x4528, 0x6575, },	/* 37-08  9347  敵 */
	{ 0x4529, 0x6EF4, },	/* 37-09  9348  滴 */
	{ 0x452A, 0x7684, },	/* 37-10  9349  的 */
	{ 0x452B, 0x7B1B, },	/* 37-11  934A  笛 */
	{ 0x452C, 0x9069, },	/* 37-12  934B  適 */
	{ 0x452D, 0x93D1, },	/* 37-13  934C  鏑 */
	{ 0x452E, 0x6EBA, },	/* 37-14  934D  溺 */
	{ 0x452F, 0x54F2, },	/* 37-15  934E  哲 */
	{ 0x4530, 0x5FB9, },	/* 37-16  934F  徹 */
	{ 0x4531, 0x64A4, },	/* 37-17  9350  撤 */
	{ 0x4532, 0x8F4D, },	/* 37-18  9351  轍 */
	{ 0x4533, 0x8FED, },	/* 37-19  9352  迭 */
	{ 0x4534, 0x9244, },	/* 37-20  9353  鉄 */
	{ 0x4535, 0x5178, },	/* 37-21  9354  典 */
	{ 0x4536, 0x586B, },	/* 37-22  9355  填 */
	{ 0x4537, 0x5929, },	/* 37-23  9356  天 */
	{ 0x4538, 0x5C55, },	/* 37-24  9357  展 */
	{ 0x4539, 0x5E97, },	/* 37-25  9358  店 */
	{ 0x453A, 0x6DFB, },	/* 37-26  9359  添 */
	{ 0x453B, 0x7E8F, },	/* 37-27  935A  纏 */
	{ 0x453C, 0x751C, },	/* 37-28  935B  甜 */
	{ 0x453D, 0x8CBC, },	/* 37-29  935C  貼 */
	{ 0x453E, 0x8EE2, },	/* 37-30  935D  転 */
	{ 0x453F, 0x985B, },	/* 37-31  935E  顛 */
	{ 0x4540, 0x70B9, },	/* 37-32  935F  点 */
	{ 0x4541, 0x4F1D, },	/* 37-33  9360  伝 */
	{ 0x4542, 0x6BBF, },	/* 37-34  9361  殿 */
	{ 0x4543, 0x6FB1, },	/* 37-35  9362  澱 */
	{ 0x4544, 0x7530, },	/* 37-36  9363  田 */
	{ 0x4545, 0x96FB, },	/* 37-37  9364  電 */
	{ 0x4546, 0x514E, },	/* 37-38  9365  兎 */
	{ 0x4547, 0x5410, },	/* 37-39  9366  吐 */
	{ 0x4548, 0x5835, },	/* 37-40  9367  堵 */
	{ 0x4549, 0x5857, },	/* 37-41  9368  塗 */
	{ 0x454A, 0x59AC, },	/* 37-42  9369  妬 */
	{ 0x454B, 0x5C60, },	/* 37-43  936A  屠 */
	{ 0x454C, 0x5F92, },	/* 37-44  936B  徒 */
	{ 0x454D, 0x6597, },	/* 37-45  936C  斗 */
	{ 0x454E, 0x675C, },	/* 37-46  936D  杜 */
	{ 0x454F, 0x6E21, },	/* 37-47  936E  渡 */
	{ 0x4550, 0x767B, },	/* 37-48  936F  登 */
	{ 0x4551, 0x83DF, },	/* 37-49  9370  菟 */
	{ 0x4552, 0x8CED, },	/* 37-50  9371  賭 */
	{ 0x4553, 0x9014, },	/* 37-51  9372  途 */
	{ 0x4554, 0x90FD, },	/* 37-52  9373  都 */
	{ 0x4555, 0x934D, },	/* 37-53  9374  鍍 */
	{ 0x4556, 0x7825, },	/* 37-54  9375  砥 */
	{ 0x4557, 0x783A, },	/* 37-55  9376  砺 */
	{ 0x4558, 0x52AA, },	/* 37-56  9377  努 */
	{ 0x4559, 0x5EA6, },	/* 37-57  9378  度 */
	{ 0x455A, 0x571F, },	/* 37-58  9379  土 */
	{ 0x455B, 0x5974, },	/* 37-59  937A  奴 */
	{ 0x455C, 0x6012, },	/* 37-60  937B  怒 */
	{ 0x455D, 0x5012, },	/* 37-61  937C  倒 */
	{ 0x455E, 0x515A, },	/* 37-62  937D  党 */
	{ 0x455F, 0x51AC, },	/* 37-63  937E  冬 */
	{ 0x4560, 0x51CD, },	/* 37-64  9380  凍 */
	{ 0x4561, 0x5200, },	/* 37-65  9381  刀 */
	{ 0x4562, 0x5510, },	/* 37-66  9382  唐 */
	{ 0x4563, 0x5854, },	/* 37-67  9383  塔 */
	{ 0x4564, 0x5858, },	/* 37-68  9384  塘 */
	{ 0x4565, 0x5957, },	/* 37-69  9385  套 */
	{ 0x4566, 0x5B95, },	/* 37-70  9386  宕 */
	{ 0x4567, 0x5CF6, },	/* 37-71  9387  島 */
	{ 0x4568, 0x5D8B, },	/* 37-72  9388  嶋 */
	{ 0x4569, 0x60BC, },	/* 37-73  9389  悼 */
	{ 0x456A, 0x6295, },	/* 37-74  938A  投 */
	{ 0x456B, 0x642D, },	/* 37-75  938B  搭 */
	{ 0x456C, 0x6771, },	/* 37-76  938C  東 */
	{ 0x456D, 0x6843, },	/* 37-77  938D  桃 */
	{ 0x456E, 0x68BC, },	/* 37-78  938E  梼 */
	{ 0x456F, 0x68DF, },	/* 37-79  938F  棟 */
	{ 0x4570, 0x76D7, },	/* 37-80  9390  盗 */
	{ 0x4571, 0x6DD8, },	/* 37-81  9391  淘 */
	{ 0x4572, 0x6E6F, },	/* 37-82  9392  湯 */
	{ 0x4573, 0x6D9B, },	/* 37-83  9393  涛 */
	{ 0x4574, 0x706F, },	/* 37-84  9394  灯 */
	{ 0x4575, 0x71C8, },	/* 37-85  9395  燈 */
	{ 0x4576, 0x5F53, },	/* 37-86  9396  当 */
	{ 0x4577, 0x75D8, },	/* 37-87  9397  痘 */
	{ 0x4578, 0x7977, },	/* 37-88  9398  祷 */
	{ 0x4579, 0x7B49, },	/* 37-89  9399  等 */
	{ 0x457A, 0x7B54, },	/* 37-90  939A  答 */
	{ 0x457B, 0x7B52, },	/* 37-91  939B  筒 */
	{ 0x457C, 0x7CD6, },	/* 37-92  939C  糖 */
	{ 0x457D, 0x7D71, },	/* 37-93  939D  統 */
	{ 0x457E, 0x5230, },	/* 37-94  939E  到 */
	{ 0x4621, 0x8463, },	/* 38-01  939F  董 */
	{ 0x4622, 0x8569, },	/* 38-02  93A0  蕩 */
	{ 0x4623, 0x85E4, },	/* 38-03  93A1  藤 */
	{ 0x4624, 0x8A0E, },	/* 38-04  93A2  討 */
	{ 0x4625, 0x8B04, },	/* 38-05  93A3  謄 */
	{ 0x4626, 0x8C46, },	/* 38-06  93A4  豆 */
	{ 0x4627, 0x8E0F, },	/* 38-07  93A5  踏 */
	{ 0x4628, 0x9003, },	/* 38-08  93A6  逃 */
	{ 0x4629, 0x900F, },	/* 38-09  93A7  透 */
	{ 0x462A, 0x9419, },	/* 38-10  93A8  鐙 */
	{ 0x462B, 0x9676, },	/* 38-11  93A9  陶 */
	{ 0x462C, 0x982D, },	/* 38-12  93AA  頭 */
	{ 0x462D, 0x9A30, },	/* 38-13  93AB  騰 */
	{ 0x462E, 0x95D8, },	/* 38-14  93AC  闘 */
	{ 0x462F, 0x50CD, },	/* 38-15  93AD  働 */
	{ 0x4630, 0x52D5, },	/* 38-16  93AE  動 */
	{ 0x4631, 0x540C, },	/* 38-17  93AF  同 */
	{ 0x4632, 0x5802, },	/* 38-18  93B0  堂 */
	{ 0x4633, 0x5C0E, },	/* 38-19  93B1  導 */
	{ 0x4634, 0x61A7, },	/* 38-20  93B2  憧 */
	{ 0x4635, 0x649E, },	/* 38-21  93B3  撞 */
	{ 0x4636, 0x6D1E, },	/* 38-22  93B4  洞 */
	{ 0x4637, 0x77B3, },	/* 38-23  93B5  瞳 */
	{ 0x4638, 0x7AE5, },	/* 38-24  93B6  童 */
	{ 0x4639, 0x80F4, },	/* 38-25  93B7  胴 */
	{ 0x463A, 0x8404, },	/* 38-26  93B8  萄 */
	{ 0x463B, 0x9053, },	/* 38-27  93B9  道 */
	{ 0x463C, 0x9285, },	/* 38-28  93BA  銅 */
	{ 0x463D, 0x5CE0, },	/* 38-29  93BB  峠 */
	{ 0x463E, 0x9D07, },	/* 38-30  93BC  鴇 */
	{ 0x463F, 0x533F, },	/* 38-31  93BD  匿 */
	{ 0x4640, 0x5F97, },	/* 38-32  93BE  得 */
	{ 0x4641, 0x5FB3, },	/* 38-33  93BF  徳 */
	{ 0x4642, 0x6D9C, },	/* 38-34  93C0  涜 */
	{ 0x4643, 0x7279, },	/* 38-35  93C1  特 */
	{ 0x4644, 0x7763, },	/* 38-36  93C2  督 */
	{ 0x4645, 0x79BF, },	/* 38-37  93C3  禿 */
	{ 0x4646, 0x7BE4, },	/* 38-38  93C4  篤 */
	{ 0x4647, 0x6BD2, },	/* 38-39  93C5  毒 */
	{ 0x4648, 0x72EC, },	/* 38-40  93C6  独 */
	{ 0x4649, 0x8AAD, },	/* 38-41  93C7  読 */
	{ 0x464A, 0x6803, },	/* 38-42  93C8  栃 */
	{ 0x464B, 0x6A61, },	/* 38-43  93C9  橡 */
	{ 0x464C, 0x51F8, },	/* 38-44  93CA  凸 */
	{ 0x464D, 0x7A81, },	/* 38-45  93CB  突 */
	{ 0x464E, 0x6934, },	/* 38-46  93CC  椴 */
	{ 0x464F, 0x5C4A, },	/* 38-47  93CD  届 */
	{ 0x4650, 0x9CF6, },	/* 38-48  93CE  鳶 */
	{ 0x4651, 0x82EB, },	/* 38-49  93CF  苫 */
	{ 0x4652, 0x5BC5, },	/* 38-50  93D0  寅 */
	{ 0x4653, 0x9149, },	/* 38-51  93D1  酉 */
	{ 0x4654, 0x701E, },	/* 38-52  93D2  瀞 */
	{ 0x4655, 0x5678, },	/* 38-53  93D3  噸 */
	{ 0x4656, 0x5C6F, },	/* 38-54  93D4  屯 */
	{ 0x4657, 0x60C7, },	/* 38-55  93D5  惇 */
	{ 0x4658, 0x6566, },	/* 38-56  93D6  敦 */
	{ 0x4659, 0x6C8C, },	/* 38-57  93D7  沌 */
	{ 0x465A, 0x8C5A, },	/* 38-58  93D8  豚 */
	{ 0x465B, 0x9041, },	/* 38-59  93D9  遁 */
	{ 0x465C, 0x9813, },	/* 38-60  93DA  頓 */
	{ 0x465D, 0x5451, },	/* 38-61  93DB  呑 */
	{ 0x465E, 0x66C7, },	/* 38-62  93DC  曇 */
	{ 0x465F, 0x920D, },	/* 38-63  93DD  鈍 */
	{ 0x4660, 0x5948, },	/* 38-64  93DE  奈 */
	{ 0x4661, 0x90A3, },	/* 38-65  93DF  那 */
	{ 0x4662, 0x5185, },	/* 38-66  93E0  内 */
	{ 0x4663, 0x4E4D, },	/* 38-67  93E1  乍 */
	{ 0x4664, 0x51EA, },	/* 38-68  93E2  凪 */
	{ 0x4665, 0x8599, },	/* 38-69  93E3  薙 */
	{ 0x4666, 0x8B0E, },	/* 38-70  93E4  謎 */
	{ 0x4667, 0x7058, },	/* 38-71  93E5  灘 */
	{ 0x4668, 0x637A, },	/* 38-72  93E6  捺 */
	{ 0x4669, 0x934B, },	/* 38-73  93E7  鍋 */
	{ 0x466A, 0x6962, },	/* 38-74  93E8  楢 */
	{ 0x466B, 0x99B4, },	/* 38-75  93E9  馴 */
	{ 0x466C, 0x7E04, },	/* 38-76  93EA  縄 */
	{ 0x466D, 0x7577, },	/* 38-77  93EB  畷 */
	{ 0x466E, 0x5357, },	/* 38-78  93EC  南 */
	{ 0x466F, 0x6960, },	/* 38-79  93ED  楠 */
	{ 0x4670, 0x8EDF, },	/* 38-80  93EE  軟 */
	{ 0x4671, 0x96E3, },	/* 38-81  93EF  難 */
	{ 0x4672, 0x6C5D, },	/* 38-82  93F0  汝 */
	{ 0x4673, 0x4E8C, },	/* 38-83  93F1  二 */
	{ 0x4674, 0x5C3C, },	/* 38-84  93F2  尼 */
	{ 0x4675, 0x5F10, },	/* 38-85  93F3  弐 */
	{ 0x4676, 0x8FE9, },	/* 38-86  93F4  迩 */
	{ 0x4677, 0x5302, },	/* 38-87  93F5  匂 */
	{ 0x4678, 0x8CD1, },	/* 38-88  93F6  賑 */
	{ 0x4679, 0x8089, },	/* 38-89  93F7  肉 */
	{ 0x467A, 0x8679, },	/* 38-90  93F8  虹 */
	{ 0x467B, 0x5EFF, },	/* 38-91  93F9  廿 */
	{ 0x467C, 0x65E5, },	/* 38-92  93FA  日 */
	{ 0x467D, 0x4E73, },	/* 38-93  93FB  乳 */
	{ 0x467E, 0x5165, },	/* 38-94  93FC  入 */
	{ 0x4721, 0x5982, },	/* 39-01  9440  如 */
	{ 0x4722, 0x5C3F, },	/* 39-02  9441  尿 */
	{ 0x4723, 0x97EE, },	/* 39-03  9442  韮 */
	{ 0x4724, 0x4EFB, },	/* 39-04  9443  任 */
	{ 0x4725, 0x598A, },	/* 39-05  9444  妊 */
	{ 0x4726, 0x5FCD, },	/* 39-06  9445  忍 */
	{ 0x4727, 0x8A8D, },	/* 39-07  9446  認 */
	{ 0x4728, 0x6FE1, },	/* 39-08  9447  濡 */
	{ 0x4729, 0x79B0, },	/* 39-09  9448  禰 */
	{ 0x472A, 0x7962, },	/* 39-10  9449  祢 */
	{ 0x472B, 0x5BE7, },	/* 39-11  944A  寧 */
	{ 0x472C, 0x8471, },	/* 39-12  944B  葱 */
	{ 0x472D, 0x732B, },	/* 39-13  944C  猫 */
	{ 0x472E, 0x71B1, },	/* 39-14  944D  熱 */
	{ 0x472F, 0x5E74, },	/* 39-15  944E  年 */
	{ 0x4730, 0x5FF5, },	/* 39-16  944F  念 */
	{ 0x4731, 0x637B, },	/* 39-17  9450  捻 */
	{ 0x4732, 0x649A, },	/* 39-18  9451  撚 */
	{ 0x4733, 0x71C3, },	/* 39-19  9452  燃 */
	{ 0x4734, 0x7C98, },	/* 39-20  9453  粘 */
	{ 0x4735, 0x4E43, },	/* 39-21  9454  乃 */
	{ 0x4736, 0x5EFC, },	/* 39-22  9455  廼 */
	{ 0x4737, 0x4E4B, },	/* 39-23  9456  之 */
	{ 0x4738, 0x57DC, },	/* 39-24  9457  埜 */
	{ 0x4739, 0x56A2, },	/* 39-25  9458  嚢 */
	{ 0x473A, 0x60A9, },	/* 39-26  9459  悩 */
	{ 0x473B, 0x6FC3, },	/* 39-27  945A  濃 */
	{ 0x473C, 0x7D0D, },	/* 39-28  945B  納 */
	{ 0x473D, 0x80FD, },	/* 39-29  945C  能 */
	{ 0x473E, 0x8133, },	/* 39-30  945D  脳 */
	{ 0x473F, 0x81BF, },	/* 39-31  945E  膿 */
	{ 0x4740, 0x8FB2, },	/* 39-32  945F  農 */
	{ 0x4741, 0x8997, },	/* 39-33  9460  覗 */
	{ 0x4742, 0x86A4, },	/* 39-34  9461  蚤 */
	{ 0x4743, 0x5DF4, },	/* 39-35  9462  巴 */
	{ 0x4744, 0x628A, },	/* 39-36  9463  把 */
	{ 0x4745, 0x64AD, },	/* 39-37  9464  播 */
	{ 0x4746, 0x8987, },	/* 39-38  9465  覇 */
	{ 0x4747, 0x6777, },	/* 39-39  9466  杷 */
	{ 0x4748, 0x6CE2, },	/* 39-40  9467  波 */
	{ 0x4749, 0x6D3E, },	/* 39-41  9468  派 */
	{ 0x474A, 0x7436, },	/* 39-42  9469  琶 */
	{ 0x474B, 0x7834, },	/* 39-43  946A  破 */
	{ 0x474C, 0x5A46, },	/* 39-44  946B  婆 */
	{ 0x474D, 0x7F75, },	/* 39-45  946C  罵 */
	{ 0x474E, 0x82AD, },	/* 39-46  946D  芭 */
	{ 0x474F, 0x99AC, },	/* 39-47  946E  馬 */
	{ 0x4750, 0x4FF3, },	/* 39-48  946F  俳 */
	{ 0x4751, 0x5EC3, },	/* 39-49  9470  廃 */
	{ 0x4752, 0x62DD, },	/* 39-50  9471  拝 */
	{ 0x4753, 0x6392, },	/* 39-51  9472  排 */
	{ 0x4754, 0x6557, },	/* 39-52  9473  敗 */
	{ 0x4755, 0x676F, },	/* 39-53  9474  杯 */
	{ 0x4756, 0x76C3, },	/* 39-54  9475  盃 */
	{ 0x4757, 0x724C, },	/* 39-55  9476  牌 */
	{ 0x4758, 0x80CC, },	/* 39-56  9477  背 */
	{ 0x4759, 0x80BA, },	/* 39-57  9478  肺 */
	{ 0x475A, 0x8F29, },	/* 39-58  9479  輩 */
	{ 0x475B, 0x914D, },	/* 39-59  947A  配 */
	{ 0x475C, 0x500D, },	/* 39-60  947B  倍 */
	{ 0x475D, 0x57F9, },	/* 39-61  947C  培 */
	{ 0x475E, 0x5A92, },	/* 39-62  947D  媒 */
	{ 0x475F, 0x6885, },	/* 39-63  947E  梅 */
	{ 0x4760, 0x6973, },	/* 39-64  9480  楳 */
	{ 0x4761, 0x7164, },	/* 39-65  9481  煤 */
	{ 0x4762, 0x72FD, },	/* 39-66  9482  狽 */
	{ 0x4763, 0x8CB7, },	/* 39-67  9483  買 */
	{ 0x4764, 0x58F2, },	/* 39-68  9484  売 */
	{ 0x4765, 0x8CE0, },	/* 39-69  9485  賠 */
	{ 0x4766, 0x966A, },	/* 39-70  9486  陪 */
	{ 0x4767, 0x9019, },	/* 39-71  9487  這 */
	{ 0x4768, 0x877F, },	/* 39-72  9488  蝿 */
	{ 0x4769, 0x79E4, },	/* 39-73  9489  秤 */
	{ 0x476A, 0x77E7, },	/* 39-74  948A  矧 */
	{ 0x476B, 0x8429, },	/* 39-75  948B  萩 */
	{ 0x476C, 0x4F2F, },	/* 39-76  948C  伯 */
	{ 0x476D, 0x5265, },	/* 39-77  948D  剥 */
	{ 0x476E, 0x535A, },	/* 39-78  948E  博 */
	{ 0x476F, 0x62CD, },	/* 39-79  948F  拍 */
	{ 0x4770, 0x67CF, },	/* 39-80  9490  柏 */
	{ 0x4771, 0x6CCA, },	/* 39-81  9491  泊 */
	{ 0x4772, 0x767D, },	/* 39-82  9492  白 */
	{ 0x4773, 0x7B94, },	/* 39-83  9493  箔 */
	{ 0x4774, 0x7C95, },	/* 39-84  9494  粕 */
	{ 0x4775, 0x8236, },	/* 39-85  9495  舶 */
	{ 0x4776, 0x8584, },	/* 39-86  9496  薄 */
	{ 0x4777, 0x8FEB, },	/* 39-87  9497  迫 */
	{ 0x4778, 0x66DD, },	/* 39-88  9498  曝 */
	{ 0x4779, 0x6F20, },	/* 39-89  9499  漠 */
	{ 0x477A, 0x7206, },	/* 39-90  949A  爆 */
	{ 0x477B, 0x7E1B, },	/* 39-91  949B  縛 */
	{ 0x477C, 0x83AB, },	/* 39-92  949C  莫 */
	{ 0x477D, 0x99C1, },	/* 39-93  949D  駁 */
	{ 0x477E, 0x9EA6, },	/* 39-94  949E  麦 */
	{ 0x4821, 0x51FD, },	/* 40-01  949F  函 */
	{ 0x4822, 0x7BB1, },	/* 40-02  94A0  箱 */
	{ 0x4823, 0x7872, },	/* 40-03  94A1  硲 */
	{ 0x4824, 0x7BB8, },	/* 40-04  94A2  箸 */
	{ 0x4825, 0x8087, },	/* 40-05  94A3  肇 */
	{ 0x4826, 0x7B48, },	/* 40-06  94A4  筈 */
	{ 0x4827, 0x6AE8, },	/* 40-07  94A5  櫨 */
	{ 0x4828, 0x5E61, },	/* 40-08  94A6  幡 */
	{ 0x4829, 0x808C, },	/* 40-09  94A7  肌 */
	{ 0x482A, 0x7551, },	/* 40-10  94A8  畑 */
	{ 0x482B, 0x7560, },	/* 40-11  94A9  畠 */
	{ 0x482C, 0x516B, },	/* 40-12  94AA  八 */
	{ 0x482D, 0x9262, },	/* 40-13  94AB  鉢 */
	{ 0x482E, 0x6E8C, },	/* 40-14  94AC  溌 */
	{ 0x482F, 0x767A, },	/* 40-15  94AD  発 */
	{ 0x4830, 0x9197, },	/* 40-16  94AE  醗 */
	{ 0x4831, 0x9AEA, },	/* 40-17  94AF  髪 */
	{ 0x4832, 0x4F10, },	/* 40-18  94B0  伐 */
	{ 0x4833, 0x7F70, },	/* 40-19  94B1  罰 */
	{ 0x4834, 0x629C, },	/* 40-20  94B2  抜 */
	{ 0x4835, 0x7B4F, },	/* 40-21  94B3  筏 */
	{ 0x4836, 0x95A5, },	/* 40-22  94B4  閥 */
	{ 0x4837, 0x9CE9, },	/* 40-23  94B5  鳩 */
	{ 0x4838, 0x567A, },	/* 40-24  94B6  噺 */
	{ 0x4839, 0x5859, },	/* 40-25  94B7  塙 */
	{ 0x483A, 0x86E4, },	/* 40-26  94B8  蛤 */
	{ 0x483B, 0x96BC, },	/* 40-27  94B9  隼 */
	{ 0x483C, 0x4F34, },	/* 40-28  94BA  伴 */
	{ 0x483D, 0x5224, },	/* 40-29  94BB  判 */
	{ 0x483E, 0x534A, },	/* 40-30  94BC  半 */
	{ 0x483F, 0x53CD, },	/* 40-31  94BD  反 */
	{ 0x4840, 0x53DB, },	/* 40-32  94BE  叛 */
	{ 0x4841, 0x5E06, },	/* 40-33  94BF  帆 */
	{ 0x4842, 0x642C, },	/* 40-34  94C0  搬 */
	{ 0x4843, 0x6591, },	/* 40-35  94C1  斑 */
	{ 0x4844, 0x677F, },	/* 40-36  94C2  板 */
	{ 0x4845, 0x6C3E, },	/* 40-37  94C3  氾 */
	{ 0x4846, 0x6C4E, },	/* 40-38  94C4  汎 */
	{ 0x4847, 0x7248, },	/* 40-39  94C5  版 */
	{ 0x4848, 0x72AF, },	/* 40-40  94C6  犯 */
	{ 0x4849, 0x73ED, },	/* 40-41  94C7  班 */
	{ 0x484A, 0x7554, },	/* 40-42  94C8  畔 */
	{ 0x484B, 0x7E41, },	/* 40-43  94C9  繁 */
	{ 0x484C, 0x822C, },	/* 40-44  94CA  般 */
	{ 0x484D, 0x85E9, },	/* 40-45  94CB  藩 */
	{ 0x484E, 0x8CA9, },	/* 40-46  94CC  販 */
	{ 0x484F, 0x7BC4, },	/* 40-47  94CD  範 */
	{ 0x4850, 0x91C6, },	/* 40-48  94CE  釆 */
	{ 0x4851, 0x7169, },	/* 40-49  94CF  煩 */
	{ 0x4852, 0x9812, },	/* 40-50  94D0  頒 */
	{ 0x4853, 0x98EF, },	/* 40-51  94D1  飯 */
	{ 0x4854, 0x633D, },	/* 40-52  94D2  挽 */
	{ 0x4855, 0x6669, },	/* 40-53  94D3  晩 */
	{ 0x4856, 0x756A, },	/* 40-54  94D4  番 */
	{ 0x4857, 0x76E4, },	/* 40-55  94D5  盤 */
	{ 0x4858, 0x78D0, },	/* 40-56  94D6  磐 */
	{ 0x4859, 0x8543, },	/* 40-57  94D7  蕃 */
	{ 0x485A, 0x86EE, },	/* 40-58  94D8  蛮 */
	{ 0x485B, 0x532A, },	/* 40-59  94D9  匪 */
	{ 0x485C, 0x5351, },	/* 40-60  94DA  卑 */
	{ 0x485D, 0x5426, },	/* 40-61  94DB  否 */
	{ 0x485E, 0x5983, },	/* 40-62  94DC  妃 */
	{ 0x485F, 0x5E87, },	/* 40-63  94DD  庇 */
	{ 0x4860, 0x5F7C, },	/* 40-64  94DE  彼 */
	{ 0x4861, 0x60B2, },	/* 40-65  94DF  悲 */
	{ 0x4862, 0x6249, },	/* 40-66  94E0  扉 */
	{ 0x4863, 0x6279, },	/* 40-67  94E1  批 */
	{ 0x4864, 0x62AB, },	/* 40-68  94E2  披 */
	{ 0x4865, 0x6590, },	/* 40-69  94E3  斐 */
	{ 0x4866, 0x6BD4, },	/* 40-70  94E4  比 */
	{ 0x4867, 0x6CCC, },	/* 40-71  94E5  泌 */
	{ 0x4868, 0x75B2, },	/* 40-72  94E6  疲 */
	{ 0x4869, 0x76AE, },	/* 40-73  94E7  皮 */
	{ 0x486A, 0x7891, },	/* 40-74  94E8  碑 */
	{ 0x486B, 0x79D8, },	/* 40-75  94E9  秘 */
	{ 0x486C, 0x7DCB, },	/* 40-76  94EA  緋 */
	{ 0x486D, 0x7F77, },	/* 40-77  94EB  罷 */
	{ 0x486E, 0x80A5, },	/* 40-78  94EC  肥 */
	{ 0x486F, 0x88AB, },	/* 40-79  94ED  被 */
	{ 0x4870, 0x8AB9, },	/* 40-80  94EE  誹 */
	{ 0x4871, 0x8CBB, },	/* 40-81  94EF  費 */
	{ 0x4872, 0x907F, },	/* 40-82  94F0  避 */
	{ 0x4873, 0x975E, },	/* 40-83  94F1  非 */
	{ 0x4874, 0x98DB, },	/* 40-84  94F2  飛 */
	{ 0x4875, 0x6A0B, },	/* 40-85  94F3  樋 */
	{ 0x4876, 0x7C38, },	/* 40-86  94F4  簸 */
	{ 0x4877, 0x5099, },	/* 40-87  94F5  備 */
	{ 0x4878, 0x5C3E, },	/* 40-88  94F6  尾 */
	{ 0x4879, 0x5FAE, },	/* 40-89  94F7  微 */
	{ 0x487A, 0x6787, },	/* 40-90  94F8  枇 */
	{ 0x487B, 0x6BD8, },	/* 40-91  94F9  毘 */
	{ 0x487C, 0x7435, },	/* 40-92  94FA  琵 */
	{ 0x487D, 0x7709, },	/* 40-93  94FB  眉 */
	{ 0x487E, 0x7F8E, },	/* 40-94  94FC  美 */
	{ 0x4921, 0x9F3B, },	/* 41-01  9540  鼻 */
	{ 0x4922, 0x67CA, },	/* 41-02  9541  柊 */
	{ 0x4923, 0x7A17, },	/* 41-03  9542  稗 */
	{ 0x4924, 0x5339, },	/* 41-04  9543  匹 */
	{ 0x4925, 0x758B, },	/* 41-05  9544  疋 */
	{ 0x4926, 0x9AED, },	/* 41-06  9545  髭 */
	{ 0x4927, 0x5F66, },	/* 41-07  9546  彦 */
	{ 0x4928, 0x819D, },	/* 41-08  9547  膝 */
	{ 0x4929, 0x83F1, },	/* 41-09  9548  菱 */
	{ 0x492A, 0x8098, },	/* 41-10  9549  肘 */
	{ 0x492B, 0x5F3C, },	/* 41-11  954A  弼 */
	{ 0x492C, 0x5FC5, },	/* 41-12  954B  必 */
	{ 0x492D, 0x7562, },	/* 41-13  954C  畢 */
	{ 0x492E, 0x7B46, },	/* 41-14  954D  筆 */
	{ 0x492F, 0x903C, },	/* 41-15  954E  逼 */
	{ 0x4930, 0x6867, },	/* 41-16  954F  桧 */
	{ 0x4931, 0x59EB, },	/* 41-17  9550  姫 */
	{ 0x4932, 0x5A9B, },	/* 41-18  9551  媛 */
	{ 0x4933, 0x7D10, },	/* 41-19  9552  紐 */
	{ 0x4934, 0x767E, },	/* 41-20  9553  百 */
	{ 0x4935, 0x8B2C, },	/* 41-21  9554  謬 */
	{ 0x4936, 0x4FF5, },	/* 41-22  9555  俵 */
	{ 0x4937, 0x5F6A, },	/* 41-23  9556  彪 */
	{ 0x4938, 0x6A19, },	/* 41-24  9557  標 */
	{ 0x4939, 0x6C37, },	/* 41-25  9558  氷 */
	{ 0x493A, 0x6F02, },	/* 41-26  9559  漂 */
	{ 0x493B, 0x74E2, },	/* 41-27  955A  瓢 */
	{ 0x493C, 0x7968, },	/* 41-28  955B  票 */
	{ 0x493D, 0x8868, },	/* 41-29  955C  表 */
	{ 0x493E, 0x8A55, },	/* 41-30  955D  評 */
	{ 0x493F, 0x8C79, },	/* 41-31  955E  豹 */
	{ 0x4940, 0x5EDF, },	/* 41-32  955F  廟 */
	{ 0x4941, 0x63CF, },	/* 41-33  9560  描 */
	{ 0x4942, 0x75C5, },	/* 41-34  9561  病 */
	{ 0x4943, 0x79D2, },	/* 41-35  9562  秒 */
	{ 0x4944, 0x82D7, },	/* 41-36  9563  苗 */
	{ 0x4945, 0x9328, },	/* 41-37  9564  錨 */
	{ 0x4946, 0x92F2, },	/* 41-38  9565  鋲 */
	{ 0x4947, 0x849C, },	/* 41-39  9566  蒜 */
	{ 0x4948, 0x86ED, },	/* 41-40  9567  蛭 */
	{ 0x4949, 0x9C2D, },	/* 41-41  9568  鰭 */
	{ 0x494A, 0x54C1, },	/* 41-42  9569  品 */
	{ 0x494B, 0x5F6C, },	/* 41-43  956A  彬 */
	{ 0x494C, 0x658C, },	/* 41-44  956B  斌 */
	{ 0x494D, 0x6D5C, },	/* 41-45  956C  浜 */
	{ 0x494E, 0x7015, },	/* 41-46  956D  瀕 */
	{ 0x494F, 0x8CA7, },	/* 41-47  956E  貧 */
	{ 0x4950, 0x8CD3, },	/* 41-48  956F  賓 */
	{ 0x4951, 0x983B, },	/* 41-49  9570  頻 */
	{ 0x4952, 0x654F, },	/* 41-50  9571  敏 */
	{ 0x4953, 0x74F6, },	/* 41-51  9572  瓶 */
	{ 0x4954, 0x4E0D, },	/* 41-52  9573  不 */
	{ 0x4955, 0x4ED8, },	/* 41-53  9574  付 */
	{ 0x4956, 0x57E0, },	/* 41-54  9575  埠 */
	{ 0x4957, 0x592B, },	/* 41-55  9576  夫 */
	{ 0x4958, 0x5A66, },	/* 41-56  9577  婦 */
	{ 0x4959, 0x5BCC, },	/* 41-57  9578  富 */
	{ 0x495A, 0x51A8, },	/* 41-58  9579  冨 */
	{ 0x495B, 0x5E03, },	/* 41-59  957A  布 */
	{ 0x495C, 0x5E9C, },	/* 41-60  957B  府 */
	{ 0x495D, 0x6016, },	/* 41-61  957C  怖 */
	{ 0x495E, 0x6276, },	/* 41-62  957D  扶 */
	{ 0x495F, 0x6577, },	/* 41-63  957E  敷 */
	{ 0x4960, 0x65A7, },	/* 41-64  9580  斧 */
	{ 0x4961, 0x666E, },	/* 41-65  9581  普 */
	{ 0x4962, 0x6D6E, },	/* 41-66  9582  浮 */
	{ 0x4963, 0x7236, },	/* 41-67  9583  父 */
	{ 0x4964, 0x7B26, },	/* 41-68  9584  符 */
	{ 0x4965, 0x8150, },	/* 41-69  9585  腐 */
	{ 0x4966, 0x819A, },	/* 41-70  9586  膚 */
	{ 0x4967, 0x8299, },	/* 41-71  9587  芙 */
	{ 0x4968, 0x8B5C, },	/* 41-72  9588  譜 */
	{ 0x4969, 0x8CA0, },	/* 41-73  9589  負 */
	{ 0x496A, 0x8CE6, },	/* 41-74  958A  賦 */
	{ 0x496B, 0x8D74, },	/* 41-75  958B  赴 */
	{ 0x496C, 0x961C, },	/* 41-76  958C  阜 */
	{ 0x496D, 0x9644, },	/* 41-77  958D  附 */
	{ 0x496E, 0x4FAE, },	/* 41-78  958E  侮 */
	{ 0x496F, 0x64AB, },	/* 41-79  958F  撫 */
	{ 0x4970, 0x6B66, },	/* 41-80  9590  武 */
	{ 0x4971, 0x821E, },	/* 41-81  9591  舞 */
	{ 0x4972, 0x8461, },	/* 41-82  9592  葡 */
	{ 0x4973, 0x856A, },	/* 41-83  9593  蕪 */
	{ 0x4974, 0x90E8, },	/* 41-84  9594  部 */
	{ 0x4975, 0x5C01, },	/* 41-85  9595  封 */
	{ 0x4976, 0x6953, },	/* 41-86  9596  楓 */
	{ 0x4977, 0x98A8, },	/* 41-87  9597  風 */
	{ 0x4978, 0x847A, },	/* 41-88  9598  葺 */
	{ 0x4979, 0x8557, },	/* 41-89  9599  蕗 */
	{ 0x497A, 0x4F0F, },	/* 41-90  959A  伏 */
	{ 0x497B, 0x526F, },	/* 41-91  959B  副 */
	{ 0x497C, 0x5FA9, },	/* 41-92  959C  復 */
	{ 0x497D, 0x5E45, },	/* 41-93  959D  幅 */
	{ 0x497E, 0x670D, },	/* 41-94  959E  服 */
	{ 0x4A21, 0x798F, },	/* 42-01  959F  福 */
	{ 0x4A22, 0x8179, },	/* 42-02  95A0  腹 */
	{ 0x4A23, 0x8907, },	/* 42-03  95A1  複 */
	{ 0x4A24, 0x8986, },	/* 42-04  95A2  覆 */
	{ 0x4A25, 0x6DF5, },	/* 42-05  95A3  淵 */
	{ 0x4A26, 0x5F17, },	/* 42-06  95A4  弗 */
	{ 0x4A27, 0x6255, },	/* 42-07  95A5  払 */
	{ 0x4A28, 0x6CB8, },	/* 42-08  95A6  沸 */
	{ 0x4A29, 0x4ECF, },	/* 42-09  95A7  仏 */
	{ 0x4A2A, 0x7269, },	/* 42-10  95A8  物 */
	{ 0x4A2B, 0x9B92, },	/* 42-11  95A9  鮒 */
	{ 0x4A2C, 0x5206, },	/* 42-12  95AA  分 */
	{ 0x4A2D, 0x543B, },	/* 42-13  95AB  吻 */
	{ 0x4A2E, 0x5674, },	/* 42-14  95AC  噴 */
	{ 0x4A2F, 0x58B3, },	/* 42-15  95AD  墳 */
	{ 0x4A30, 0x61A4, },	/* 42-16  95AE  憤 */
	{ 0x4A31, 0x626E, },	/* 42-17  95AF  扮 */
	{ 0x4A32, 0x711A, },	/* 42-18  95B0  焚 */
	{ 0x4A33, 0x596E, },	/* 42-19  95B1  奮 */
	{ 0x4A34, 0x7C89, },	/* 42-20  95B2  粉 */
	{ 0x4A35, 0x7CDE, },	/* 42-21  95B3  糞 */
	{ 0x4A36, 0x7D1B, },	/* 42-22  95B4  紛 */
	{ 0x4A37, 0x96F0, },	/* 42-23  95B5  雰 */
	{ 0x4A38, 0x6587, },	/* 42-24  95B6  文 */
	{ 0x4A39, 0x805E, },	/* 42-25  95B7  聞 */
	{ 0x4A3A, 0x4E19, },	/* 42-26  95B8  丙 */
	{ 0x4A3B, 0x4F75, },	/* 42-27  95B9  併 */
	{ 0x4A3C, 0x5175, },	/* 42-28  95BA  兵 */
	{ 0x4A3D, 0x5840, },	/* 42-29  95BB  塀 */
	{ 0x4A3E, 0x5E63, },	/* 42-30  95BC  幣 */
	{ 0x4A3F, 0x5E73, },	/* 42-31  95BD  平 */
	{ 0x4A40, 0x5F0A, },	/* 42-32  95BE  弊 */
	{ 0x4A41, 0x67C4, },	/* 42-33  95BF  柄 */
	{ 0x4A42, 0x4E26, },	/* 42-34  95C0  並 */
	{ 0x4A43, 0x853D, },	/* 42-35  95C1  蔽 */
	{ 0x4A44, 0x9589, },	/* 42-36  95C2  閉 */
	{ 0x4A45, 0x965B, },	/* 42-37  95C3  陛 */
	{ 0x4A46, 0x7C73, },	/* 42-38  95C4  米 */
	{ 0x4A47, 0x9801, },	/* 42-39  95C5  頁 */
	{ 0x4A48, 0x50FB, },	/* 42-40  95C6  僻 */
	{ 0x4A49, 0x58C1, },	/* 42-41  95C7  壁 */
	{ 0x4A4A, 0x7656, },	/* 42-42  95C8  癖 */
	{ 0x4A4B, 0x78A7, },	/* 42-43  95C9  碧 */
	{ 0x4A4C, 0x5225, },	/* 42-44  95CA  別 */
	{ 0x4A4D, 0x77A5, },	/* 42-45  95CB  瞥 */
	{ 0x4A4E, 0x8511, },	/* 42-46  95CC  蔑 */
	{ 0x4A4F, 0x7B86, },	/* 42-47  95CD  箆 */
	{ 0x4A50, 0x504F, },	/* 42-48  95CE  偏 */
	{ 0x4A51, 0x5909, },	/* 42-49  95CF  変 */
	{ 0x4A52, 0x7247, },	/* 42-50  95D0  片 */
	{ 0x4A53, 0x7BC7, },	/* 42-51  95D1  篇 */
	{ 0x4A54, 0x7DE8, },	/* 42-52  95D2  編 */
	{ 0x4A55, 0x8FBA, },	/* 42-53  95D3  辺 */
	{ 0x4A56, 0x8FD4, },	/* 42-54  95D4  返 */
	{ 0x4A57, 0x904D, },	/* 42-55  95D5  遍 */
	{ 0x4A58, 0x4FBF, },	/* 42-56  95D6  便 */
	{ 0x4A59, 0x52C9, },	/* 42-57  95D7  勉 */
	{ 0x4A5A, 0x5A29, },	/* 42-58  95D8  娩 */
	{ 0x4A5B, 0x5F01, },	/* 42-59  95D9  弁 */
	{ 0x4A5C, 0x97AD, },	/* 42-60  95DA  鞭 */
	{ 0x4A5D, 0x4FDD, },	/* 42-61  95DB  保 */
	{ 0x4A5E, 0x8217, },	/* 42-62  95DC  舗 */
	{ 0x4A5F, 0x92EA, },	/* 42-63  95DD  鋪 */
	{ 0x4A60, 0x5703, },	/* 42-64  95DE  圃 */
	{ 0x4A61, 0x6355, },	/* 42-65  95DF  捕 */
	{ 0x4A62, 0x6B69, },	/* 42-66  95E0  歩 */
	{ 0x4A63, 0x752B, },	/* 42-67  95E1  甫 */
	{ 0x4A64, 0x88DC, },	/* 42-68  95E2  補 */
	{ 0x4A65, 0x8F14, },	/* 42-69  95E3  輔 */
	{ 0x4A66, 0x7A42, },	/* 42-70  95E4  穂 */
	{ 0x4A67, 0x52DF, },	/* 42-71  95E5  募 */
	{ 0x4A68, 0x5893, },	/* 42-72  95E6  墓 */
	{ 0x4A69, 0x6155, },	/* 42-73  95E7  慕 */
	{ 0x4A6A, 0x620A, },	/* 42-74  95E8  戊 */
	{ 0x4A6B, 0x66AE, },	/* 42-75  95E9  暮 */
	{ 0x4A6C, 0x6BCD, },	/* 42-76  95EA  母 */
	{ 0x4A6D, 0x7C3F, },	/* 42-77  95EB  簿 */
	{ 0x4A6E, 0x83E9, },	/* 42-78  95EC  菩 */
	{ 0x4A6F, 0x5023, },	/* 42-79  95ED  倣 */
	{ 0x4A70, 0x4FF8, },	/* 42-80  95EE  俸 */
	{ 0x4A71, 0x5305, },	/* 42-81  95EF  包 */
	{ 0x4A72, 0x5446, },	/* 42-82  95F0  呆 */
	{ 0x4A73, 0x5831, },	/* 42-83  95F1  報 */
	{ 0x4A74, 0x5949, },	/* 42-84  95F2  奉 */
	{ 0x4A75, 0x5B9D, },	/* 42-85  95F3  宝 */
	{ 0x4A76, 0x5CF0, },	/* 42-86  95F4  峰 */
	{ 0x4A77, 0x5CEF, },	/* 42-87  95F5  峯 */
	{ 0x4A78, 0x5D29, },	/* 42-88  95F6  崩 */
	{ 0x4A79, 0x5E96, },	/* 42-89  95F7  庖 */
	{ 0x4A7A, 0x62B1, },	/* 42-90  95F8  抱 */
	{ 0x4A7B, 0x6367, },	/* 42-91  95F9  捧 */
	{ 0x4A7C, 0x653E, },	/* 42-92  95FA  放 */
	{ 0x4A7D, 0x65B9, },	/* 42-93  95FB  方 */
	{ 0x4A7E, 0x670B, },	/* 42-94  95FC  朋 */
	{ 0x4B21, 0x6CD5, },	/* 43-01  9640  法 */
	{ 0x4B22, 0x6CE1, },	/* 43-02  9641  泡 */
	{ 0x4B23, 0x70F9, },	/* 43-03  9642  烹 */
	{ 0x4B24, 0x7832, },	/* 43-04  9643  砲 */
	{ 0x4B25, 0x7E2B, },	/* 43-05  9644  縫 */
	{ 0x4B26, 0x80DE, },	/* 43-06  9645  胞 */
	{ 0x4B27, 0x82B3, },	/* 43-07  9646  芳 */
	{ 0x4B28, 0x840C, },	/* 43-08  9647  萌 */
	{ 0x4B29, 0x84EC, },	/* 43-09  9648  蓬 */
	{ 0x4B2A, 0x8702, },	/* 43-10  9649  蜂 */
	{ 0x4B2B, 0x8912, },	/* 43-11  964A  褒 */
	{ 0x4B2C, 0x8A2A, },	/* 43-12  964B  訪 */
	{ 0x4B2D, 0x8C4A, },	/* 43-13  964C  豊 */
	{ 0x4B2E, 0x90A6, },	/* 43-14  964D  邦 */
	{ 0x4B2F, 0x92D2, },	/* 43-15  964E  鋒 */
	{ 0x4B30, 0x98FD, },	/* 43-16  964F  飽 */
	{ 0x4B31, 0x9CF3, },	/* 43-17  9650  鳳 */
	{ 0x4B32, 0x9D6C, },	/* 43-18  9651  鵬 */
	{ 0x4B33, 0x4E4F, },	/* 43-19  9652  乏 */
	{ 0x4B34, 0x4EA1, },	/* 43-20  9653  亡 */
	{ 0x4B35, 0x508D, },	/* 43-21  9654  傍 */
	{ 0x4B36, 0x5256, },	/* 43-22  9655  剖 */
	{ 0x4B37, 0x574A, },	/* 43-23  9656  坊 */
	{ 0x4B38, 0x59A8, },	/* 43-24  9657  妨 */
	{ 0x4B39, 0x5E3D, },	/* 43-25  9658  帽 */
	{ 0x4B3A, 0x5FD8, },	/* 43-26  9659  忘 */
	{ 0x4B3B, 0x5FD9, },	/* 43-27  965A  忙 */
	{ 0x4B3C, 0x623F, },	/* 43-28  965B  房 */
	{ 0x4B3D, 0x66B4, },	/* 43-29  965C  暴 */
	{ 0x4B3E, 0x671B, },	/* 43-30  965D  望 */
	{ 0x4B3F, 0x67D0, },	/* 43-31  965E  某 */
	{ 0x4B40, 0x68D2, },	/* 43-32  965F  棒 */
	{ 0x4B41, 0x5192, },	/* 43-33  9660  冒 */
	{ 0x4B42, 0x7D21, },	/* 43-34  9661  紡 */
	{ 0x4B43, 0x80AA, },	/* 43-35  9662  肪 */
	{ 0x4B44, 0x81A8, },	/* 43-36  9663  膨 */
	{ 0x4B45, 0x8B00, },	/* 43-37  9664  謀 */
	{ 0x4B46, 0x8C8C, },	/* 43-38  9665  貌 */
	{ 0x4B47, 0x8CBF, },	/* 43-39  9666  貿 */
	{ 0x4B48, 0x927E, },	/* 43-40  9667  鉾 */
	{ 0x4B49, 0x9632, },	/* 43-41  9668  防 */
	{ 0x4B4A, 0x5420, },	/* 43-42  9669  吠 */
	{ 0x4B4B, 0x982C, },	/* 43-43  966A  頬 */
	{ 0x4B4C, 0x5317, },	/* 43-44  966B  北 */
	{ 0x4B4D, 0x50D5, },	/* 43-45  966C  僕 */
	{ 0x4B4E, 0x535C, },	/* 43-46  966D  卜 */
	{ 0x4B4F, 0x58A8, },	/* 43-47  966E  墨 */
	{ 0x4B50, 0x64B2, },	/* 43-48  966F  撲 */
	{ 0x4B51, 0x6734, },	/* 43-49  9670  朴 */
	{ 0x4B52, 0x7267, },	/* 43-50  9671  牧 */
	{ 0x4B53, 0x7766, },	/* 43-51  9672  睦 */
	{ 0x4B54, 0x7A46, },	/* 43-52  9673  穆 */
	{ 0x4B55, 0x91E6, },	/* 43-53  9674  釦 */
	{ 0x4B56, 0x52C3, },	/* 43-54  9675  勃 */
	{ 0x4B57, 0x6CA1, },	/* 43-55  9676  没 */
	{ 0x4B58, 0x6B86, },	/* 43-56  9677  殆 */
	{ 0x4B59, 0x5800, },	/* 43-57  9678  堀 */
	{ 0x4B5A, 0x5E4C, },	/* 43-58  9679  幌 */
	{ 0x4B5B, 0x5954, },	/* 43-59  967A  奔 */
	{ 0x4B5C, 0x672C, },	/* 43-60  967B  本 */
	{ 0x4B5D, 0x7FFB, },	/* 43-61  967C  翻 */
	{ 0x4B5E, 0x51E1, },	/* 43-62  967D  凡 */
	{ 0x4B5F, 0x76C6, },	/* 43-63  967E  盆 */
	{ 0x4B60, 0x6469, },	/* 43-64  9680  摩 */
	{ 0x4B61, 0x78E8, },	/* 43-65  9681  磨 */
	{ 0x4B62, 0x9B54, },	/* 43-66  9682  魔 */
	{ 0x4B63, 0x9EBB, },	/* 43-67  9683  麻 */
	{ 0x4B64, 0x57CB, },	/* 43-68  9684  埋 */
	{ 0x4B65, 0x59B9, },	/* 43-69  9685  妹 */
	{ 0x4B66, 0x6627, },	/* 43-70  9686  昧 */
	{ 0x4B67, 0x679A, },	/* 43-71  9687  枚 */
	{ 0x4B68, 0x6BCE, },	/* 43-72  9688  毎 */
	{ 0x4B69, 0x54E9, },	/* 43-73  9689  哩 */
	{ 0x4B6A, 0x69D9, },	/* 43-74  968A  槙 */
	{ 0x4B6B, 0x5E55, },	/* 43-75  968B  幕 */
	{ 0x4B6C, 0x819C, },	/* 43-76  968C  膜 */
	{ 0x4B6D, 0x6795, },	/* 43-77  968D  枕 */
	{ 0x4B6E, 0x9BAA, },	/* 43-78  968E  鮪 */
	{ 0x4B6F, 0x67FE, },	/* 43-79  968F  柾 */
	{ 0x4B70, 0x9C52, },	/* 43-80  9690  鱒 */
	{ 0x4B71, 0x685D, },	/* 43-81  9691  桝 */
	{ 0x4B72, 0x4EA6, },	/* 43-82  9692  亦 */
	{ 0x4B73, 0x4FE3, },	/* 43-83  9693  俣 */
	{ 0x4B74, 0x53C8, },	/* 43-84  9694  又 */
	{ 0x4B75, 0x62B9, },	/* 43-85  9695  抹 */
	{ 0x4B76, 0x672B, },	/* 43-86  9696  末 */
	{ 0x4B77, 0x6CAB, },	/* 43-87  9697  沫 */
	{ 0x4B78, 0x8FC4, },	/* 43-88  9698  迄 */
	{ 0x4B79, 0x4FAD, },	/* 43-89  9699  侭 */
	{ 0x4B7A, 0x7E6D, },	/* 43-90  969A  繭 */
	{ 0x4B7B, 0x9EBF, },	/* 43-91  969B  麿 */
	{ 0x4B7C, 0x4E07, },	/* 43-92  969C  万 */
	{ 0x4B7D, 0x6162, },	/* 43-93  969D  慢 */
	{ 0x4B7E, 0x6E80, },	/* 43-94  969E  満 */
	{ 0x4C21, 0x6F2B, },	/* 44-01  969F  漫 */
	{ 0x4C22, 0x8513, },	/* 44-02  96A0  蔓 */
	{ 0x4C23, 0x5473, },	/* 44-03  96A1  味 */
	{ 0x4C24, 0x672A, },	/* 44-04  96A2  未 */
	{ 0x4C25, 0x9B45, },	/* 44-05  96A3  魅 */
	{ 0x4C26, 0x5DF3, },	/* 44-06  96A4  巳 */
	{ 0x4C27, 0x7B95, },	/* 44-07  96A5  箕 */
	{ 0x4C28, 0x5CAC, },	/* 44-08  96A6  岬 */
	{ 0x4C29, 0x5BC6, },	/* 44-09  96A7  密 */
	{ 0x4C2A, 0x871C, },	/* 44-10  96A8  蜜 */
	{ 0x4C2B, 0x6E4A, },	/* 44-11  96A9  湊 */
	{ 0x4C2C, 0x84D1, },	/* 44-12  96AA  蓑 */
	{ 0x4C2D, 0x7A14, },	/* 44-13  96AB  稔 */
	{ 0x4C2E, 0x8108, },	/* 44-14  96AC  脈 */
	{ 0x4C2F, 0x5999, },	/* 44-15  96AD  妙 */
	{ 0x4C30, 0x7C8D, },	/* 44-16  96AE  粍 */
	{ 0x4C31, 0x6C11, },	/* 44-17  96AF  民 */
	{ 0x4C32, 0x7720, },	/* 44-18  96B0  眠 */
	{ 0x4C33, 0x52D9, },	/* 44-19  96B1  務 */
	{ 0x4C34, 0x5922, },	/* 44-20  96B2  夢 */
	{ 0x4C35, 0x7121, },	/* 44-21  96B3  無 */
	{ 0x4C36, 0x725F, },	/* 44-22  96B4  牟 */
	{ 0x4C37, 0x77DB, },	/* 44-23  96B5  矛 */
	{ 0x4C38, 0x9727, },	/* 44-24  96B6  霧 */
	{ 0x4C39, 0x9D61, },	/* 44-25  96B7  鵡 */
	{ 0x4C3A, 0x690B, },	/* 44-26  96B8  椋 */
	{ 0x4C3B, 0x5A7F, },	/* 44-27  96B9  婿 */
	{ 0x4C3C, 0x5A18, },	/* 44-28  96BA  娘 */
	{ 0x4C3D, 0x51A5, },	/* 44-29  96BB  冥 */
	{ 0x4C3E, 0x540D, },	/* 44-30  96BC  名 */
	{ 0x4C3F, 0x547D, },	/* 44-31  96BD  命 */
	{ 0x4C40, 0x660E, },	/* 44-32  96BE  明 */
	{ 0x4C41, 0x76DF, },	/* 44-33  96BF  盟 */
	{ 0x4C42, 0x8FF7, },	/* 44-34  96C0  迷 */
	{ 0x4C43, 0x9298, },	/* 44-35  96C1  銘 */
	{ 0x4C44, 0x9CF4, },	/* 44-36  96C2  鳴 */
	{ 0x4C45, 0x59EA, },	/* 44-37  96C3  姪 */
	{ 0x4C46, 0x725D, },	/* 44-38  96C4  牝 */
	{ 0x4C47, 0x6EC5, },	/* 44-39  96C5  滅 */
	{ 0x4C48, 0x514D, },	/* 44-40  96C6  免 */
	{ 0x4C49, 0x68C9, },	/* 44-41  96C7  棉 */
	{ 0x4C4A, 0x7DBF, },	/* 44-42  96C8  綿 */
	{ 0x4C4B, 0x7DEC, },	/* 44-43  96C9  緬 */
	{ 0x4C4C, 0x9762, },	/* 44-44  96CA  面 */
	{ 0x4C4D, 0x9EBA, },	/* 44-45  96CB  麺 */
	{ 0x4C4E, 0x6478, },	/* 44-46  96CC  摸 */
	{ 0x4C4F, 0x6A21, },	/* 44-47  96CD  模 */
	{ 0x4C50, 0x8302, },	/* 44-48  96CE  茂 */
	{ 0x4C51, 0x5984, },	/* 44-49  96CF  妄 */
	{ 0x4C52, 0x5B5F, },	/* 44-50  96D0  孟 */
	{ 0x4C53, 0x6BDB, },	/* 44-51  96D1  毛 */
	{ 0x4C54, 0x731B, },	/* 44-52  96D2  猛 */
	{ 0x4C55, 0x76F2, },	/* 44-53  96D3  盲 */
	{ 0x4C56, 0x7DB2, },	/* 44-54  96D4  網 */
	{ 0x4C57, 0x8017, },	/* 44-55  96D5  耗 */
	{ 0x4C58, 0x8499, },	/* 44-56  96D6  蒙 */
	{ 0x4C59, 0x5132, },	/* 44-57  96D7  儲 */
	{ 0x4C5A, 0x6728, },	/* 44-58  96D8  木 */
	{ 0x4C5B, 0x9ED9, },	/* 44-59  96D9  黙 */
	{ 0x4C5C, 0x76EE, },	/* 44-60  96DA  目 */
	{ 0x4C5D, 0x6762, },	/* 44-61  96DB  杢 */
	{ 0x4C5E, 0x52FF, },	/* 44-62  96DC  勿 */
	{ 0x4C5F, 0x9905, },	/* 44-63  96DD  餅 */
	{ 0x4C60, 0x5C24, },	/* 44-64  96DE  尤 */
	{ 0x4C61, 0x623B, },	/* 44-65  96DF  戻 */
	{ 0x4C62, 0x7C7E, },	/* 44-66  96E0  籾 */
	{ 0x4C63, 0x8CB0, },	/* 44-67  96E1  貰 */
	{ 0x4C64, 0x554F, },	/* 44-68  96E2  問 */
	{ 0x4C65, 0x60B6, },	/* 44-69  96E3  悶 */
	{ 0x4C66, 0x7D0B, },	/* 44-70  96E4  紋 */
	{ 0x4C67, 0x9580, },	/* 44-71  96E5  門 */
	{ 0x4C68, 0x5301, },	/* 44-72  96E6  匁 */
	{ 0x4C69, 0x4E5F, },	/* 44-73  96E7  也 */
	{ 0x4C6A, 0x51B6, },	/* 44-74  96E8  冶 */
	{ 0x4C6B, 0x591C, },	/* 44-75  96E9  夜 */
	{ 0x4C6C, 0x723A, },	/* 44-76  96EA  爺 */
	{ 0x4C6D, 0x8036, },	/* 44-77  96EB  耶 */
	{ 0x4C6E, 0x91CE, },	/* 44-78  96EC  野 */
	{ 0x4C6F, 0x5F25, },	/* 44-79  96ED  弥 */
	{ 0x4C70, 0x77E2, },	/* 44-80  96EE  矢 */
	{ 0x4C71, 0x5384, },	/* 44-81  96EF  厄 */
	{ 0x4C72, 0x5F79, },	/* 44-82  96F0  役 */
	{ 0x4C73, 0x7D04, },	/* 44-83  96F1  約 */
	{ 0x4C74, 0x85AC, },	/* 44-84  96F2  薬 */
	{ 0x4C75, 0x8A33, },	/* 44-85  96F3  訳 */
	{ 0x4C76, 0x8E8D, },	/* 44-86  96F4  躍 */
	{ 0x4C77, 0x9756, },	/* 44-87  96F5  靖 */
	{ 0x4C78, 0x67F3, },	/* 44-88  96F6  柳 */
	{ 0x4C79, 0x85AE, },	/* 44-89  96F7  薮 */
	{ 0x4C7A, 0x9453, },	/* 44-90  96F8  鑓 */
	{ 0x4C7B, 0x6109, },	/* 44-91  96F9  愉 */
	{ 0x4C7C, 0x6108, },	/* 44-92  96FA  愈 */
	{ 0x4C7D, 0x6CB9, },	/* 44-93  96FB  油 */
	{ 0x4C7E, 0x7652, },	/* 44-94  96FC  癒 */
	{ 0x4D21, 0x8AED, },	/* 45-01  9740  諭 */
	{ 0x4D22, 0x8F38, },	/* 45-02  9741  輸 */
	{ 0x4D23, 0x552F, },	/* 45-03  9742  唯 */
	{ 0x4D24, 0x4F51, },	/* 45-04  9743  佑 */
	{ 0x4D25, 0x512A, },	/* 45-05  9744  優 */
	{ 0x4D26, 0x52C7, },	/* 45-06  9745  勇 */
	{ 0x4D27, 0x53CB, },	/* 45-07  9746  友 */
	{ 0x4D28, 0x5BA5, },	/* 45-08  9747  宥 */
	{ 0x4D29, 0x5E7D, },	/* 45-09  9748  幽 */
	{ 0x4D2A, 0x60A0, },	/* 45-10  9749  悠 */
	{ 0x4D2B, 0x6182, },	/* 45-11  974A  憂 */
	{ 0x4D2C, 0x63D6, },	/* 45-12  974B  揖 */
	{ 0x4D2D, 0x6709, },	/* 45-13  974C  有 */
	{ 0x4D2E, 0x67DA, },	/* 45-14  974D  柚 */
	{ 0x4D2F, 0x6E67, },	/* 45-15  974E  湧 */
	{ 0x4D30, 0x6D8C, },	/* 45-16  974F  涌 */
	{ 0x4D31, 0x7336, },	/* 45-17  9750  猶 */
	{ 0x4D32, 0x7337, },	/* 45-18  9751  猷 */
	{ 0x4D33, 0x7531, },	/* 45-19  9752  由 */
	{ 0x4D34, 0x7950, },	/* 45-20  9753  祐 */
	{ 0x4D35, 0x88D5, },	/* 45-21  9754  裕 */
	{ 0x4D36, 0x8A98, },	/* 45-22  9755  誘 */
	{ 0x4D37, 0x904A, },	/* 45-23  9756  遊 */
	{ 0x4D38, 0x9091, },	/* 45-24  9757  邑 */
	{ 0x4D39, 0x90F5, },	/* 45-25  9758  郵 */
	{ 0x4D3A, 0x96C4, },	/* 45-26  9759  雄 */
	{ 0x4D3B, 0x878D, },	/* 45-27  975A  融 */
	{ 0x4D3C, 0x5915, },	/* 45-28  975B  夕 */
	{ 0x4D3D, 0x4E88, },	/* 45-29  975C  予 */
	{ 0x4D3E, 0x4F59, },	/* 45-30  975D  余 */
	{ 0x4D3F, 0x4E0E, },	/* 45-31  975E  与 */
	{ 0x4D40, 0x8A89, },	/* 45-32  975F  誉 */
	{ 0x4D41, 0x8F3F, },	/* 45-33  9760  輿 */
	{ 0x4D42, 0x9810, },	/* 45-34  9761  預 */
	{ 0x4D43, 0x50AD, },	/* 45-35  9762  傭 */
	{ 0x4D44, 0x5E7C, },	/* 45-36  9763  幼 */
	{ 0x4D45, 0x5996, },	/* 45-37  9764  妖 */
	{ 0x4D46, 0x5BB9, },	/* 45-38  9765  容 */
	{ 0x4D47, 0x5EB8, },	/* 45-39  9766  庸 */
	{ 0x4D48, 0x63DA, },	/* 45-40  9767  揚 */
	{ 0x4D49, 0x63FA, },	/* 45-41  9768  揺 */
	{ 0x4D4A, 0x64C1, },	/* 45-42  9769  擁 */
	{ 0x4D4B, 0x66DC, },	/* 45-43  976A  曜 */
	{ 0x4D4C, 0x694A, },	/* 45-44  976B  楊 */
	{ 0x4D4D, 0x69D8, },	/* 45-45  976C  様 */
	{ 0x4D4E, 0x6D0B, },	/* 45-46  976D  洋 */
	{ 0x4D4F, 0x6EB6, },	/* 45-47  976E  溶 */
	{ 0x4D50, 0x7194, },	/* 45-48  976F  熔 */
	{ 0x4D51, 0x7528, },	/* 45-49  9770  用 */
	{ 0x4D52, 0x7AAF, },	/* 45-50  9771  窯 */
	{ 0x4D53, 0x7F8A, },	/* 45-51  9772  羊 */
	{ 0x4D54, 0x8000, },	/* 45-52  9773  耀 */
	{ 0x4D55, 0x8449, },	/* 45-53  9774  葉 */
	{ 0x4D56, 0x84C9, },	/* 45-54  9775  蓉 */
	{ 0x4D57, 0x8981, },	/* 45-55  9776  要 */
	{ 0x4D58, 0x8B21, },	/* 45-56  9777  謡 */
	{ 0x4D59, 0x8E0A, },	/* 45-57  9778  踊 */
	{ 0x4D5A, 0x9065, },	/* 45-58  9779  遥 */
	{ 0x4D5B, 0x967D, },	/* 45-59  977A  陽 */
	{ 0x4D5C, 0x990A, },	/* 45-60  977B  養 */
	{ 0x4D5D, 0x617E, },	/* 45-61  977C  慾 */
	{ 0x4D5E, 0x6291, },	/* 45-62  977D  抑 */
	{ 0x4D5F, 0x6B32, },	/* 45-63  977E  欲 */
	{ 0x4D60, 0x6C83, },	/* 45-64  9780  沃 */
	{ 0x4D61, 0x6D74, },	/* 45-65  9781  浴 */
	{ 0x4D62, 0x7FCC, },	/* 45-66  9782  翌 */
	{ 0x4D63, 0x7FFC, },	/* 45-67  9783  翼 */
	{ 0x4D64, 0x6DC0, },	/* 45-68  9784  淀 */
	{ 0x4D65, 0x7F85, },	/* 45-69  9785  羅 */
	{ 0x4D66, 0x87BA, },	/* 45-70  9786  螺 */
	{ 0x4D67, 0x88F8, },	/* 45-71  9787  裸 */
	{ 0x4D68, 0x6765, },	/* 45-72  9788  来 */
	{ 0x4D69, 0x83B1, },	/* 45-73  9789  莱 */
	{ 0x4D6A, 0x983C, },	/* 45-74  978A  頼 */
	{ 0x4D6B, 0x96F7, },	/* 45-75  978B  雷 */
	{ 0x4D6C, 0x6D1B, },	/* 45-76  978C  洛 */
	{ 0x4D6D, 0x7D61, },	/* 45-77  978D  絡 */
	{ 0x4D6E, 0x843D, },	/* 45-78  978E  落 */
	{ 0x4D6F, 0x916A, },	/* 45-79  978F  酪 */
	{ 0x4D70, 0x4E71, },	/* 45-80  9790  乱 */
	{ 0x4D71, 0x5375, },	/* 45-81  9791  卵 */
	{ 0x4D72, 0x5D50, },	/* 45-82  9792  嵐 */
	{ 0x4D73, 0x6B04, },	/* 45-83  9793  欄 */
	{ 0x4D74, 0x6FEB, },	/* 45-84  9794  濫 */
	{ 0x4D75, 0x85CD, },	/* 45-85  9795  藍 */
	{ 0x4D76, 0x862D, },	/* 45-86  9796  蘭 */
	{ 0x4D77, 0x89A7, },	/* 45-87  9797  覧 */
	{ 0x4D78, 0x5229, },	/* 45-88  9798  利 */
	{ 0x4D79, 0x540F, },	/* 45-89  9799  吏 */
	{ 0x4D7A, 0x5C65, },	/* 45-90  979A  履 */
	{ 0x4D7B, 0x674E, },	/* 45-91  979B  李 */
	{ 0x4D7C, 0x68A8, },	/* 45-92  979C  梨 */
	{ 0x4D7D, 0x7406, },	/* 45-93  979D  理 */
	{ 0x4D7E, 0x7483, },	/* 45-94  979E  璃 */
	{ 0x4E21, 0x75E2, },	/* 46-01  979F  痢 */
	{ 0x4E22, 0x88CF, },	/* 46-02  97A0  裏 */
	{ 0x4E23, 0x88E1, },	/* 46-03  97A1  裡 */
	{ 0x4E24, 0x91CC, },	/* 46-04  97A2  里 */
	{ 0x4E25, 0x96E2, },	/* 46-05  97A3  離 */
	{ 0x4E26, 0x9678, },	/* 46-06  97A4  陸 */
	{ 0x4E27, 0x5F8B, },	/* 46-07  97A5  律 */
	{ 0x4E28, 0x7387, },	/* 46-08  97A6  率 */
	{ 0x4E29, 0x7ACB, },	/* 46-09  97A7  立 */
	{ 0x4E2A, 0x844E, },	/* 46-10  97A8  葎 */
	{ 0x4E2B, 0x63A0, },	/* 46-11  97A9  掠 */
	{ 0x4E2C, 0x7565, },	/* 46-12  97AA  略 */
	{ 0x4E2D, 0x5289, },	/* 46-13  97AB  劉 */
	{ 0x4E2E, 0x6D41, },	/* 46-14  97AC  流 */
	{ 0x4E2F, 0x6E9C, },	/* 46-15  97AD  溜 */
	{ 0x4E30, 0x7409, },	/* 46-16  97AE  琉 */
	{ 0x4E31, 0x7559, },	/* 46-17  97AF  留 */
	{ 0x4E32, 0x786B, },	/* 46-18  97B0  硫 */
	{ 0x4E33, 0x7C92, },	/* 46-19  97B1  粒 */
	{ 0x4E34, 0x9686, },	/* 46-20  97B2  隆 */
	{ 0x4E35, 0x7ADC, },	/* 46-21  97B3  竜 */
	{ 0x4E36, 0x9F8D, },	/* 46-22  97B4  龍 */
	{ 0x4E37, 0x4FB6, },	/* 46-23  97B5  侶 */
	{ 0x4E38, 0x616E, },	/* 46-24  97B6  慮 */
	{ 0x4E39, 0x65C5, },	/* 46-25  97B7  旅 */
	{ 0x4E3A, 0x865C, },	/* 46-26  97B8  虜 */
	{ 0x4E3B, 0x4E86, },	/* 46-27  97B9  了 */
	{ 0x4E3C, 0x4EAE, },	/* 46-28  97BA  亮 */
	{ 0x4E3D, 0x50DA, },	/* 46-29  97BB  僚 */
	{ 0x4E3E, 0x4E21, },	/* 46-30  97BC  両 */
	{ 0x4E3F, 0x51CC, },	/* 46-31  97BD  凌 */
	{ 0x4E40, 0x5BEE, },	/* 46-32  97BE  寮 */
	{ 0x4E41, 0x6599, },	/* 46-33  97BF  料 */
	{ 0x4E42, 0x6881, },	/* 46-34  97C0  梁 */
	{ 0x4E43, 0x6DBC, },	/* 46-35  97C1  涼 */
	{ 0x4E44, 0x731F, },	/* 46-36  97C2  猟 */
	{ 0x4E45, 0x7642, },	/* 46-37  97C3  療 */
	{ 0x4E46, 0x77AD, },	/* 46-38  97C4  瞭 */
	{ 0x4E47, 0x7A1C, },	/* 46-39  97C5  稜 */
	{ 0x4E48, 0x7CE7, },	/* 46-40  97C6  糧 */
	{ 0x4E49, 0x826F, },	/* 46-41  97C7  良 */
	{ 0x4E4A, 0x8AD2, },	/* 46-42  97C8  諒 */
	{ 0x4E4B, 0x907C, },	/* 46-43  97C9  遼 */
	{ 0x4E4C, 0x91CF, },	/* 46-44  97CA  量 */
	{ 0x4E4D, 0x9675, },	/* 46-45  97CB  陵 */
	{ 0x4E4E, 0x9818, },	/* 46-46  97CC  領 */
	{ 0x4E4F, 0x529B, },	/* 46-47  97CD  力 */
	{ 0x4E50, 0x7DD1, },	/* 46-48  97CE  緑 */
	{ 0x4E51, 0x502B, },	/* 46-49  97CF  倫 */
	{ 0x4E52, 0x5398, },	/* 46-50  97D0  厘 */
	{ 0x4E53, 0x6797, },	/* 46-51  97D1  林 */
	{ 0x4E54, 0x6DCB, },	/* 46-52  97D2  淋 */
	{ 0x4E55, 0x71D0, },	/* 46-53  97D3  燐 */
	{ 0x4E56, 0x7433, },	/* 46-54  97D4  琳 */
	{ 0x4E57, 0x81E8, },	/* 46-55  97D5  臨 */
	{ 0x4E58, 0x8F2A, },	/* 46-56  97D6  輪 */
	{ 0x4E59, 0x96A3, },	/* 46-57  97D7  隣 */
	{ 0x4E5A, 0x9C57, },	/* 46-58  97D8  鱗 */
	{ 0x4E5B, 0x9E9F, },	/* 46-59  97D9  麟 */
	{ 0x4E5C, 0x7460, },	/* 46-60  97DA  瑠 */
	{ 0x4E5D, 0x5841, },	/* 46-61  97DB  塁 */
	{ 0x4E5E, 0x6D99, },	/* 46-62  97DC  涙 */
	{ 0x4E5F, 0x7D2F, },	/* 46-63  97DD  累 */
	{ 0x4E60, 0x985E, },	/* 46-64  97DE  類 */
	{ 0x4E61, 0x4EE4, },	/* 46-65  97DF  令 */
	{ 0x4E62, 0x4F36, },	/* 46-66  97E0  伶 */
	{ 0x4E63, 0x4F8B, },	/* 46-67  97E1  例 */
	{ 0x4E64, 0x51B7, },	/* 46-68  97E2  冷 */
	{ 0x4E65, 0x52B1, },	/* 46-69  97E3  励 */
	{ 0x4E66, 0x5DBA, },	/* 46-70  97E4  嶺 */
	{ 0x4E67, 0x601C, },	/* 46-71  97E5  怜 */
	{ 0x4E68, 0x73B2, },	/* 46-72  97E6  玲 */
	{ 0x4E69, 0x793C, },	/* 46-73  97E7  礼 */
	{ 0x4E6A, 0x82D3, },	/* 46-74  97E8  苓 */
	{ 0x4E6B, 0x9234, },	/* 46-75  97E9  鈴 */
	{ 0x4E6C, 0x96B7, },	/* 46-76  97EA  隷 */
	{ 0x4E6D, 0x96F6, },	/* 46-77  97EB  零 */
	{ 0x4E6E, 0x970A, },	/* 46-78  97EC  霊 */
	{ 0x4E6F, 0x9E97, },	/* 46-79  97ED  麗 */
	{ 0x4E70, 0x9F62, },	/* 46-80  97EE  齢 */
	{ 0x4E71, 0x66A6, },	/* 46-81  97EF  暦 */
	{ 0x4E72, 0x6B74, },	/* 46-82  97F0  歴 */
	{ 0x4E73, 0x5217, },	/* 46-83  97F1  列 */
	{ 0x4E74, 0x52A3, },	/* 46-84  97F2  劣 */
	{ 0x4E75, 0x70C8, },	/* 46-85  97F3  烈 */
	{ 0x4E76, 0x88C2, },	/* 46-86  97F4  裂 */
	{ 0x4E77, 0x5EC9, },	/* 46-87  97F5  廉 */
	{ 0x4E78, 0x604B, },	/* 46-88  97F6  恋 */
	{ 0x4E79, 0x6190, },	/* 46-89  97F7  憐 */
	{ 0x4E7A, 0x6F23, },	/* 46-90  97F8  漣 */
	{ 0x4E7B, 0x7149, },	/* 46-91  97F9  煉 */
	{ 0x4E7C, 0x7C3E, },	/* 46-92  97FA  簾 */
	{ 0x4E7D, 0x7DF4, },	/* 46-93  97FB  練 */
	{ 0x4E7E, 0x806F, },	/* 46-94  97FC  聯 */
	{ 0x4F21, 0x84EE, },	/* 47-01  9840  蓮 */
	{ 0x4F22, 0x9023, },	/* 47-02  9841  連 */
	{ 0x4F23, 0x932C, },	/* 47-03  9842  錬 */
	{ 0x4F24, 0x5442, },	/* 47-04  9843  呂 */
	{ 0x4F25, 0x9B6F, },	/* 47-05  9844  魯 */
	{ 0x4F26, 0x6AD3, },	/* 47-06  9845  櫓 */
	{ 0x4F27, 0x7089, },	/* 47-07  9846  炉 */
	{ 0x4F28, 0x8CC2, },	/* 47-08  9847  賂 */
	{ 0x4F29, 0x8DEF, },	/* 47-09  9848  路 */
	{ 0x4F2A, 0x9732, },	/* 47-10  9849  露 */
	{ 0x4F2B, 0x52B4, },	/* 47-11  984A  労 */
	{ 0x4F2C, 0x5A41, },	/* 47-12  984B  婁 */
	{ 0x4F2D, 0x5ECA, },	/* 47-13  984C  廊 */
	{ 0x4F2E, 0x5F04, },	/* 47-14  984D  弄 */
	{ 0x4F2F, 0x6717, },	/* 47-15  984E  朗 */
	{ 0x4F30, 0x697C, },	/* 47-16  984F  楼 */
	{ 0x4F31, 0x6994, },	/* 47-17  9850  榔 */
	{ 0x4F32, 0x6D6A, },	/* 47-18  9851  浪 */
	{ 0x4F33, 0x6F0F, },	/* 47-19  9852  漏 */
	{ 0x4F34, 0x7262, },	/* 47-20  9853  牢 */
	{ 0x4F35, 0x72FC, },	/* 47-21  9854  狼 */
	{ 0x4F36, 0x7BED, },	/* 47-22  9855  篭 */
	{ 0x4F37, 0x8001, },	/* 47-23  9856  老 */
	{ 0x4F38, 0x807E, },	/* 47-24  9857  聾 */
	{ 0x4F39, 0x874B, },	/* 47-25  9858  蝋 */
	{ 0x4F3A, 0x90CE, },	/* 47-26  9859  郎 */
	{ 0x4F3B, 0x516D, },	/* 47-27  985A  六 */
	{ 0x4F3C, 0x9E93, },	/* 47-28  985B  麓 */
	{ 0x4F3D, 0x7984, },	/* 47-29  985C  禄 */
	{ 0x4F3E, 0x808B, },	/* 47-30  985D  肋 */
	{ 0x4F3F, 0x9332, },	/* 47-31  985E  録 */
	{ 0x4F40, 0x8AD6, },	/* 47-32  985F  論 */
	{ 0x4F41, 0x502D, },	/* 47-33  9860  倭 */
	{ 0x4F42, 0x548C, },	/* 47-34  9861  和 */
	{ 0x4F43, 0x8A71, },	/* 47-35  9862  話 */
	{ 0x4F44, 0x6B6A, },	/* 47-36  9863  歪 */
	{ 0x4F45, 0x8CC4, },	/* 47-37  9864  賄 */
	{ 0x4F46, 0x8107, },	/* 47-38  9865  脇 */
	{ 0x4F47, 0x60D1, },	/* 47-39  9866  惑 */
	{ 0x4F48, 0x67A0, },	/* 47-40  9867  枠 */
	{ 0x4F49, 0x9DF2, },	/* 47-41  9868  鷲 */
	{ 0x4F4A, 0x4E99, },	/* 47-42  9869  亙 */
	{ 0x4F4B, 0x4E98, },	/* 47-43  986A  亘 */
	{ 0x4F4C, 0x9C10, },	/* 47-44  986B  鰐 */
	{ 0x4F4D, 0x8A6B, },	/* 47-45  986C  詫 */
	{ 0x4F4E, 0x85C1, },	/* 47-46  986D  藁 */
	{ 0x4F4F, 0x8568, },	/* 47-47  986E  蕨 */
	{ 0x4F50, 0x6900, },	/* 47-48  986F  椀 */
	{ 0x4F51, 0x6E7E, },	/* 47-49  9870  湾 */
	{ 0x4F52, 0x7897, },	/* 47-50  9871  碗 */
	{ 0x4F53, 0x8155, },	/* 47-51  9872  腕 */
	{ 0x5021, 0x5F0C, },	/* 48-01  989F  弌 */
	{ 0x5022, 0x4E10, },	/* 48-02  98A0  丐 */
	{ 0x5023, 0x4E15, },	/* 48-03  98A1  丕 */
	{ 0x5024, 0x4E2A, },	/* 48-04  98A2  个 */
	{ 0x5025, 0x4E31, },	/* 48-05  98A3  丱 */
	{ 0x5026, 0x4E36, },	/* 48-06  98A4  丶 */
	{ 0x5027, 0x4E3C, },	/* 48-07  98A5  丼 */
	{ 0x5028, 0x4E3F, },	/* 48-08  98A6  丿 */
	{ 0x5029, 0x4E42, },	/* 48-09  98A7  乂 */
	{ 0x502A, 0x4E56, },	/* 48-10  98A8  乖 */
	{ 0x502B, 0x4E58, },	/* 48-11  98A9  乘 */
	{ 0x502C, 0x4E82, },	/* 48-12  98AA  亂 */
	{ 0x502D, 0x4E85, },	/* 48-13  98AB  亅 */
	{ 0x502E, 0x8C6B, },	/* 48-14  98AC  豫 */
	{ 0x502F, 0x4E8A, },	/* 48-15  98AD  亊 */
	{ 0x5030, 0x8212, },	/* 48-16  98AE  舒 */
	{ 0x5031, 0x5F0D, },	/* 48-17  98AF  弍 */
	{ 0x5032, 0x4E8E, },	/* 48-18  98B0  于 */
	{ 0x5033, 0x4E9E, },	/* 48-19  98B1  亞 */
	{ 0x5034, 0x4E9F, },	/* 48-20  98B2  亟 */
	{ 0x5035, 0x4EA0, },	/* 48-21  98B3  亠 */
	{ 0x5036, 0x4EA2, },	/* 48-22  98B4  亢 */
	{ 0x5037, 0x4EB0, },	/* 48-23  98B5  亰 */
	{ 0x5038, 0x4EB3, },	/* 48-24  98B6  亳 */
	{ 0x5039, 0x4EB6, },	/* 48-25  98B7  亶 */
	{ 0x503A, 0x4ECE, },	/* 48-26  98B8  从 */
	{ 0x503B, 0x4ECD, },	/* 48-27  98B9  仍 */
	{ 0x503C, 0x4EC4, },	/* 48-28  98BA  仄 */
	{ 0x503D, 0x4EC6, },	/* 48-29  98BB  仆 */
	{ 0x503E, 0x4EC2, },	/* 48-30  98BC  仂 */
	{ 0x503F, 0x4ED7, },	/* 48-31  98BD  仗 */
	{ 0x5040, 0x4EDE, },	/* 48-32  98BE  仞 */
	{ 0x5041, 0x4EED, },	/* 48-33  98BF  仭 */
	{ 0x5042, 0x4EDF, },	/* 48-34  98C0  仟 */
	{ 0x5043, 0x4EF7, },	/* 48-35  98C1  价 */
	{ 0x5044, 0x4F09, },	/* 48-36  98C2  伉 */
	{ 0x5045, 0x4F5A, },	/* 48-37  98C3  佚 */
	{ 0x5046, 0x4F30, },	/* 48-38  98C4  估 */
	{ 0x5047, 0x4F5B, },	/* 48-39  98C5  佛 */
	{ 0x5048, 0x4F5D, },	/* 48-40  98C6  佝 */
	{ 0x5049, 0x4F57, },	/* 48-41  98C7  佗 */
	{ 0x504A, 0x4F47, },	/* 48-42  98C8  佇 */
	{ 0x504B, 0x4F76, },	/* 48-43  98C9  佶 */
	{ 0x504C, 0x4F88, },	/* 48-44  98CA  侈 */
	{ 0x504D, 0x4F8F, },	/* 48-45  98CB  侏 */
	{ 0x504E, 0x4F98, },	/* 48-46  98CC  侘 */
	{ 0x504F, 0x4F7B, },	/* 48-47  98CD  佻 */
	{ 0x5050, 0x4F69, },	/* 48-48  98CE  佩 */
	{ 0x5051, 0x4F70, },	/* 48-49  98CF  佰 */
	{ 0x5052, 0x4F91, },	/* 48-50  98D0  侑 */
	{ 0x5053, 0x4F6F, },	/* 48-51  98D1  佯 */
	{ 0x5054, 0x4F86, },	/* 48-52  98D2  來 */
	{ 0x5055, 0x4F96, },	/* 48-53  98D3  侖 */
	{ 0x5056, 0x5118, },	/* 48-54  98D4  儘 */
	{ 0x5057, 0x4FD4, },	/* 48-55  98D5  俔 */
	{ 0x5058, 0x4FDF, },	/* 48-56  98D6  俟 */
	{ 0x5059, 0x4FCE, },	/* 48-57  98D7  俎 */
	{ 0x505A, 0x4FD8, },	/* 48-58  98D8  俘 */
	{ 0x505B, 0x4FDB, },	/* 48-59  98D9  俛 */
	{ 0x505C, 0x4FD1, },	/* 48-60  98DA  俑 */
	{ 0x505D, 0x4FDA, },	/* 48-61  98DB  俚 */
	{ 0x505E, 0x4FD0, },	/* 48-62  98DC  俐 */
	{ 0x505F, 0x4FE4, },	/* 48-63  98DD  俤 */
	{ 0x5060, 0x4FE5, },	/* 48-64  98DE  俥 */
	{ 0x5061, 0x501A, },	/* 48-65  98DF  倚 */
	{ 0x5062, 0x5028, },	/* 48-66  98E0  倨 */
	{ 0x5063, 0x5014, },	/* 48-67  98E1  倔 */
	{ 0x5064, 0x502A, },	/* 48-68  98E2  倪 */
	{ 0x5065, 0x5025, },	/* 48-69  98E3  倥 */
	{ 0x5066, 0x5005, },	/* 48-70  98E4  倅 */
	{ 0x5067, 0x4F1C, },	/* 48-71  98E5  伜 */
	{ 0x5068, 0x4FF6, },	/* 48-72  98E6  俶 */
	{ 0x5069, 0x5021, },	/* 48-73  98E7  倡 */
	{ 0x506A, 0x5029, },	/* 48-74  98E8  倩 */
	{ 0x506B, 0x502C, },	/* 48-75  98E9  倬 */
	{ 0x506C, 0x4FFE, },	/* 48-76  98EA  俾 */
	{ 0x506D, 0x4FEF, },	/* 48-77  98EB  俯 */
	{ 0x506E, 0x5011, },	/* 48-78  98EC  們 */
	{ 0x506F, 0x5006, },	/* 48-79  98ED  倆 */
	{ 0x5070, 0x5043, },	/* 48-80  98EE  偃 */
	{ 0x5071, 0x5047, },	/* 48-81  98EF  假 */
	{ 0x5072, 0x6703, },	/* 48-82  98F0  會 */
	{ 0x5073, 0x5055, },	/* 48-83  98F1  偕 */
	{ 0x5074, 0x5050, },	/* 48-84  98F2  偐 */
	{ 0x5075, 0x5048, },	/* 48-85  98F3  偈 */
	{ 0x5076, 0x505A, },	/* 48-86  98F4  做 */
	{ 0x5077, 0x5056, },	/* 48-87  98F5  偖 */
	{ 0x5078, 0x506C, },	/* 48-88  98F6  偬 */
	{ 0x5079, 0x5078, },	/* 48-89  98F7  偸 */
	{ 0x507A, 0x5080, },	/* 48-90  98F8  傀 */
	{ 0x507B, 0x509A, },	/* 48-91  98F9  傚 */
	{ 0x507C, 0x5085, },	/* 48-92  98FA  傅 */
	{ 0x507D, 0x50B4, },	/* 48-93  98FB  傴 */
	{ 0x507E, 0x50B2, },	/* 48-94  98FC  傲 */
	{ 0x5121, 0x50C9, },	/* 49-01  9940  僉 */
	{ 0x5122, 0x50CA, },	/* 49-02  9941  僊 */
	{ 0x5123, 0x50B3, },	/* 49-03  9942  傳 */
	{ 0x5124, 0x50C2, },	/* 49-04  9943  僂 */
	{ 0x5125, 0x50D6, },	/* 49-05  9944  僖 */
	{ 0x5126, 0x50DE, },	/* 49-06  9945  僞 */
	{ 0x5127, 0x50E5, },	/* 49-07  9946  僥 */
	{ 0x5128, 0x50ED, },	/* 49-08  9947  僭 */
	{ 0x5129, 0x50E3, },	/* 49-09  9948  僣 */
	{ 0x512A, 0x50EE, },	/* 49-10  9949  僮 */
	{ 0x512B, 0x50F9, },	/* 49-11  994A  價 */
	{ 0x512C, 0x50F5, },	/* 49-12  994B  僵 */
	{ 0x512D, 0x5109, },	/* 49-13  994C  儉 */
	{ 0x512E, 0x5101, },	/* 49-14  994D  儁 */
	{ 0x512F, 0x5102, },	/* 49-15  994E  儂 */
	{ 0x5130, 0x5116, },	/* 49-16  994F  儖 */
	{ 0x5131, 0x5115, },	/* 49-17  9950  儕 */
	{ 0x5132, 0x5114, },	/* 49-18  9951  儔 */
	{ 0x5133, 0x511A, },	/* 49-19  9952  儚 */
	{ 0x5134, 0x5121, },	/* 49-20  9953  儡 */
	{ 0x5135, 0x513A, },	/* 49-21  9954  儺 */
	{ 0x5136, 0x5137, },	/* 49-22  9955  儷 */
	{ 0x5137, 0x513C, },	/* 49-23  9956  儼 */
	{ 0x5138, 0x513B, },	/* 49-24  9957  儻 */
	{ 0x5139, 0x513F, },	/* 49-25  9958  儿 */
	{ 0x513A, 0x5140, },	/* 49-26  9959  兀 */
	{ 0x513B, 0x5152, },	/* 49-27  995A  兒 */
	{ 0x513C, 0x514C, },	/* 49-28  995B  兌 */
	{ 0x513D, 0x5154, },	/* 49-29  995C  兔 */
	{ 0x513E, 0x5162, },	/* 49-30  995D  兢 */
	{ 0x513F, 0x7AF8, },	/* 49-31  995E  竸 */
	{ 0x5140, 0x5169, },	/* 49-32  995F  兩 */
	{ 0x5141, 0x516A, },	/* 49-33  9960  兪 */
	{ 0x5142, 0x516E, },	/* 49-34  9961  兮 */
	{ 0x5143, 0x5180, },	/* 49-35  9962  冀 */
	{ 0x5144, 0x5182, },	/* 49-36  9963  冂 */
	{ 0x5145, 0x56D8, },	/* 49-37  9964  囘 */
	{ 0x5146, 0x518C, },	/* 49-38  9965  册 */
	{ 0x5147, 0x5189, },	/* 49-39  9966  冉 */
	{ 0x5148, 0x518F, },	/* 49-40  9967  冏 */
	{ 0x5149, 0x5191, },	/* 49-41  9968  冑 */
	{ 0x514A, 0x5193, },	/* 49-42  9969  冓 */
	{ 0x514B, 0x5195, },	/* 49-43  996A  冕 */
	{ 0x514C, 0x5196, },	/* 49-44  996B  冖 */
	{ 0x514D, 0x51A4, },	/* 49-45  996C  冤 */
	{ 0x514E, 0x51A6, },	/* 49-46  996D  冦 */
	{ 0x514F, 0x51A2, },	/* 49-47  996E  冢 */
	{ 0x5150, 0x51A9, },	/* 49-48  996F  冩 */
	{ 0x5151, 0x51AA, },	/* 49-49  9970  冪 */
	{ 0x5152, 0x51AB, },	/* 49-50  9971  冫 */
	{ 0x5153, 0x51B3, },	/* 49-51  9972  决 */
	{ 0x5154, 0x51B1, },	/* 49-52  9973  冱 */
	{ 0x5155, 0x51B2, },	/* 49-53  9974  冲 */
	{ 0x5156, 0x51B0, },	/* 49-54  9975  冰 */
	{ 0x5157, 0x51B5, },	/* 49-55  9976  况 */
	{ 0x5158, 0x51BD, },	/* 49-56  9977  冽 */
	{ 0x5159, 0x51C5, },	/* 49-57  9978  凅 */
	{ 0x515A, 0x51C9, },	/* 49-58  9979  凉 */
	{ 0x515B, 0x51DB, },	/* 49-59  997A  凛 */
	{ 0x515C, 0x51E0, },	/* 49-60  997B  几 */
	{ 0x515D, 0x8655, },	/* 49-61  997C  處 */
	{ 0x515E, 0x51E9, },	/* 49-62  997D  凩 */
	{ 0x515F, 0x51ED, },	/* 49-63  997E  凭 */
	{ 0x5160, 0x51F0, },	/* 49-64  9980  凰 */
	{ 0x5161, 0x51F5, },	/* 49-65  9981  凵 */
	{ 0x5162, 0x51FE, },	/* 49-66  9982  凾 */
	{ 0x5163, 0x5204, },	/* 49-67  9983  刄 */
	{ 0x5164, 0x520B, },	/* 49-68  9984  刋 */
	{ 0x5165, 0x5214, },	/* 49-69  9985  刔 */
	{ 0x5166, 0x520E, },	/* 49-70  9986  刎 */
	{ 0x5167, 0x5227, },	/* 49-71  9987  刧 */
	{ 0x5168, 0x522A, },	/* 49-72  9988  刪 */
	{ 0x5169, 0x522E, },	/* 49-73  9989  刮 */
	{ 0x516A, 0x5233, },	/* 49-74  998A  刳 */
	{ 0x516B, 0x5239, },	/* 49-75  998B  刹 */
	{ 0x516C, 0x524F, },	/* 49-76  998C  剏 */
	{ 0x516D, 0x5244, },	/* 49-77  998D  剄 */
	{ 0x516E, 0x524B, },	/* 49-78  998E  剋 */
	{ 0x516F, 0x524C, },	/* 49-79  998F  剌 */
	{ 0x5170, 0x525E, },	/* 49-80  9990  剞 */
	{ 0x5171, 0x5254, },	/* 49-81  9991  剔 */
	{ 0x5172, 0x526A, },	/* 49-82  9992  剪 */
	{ 0x5173, 0x5274, },	/* 49-83  9993  剴 */
	{ 0x5174, 0x5269, },	/* 49-84  9994  剩 */
	{ 0x5175, 0x5273, },	/* 49-85  9995  剳 */
	{ 0x5176, 0x527F, },	/* 49-86  9996  剿 */
	{ 0x5177, 0x527D, },	/* 49-87  9997  剽 */
	{ 0x5178, 0x528D, },	/* 49-88  9998  劍 */
	{ 0x5179, 0x5294, },	/* 49-89  9999  劔 */
	{ 0x517A, 0x5292, },	/* 49-90  999A  劒 */
	{ 0x517B, 0x5271, },	/* 49-91  999B  剱 */
	{ 0x517C, 0x5288, },	/* 49-92  999C  劈 */
	{ 0x517D, 0x5291, },	/* 49-93  999D  劑 */
	{ 0x517E, 0x8FA8, },	/* 49-94  999E  辨 */
	{ 0x5221, 0x8FA7, },	/* 50-01  999F  辧 */
	{ 0x5222, 0x52AC, },	/* 50-02  99A0  劬 */
	{ 0x5223, 0x52AD, },	/* 50-03  99A1  劭 */
	{ 0x5224, 0x52BC, },	/* 50-04  99A2  劼 */
	{ 0x5225, 0x52B5, },	/* 50-05  99A3  劵 */
	{ 0x5226, 0x52C1, },	/* 50-06  99A4  勁 */
	{ 0x5227, 0x52CD, },	/* 50-07  99A5  勍 */
	{ 0x5228, 0x52D7, },	/* 50-08  99A6  勗 */
	{ 0x5229, 0x52DE, },	/* 50-09  99A7  勞 */
	{ 0x522A, 0x52E3, },	/* 50-10  99A8  勣 */
	{ 0x522B, 0x52E6, },	/* 50-11  99A9  勦 */
	{ 0x522C, 0x98ED, },	/* 50-12  99AA  飭 */
	{ 0x522D, 0x52E0, },	/* 50-13  99AB  勠 */
	{ 0x522E, 0x52F3, },	/* 50-14  99AC  勳 */
	{ 0x522F, 0x52F5, },	/* 50-15  99AD  勵 */
	{ 0x5230, 0x52F8, },	/* 50-16  99AE  勸 */
	{ 0x5231, 0x52F9, },	/* 50-17  99AF  勹 */
	{ 0x5232, 0x5306, },	/* 50-18  99B0  匆 */
	{ 0x5233, 0x5308, },	/* 50-19  99B1  匈 */
	{ 0x5234, 0x7538, },	/* 50-20  99B2  甸 */
	{ 0x5235, 0x530D, },	/* 50-21  99B3  匍 */
	{ 0x5236, 0x5310, },	/* 50-22  99B4  匐 */
	{ 0x5237, 0x530F, },	/* 50-23  99B5  匏 */
	{ 0x5238, 0x5315, },	/* 50-24  99B6  匕 */
	{ 0x5239, 0x531A, },	/* 50-25  99B7  匚 */
	{ 0x523A, 0x5323, },	/* 50-26  99B8  匣 */
	{ 0x523B, 0x532F, },	/* 50-27  99B9  匯 */
	{ 0x523C, 0x5331, },	/* 50-28  99BA  匱 */
	{ 0x523D, 0x5333, },	/* 50-29  99BB  匳 */
	{ 0x523E, 0x5338, },	/* 50-30  99BC  匸 */
	{ 0x523F, 0x5340, },	/* 50-31  99BD  區 */
	{ 0x5240, 0x5346, },	/* 50-32  99BE  卆 */
	{ 0x5241, 0x5345, },	/* 50-33  99BF  卅 */
	{ 0x5242, 0x4E17, },	/* 50-34  99C0  丗 */
	{ 0x5243, 0x5349, },	/* 50-35  99C1  卉 */
	{ 0x5244, 0x534D, },	/* 50-36  99C2  卍 */
	{ 0x5245, 0x51D6, },	/* 50-37  99C3  凖 */
	{ 0x5246, 0x535E, },	/* 50-38  99C4  卞 */
	{ 0x5247, 0x5369, },	/* 50-39  99C5  卩 */
	{ 0x5248, 0x536E, },	/* 50-40  99C6  卮 */
	{ 0x5249, 0x5918, },	/* 50-41  99C7  夘 */
	{ 0x524A, 0x537B, },	/* 50-42  99C8  卻 */
	{ 0x524B, 0x5377, },	/* 50-43  99C9  卷 */
	{ 0x524C, 0x5382, },	/* 50-44  99CA  厂 */
	{ 0x524D, 0x5396, },	/* 50-45  99CB  厖 */
	{ 0x524E, 0x53A0, },	/* 50-46  99CC  厠 */
	{ 0x524F, 0x53A6, },	/* 50-47  99CD  厦 */
	{ 0x5250, 0x53A5, },	/* 50-48  99CE  厥 */
	{ 0x5251, 0x53AE, },	/* 50-49  99CF  厮 */
	{ 0x5252, 0x53B0, },	/* 50-50  99D0  厰 */
	{ 0x5253, 0x53B6, },	/* 50-51  99D1  厶 */
	{ 0x5254, 0x53C3, },	/* 50-52  99D2  參 */
	{ 0x5255, 0x7C12, },	/* 50-53  99D3  簒 */
	{ 0x5256, 0x96D9, },	/* 50-54  99D4  雙 */
	{ 0x5257, 0x53DF, },	/* 50-55  99D5  叟 */
	{ 0x5258, 0x66FC, },	/* 50-56  99D6  曼 */
	{ 0x5259, 0x71EE, },	/* 50-57  99D7  燮 */
	{ 0x525A, 0x53EE, },	/* 50-58  99D8  叮 */
	{ 0x525B, 0x53E8, },	/* 50-59  99D9  叨 */
	{ 0x525C, 0x53ED, },	/* 50-60  99DA  叭 */
	{ 0x525D, 0x53FA, },	/* 50-61  99DB  叺 */
	{ 0x525E, 0x5401, },	/* 50-62  99DC  吁 */
	{ 0x525F, 0x543D, },	/* 50-63  99DD  吽 */
	{ 0x5260, 0x5440, },	/* 50-64  99DE  呀 */
	{ 0x5261, 0x542C, },	/* 50-65  99DF  听 */
	{ 0x5262, 0x542D, },	/* 50-66  99E0  吭 */
	{ 0x5263, 0x543C, },	/* 50-67  99E1  吼 */
	{ 0x5264, 0x542E, },	/* 50-68  99E2  吮 */
	{ 0x5265, 0x5436, },	/* 50-69  99E3  吶 */
	{ 0x5266, 0x5429, },	/* 50-70  99E4  吩 */
	{ 0x5267, 0x541D, },	/* 50-71  99E5  吝 */
	{ 0x5268, 0x544E, },	/* 50-72  99E6  呎 */
	{ 0x5269, 0x548F, },	/* 50-73  99E7  咏 */
	{ 0x526A, 0x5475, },	/* 50-74  99E8  呵 */
	{ 0x526B, 0x548E, },	/* 50-75  99E9  咎 */
	{ 0x526C, 0x545F, },	/* 50-76  99EA  呟 */
	{ 0x526D, 0x5471, },	/* 50-77  99EB  呱 */
	{ 0x526E, 0x5477, },	/* 50-78  99EC  呷 */
	{ 0x526F, 0x5470, },	/* 50-79  99ED  呰 */
	{ 0x5270, 0x5492, },	/* 50-80  99EE  咒 */
	{ 0x5271, 0x547B, },	/* 50-81  99EF  呻 */
	{ 0x5272, 0x5480, },	/* 50-82  99F0  咀 */
	{ 0x5273, 0x5476, },	/* 50-83  99F1  呶 */
	{ 0x5274, 0x5484, },	/* 50-84  99F2  咄 */
	{ 0x5275, 0x5490, },	/* 50-85  99F3  咐 */
	{ 0x5276, 0x5486, },	/* 50-86  99F4  咆 */
	{ 0x5277, 0x54C7, },	/* 50-87  99F5  哇 */
	{ 0x5278, 0x54A2, },	/* 50-88  99F6  咢 */
	{ 0x5279, 0x54B8, },	/* 50-89  99F7  咸 */
	{ 0x527A, 0x54A5, },	/* 50-90  99F8  咥 */
	{ 0x527B, 0x54AC, },	/* 50-91  99F9  咬 */
	{ 0x527C, 0x54C4, },	/* 50-92  99FA  哄 */
	{ 0x527D, 0x54C8, },	/* 50-93  99FB  哈 */
	{ 0x527E, 0x54A8, },	/* 50-94  99FC  咨 */
	{ 0x5321, 0x54AB, },	/* 51-01  9A40  咫 */
	{ 0x5322, 0x54C2, },	/* 51-02  9A41  哂 */
	{ 0x5323, 0x54A4, },	/* 51-03  9A42  咤 */
	{ 0x5324, 0x54BE, },	/* 51-04  9A43  咾 */
	{ 0x5325, 0x54BC, },	/* 51-05  9A44  咼 */
	{ 0x5326, 0x54D8, },	/* 51-06  9A45  哘 */
	{ 0x5327, 0x54E5, },	/* 51-07  9A46  哥 */
	{ 0x5328, 0x54E6, },	/* 51-08  9A47  哦 */
	{ 0x5329, 0x550F, },	/* 51-09  9A48  唏 */
	{ 0x532A, 0x5514, },	/* 51-10  9A49  唔 */
	{ 0x532B, 0x54FD, },	/* 51-11  9A4A  哽 */
	{ 0x532C, 0x54EE, },	/* 51-12  9A4B  哮 */
	{ 0x532D, 0x54ED, },	/* 51-13  9A4C  哭 */
	{ 0x532E, 0x54FA, },	/* 51-14  9A4D  哺 */
	{ 0x532F, 0x54E2, },	/* 51-15  9A4E  哢 */
	{ 0x5330, 0x5539, },	/* 51-16  9A4F  唹 */
	{ 0x5331, 0x5540, },	/* 51-17  9A50  啀 */
	{ 0x5332, 0x5563, },	/* 51-18  9A51  啣 */
	{ 0x5333, 0x554C, },	/* 51-19  9A52  啌 */
	{ 0x5334, 0x552E, },	/* 51-20  9A53  售 */
	{ 0x5335, 0x555C, },	/* 51-21  9A54  啜 */
	{ 0x5336, 0x5545, },	/* 51-22  9A55  啅 */
	{ 0x5337, 0x5556, },	/* 51-23  9A56  啖 */
	{ 0x5338, 0x5557, },	/* 51-24  9A57  啗 */
	{ 0x5339, 0x5538, },	/* 51-25  9A58  唸 */
	{ 0x533A, 0x5533, },	/* 51-26  9A59  唳 */
	{ 0x533B, 0x555D, },	/* 51-27  9A5A  啝 */
	{ 0x533C, 0x5599, },	/* 51-28  9A5B  喙 */
	{ 0x533D, 0x5580, },	/* 51-29  9A5C  喀 */
	{ 0x533E, 0x54AF, },	/* 51-30  9A5D  咯 */
	{ 0x533F, 0x558A, },	/* 51-31  9A5E  喊 */
	{ 0x5340, 0x559F, },	/* 51-32  9A5F  喟 */
	{ 0x5341, 0x557B, },	/* 51-33  9A60  啻 */
	{ 0x5342, 0x557E, },	/* 51-34  9A61  啾 */
	{ 0x5343, 0x5598, },	/* 51-35  9A62  喘 */
	{ 0x5344, 0x559E, },	/* 51-36  9A63  喞 */
	{ 0x5345, 0x55AE, },	/* 51-37  9A64  單 */
	{ 0x5346, 0x557C, },	/* 51-38  9A65  啼 */
	{ 0x5347, 0x5583, },	/* 51-39  9A66  喃 */
	{ 0x5348, 0x55A9, },	/* 51-40  9A67  喩 */
	{ 0x5349, 0x5587, },	/* 51-41  9A68  喇 */
	{ 0x534A, 0x55A8, },	/* 51-42  9A69  喨 */
	{ 0x534B, 0x55DA, },	/* 51-43  9A6A  嗚 */
	{ 0x534C, 0x55C5, },	/* 51-44  9A6B  嗅 */
	{ 0x534D, 0x55DF, },	/* 51-45  9A6C  嗟 */
	{ 0x534E, 0x55C4, },	/* 51-46  9A6D  嗄 */
	{ 0x534F, 0x55DC, },	/* 51-47  9A6E  嗜 */
	{ 0x5350, 0x55E4, },	/* 51-48  9A6F  嗤 */
	{ 0x5351, 0x55D4, },	/* 51-49  9A70  嗔 */
	{ 0x5352, 0x5614, },	/* 51-50  9A71  嘔 */
	{ 0x5353, 0x55F7, },	/* 51-51  9A72  嗷 */
	{ 0x5354, 0x5616, },	/* 51-52  9A73  嘖 */
	{ 0x5355, 0x55FE, },	/* 51-53  9A74  嗾 */
	{ 0x5356, 0x55FD, },	/* 51-54  9A75  嗽 */
	{ 0x5357, 0x561B, },	/* 51-55  9A76  嘛 */
	{ 0x5358, 0x55F9, },	/* 51-56  9A77  嗹 */
	{ 0x5359, 0x564E, },	/* 51-57  9A78  噎 */
	{ 0x535A, 0x5650, },	/* 51-58  9A79  噐 */
	{ 0x535B, 0x71DF, },	/* 51-59  9A7A  營 */
	{ 0x535C, 0x5634, },	/* 51-60  9A7B  嘴 */
	{ 0x535D, 0x5636, },	/* 51-61  9A7C  嘶 */
	{ 0x535E, 0x5632, },	/* 51-62  9A7D  嘲 */
	{ 0x535F, 0x5638, },	/* 51-63  9A7E  嘸 */
	{ 0x5360, 0x566B, },	/* 51-64  9A80  噫 */
	{ 0x5361, 0x5664, },	/* 51-65  9A81  噤 */
	{ 0x5362, 0x562F, },	/* 51-66  9A82  嘯 */
	{ 0x5363, 0x566C, },	/* 51-67  9A83  噬 */
	{ 0x5364, 0x566A, },	/* 51-68  9A84  噪 */
	{ 0x5365, 0x5686, },	/* 51-69  9A85  嚆 */
	{ 0x5366, 0x5680, },	/* 51-70  9A86  嚀 */
	{ 0x5367, 0x568A, },	/* 51-71  9A87  嚊 */
	{ 0x5368, 0x56A0, },	/* 51-72  9A88  嚠 */
	{ 0x5369, 0x5694, },	/* 51-73  9A89  嚔 */
	{ 0x536A, 0x568F, },	/* 51-74  9A8A  嚏 */
	{ 0x536B, 0x56A5, },	/* 51-75  9A8B  嚥 */
	{ 0x536C, 0x56AE, },	/* 51-76  9A8C  嚮 */
	{ 0x536D, 0x56B6, },	/* 51-77  9A8D  嚶 */
	{ 0x536E, 0x56B4, },	/* 51-78  9A8E  嚴 */
	{ 0x536F, 0x56C2, },	/* 51-79  9A8F  囂 */
	{ 0x5370, 0x56BC, },	/* 51-80  9A90  嚼 */
	{ 0x5371, 0x56C1, },	/* 51-81  9A91  囁 */
	{ 0x5372, 0x56C3, },	/* 51-82  9A92  囃 */
	{ 0x5373, 0x56C0, },	/* 51-83  9A93  囀 */
	{ 0x5374, 0x56C8, },	/* 51-84  9A94  囈 */
	{ 0x5375, 0x56CE, },	/* 51-85  9A95  囎 */
	{ 0x5376, 0x56D1, },	/* 51-86  9A96  囑 */
	{ 0x5377, 0x56D3, },	/* 51-87  9A97  囓 */
	{ 0x5378, 0x56D7, },	/* 51-88  9A98  囗 */
	{ 0x5379, 0x56EE, },	/* 51-89  9A99  囮 */
	{ 0x537A, 0x56F9, },	/* 51-90  9A9A  囹 */
	{ 0x537B, 0x5700, },	/* 51-91  9A9B  圀 */
	{ 0x537C, 0x56FF, },	/* 51-92  9A9C  囿 */
	{ 0x537D, 0x5704, },	/* 51-93  9A9D  圄 */
	{ 0x537E, 0x5709, },	/* 51-94  9A9E  圉 */
	{ 0x5421, 0x5708, },	/* 52-01  9A9F  圈 */
	{ 0x5422, 0x570B, },	/* 52-02  9AA0  國 */
	{ 0x5423, 0x570D, },	/* 52-03  9AA1  圍 */
	{ 0x5424, 0x5713, },	/* 52-04  9AA2  圓 */
	{ 0x5425, 0x5718, },	/* 52-05  9AA3  團 */
	{ 0x5426, 0x5716, },	/* 52-06  9AA4  圖 */
	{ 0x5427, 0x55C7, },	/* 52-07  9AA5  嗇 */
	{ 0x5428, 0x571C, },	/* 52-08  9AA6  圜 */
	{ 0x5429, 0x5726, },	/* 52-09  9AA7  圦 */
	{ 0x542A, 0x5737, },	/* 52-10  9AA8  圷 */
	{ 0x542B, 0x5738, },	/* 52-11  9AA9  圸 */
	{ 0x542C, 0x574E, },	/* 52-12  9AAA  坎 */
	{ 0x542D, 0x573B, },	/* 52-13  9AAB  圻 */
	{ 0x542E, 0x5740, },	/* 52-14  9AAC  址 */
	{ 0x542F, 0x574F, },	/* 52-15  9AAD  坏 */
	{ 0x5430, 0x5769, },	/* 52-16  9AAE  坩 */
	{ 0x5431, 0x57C0, },	/* 52-17  9AAF  埀 */
	{ 0x5432, 0x5788, },	/* 52-18  9AB0  垈 */
	{ 0x5433, 0x5761, },	/* 52-19  9AB1  坡 */
	{ 0x5434, 0x577F, },	/* 52-20  9AB2  坿 */
	{ 0x5435, 0x5789, },	/* 52-21  9AB3  垉 */
	{ 0x5436, 0x5793, },	/* 52-22  9AB4  垓 */
	{ 0x5437, 0x57A0, },	/* 52-23  9AB5  垠 */
	{ 0x5438, 0x57B3, },	/* 52-24  9AB6  垳 */
	{ 0x5439, 0x57A4, },	/* 52-25  9AB7  垤 */
	{ 0x543A, 0x57AA, },	/* 52-26  9AB8  垪 */
	{ 0x543B, 0x57B0, },	/* 52-27  9AB9  垰 */
	{ 0x543C, 0x57C3, },	/* 52-28  9ABA  埃 */
	{ 0x543D, 0x57C6, },	/* 52-29  9ABB  埆 */
	{ 0x543E, 0x57D4, },	/* 52-30  9ABC  埔 */
	{ 0x543F, 0x57D2, },	/* 52-31  9ABD  埒 */
	{ 0x5440, 0x57D3, },	/* 52-32  9ABE  埓 */
	{ 0x5441, 0x580A, },	/* 52-33  9ABF  堊 */
	{ 0x5442, 0x57D6, },	/* 52-34  9AC0  埖 */
	{ 0x5443, 0x57E3, },	/* 52-35  9AC1  埣 */
	{ 0x5444, 0x580B, },	/* 52-36  9AC2  堋 */
	{ 0x5445, 0x5819, },	/* 52-37  9AC3  堙 */
	{ 0x5446, 0x581D, },	/* 52-38  9AC4  堝 */
	{ 0x5447, 0x5872, },	/* 52-39  9AC5  塲 */
	{ 0x5448, 0x5821, },	/* 52-40  9AC6  堡 */
	{ 0x5449, 0x5862, },	/* 52-41  9AC7  塢 */
	{ 0x544A, 0x584B, },	/* 52-42  9AC8  塋 */
	{ 0x544B, 0x5870, },	/* 52-43  9AC9  塰 */
	{ 0x544C, 0x6BC0, },	/* 52-44  9ACA  毀 */
	{ 0x544D, 0x5852, },	/* 52-45  9ACB  塒 */
	{ 0x544E, 0x583D, },	/* 52-46  9ACC  堽 */
	{ 0x544F, 0x5879, },	/* 52-47  9ACD  塹 */
	{ 0x5450, 0x5885, },	/* 52-48  9ACE  墅 */
	{ 0x5451, 0x58B9, },	/* 52-49  9ACF  墹 */
	{ 0x5452, 0x589F, },	/* 52-50  9AD0  墟 */
	{ 0x5453, 0x58AB, },	/* 52-51  9AD1  墫 */
	{ 0x5454, 0x58BA, },	/* 52-52  9AD2  墺 */
	{ 0x5455, 0x58DE, },	/* 52-53  9AD3  壞 */
	{ 0x5456, 0x58BB, },	/* 52-54  9AD4  墻 */
	{ 0x5457, 0x58B8, },	/* 52-55  9AD5  墸 */
	{ 0x5458, 0x58AE, },	/* 52-56  9AD6  墮 */
	{ 0x5459, 0x58C5, },	/* 52-57  9AD7  壅 */
	{ 0x545A, 0x58D3, },	/* 52-58  9AD8  壓 */
	{ 0x545B, 0x58D1, },	/* 52-59  9AD9  壑 */
	{ 0x545C, 0x58D7, },	/* 52-60  9ADA  壗 */
	{ 0x545D, 0x58D9, },	/* 52-61  9ADB  壙 */
	{ 0x545E, 0x58D8, },	/* 52-62  9ADC  壘 */
	{ 0x545F, 0x58E5, },	/* 52-63  9ADD  壥 */
	{ 0x5460, 0x58DC, },	/* 52-64  9ADE  壜 */
	{ 0x5461, 0x58E4, },	/* 52-65  9ADF  壤 */
	{ 0x5462, 0x58DF, },	/* 52-66  9AE0  壟 */
	{ 0x5463, 0x58EF, },	/* 52-67  9AE1  壯 */
	{ 0x5464, 0x58FA, },	/* 52-68  9AE2  壺 */
	{ 0x5465, 0x58F9, },	/* 52-69  9AE3  壹 */
	{ 0x5466, 0x58FB, },	/* 52-70  9AE4  壻 */
	{ 0x5467, 0x58FC, },	/* 52-71  9AE5  壼 */
	{ 0x5468, 0x58FD, },	/* 52-72  9AE6  壽 */
	{ 0x5469, 0x5902, },	/* 52-73  9AE7  夂 */
	{ 0x546A, 0x590A, },	/* 52-74  9AE8  夊 */
	{ 0x546B, 0x5910, },	/* 52-75  9AE9  夐 */
	{ 0x546C, 0x591B, },	/* 52-76  9AEA  夛 */
	{ 0x546D, 0x68A6, },	/* 52-77  9AEB  梦 */
	{ 0x546E, 0x5925, },	/* 52-78  9AEC  夥 */
	{ 0x546F, 0x592C, },	/* 52-79  9AED  夬 */
	{ 0x5470, 0x592D, },	/* 52-80  9AEE  夭 */
	{ 0x5471, 0x5932, },	/* 52-81  9AEF  夲 */
	{ 0x5472, 0x5938, },	/* 52-82  9AF0  夸 */
	{ 0x5473, 0x593E, },	/* 52-83  9AF1  夾 */
	{ 0x5474, 0x7AD2, },	/* 52-84  9AF2  竒 */
	{ 0x5475, 0x5955, },	/* 52-85  9AF3  奕 */
	{ 0x5476, 0x5950, },	/* 52-86  9AF4  奐 */
	{ 0x5477, 0x594E, },	/* 52-87  9AF5  奎 */
	{ 0x5478, 0x595A, },	/* 52-88  9AF6  奚 */
	{ 0x5479, 0x5958, },	/* 52-89  9AF7  奘 */
	{ 0x547A, 0x5962, },	/* 52-90  9AF8  奢 */
	{ 0x547B, 0x5960, },	/* 52-91  9AF9  奠 */
	{ 0x547C, 0x5967, },	/* 52-92  9AFA  奧 */
	{ 0x547D, 0x596C, },	/* 52-93  9AFB  奬 */
	{ 0x547E, 0x5969, },	/* 52-94  9AFC  奩 */
	{ 0x5521, 0x5978, },	/* 53-01  9B40  奸 */
	{ 0x5522, 0x5981, },	/* 53-02  9B41  妁 */
	{ 0x5523, 0x599D, },	/* 53-03  9B42  妝 */
	{ 0x5524, 0x4F5E, },	/* 53-04  9B43  佞 */
	{ 0x5525, 0x4FAB, },	/* 53-05  9B44  侫 */
	{ 0x5526, 0x59A3, },	/* 53-06  9B45  妣 */
	{ 0x5527, 0x59B2, },	/* 53-07  9B46  妲 */
	{ 0x5528, 0x59C6, },	/* 53-08  9B47  姆 */
	{ 0x5529, 0x59E8, },	/* 53-09  9B48  姨 */
	{ 0x552A, 0x59DC, },	/* 53-10  9B49  姜 */
	{ 0x552B, 0x598D, },	/* 53-11  9B4A  妍 */
	{ 0x552C, 0x59D9, },	/* 53-12  9B4B  姙 */
	{ 0x552D, 0x59DA, },	/* 53-13  9B4C  姚 */
	{ 0x552E, 0x5A25, },	/* 53-14  9B4D  娥 */
	{ 0x552F, 0x5A1F, },	/* 53-15  9B4E  娟 */
	{ 0x5530, 0x5A11, },	/* 53-16  9B4F  娑 */
	{ 0x5531, 0x5A1C, },	/* 53-17  9B50  娜 */
	{ 0x5532, 0x5A09, },	/* 53-18  9B51  娉 */
	{ 0x5533, 0x5A1A, },	/* 53-19  9B52  娚 */
	{ 0x5534, 0x5A40, },	/* 53-20  9B53  婀 */
	{ 0x5535, 0x5A6C, },	/* 53-21  9B54  婬 */
	{ 0x5536, 0x5A49, },	/* 53-22  9B55  婉 */
	{ 0x5537, 0x5A35, },	/* 53-23  9B56  娵 */
	{ 0x5538, 0x5A36, },	/* 53-24  9B57  娶 */
	{ 0x5539, 0x5A62, },	/* 53-25  9B58  婢 */
	{ 0x553A, 0x5A6A, },	/* 53-26  9B59  婪 */
	{ 0x553B, 0x5A9A, },	/* 53-27  9B5A  媚 */
	{ 0x553C, 0x5ABC, },	/* 53-28  9B5B  媼 */
	{ 0x553D, 0x5ABE, },	/* 53-29  9B5C  媾 */
	{ 0x553E, 0x5ACB, },	/* 53-30  9B5D  嫋 */
	{ 0x553F, 0x5AC2, },	/* 53-31  9B5E  嫂 */
	{ 0x5540, 0x5ABD, },	/* 53-32  9B5F  媽 */
	{ 0x5541, 0x5AE3, },	/* 53-33  9B60  嫣 */
	{ 0x5542, 0x5AD7, },	/* 53-34  9B61  嫗 */
	{ 0x5543, 0x5AE6, },	/* 53-35  9B62  嫦 */
	{ 0x5544, 0x5AE9, },	/* 53-36  9B63  嫩 */
	{ 0x5545, 0x5AD6, },	/* 53-37  9B64  嫖 */
	{ 0x5546, 0x5AFA, },	/* 53-38  9B65  嫺 */
	{ 0x5547, 0x5AFB, },	/* 53-39  9B66  嫻 */
	{ 0x5548, 0x5B0C, },	/* 53-40  9B67  嬌 */
	{ 0x5549, 0x5B0B, },	/* 53-41  9B68  嬋 */
	{ 0x554A, 0x5B16, },	/* 53-42  9B69  嬖 */
	{ 0x554B, 0x5B32, },	/* 53-43  9B6A  嬲 */
	{ 0x554C, 0x5AD0, },	/* 53-44  9B6B  嫐 */
	{ 0x554D, 0x5B2A, },	/* 53-45  9B6C  嬪 */
	{ 0x554E, 0x5B36, },	/* 53-46  9B6D  嬶 */
	{ 0x554F, 0x5B3E, },	/* 53-47  9B6E  嬾 */
	{ 0x5550, 0x5B43, },	/* 53-48  9B6F  孃 */
	{ 0x5551, 0x5B45, },	/* 53-49  9B70  孅 */
	{ 0x5552, 0x5B40, },	/* 53-50  9B71  孀 */
	{ 0x5553, 0x5B51, },	/* 53-51  9B72  孑 */
	{ 0x5554, 0x5B55, },	/* 53-52  9B73  孕 */
	{ 0x5555, 0x5B5A, },	/* 53-53  9B74  孚 */
	{ 0x5556, 0x5B5B, },	/* 53-54  9B75  孛 */
	{ 0x5557, 0x5B65, },	/* 53-55  9B76  孥 */
	{ 0x5558, 0x5B69, },	/* 53-56  9B77  孩 */
	{ 0x5559, 0x5B70, },	/* 53-57  9B78  孰 */
	{ 0x555A, 0x5B73, },	/* 53-58  9B79  孳 */
	{ 0x555B, 0x5B75, },	/* 53-59  9B7A  孵 */
	{ 0x555C, 0x5B78, },	/* 53-60  9B7B  學 */
	{ 0x555D, 0x6588, },	/* 53-61  9B7C  斈 */
	{ 0x555E, 0x5B7A, },	/* 53-62  9B7D  孺 */
	{ 0x555F, 0x5B80, },	/* 53-63  9B7E  宀 */
	{ 0x5560, 0x5B83, },	/* 53-64  9B80  它 */
	{ 0x5561, 0x5BA6, },	/* 53-65  9B81  宦 */
	{ 0x5562, 0x5BB8, },	/* 53-66  9B82  宸 */
	{ 0x5563, 0x5BC3, },	/* 53-67  9B83  寃 */
	{ 0x5564, 0x5BC7, },	/* 53-68  9B84  寇 */
	{ 0x5565, 0x5BC9, },	/* 53-69  9B85  寉 */
	{ 0x5566, 0x5BD4, },	/* 53-70  9B86  寔 */
	{ 0x5567, 0x5BD0, },	/* 53-71  9B87  寐 */
	{ 0x5568, 0x5BE4, },	/* 53-72  9B88  寤 */
	{ 0x5569, 0x5BE6, },	/* 53-73  9B89  實 */
	{ 0x556A, 0x5BE2, },	/* 53-74  9B8A  寢 */
	{ 0x556B, 0x5BDE, },	/* 53-75  9B8B  寞 */
	{ 0x556C, 0x5BE5, },	/* 53-76  9B8C  寥 */
	{ 0x556D, 0x5BEB, },	/* 53-77  9B8D  寫 */
	{ 0x556E, 0x5BF0, },	/* 53-78  9B8E  寰 */
	{ 0x556F, 0x5BF6, },	/* 53-79  9B8F  寶 */
	{ 0x5570, 0x5BF3, },	/* 53-80  9B90  寳 */
	{ 0x5571, 0x5C05, },	/* 53-81  9B91  尅 */
	{ 0x5572, 0x5C07, },	/* 53-82  9B92  將 */
	{ 0x5573, 0x5C08, },	/* 53-83  9B93  專 */
	{ 0x5574, 0x5C0D, },	/* 53-84  9B94  對 */
	{ 0x5575, 0x5C13, },	/* 53-85  9B95  尓 */
	{ 0x5576, 0x5C20, },	/* 53-86  9B96  尠 */
	{ 0x5577, 0x5C22, },	/* 53-87  9B97  尢 */
	{ 0x5578, 0x5C28, },	/* 53-88  9B98  尨 */
	{ 0x5579, 0x5C38, },	/* 53-89  9B99  尸 */
	{ 0x557A, 0x5C39, },	/* 53-90  9B9A  尹 */
	{ 0x557B, 0x5C41, },	/* 53-91  9B9B  屁 */
	{ 0x557C, 0x5C46, },	/* 53-92  9B9C  屆 */
	{ 0x557D, 0x5C4E, },	/* 53-93  9B9D  屎 */
	{ 0x557E, 0x5C53, },	/* 53-94  9B9E  屓 */
	{ 0x5621, 0x5C50, },	/* 54-01  9B9F  屐 */
	{ 0x5622, 0x5C4F, },	/* 54-02  9BA0  屏 */
	{ 0x5623, 0x5B71, },	/* 54-03  9BA1  孱 */
	{ 0x5624, 0x5C6C, },	/* 54-04  9BA2  屬 */
	{ 0x5625, 0x5C6E, },	/* 54-05  9BA3  屮 */
	{ 0x5626, 0x4E62, },	/* 54-06  9BA4  乢 */
	{ 0x5627, 0x5C76, },	/* 54-07  9BA5  屶 */
	{ 0x5628, 0x5C79, },	/* 54-08  9BA6  屹 */
	{ 0x5629, 0x5C8C, },	/* 54-09  9BA7  岌 */
	{ 0x562A, 0x5C91, },	/* 54-10  9BA8  岑 */
	{ 0x562B, 0x5C94, },	/* 54-11  9BA9  岔 */
	{ 0x562C, 0x599B, },	/* 54-12  9BAA  妛 */
	{ 0x562D, 0x5CAB, },	/* 54-13  9BAB  岫 */
	{ 0x562E, 0x5CBB, },	/* 54-14  9BAC  岻 */
	{ 0x562F, 0x5CB6, },	/* 54-15  9BAD  岶 */
	{ 0x5630, 0x5CBC, },	/* 54-16  9BAE  岼 */
	{ 0x5631, 0x5CB7, },	/* 54-17  9BAF  岷 */
	{ 0x5632, 0x5CC5, },	/* 54-18  9BB0  峅 */
	{ 0x5633, 0x5CBE, },	/* 54-19  9BB1  岾 */
	{ 0x5634, 0x5CC7, },	/* 54-20  9BB2  峇 */
	{ 0x5635, 0x5CD9, },	/* 54-21  9BB3  峙 */
	{ 0x5636, 0x5CE9, },	/* 54-22  9BB4  峩 */
	{ 0x5637, 0x5CFD, },	/* 54-23  9BB5  峽 */
	{ 0x5638, 0x5CFA, },	/* 54-24  9BB6  峺 */
	{ 0x5639, 0x5CED, },	/* 54-25  9BB7  峭 */
	{ 0x563A, 0x5D8C, },	/* 54-26  9BB8  嶌 */
	{ 0x563B, 0x5CEA, },	/* 54-27  9BB9  峪 */
	{ 0x563C, 0x5D0B, },	/* 54-28  9BBA  崋 */
	{ 0x563D, 0x5D15, },	/* 54-29  9BBB  崕 */
	{ 0x563E, 0x5D17, },	/* 54-30  9BBC  崗 */
	{ 0x563F, 0x5D5C, },	/* 54-31  9BBD  嵜 */
	{ 0x5640, 0x5D1F, },	/* 54-32  9BBE  崟 */
	{ 0x5641, 0x5D1B, },	/* 54-33  9BBF  崛 */
	{ 0x5642, 0x5D11, },	/* 54-34  9BC0  崑 */
	{ 0x5643, 0x5D14, },	/* 54-35  9BC1  崔 */
	{ 0x5644, 0x5D22, },	/* 54-36  9BC2  崢 */
	{ 0x5645, 0x5D1A, },	/* 54-37  9BC3  崚 */
	{ 0x5646, 0x5D19, },	/* 54-38  9BC4  崙 */
	{ 0x5647, 0x5D18, },	/* 54-39  9BC5  崘 */
	{ 0x5648, 0x5D4C, },	/* 54-40  9BC6  嵌 */
	{ 0x5649, 0x5D52, },	/* 54-41  9BC7  嵒 */
	{ 0x564A, 0x5D4E, },	/* 54-42  9BC8  嵎 */
	{ 0x564B, 0x5D4B, },	/* 54-43  9BC9  嵋 */
	{ 0x564C, 0x5D6C, },	/* 54-44  9BCA  嵬 */
	{ 0x564D, 0x5D73, },	/* 54-45  9BCB  嵳 */
	{ 0x564E, 0x5D76, },	/* 54-46  9BCC  嵶 */
	{ 0x564F, 0x5D87, },	/* 54-47  9BCD  嶇 */
	{ 0x5650, 0x5D84, },	/* 54-48  9BCE  嶄 */
	{ 0x5651, 0x5D82, },	/* 54-49  9BCF  嶂 */
	{ 0x5652, 0x5DA2, },	/* 54-50  9BD0  嶢 */
	{ 0x5653, 0x5D9D, },	/* 54-51  9BD1  嶝 */
	{ 0x5654, 0x5DAC, },	/* 54-52  9BD2  嶬 */
	{ 0x5655, 0x5DAE, },	/* 54-53  9BD3  嶮 */
	{ 0x5656, 0x5DBD, },	/* 54-54  9BD4  嶽 */
	{ 0x5657, 0x5D90, },	/* 54-55  9BD5  嶐 */
	{ 0x5658, 0x5DB7, },	/* 54-56  9BD6  嶷 */
	{ 0x5659, 0x5DBC, },	/* 54-57  9BD7  嶼 */
	{ 0x565A, 0x5DC9, },	/* 54-58  9BD8  巉 */
	{ 0x565B, 0x5DCD, },	/* 54-59  9BD9  巍 */
	{ 0x565C, 0x5DD3, },	/* 54-60  9BDA  巓 */
	{ 0x565D, 0x5DD2, },	/* 54-61  9BDB  巒 */
	{ 0x565E, 0x5DD6, },	/* 54-62  9BDC  巖 */
	{ 0x565F, 0x5DDB, },	/* 54-63  9BDD  巛 */
	{ 0x5660, 0x5DEB, },	/* 54-64  9BDE  巫 */
	{ 0x5661, 0x5DF2, },	/* 54-65  9BDF  已 */
	{ 0x5662, 0x5DF5, },	/* 54-66  9BE0  巵 */
	{ 0x5663, 0x5E0B, },	/* 54-67  9BE1  帋 */
	{ 0x5664, 0x5E1A, },	/* 54-68  9BE2  帚 */
	{ 0x5665, 0x5E19, },	/* 54-69  9BE3  帙 */
	{ 0x5666, 0x5E11, },	/* 54-70  9BE4  帑 */
	{ 0x5667, 0x5E1B, },	/* 54-71  9BE5  帛 */
	{ 0x5668, 0x5E36, },	/* 54-72  9BE6  帶 */
	{ 0x5669, 0x5E37, },	/* 54-73  9BE7  帷 */
	{ 0x566A, 0x5E44, },	/* 54-74  9BE8  幄 */
	{ 0x566B, 0x5E43, },	/* 54-75  9BE9  幃 */
	{ 0x566C, 0x5E40, },	/* 54-76  9BEA  幀 */
	{ 0x566D, 0x5E4E, },	/* 54-77  9BEB  幎 */
	{ 0x566E, 0x5E57, },	/* 54-78  9BEC  幗 */
	{ 0x566F, 0x5E54, },	/* 54-79  9BED  幔 */
	{ 0x5670, 0x5E5F, },	/* 54-80  9BEE  幟 */
	{ 0x5671, 0x5E62, },	/* 54-81  9BEF  幢 */
	{ 0x5672, 0x5E64, },	/* 54-82  9BF0  幤 */
	{ 0x5673, 0x5E47, },	/* 54-83  9BF1  幇 */
	{ 0x5674, 0x5E75, },	/* 54-84  9BF2  幵 */
	{ 0x5675, 0x5E76, },	/* 54-85  9BF3  并 */
	{ 0x5676, 0x5E7A, },	/* 54-86  9BF4  幺 */
	{ 0x5677, 0x9EBC, },	/* 54-87  9BF5  麼 */
	{ 0x5678, 0x5E7F, },	/* 54-88  9BF6  广 */
	{ 0x5679, 0x5EA0, },	/* 54-89  9BF7  庠 */
	{ 0x567A, 0x5EC1, },	/* 54-90  9BF8  廁 */
	{ 0x567B, 0x5EC2, },	/* 54-91  9BF9  廂 */
	{ 0x567C, 0x5EC8, },	/* 54-92  9BFA  廈 */
	{ 0x567D, 0x5ED0, },	/* 54-93  9BFB  廐 */
	{ 0x567E, 0x5ECF, },	/* 54-94  9BFC  廏 */
	{ 0x5721, 0x5ED6, },	/* 55-01  9C40  廖 */
	{ 0x5722, 0x5EE3, },	/* 55-02  9C41  廣 */
	{ 0x5723, 0x5EDD, },	/* 55-03  9C42  廝 */
	{ 0x5724, 0x5EDA, },	/* 55-04  9C43  廚 */
	{ 0x5725, 0x5EDB, },	/* 55-05  9C44  廛 */
	{ 0x5726, 0x5EE2, },	/* 55-06  9C45  廢 */
	{ 0x5727, 0x5EE1, },	/* 55-07  9C46  廡 */
	{ 0x5728, 0x5EE8, },	/* 55-08  9C47  廨 */
	{ 0x5729, 0x5EE9, },	/* 55-09  9C48  廩 */
	{ 0x572A, 0x5EEC, },	/* 55-10  9C49  廬 */
	{ 0x572B, 0x5EF1, },	/* 55-11  9C4A  廱 */
	{ 0x572C, 0x5EF3, },	/* 55-12  9C4B  廳 */
	{ 0x572D, 0x5EF0, },	/* 55-13  9C4C  廰 */
	{ 0x572E, 0x5EF4, },	/* 55-14  9C4D  廴 */
	{ 0x572F, 0x5EF8, },	/* 55-15  9C4E  廸 */
	{ 0x5730, 0x5EFE, },	/* 55-16  9C4F  廾 */
	{ 0x5731, 0x5F03, },	/* 55-17  9C50  弃 */
	{ 0x5732, 0x5F09, },	/* 55-18  9C51  弉 */
	{ 0x5733, 0x5F5D, },	/* 55-19  9C52  彝 */
	{ 0x5734, 0x5F5C, },	/* 55-20  9C53  彜 */
	{ 0x5735, 0x5F0B, },	/* 55-21  9C54  弋 */
	{ 0x5736, 0x5F11, },	/* 55-22  9C55  弑 */
	{ 0x5737, 0x5F16, },	/* 55-23  9C56  弖 */
	{ 0x5738, 0x5F29, },	/* 55-24  9C57  弩 */
	{ 0x5739, 0x5F2D, },	/* 55-25  9C58  弭 */
	{ 0x573A, 0x5F38, },	/* 55-26  9C59  弸 */
	{ 0x573B, 0x5F41, },	/* 55-27  9C5A  彁 */
	{ 0x573C, 0x5F48, },	/* 55-28  9C5B  彈 */
	{ 0x573D, 0x5F4C, },	/* 55-29  9C5C  彌 */
	{ 0x573E, 0x5F4E, },	/* 55-30  9C5D  彎 */
	{ 0x573F, 0x5F2F, },	/* 55-31  9C5E  弯 */
	{ 0x5740, 0x5F51, },	/* 55-32  9C5F  彑 */
	{ 0x5741, 0x5F56, },	/* 55-33  9C60  彖 */
	{ 0x5742, 0x5F57, },	/* 55-34  9C61  彗 */
	{ 0x5743, 0x5F59, },	/* 55-35  9C62  彙 */
	{ 0x5744, 0x5F61, },	/* 55-36  9C63  彡 */
	{ 0x5745, 0x5F6D, },	/* 55-37  9C64  彭 */
	{ 0x5746, 0x5F73, },	/* 55-38  9C65  彳 */
	{ 0x5747, 0x5F77, },	/* 55-39  9C66  彷 */
	{ 0x5748, 0x5F83, },	/* 55-40  9C67  徃 */
	{ 0x5749, 0x5F82, },	/* 55-41  9C68  徂 */
	{ 0x574A, 0x5F7F, },	/* 55-42  9C69  彿 */
	{ 0x574B, 0x5F8A, },	/* 55-43  9C6A  徊 */
	{ 0x574C, 0x5F88, },	/* 55-44  9C6B  很 */
	{ 0x574D, 0x5F91, },	/* 55-45  9C6C  徑 */
	{ 0x574E, 0x5F87, },	/* 55-46  9C6D  徇 */
	{ 0x574F, 0x5F9E, },	/* 55-47  9C6E  從 */
	{ 0x5750, 0x5F99, },	/* 55-48  9C6F  徙 */
	{ 0x5751, 0x5F98, },	/* 55-49  9C70  徘 */
	{ 0x5752, 0x5FA0, },	/* 55-50  9C71  徠 */
	{ 0x5753, 0x5FA8, },	/* 55-51  9C72  徨 */
	{ 0x5754, 0x5FAD, },	/* 55-52  9C73  徭 */
	{ 0x5755, 0x5FBC, },	/* 55-53  9C74  徼 */
	{ 0x5756, 0x5FD6, },	/* 55-54  9C75  忖 */
	{ 0x5757, 0x5FFB, },	/* 55-55  9C76  忻 */
	{ 0x5758, 0x5FE4, },	/* 55-56  9C77  忤 */
	{ 0x5759, 0x5FF8, },	/* 55-57  9C78  忸 */
	{ 0x575A, 0x5FF1, },	/* 55-58  9C79  忱 */
	{ 0x575B, 0x5FDD, },	/* 55-59  9C7A  忝 */
	{ 0x575C, 0x60B3, },	/* 55-60  9C7B  悳 */
	{ 0x575D, 0x5FFF, },	/* 55-61  9C7C  忿 */
	{ 0x575E, 0x6021, },	/* 55-62  9C7D  怡 */
	{ 0x575F, 0x6060, },	/* 55-63  9C7E  恠 */
	{ 0x5760, 0x6019, },	/* 55-64  9C80  怙 */
	{ 0x5761, 0x6010, },	/* 55-65  9C81  怐 */
	{ 0x5762, 0x6029, },	/* 55-66  9C82  怩 */
	{ 0x5763, 0x600E, },	/* 55-67  9C83  怎 */
	{ 0x5764, 0x6031, },	/* 55-68  9C84  怱 */
	{ 0x5765, 0x601B, },	/* 55-69  9C85  怛 */
	{ 0x5766, 0x6015, },	/* 55-70  9C86  怕 */
	{ 0x5767, 0x602B, },	/* 55-71  9C87  怫 */
	{ 0x5768, 0x6026, },	/* 55-72  9C88  怦 */
	{ 0x5769, 0x600F, },	/* 55-73  9C89  怏 */
	{ 0x576A, 0x603A, },	/* 55-74  9C8A  怺 */
	{ 0x576B, 0x605A, },	/* 55-75  9C8B  恚 */
	{ 0x576C, 0x6041, },	/* 55-76  9C8C  恁 */
	{ 0x576D, 0x606A, },	/* 55-77  9C8D  恪 */
	{ 0x576E, 0x6077, },	/* 55-78  9C8E  恷 */
	{ 0x576F, 0x605F, },	/* 55-79  9C8F  恟 */
	{ 0x5770, 0x604A, },	/* 55-80  9C90  恊 */
	{ 0x5771, 0x6046, },	/* 55-81  9C91  恆 */
	{ 0x5772, 0x604D, },	/* 55-82  9C92  恍 */
	{ 0x5773, 0x6063, },	/* 55-83  9C93  恣 */
	{ 0x5774, 0x6043, },	/* 55-84  9C94  恃 */
	{ 0x5775, 0x6064, },	/* 55-85  9C95  恤 */
	{ 0x5776, 0x6042, },	/* 55-86  9C96  恂 */
	{ 0x5777, 0x606C, },	/* 55-87  9C97  恬 */
	{ 0x5778, 0x606B, },	/* 55-88  9C98  恫 */
	{ 0x5779, 0x6059, },	/* 55-89  9C99  恙 */
	{ 0x577A, 0x6081, },	/* 55-90  9C9A  悁 */
	{ 0x577B, 0x608D, },	/* 55-91  9C9B  悍 */
	{ 0x577C, 0x60E7, },	/* 55-92  9C9C  惧 */
	{ 0x577D, 0x6083, },	/* 55-93  9C9D  悃 */
	{ 0x577E, 0x609A, },	/* 55-94  9C9E  悚 */
	{ 0x5821, 0x6084, },	/* 56-01  9C9F  悄 */
	{ 0x5822, 0x609B, },	/* 56-02  9CA0  悛 */
	{ 0x5823, 0x6096, },	/* 56-03  9CA1  悖 */
	{ 0x5824, 0x6097, },	/* 56-04  9CA2  悗 */
	{ 0x5825, 0x6092, },	/* 56-05  9CA3  悒 */
	{ 0x5826, 0x60A7, },	/* 56-06  9CA4  悧 */
	{ 0x5827, 0x608B, },	/* 56-07  9CA5  悋 */
	{ 0x5828, 0x60E1, },	/* 56-08  9CA6  惡 */
	{ 0x5829, 0x60B8, },	/* 56-09  9CA7  悸 */
	{ 0x582A, 0x60E0, },	/* 56-10  9CA8  惠 */
	{ 0x582B, 0x60D3, },	/* 56-11  9CA9  惓 */
	{ 0x582C, 0x60B4, },	/* 56-12  9CAA  悴 */
	{ 0x582D, 0x5FF0, },	/* 56-13  9CAB  忰 */
	{ 0x582E, 0x60BD, },	/* 56-14  9CAC  悽 */
	{ 0x582F, 0x60C6, },	/* 56-15  9CAD  惆 */
	{ 0x5830, 0x60B5, },	/* 56-16  9CAE  悵 */
	{ 0x5831, 0x60D8, },	/* 56-17  9CAF  惘 */
	{ 0x5832, 0x614D, },	/* 56-18  9CB0  慍 */
	{ 0x5833, 0x6115, },	/* 56-19  9CB1  愕 */
	{ 0x5834, 0x6106, },	/* 56-20  9CB2  愆 */
	{ 0x5835, 0x60F6, },	/* 56-21  9CB3  惶 */
	{ 0x5836, 0x60F7, },	/* 56-22  9CB4  惷 */
	{ 0x5837, 0x6100, },	/* 56-23  9CB5  愀 */
	{ 0x5838, 0x60F4, },	/* 56-24  9CB6  惴 */
	{ 0x5839, 0x60FA, },	/* 56-25  9CB7  惺 */
	{ 0x583A, 0x6103, },	/* 56-26  9CB8  愃 */
	{ 0x583B, 0x6121, },	/* 56-27  9CB9  愡 */
	{ 0x583C, 0x60FB, },	/* 56-28  9CBA  惻 */
	{ 0x583D, 0x60F1, },	/* 56-29  9CBB  惱 */
	{ 0x583E, 0x610D, },	/* 56-30  9CBC  愍 */
	{ 0x583F, 0x610E, },	/* 56-31  9CBD  愎 */
	{ 0x5840, 0x6147, },	/* 56-32  9CBE  慇 */
	{ 0x5841, 0x613E, },	/* 56-33  9CBF  愾 */
	{ 0x5842, 0x6128, },	/* 56-34  9CC0  愨 */
	{ 0x5843, 0x6127, },	/* 56-35  9CC1  愧 */
	{ 0x5844, 0x614A, },	/* 56-36  9CC2  慊 */
	{ 0x5845, 0x613F, },	/* 56-37  9CC3  愿 */
	{ 0x5846, 0x613C, },	/* 56-38  9CC4  愼 */
	{ 0x5847, 0x612C, },	/* 56-39  9CC5  愬 */
	{ 0x5848, 0x6134, },	/* 56-40  9CC6  愴 */
	{ 0x5849, 0x613D, },	/* 56-41  9CC7  愽 */
	{ 0x584A, 0x6142, },	/* 56-42  9CC8  慂 */
	{ 0x584B, 0x6144, },	/* 56-43  9CC9  慄 */
	{ 0x584C, 0x6173, },	/* 56-44  9CCA  慳 */
	{ 0x584D, 0x6177, },	/* 56-45  9CCB  慷 */
	{ 0x584E, 0x6158, },	/* 56-46  9CCC  慘 */
	{ 0x584F, 0x6159, },	/* 56-47  9CCD  慙 */
	{ 0x5850, 0x615A, },	/* 56-48  9CCE  慚 */
	{ 0x5851, 0x616B, },	/* 56-49  9CCF  慫 */
	{ 0x5852, 0x6174, },	/* 56-50  9CD0  慴 */
	{ 0x5853, 0x616F, },	/* 56-51  9CD1  慯 */
	{ 0x5854, 0x6165, },	/* 56-52  9CD2  慥 */
	{ 0x5855, 0x6171, },	/* 56-53  9CD3  慱 */
	{ 0x5856, 0x615F, },	/* 56-54  9CD4  慟 */
	{ 0x5857, 0x615D, },	/* 56-55  9CD5  慝 */
	{ 0x5858, 0x6153, },	/* 56-56  9CD6  慓 */
	{ 0x5859, 0x6175, },	/* 56-57  9CD7  慵 */
	{ 0x585A, 0x6199, },	/* 56-58  9CD8  憙 */
	{ 0x585B, 0x6196, },	/* 56-59  9CD9  憖 */
	{ 0x585C, 0x6187, },	/* 56-60  9CDA  憇 */
	{ 0x585D, 0x61AC, },	/* 56-61  9CDB  憬 */
	{ 0x585E, 0x6194, },	/* 56-62  9CDC  憔 */
	{ 0x585F, 0x619A, },	/* 56-63  9CDD  憚 */
	{ 0x5860, 0x618A, },	/* 56-64  9CDE  憊 */
	{ 0x5861, 0x6191, },	/* 56-65  9CDF  憑 */
	{ 0x5862, 0x61AB, },	/* 56-66  9CE0  憫 */
	{ 0x5863, 0x61AE, },	/* 56-67  9CE1  憮 */
	{ 0x5864, 0x61CC, },	/* 56-68  9CE2  懌 */
	{ 0x5865, 0x61CA, },	/* 56-69  9CE3  懊 */
	{ 0x5866, 0x61C9, },	/* 56-70  9CE4  應 */
	{ 0x5867, 0x61F7, },	/* 56-71  9CE5  懷 */
	{ 0x5868, 0x61C8, },	/* 56-72  9CE6  懈 */
	{ 0x5869, 0x61C3, },	/* 56-73  9CE7  懃 */
	{ 0x586A, 0x61C6, },	/* 56-74  9CE8  懆 */
	{ 0x586B, 0x61BA, },	/* 56-75  9CE9  憺 */
	{ 0x586C, 0x61CB, },	/* 56-76  9CEA  懋 */
	{ 0x586D, 0x7F79, },	/* 56-77  9CEB  罹 */
	{ 0x586E, 0x61CD, },	/* 56-78  9CEC  懍 */
	{ 0x586F, 0x61E6, },	/* 56-79  9CED  懦 */
	{ 0x5870, 0x61E3, },	/* 56-80  9CEE  懣 */
	{ 0x5871, 0x61F6, },	/* 56-81  9CEF  懶 */
	{ 0x5872, 0x61FA, },	/* 56-82  9CF0  懺 */
	{ 0x5873, 0x61F4, },	/* 56-83  9CF1  懴 */
	{ 0x5874, 0x61FF, },	/* 56-84  9CF2  懿 */
	{ 0x5875, 0x61FD, },	/* 56-85  9CF3  懽 */
	{ 0x5876, 0x61FC, },	/* 56-86  9CF4  懼 */
	{ 0x5877, 0x61FE, },	/* 56-87  9CF5  懾 */
	{ 0x5878, 0x6200, },	/* 56-88  9CF6  戀 */
	{ 0x5879, 0x6208, },	/* 56-89  9CF7  戈 */
	{ 0x587A, 0x6209, },	/* 56-90  9CF8  戉 */
	{ 0x587B, 0x620D, },	/* 56-91  9CF9  戍 */
	{ 0x587C, 0x620C, },	/* 56-92  9CFA  戌 */
	{ 0x587D, 0x6214, },	/* 56-93  9CFB  戔 */
	{ 0x587E, 0x621B, },	/* 56-94  9CFC  戛 */
	{ 0x5921, 0x621E, },	/* 57-01  9D40  戞 */
	{ 0x5922, 0x6221, },	/* 57-02  9D41  戡 */
	{ 0x5923, 0x622A, },	/* 57-03  9D42  截 */
	{ 0x5924, 0x622E, },	/* 57-04  9D43  戮 */
	{ 0x5925, 0x6230, },	/* 57-05  9D44  戰 */
	{ 0x5926, 0x6232, },	/* 57-06  9D45  戲 */
	{ 0x5927, 0x6233, },	/* 57-07  9D46  戳 */
	{ 0x5928, 0x6241, },	/* 57-08  9D47  扁 */
	{ 0x5929, 0x624E, },	/* 57-09  9D48  扎 */
	{ 0x592A, 0x625E, },	/* 57-10  9D49  扞 */
	{ 0x592B, 0x6263, },	/* 57-11  9D4A  扣 */
	{ 0x592C, 0x625B, },	/* 57-12  9D4B  扛 */
	{ 0x592D, 0x6260, },	/* 57-13  9D4C  扠 */
	{ 0x592E, 0x6268, },	/* 57-14  9D4D  扨 */
	{ 0x592F, 0x627C, },	/* 57-15  9D4E  扼 */
	{ 0x5930, 0x6282, },	/* 57-16  9D4F  抂 */
	{ 0x5931, 0x6289, },	/* 57-17  9D50  抉 */
	{ 0x5932, 0x627E, },	/* 57-18  9D51  找 */
	{ 0x5933, 0x6292, },	/* 57-19  9D52  抒 */
	{ 0x5934, 0x6293, },	/* 57-20  9D53  抓 */
	{ 0x5935, 0x6296, },	/* 57-21  9D54  抖 */
	{ 0x5936, 0x62D4, },	/* 57-22  9D55  拔 */
	{ 0x5937, 0x6283, },	/* 57-23  9D56  抃 */
	{ 0x5938, 0x6294, },	/* 57-24  9D57  抔 */
	{ 0x5939, 0x62D7, },	/* 57-25  9D58  拗 */
	{ 0x593A, 0x62D1, },	/* 57-26  9D59  拑 */
	{ 0x593B, 0x62BB, },	/* 57-27  9D5A  抻 */
	{ 0x593C, 0x62CF, },	/* 57-28  9D5B  拏 */
	{ 0x593D, 0x62FF, },	/* 57-29  9D5C  拿 */
	{ 0x593E, 0x62C6, },	/* 57-30  9D5D  拆 */
	{ 0x593F, 0x64D4, },	/* 57-31  9D5E  擔 */
	{ 0x5940, 0x62C8, },	/* 57-32  9D5F  拈 */
	{ 0x5941, 0x62DC, },	/* 57-33  9D60  拜 */
	{ 0x5942, 0x62CC, },	/* 57-34  9D61  拌 */
	{ 0x5943, 0x62CA, },	/* 57-35  9D62  拊 */
	{ 0x5944, 0x62C2, },	/* 57-36  9D63  拂 */
	{ 0x5945, 0x62C7, },	/* 57-37  9D64  拇 */
	{ 0x5946, 0x629B, },	/* 57-38  9D65  抛 */
	{ 0x5947, 0x62C9, },	/* 57-39  9D66  拉 */
	{ 0x5948, 0x630C, },	/* 57-40  9D67  挌 */
	{ 0x5949, 0x62EE, },	/* 57-41  9D68  拮 */
	{ 0x594A, 0x62F1, },	/* 57-42  9D69  拱 */
	{ 0x594B, 0x6327, },	/* 57-43  9D6A  挧 */
	{ 0x594C, 0x6302, },	/* 57-44  9D6B  挂 */
	{ 0x594D, 0x6308, },	/* 57-45  9D6C  挈 */
	{ 0x594E, 0x62EF, },	/* 57-46  9D6D  拯 */
	{ 0x594F, 0x62F5, },	/* 57-47  9D6E  拵 */
	{ 0x5950, 0x6350, },	/* 57-48  9D6F  捐 */
	{ 0x5951, 0x633E, },	/* 57-49  9D70  挾 */
	{ 0x5952, 0x634D, },	/* 57-50  9D71  捍 */
	{ 0x5953, 0x641C, },	/* 57-51  9D72  搜 */
	{ 0x5954, 0x634F, },	/* 57-52  9D73  捏 */
	{ 0x5955, 0x6396, },	/* 57-53  9D74  掖 */
	{ 0x5956, 0x638E, },	/* 57-54  9D75  掎 */
	{ 0x5957, 0x6380, },	/* 57-55  9D76  掀 */
	{ 0x5958, 0x63AB, },	/* 57-56  9D77  掫 */
	{ 0x5959, 0x6376, },	/* 57-57  9D78  捶 */
	{ 0x595A, 0x63A3, },	/* 57-58  9D79  掣 */
	{ 0x595B, 0x638F, },	/* 57-59  9D7A  掏 */
	{ 0x595C, 0x6389, },	/* 57-60  9D7B  掉 */
	{ 0x595D, 0x639F, },	/* 57-61  9D7C  掟 */
	{ 0x595E, 0x63B5, },	/* 57-62  9D7D  掵 */
	{ 0x595F, 0x636B, },	/* 57-63  9D7E  捫 */
	{ 0x5960, 0x6369, },	/* 57-64  9D80  捩 */
	{ 0x5961, 0x63BE, },	/* 57-65  9D81  掾 */
	{ 0x5962, 0x63E9, },	/* 57-66  9D82  揩 */
	{ 0x5963, 0x63C0, },	/* 57-67  9D83  揀 */
	{ 0x5964, 0x63C6, },	/* 57-68  9D84  揆 */
	{ 0x5965, 0x63E3, },	/* 57-69  9D85  揣 */
	{ 0x5966, 0x63C9, },	/* 57-70  9D86  揉 */
	{ 0x5967, 0x63D2, },	/* 57-71  9D87  插 */
	{ 0x5968, 0x63F6, },	/* 57-72  9D88  揶 */
	{ 0x5969, 0x63C4, },	/* 57-73  9D89  揄 */
	{ 0x596A, 0x6416, },	/* 57-74  9D8A  搖 */
	{ 0x596B, 0x6434, },	/* 57-75  9D8B  搴 */
	{ 0x596C, 0x6406, },	/* 57-76  9D8C  搆 */
	{ 0x596D, 0x6413, },	/* 57-77  9D8D  搓 */
	{ 0x596E, 0x6426, },	/* 57-78  9D8E  搦 */
	{ 0x596F, 0x6436, },	/* 57-79  9D8F  搶 */
	{ 0x5970, 0x651D, },	/* 57-80  9D90  攝 */
	{ 0x5971, 0x6417, },	/* 57-81  9D91  搗 */
	{ 0x5972, 0x6428, },	/* 57-82  9D92  搨 */
	{ 0x5973, 0x640F, },	/* 57-83  9D93  搏 */
	{ 0x5974, 0x6467, },	/* 57-84  9D94  摧 */
	{ 0x5975, 0x646F, },	/* 57-85  9D95  摯 */
	{ 0x5976, 0x6476, },	/* 57-86  9D96  摶 */
	{ 0x5977, 0x644E, },	/* 57-87  9D97  摎 */
	{ 0x5978, 0x652A, },	/* 57-88  9D98  攪 */
	{ 0x5979, 0x6495, },	/* 57-89  9D99  撕 */
	{ 0x597A, 0x6493, },	/* 57-90  9D9A  撓 */
	{ 0x597B, 0x64A5, },	/* 57-91  9D9B  撥 */
	{ 0x597C, 0x64A9, },	/* 57-92  9D9C  撩 */
	{ 0x597D, 0x6488, },	/* 57-93  9D9D  撈 */
	{ 0x597E, 0x64BC, },	/* 57-94  9D9E  撼 */
	{ 0x5A21, 0x64DA, },	/* 58-01  9D9F  據 */
	{ 0x5A22, 0x64D2, },	/* 58-02  9DA0  擒 */
	{ 0x5A23, 0x64C5, },	/* 58-03  9DA1  擅 */
	{ 0x5A24, 0x64C7, },	/* 58-04  9DA2  擇 */
	{ 0x5A25, 0x64BB, },	/* 58-05  9DA3  撻 */
	{ 0x5A26, 0x64D8, },	/* 58-06  9DA4  擘 */
	{ 0x5A27, 0x64C2, },	/* 58-07  9DA5  擂 */
	{ 0x5A28, 0x64F1, },	/* 58-08  9DA6  擱 */
	{ 0x5A29, 0x64E7, },	/* 58-09  9DA7  擧 */
	{ 0x5A2A, 0x8209, },	/* 58-10  9DA8  舉 */
	{ 0x5A2B, 0x64E0, },	/* 58-11  9DA9  擠 */
	{ 0x5A2C, 0x64E1, },	/* 58-12  9DAA  擡 */
	{ 0x5A2D, 0x62AC, },	/* 58-13  9DAB  抬 */
	{ 0x5A2E, 0x64E3, },	/* 58-14  9DAC  擣 */
	{ 0x5A2F, 0x64EF, },	/* 58-15  9DAD  擯 */
	{ 0x5A30, 0x652C, },	/* 58-16  9DAE  攬 */
	{ 0x5A31, 0x64F6, },	/* 58-17  9DAF  擶 */
	{ 0x5A32, 0x64F4, },	/* 58-18  9DB0  擴 */
	{ 0x5A33, 0x64F2, },	/* 58-19  9DB1  擲 */
	{ 0x5A34, 0x64FA, },	/* 58-20  9DB2  擺 */
	{ 0x5A35, 0x6500, },	/* 58-21  9DB3  攀 */
	{ 0x5A36, 0x64FD, },	/* 58-22  9DB4  擽 */
	{ 0x5A37, 0x6518, },	/* 58-23  9DB5  攘 */
	{ 0x5A38, 0x651C, },	/* 58-24  9DB6  攜 */
	{ 0x5A39, 0x6505, },	/* 58-25  9DB7  攅 */
	{ 0x5A3A, 0x6524, },	/* 58-26  9DB8  攤 */
	{ 0x5A3B, 0x6523, },	/* 58-27  9DB9  攣 */
	{ 0x5A3C, 0x652B, },	/* 58-28  9DBA  攫 */
	{ 0x5A3D, 0x6534, },	/* 58-29  9DBB  攴 */
	{ 0x5A3E, 0x6535, },	/* 58-30  9DBC  攵 */
	{ 0x5A3F, 0x6537, },	/* 58-31  9DBD  攷 */
	{ 0x5A40, 0x6536, },	/* 58-32  9DBE  收 */
	{ 0x5A41, 0x6538, },	/* 58-33  9DBF  攸 */
	{ 0x5A42, 0x754B, },	/* 58-34  9DC0  畋 */
	{ 0x5A43, 0x6548, },	/* 58-35  9DC1  效 */
	{ 0x5A44, 0x6556, },	/* 58-36  9DC2  敖 */
	{ 0x5A45, 0x6555, },	/* 58-37  9DC3  敕 */
	{ 0x5A46, 0x654D, },	/* 58-38  9DC4  敍 */
	{ 0x5A47, 0x6558, },	/* 58-39  9DC5  敘 */
	{ 0x5A48, 0x655E, },	/* 58-40  9DC6  敞 */
	{ 0x5A49, 0x655D, },	/* 58-41  9DC7  敝 */
	{ 0x5A4A, 0x6572, },	/* 58-42  9DC8  敲 */
	{ 0x5A4B, 0x6578, },	/* 58-43  9DC9  數 */
	{ 0x5A4C, 0x6582, },	/* 58-44  9DCA  斂 */
	{ 0x5A4D, 0x6583, },	/* 58-45  9DCB  斃 */
	{ 0x5A4E, 0x8B8A, },	/* 58-46  9DCC  變 */
	{ 0x5A4F, 0x659B, },	/* 58-47  9DCD  斛 */
	{ 0x5A50, 0x659F, },	/* 58-48  9DCE  斟 */
	{ 0x5A51, 0x65AB, },	/* 58-49  9DCF  斫 */
	{ 0x5A52, 0x65B7, },	/* 58-50  9DD0  斷 */
	{ 0x5A53, 0x65C3, },	/* 58-51  9DD1  旃 */
	{ 0x5A54, 0x65C6, },	/* 58-52  9DD2  旆 */
	{ 0x5A55, 0x65C1, },	/* 58-53  9DD3  旁 */
	{ 0x5A56, 0x65C4, },	/* 58-54  9DD4  旄 */
	{ 0x5A57, 0x65CC, },	/* 58-55  9DD5  旌 */
	{ 0x5A58, 0x65D2, },	/* 58-56  9DD6  旒 */
	{ 0x5A59, 0x65DB, },	/* 58-57  9DD7  旛 */
	{ 0x5A5A, 0x65D9, },	/* 58-58  9DD8  旙 */
	{ 0x5A5B, 0x65E0, },	/* 58-59  9DD9  无 */
	{ 0x5A5C, 0x65E1, },	/* 58-60  9DDA  旡 */
	{ 0x5A5D, 0x65F1, },	/* 58-61  9DDB  旱 */
	{ 0x5A5E, 0x6772, },	/* 58-62  9DDC  杲 */
	{ 0x5A5F, 0x660A, },	/* 58-63  9DDD  昊 */
	{ 0x5A60, 0x6603, },	/* 58-64  9DDE  昃 */
	{ 0x5A61, 0x65FB, },	/* 58-65  9DDF  旻 */
	{ 0x5A62, 0x6773, },	/* 58-66  9DE0  杳 */
	{ 0x5A63, 0x6635, },	/* 58-67  9DE1  昵 */
	{ 0x5A64, 0x6636, },	/* 58-68  9DE2  昶 */
	{ 0x5A65, 0x6634, },	/* 58-69  9DE3  昴 */
	{ 0x5A66, 0x661C, },	/* 58-70  9DE4  昜 */
	{ 0x5A67, 0x664F, },	/* 58-71  9DE5  晏 */
	{ 0x5A68, 0x6644, },	/* 58-72  9DE6  晄 */
	{ 0x5A69, 0x6649, },	/* 58-73  9DE7  晉 */
	{ 0x5A6A, 0x6641, },	/* 58-74  9DE8  晁 */
	{ 0x5A6B, 0x665E, },	/* 58-75  9DE9  晞 */
	{ 0x5A6C, 0x665D, },	/* 58-76  9DEA  晝 */
	{ 0x5A6D, 0x6664, },	/* 58-77  9DEB  晤 */
	{ 0x5A6E, 0x6667, },	/* 58-78  9DEC  晧 */
	{ 0x5A6F, 0x6668, },	/* 58-79  9DED  晨 */
	{ 0x5A70, 0x665F, },	/* 58-80  9DEE  晟 */
	{ 0x5A71, 0x6662, },	/* 58-81  9DEF  晢 */
	{ 0x5A72, 0x6670, },	/* 58-82  9DF0  晰 */
	{ 0x5A73, 0x6683, },	/* 58-83  9DF1  暃 */
	{ 0x5A74, 0x6688, },	/* 58-84  9DF2  暈 */
	{ 0x5A75, 0x668E, },	/* 58-85  9DF3  暎 */
	{ 0x5A76, 0x6689, },	/* 58-86  9DF4  暉 */
	{ 0x5A77, 0x6684, },	/* 58-87  9DF5  暄 */
	{ 0x5A78, 0x6698, },	/* 58-88  9DF6  暘 */
	{ 0x5A79, 0x669D, },	/* 58-89  9DF7  暝 */
	{ 0x5A7A, 0x66C1, },	/* 58-90  9DF8  曁 */
	{ 0x5A7B, 0x66B9, },	/* 58-91  9DF9  暹 */
	{ 0x5A7C, 0x66C9, },	/* 58-92  9DFA  曉 */
	{ 0x5A7D, 0x66BE, },	/* 58-93  9DFB  暾 */
	{ 0x5A7E, 0x66BC, },	/* 58-94  9DFC  暼 */
	{ 0x5B21, 0x66C4, },	/* 59-01  9E40  曄 */
	{ 0x5B22, 0x66B8, },	/* 59-02  9E41  暸 */
	{ 0x5B23, 0x66D6, },	/* 59-03  9E42  曖 */
	{ 0x5B24, 0x66DA, },	/* 59-04  9E43  曚 */
	{ 0x5B25, 0x66E0, },	/* 59-05  9E44  曠 */
	{ 0x5B26, 0x663F, },	/* 59-06  9E45  昿 */
	{ 0x5B27, 0x66E6, },	/* 59-07  9E46  曦 */
	{ 0x5B28, 0x66E9, },	/* 59-08  9E47  曩 */
	{ 0x5B29, 0x66F0, },	/* 59-09  9E48  曰 */
	{ 0x5B2A, 0x66F5, },	/* 59-10  9E49  曵 */
	{ 0x5B2B, 0x66F7, },	/* 59-11  9E4A  曷 */
	{ 0x5B2C, 0x670F, },	/* 59-12  9E4B  朏 */
	{ 0x5B2D, 0x6716, },	/* 59-13  9E4C  朖 */
	{ 0x5B2E, 0x671E, },	/* 59-14  9E4D  朞 */
	{ 0x5B2F, 0x6726, },	/* 59-15  9E4E  朦 */
	{ 0x5B30, 0x6727, },	/* 59-16  9E4F  朧 */
	{ 0x5B31, 0x9738, },	/* 59-17  9E50  霸 */
	{ 0x5B32, 0x672E, },	/* 59-18  9E51  朮 */
	{ 0x5B33, 0x673F, },	/* 59-19  9E52  朿 */
	{ 0x5B34, 0x6736, },	/* 59-20  9E53  朶 */
	{ 0x5B35, 0x6741, },	/* 59-21  9E54  杁 */
	{ 0x5B36, 0x6738, },	/* 59-22  9E55  朸 */
	{ 0x5B37, 0x6737, },	/* 59-23  9E56  朷 */
	{ 0x5B38, 0x6746, },	/* 59-24  9E57  杆 */
	{ 0x5B39, 0x675E, },	/* 59-25  9E58  杞 */
	{ 0x5B3A, 0x6760, },	/* 59-26  9E59  杠 */
	{ 0x5B3B, 0x6759, },	/* 59-27  9E5A  杙 */
	{ 0x5B3C, 0x6763, },	/* 59-28  9E5B  杣 */
	{ 0x5B3D, 0x6764, },	/* 59-29  9E5C  杤 */
	{ 0x5B3E, 0x6789, },	/* 59-30  9E5D  枉 */
	{ 0x5B3F, 0x6770, },	/* 59-31  9E5E  杰 */
	{ 0x5B40, 0x67A9, },	/* 59-32  9E5F  枩 */
	{ 0x5B41, 0x677C, },	/* 59-33  9E60  杼 */
	{ 0x5B42, 0x676A, },	/* 59-34  9E61  杪 */
	{ 0x5B43, 0x678C, },	/* 59-35  9E62  枌 */
	{ 0x5B44, 0x678B, },	/* 59-36  9E63  枋 */
	{ 0x5B45, 0x67A6, },	/* 59-37  9E64  枦 */
	{ 0x5B46, 0x67A1, },	/* 59-38  9E65  枡 */
	{ 0x5B47, 0x6785, },	/* 59-39  9E66  枅 */
	{ 0x5B48, 0x67B7, },	/* 59-40  9E67  枷 */
	{ 0x5B49, 0x67EF, },	/* 59-41  9E68  柯 */
	{ 0x5B4A, 0x67B4, },	/* 59-42  9E69  枴 */
	{ 0x5B4B, 0x67EC, },	/* 59-43  9E6A  柬 */
	{ 0x5B4C, 0x67B3, },	/* 59-44  9E6B  枳 */
	{ 0x5B4D, 0x67E9, },	/* 59-45  9E6C  柩 */
	{ 0x5B4E, 0x67B8, },	/* 59-46  9E6D  枸 */
	{ 0x5B4F, 0x67E4, },	/* 59-47  9E6E  柤 */
	{ 0x5B50, 0x67DE, },	/* 59-48  9E6F  柞 */
	{ 0x5B51, 0x67DD, },	/* 59-49  9E70  柝 */
	{ 0x5B52, 0x67E2, },	/* 59-50  9E71  柢 */
	{ 0x5B53, 0x67EE, },	/* 59-51  9E72  柮 */
	{ 0x5B54, 0x67B9, },	/* 59-52  9E73  枹 */
	{ 0x5B55, 0x67CE, },	/* 59-53  9E74  柎 */
	{ 0x5B56, 0x67C6, },	/* 59-54  9E75  柆 */
	{ 0x5B57, 0x67E7, },	/* 59-55  9E76  柧 */
	{ 0x5B58, 0x6A9C, },	/* 59-56  9E77  檜 */
	{ 0x5B59, 0x681E, },	/* 59-57  9E78  栞 */
	{ 0x5B5A, 0x6846, },	/* 59-58  9E79  框 */
	{ 0x5B5B, 0x6829, },	/* 59-59  9E7A  栩 */
	{ 0x5B5C, 0x6840, },	/* 59-60  9E7B  桀 */
	{ 0x5B5D, 0x684D, },	/* 59-61  9E7C  桍 */
	{ 0x5B5E, 0x6832, },	/* 59-62  9E7D  栲 */
	{ 0x5B5F, 0x684E, },	/* 59-63  9E7E  桎 */
	{ 0x5B60, 0x68B3, },	/* 59-64  9E80  梳 */
	{ 0x5B61, 0x682B, },	/* 59-65  9E81  栫 */
	{ 0x5B62, 0x6859, },	/* 59-66  9E82  桙 */
	{ 0x5B63, 0x6863, },	/* 59-67  9E83  档 */
	{ 0x5B64, 0x6877, },	/* 59-68  9E84  桷 */
	{ 0x5B65, 0x687F, },	/* 59-69  9E85  桿 */
	{ 0x5B66, 0x689F, },	/* 59-70  9E86  梟 */
	{ 0x5B67, 0x688F, },	/* 59-71  9E87  梏 */
	{ 0x5B68, 0x68AD, },	/* 59-72  9E88  梭 */
	{ 0x5B69, 0x6894, },	/* 59-73  9E89  梔 */
	{ 0x5B6A, 0x689D, },	/* 59-74  9E8A  條 */
	{ 0x5B6B, 0x689B, },	/* 59-75  9E8B  梛 */
	{ 0x5B6C, 0x6883, },	/* 59-76  9E8C  梃 */
	{ 0x5B6D, 0x6AAE, },	/* 59-77  9E8D  檮 */
	{ 0x5B6E, 0x68B9, },	/* 59-78  9E8E  梹 */
	{ 0x5B6F, 0x6874, },	/* 59-79  9E8F  桴 */
	{ 0x5B70, 0x68B5, },	/* 59-80  9E90  梵 */
	{ 0x5B71, 0x68A0, },	/* 59-81  9E91  梠 */
	{ 0x5B72, 0x68BA, },	/* 59-82  9E92  梺 */
	{ 0x5B73, 0x690F, },	/* 59-83  9E93  椏 */
	{ 0x5B74, 0x688D, },	/* 59-84  9E94  梍 */
	{ 0x5B75, 0x687E, },	/* 59-85  9E95  桾 */
	{ 0x5B76, 0x6901, },	/* 59-86  9E96  椁 */
	{ 0x5B77, 0x68CA, },	/* 59-87  9E97  棊 */
	{ 0x5B78, 0x6908, },	/* 59-88  9E98  椈 */
	{ 0x5B79, 0x68D8, },	/* 59-89  9E99  棘 */
	{ 0x5B7A, 0x6922, },	/* 59-90  9E9A  椢 */
	{ 0x5B7B, 0x6926, },	/* 59-91  9E9B  椦 */
	{ 0x5B7C, 0x68E1, },	/* 59-92  9E9C  棡 */
	{ 0x5B7D, 0x690C, },	/* 59-93  9E9D  椌 */
	{ 0x5B7E, 0x68CD, },	/* 59-94  9E9E  棍 */
	{ 0x5C21, 0x68D4, },	/* 60-01  9E9F  棔 */
	{ 0x5C22, 0x68E7, },	/* 60-02  9EA0  棧 */
	{ 0x5C23, 0x68D5, },	/* 60-03  9EA1  棕 */
	{ 0x5C24, 0x6936, },	/* 60-04  9EA2  椶 */
	{ 0x5C25, 0x6912, },	/* 60-05  9EA3  椒 */
	{ 0x5C26, 0x6904, },	/* 60-06  9EA4  椄 */
	{ 0x5C27, 0x68D7, },	/* 60-07  9EA5  棗 */
	{ 0x5C28, 0x68E3, },	/* 60-08  9EA6  棣 */
	{ 0x5C29, 0x6925, },	/* 60-09  9EA7  椥 */
	{ 0x5C2A, 0x68F9, },	/* 60-10  9EA8  棹 */
	{ 0x5C2B, 0x68E0, },	/* 60-11  9EA9  棠 */
	{ 0x5C2C, 0x68EF, },	/* 60-12  9EAA  棯 */
	{ 0x5C2D, 0x6928, },	/* 60-13  9EAB  椨 */
	{ 0x5C2E, 0x692A, },	/* 60-14  9EAC  椪 */
	{ 0x5C2F, 0x691A, },	/* 60-15  9EAD  椚 */
	{ 0x5C30, 0x6923, },	/* 60-16  9EAE  椣 */
	{ 0x5C31, 0x6921, },	/* 60-17  9EAF  椡 */
	{ 0x5C32, 0x68C6, },	/* 60-18  9EB0  棆 */
	{ 0x5C33, 0x6979, },	/* 60-19  9EB1  楹 */
	{ 0x5C34, 0x6977, },	/* 60-20  9EB2  楷 */
	{ 0x5C35, 0x695C, },	/* 60-21  9EB3  楜 */
	{ 0x5C36, 0x6978, },	/* 60-22  9EB4  楸 */
	{ 0x5C37, 0x696B, },	/* 60-23  9EB5  楫 */
	{ 0x5C38, 0x6954, },	/* 60-24  9EB6  楔 */
	{ 0x5C39, 0x697E, },	/* 60-25  9EB7  楾 */
	{ 0x5C3A, 0x696E, },	/* 60-26  9EB8  楮 */
	{ 0x5C3B, 0x6939, },	/* 60-27  9EB9  椹 */
	{ 0x5C3C, 0x6974, },	/* 60-28  9EBA  楴 */
	{ 0x5C3D, 0x693D, },	/* 60-29  9EBB  椽 */
	{ 0x5C3E, 0x6959, },	/* 60-30  9EBC  楙 */
	{ 0x5C3F, 0x6930, },	/* 60-31  9EBD  椰 */
	{ 0x5C40, 0x6961, },	/* 60-32  9EBE  楡 */
	{ 0x5C41, 0x695E, },	/* 60-33  9EBF  楞 */
	{ 0x5C42, 0x695D, },	/* 60-34  9EC0  楝 */
	{ 0x5C43, 0x6981, },	/* 60-35  9EC1  榁 */
	{ 0x5C44, 0x696A, },	/* 60-36  9EC2  楪 */
	{ 0x5C45, 0x69B2, },	/* 60-37  9EC3  榲 */
	{ 0x5C46, 0x69AE, },	/* 60-38  9EC4  榮 */
	{ 0x5C47, 0x69D0, },	/* 60-39  9EC5  槐 */
	{ 0x5C48, 0x69BF, },	/* 60-40  9EC6  榿 */
	{ 0x5C49, 0x69C1, },	/* 60-41  9EC7  槁 */
	{ 0x5C4A, 0x69D3, },	/* 60-42  9EC8  槓 */
	{ 0x5C4B, 0x69BE, },	/* 60-43  9EC9  榾 */
	{ 0x5C4C, 0x69CE, },	/* 60-44  9ECA  槎 */
	{ 0x5C4D, 0x5BE8, },	/* 60-45  9ECB  寨 */
	{ 0x5C4E, 0x69CA, },	/* 60-46  9ECC  槊 */
	{ 0x5C4F, 0x69DD, },	/* 60-47  9ECD  槝 */
	{ 0x5C50, 0x69BB, },	/* 60-48  9ECE  榻 */
	{ 0x5C51, 0x69C3, },	/* 60-49  9ECF  槃 */
	{ 0x5C52, 0x69A7, },	/* 60-50  9ED0  榧 */
	{ 0x5C53, 0x6A2E, },	/* 60-51  9ED1  樮 */
	{ 0x5C54, 0x6991, },	/* 60-52  9ED2  榑 */
	{ 0x5C55, 0x69A0, },	/* 60-53  9ED3  榠 */
	{ 0x5C56, 0x699C, },	/* 60-54  9ED4  榜 */
	{ 0x5C57, 0x6995, },	/* 60-55  9ED5  榕 */
	{ 0x5C58, 0x69B4, },	/* 60-56  9ED6  榴 */
	{ 0x5C59, 0x69DE, },	/* 60-57  9ED7  槞 */
	{ 0x5C5A, 0x69E8, },	/* 60-58  9ED8  槨 */
	{ 0x5C5B, 0x6A02, },	/* 60-59  9ED9  樂 */
	{ 0x5C5C, 0x6A1B, },	/* 60-60  9EDA  樛 */
	{ 0x5C5D, 0x69FF, },	/* 60-61  9EDB  槿 */
	{ 0x5C5E, 0x6B0A, },	/* 60-62  9EDC  權 */
	{ 0x5C5F, 0x69F9, },	/* 60-63  9EDD  槹 */
	{ 0x5C60, 0x69F2, },	/* 60-64  9EDE  槲 */
	{ 0x5C61, 0x69E7, },	/* 60-65  9EDF  槧 */
	{ 0x5C62, 0x6A05, },	/* 60-66  9EE0  樅 */
	{ 0x5C63, 0x69B1, },	/* 60-67  9EE1  榱 */
	{ 0x5C64, 0x6A1E, },	/* 60-68  9EE2  樞 */
	{ 0x5C65, 0x69ED, },	/* 60-69  9EE3  槭 */
	{ 0x5C66, 0x6A14, },	/* 60-70  9EE4  樔 */
	{ 0x5C67, 0x69EB, },	/* 60-71  9EE5  槫 */
	{ 0x5C68, 0x6A0A, },	/* 60-72  9EE6  樊 */
	{ 0x5C69, 0x6A12, },	/* 60-73  9EE7  樒 */
	{ 0x5C6A, 0x6AC1, },	/* 60-74  9EE8  櫁 */
	{ 0x5C6B, 0x6A23, },	/* 60-75  9EE9  樣 */
	{ 0x5C6C, 0x6A13, },	/* 60-76  9EEA  樓 */
	{ 0x5C6D, 0x6A44, },	/* 60-77  9EEB  橄 */
	{ 0x5C6E, 0x6A0C, },	/* 60-78  9EEC  樌 */
	{ 0x5C6F, 0x6A72, },	/* 60-79  9EED  橲 */
	{ 0x5C70, 0x6A36, },	/* 60-80  9EEE  樶 */
	{ 0x5C71, 0x6A78, },	/* 60-81  9EEF  橸 */
	{ 0x5C72, 0x6A47, },	/* 60-82  9EF0  橇 */
	{ 0x5C73, 0x6A62, },	/* 60-83  9EF1  橢 */
	{ 0x5C74, 0x6A59, },	/* 60-84  9EF2  橙 */
	{ 0x5C75, 0x6A66, },	/* 60-85  9EF3  橦 */
	{ 0x5C76, 0x6A48, },	/* 60-86  9EF4  橈 */
	{ 0x5C77, 0x6A38, },	/* 60-87  9EF5  樸 */
	{ 0x5C78, 0x6A22, },	/* 60-88  9EF6  樢 */
	{ 0x5C79, 0x6A90, },	/* 60-89  9EF7  檐 */
	{ 0x5C7A, 0x6A8D, },	/* 60-90  9EF8  檍 */
	{ 0x5C7B, 0x6AA0, },	/* 60-91  9EF9  檠 */
	{ 0x5C7C, 0x6A84, },	/* 60-92  9EFA  檄 */
	{ 0x5C7D, 0x6AA2, },	/* 60-93  9EFB  檢 */
	{ 0x5C7E, 0x6AA3, },	/* 60-94  9EFC  檣 */
	{ 0x5D21, 0x6A97, },	/* 61-01  9F40  檗 */
	{ 0x5D22, 0x8617, },	/* 61-02  9F41  蘗 */
	{ 0x5D23, 0x6ABB, },	/* 61-03  9F42  檻 */
	{ 0x5D24, 0x6AC3, },	/* 61-04  9F43  櫃 */
	{ 0x5D25, 0x6AC2, },	/* 61-05  9F44  櫂 */
	{ 0x5D26, 0x6AB8, },	/* 61-06  9F45  檸 */
	{ 0x5D27, 0x6AB3, },	/* 61-07  9F46  檳 */
	{ 0x5D28, 0x6AAC, },	/* 61-08  9F47  檬 */
	{ 0x5D29, 0x6ADE, },	/* 61-09  9F48  櫞 */
	{ 0x5D2A, 0x6AD1, },	/* 61-10  9F49  櫑 */
	{ 0x5D2B, 0x6ADF, },	/* 61-11  9F4A  櫟 */
	{ 0x5D2C, 0x6AAA, },	/* 61-12  9F4B  檪 */
	{ 0x5D2D, 0x6ADA, },	/* 61-13  9F4C  櫚 */
	{ 0x5D2E, 0x6AEA, },	/* 61-14  9F4D  櫪 */
	{ 0x5D2F, 0x6AFB, },	/* 61-15  9F4E  櫻 */
	{ 0x5D30, 0x6B05, },	/* 61-16  9F4F  欅 */
	{ 0x5D31, 0x8616, },	/* 61-17  9F50  蘖 */
	{ 0x5D32, 0x6AFA, },	/* 61-18  9F51  櫺 */
	{ 0x5D33, 0x6B12, },	/* 61-19  9F52  欒 */
	{ 0x5D34, 0x6B16, },	/* 61-20  9F53  欖 */
	{ 0x5D35, 0x9B31, },	/* 61-21  9F54  鬱 */
	{ 0x5D36, 0x6B1F, },	/* 61-22  9F55  欟 */
	{ 0x5D37, 0x6B38, },	/* 61-23  9F56  欸 */
	{ 0x5D38, 0x6B37, },	/* 61-24  9F57  欷 */
	{ 0x5D39, 0x76DC, },	/* 61-25  9F58  盜 */
	{ 0x5D3A, 0x6B39, },	/* 61-26  9F59  欹 */
	{ 0x5D3B, 0x98EE, },	/* 61-27  9F5A  飮 */
	{ 0x5D3C, 0x6B47, },	/* 61-28  9F5B  歇 */
	{ 0x5D3D, 0x6B43, },	/* 61-29  9F5C  歃 */
	{ 0x5D3E, 0x6B49, },	/* 61-30  9F5D  歉 */
	{ 0x5D3F, 0x6B50, },	/* 61-31  9F5E  歐 */
	{ 0x5D40, 0x6B59, },	/* 61-32  9F5F  歙 */
	{ 0x5D41, 0x6B54, },	/* 61-33  9F60  歔 */
	{ 0x5D42, 0x6B5B, },	/* 61-34  9F61  歛 */
	{ 0x5D43, 0x6B5F, },	/* 61-35  9F62  歟 */
	{ 0x5D44, 0x6B61, },	/* 61-36  9F63  歡 */
	{ 0x5D45, 0x6B78, },	/* 61-37  9F64  歸 */
	{ 0x5D46, 0x6B79, },	/* 61-38  9F65  歹 */
	{ 0x5D47, 0x6B7F, },	/* 61-39  9F66  歿 */
	{ 0x5D48, 0x6B80, },	/* 61-40  9F67  殀 */
	{ 0x5D49, 0x6B84, },	/* 61-41  9F68  殄 */
	{ 0x5D4A, 0x6B83, },	/* 61-42  9F69  殃 */
	{ 0x5D4B, 0x6B8D, },	/* 61-43  9F6A  殍 */
	{ 0x5D4C, 0x6B98, },	/* 61-44  9F6B  殘 */
	{ 0x5D4D, 0x6B95, },	/* 61-45  9F6C  殕 */
	{ 0x5D4E, 0x6B9E, },	/* 61-46  9F6D  殞 */
	{ 0x5D4F, 0x6BA4, },	/* 61-47  9F6E  殤 */
	{ 0x5D50, 0x6BAA, },	/* 61-48  9F6F  殪 */
	{ 0x5D51, 0x6BAB, },	/* 61-49  9F70  殫 */
	{ 0x5D52, 0x6BAF, },	/* 61-50  9F71  殯 */
	{ 0x5D53, 0x6BB2, },	/* 61-51  9F72  殲 */
	{ 0x5D54, 0x6BB1, },	/* 61-52  9F73  殱 */
	{ 0x5D55, 0x6BB3, },	/* 61-53  9F74  殳 */
	{ 0x5D56, 0x6BB7, },	/* 61-54  9F75  殷 */
	{ 0x5D57, 0x6BBC, },	/* 61-55  9F76  殼 */
	{ 0x5D58, 0x6BC6, },	/* 61-56  9F77  毆 */
	{ 0x5D59, 0x6BCB, },	/* 61-57  9F78  毋 */
	{ 0x5D5A, 0x6BD3, },	/* 61-58  9F79  毓 */
	{ 0x5D5B, 0x6BDF, },	/* 61-59  9F7A  毟 */
	{ 0x5D5C, 0x6BEC, },	/* 61-60  9F7B  毬 */
	{ 0x5D5D, 0x6BEB, },	/* 61-61  9F7C  毫 */
	{ 0x5D5E, 0x6BF3, },	/* 61-62  9F7D  毳 */
	{ 0x5D5F, 0x6BEF, },	/* 61-63  9F7E  毯 */
	{ 0x5D60, 0x9EBE, },	/* 61-64  9F80  麾 */
	{ 0x5D61, 0x6C08, },	/* 61-65  9F81  氈 */
	{ 0x5D62, 0x6C13, },	/* 61-66  9F82  氓 */
	{ 0x5D63, 0x6C14, },	/* 61-67  9F83  气 */
	{ 0x5D64, 0x6C1B, },	/* 61-68  9F84  氛 */
	{ 0x5D65, 0x6C24, },	/* 61-69  9F85  氤 */
	{ 0x5D66, 0x6C23, },	/* 61-70  9F86  氣 */
	{ 0x5D67, 0x6C5E, },	/* 61-71  9F87  汞 */
	{ 0x5D68, 0x6C55, },	/* 61-72  9F88  汕 */
	{ 0x5D69, 0x6C62, },	/* 61-73  9F89  汢 */
	{ 0x5D6A, 0x6C6A, },	/* 61-74  9F8A  汪 */
	{ 0x5D6B, 0x6C82, },	/* 61-75  9F8B  沂 */
	{ 0x5D6C, 0x6C8D, },	/* 61-76  9F8C  沍 */
	{ 0x5D6D, 0x6C9A, },	/* 61-77  9F8D  沚 */
	{ 0x5D6E, 0x6C81, },	/* 61-78  9F8E  沁 */
	{ 0x5D6F, 0x6C9B, },	/* 61-79  9F8F  沛 */
	{ 0x5D70, 0x6C7E, },	/* 61-80  9F90  汾 */
	{ 0x5D71, 0x6C68, },	/* 61-81  9F91  汨 */
	{ 0x5D72, 0x6C73, },	/* 61-82  9F92  汳 */
	{ 0x5D73, 0x6C92, },	/* 61-83  9F93  沒 */
	{ 0x5D74, 0x6C90, },	/* 61-84  9F94  沐 */
	{ 0x5D75, 0x6CC4, },	/* 61-85  9F95  泄 */
	{ 0x5D76, 0x6CF1, },	/* 61-86  9F96  泱 */
	{ 0x5D77, 0x6CD3, },	/* 61-87  9F97  泓 */
	{ 0x5D78, 0x6CBD, },	/* 61-88  9F98  沽 */
	{ 0x5D79, 0x6CD7, },	/* 61-89  9F99  泗 */
	{ 0x5D7A, 0x6CC5, },	/* 61-90  9F9A  泅 */
	{ 0x5D7B, 0x6CDD, },	/* 61-91  9F9B  泝 */
	{ 0x5D7C, 0x6CAE, },	/* 61-92  9F9C  沮 */
	{ 0x5D7D, 0x6CB1, },	/* 61-93  9F9D  沱 */
	{ 0x5D7E, 0x6CBE, },	/* 61-94  9F9E  沾 */
	{ 0x5E21, 0x6CBA, },	/* 62-01  9F9F  沺 */
	{ 0x5E22, 0x6CDB, },	/* 62-02  9FA0  泛 */
	{ 0x5E23, 0x6CEF, },	/* 62-03  9FA1  泯 */
	{ 0x5E24, 0x6CD9, },	/* 62-04  9FA2  泙 */
	{ 0x5E25, 0x6CEA, },	/* 62-05  9FA3  泪 */
	{ 0x5E26, 0x6D1F, },	/* 62-06  9FA4  洟 */
	{ 0x5E27, 0x884D, },	/* 62-07  9FA5  衍 */
	{ 0x5E28, 0x6D36, },	/* 62-08  9FA6  洶 */
	{ 0x5E29, 0x6D2B, },	/* 62-09  9FA7  洫 */
	{ 0x5E2A, 0x6D3D, },	/* 62-10  9FA8  洽 */
	{ 0x5E2B, 0x6D38, },	/* 62-11  9FA9  洸 */
	{ 0x5E2C, 0x6D19, },	/* 62-12  9FAA  洙 */
	{ 0x5E2D, 0x6D35, },	/* 62-13  9FAB  洵 */
	{ 0x5E2E, 0x6D33, },	/* 62-14  9FAC  洳 */
	{ 0x5E2F, 0x6D12, },	/* 62-15  9FAD  洒 */
	{ 0x5E30, 0x6D0C, },	/* 62-16  9FAE  洌 */
	{ 0x5E31, 0x6D63, },	/* 62-17  9FAF  浣 */
	{ 0x5E32, 0x6D93, },	/* 62-18  9FB0  涓 */
	{ 0x5E33, 0x6D64, },	/* 62-19  9FB1  浤 */
	{ 0x5E34, 0x6D5A, },	/* 62-20  9FB2  浚 */
	{ 0x5E35, 0x6D79, },	/* 62-21  9FB3  浹 */
	{ 0x5E36, 0x6D59, },	/* 62-22  9FB4  浙 */
	{ 0x5E37, 0x6D8E, },	/* 62-23  9FB5  涎 */
	{ 0x5E38, 0x6D95, },	/* 62-24  9FB6  涕 */
	{ 0x5E39, 0x6FE4, },	/* 62-25  9FB7  濤 */
	{ 0x5E3A, 0x6D85, },	/* 62-26  9FB8  涅 */
	{ 0x5E3B, 0x6DF9, },	/* 62-27  9FB9  淹 */
	{ 0x5E3C, 0x6E15, },	/* 62-28  9FBA  渕 */
	{ 0x5E3D, 0x6E0A, },	/* 62-29  9FBB  渊 */
	{ 0x5E3E, 0x6DB5, },	/* 62-30  9FBC  涵 */
	{ 0x5E3F, 0x6DC7, },	/* 62-31  9FBD  淇 */
	{ 0x5E40, 0x6DE6, },	/* 62-32  9FBE  淦 */
	{ 0x5E41, 0x6DB8, },	/* 62-33  9FBF  涸 */
	{ 0x5E42, 0x6DC6, },	/* 62-34  9FC0  淆 */
	{ 0x5E43, 0x6DEC, },	/* 62-35  9FC1  淬 */
	{ 0x5E44, 0x6DDE, },	/* 62-36  9FC2  淞 */
	{ 0x5E45, 0x6DCC, },	/* 62-37  9FC3  淌 */
	{ 0x5E46, 0x6DE8, },	/* 62-38  9FC4  淨 */
	{ 0x5E47, 0x6DD2, },	/* 62-39  9FC5  淒 */
	{ 0x5E48, 0x6DC5, },	/* 62-40  9FC6  淅 */
	{ 0x5E49, 0x6DFA, },	/* 62-41  9FC7  淺 */
	{ 0x5E4A, 0x6DD9, },	/* 62-42  9FC8  淙 */
	{ 0x5E4B, 0x6DE4, },	/* 62-43  9FC9  淤 */
	{ 0x5E4C, 0x6DD5, },	/* 62-44  9FCA  淕 */
	{ 0x5E4D, 0x6DEA, },	/* 62-45  9FCB  淪 */
	{ 0x5E4E, 0x6DEE, },	/* 62-46  9FCC  淮 */
	{ 0x5E4F, 0x6E2D, },	/* 62-47  9FCD  渭 */
	{ 0x5E50, 0x6E6E, },	/* 62-48  9FCE  湮 */
	{ 0x5E51, 0x6E2E, },	/* 62-49  9FCF  渮 */
	{ 0x5E52, 0x6E19, },	/* 62-50  9FD0  渙 */
	{ 0x5E53, 0x6E72, },	/* 62-51  9FD1  湲 */
	{ 0x5E54, 0x6E5F, },	/* 62-52  9FD2  湟 */
	{ 0x5E55, 0x6E3E, },	/* 62-53  9FD3  渾 */
	{ 0x5E56, 0x6E23, },	/* 62-54  9FD4  渣 */
	{ 0x5E57, 0x6E6B, },	/* 62-55  9FD5  湫 */
	{ 0x5E58, 0x6E2B, },	/* 62-56  9FD6  渫 */
	{ 0x5E59, 0x6E76, },	/* 62-57  9FD7  湶 */
	{ 0x5E5A, 0x6E4D, },	/* 62-58  9FD8  湍 */
	{ 0x5E5B, 0x6E1F, },	/* 62-59  9FD9  渟 */
	{ 0x5E5C, 0x6E43, },	/* 62-60  9FDA  湃 */
	{ 0x5E5D, 0x6E3A, },	/* 62-61  9FDB  渺 */
	{ 0x5E5E, 0x6E4E, },	/* 62-62  9FDC  湎 */
	{ 0x5E5F, 0x6E24, },	/* 62-63  9FDD  渤 */
	{ 0x5E60, 0x6EFF, },	/* 62-64  9FDE  滿 */
	{ 0x5E61, 0x6E1D, },	/* 62-65  9FDF  渝 */
	{ 0x5E62, 0x6E38, },	/* 62-66  9FE0  游 */
	{ 0x5E63, 0x6E82, },	/* 62-67  9FE1  溂 */
	{ 0x5E64, 0x6EAA, },	/* 62-68  9FE2  溪 */
	{ 0x5E65, 0x6E98, },	/* 62-69  9FE3  溘 */
	{ 0x5E66, 0x6EC9, },	/* 62-70  9FE4  滉 */
	{ 0x5E67, 0x6EB7, },	/* 62-71  9FE5  溷 */
	{ 0x5E68, 0x6ED3, },	/* 62-72  9FE6  滓 */
	{ 0x5E69, 0x6EBD, },	/* 62-73  9FE7  溽 */
	{ 0x5E6A, 0x6EAF, },	/* 62-74  9FE8  溯 */
	{ 0x5E6B, 0x6EC4, },	/* 62-75  9FE9  滄 */
	{ 0x5E6C, 0x6EB2, },	/* 62-76  9FEA  溲 */
	{ 0x5E6D, 0x6ED4, },	/* 62-77  9FEB  滔 */
	{ 0x5E6E, 0x6ED5, },	/* 62-78  9FEC  滕 */
	{ 0x5E6F, 0x6E8F, },	/* 62-79  9FED  溏 */
	{ 0x5E70, 0x6EA5, },	/* 62-80  9FEE  溥 */
	{ 0x5E71, 0x6EC2, },	/* 62-81  9FEF  滂 */
	{ 0x5E72, 0x6E9F, },	/* 62-82  9FF0  溟 */
	{ 0x5E73, 0x6F41, },	/* 62-83  9FF1  潁 */
	{ 0x5E74, 0x6F11, },	/* 62-84  9FF2  漑 */
	{ 0x5E75, 0x704C, },	/* 62-85  9FF3  灌 */
	{ 0x5E76, 0x6EEC, },	/* 62-86  9FF4  滬 */
	{ 0x5E77, 0x6EF8, },	/* 62-87  9FF5  滸 */
	{ 0x5E78, 0x6EFE, },	/* 62-88  9FF6  滾 */
	{ 0x5E79, 0x6F3F, },	/* 62-89  9FF7  漿 */
	{ 0x5E7A, 0x6EF2, },	/* 62-90  9FF8  滲 */
	{ 0x5E7B, 0x6F31, },	/* 62-91  9FF9  漱 */
	{ 0x5E7C, 0x6EEF, },	/* 62-92  9FFA  滯 */
	{ 0x5E7D, 0x6F32, },	/* 62-93  9FFB  漲 */
	{ 0x5E7E, 0x6ECC, },	/* 62-94  9FFC  滌 */
	{ 0x5F21, 0x6F3E, },	/* 63-01  E040  漾 */
	{ 0x5F22, 0x6F13, },	/* 63-02  E041  漓 */
	{ 0x5F23, 0x6EF7, },	/* 63-03  E042  滷 */
	{ 0x5F24, 0x6F86, },	/* 63-04  E043  澆 */
	{ 0x5F25, 0x6F7A, },	/* 63-05  E044  潺 */
	{ 0x5F26, 0x6F78, },	/* 63-06  E045  潸 */
	{ 0x5F27, 0x6F81, },	/* 63-07  E046  澁 */
	{ 0x5F28, 0x6F80, },	/* 63-08  E047  澀 */
	{ 0x5F29, 0x6F6F, },	/* 63-09  E048  潯 */
	{ 0x5F2A, 0x6F5B, },	/* 63-10  E049  潛 */
	{ 0x5F2B, 0x6FF3, },	/* 63-11  E04A  濳 */
	{ 0x5F2C, 0x6F6D, },	/* 63-12  E04B  潭 */
	{ 0x5F2D, 0x6F82, },	/* 63-13  E04C  澂 */
	{ 0x5F2E, 0x6F7C, },	/* 63-14  E04D  潼 */
	{ 0x5F2F, 0x6F58, },	/* 63-15  E04E  潘 */
	{ 0x5F30, 0x6F8E, },	/* 63-16  E04F  澎 */
	{ 0x5F31, 0x6F91, },	/* 63-17  E050  澑 */
	{ 0x5F32, 0x6FC2, },	/* 63-18  E051  濂 */
	{ 0x5F33, 0x6F66, },	/* 63-19  E052  潦 */
	{ 0x5F34, 0x6FB3, },	/* 63-20  E053  澳 */
	{ 0x5F35, 0x6FA3, },	/* 63-21  E054  澣 */
	{ 0x5F36, 0x6FA1, },	/* 63-22  E055  澡 */
	{ 0x5F37, 0x6FA4, },	/* 63-23  E056  澤 */
	{ 0x5F38, 0x6FB9, },	/* 63-24  E057  澹 */
	{ 0x5F39, 0x6FC6, },	/* 63-25  E058  濆 */
	{ 0x5F3A, 0x6FAA, },	/* 63-26  E059  澪 */
	{ 0x5F3B, 0x6FDF, },	/* 63-27  E05A  濟 */
	{ 0x5F3C, 0x6FD5, },	/* 63-28  E05B  濕 */
	{ 0x5F3D, 0x6FEC, },	/* 63-29  E05C  濬 */
	{ 0x5F3E, 0x6FD4, },	/* 63-30  E05D  濔 */
	{ 0x5F3F, 0x6FD8, },	/* 63-31  E05E  濘 */
	{ 0x5F40, 0x6FF1, },	/* 63-32  E05F  濱 */
	{ 0x5F41, 0x6FEE, },	/* 63-33  E060  濮 */
	{ 0x5F42, 0x6FDB, },	/* 63-34  E061  濛 */
	{ 0x5F43, 0x7009, },	/* 63-35  E062  瀉 */
	{ 0x5F44, 0x700B, },	/* 63-36  E063  瀋 */
	{ 0x5F45, 0x6FFA, },	/* 63-37  E064  濺 */
	{ 0x5F46, 0x7011, },	/* 63-38  E065  瀑 */
	{ 0x5F47, 0x7001, },	/* 63-39  E066  瀁 */
	{ 0x5F48, 0x700F, },	/* 63-40  E067  瀏 */
	{ 0x5F49, 0x6FFE, },	/* 63-41  E068  濾 */
	{ 0x5F4A, 0x701B, },	/* 63-42  E069  瀛 */
	{ 0x5F4B, 0x701A, },	/* 63-43  E06A  瀚 */
	{ 0x5F4C, 0x6F74, },	/* 63-44  E06B  潴 */
	{ 0x5F4D, 0x701D, },	/* 63-45  E06C  瀝 */
	{ 0x5F4E, 0x7018, },	/* 63-46  E06D  瀘 */
	{ 0x5F4F, 0x701F, },	/* 63-47  E06E  瀟 */
	{ 0x5F50, 0x7030, },	/* 63-48  E06F  瀰 */
	{ 0x5F51, 0x703E, },	/* 63-49  E070  瀾 */
	{ 0x5F52, 0x7032, },	/* 63-50  E071  瀲 */
	{ 0x5F53, 0x7051, },	/* 63-51  E072  灑 */
	{ 0x5F54, 0x7063, },	/* 63-52  E073  灣 */
	{ 0x5F55, 0x7099, },	/* 63-53  E074  炙 */
	{ 0x5F56, 0x7092, },	/* 63-54  E075  炒 */
	{ 0x5F57, 0x70AF, },	/* 63-55  E076  炯 */
	{ 0x5F58, 0x70F1, },	/* 63-56  E077  烱 */
	{ 0x5F59, 0x70AC, },	/* 63-57  E078  炬 */
	{ 0x5F5A, 0x70B8, },	/* 63-58  E079  炸 */
	{ 0x5F5B, 0x70B3, },	/* 63-59  E07A  炳 */
	{ 0x5F5C, 0x70AE, },	/* 63-60  E07B  炮 */
	{ 0x5F5D, 0x70DF, },	/* 63-61  E07C  烟 */
	{ 0x5F5E, 0x70CB, },	/* 63-62  E07D  烋 */
	{ 0x5F5F, 0x70DD, },	/* 63-63  E07E  烝 */
	{ 0x5F60, 0x70D9, },	/* 63-64  E080  烙 */
	{ 0x5F61, 0x7109, },	/* 63-65  E081  焉 */
	{ 0x5F62, 0x70FD, },	/* 63-66  E082  烽 */
	{ 0x5F63, 0x711C, },	/* 63-67  E083  焜 */
	{ 0x5F64, 0x7119, },	/* 63-68  E084  焙 */
	{ 0x5F65, 0x7165, },	/* 63-69  E085  煥 */
	{ 0x5F66, 0x7155, },	/* 63-70  E086  煕 */
	{ 0x5F67, 0x7188, },	/* 63-71  E087  熈 */
	{ 0x5F68, 0x7166, },	/* 63-72  E088  煦 */
	{ 0x5F69, 0x7162, },	/* 63-73  E089  煢 */
	{ 0x5F6A, 0x714C, },	/* 63-74  E08A  煌 */
	{ 0x5F6B, 0x7156, },	/* 63-75  E08B  煖 */
	{ 0x5F6C, 0x716C, },	/* 63-76  E08C  煬 */
	{ 0x5F6D, 0x718F, },	/* 63-77  E08D  熏 */
	{ 0x5F6E, 0x71FB, },	/* 63-78  E08E  燻 */
	{ 0x5F6F, 0x7184, },	/* 63-79  E08F  熄 */
	{ 0x5F70, 0x7195, },	/* 63-80  E090  熕 */
	{ 0x5F71, 0x71A8, },	/* 63-81  E091  熨 */
	{ 0x5F72, 0x71AC, },	/* 63-82  E092  熬 */
	{ 0x5F73, 0x71D7, },	/* 63-83  E093  燗 */
	{ 0x5F74, 0x71B9, },	/* 63-84  E094  熹 */
	{ 0x5F75, 0x71BE, },	/* 63-85  E095  熾 */
	{ 0x5F76, 0x71D2, },	/* 63-86  E096  燒 */
	{ 0x5F77, 0x71C9, },	/* 63-87  E097  燉 */
	{ 0x5F78, 0x71D4, },	/* 63-88  E098  燔 */
	{ 0x5F79, 0x71CE, },	/* 63-89  E099  燎 */
	{ 0x5F7A, 0x71E0, },	/* 63-90  E09A  燠 */
	{ 0x5F7B, 0x71EC, },	/* 63-91  E09B  燬 */
	{ 0x5F7C, 0x71E7, },	/* 63-92  E09C  燧 */
	{ 0x5F7D, 0x71F5, },	/* 63-93  E09D  燵 */
	{ 0x5F7E, 0x71FC, },	/* 63-94  E09E  燼 */
	{ 0x6021, 0x71F9, },	/* 64-01  E09F  燹 */
	{ 0x6022, 0x71FF, },	/* 64-02  E0A0  燿 */
	{ 0x6023, 0x720D, },	/* 64-03  E0A1  爍 */
	{ 0x6024, 0x7210, },	/* 64-04  E0A2  爐 */
	{ 0x6025, 0x721B, },	/* 64-05  E0A3  爛 */
	{ 0x6026, 0x7228, },	/* 64-06  E0A4  爨 */
	{ 0x6027, 0x722D, },	/* 64-07  E0A5  爭 */
	{ 0x6028, 0x722C, },	/* 64-08  E0A6  爬 */
	{ 0x6029, 0x7230, },	/* 64-09  E0A7  爰 */
	{ 0x602A, 0x7232, },	/* 64-10  E0A8  爲 */
	{ 0x602B, 0x723B, },	/* 64-11  E0A9  爻 */
	{ 0x602C, 0x723C, },	/* 64-12  E0AA  爼 */
	{ 0x602D, 0x723F, },	/* 64-13  E0AB  爿 */
	{ 0x602E, 0x7240, },	/* 64-14  E0AC  牀 */
	{ 0x602F, 0x7246, },	/* 64-15  E0AD  牆 */
	{ 0x6030, 0x724B, },	/* 64-16  E0AE  牋 */
	{ 0x6031, 0x7258, },	/* 64-17  E0AF  牘 */
	{ 0x6032, 0x7274, },	/* 64-18  E0B0  牴 */
	{ 0x6033, 0x727E, },	/* 64-19  E0B1  牾 */
	{ 0x6034, 0x7282, },	/* 64-20  E0B2  犂 */
	{ 0x6035, 0x7281, },	/* 64-21  E0B3  犁 */
	{ 0x6036, 0x7287, },	/* 64-22  E0B4  犇 */
	{ 0x6037, 0x7292, },	/* 64-23  E0B5  犒 */
	{ 0x6038, 0x7296, },	/* 64-24  E0B6  犖 */
	{ 0x6039, 0x72A2, },	/* 64-25  E0B7  犢 */
	{ 0x603A, 0x72A7, },	/* 64-26  E0B8  犧 */
	{ 0x603B, 0x72B9, },	/* 64-27  E0B9  犹 */
	{ 0x603C, 0x72B2, },	/* 64-28  E0BA  犲 */
	{ 0x603D, 0x72C3, },	/* 64-29  E0BB  狃 */
	{ 0x603E, 0x72C6, },	/* 64-30  E0BC  狆 */
	{ 0x603F, 0x72C4, },	/* 64-31  E0BD  狄 */
	{ 0x6040, 0x72CE, },	/* 64-32  E0BE  狎 */
	{ 0x6041, 0x72D2, },	/* 64-33  E0BF  狒 */
	{ 0x6042, 0x72E2, },	/* 64-34  E0C0  狢 */
	{ 0x6043, 0x72E0, },	/* 64-35  E0C1  狠 */
	{ 0x6044, 0x72E1, },	/* 64-36  E0C2  狡 */
	{ 0x6045, 0x72F9, },	/* 64-37  E0C3  狹 */
	{ 0x6046, 0x72F7, },	/* 64-38  E0C4  狷 */
	{ 0x6047, 0x500F, },	/* 64-39  E0C5  倏 */
	{ 0x6048, 0x7317, },	/* 64-40  E0C6  猗 */
	{ 0x6049, 0x730A, },	/* 64-41  E0C7  猊 */
	{ 0x604A, 0x731C, },	/* 64-42  E0C8  猜 */
	{ 0x604B, 0x7316, },	/* 64-43  E0C9  猖 */
	{ 0x604C, 0x731D, },	/* 64-44  E0CA  猝 */
	{ 0x604D, 0x7334, },	/* 64-45  E0CB  猴 */
	{ 0x604E, 0x732F, },	/* 64-46  E0CC  猯 */
	{ 0x604F, 0x7329, },	/* 64-47  E0CD  猩 */
	{ 0x6050, 0x7325, },	/* 64-48  E0CE  猥 */
	{ 0x6051, 0x733E, },	/* 64-49  E0CF  猾 */
	{ 0x6052, 0x734E, },	/* 64-50  E0D0  獎 */
	{ 0x6053, 0x734F, },	/* 64-51  E0D1  獏 */
	{ 0x6054, 0x9ED8, },	/* 64-52  E0D2  默 */
	{ 0x6055, 0x7357, },	/* 64-53  E0D3  獗 */
	{ 0x6056, 0x736A, },	/* 64-54  E0D4  獪 */
	{ 0x6057, 0x7368, },	/* 64-55  E0D5  獨 */
	{ 0x6058, 0x7370, },	/* 64-56  E0D6  獰 */
	{ 0x6059, 0x7378, },	/* 64-57  E0D7  獸 */
	{ 0x605A, 0x7375, },	/* 64-58  E0D8  獵 */
	{ 0x605B, 0x737B, },	/* 64-59  E0D9  獻 */
	{ 0x605C, 0x737A, },	/* 64-60  E0DA  獺 */
	{ 0x605D, 0x73C8, },	/* 64-61  E0DB  珈 */
	{ 0x605E, 0x73B3, },	/* 64-62  E0DC  玳 */
	{ 0x605F, 0x73CE, },	/* 64-63  E0DD  珎 */
	{ 0x6060, 0x73BB, },	/* 64-64  E0DE  玻 */
	{ 0x6061, 0x73C0, },	/* 64-65  E0DF  珀 */
	{ 0x6062, 0x73E5, },	/* 64-66  E0E0  珥 */
	{ 0x6063, 0x73EE, },	/* 64-67  E0E1  珮 */
	{ 0x6064, 0x73DE, },	/* 64-68  E0E2  珞 */
	{ 0x6065, 0x74A2, },	/* 64-69  E0E3  璢 */
	{ 0x6066, 0x7405, },	/* 64-70  E0E4  琅 */
	{ 0x6067, 0x746F, },	/* 64-71  E0E5  瑯 */
	{ 0x6068, 0x7425, },	/* 64-72  E0E6  琥 */
	{ 0x6069, 0x73F8, },	/* 64-73  E0E7  珸 */
	{ 0x606A, 0x7432, },	/* 64-74  E0E8  琲 */
	{ 0x606B, 0x743A, },	/* 64-75  E0E9  琺 */
	{ 0x606C, 0x7455, },	/* 64-76  E0EA  瑕 */
	{ 0x606D, 0x743F, },	/* 64-77  E0EB  琿 */
	{ 0x606E, 0x745F, },	/* 64-78  E0EC  瑟 */
	{ 0x606F, 0x7459, },	/* 64-79  E0ED  瑙 */
	{ 0x6070, 0x7441, },	/* 64-80  E0EE  瑁 */
	{ 0x6071, 0x745C, },	/* 64-81  E0EF  瑜 */
	{ 0x6072, 0x7469, },	/* 64-82  E0F0  瑩 */
	{ 0x6073, 0x7470, },	/* 64-83  E0F1  瑰 */
	{ 0x6074, 0x7463, },	/* 64-84  E0F2  瑣 */
	{ 0x6075, 0x746A, },	/* 64-85  E0F3  瑪 */
	{ 0x6076, 0x7476, },	/* 64-86  E0F4  瑶 */
	{ 0x6077, 0x747E, },	/* 64-87  E0F5  瑾 */
	{ 0x6078, 0x748B, },	/* 64-88  E0F6  璋 */
	{ 0x6079, 0x749E, },	/* 64-89  E0F7  璞 */
	{ 0x607A, 0x74A7, },	/* 64-90  E0F8  璧 */
	{ 0x607B, 0x74CA, },	/* 64-91  E0F9  瓊 */
	{ 0x607C, 0x74CF, },	/* 64-92  E0FA  瓏 */
	{ 0x607D, 0x74D4, },	/* 64-93  E0FB  瓔 */
	{ 0x607E, 0x73F1, },	/* 64-94  E0FC  珱 */
	{ 0x6121, 0x74E0, },	/* 65-01  E140  瓠 */
	{ 0x6122, 0x74E3, },	/* 65-02  E141  瓣 */
	{ 0x6123, 0x74E7, },	/* 65-03  E142  瓧 */
	{ 0x6124, 0x74E9, },	/* 65-04  E143  瓩 */
	{ 0x6125, 0x74EE, },	/* 65-05  E144  瓮 */
	{ 0x6126, 0x74F2, },	/* 65-06  E145  瓲 */
	{ 0x6127, 0x74F0, },	/* 65-07  E146  瓰 */
	{ 0x6128, 0x74F1, },	/* 65-08  E147  瓱 */
	{ 0x6129, 0x74F8, },	/* 65-09  E148  瓸 */
	{ 0x612A, 0x74F7, },	/* 65-10  E149  瓷 */
	{ 0x612B, 0x7504, },	/* 65-11  E14A  甄 */
	{ 0x612C, 0x7503, },	/* 65-12  E14B  甃 */
	{ 0x612D, 0x7505, },	/* 65-13  E14C  甅 */
	{ 0x612E, 0x750C, },	/* 65-14  E14D  甌 */
	{ 0x612F, 0x750E, },	/* 65-15  E14E  甎 */
	{ 0x6130, 0x750D, },	/* 65-16  E14F  甍 */
	{ 0x6131, 0x7515, },	/* 65-17  E150  甕 */
	{ 0x6132, 0x7513, },	/* 65-18  E151  甓 */
	{ 0x6133, 0x751E, },	/* 65-19  E152  甞 */
	{ 0x6134, 0x7526, },	/* 65-20  E153  甦 */
	{ 0x6135, 0x752C, },	/* 65-21  E154  甬 */
	{ 0x6136, 0x753C, },	/* 65-22  E155  甼 */
	{ 0x6137, 0x7544, },	/* 65-23  E156  畄 */
	{ 0x6138, 0x754D, },	/* 65-24  E157  畍 */
	{ 0x6139, 0x754A, },	/* 65-25  E158  畊 */
	{ 0x613A, 0x7549, },	/* 65-26  E159  畉 */
	{ 0x613B, 0x755B, },	/* 65-27  E15A  畛 */
	{ 0x613C, 0x7546, },	/* 65-28  E15B  畆 */
	{ 0x613D, 0x755A, },	/* 65-29  E15C  畚 */
	{ 0x613E, 0x7569, },	/* 65-30  E15D  畩 */
	{ 0x613F, 0x7564, },	/* 65-31  E15E  畤 */
	{ 0x6140, 0x7567, },	/* 65-32  E15F  畧 */
	{ 0x6141, 0x756B, },	/* 65-33  E160  畫 */
	{ 0x6142, 0x756D, },	/* 65-34  E161  畭 */
	{ 0x6143, 0x7578, },	/* 65-35  E162  畸 */
	{ 0x6144, 0x7576, },	/* 65-36  E163  當 */
	{ 0x6145, 0x7586, },	/* 65-37  E164  疆 */
	{ 0x6146, 0x7587, },	/* 65-38  E165  疇 */
	{ 0x6147, 0x7574, },	/* 65-39  E166  畴 */
	{ 0x6148, 0x758A, },	/* 65-40  E167  疊 */
	{ 0x6149, 0x7589, },	/* 65-41  E168  疉 */
	{ 0x614A, 0x7582, },	/* 65-42  E169  疂 */
	{ 0x614B, 0x7594, },	/* 65-43  E16A  疔 */
	{ 0x614C, 0x759A, },	/* 65-44  E16B  疚 */
	{ 0x614D, 0x759D, },	/* 65-45  E16C  疝 */
	{ 0x614E, 0x75A5, },	/* 65-46  E16D  疥 */
	{ 0x614F, 0x75A3, },	/* 65-47  E16E  疣 */
	{ 0x6150, 0x75C2, },	/* 65-48  E16F  痂 */
	{ 0x6151, 0x75B3, },	/* 65-49  E170  疳 */
	{ 0x6152, 0x75C3, },	/* 65-50  E171  痃 */
	{ 0x6153, 0x75B5, },	/* 65-51  E172  疵 */
	{ 0x6154, 0x75BD, },	/* 65-52  E173  疽 */
	{ 0x6155, 0x75B8, },	/* 65-53  E174  疸 */
	{ 0x6156, 0x75BC, },	/* 65-54  E175  疼 */
	{ 0x6157, 0x75B1, },	/* 65-55  E176  疱 */
	{ 0x6158, 0x75CD, },	/* 65-56  E177  痍 */
	{ 0x6159, 0x75CA, },	/* 65-57  E178  痊 */
	{ 0x615A, 0x75D2, },	/* 65-58  E179  痒 */
	{ 0x615B, 0x75D9, },	/* 65-59  E17A  痙 */
	{ 0x615C, 0x75E3, },	/* 65-60  E17B  痣 */
	{ 0x615D, 0x75DE, },	/* 65-61  E17C  痞 */
	{ 0x615E, 0x75FE, },	/* 65-62  E17D  痾 */
	{ 0x615F, 0x75FF, },	/* 65-63  E17E  痿 */
	{ 0x6160, 0x75FC, },	/* 65-64  E180  痼 */
	{ 0x6161, 0x7601, },	/* 65-65  E181  瘁 */
	{ 0x6162, 0x75F0, },	/* 65-66  E182  痰 */
	{ 0x6163, 0x75FA, },	/* 65-67  E183  痺 */
	{ 0x6164, 0x75F2, },	/* 65-68  E184  痲 */
	{ 0x6165, 0x75F3, },	/* 65-69  E185  痳 */
	{ 0x6166, 0x760B, },	/* 65-70  E186  瘋 */
	{ 0x6167, 0x760D, },	/* 65-71  E187  瘍 */
	{ 0x6168, 0x7609, },	/* 65-72  E188  瘉 */
	{ 0x6169, 0x761F, },	/* 65-73  E189  瘟 */
	{ 0x616A, 0x7627, },	/* 65-74  E18A  瘧 */
	{ 0x616B, 0x7620, },	/* 65-75  E18B  瘠 */
	{ 0x616C, 0x7621, },	/* 65-76  E18C  瘡 */
	{ 0x616D, 0x7622, },	/* 65-77  E18D  瘢 */
	{ 0x616E, 0x7624, },	/* 65-78  E18E  瘤 */
	{ 0x616F, 0x7634, },	/* 65-79  E18F  瘴 */
	{ 0x6170, 0x7630, },	/* 65-80  E190  瘰 */
	{ 0x6171, 0x763B, },	/* 65-81  E191  瘻 */
	{ 0x6172, 0x7647, },	/* 65-82  E192  癇 */
	{ 0x6173, 0x7648, },	/* 65-83  E193  癈 */
	{ 0x6174, 0x7646, },	/* 65-84  E194  癆 */
	{ 0x6175, 0x765C, },	/* 65-85  E195  癜 */
	{ 0x6176, 0x7658, },	/* 65-86  E196  癘 */
	{ 0x6177, 0x7661, },	/* 65-87  E197  癡 */
	{ 0x6178, 0x7662, },	/* 65-88  E198  癢 */
	{ 0x6179, 0x7668, },	/* 65-89  E199  癨 */
	{ 0x617A, 0x7669, },	/* 65-90  E19A  癩 */
	{ 0x617B, 0x766A, },	/* 65-91  E19B  癪 */
	{ 0x617C, 0x7667, },	/* 65-92  E19C  癧 */
	{ 0x617D, 0x766C, },	/* 65-93  E19D  癬 */
	{ 0x617E, 0x7670, },	/* 65-94  E19E  癰 */
	{ 0x6221, 0x7672, },	/* 66-01  E19F  癲 */
	{ 0x6222, 0x7676, },	/* 66-02  E1A0  癶 */
	{ 0x6223, 0x7678, },	/* 66-03  E1A1  癸 */
	{ 0x6224, 0x767C, },	/* 66-04  E1A2  發 */
	{ 0x6225, 0x7680, },	/* 66-05  E1A3  皀 */
	{ 0x6226, 0x7683, },	/* 66-06  E1A4  皃 */
	{ 0x6227, 0x7688, },	/* 66-07  E1A5  皈 */
	{ 0x6228, 0x768B, },	/* 66-08  E1A6  皋 */
	{ 0x6229, 0x768E, },	/* 66-09  E1A7  皎 */
	{ 0x622A, 0x7696, },	/* 66-10  E1A8  皖 */
	{ 0x622B, 0x7693, },	/* 66-11  E1A9  皓 */
	{ 0x622C, 0x7699, },	/* 66-12  E1AA  皙 */
	{ 0x622D, 0x769A, },	/* 66-13  E1AB  皚 */
	{ 0x622E, 0x76B0, },	/* 66-14  E1AC  皰 */
	{ 0x622F, 0x76B4, },	/* 66-15  E1AD  皴 */
	{ 0x6230, 0x76B8, },	/* 66-16  E1AE  皸 */
	{ 0x6231, 0x76B9, },	/* 66-17  E1AF  皹 */
	{ 0x6232, 0x76BA, },	/* 66-18  E1B0  皺 */
	{ 0x6233, 0x76C2, },	/* 66-19  E1B1  盂 */
	{ 0x6234, 0x76CD, },	/* 66-20  E1B2  盍 */
	{ 0x6235, 0x76D6, },	/* 66-21  E1B3  盖 */
	{ 0x6236, 0x76D2, },	/* 66-22  E1B4  盒 */
	{ 0x6237, 0x76DE, },	/* 66-23  E1B5  盞 */
	{ 0x6238, 0x76E1, },	/* 66-24  E1B6  盡 */
	{ 0x6239, 0x76E5, },	/* 66-25  E1B7  盥 */
	{ 0x623A, 0x76E7, },	/* 66-26  E1B8  盧 */
	{ 0x623B, 0x76EA, },	/* 66-27  E1B9  盪 */
	{ 0x623C, 0x862F, },	/* 66-28  E1BA  蘯 */
	{ 0x623D, 0x76FB, },	/* 66-29  E1BB  盻 */
	{ 0x623E, 0x7708, },	/* 66-30  E1BC  眈 */
	{ 0x623F, 0x7707, },	/* 66-31  E1BD  眇 */
	{ 0x6240, 0x7704, },	/* 66-32  E1BE  眄 */
	{ 0x6241, 0x7729, },	/* 66-33  E1BF  眩 */
	{ 0x6242, 0x7724, },	/* 66-34  E1C0  眤 */
	{ 0x6243, 0x771E, },	/* 66-35  E1C1  眞 */
	{ 0x6244, 0x7725, },	/* 66-36  E1C2  眥 */
	{ 0x6245, 0x7726, },	/* 66-37  E1C3  眦 */
	{ 0x6246, 0x771B, },	/* 66-38  E1C4  眛 */
	{ 0x6247, 0x7737, },	/* 66-39  E1C5  眷 */
	{ 0x6248, 0x7738, },	/* 66-40  E1C6  眸 */
	{ 0x6249, 0x7747, },	/* 66-41  E1C7  睇 */
	{ 0x624A, 0x775A, },	/* 66-42  E1C8  睚 */
	{ 0x624B, 0x7768, },	/* 66-43  E1C9  睨 */
	{ 0x624C, 0x776B, },	/* 66-44  E1CA  睫 */
	{ 0x624D, 0x775B, },	/* 66-45  E1CB  睛 */
	{ 0x624E, 0x7765, },	/* 66-46  E1CC  睥 */
	{ 0x624F, 0x777F, },	/* 66-47  E1CD  睿 */
	{ 0x6250, 0x777E, },	/* 66-48  E1CE  睾 */
	{ 0x6251, 0x7779, },	/* 66-49  E1CF  睹 */
	{ 0x6252, 0x778E, },	/* 66-50  E1D0  瞎 */
	{ 0x6253, 0x778B, },	/* 66-51  E1D1  瞋 */
	{ 0x6254, 0x7791, },	/* 66-52  E1D2  瞑 */
	{ 0x6255, 0x77A0, },	/* 66-53  E1D3  瞠 */
	{ 0x6256, 0x779E, },	/* 66-54  E1D4  瞞 */
	{ 0x6257, 0x77B0, },	/* 66-55  E1D5  瞰 */
	{ 0x6258, 0x77B6, },	/* 66-56  E1D6  瞶 */
	{ 0x6259, 0x77B9, },	/* 66-57  E1D7  瞹 */
	{ 0x625A, 0x77BF, },	/* 66-58  E1D8  瞿 */
	{ 0x625B, 0x77BC, },	/* 66-59  E1D9  瞼 */
	{ 0x625C, 0x77BD, },	/* 66-60  E1DA  瞽 */
	{ 0x625D, 0x77BB, },	/* 66-61  E1DB  瞻 */
	{ 0x625E, 0x77C7, },	/* 66-62  E1DC  矇 */
	{ 0x625F, 0x77CD, },	/* 66-63  E1DD  矍 */
	{ 0x6260, 0x77D7, },	/* 66-64  E1DE  矗 */
	{ 0x6261, 0x77DA, },	/* 66-65  E1DF  矚 */
	{ 0x6262, 0x77DC, },	/* 66-66  E1E0  矜 */
	{ 0x6263, 0x77E3, },	/* 66-67  E1E1  矣 */
	{ 0x6264, 0x77EE, },	/* 66-68  E1E2  矮 */
	{ 0x6265, 0x77FC, },	/* 66-69  E1E3  矼 */
	{ 0x6266, 0x780C, },	/* 66-70  E1E4  砌 */
	{ 0x6267, 0x7812, },	/* 66-71  E1E5  砒 */
	{ 0x6268, 0x7926, },	/* 66-72  E1E6  礦 */
	{ 0x6269, 0x7820, },	/* 66-73  E1E7  砠 */
	{ 0x626A, 0x792A, },	/* 66-74  E1E8  礪 */
	{ 0x626B, 0x7845, },	/* 66-75  E1E9  硅 */
	{ 0x626C, 0x788E, },	/* 66-76  E1EA  碎 */
	{ 0x626D, 0x7874, },	/* 66-77  E1EB  硴 */
	{ 0x626E, 0x7886, },	/* 66-78  E1EC  碆 */
	{ 0x626F, 0x787C, },	/* 66-79  E1ED  硼 */
	{ 0x6270, 0x789A, },	/* 66-80  E1EE  碚 */
	{ 0x6271, 0x788C, },	/* 66-81  E1EF  碌 */
	{ 0x6272, 0x78A3, },	/* 66-82  E1F0  碣 */
	{ 0x6273, 0x78B5, },	/* 66-83  E1F1  碵 */
	{ 0x6274, 0x78AA, },	/* 66-84  E1F2  碪 */
	{ 0x6275, 0x78AF, },	/* 66-85  E1F3  碯 */
	{ 0x6276, 0x78D1, },	/* 66-86  E1F4  磑 */
	{ 0x6277, 0x78C6, },	/* 66-87  E1F5  磆 */
	{ 0x6278, 0x78CB, },	/* 66-88  E1F6  磋 */
	{ 0x6279, 0x78D4, },	/* 66-89  E1F7  磔 */
	{ 0x627A, 0x78BE, },	/* 66-90  E1F8  碾 */
	{ 0x627B, 0x78BC, },	/* 66-91  E1F9  碼 */
	{ 0x627C, 0x78C5, },	/* 66-92  E1FA  磅 */
	{ 0x627D, 0x78CA, },	/* 66-93  E1FB  磊 */
	{ 0x627E, 0x78EC, },	/* 66-94  E1FC  磬 */
	{ 0x6321, 0x78E7, },	/* 67-01  E240  磧 */
	{ 0x6322, 0x78DA, },	/* 67-02  E241  磚 */
	{ 0x6323, 0x78FD, },	/* 67-03  E242  磽 */
	{ 0x6324, 0x78F4, },	/* 67-04  E243  磴 */
	{ 0x6325, 0x7907, },	/* 67-05  E244  礇 */
	{ 0x6326, 0x7912, },	/* 67-06  E245  礒 */
	{ 0x6327, 0x7911, },	/* 67-07  E246  礑 */
	{ 0x6328, 0x7919, },	/* 67-08  E247  礙 */
	{ 0x6329, 0x792C, },	/* 67-09  E248  礬 */
	{ 0x632A, 0x792B, },	/* 67-10  E249  礫 */
	{ 0x632B, 0x7940, },	/* 67-11  E24A  祀 */
	{ 0x632C, 0x7960, },	/* 67-12  E24B  祠 */
	{ 0x632D, 0x7957, },	/* 67-13  E24C  祗 */
	{ 0x632E, 0x795F, },	/* 67-14  E24D  祟 */
	{ 0x632F, 0x795A, },	/* 67-15  E24E  祚 */
	{ 0x6330, 0x7955, },	/* 67-16  E24F  祕 */
	{ 0x6331, 0x7953, },	/* 67-17  E250  祓 */
	{ 0x6332, 0x797A, },	/* 67-18  E251  祺 */
	{ 0x6333, 0x797F, },	/* 67-19  E252  祿 */
	{ 0x6334, 0x798A, },	/* 67-20  E253  禊 */
	{ 0x6335, 0x799D, },	/* 67-21  E254  禝 */
	{ 0x6336, 0x79A7, },	/* 67-22  E255  禧 */
	{ 0x6337, 0x9F4B, },	/* 67-23  E256  齋 */
	{ 0x6338, 0x79AA, },	/* 67-24  E257  禪 */
	{ 0x6339, 0x79AE, },	/* 67-25  E258  禮 */
	{ 0x633A, 0x79B3, },	/* 67-26  E259  禳 */
	{ 0x633B, 0x79B9, },	/* 67-27  E25A  禹 */
	{ 0x633C, 0x79BA, },	/* 67-28  E25B  禺 */
	{ 0x633D, 0x79C9, },	/* 67-29  E25C  秉 */
	{ 0x633E, 0x79D5, },	/* 67-30  E25D  秕 */
	{ 0x633F, 0x79E7, },	/* 67-31  E25E  秧 */
	{ 0x6340, 0x79EC, },	/* 67-32  E25F  秬 */
	{ 0x6341, 0x79E1, },	/* 67-33  E260  秡 */
	{ 0x6342, 0x79E3, },	/* 67-34  E261  秣 */
	{ 0x6343, 0x7A08, },	/* 67-35  E262  稈 */
	{ 0x6344, 0x7A0D, },	/* 67-36  E263  稍 */
	{ 0x6345, 0x7A18, },	/* 67-37  E264  稘 */
	{ 0x6346, 0x7A19, },	/* 67-38  E265  稙 */
	{ 0x6347, 0x7A20, },	/* 67-39  E266  稠 */
	{ 0x6348, 0x7A1F, },	/* 67-40  E267  稟 */
	{ 0x6349, 0x7980, },	/* 67-41  E268  禀 */
	{ 0x634A, 0x7A31, },	/* 67-42  E269  稱 */
	{ 0x634B, 0x7A3B, },	/* 67-43  E26A  稻 */
	{ 0x634C, 0x7A3E, },	/* 67-44  E26B  稾 */
	{ 0x634D, 0x7A37, },	/* 67-45  E26C  稷 */
	{ 0x634E, 0x7A43, },	/* 67-46  E26D  穃 */
	{ 0x634F, 0x7A57, },	/* 67-47  E26E  穗 */
	{ 0x6350, 0x7A49, },	/* 67-48  E26F  穉 */
	{ 0x6351, 0x7A61, },	/* 67-49  E270  穡 */
	{ 0x6352, 0x7A62, },	/* 67-50  E271  穢 */
	{ 0x6353, 0x7A69, },	/* 67-51  E272  穩 */
	{ 0x6354, 0x9F9D, },	/* 67-52  E273  龝 */
	{ 0x6355, 0x7A70, },	/* 67-53  E274  穰 */
	{ 0x6356, 0x7A79, },	/* 67-54  E275  穹 */
	{ 0x6357, 0x7A7D, },	/* 67-55  E276  穽 */
	{ 0x6358, 0x7A88, },	/* 67-56  E277  窈 */
	{ 0x6359, 0x7A97, },	/* 67-57  E278  窗 */
	{ 0x635A, 0x7A95, },	/* 67-58  E279  窕 */
	{ 0x635B, 0x7A98, },	/* 67-59  E27A  窘 */
	{ 0x635C, 0x7A96, },	/* 67-60  E27B  窖 */
	{ 0x635D, 0x7AA9, },	/* 67-61  E27C  窩 */
	{ 0x635E, 0x7AC8, },	/* 67-62  E27D  竈 */
	{ 0x635F, 0x7AB0, },	/* 67-63  E27E  窰 */
	{ 0x6360, 0x7AB6, },	/* 67-64  E280  窶 */
	{ 0x6361, 0x7AC5, },	/* 67-65  E281  竅 */
	{ 0x6362, 0x7AC4, },	/* 67-66  E282  竄 */
	{ 0x6363, 0x7ABF, },	/* 67-67  E283  窿 */
	{ 0x6364, 0x9083, },	/* 67-68  E284  邃 */
	{ 0x6365, 0x7AC7, },	/* 67-69  E285  竇 */
	{ 0x6366, 0x7ACA, },	/* 67-70  E286  竊 */
	{ 0x6367, 0x7ACD, },	/* 67-71  E287  竍 */
	{ 0x6368, 0x7ACF, },	/* 67-72  E288  竏 */
	{ 0x6369, 0x7AD5, },	/* 67-73  E289  竕 */
	{ 0x636A, 0x7AD3, },	/* 67-74  E28A  竓 */
	{ 0x636B, 0x7AD9, },	/* 67-75  E28B  站 */
	{ 0x636C, 0x7ADA, },	/* 67-76  E28C  竚 */
	{ 0x636D, 0x7ADD, },	/* 67-77  E28D  竝 */
	{ 0x636E, 0x7AE1, },	/* 67-78  E28E  竡 */
	{ 0x636F, 0x7AE2, },	/* 67-79  E28F  竢 */
	{ 0x6370, 0x7AE6, },	/* 67-80  E290  竦 */
	{ 0x6371, 0x7AED, },	/* 67-81  E291  竭 */
	{ 0x6372, 0x7AF0, },	/* 67-82  E292  竰 */
	{ 0x6373, 0x7B02, },	/* 67-83  E293  笂 */
	{ 0x6374, 0x7B0F, },	/* 67-84  E294  笏 */
	{ 0x6375, 0x7B0A, },	/* 67-85  E295  笊 */
	{ 0x6376, 0x7B06, },	/* 67-86  E296  笆 */
	{ 0x6377, 0x7B33, },	/* 67-87  E297  笳 */
	{ 0x6378, 0x7B18, },	/* 67-88  E298  笘 */
	{ 0x6379, 0x7B19, },	/* 67-89  E299  笙 */
	{ 0x637A, 0x7B1E, },	/* 67-90  E29A  笞 */
	{ 0x637B, 0x7B35, },	/* 67-91  E29B  笵 */
	{ 0x637C, 0x7B28, },	/* 67-92  E29C  笨 */
	{ 0x637D, 0x7B36, },	/* 67-93  E29D  笶 */
	{ 0x637E, 0x7B50, },	/* 67-94  E29E  筐 */
	{ 0x6421, 0x7B7A, },	/* 68-01  E29F  筺 */
	{ 0x6422, 0x7B04, },	/* 68-02  E2A0  笄 */
	{ 0x6423, 0x7B4D, },	/* 68-03  E2A1  筍 */
	{ 0x6424, 0x7B0B, },	/* 68-04  E2A2  笋 */
	{ 0x6425, 0x7B4C, },	/* 68-05  E2A3  筌 */
	{ 0x6426, 0x7B45, },	/* 68-06  E2A4  筅 */
	{ 0x6427, 0x7B75, },	/* 68-07  E2A5  筵 */
	{ 0x6428, 0x7B65, },	/* 68-08  E2A6  筥 */
	{ 0x6429, 0x7B74, },	/* 68-09  E2A7  筴 */
	{ 0x642A, 0x7B67, },	/* 68-10  E2A8  筧 */
	{ 0x642B, 0x7B70, },	/* 68-11  E2A9  筰 */
	{ 0x642C, 0x7B71, },	/* 68-12  E2AA  筱 */
	{ 0x642D, 0x7B6C, },	/* 68-13  E2AB  筬 */
	{ 0x642E, 0x7B6E, },	/* 68-14  E2AC  筮 */
	{ 0x642F, 0x7B9D, },	/* 68-15  E2AD  箝 */
	{ 0x6430, 0x7B98, },	/* 68-16  E2AE  箘 */
	{ 0x6431, 0x7B9F, },	/* 68-17  E2AF  箟 */
	{ 0x6432, 0x7B8D, },	/* 68-18  E2B0  箍 */
	{ 0x6433, 0x7B9C, },	/* 68-19  E2B1  箜 */
	{ 0x6434, 0x7B9A, },	/* 68-20  E2B2  箚 */
	{ 0x6435, 0x7B8B, },	/* 68-21  E2B3  箋 */
	{ 0x6436, 0x7B92, },	/* 68-22  E2B4  箒 */
	{ 0x6437, 0x7B8F, },	/* 68-23  E2B5  箏 */
	{ 0x6438, 0x7B5D, },	/* 68-24  E2B6  筝 */
	{ 0x6439, 0x7B99, },	/* 68-25  E2B7  箙 */
	{ 0x643A, 0x7BCB, },	/* 68-26  E2B8  篋 */
	{ 0x643B, 0x7BC1, },	/* 68-27  E2B9  篁 */
	{ 0x643C, 0x7BCC, },	/* 68-28  E2BA  篌 */
	{ 0x643D, 0x7BCF, },	/* 68-29  E2BB  篏 */
	{ 0x643E, 0x7BB4, },	/* 68-30  E2BC  箴 */
	{ 0x643F, 0x7BC6, },	/* 68-31  E2BD  篆 */
	{ 0x6440, 0x7BDD, },	/* 68-32  E2BE  篝 */
	{ 0x6441, 0x7BE9, },	/* 68-33  E2BF  篩 */
	{ 0x6442, 0x7C11, },	/* 68-34  E2C0  簑 */
	{ 0x6443, 0x7C14, },	/* 68-35  E2C1  簔 */
	{ 0x6444, 0x7BE6, },	/* 68-36  E2C2  篦 */
	{ 0x6445, 0x7BE5, },	/* 68-37  E2C3  篥 */
	{ 0x6446, 0x7C60, },	/* 68-38  E2C4  籠 */
	{ 0x6447, 0x7C00, },	/* 68-39  E2C5  簀 */
	{ 0x6448, 0x7C07, },	/* 68-40  E2C6  簇 */
	{ 0x6449, 0x7C13, },	/* 68-41  E2C7  簓 */
	{ 0x644A, 0x7BF3, },	/* 68-42  E2C8  篳 */
	{ 0x644B, 0x7BF7, },	/* 68-43  E2C9  篷 */
	{ 0x644C, 0x7C17, },	/* 68-44  E2CA  簗 */
	{ 0x644D, 0x7C0D, },	/* 68-45  E2CB  簍 */
	{ 0x644E, 0x7BF6, },	/* 68-46  E2CC  篶 */
	{ 0x644F, 0x7C23, },	/* 68-47  E2CD  簣 */
	{ 0x6450, 0x7C27, },	/* 68-48  E2CE  簧 */
	{ 0x6451, 0x7C2A, },	/* 68-49  E2CF  簪 */
	{ 0x6452, 0x7C1F, },	/* 68-50  E2D0  簟 */
	{ 0x6453, 0x7C37, },	/* 68-51  E2D1  簷 */
	{ 0x6454, 0x7C2B, },	/* 68-52  E2D2  簫 */
	{ 0x6455, 0x7C3D, },	/* 68-53  E2D3  簽 */
	{ 0x6456, 0x7C4C, },	/* 68-54  E2D4  籌 */
	{ 0x6457, 0x7C43, },	/* 68-55  E2D5  籃 */
	{ 0x6458, 0x7C54, },	/* 68-56  E2D6  籔 */
	{ 0x6459, 0x7C4F, },	/* 68-57  E2D7  籏 */
	{ 0x645A, 0x7C40, },	/* 68-58  E2D8  籀 */
	{ 0x645B, 0x7C50, },	/* 68-59  E2D9  籐 */
	{ 0x645C, 0x7C58, },	/* 68-60  E2DA  籘 */
	{ 0x645D, 0x7C5F, },	/* 68-61  E2DB  籟 */
	{ 0x645E, 0x7C64, },	/* 68-62  E2DC  籤 */
	{ 0x645F, 0x7C56, },	/* 68-63  E2DD  籖 */
	{ 0x6460, 0x7C65, },	/* 68-64  E2DE  籥 */
	{ 0x6461, 0x7C6C, },	/* 68-65  E2DF  籬 */
	{ 0x6462, 0x7C75, },	/* 68-66  E2E0  籵 */
	{ 0x6463, 0x7C83, },	/* 68-67  E2E1  粃 */
	{ 0x6464, 0x7C90, },	/* 68-68  E2E2  粐 */
	{ 0x6465, 0x7CA4, },	/* 68-69  E2E3  粤 */
	{ 0x6466, 0x7CAD, },	/* 68-70  E2E4  粭 */
	{ 0x6467, 0x7CA2, },	/* 68-71  E2E5  粢 */
	{ 0x6468, 0x7CAB, },	/* 68-72  E2E6  粫 */
	{ 0x6469, 0x7CA1, },	/* 68-73  E2E7  粡 */
	{ 0x646A, 0x7CA8, },	/* 68-74  E2E8  粨 */
	{ 0x646B, 0x7CB3, },	/* 68-75  E2E9  粳 */
	{ 0x646C, 0x7CB2, },	/* 68-76  E2EA  粲 */
	{ 0x646D, 0x7CB1, },	/* 68-77  E2EB  粱 */
	{ 0x646E, 0x7CAE, },	/* 68-78  E2EC  粮 */
	{ 0x646F, 0x7CB9, },	/* 68-79  E2ED  粹 */
	{ 0x6470, 0x7CBD, },	/* 68-80  E2EE  粽 */
	{ 0x6471, 0x7CC0, },	/* 68-81  E2EF  糀 */
	{ 0x6472, 0x7CC5, },	/* 68-82  E2F0  糅 */
	{ 0x6473, 0x7CC2, },	/* 68-83  E2F1  糂 */
	{ 0x6474, 0x7CD8, },	/* 68-84  E2F2  糘 */
	{ 0x6475, 0x7CD2, },	/* 68-85  E2F3  糒 */
	{ 0x6476, 0x7CDC, },	/* 68-86  E2F4  糜 */
	{ 0x6477, 0x7CE2, },	/* 68-87  E2F5  糢 */
	{ 0x6478, 0x9B3B, },	/* 68-88  E2F6  鬻 */
	{ 0x6479, 0x7CEF, },	/* 68-89  E2F7  糯 */
	{ 0x647A, 0x7CF2, },	/* 68-90  E2F8  糲 */
	{ 0x647B, 0x7CF4, },	/* 68-91  E2F9  糴 */
	{ 0x647C, 0x7CF6, },	/* 68-92  E2FA  糶 */
	{ 0x647D, 0x7CFA, },	/* 68-93  E2FB  糺 */
	{ 0x647E, 0x7D06, },	/* 68-94  E2FC  紆 */
	{ 0x6521, 0x7D02, },	/* 69-01  E340  紂 */
	{ 0x6522, 0x7D1C, },	/* 69-02  E341  紜 */
	{ 0x6523, 0x7D15, },	/* 69-03  E342  紕 */
	{ 0x6524, 0x7D0A, },	/* 69-04  E343  紊 */
	{ 0x6525, 0x7D45, },	/* 69-05  E344  絅 */
	{ 0x6526, 0x7D4B, },	/* 69-06  E345  絋 */
	{ 0x6527, 0x7D2E, },	/* 69-07  E346  紮 */
	{ 0x6528, 0x7D32, },	/* 69-08  E347  紲 */
	{ 0x6529, 0x7D3F, },	/* 69-09  E348  紿 */
	{ 0x652A, 0x7D35, },	/* 69-10  E349  紵 */
	{ 0x652B, 0x7D46, },	/* 69-11  E34A  絆 */
	{ 0x652C, 0x7D73, },	/* 69-12  E34B  絳 */
	{ 0x652D, 0x7D56, },	/* 69-13  E34C  絖 */
	{ 0x652E, 0x7D4E, },	/* 69-14  E34D  絎 */
	{ 0x652F, 0x7D72, },	/* 69-15  E34E  絲 */
	{ 0x6530, 0x7D68, },	/* 69-16  E34F  絨 */
	{ 0x6531, 0x7D6E, },	/* 69-17  E350  絮 */
	{ 0x6532, 0x7D4F, },	/* 69-18  E351  絏 */
	{ 0x6533, 0x7D63, },	/* 69-19  E352  絣 */
	{ 0x6534, 0x7D93, },	/* 69-20  E353  經 */
	{ 0x6535, 0x7D89, },	/* 69-21  E354  綉 */
	{ 0x6536, 0x7D5B, },	/* 69-22  E355  絛 */
	{ 0x6537, 0x7D8F, },	/* 69-23  E356  綏 */
	{ 0x6538, 0x7D7D, },	/* 69-24  E357  絽 */
	{ 0x6539, 0x7D9B, },	/* 69-25  E358  綛 */
	{ 0x653A, 0x7DBA, },	/* 69-26  E359  綺 */
	{ 0x653B, 0x7DAE, },	/* 69-27  E35A  綮 */
	{ 0x653C, 0x7DA3, },	/* 69-28  E35B  綣 */
	{ 0x653D, 0x7DB5, },	/* 69-29  E35C  綵 */
	{ 0x653E, 0x7DC7, },	/* 69-30  E35D  緇 */
	{ 0x653F, 0x7DBD, },	/* 69-31  E35E  綽 */
	{ 0x6540, 0x7DAB, },	/* 69-32  E35F  綫 */
	{ 0x6541, 0x7E3D, },	/* 69-33  E360  總 */
	{ 0x6542, 0x7DA2, },	/* 69-34  E361  綢 */
	{ 0x6543, 0x7DAF, },	/* 69-35  E362  綯 */
	{ 0x6544, 0x7DDC, },	/* 69-36  E363  緜 */
	{ 0x6545, 0x7DB8, },	/* 69-37  E364  綸 */
	{ 0x6546, 0x7D9F, },	/* 69-38  E365  綟 */
	{ 0x6547, 0x7DB0, },	/* 69-39  E366  綰 */
	{ 0x6548, 0x7DD8, },	/* 69-40  E367  緘 */
	{ 0x6549, 0x7DDD, },	/* 69-41  E368  緝 */
	{ 0x654A, 0x7DE4, },	/* 69-42  E369  緤 */
	{ 0x654B, 0x7DDE, },	/* 69-43  E36A  緞 */
	{ 0x654C, 0x7DFB, },	/* 69-44  E36B  緻 */
	{ 0x654D, 0x7DF2, },	/* 69-45  E36C  緲 */
	{ 0x654E, 0x7DE1, },	/* 69-46  E36D  緡 */
	{ 0x654F, 0x7E05, },	/* 69-47  E36E  縅 */
	{ 0x6550, 0x7E0A, },	/* 69-48  E36F  縊 */
	{ 0x6551, 0x7E23, },	/* 69-49  E370  縣 */
	{ 0x6552, 0x7E21, },	/* 69-50  E371  縡 */
	{ 0x6553, 0x7E12, },	/* 69-51  E372  縒 */
	{ 0x6554, 0x7E31, },	/* 69-52  E373  縱 */
	{ 0x6555, 0x7E1F, },	/* 69-53  E374  縟 */
	{ 0x6556, 0x7E09, },	/* 69-54  E375  縉 */
	{ 0x6557, 0x7E0B, },	/* 69-55  E376  縋 */
	{ 0x6558, 0x7E22, },	/* 69-56  E377  縢 */
	{ 0x6559, 0x7E46, },	/* 69-57  E378  繆 */
	{ 0x655A, 0x7E66, },	/* 69-58  E379  繦 */
	{ 0x655B, 0x7E3B, },	/* 69-59  E37A  縻 */
	{ 0x655C, 0x7E35, },	/* 69-60  E37B  縵 */
	{ 0x655D, 0x7E39, },	/* 69-61  E37C  縹 */
	{ 0x655E, 0x7E43, },	/* 69-62  E37D  繃 */
	{ 0x655F, 0x7E37, },	/* 69-63  E37E  縷 */
	{ 0x6560, 0x7E32, },	/* 69-64  E380  縲 */
	{ 0x6561, 0x7E3A, },	/* 69-65  E381  縺 */
	{ 0x6562, 0x7E67, },	/* 69-66  E382  繧 */
	{ 0x6563, 0x7E5D, },	/* 69-67  E383  繝 */
	{ 0x6564, 0x7E56, },	/* 69-68  E384  繖 */
	{ 0x6565, 0x7E5E, },	/* 69-69  E385  繞 */
	{ 0x6566, 0x7E59, },	/* 69-70  E386  繙 */
	{ 0x6567, 0x7E5A, },	/* 69-71  E387  繚 */
	{ 0x6568, 0x7E79, },	/* 69-72  E388  繹 */
	{ 0x6569, 0x7E6A, },	/* 69-73  E389  繪 */
	{ 0x656A, 0x7E69, },	/* 69-74  E38A  繩 */
	{ 0x656B, 0x7E7C, },	/* 69-75  E38B  繼 */
	{ 0x656C, 0x7E7B, },	/* 69-76  E38C  繻 */
	{ 0x656D, 0x7E83, },	/* 69-77  E38D  纃 */
	{ 0x656E, 0x7DD5, },	/* 69-78  E38E  緕 */
	{ 0x656F, 0x7E7D, },	/* 69-79  E38F  繽 */
	{ 0x6570, 0x8FAE, },	/* 69-80  E390  辮 */
	{ 0x6571, 0x7E7F, },	/* 69-81  E391  繿 */
	{ 0x6572, 0x7E88, },	/* 69-82  E392  纈 */
	{ 0x6573, 0x7E89, },	/* 69-83  E393  纉 */
	{ 0x6574, 0x7E8C, },	/* 69-84  E394  續 */
	{ 0x6575, 0x7E92, },	/* 69-85  E395  纒 */
	{ 0x6576, 0x7E90, },	/* 69-86  E396  纐 */
	{ 0x6577, 0x7E93, },	/* 69-87  E397  纓 */
	{ 0x6578, 0x7E94, },	/* 69-88  E398  纔 */
	{ 0x6579, 0x7E96, },	/* 69-89  E399  纖 */
	{ 0x657A, 0x7E8E, },	/* 69-90  E39A  纎 */
	{ 0x657B, 0x7E9B, },	/* 69-91  E39B  纛 */
	{ 0x657C, 0x7E9C, },	/* 69-92  E39C  纜 */
	{ 0x657D, 0x7F38, },	/* 69-93  E39D  缸 */
	{ 0x657E, 0x7F3A, },	/* 69-94  E39E  缺 */
	{ 0x6621, 0x7F45, },	/* 70-01  E39F  罅 */
	{ 0x6622, 0x7F4C, },	/* 70-02  E3A0  罌 */
	{ 0x6623, 0x7F4D, },	/* 70-03  E3A1  罍 */
	{ 0x6624, 0x7F4E, },	/* 70-04  E3A2  罎 */
	{ 0x6625, 0x7F50, },	/* 70-05  E3A3  罐 */
	{ 0x6626, 0x7F51, },	/* 70-06  E3A4  网 */
	{ 0x6627, 0x7F55, },	/* 70-07  E3A5  罕 */
	{ 0x6628, 0x7F54, },	/* 70-08  E3A6  罔 */
	{ 0x6629, 0x7F58, },	/* 70-09  E3A7  罘 */
	{ 0x662A, 0x7F5F, },	/* 70-10  E3A8  罟 */
	{ 0x662B, 0x7F60, },	/* 70-11  E3A9  罠 */
	{ 0x662C, 0x7F68, },	/* 70-12  E3AA  罨 */
	{ 0x662D, 0x7F69, },	/* 70-13  E3AB  罩 */
	{ 0x662E, 0x7F67, },	/* 70-14  E3AC  罧 */
	{ 0x662F, 0x7F78, },	/* 70-15  E3AD  罸 */
	{ 0x6630, 0x7F82, },	/* 70-16  E3AE  羂 */
	{ 0x6631, 0x7F86, },	/* 70-17  E3AF  羆 */
	{ 0x6632, 0x7F83, },	/* 70-18  E3B0  羃 */
	{ 0x6633, 0x7F88, },	/* 70-19  E3B1  羈 */
	{ 0x6634, 0x7F87, },	/* 70-20  E3B2  羇 */
	{ 0x6635, 0x7F8C, },	/* 70-21  E3B3  羌 */
	{ 0x6636, 0x7F94, },	/* 70-22  E3B4  羔 */
	{ 0x6637, 0x7F9E, },	/* 70-23  E3B5  羞 */
	{ 0x6638, 0x7F9D, },	/* 70-24  E3B6  羝 */
	{ 0x6639, 0x7F9A, },	/* 70-25  E3B7  羚 */
	{ 0x663A, 0x7FA3, },	/* 70-26  E3B8  羣 */
	{ 0x663B, 0x7FAF, },	/* 70-27  E3B9  羯 */
	{ 0x663C, 0x7FB2, },	/* 70-28  E3BA  羲 */
	{ 0x663D, 0x7FB9, },	/* 70-29  E3BB  羹 */
	{ 0x663E, 0x7FAE, },	/* 70-30  E3BC  羮 */
	{ 0x663F, 0x7FB6, },	/* 70-31  E3BD  羶 */
	{ 0x6640, 0x7FB8, },	/* 70-32  E3BE  羸 */
	{ 0x6641, 0x8B71, },	/* 70-33  E3BF  譱 */
	{ 0x6642, 0x7FC5, },	/* 70-34  E3C0  翅 */
	{ 0x6643, 0x7FC6, },	/* 70-35  E3C1  翆 */
	{ 0x6644, 0x7FCA, },	/* 70-36  E3C2  翊 */
	{ 0x6645, 0x7FD5, },	/* 70-37  E3C3  翕 */
	{ 0x6646, 0x7FD4, },	/* 70-38  E3C4  翔 */
	{ 0x6647, 0x7FE1, },	/* 70-39  E3C5  翡 */
	{ 0x6648, 0x7FE6, },	/* 70-40  E3C6  翦 */
	{ 0x6649, 0x7FE9, },	/* 70-41  E3C7  翩 */
	{ 0x664A, 0x7FF3, },	/* 70-42  E3C8  翳 */
	{ 0x664B, 0x7FF9, },	/* 70-43  E3C9  翹 */
	{ 0x664C, 0x98DC, },	/* 70-44  E3CA  飜 */
	{ 0x664D, 0x8006, },	/* 70-45  E3CB  耆 */
	{ 0x664E, 0x8004, },	/* 70-46  E3CC  耄 */
	{ 0x664F, 0x800B, },	/* 70-47  E3CD  耋 */
	{ 0x6650, 0x8012, },	/* 70-48  E3CE  耒 */
	{ 0x6651, 0x8018, },	/* 70-49  E3CF  耘 */
	{ 0x6652, 0x8019, },	/* 70-50  E3D0  耙 */
	{ 0x6653, 0x801C, },	/* 70-51  E3D1  耜 */
	{ 0x6654, 0x8021, },	/* 70-52  E3D2  耡 */
	{ 0x6655, 0x8028, },	/* 70-53  E3D3  耨 */
	{ 0x6656, 0x803F, },	/* 70-54  E3D4  耿 */
	{ 0x6657, 0x803B, },	/* 70-55  E3D5  耻 */
	{ 0x6658, 0x804A, },	/* 70-56  E3D6  聊 */
	{ 0x6659, 0x8046, },	/* 70-57  E3D7  聆 */
	{ 0x665A, 0x8052, },	/* 70-58  E3D8  聒 */
	{ 0x665B, 0x8058, },	/* 70-59  E3D9  聘 */
	{ 0x665C, 0x805A, },	/* 70-60  E3DA  聚 */
	{ 0x665D, 0x805F, },	/* 70-61  E3DB  聟 */
	{ 0x665E, 0x8062, },	/* 70-62  E3DC  聢 */
	{ 0x665F, 0x8068, },	/* 70-63  E3DD  聨 */
	{ 0x6660, 0x8073, },	/* 70-64  E3DE  聳 */
	{ 0x6661, 0x8072, },	/* 70-65  E3DF  聲 */
	{ 0x6662, 0x8070, },	/* 70-66  E3E0  聰 */
	{ 0x6663, 0x8076, },	/* 70-67  E3E1  聶 */
	{ 0x6664, 0x8079, },	/* 70-68  E3E2  聹 */
	{ 0x6665, 0x807D, },	/* 70-69  E3E3  聽 */
	{ 0x6666, 0x807F, },	/* 70-70  E3E4  聿 */
	{ 0x6667, 0x8084, },	/* 70-71  E3E5  肄 */
	{ 0x6668, 0x8086, },	/* 70-72  E3E6  肆 */
	{ 0x6669, 0x8085, },	/* 70-73  E3E7  肅 */
	{ 0x666A, 0x809B, },	/* 70-74  E3E8  肛 */
	{ 0x666B, 0x8093, },	/* 70-75  E3E9  肓 */
	{ 0x666C, 0x809A, },	/* 70-76  E3EA  肚 */
	{ 0x666D, 0x80AD, },	/* 70-77  E3EB  肭 */
	{ 0x666E, 0x5190, },	/* 70-78  E3EC  冐 */
	{ 0x666F, 0x80AC, },	/* 70-79  E3ED  肬 */
	{ 0x6670, 0x80DB, },	/* 70-80  E3EE  胛 */
	{ 0x6671, 0x80E5, },	/* 70-81  E3EF  胥 */
	{ 0x6672, 0x80D9, },	/* 70-82  E3F0  胙 */
	{ 0x6673, 0x80DD, },	/* 70-83  E3F1  胝 */
	{ 0x6674, 0x80C4, },	/* 70-84  E3F2  胄 */
	{ 0x6675, 0x80DA, },	/* 70-85  E3F3  胚 */
	{ 0x6676, 0x80D6, },	/* 70-86  E3F4  胖 */
	{ 0x6677, 0x8109, },	/* 70-87  E3F5  脉 */
	{ 0x6678, 0x80EF, },	/* 70-88  E3F6  胯 */
	{ 0x6679, 0x80F1, },	/* 70-89  E3F7  胱 */
	{ 0x667A, 0x811B, },	/* 70-90  E3F8  脛 */
	{ 0x667B, 0x8129, },	/* 70-91  E3F9  脩 */
	{ 0x667C, 0x8123, },	/* 70-92  E3FA  脣 */
	{ 0x667D, 0x812F, },	/* 70-93  E3FB  脯 */
	{ 0x667E, 0x814B, },	/* 70-94  E3FC  腋 */
	{ 0x6721, 0x968B, },	/* 71-01  E440  隋 */
	{ 0x6722, 0x8146, },	/* 71-02  E441  腆 */
	{ 0x6723, 0x813E, },	/* 71-03  E442  脾 */
	{ 0x6724, 0x8153, },	/* 71-04  E443  腓 */
	{ 0x6725, 0x8151, },	/* 71-05  E444  腑 */
	{ 0x6726, 0x80FC, },	/* 71-06  E445  胼 */
	{ 0x6727, 0x8171, },	/* 71-07  E446  腱 */
	{ 0x6728, 0x816E, },	/* 71-08  E447  腮 */
	{ 0x6729, 0x8165, },	/* 71-09  E448  腥 */
	{ 0x672A, 0x8166, },	/* 71-10  E449  腦 */
	{ 0x672B, 0x8174, },	/* 71-11  E44A  腴 */
	{ 0x672C, 0x8183, },	/* 71-12  E44B  膃 */
	{ 0x672D, 0x8188, },	/* 71-13  E44C  膈 */
	{ 0x672E, 0x818A, },	/* 71-14  E44D  膊 */
	{ 0x672F, 0x8180, },	/* 71-15  E44E  膀 */
	{ 0x6730, 0x8182, },	/* 71-16  E44F  膂 */
	{ 0x6731, 0x81A0, },	/* 71-17  E450  膠 */
	{ 0x6732, 0x8195, },	/* 71-18  E451  膕 */
	{ 0x6733, 0x81A4, },	/* 71-19  E452  膤 */
	{ 0x6734, 0x81A3, },	/* 71-20  E453  膣 */
	{ 0x6735, 0x815F, },	/* 71-21  E454  腟 */
	{ 0x6736, 0x8193, },	/* 71-22  E455  膓 */
	{ 0x6737, 0x81A9, },	/* 71-23  E456  膩 */
	{ 0x6738, 0x81B0, },	/* 71-24  E457  膰 */
	{ 0x6739, 0x81B5, },	/* 71-25  E458  膵 */
	{ 0x673A, 0x81BE, },	/* 71-26  E459  膾 */
	{ 0x673B, 0x81B8, },	/* 71-27  E45A  膸 */
	{ 0x673C, 0x81BD, },	/* 71-28  E45B  膽 */
	{ 0x673D, 0x81C0, },	/* 71-29  E45C  臀 */
	{ 0x673E, 0x81C2, },	/* 71-30  E45D  臂 */
	{ 0x673F, 0x81BA, },	/* 71-31  E45E  膺 */
	{ 0x6740, 0x81C9, },	/* 71-32  E45F  臉 */
	{ 0x6741, 0x81CD, },	/* 71-33  E460  臍 */
	{ 0x6742, 0x81D1, },	/* 71-34  E461  臑 */
	{ 0x6743, 0x81D9, },	/* 71-35  E462  臙 */
	{ 0x6744, 0x81D8, },	/* 71-36  E463  臘 */
	{ 0x6745, 0x81C8, },	/* 71-37  E464  臈 */
	{ 0x6746, 0x81DA, },	/* 71-38  E465  臚 */
	{ 0x6747, 0x81DF, },	/* 71-39  E466  臟 */
	{ 0x6748, 0x81E0, },	/* 71-40  E467  臠 */
	{ 0x6749, 0x81E7, },	/* 71-41  E468  臧 */
	{ 0x674A, 0x81FA, },	/* 71-42  E469  臺 */
	{ 0x674B, 0x81FB, },	/* 71-43  E46A  臻 */
	{ 0x674C, 0x81FE, },	/* 71-44  E46B  臾 */
	{ 0x674D, 0x8201, },	/* 71-45  E46C  舁 */
	{ 0x674E, 0x8202, },	/* 71-46  E46D  舂 */
	{ 0x674F, 0x8205, },	/* 71-47  E46E  舅 */
	{ 0x6750, 0x8207, },	/* 71-48  E46F  與 */
	{ 0x6751, 0x820A, },	/* 71-49  E470  舊 */
	{ 0x6752, 0x820D, },	/* 71-50  E471  舍 */
	{ 0x6753, 0x8210, },	/* 71-51  E472  舐 */
	{ 0x6754, 0x8216, },	/* 71-52  E473  舖 */
	{ 0x6755, 0x8229, },	/* 71-53  E474  舩 */
	{ 0x6756, 0x822B, },	/* 71-54  E475  舫 */
	{ 0x6757, 0x8238, },	/* 71-55  E476  舸 */
	{ 0x6758, 0x8233, },	/* 71-56  E477  舳 */
	{ 0x6759, 0x8240, },	/* 71-57  E478  艀 */
	{ 0x675A, 0x8259, },	/* 71-58  E479  艙 */
	{ 0x675B, 0x8258, },	/* 71-59  E47A  艘 */
	{ 0x675C, 0x825D, },	/* 71-60  E47B  艝 */
	{ 0x675D, 0x825A, },	/* 71-61  E47C  艚 */
	{ 0x675E, 0x825F, },	/* 71-62  E47D  艟 */
	{ 0x675F, 0x8264, },	/* 71-63  E47E  艤 */
	{ 0x6760, 0x8262, },	/* 71-64  E480  艢 */
	{ 0x6761, 0x8268, },	/* 71-65  E481  艨 */
	{ 0x6762, 0x826A, },	/* 71-66  E482  艪 */
	{ 0x6763, 0x826B, },	/* 71-67  E483  艫 */
	{ 0x6764, 0x822E, },	/* 71-68  E484  舮 */
	{ 0x6765, 0x8271, },	/* 71-69  E485  艱 */
	{ 0x6766, 0x8277, },	/* 71-70  E486  艷 */
	{ 0x6767, 0x8278, },	/* 71-71  E487  艸 */
	{ 0x6768, 0x827E, },	/* 71-72  E488  艾 */
	{ 0x6769, 0x828D, },	/* 71-73  E489  芍 */
	{ 0x676A, 0x8292, },	/* 71-74  E48A  芒 */
	{ 0x676B, 0x82AB, },	/* 71-75  E48B  芫 */
	{ 0x676C, 0x829F, },	/* 71-76  E48C  芟 */
	{ 0x676D, 0x82BB, },	/* 71-77  E48D  芻 */
	{ 0x676E, 0x82AC, },	/* 71-78  E48E  芬 */
	{ 0x676F, 0x82E1, },	/* 71-79  E48F  苡 */
	{ 0x6770, 0x82E3, },	/* 71-80  E490  苣 */
	{ 0x6771, 0x82DF, },	/* 71-81  E491  苟 */
	{ 0x6772, 0x82D2, },	/* 71-82  E492  苒 */
	{ 0x6773, 0x82F4, },	/* 71-83  E493  苴 */
	{ 0x6774, 0x82F3, },	/* 71-84  E494  苳 */
	{ 0x6775, 0x82FA, },	/* 71-85  E495  苺 */
	{ 0x6776, 0x8393, },	/* 71-86  E496  莓 */
	{ 0x6777, 0x8303, },	/* 71-87  E497  范 */
	{ 0x6778, 0x82FB, },	/* 71-88  E498  苻 */
	{ 0x6779, 0x82F9, },	/* 71-89  E499  苹 */
	{ 0x677A, 0x82DE, },	/* 71-90  E49A  苞 */
	{ 0x677B, 0x8306, },	/* 71-91  E49B  茆 */
	{ 0x677C, 0x82DC, },	/* 71-92  E49C  苜 */
	{ 0x677D, 0x8309, },	/* 71-93  E49D  茉 */
	{ 0x677E, 0x82D9, },	/* 71-94  E49E  苙 */
	{ 0x6821, 0x8335, },	/* 72-01  E49F  茵 */
	{ 0x6822, 0x8334, },	/* 72-02  E4A0  茴 */
	{ 0x6823, 0x8316, },	/* 72-03  E4A1  茖 */
	{ 0x6824, 0x8332, },	/* 72-04  E4A2  茲 */
	{ 0x6825, 0x8331, },	/* 72-05  E4A3  茱 */
	{ 0x6826, 0x8340, },	/* 72-06  E4A4  荀 */
	{ 0x6827, 0x8339, },	/* 72-07  E4A5  茹 */
	{ 0x6828, 0x8350, },	/* 72-08  E4A6  荐 */
	{ 0x6829, 0x8345, },	/* 72-09  E4A7  荅 */
	{ 0x682A, 0x832F, },	/* 72-10  E4A8  茯 */
	{ 0x682B, 0x832B, },	/* 72-11  E4A9  茫 */
	{ 0x682C, 0x8317, },	/* 72-12  E4AA  茗 */
	{ 0x682D, 0x8318, },	/* 72-13  E4AB  茘 */
	{ 0x682E, 0x8385, },	/* 72-14  E4AC  莅 */
	{ 0x682F, 0x839A, },	/* 72-15  E4AD  莚 */
	{ 0x6830, 0x83AA, },	/* 72-16  E4AE  莪 */
	{ 0x6831, 0x839F, },	/* 72-17  E4AF  莟 */
	{ 0x6832, 0x83A2, },	/* 72-18  E4B0  莢 */
	{ 0x6833, 0x8396, },	/* 72-19  E4B1  莖 */
	{ 0x6834, 0x8323, },	/* 72-20  E4B2  茣 */
	{ 0x6835, 0x838E, },	/* 72-21  E4B3  莎 */
	{ 0x6836, 0x8387, },	/* 72-22  E4B4  莇 */
	{ 0x6837, 0x838A, },	/* 72-23  E4B5  莊 */
	{ 0x6838, 0x837C, },	/* 72-24  E4B6  荼 */
	{ 0x6839, 0x83B5, },	/* 72-25  E4B7  莵 */
	{ 0x683A, 0x8373, },	/* 72-26  E4B8  荳 */
	{ 0x683B, 0x8375, },	/* 72-27  E4B9  荵 */
	{ 0x683C, 0x83A0, },	/* 72-28  E4BA  莠 */
	{ 0x683D, 0x8389, },	/* 72-29  E4BB  莉 */
	{ 0x683E, 0x83A8, },	/* 72-30  E4BC  莨 */
	{ 0x683F, 0x83F4, },	/* 72-31  E4BD  菴 */
	{ 0x6840, 0x8413, },	/* 72-32  E4BE  萓 */
	{ 0x6841, 0x83EB, },	/* 72-33  E4BF  菫 */
	{ 0x6842, 0x83CE, },	/* 72-34  E4C0  菎 */
	{ 0x6843, 0x83FD, },	/* 72-35  E4C1  菽 */
	{ 0x6844, 0x8403, },	/* 72-36  E4C2  萃 */
	{ 0x6845, 0x83D8, },	/* 72-37  E4C3  菘 */
	{ 0x6846, 0x840B, },	/* 72-38  E4C4  萋 */
	{ 0x6847, 0x83C1, },	/* 72-39  E4C5  菁 */
	{ 0x6848, 0x83F7, },	/* 72-40  E4C6  菷 */
	{ 0x6849, 0x8407, },	/* 72-41  E4C7  萇 */
	{ 0x684A, 0x83E0, },	/* 72-42  E4C8  菠 */
	{ 0x684B, 0x83F2, },	/* 72-43  E4C9  菲 */
	{ 0x684C, 0x840D, },	/* 72-44  E4CA  萍 */
	{ 0x684D, 0x8422, },	/* 72-45  E4CB  萢 */
	{ 0x684E, 0x8420, },	/* 72-46  E4CC  萠 */
	{ 0x684F, 0x83BD, },	/* 72-47  E4CD  莽 */
	{ 0x6850, 0x8438, },	/* 72-48  E4CE  萸 */
	{ 0x6851, 0x8506, },	/* 72-49  E4CF  蔆 */
	{ 0x6852, 0x83FB, },	/* 72-50  E4D0  菻 */
	{ 0x6853, 0x846D, },	/* 72-51  E4D1  葭 */
	{ 0x6854, 0x842A, },	/* 72-52  E4D2  萪 */
	{ 0x6855, 0x843C, },	/* 72-53  E4D3  萼 */
	{ 0x6856, 0x855A, },	/* 72-54  E4D4  蕚 */
	{ 0x6857, 0x8484, },	/* 72-55  E4D5  蒄 */
	{ 0x6858, 0x8477, },	/* 72-56  E4D6  葷 */
	{ 0x6859, 0x846B, },	/* 72-57  E4D7  葫 */
	{ 0x685A, 0x84AD, },	/* 72-58  E4D8  蒭 */
	{ 0x685B, 0x846E, },	/* 72-59  E4D9  葮 */
	{ 0x685C, 0x8482, },	/* 72-60  E4DA  蒂 */
	{ 0x685D, 0x8469, },	/* 72-61  E4DB  葩 */
	{ 0x685E, 0x8446, },	/* 72-62  E4DC  葆 */
	{ 0x685F, 0x842C, },	/* 72-63  E4DD  萬 */
	{ 0x6860, 0x846F, },	/* 72-64  E4DE  葯 */
	{ 0x6861, 0x8479, },	/* 72-65  E4DF  葹 */
	{ 0x6862, 0x8435, },	/* 72-66  E4E0  萵 */
	{ 0x6863, 0x84CA, },	/* 72-67  E4E1  蓊 */
	{ 0x6864, 0x8462, },	/* 72-68  E4E2  葢 */
	{ 0x6865, 0x84B9, },	/* 72-69  E4E3  蒹 */
	{ 0x6866, 0x84BF, },	/* 72-70  E4E4  蒿 */
	{ 0x6867, 0x849F, },	/* 72-71  E4E5  蒟 */
	{ 0x6868, 0x84D9, },	/* 72-72  E4E6  蓙 */
	{ 0x6869, 0x84CD, },	/* 72-73  E4E7  蓍 */
	{ 0x686A, 0x84BB, },	/* 72-74  E4E8  蒻 */
	{ 0x686B, 0x84DA, },	/* 72-75  E4E9  蓚 */
	{ 0x686C, 0x84D0, },	/* 72-76  E4EA  蓐 */
	{ 0x686D, 0x84C1, },	/* 72-77  E4EB  蓁 */
	{ 0x686E, 0x84C6, },	/* 72-78  E4EC  蓆 */
	{ 0x686F, 0x84D6, },	/* 72-79  E4ED  蓖 */
	{ 0x6870, 0x84A1, },	/* 72-80  E4EE  蒡 */
	{ 0x6871, 0x8521, },	/* 72-81  E4EF  蔡 */
	{ 0x6872, 0x84FF, },	/* 72-82  E4F0  蓿 */
	{ 0x6873, 0x84F4, },	/* 72-83  E4F1  蓴 */
	{ 0x6874, 0x8517, },	/* 72-84  E4F2  蔗 */
	{ 0x6875, 0x8518, },	/* 72-85  E4F3  蔘 */
	{ 0x6876, 0x852C, },	/* 72-86  E4F4  蔬 */
	{ 0x6877, 0x851F, },	/* 72-87  E4F5  蔟 */
	{ 0x6878, 0x8515, },	/* 72-88  E4F6  蔕 */
	{ 0x6879, 0x8514, },	/* 72-89  E4F7  蔔 */
	{ 0x687A, 0x84FC, },	/* 72-90  E4F8  蓼 */
	{ 0x687B, 0x8540, },	/* 72-91  E4F9  蕀 */
	{ 0x687C, 0x8563, },	/* 72-92  E4FA  蕣 */
	{ 0x687D, 0x8558, },	/* 72-93  E4FB  蕘 */
	{ 0x687E, 0x8548, },	/* 72-94  E4FC  蕈 */
	{ 0x6921, 0x8541, },	/* 73-01  E540  蕁 */
	{ 0x6922, 0x8602, },	/* 73-02  E541  蘂 */
	{ 0x6923, 0x854B, },	/* 73-03  E542  蕋 */
	{ 0x6924, 0x8555, },	/* 73-04  E543  蕕 */
	{ 0x6925, 0x8580, },	/* 73-05  E544  薀 */
	{ 0x6926, 0x85A4, },	/* 73-06  E545  薤 */
	{ 0x6927, 0x8588, },	/* 73-07  E546  薈 */
	{ 0x6928, 0x8591, },	/* 73-08  E547  薑 */
	{ 0x6929, 0x858A, },	/* 73-09  E548  薊 */
	{ 0x692A, 0x85A8, },	/* 73-10  E549  薨 */
	{ 0x692B, 0x856D, },	/* 73-11  E54A  蕭 */
	{ 0x692C, 0x8594, },	/* 73-12  E54B  薔 */
	{ 0x692D, 0x859B, },	/* 73-13  E54C  薛 */
	{ 0x692E, 0x85EA, },	/* 73-14  E54D  藪 */
	{ 0x692F, 0x8587, },	/* 73-15  E54E  薇 */
	{ 0x6930, 0x859C, },	/* 73-16  E54F  薜 */
	{ 0x6931, 0x8577, },	/* 73-17  E550  蕷 */
	{ 0x6932, 0x857E, },	/* 73-18  E551  蕾 */
	{ 0x6933, 0x8590, },	/* 73-19  E552  薐 */
	{ 0x6934, 0x85C9, },	/* 73-20  E553  藉 */
	{ 0x6935, 0x85BA, },	/* 73-21  E554  薺 */
	{ 0x6936, 0x85CF, },	/* 73-22  E555  藏 */
	{ 0x6937, 0x85B9, },	/* 73-23  E556  薹 */
	{ 0x6938, 0x85D0, },	/* 73-24  E557  藐 */
	{ 0x6939, 0x85D5, },	/* 73-25  E558  藕 */
	{ 0x693A, 0x85DD, },	/* 73-26  E559  藝 */
	{ 0x693B, 0x85E5, },	/* 73-27  E55A  藥 */
	{ 0x693C, 0x85DC, },	/* 73-28  E55B  藜 */
	{ 0x693D, 0x85F9, },	/* 73-29  E55C  藹 */
	{ 0x693E, 0x860A, },	/* 73-30  E55D  蘊 */
	{ 0x693F, 0x8613, },	/* 73-31  E55E  蘓 */
	{ 0x6940, 0x860B, },	/* 73-32  E55F  蘋 */
	{ 0x6941, 0x85FE, },	/* 73-33  E560  藾 */
	{ 0x6942, 0x85FA, },	/* 73-34  E561  藺 */
	{ 0x6943, 0x8606, },	/* 73-35  E562  蘆 */
	{ 0x6944, 0x8622, },	/* 73-36  E563  蘢 */
	{ 0x6945, 0x861A, },	/* 73-37  E564  蘚 */
	{ 0x6946, 0x8630, },	/* 73-38  E565  蘰 */
	{ 0x6947, 0x863F, },	/* 73-39  E566  蘿 */
	{ 0x6948, 0x864D, },	/* 73-40  E567  虍 */
	{ 0x6949, 0x4E55, },	/* 73-41  E568  乕 */
	{ 0x694A, 0x8654, },	/* 73-42  E569  虔 */
	{ 0x694B, 0x865F, },	/* 73-43  E56A  號 */
	{ 0x694C, 0x8667, },	/* 73-44  E56B  虧 */
	{ 0x694D, 0x8671, },	/* 73-45  E56C  虱 */
	{ 0x694E, 0x8693, },	/* 73-46  E56D  蚓 */
	{ 0x694F, 0x86A3, },	/* 73-47  E56E  蚣 */
	{ 0x6950, 0x86A9, },	/* 73-48  E56F  蚩 */
	{ 0x6951, 0x86AA, },	/* 73-49  E570  蚪 */
	{ 0x6952, 0x868B, },	/* 73-50  E571  蚋 */
	{ 0x6953, 0x868C, },	/* 73-51  E572  蚌 */
	{ 0x6954, 0x86B6, },	/* 73-52  E573  蚶 */
	{ 0x6955, 0x86AF, },	/* 73-53  E574  蚯 */
	{ 0x6956, 0x86C4, },	/* 73-54  E575  蛄 */
	{ 0x6957, 0x86C6, },	/* 73-55  E576  蛆 */
	{ 0x6958, 0x86B0, },	/* 73-56  E577  蚰 */
	{ 0x6959, 0x86C9, },	/* 73-57  E578  蛉 */
	{ 0x695A, 0x8823, },	/* 73-58  E579  蠣 */
	{ 0x695B, 0x86AB, },	/* 73-59  E57A  蚫 */
	{ 0x695C, 0x86D4, },	/* 73-60  E57B  蛔 */
	{ 0x695D, 0x86DE, },	/* 73-61  E57C  蛞 */
	{ 0x695E, 0x86E9, },	/* 73-62  E57D  蛩 */
	{ 0x695F, 0x86EC, },	/* 73-63  E57E  蛬 */
	{ 0x6960, 0x86DF, },	/* 73-64  E580  蛟 */
	{ 0x6961, 0x86DB, },	/* 73-65  E581  蛛 */
	{ 0x6962, 0x86EF, },	/* 73-66  E582  蛯 */
	{ 0x6963, 0x8712, },	/* 73-67  E583  蜒 */
	{ 0x6964, 0x8706, },	/* 73-68  E584  蜆 */
	{ 0x6965, 0x8708, },	/* 73-69  E585  蜈 */
	{ 0x6966, 0x8700, },	/* 73-70  E586  蜀 */
	{ 0x6967, 0x8703, },	/* 73-71  E587  蜃 */
	{ 0x6968, 0x86FB, },	/* 73-72  E588  蛻 */
	{ 0x6969, 0x8711, },	/* 73-73  E589  蜑 */
	{ 0x696A, 0x8709, },	/* 73-74  E58A  蜉 */
	{ 0x696B, 0x870D, },	/* 73-75  E58B  蜍 */
	{ 0x696C, 0x86F9, },	/* 73-76  E58C  蛹 */
	{ 0x696D, 0x870A, },	/* 73-77  E58D  蜊 */
	{ 0x696E, 0x8734, },	/* 73-78  E58E  蜴 */
	{ 0x696F, 0x873F, },	/* 73-79  E58F  蜿 */
	{ 0x6970, 0x8737, },	/* 73-80  E590  蜷 */
	{ 0x6971, 0x873B, },	/* 73-81  E591  蜻 */
	{ 0x6972, 0x8725, },	/* 73-82  E592  蜥 */
	{ 0x6973, 0x8729, },	/* 73-83  E593  蜩 */
	{ 0x6974, 0x871A, },	/* 73-84  E594  蜚 */
	{ 0x6975, 0x8760, },	/* 73-85  E595  蝠 */
	{ 0x6976, 0x875F, },	/* 73-86  E596  蝟 */
	{ 0x6977, 0x8778, },	/* 73-87  E597  蝸 */
	{ 0x6978, 0x874C, },	/* 73-88  E598  蝌 */
	{ 0x6979, 0x874E, },	/* 73-89  E599  蝎 */
	{ 0x697A, 0x8774, },	/* 73-90  E59A  蝴 */
	{ 0x697B, 0x8757, },	/* 73-91  E59B  蝗 */
	{ 0x697C, 0x8768, },	/* 73-92  E59C  蝨 */
	{ 0x697D, 0x876E, },	/* 73-93  E59D  蝮 */
	{ 0x697E, 0x8759, },	/* 73-94  E59E  蝙 */
	{ 0x6A21, 0x8753, },	/* 74-01  E59F  蝓 */
	{ 0x6A22, 0x8763, },	/* 74-02  E5A0  蝣 */
	{ 0x6A23, 0x876A, },	/* 74-03  E5A1  蝪 */
	{ 0x6A24, 0x8805, },	/* 74-04  E5A2  蠅 */
	{ 0x6A25, 0x87A2, },	/* 74-05  E5A3  螢 */
	{ 0x6A26, 0x879F, },	/* 74-06  E5A4  螟 */
	{ 0x6A27, 0x8782, },	/* 74-07  E5A5  螂 */
	{ 0x6A28, 0x87AF, },	/* 74-08  E5A6  螯 */
	{ 0x6A29, 0x87CB, },	/* 74-09  E5A7  蟋 */
	{ 0x6A2A, 0x87BD, },	/* 74-10  E5A8  螽 */
	{ 0x6A2B, 0x87C0, },	/* 74-11  E5A9  蟀 */
	{ 0x6A2C, 0x87D0, },	/* 74-12  E5AA  蟐 */
	{ 0x6A2D, 0x96D6, },	/* 74-13  E5AB  雖 */
	{ 0x6A2E, 0x87AB, },	/* 74-14  E5AC  螫 */
	{ 0x6A2F, 0x87C4, },	/* 74-15  E5AD  蟄 */
	{ 0x6A30, 0x87B3, },	/* 74-16  E5AE  螳 */
	{ 0x6A31, 0x87C7, },	/* 74-17  E5AF  蟇 */
	{ 0x6A32, 0x87C6, },	/* 74-18  E5B0  蟆 */
	{ 0x6A33, 0x87BB, },	/* 74-19  E5B1  螻 */
	{ 0x6A34, 0x87EF, },	/* 74-20  E5B2  蟯 */
	{ 0x6A35, 0x87F2, },	/* 74-21  E5B3  蟲 */
	{ 0x6A36, 0x87E0, },	/* 74-22  E5B4  蟠 */
	{ 0x6A37, 0x880F, },	/* 74-23  E5B5  蠏 */
	{ 0x6A38, 0x880D, },	/* 74-24  E5B6  蠍 */
	{ 0x6A39, 0x87FE, },	/* 74-25  E5B7  蟾 */
	{ 0x6A3A, 0x87F6, },	/* 74-26  E5B8  蟶 */
	{ 0x6A3B, 0x87F7, },	/* 74-27  E5B9  蟷 */
	{ 0x6A3C, 0x880E, },	/* 74-28  E5BA  蠎 */
	{ 0x6A3D, 0x87D2, },	/* 74-29  E5BB  蟒 */
	{ 0x6A3E, 0x8811, },	/* 74-30  E5BC  蠑 */
	{ 0x6A3F, 0x8816, },	/* 74-31  E5BD  蠖 */
	{ 0x6A40, 0x8815, },	/* 74-32  E5BE  蠕 */
	{ 0x6A41, 0x8822, },	/* 74-33  E5BF  蠢 */
	{ 0x6A42, 0x8821, },	/* 74-34  E5C0  蠡 */
	{ 0x6A43, 0x8831, },	/* 74-35  E5C1  蠱 */
	{ 0x6A44, 0x8836, },	/* 74-36  E5C2  蠶 */
	{ 0x6A45, 0x8839, },	/* 74-37  E5C3  蠹 */
	{ 0x6A46, 0x8827, },	/* 74-38  E5C4  蠧 */
	{ 0x6A47, 0x883B, },	/* 74-39  E5C5  蠻 */
	{ 0x6A48, 0x8844, },	/* 74-40  E5C6  衄 */
	{ 0x6A49, 0x8842, },	/* 74-41  E5C7  衂 */
	{ 0x6A4A, 0x8852, },	/* 74-42  E5C8  衒 */
	{ 0x6A4B, 0x8859, },	/* 74-43  E5C9  衙 */
	{ 0x6A4C, 0x885E, },	/* 74-44  E5CA  衞 */
	{ 0x6A4D, 0x8862, },	/* 74-45  E5CB  衢 */
	{ 0x6A4E, 0x886B, },	/* 74-46  E5CC  衫 */
	{ 0x6A4F, 0x8881, },	/* 74-47  E5CD  袁 */
	{ 0x6A50, 0x887E, },	/* 74-48  E5CE  衾 */
	{ 0x6A51, 0x889E, },	/* 74-49  E5CF  袞 */
	{ 0x6A52, 0x8875, },	/* 74-50  E5D0  衵 */
	{ 0x6A53, 0x887D, },	/* 74-51  E5D1  衽 */
	{ 0x6A54, 0x88B5, },	/* 74-52  E5D2  袵 */
	{ 0x6A55, 0x8872, },	/* 74-53  E5D3  衲 */
	{ 0x6A56, 0x8882, },	/* 74-54  E5D4  袂 */
	{ 0x6A57, 0x8897, },	/* 74-55  E5D5  袗 */
	{ 0x6A58, 0x8892, },	/* 74-56  E5D6  袒 */
	{ 0x6A59, 0x88AE, },	/* 74-57  E5D7  袮 */
	{ 0x6A5A, 0x8899, },	/* 74-58  E5D8  袙 */
	{ 0x6A5B, 0x88A2, },	/* 74-59  E5D9  袢 */
	{ 0x6A5C, 0x888D, },	/* 74-60  E5DA  袍 */
	{ 0x6A5D, 0x88A4, },	/* 74-61  E5DB  袤 */
	{ 0x6A5E, 0x88B0, },	/* 74-62  E5DC  袰 */
	{ 0x6A5F, 0x88BF, },	/* 74-63  E5DD  袿 */
	{ 0x6A60, 0x88B1, },	/* 74-64  E5DE  袱 */
	{ 0x6A61, 0x88C3, },	/* 74-65  E5DF  裃 */
	{ 0x6A62, 0x88C4, },	/* 74-66  E5E0  裄 */
	{ 0x6A63, 0x88D4, },	/* 74-67  E5E1  裔 */
	{ 0x6A64, 0x88D8, },	/* 74-68  E5E2  裘 */
	{ 0x6A65, 0x88D9, },	/* 74-69  E5E3  裙 */
	{ 0x6A66, 0x88DD, },	/* 74-70  E5E4  裝 */
	{ 0x6A67, 0x88F9, },	/* 74-71  E5E5  裹 */
	{ 0x6A68, 0x8902, },	/* 74-72  E5E6  褂 */
	{ 0x6A69, 0x88FC, },	/* 74-73  E5E7  裼 */
	{ 0x6A6A, 0x88F4, },	/* 74-74  E5E8  裴 */
	{ 0x6A6B, 0x88E8, },	/* 74-75  E5E9  裨 */
	{ 0x6A6C, 0x88F2, },	/* 74-76  E5EA  裲 */
	{ 0x6A6D, 0x8904, },	/* 74-77  E5EB  褄 */
	{ 0x6A6E, 0x890C, },	/* 74-78  E5EC  褌 */
	{ 0x6A6F, 0x890A, },	/* 74-79  E5ED  褊 */
	{ 0x6A70, 0x8913, },	/* 74-80  E5EE  褓 */
	{ 0x6A71, 0x8943, },	/* 74-81  E5EF  襃 */
	{ 0x6A72, 0x891E, },	/* 74-82  E5F0  褞 */
	{ 0x6A73, 0x8925, },	/* 74-83  E5F1  褥 */
	{ 0x6A74, 0x892A, },	/* 74-84  E5F2  褪 */
	{ 0x6A75, 0x892B, },	/* 74-85  E5F3  褫 */
	{ 0x6A76, 0x8941, },	/* 74-86  E5F4  襁 */
	{ 0x6A77, 0x8944, },	/* 74-87  E5F5  襄 */
	{ 0x6A78, 0x893B, },	/* 74-88  E5F6  褻 */
	{ 0x6A79, 0x8936, },	/* 74-89  E5F7  褶 */
	{ 0x6A7A, 0x8938, },	/* 74-90  E5F8  褸 */
	{ 0x6A7B, 0x894C, },	/* 74-91  E5F9  襌 */
	{ 0x6A7C, 0x891D, },	/* 74-92  E5FA  褝 */
	{ 0x6A7D, 0x8960, },	/* 74-93  E5FB  襠 */
	{ 0x6A7E, 0x895E, },	/* 74-94  E5FC  襞 */
	{ 0x6B21, 0x8966, },	/* 75-01  E640  襦 */
	{ 0x6B22, 0x8964, },	/* 75-02  E641  襤 */
	{ 0x6B23, 0x896D, },	/* 75-03  E642  襭 */
	{ 0x6B24, 0x896A, },	/* 75-04  E643  襪 */
	{ 0x6B25, 0x896F, },	/* 75-05  E644  襯 */
	{ 0x6B26, 0x8974, },	/* 75-06  E645  襴 */
	{ 0x6B27, 0x8977, },	/* 75-07  E646  襷 */
	{ 0x6B28, 0x897E, },	/* 75-08  E647  襾 */
	{ 0x6B29, 0x8983, },	/* 75-09  E648  覃 */
	{ 0x6B2A, 0x8988, },	/* 75-10  E649  覈 */
	{ 0x6B2B, 0x898A, },	/* 75-11  E64A  覊 */
	{ 0x6B2C, 0x8993, },	/* 75-12  E64B  覓 */
	{ 0x6B2D, 0x8998, },	/* 75-13  E64C  覘 */
	{ 0x6B2E, 0x89A1, },	/* 75-14  E64D  覡 */
	{ 0x6B2F, 0x89A9, },	/* 75-15  E64E  覩 */
	{ 0x6B30, 0x89A6, },	/* 75-16  E64F  覦 */
	{ 0x6B31, 0x89AC, },	/* 75-17  E650  覬 */
	{ 0x6B32, 0x89AF, },	/* 75-18  E651  覯 */
	{ 0x6B33, 0x89B2, },	/* 75-19  E652  覲 */
	{ 0x6B34, 0x89BA, },	/* 75-20  E653  覺 */
	{ 0x6B35, 0x89BD, },	/* 75-21  E654  覽 */
	{ 0x6B36, 0x89BF, },	/* 75-22  E655  覿 */
	{ 0x6B37, 0x89C0, },	/* 75-23  E656  觀 */
	{ 0x6B38, 0x89DA, },	/* 75-24  E657  觚 */
	{ 0x6B39, 0x89DC, },	/* 75-25  E658  觜 */
	{ 0x6B3A, 0x89DD, },	/* 75-26  E659  觝 */
	{ 0x6B3B, 0x89E7, },	/* 75-27  E65A  觧 */
	{ 0x6B3C, 0x89F4, },	/* 75-28  E65B  觴 */
	{ 0x6B3D, 0x89F8, },	/* 75-29  E65C  觸 */
	{ 0x6B3E, 0x8A03, },	/* 75-30  E65D  訃 */
	{ 0x6B3F, 0x8A16, },	/* 75-31  E65E  訖 */
	{ 0x6B40, 0x8A10, },	/* 75-32  E65F  訐 */
	{ 0x6B41, 0x8A0C, },	/* 75-33  E660  訌 */
	{ 0x6B42, 0x8A1B, },	/* 75-34  E661  訛 */
	{ 0x6B43, 0x8A1D, },	/* 75-35  E662  訝 */
	{ 0x6B44, 0x8A25, },	/* 75-36  E663  訥 */
	{ 0x6B45, 0x8A36, },	/* 75-37  E664  訶 */
	{ 0x6B46, 0x8A41, },	/* 75-38  E665  詁 */
	{ 0x6B47, 0x8A5B, },	/* 75-39  E666  詛 */
	{ 0x6B48, 0x8A52, },	/* 75-40  E667  詒 */
	{ 0x6B49, 0x8A46, },	/* 75-41  E668  詆 */
	{ 0x6B4A, 0x8A48, },	/* 75-42  E669  詈 */
	{ 0x6B4B, 0x8A7C, },	/* 75-43  E66A  詼 */
	{ 0x6B4C, 0x8A6D, },	/* 75-44  E66B  詭 */
	{ 0x6B4D, 0x8A6C, },	/* 75-45  E66C  詬 */
	{ 0x6B4E, 0x8A62, },	/* 75-46  E66D  詢 */
	{ 0x6B4F, 0x8A85, },	/* 75-47  E66E  誅 */
	{ 0x6B50, 0x8A82, },	/* 75-48  E66F  誂 */
	{ 0x6B51, 0x8A84, },	/* 75-49  E670  誄 */
	{ 0x6B52, 0x8AA8, },	/* 75-50  E671  誨 */
	{ 0x6B53, 0x8AA1, },	/* 75-51  E672  誡 */
	{ 0x6B54, 0x8A91, },	/* 75-52  E673  誑 */
	{ 0x6B55, 0x8AA5, },	/* 75-53  E674  誥 */
	{ 0x6B56, 0x8AA6, },	/* 75-54  E675  誦 */
	{ 0x6B57, 0x8A9A, },	/* 75-55  E676  誚 */
	{ 0x6B58, 0x8AA3, },	/* 75-56  E677  誣 */
	{ 0x6B59, 0x8AC4, },	/* 75-57  E678  諄 */
	{ 0x6B5A, 0x8ACD, },	/* 75-58  E679  諍 */
	{ 0x6B5B, 0x8AC2, },	/* 75-59  E67A  諂 */
	{ 0x6B5C, 0x8ADA, },	/* 75-60  E67B  諚 */
	{ 0x6B5D, 0x8AEB, },	/* 75-61  E67C  諫 */
	{ 0x6B5E, 0x8AF3, },	/* 75-62  E67D  諳 */
	{ 0x6B5F, 0x8AE7, },	/* 75-63  E67E  諧 */
	{ 0x6B60, 0x8AE4, },	/* 75-64  E680  諤 */
	{ 0x6B61, 0x8AF1, },	/* 75-65  E681  諱 */
	{ 0x6B62, 0x8B14, },	/* 75-66  E682  謔 */
	{ 0x6B63, 0x8AE0, },	/* 75-67  E683  諠 */
	{ 0x6B64, 0x8AE2, },	/* 75-68  E684  諢 */
	{ 0x6B65, 0x8AF7, },	/* 75-69  E685  諷 */
	{ 0x6B66, 0x8ADE, },	/* 75-70  E686  諞 */
	{ 0x6B67, 0x8ADB, },	/* 75-71  E687  諛 */
	{ 0x6B68, 0x8B0C, },	/* 75-72  E688  謌 */
	{ 0x6B69, 0x8B07, },	/* 75-73  E689  謇 */
	{ 0x6B6A, 0x8B1A, },	/* 75-74  E68A  謚 */
	{ 0x6B6B, 0x8AE1, },	/* 75-75  E68B  諡 */
	{ 0x6B6C, 0x8B16, },	/* 75-76  E68C  謖 */
	{ 0x6B6D, 0x8B10, },	/* 75-77  E68D  謐 */
	{ 0x6B6E, 0x8B17, },	/* 75-78  E68E  謗 */
	{ 0x6B6F, 0x8B20, },	/* 75-79  E68F  謠 */
	{ 0x6B70, 0x8B33, },	/* 75-80  E690  謳 */
	{ 0x6B71, 0x97AB, },	/* 75-81  E691  鞫 */
	{ 0x6B72, 0x8B26, },	/* 75-82  E692  謦 */
	{ 0x6B73, 0x8B2B, },	/* 75-83  E693  謫 */
	{ 0x6B74, 0x8B3E, },	/* 75-84  E694  謾 */
	{ 0x6B75, 0x8B28, },	/* 75-85  E695  謨 */
	{ 0x6B76, 0x8B41, },	/* 75-86  E696  譁 */
	{ 0x6B77, 0x8B4C, },	/* 75-87  E697  譌 */
	{ 0x6B78, 0x8B4F, },	/* 75-88  E698  譏 */
	{ 0x6B79, 0x8B4E, },	/* 75-89  E699  譎 */
	{ 0x6B7A, 0x8B49, },	/* 75-90  E69A  證 */
	{ 0x6B7B, 0x8B56, },	/* 75-91  E69B  譖 */
	{ 0x6B7C, 0x8B5B, },	/* 75-92  E69C  譛 */
	{ 0x6B7D, 0x8B5A, },	/* 75-93  E69D  譚 */
	{ 0x6B7E, 0x8B6B, },	/* 75-94  E69E  譫 */
	{ 0x6C21, 0x8B5F, },	/* 76-01  E69F  譟 */
	{ 0x6C22, 0x8B6C, },	/* 76-02  E6A0  譬 */
	{ 0x6C23, 0x8B6F, },	/* 76-03  E6A1  譯 */
	{ 0x6C24, 0x8B74, },	/* 76-04  E6A2  譴 */
	{ 0x6C25, 0x8B7D, },	/* 76-05  E6A3  譽 */
	{ 0x6C26, 0x8B80, },	/* 76-06  E6A4  讀 */
	{ 0x6C27, 0x8B8C, },	/* 76-07  E6A5  讌 */
	{ 0x6C28, 0x8B8E, },	/* 76-08  E6A6  讎 */
	{ 0x6C29, 0x8B92, },	/* 76-09  E6A7  讒 */
	{ 0x6C2A, 0x8B93, },	/* 76-10  E6A8  讓 */
	{ 0x6C2B, 0x8B96, },	/* 76-11  E6A9  讖 */
	{ 0x6C2C, 0x8B99, },	/* 76-12  E6AA  讙 */
	{ 0x6C2D, 0x8B9A, },	/* 76-13  E6AB  讚 */
	{ 0x6C2E, 0x8C3A, },	/* 76-14  E6AC  谺 */
	{ 0x6C2F, 0x8C41, },	/* 76-15  E6AD  豁 */
	{ 0x6C30, 0x8C3F, },	/* 76-16  E6AE  谿 */
	{ 0x6C31, 0x8C48, },	/* 76-17  E6AF  豈 */
	{ 0x6C32, 0x8C4C, },	/* 76-18  E6B0  豌 */
	{ 0x6C33, 0x8C4E, },	/* 76-19  E6B1  豎 */
	{ 0x6C34, 0x8C50, },	/* 76-20  E6B2  豐 */
	{ 0x6C35, 0x8C55, },	/* 76-21  E6B3  豕 */
	{ 0x6C36, 0x8C62, },	/* 76-22  E6B4  豢 */
	{ 0x6C37, 0x8C6C, },	/* 76-23  E6B5  豬 */
	{ 0x6C38, 0x8C78, },	/* 76-24  E6B6  豸 */
	{ 0x6C39, 0x8C7A, },	/* 76-25  E6B7  豺 */
	{ 0x6C3A, 0x8C82, },	/* 76-26  E6B8  貂 */
	{ 0x6C3B, 0x8C89, },	/* 76-27  E6B9  貉 */
	{ 0x6C3C, 0x8C85, },	/* 76-28  E6BA  貅 */
	{ 0x6C3D, 0x8C8A, },	/* 76-29  E6BB  貊 */
	{ 0x6C3E, 0x8C8D, },	/* 76-30  E6BC  貍 */
	{ 0x6C3F, 0x8C8E, },	/* 76-31  E6BD  貎 */
	{ 0x6C40, 0x8C94, },	/* 76-32  E6BE  貔 */
	{ 0x6C41, 0x8C7C, },	/* 76-33  E6BF  豼 */
	{ 0x6C42, 0x8C98, },	/* 76-34  E6C0  貘 */
	{ 0x6C43, 0x621D, },	/* 76-35  E6C1  戝 */
	{ 0x6C44, 0x8CAD, },	/* 76-36  E6C2  貭 */
	{ 0x6C45, 0x8CAA, },	/* 76-37  E6C3  貪 */
	{ 0x6C46, 0x8CBD, },	/* 76-38  E6C4  貽 */
	{ 0x6C47, 0x8CB2, },	/* 76-39  E6C5  貲 */
	{ 0x6C48, 0x8CB3, },	/* 76-40  E6C6  貳 */
	{ 0x6C49, 0x8CAE, },	/* 76-41  E6C7  貮 */
	{ 0x6C4A, 0x8CB6, },	/* 76-42  E6C8  貶 */
	{ 0x6C4B, 0x8CC8, },	/* 76-43  E6C9  賈 */
	{ 0x6C4C, 0x8CC1, },	/* 76-44  E6CA  賁 */
	{ 0x6C4D, 0x8CE4, },	/* 76-45  E6CB  賤 */
	{ 0x6C4E, 0x8CE3, },	/* 76-46  E6CC  賣 */
	{ 0x6C4F, 0x8CDA, },	/* 76-47  E6CD  賚 */
	{ 0x6C50, 0x8CFD, },	/* 76-48  E6CE  賽 */
	{ 0x6C51, 0x8CFA, },	/* 76-49  E6CF  賺 */
	{ 0x6C52, 0x8CFB, },	/* 76-50  E6D0  賻 */
	{ 0x6C53, 0x8D04, },	/* 76-51  E6D1  贄 */
	{ 0x6C54, 0x8D05, },	/* 76-52  E6D2  贅 */
	{ 0x6C55, 0x8D0A, },	/* 76-53  E6D3  贊 */
	{ 0x6C56, 0x8D07, },	/* 76-54  E6D4  贇 */
	{ 0x6C57, 0x8D0F, },	/* 76-55  E6D5  贏 */
	{ 0x6C58, 0x8D0D, },	/* 76-56  E6D6  贍 */
	{ 0x6C59, 0x8D10, },	/* 76-57  E6D7  贐 */
	{ 0x6C5A, 0x9F4E, },	/* 76-58  E6D8  齎 */
	{ 0x6C5B, 0x8D13, },	/* 76-59  E6D9  贓 */
	{ 0x6C5C, 0x8CCD, },	/* 76-60  E6DA  賍 */
	{ 0x6C5D, 0x8D14, },	/* 76-61  E6DB  贔 */
	{ 0x6C5E, 0x8D16, },	/* 76-62  E6DC  贖 */
	{ 0x6C5F, 0x8D67, },	/* 76-63  E6DD  赧 */
	{ 0x6C60, 0x8D6D, },	/* 76-64  E6DE  赭 */
	{ 0x6C61, 0x8D71, },	/* 76-65  E6DF  赱 */
	{ 0x6C62, 0x8D73, },	/* 76-66  E6E0  赳 */
	{ 0x6C63, 0x8D81, },	/* 76-67  E6E1  趁 */
	{ 0x6C64, 0x8D99, },	/* 76-68  E6E2  趙 */
	{ 0x6C65, 0x8DC2, },	/* 76-69  E6E3  跂 */
	{ 0x6C66, 0x8DBE, },	/* 76-70  E6E4  趾 */
	{ 0x6C67, 0x8DBA, },	/* 76-71  E6E5  趺 */
	{ 0x6C68, 0x8DCF, },	/* 76-72  E6E6  跏 */
	{ 0x6C69, 0x8DDA, },	/* 76-73  E6E7  跚 */
	{ 0x6C6A, 0x8DD6, },	/* 76-74  E6E8  跖 */
	{ 0x6C6B, 0x8DCC, },	/* 76-75  E6E9  跌 */
	{ 0x6C6C, 0x8DDB, },	/* 76-76  E6EA  跛 */
	{ 0x6C6D, 0x8DCB, },	/* 76-77  E6EB  跋 */
	{ 0x6C6E, 0x8DEA, },	/* 76-78  E6EC  跪 */
	{ 0x6C6F, 0x8DEB, },	/* 76-79  E6ED  跫 */
	{ 0x6C70, 0x8DDF, },	/* 76-80  E6EE  跟 */
	{ 0x6C71, 0x8DE3, },	/* 76-81  E6EF  跣 */
	{ 0x6C72, 0x8DFC, },	/* 76-82  E6F0  跼 */
	{ 0x6C73, 0x8E08, },	/* 76-83  E6F1  踈 */
	{ 0x6C74, 0x8E09, },	/* 76-84  E6F2  踉 */
	{ 0x6C75, 0x8DFF, },	/* 76-85  E6F3  跿 */
	{ 0x6C76, 0x8E1D, },	/* 76-86  E6F4  踝 */
	{ 0x6C77, 0x8E1E, },	/* 76-87  E6F5  踞 */
	{ 0x6C78, 0x8E10, },	/* 76-88  E6F6  踐 */
	{ 0x6C79, 0x8E1F, },	/* 76-89  E6F7  踟 */
	{ 0x6C7A, 0x8E42, },	/* 76-90  E6F8  蹂 */
	{ 0x6C7B, 0x8E35, },	/* 76-91  E6F9  踵 */
	{ 0x6C7C, 0x8E30, },	/* 76-92  E6FA  踰 */
	{ 0x6C7D, 0x8E34, },	/* 76-93  E6FB  踴 */
	{ 0x6C7E, 0x8E4A, },	/* 76-94  E6FC  蹊 */
	{ 0x6D21, 0x8E47, },	/* 77-01  E740  蹇 */
	{ 0x6D22, 0x8E49, },	/* 77-02  E741  蹉 */
	{ 0x6D23, 0x8E4C, },	/* 77-03  E742  蹌 */
	{ 0x6D24, 0x8E50, },	/* 77-04  E743  蹐 */
	{ 0x6D25, 0x8E48, },	/* 77-05  E744  蹈 */
	{ 0x6D26, 0x8E59, },	/* 77-06  E745  蹙 */
	{ 0x6D27, 0x8E64, },	/* 77-07  E746  蹤 */
	{ 0x6D28, 0x8E60, },	/* 77-08  E747  蹠 */
	{ 0x6D29, 0x8E2A, },	/* 77-09  E748  踪 */
	{ 0x6D2A, 0x8E63, },	/* 77-10  E749  蹣 */
	{ 0x6D2B, 0x8E55, },	/* 77-11  E74A  蹕 */
	{ 0x6D2C, 0x8E76, },	/* 77-12  E74B  蹶 */
	{ 0x6D2D, 0x8E72, },	/* 77-13  E74C  蹲 */
	{ 0x6D2E, 0x8E7C, },	/* 77-14  E74D  蹼 */
	{ 0x6D2F, 0x8E81, },	/* 77-15  E74E  躁 */
	{ 0x6D30, 0x8E87, },	/* 77-16  E74F  躇 */
	{ 0x6D31, 0x8E85, },	/* 77-17  E750  躅 */
	{ 0x6D32, 0x8E84, },	/* 77-18  E751  躄 */
	{ 0x6D33, 0x8E8B, },	/* 77-19  E752  躋 */
	{ 0x6D34, 0x8E8A, },	/* 77-20  E753  躊 */
	{ 0x6D35, 0x8E93, },	/* 77-21  E754  躓 */
	{ 0x6D36, 0x8E91, },	/* 77-22  E755  躑 */
	{ 0x6D37, 0x8E94, },	/* 77-23  E756  躔 */
	{ 0x6D38, 0x8E99, },	/* 77-24  E757  躙 */
	{ 0x6D39, 0x8EAA, },	/* 77-25  E758  躪 */
	{ 0x6D3A, 0x8EA1, },	/* 77-26  E759  躡 */
	{ 0x6D3B, 0x8EAC, },	/* 77-27  E75A  躬 */
	{ 0x6D3C, 0x8EB0, },	/* 77-28  E75B  躰 */
	{ 0x6D3D, 0x8EC6, },	/* 77-29  E75C  軆 */
	{ 0x6D3E, 0x8EB1, },	/* 77-30  E75D  躱 */
	{ 0x6D3F, 0x8EBE, },	/* 77-31  E75E  躾 */
	{ 0x6D40, 0x8EC5, },	/* 77-32  E75F  軅 */
	{ 0x6D41, 0x8EC8, },	/* 77-33  E760  軈 */
	{ 0x6D42, 0x8ECB, },	/* 77-34  E761  軋 */
	{ 0x6D43, 0x8EDB, },	/* 77-35  E762  軛 */
	{ 0x6D44, 0x8EE3, },	/* 77-36  E763  軣 */
	{ 0x6D45, 0x8EFC, },	/* 77-37  E764  軼 */
	{ 0x6D46, 0x8EFB, },	/* 77-38  E765  軻 */
	{ 0x6D47, 0x8EEB, },	/* 77-39  E766  軫 */
	{ 0x6D48, 0x8EFE, },	/* 77-40  E767  軾 */
	{ 0x6D49, 0x8F0A, },	/* 77-41  E768  輊 */
	{ 0x6D4A, 0x8F05, },	/* 77-42  E769  輅 */
	{ 0x6D4B, 0x8F15, },	/* 77-43  E76A  輕 */
	{ 0x6D4C, 0x8F12, },	/* 77-44  E76B  輒 */
	{ 0x6D4D, 0x8F19, },	/* 77-45  E76C  輙 */
	{ 0x6D4E, 0x8F13, },	/* 77-46  E76D  輓 */
	{ 0x6D4F, 0x8F1C, },	/* 77-47  E76E  輜 */
	{ 0x6D50, 0x8F1F, },	/* 77-48  E76F  輟 */
	{ 0x6D51, 0x8F1B, },	/* 77-49  E770  輛 */
	{ 0x6D52, 0x8F0C, },	/* 77-50  E771  輌 */
	{ 0x6D53, 0x8F26, },	/* 77-51  E772  輦 */
	{ 0x6D54, 0x8F33, },	/* 77-52  E773  輳 */
	{ 0x6D55, 0x8F3B, },	/* 77-53  E774  輻 */
	{ 0x6D56, 0x8F39, },	/* 77-54  E775  輹 */
	{ 0x6D57, 0x8F45, },	/* 77-55  E776  轅 */
	{ 0x6D58, 0x8F42, },	/* 77-56  E777  轂 */
	{ 0x6D59, 0x8F3E, },	/* 77-57  E778  輾 */
	{ 0x6D5A, 0x8F4C, },	/* 77-58  E779  轌 */
	{ 0x6D5B, 0x8F49, },	/* 77-59  E77A  轉 */
	{ 0x6D5C, 0x8F46, },	/* 77-60  E77B  轆 */
	{ 0x6D5D, 0x8F4E, },	/* 77-61  E77C  轎 */
	{ 0x6D5E, 0x8F57, },	/* 77-62  E77D  轗 */
	{ 0x6D5F, 0x8F5C, },	/* 77-63  E77E  轜 */
	{ 0x6D60, 0x8F62, },	/* 77-64  E780  轢 */
	{ 0x6D61, 0x8F63, },	/* 77-65  E781  轣 */
	{ 0x6D62, 0x8F64, },	/* 77-66  E782  轤 */
	{ 0x6D63, 0x8F9C, },	/* 77-67  E783  辜 */
	{ 0x6D64, 0x8F9F, },	/* 77-68  E784  辟 */
	{ 0x6D65, 0x8FA3, },	/* 77-69  E785  辣 */
	{ 0x6D66, 0x8FAD, },	/* 77-70  E786  辭 */
	{ 0x6D67, 0x8FAF, },	/* 77-71  E787  辯 */
	{ 0x6D68, 0x8FB7, },	/* 77-72  E788  辷 */
	{ 0x6D69, 0x8FDA, },	/* 77-73  E789  迚 */
	{ 0x6D6A, 0x8FE5, },	/* 77-74  E78A  迥 */
	{ 0x6D6B, 0x8FE2, },	/* 77-75  E78B  迢 */
	{ 0x6D6C, 0x8FEA, },	/* 77-76  E78C  迪 */
	{ 0x6D6D, 0x8FEF, },	/* 77-77  E78D  迯 */
	{ 0x6D6E, 0x9087, },	/* 77-78  E78E  邇 */
	{ 0x6D6F, 0x8FF4, },	/* 77-79  E78F  迴 */
	{ 0x6D70, 0x9005, },	/* 77-80  E790  逅 */
	{ 0x6D71, 0x8FF9, },	/* 77-81  E791  迹 */
	{ 0x6D72, 0x8FFA, },	/* 77-82  E792  迺 */
	{ 0x6D73, 0x9011, },	/* 77-83  E793  逑 */
	{ 0x6D74, 0x9015, },	/* 77-84  E794  逕 */
	{ 0x6D75, 0x9021, },	/* 77-85  E795  逡 */
	{ 0x6D76, 0x900D, },	/* 77-86  E796  逍 */
	{ 0x6D77, 0x901E, },	/* 77-87  E797  逞 */
	{ 0x6D78, 0x9016, },	/* 77-88  E798  逖 */
	{ 0x6D79, 0x900B, },	/* 77-89  E799  逋 */
	{ 0x6D7A, 0x9027, },	/* 77-90  E79A  逧 */
	{ 0x6D7B, 0x9036, },	/* 77-91  E79B  逶 */
	{ 0x6D7C, 0x9035, },	/* 77-92  E79C  逵 */
	{ 0x6D7D, 0x9039, },	/* 77-93  E79D  逹 */
	{ 0x6D7E, 0x8FF8, },	/* 77-94  E79E  迸 */
	{ 0x6E21, 0x904F, },	/* 78-01  E79F  遏 */
	{ 0x6E22, 0x9050, },	/* 78-02  E7A0  遐 */
	{ 0x6E23, 0x9051, },	/* 78-03  E7A1  遑 */
	{ 0x6E24, 0x9052, },	/* 78-04  E7A2  遒 */
	{ 0x6E25, 0x900E, },	/* 78-05  E7A3  逎 */
	{ 0x6E26, 0x9049, },	/* 78-06  E7A4  遉 */
	{ 0x6E27, 0x903E, },	/* 78-07  E7A5  逾 */
	{ 0x6E28, 0x9056, },	/* 78-08  E7A6  遖 */
	{ 0x6E29, 0x9058, },	/* 78-09  E7A7  遘 */
	{ 0x6E2A, 0x905E, },	/* 78-10  E7A8  遞 */
	{ 0x6E2B, 0x9068, },	/* 78-11  E7A9  遨 */
	{ 0x6E2C, 0x906F, },	/* 78-12  E7AA  遯 */
	{ 0x6E2D, 0x9076, },	/* 78-13  E7AB  遶 */
	{ 0x6E2E, 0x96A8, },	/* 78-14  E7AC  隨 */
	{ 0x6E2F, 0x9072, },	/* 78-15  E7AD  遲 */
	{ 0x6E30, 0x9082, },	/* 78-16  E7AE  邂 */
	{ 0x6E31, 0x907D, },	/* 78-17  E7AF  遽 */
	{ 0x6E32, 0x9081, },	/* 78-18  E7B0  邁 */
	{ 0x6E33, 0x9080, },	/* 78-19  E7B1  邀 */
	{ 0x6E34, 0x908A, },	/* 78-20  E7B2  邊 */
	{ 0x6E35, 0x9089, },	/* 78-21  E7B3  邉 */
	{ 0x6E36, 0x908F, },	/* 78-22  E7B4  邏 */
	{ 0x6E37, 0x90A8, },	/* 78-23  E7B5  邨 */
	{ 0x6E38, 0x90AF, },	/* 78-24  E7B6  邯 */
	{ 0x6E39, 0x90B1, },	/* 78-25  E7B7  邱 */
	{ 0x6E3A, 0x90B5, },	/* 78-26  E7B8  邵 */
	{ 0x6E3B, 0x90E2, },	/* 78-27  E7B9  郢 */
	{ 0x6E3C, 0x90E4, },	/* 78-28  E7BA  郤 */
	{ 0x6E3D, 0x6248, },	/* 78-29  E7BB  扈 */
	{ 0x6E3E, 0x90DB, },	/* 78-30  E7BC  郛 */
	{ 0x6E3F, 0x9102, },	/* 78-31  E7BD  鄂 */
	{ 0x6E40, 0x9112, },	/* 78-32  E7BE  鄒 */
	{ 0x6E41, 0x9119, },	/* 78-33  E7BF  鄙 */
	{ 0x6E42, 0x9132, },	/* 78-34  E7C0  鄲 */
	{ 0x6E43, 0x9130, },	/* 78-35  E7C1  鄰 */
	{ 0x6E44, 0x914A, },	/* 78-36  E7C2  酊 */
	{ 0x6E45, 0x9156, },	/* 78-37  E7C3  酖 */
	{ 0x6E46, 0x9158, },	/* 78-38  E7C4  酘 */
	{ 0x6E47, 0x9163, },	/* 78-39  E7C5  酣 */
	{ 0x6E48, 0x9165, },	/* 78-40  E7C6  酥 */
	{ 0x6E49, 0x9169, },	/* 78-41  E7C7  酩 */
	{ 0x6E4A, 0x9173, },	/* 78-42  E7C8  酳 */
	{ 0x6E4B, 0x9172, },	/* 78-43  E7C9  酲 */
	{ 0x6E4C, 0x918B, },	/* 78-44  E7CA  醋 */
	{ 0x6E4D, 0x9189, },	/* 78-45  E7CB  醉 */
	{ 0x6E4E, 0x9182, },	/* 78-46  E7CC  醂 */
	{ 0x6E4F, 0x91A2, },	/* 78-47  E7CD  醢 */
	{ 0x6E50, 0x91AB, },	/* 78-48  E7CE  醫 */
	{ 0x6E51, 0x91AF, },	/* 78-49  E7CF  醯 */
	{ 0x6E52, 0x91AA, },	/* 78-50  E7D0  醪 */
	{ 0x6E53, 0x91B5, },	/* 78-51  E7D1  醵 */
	{ 0x6E54, 0x91B4, },	/* 78-52  E7D2  醴 */
	{ 0x6E55, 0x91BA, },	/* 78-53  E7D3  醺 */
	{ 0x6E56, 0x91C0, },	/* 78-54  E7D4  釀 */
	{ 0x6E57, 0x91C1, },	/* 78-55  E7D5  釁 */
	{ 0x6E58, 0x91C9, },	/* 78-56  E7D6  釉 */
	{ 0x6E59, 0x91CB, },	/* 78-57  E7D7  釋 */
	{ 0x6E5A, 0x91D0, },	/* 78-58  E7D8  釐 */
	{ 0x6E5B, 0x91D6, },	/* 78-59  E7D9  釖 */
	{ 0x6E5C, 0x91DF, },	/* 78-60  E7DA  釟 */
	{ 0x6E5D, 0x91E1, },	/* 78-61  E7DB  釡 */
	{ 0x6E5E, 0x91DB, },	/* 78-62  E7DC  釛 */
	{ 0x6E5F, 0x91FC, },	/* 78-63  E7DD  釼 */
	{ 0x6E60, 0x91F5, },	/* 78-64  E7DE  釵 */
	{ 0x6E61, 0x91F6, },	/* 78-65  E7DF  釶 */
	{ 0x6E62, 0x921E, },	/* 78-66  E7E0  鈞 */
	{ 0x6E63, 0x91FF, },	/* 78-67  E7E1  釿 */
	{ 0x6E64, 0x9214, },	/* 78-68  E7E2  鈔 */
	{ 0x6E65, 0x922C, },	/* 78-69  E7E3  鈬 */
	{ 0x6E66, 0x9215, },	/* 78-70  E7E4  鈕 */
	{ 0x6E67, 0x9211, },	/* 78-71  E7E5  鈑 */
	{ 0x6E68, 0x925E, },	/* 78-72  E7E6  鉞 */
	{ 0x6E69, 0x9257, },	/* 78-73  E7E7  鉗 */
	{ 0x6E6A, 0x9245, },	/* 78-74  E7E8  鉅 */
	{ 0x6E6B, 0x9249, },	/* 78-75  E7E9  鉉 */
	{ 0x6E6C, 0x9264, },	/* 78-76  E7EA  鉤 */
	{ 0x6E6D, 0x9248, },	/* 78-77  E7EB  鉈 */
	{ 0x6E6E, 0x9295, },	/* 78-78  E7EC  銕 */
	{ 0x6E6F, 0x923F, },	/* 78-79  E7ED  鈿 */
	{ 0x6E70, 0x924B, },	/* 78-80  E7EE  鉋 */
	{ 0x6E71, 0x9250, },	/* 78-81  E7EF  鉐 */
	{ 0x6E72, 0x929C, },	/* 78-82  E7F0  銜 */
	{ 0x6E73, 0x9296, },	/* 78-83  E7F1  銖 */
	{ 0x6E74, 0x9293, },	/* 78-84  E7F2  銓 */
	{ 0x6E75, 0x929B, },	/* 78-85  E7F3  銛 */
	{ 0x6E76, 0x925A, },	/* 78-86  E7F4  鉚 */
	{ 0x6E77, 0x92CF, },	/* 78-87  E7F5  鋏 */
	{ 0x6E78, 0x92B9, },	/* 78-88  E7F6  銹 */
	{ 0x6E79, 0x92B7, },	/* 78-89  E7F7  銷 */
	{ 0x6E7A, 0x92E9, },	/* 78-90  E7F8  鋩 */
	{ 0x6E7B, 0x930F, },	/* 78-91  E7F9  錏 */
	{ 0x6E7C, 0x92FA, },	/* 78-92  E7FA  鋺 */
	{ 0x6E7D, 0x9344, },	/* 78-93  E7FB  鍄 */
	{ 0x6E7E, 0x932E, },	/* 78-94  E7FC  錮 */
	{ 0x6F21, 0x9319, },	/* 79-01  E840  錙 */
	{ 0x6F22, 0x9322, },	/* 79-02  E841  錢 */
	{ 0x6F23, 0x931A, },	/* 79-03  E842  錚 */
	{ 0x6F24, 0x9323, },	/* 79-04  E843  錣 */
	{ 0x6F25, 0x933A, },	/* 79-05  E844  錺 */
	{ 0x6F26, 0x9335, },	/* 79-06  E845  錵 */
	{ 0x6F27, 0x933B, },	/* 79-07  E846  錻 */
	{ 0x6F28, 0x935C, },	/* 79-08  E847  鍜 */
	{ 0x6F29, 0x9360, },	/* 79-09  E848  鍠 */
	{ 0x6F2A, 0x937C, },	/* 79-10  E849  鍼 */
	{ 0x6F2B, 0x936E, },	/* 79-11  E84A  鍮 */
	{ 0x6F2C, 0x9356, },	/* 79-12  E84B  鍖 */
	{ 0x6F2D, 0x93B0, },	/* 79-13  E84C  鎰 */
	{ 0x6F2E, 0x93AC, },	/* 79-14  E84D  鎬 */
	{ 0x6F2F, 0x93AD, },	/* 79-15  E84E  鎭 */
	{ 0x6F30, 0x9394, },	/* 79-16  E84F  鎔 */
	{ 0x6F31, 0x93B9, },	/* 79-17  E850  鎹 */
	{ 0x6F32, 0x93D6, },	/* 79-18  E851  鏖 */
	{ 0x6F33, 0x93D7, },	/* 79-19  E852  鏗 */
	{ 0x6F34, 0x93E8, },	/* 79-20  E853  鏨 */
	{ 0x6F35, 0x93E5, },	/* 79-21  E854  鏥 */
	{ 0x6F36, 0x93D8, },	/* 79-22  E855  鏘 */
	{ 0x6F37, 0x93C3, },	/* 79-23  E856  鏃 */
	{ 0x6F38, 0x93DD, },	/* 79-24  E857  鏝 */
	{ 0x6F39, 0x93D0, },	/* 79-25  E858  鏐 */
	{ 0x6F3A, 0x93C8, },	/* 79-26  E859  鏈 */
	{ 0x6F3B, 0x93E4, },	/* 79-27  E85A  鏤 */
	{ 0x6F3C, 0x941A, },	/* 79-28  E85B  鐚 */
	{ 0x6F3D, 0x9414, },	/* 79-29  E85C  鐔 */
	{ 0x6F3E, 0x9413, },	/* 79-30  E85D  鐓 */
	{ 0x6F3F, 0x9403, },	/* 79-31  E85E  鐃 */
	{ 0x6F40, 0x9407, },	/* 79-32  E85F  鐇 */
	{ 0x6F41, 0x9410, },	/* 79-33  E860  鐐 */
	{ 0x6F42, 0x9436, },	/* 79-34  E861  鐶 */
	{ 0x6F43, 0x942B, },	/* 79-35  E862  鐫 */
	{ 0x6F44, 0x9435, },	/* 79-36  E863  鐵 */
	{ 0x6F45, 0x9421, },	/* 79-37  E864  鐡 */
	{ 0x6F46, 0x943A, },	/* 79-38  E865  鐺 */
	{ 0x6F47, 0x9441, },	/* 79-39  E866  鑁 */
	{ 0x6F48, 0x9452, },	/* 79-40  E867  鑒 */
	{ 0x6F49, 0x9444, },	/* 79-41  E868  鑄 */
	{ 0x6F4A, 0x945B, },	/* 79-42  E869  鑛 */
	{ 0x6F4B, 0x9460, },	/* 79-43  E86A  鑠 */
	{ 0x6F4C, 0x9462, },	/* 79-44  E86B  鑢 */
	{ 0x6F4D, 0x945E, },	/* 79-45  E86C  鑞 */
	{ 0x6F4E, 0x946A, },	/* 79-46  E86D  鑪 */
	{ 0x6F4F, 0x9229, },	/* 79-47  E86E  鈩 */
	{ 0x6F50, 0x9470, },	/* 79-48  E86F  鑰 */
	{ 0x6F51, 0x9475, },	/* 79-49  E870  鑵 */
	{ 0x6F52, 0x9477, },	/* 79-50  E871  鑷 */
	{ 0x6F53, 0x947D, },	/* 79-51  E872  鑽 */
	{ 0x6F54, 0x945A, },	/* 79-52  E873  鑚 */
	{ 0x6F55, 0x947C, },	/* 79-53  E874  鑼 */
	{ 0x6F56, 0x947E, },	/* 79-54  E875  鑾 */
	{ 0x6F57, 0x9481, },	/* 79-55  E876  钁 */
	{ 0x6F58, 0x947F, },	/* 79-56  E877  鑿 */
	{ 0x6F59, 0x9582, },	/* 79-57  E878  閂 */
	{ 0x6F5A, 0x9587, },	/* 79-58  E879  閇 */
	{ 0x6F5B, 0x958A, },	/* 79-59  E87A  閊 */
	{ 0x6F5C, 0x9594, },	/* 79-60  E87B  閔 */
	{ 0x6F5D, 0x9596, },	/* 79-61  E87C  閖 */
	{ 0x6F5E, 0x9598, },	/* 79-62  E87D  閘 */
	{ 0x6F5F, 0x9599, },	/* 79-63  E87E  閙 */
	{ 0x6F60, 0x95A0, },	/* 79-64  E880  閠 */
	{ 0x6F61, 0x95A8, },	/* 79-65  E881  閨 */
	{ 0x6F62, 0x95A7, },	/* 79-66  E882  閧 */
	{ 0x6F63, 0x95AD, },	/* 79-67  E883  閭 */
	{ 0x6F64, 0x95BC, },	/* 79-68  E884  閼 */
	{ 0x6F65, 0x95BB, },	/* 79-69  E885  閻 */
	{ 0x6F66, 0x95B9, },	/* 79-70  E886  閹 */
	{ 0x6F67, 0x95BE, },	/* 79-71  E887  閾 */
	{ 0x6F68, 0x95CA, },	/* 79-72  E888  闊 */
	{ 0x6F69, 0x6FF6, },	/* 79-73  E889  濶 */
	{ 0x6F6A, 0x95C3, },	/* 79-74  E88A  闃 */
	{ 0x6F6B, 0x95CD, },	/* 79-75  E88B  闍 */
	{ 0x6F6C, 0x95CC, },	/* 79-76  E88C  闌 */
	{ 0x6F6D, 0x95D5, },	/* 79-77  E88D  闕 */
	{ 0x6F6E, 0x95D4, },	/* 79-78  E88E  闔 */
	{ 0x6F6F, 0x95D6, },	/* 79-79  E88F  闖 */
	{ 0x6F70, 0x95DC, },	/* 79-80  E890  關 */
	{ 0x6F71, 0x95E1, },	/* 79-81  E891  闡 */
	{ 0x6F72, 0x95E5, },	/* 79-82  E892  闥 */
	{ 0x6F73, 0x95E2, },	/* 79-83  E893  闢 */
	{ 0x6F74, 0x9621, },	/* 79-84  E894  阡 */
	{ 0x6F75, 0x9628, },	/* 79-85  E895  阨 */
	{ 0x6F76, 0x962E, },	/* 79-86  E896  阮 */
	{ 0x6F77, 0x962F, },	/* 79-87  E897  阯 */
	{ 0x6F78, 0x9642, },	/* 79-88  E898  陂 */
	{ 0x6F79, 0x964C, },	/* 79-89  E899  陌 */
	{ 0x6F7A, 0x964F, },	/* 79-90  E89A  陏 */
	{ 0x6F7B, 0x964B, },	/* 79-91  E89B  陋 */
	{ 0x6F7C, 0x9677, },	/* 79-92  E89C  陷 */
	{ 0x6F7D, 0x965C, },	/* 79-93  E89D  陜 */
	{ 0x6F7E, 0x965E, },	/* 79-94  E89E  陞 */
	{ 0x7021, 0x965D, },	/* 80-01  E89F  陝 */
	{ 0x7022, 0x965F, },	/* 80-02  E8A0  陟 */
	{ 0x7023, 0x9666, },	/* 80-03  E8A1  陦 */
	{ 0x7024, 0x9672, },	/* 80-04  E8A2  陲 */
	{ 0x7025, 0x966C, },	/* 80-05  E8A3  陬 */
	{ 0x7026, 0x968D, },	/* 80-06  E8A4  隍 */
	{ 0x7027, 0x9698, },	/* 80-07  E8A5  隘 */
	{ 0x7028, 0x9695, },	/* 80-08  E8A6  隕 */
	{ 0x7029, 0x9697, },	/* 80-09  E8A7  隗 */
	{ 0x702A, 0x96AA, },	/* 80-10  E8A8  險 */
	{ 0x702B, 0x96A7, },	/* 80-11  E8A9  隧 */
	{ 0x702C, 0x96B1, },	/* 80-12  E8AA  隱 */
	{ 0x702D, 0x96B2, },	/* 80-13  E8AB  隲 */
	{ 0x702E, 0x96B0, },	/* 80-14  E8AC  隰 */
	{ 0x702F, 0x96B4, },	/* 80-15  E8AD  隴 */
	{ 0x7030, 0x96B6, },	/* 80-16  E8AE  隶 */
	{ 0x7031, 0x96B8, },	/* 80-17  E8AF  隸 */
	{ 0x7032, 0x96B9, },	/* 80-18  E8B0  隹 */
	{ 0x7033, 0x96CE, },	/* 80-19  E8B1  雎 */
	{ 0x7034, 0x96CB, },	/* 80-20  E8B2  雋 */
	{ 0x7035, 0x96C9, },	/* 80-21  E8B3  雉 */
	{ 0x7036, 0x96CD, },	/* 80-22  E8B4  雍 */
	{ 0x7037, 0x894D, },	/* 80-23  E8B5  襍 */
	{ 0x7038, 0x96DC, },	/* 80-24  E8B6  雜 */
	{ 0x7039, 0x970D, },	/* 80-25  E8B7  霍 */
	{ 0x703A, 0x96D5, },	/* 80-26  E8B8  雕 */
	{ 0x703B, 0x96F9, },	/* 80-27  E8B9  雹 */
	{ 0x703C, 0x9704, },	/* 80-28  E8BA  霄 */
	{ 0x703D, 0x9706, },	/* 80-29  E8BB  霆 */
	{ 0x703E, 0x9708, },	/* 80-30  E8BC  霈 */
	{ 0x703F, 0x9713, },	/* 80-31  E8BD  霓 */
	{ 0x7040, 0x970E, },	/* 80-32  E8BE  霎 */
	{ 0x7041, 0x9711, },	/* 80-33  E8BF  霑 */
	{ 0x7042, 0x970F, },	/* 80-34  E8C0  霏 */
	{ 0x7043, 0x9716, },	/* 80-35  E8C1  霖 */
	{ 0x7044, 0x9719, },	/* 80-36  E8C2  霙 */
	{ 0x7045, 0x9724, },	/* 80-37  E8C3  霤 */
	{ 0x7046, 0x972A, },	/* 80-38  E8C4  霪 */
	{ 0x7047, 0x9730, },	/* 80-39  E8C5  霰 */
	{ 0x7048, 0x9739, },	/* 80-40  E8C6  霹 */
	{ 0x7049, 0x973D, },	/* 80-41  E8C7  霽 */
	{ 0x704A, 0x973E, },	/* 80-42  E8C8  霾 */
	{ 0x704B, 0x9744, },	/* 80-43  E8C9  靄 */
	{ 0x704C, 0x9746, },	/* 80-44  E8CA  靆 */
	{ 0x704D, 0x9748, },	/* 80-45  E8CB  靈 */
	{ 0x704E, 0x9742, },	/* 80-46  E8CC  靂 */
	{ 0x704F, 0x9749, },	/* 80-47  E8CD  靉 */
	{ 0x7050, 0x975C, },	/* 80-48  E8CE  靜 */
	{ 0x7051, 0x9760, },	/* 80-49  E8CF  靠 */
	{ 0x7052, 0x9764, },	/* 80-50  E8D0  靤 */
	{ 0x7053, 0x9766, },	/* 80-51  E8D1  靦 */
	{ 0x7054, 0x9768, },	/* 80-52  E8D2  靨 */
	{ 0x7055, 0x52D2, },	/* 80-53  E8D3  勒 */
	{ 0x7056, 0x976B, },	/* 80-54  E8D4  靫 */
	{ 0x7057, 0x9771, },	/* 80-55  E8D5  靱 */
	{ 0x7058, 0x9779, },	/* 80-56  E8D6  靹 */
	{ 0x7059, 0x9785, },	/* 80-57  E8D7  鞅 */
	{ 0x705A, 0x977C, },	/* 80-58  E8D8  靼 */
	{ 0x705B, 0x9781, },	/* 80-59  E8D9  鞁 */
	{ 0x705C, 0x977A, },	/* 80-60  E8DA  靺 */
	{ 0x705D, 0x9786, },	/* 80-61  E8DB  鞆 */
	{ 0x705E, 0x978B, },	/* 80-62  E8DC  鞋 */
	{ 0x705F, 0x978F, },	/* 80-63  E8DD  鞏 */
	{ 0x7060, 0x9790, },	/* 80-64  E8DE  鞐 */
	{ 0x7061, 0x979C, },	/* 80-65  E8DF  鞜 */
	{ 0x7062, 0x97A8, },	/* 80-66  E8E0  鞨 */
	{ 0x7063, 0x97A6, },	/* 80-67  E8E1  鞦 */
	{ 0x7064, 0x97A3, },	/* 80-68  E8E2  鞣 */
	{ 0x7065, 0x97B3, },	/* 80-69  E8E3  鞳 */
	{ 0x7066, 0x97B4, },	/* 80-70  E8E4  鞴 */
	{ 0x7067, 0x97C3, },	/* 80-71  E8E5  韃 */
	{ 0x7068, 0x97C6, },	/* 80-72  E8E6  韆 */
	{ 0x7069, 0x97C8, },	/* 80-73  E8E7  韈 */
	{ 0x706A, 0x97CB, },	/* 80-74  E8E8  韋 */
	{ 0x706B, 0x97DC, },	/* 80-75  E8E9  韜 */
	{ 0x706C, 0x97ED, },	/* 80-76  E8EA  韭 */
	{ 0x706D, 0x9F4F, },	/* 80-77  E8EB  齏 */
	{ 0x706E, 0x97F2, },	/* 80-78  E8EC  韲 */
	{ 0x706F, 0x7ADF, },	/* 80-79  E8ED  竟 */
	{ 0x7070, 0x97F6, },	/* 80-80  E8EE  韶 */
	{ 0x7071, 0x97F5, },	/* 80-81  E8EF  韵 */
	{ 0x7072, 0x980F, },	/* 80-82  E8F0  頏 */
	{ 0x7073, 0x980C, },	/* 80-83  E8F1  頌 */
	{ 0x7074, 0x9838, },	/* 80-84  E8F2  頸 */
	{ 0x7075, 0x9824, },	/* 80-85  E8F3  頤 */
	{ 0x7076, 0x9821, },	/* 80-86  E8F4  頡 */
	{ 0x7077, 0x9837, },	/* 80-87  E8F5  頷 */
	{ 0x7078, 0x983D, },	/* 80-88  E8F6  頽 */
	{ 0x7079, 0x9846, },	/* 80-89  E8F7  顆 */
	{ 0x707A, 0x984F, },	/* 80-90  E8F8  顏 */
	{ 0x707B, 0x984B, },	/* 80-91  E8F9  顋 */
	{ 0x707C, 0x986B, },	/* 80-92  E8FA  顫 */
	{ 0x707D, 0x986F, },	/* 80-93  E8FB  顯 */
	{ 0x707E, 0x9870, },	/* 80-94  E8FC  顰 */
	{ 0x7121, 0x9871, },	/* 81-01  E940  顱 */
	{ 0x7122, 0x9874, },	/* 81-02  E941  顴 */
	{ 0x7123, 0x9873, },	/* 81-03  E942  顳 */
	{ 0x7124, 0x98AA, },	/* 81-04  E943  颪 */
	{ 0x7125, 0x98AF, },	/* 81-05  E944  颯 */
	{ 0x7126, 0x98B1, },	/* 81-06  E945  颱 */
	{ 0x7127, 0x98B6, },	/* 81-07  E946  颶 */
	{ 0x7128, 0x98C4, },	/* 81-08  E947  飄 */
	{ 0x7129, 0x98C3, },	/* 81-09  E948  飃 */
	{ 0x712A, 0x98C6, },	/* 81-10  E949  飆 */
	{ 0x712B, 0x98E9, },	/* 81-11  E94A  飩 */
	{ 0x712C, 0x98EB, },	/* 81-12  E94B  飫 */
	{ 0x712D, 0x9903, },	/* 81-13  E94C  餃 */
	{ 0x712E, 0x9909, },	/* 81-14  E94D  餉 */
	{ 0x712F, 0x9912, },	/* 81-15  E94E  餒 */
	{ 0x7130, 0x9914, },	/* 81-16  E94F  餔 */
	{ 0x7131, 0x9918, },	/* 81-17  E950  餘 */
	{ 0x7132, 0x9921, },	/* 81-18  E951  餡 */
	{ 0x7133, 0x991D, },	/* 81-19  E952  餝 */
	{ 0x7134, 0x991E, },	/* 81-20  E953  餞 */
	{ 0x7135, 0x9924, },	/* 81-21  E954  餤 */
	{ 0x7136, 0x9920, },	/* 81-22  E955  餠 */
	{ 0x7137, 0x992C, },	/* 81-23  E956  餬 */
	{ 0x7138, 0x992E, },	/* 81-24  E957  餮 */
	{ 0x7139, 0x993D, },	/* 81-25  E958  餽 */
	{ 0x713A, 0x993E, },	/* 81-26  E959  餾 */
	{ 0x713B, 0x9942, },	/* 81-27  E95A  饂 */
	{ 0x713C, 0x9949, },	/* 81-28  E95B  饉 */
	{ 0x713D, 0x9945, },	/* 81-29  E95C  饅 */
	{ 0x713E, 0x9950, },	/* 81-30  E95D  饐 */
	{ 0x713F, 0x994B, },	/* 81-31  E95E  饋 */
	{ 0x7140, 0x9951, },	/* 81-32  E95F  饑 */
	{ 0x7141, 0x9952, },	/* 81-33  E960  饒 */
	{ 0x7142, 0x994C, },	/* 81-34  E961  饌 */
	{ 0x7143, 0x9955, },	/* 81-35  E962  饕 */
	{ 0x7144, 0x9997, },	/* 81-36  E963  馗 */
	{ 0x7145, 0x9998, },	/* 81-37  E964  馘 */
	{ 0x7146, 0x99A5, },	/* 81-38  E965  馥 */
	{ 0x7147, 0x99AD, },	/* 81-39  E966  馭 */
	{ 0x7148, 0x99AE, },	/* 81-40  E967  馮 */
	{ 0x7149, 0x99BC, },	/* 81-41  E968  馼 */
	{ 0x714A, 0x99DF, },	/* 81-42  E969  駟 */
	{ 0x714B, 0x99DB, },	/* 81-43  E96A  駛 */
	{ 0x714C, 0x99DD, },	/* 81-44  E96B  駝 */
	{ 0x714D, 0x99D8, },	/* 81-45  E96C  駘 */
	{ 0x714E, 0x99D1, },	/* 81-46  E96D  駑 */
	{ 0x714F, 0x99ED, },	/* 81-47  E96E  駭 */
	{ 0x7150, 0x99EE, },	/* 81-48  E96F  駮 */
	{ 0x7151, 0x99F1, },	/* 81-49  E970  駱 */
	{ 0x7152, 0x99F2, },	/* 81-50  E971  駲 */
	{ 0x7153, 0x99FB, },	/* 81-51  E972  駻 */
	{ 0x7154, 0x99F8, },	/* 81-52  E973  駸 */
	{ 0x7155, 0x9A01, },	/* 81-53  E974  騁 */
	{ 0x7156, 0x9A0F, },	/* 81-54  E975  騏 */
	{ 0x7157, 0x9A05, },	/* 81-55  E976  騅 */
	{ 0x7158, 0x99E2, },	/* 81-56  E977  駢 */
	{ 0x7159, 0x9A19, },	/* 81-57  E978  騙 */
	{ 0x715A, 0x9A2B, },	/* 81-58  E979  騫 */
	{ 0x715B, 0x9A37, },	/* 81-59  E97A  騷 */
	{ 0x715C, 0x9A45, },	/* 81-60  E97B  驅 */
	{ 0x715D, 0x9A42, },	/* 81-61  E97C  驂 */
	{ 0x715E, 0x9A40, },	/* 81-62  E97D  驀 */
	{ 0x715F, 0x9A43, },	/* 81-63  E97E  驃 */
	{ 0x7160, 0x9A3E, },	/* 81-64  E980  騾 */
	{ 0x7161, 0x9A55, },	/* 81-65  E981  驕 */
	{ 0x7162, 0x9A4D, },	/* 81-66  E982  驍 */
	{ 0x7163, 0x9A5B, },	/* 81-67  E983  驛 */
	{ 0x7164, 0x9A57, },	/* 81-68  E984  驗 */
	{ 0x7165, 0x9A5F, },	/* 81-69  E985  驟 */
	{ 0x7166, 0x9A62, },	/* 81-70  E986  驢 */
	{ 0x7167, 0x9A65, },	/* 81-71  E987  驥 */
	{ 0x7168, 0x9A64, },	/* 81-72  E988  驤 */
	{ 0x7169, 0x9A69, },	/* 81-73  E989  驩 */
	{ 0x716A, 0x9A6B, },	/* 81-74  E98A  驫 */
	{ 0x716B, 0x9A6A, },	/* 81-75  E98B  驪 */
	{ 0x716C, 0x9AAD, },	/* 81-76  E98C  骭 */
	{ 0x716D, 0x9AB0, },	/* 81-77  E98D  骰 */
	{ 0x716E, 0x9ABC, },	/* 81-78  E98E  骼 */
	{ 0x716F, 0x9AC0, },	/* 81-79  E98F  髀 */
	{ 0x7170, 0x9ACF, },	/* 81-80  E990  髏 */
	{ 0x7171, 0x9AD1, },	/* 81-81  E991  髑 */
	{ 0x7172, 0x9AD3, },	/* 81-82  E992  髓 */
	{ 0x7173, 0x9AD4, },	/* 81-83  E993  體 */
	{ 0x7174, 0x9ADE, },	/* 81-84  E994  髞 */
	{ 0x7175, 0x9ADF, },	/* 81-85  E995  髟 */
	{ 0x7176, 0x9AE2, },	/* 81-86  E996  髢 */
	{ 0x7177, 0x9AE3, },	/* 81-87  E997  髣 */
	{ 0x7178, 0x9AE6, },	/* 81-88  E998  髦 */
	{ 0x7179, 0x9AEF, },	/* 81-89  E999  髯 */
	{ 0x717A, 0x9AEB, },	/* 81-90  E99A  髫 */
	{ 0x717B, 0x9AEE, },	/* 81-91  E99B  髮 */
	{ 0x717C, 0x9AF4, },	/* 81-92  E99C  髴 */
	{ 0x717D, 0x9AF1, },	/* 81-93  E99D  髱 */
	{ 0x717E, 0x9AF7, },	/* 81-94  E99E  髷 */
	{ 0x7221, 0x9AFB, },	/* 82-01  E99F  髻 */
	{ 0x7222, 0x9B06, },	/* 82-02  E9A0  鬆 */
	{ 0x7223, 0x9B18, },	/* 82-03  E9A1  鬘 */
	{ 0x7224, 0x9B1A, },	/* 82-04  E9A2  鬚 */
	{ 0x7225, 0x9B1F, },	/* 82-05  E9A3  鬟 */
	{ 0x7226, 0x9B22, },	/* 82-06  E9A4  鬢 */
	{ 0x7227, 0x9B23, },	/* 82-07  E9A5  鬣 */
	{ 0x7228, 0x9B25, },	/* 82-08  E9A6  鬥 */
	{ 0x7229, 0x9B27, },	/* 82-09  E9A7  鬧 */
	{ 0x722A, 0x9B28, },	/* 82-10  E9A8  鬨 */
	{ 0x722B, 0x9B29, },	/* 82-11  E9A9  鬩 */
	{ 0x722C, 0x9B2A, },	/* 82-12  E9AA  鬪 */
	{ 0x722D, 0x9B2E, },	/* 82-13  E9AB  鬮 */
	{ 0x722E, 0x9B2F, },	/* 82-14  E9AC  鬯 */
	{ 0x722F, 0x9B32, },	/* 82-15  E9AD  鬲 */
	{ 0x7230, 0x9B44, },	/* 82-16  E9AE  魄 */
	{ 0x7231, 0x9B43, },	/* 82-17  E9AF  魃 */
	{ 0x7232, 0x9B4F, },	/* 82-18  E9B0  魏 */
	{ 0x7233, 0x9B4D, },	/* 82-19  E9B1  魍 */
	{ 0x7234, 0x9B4E, },	/* 82-20  E9B2  魎 */
	{ 0x7235, 0x9B51, },	/* 82-21  E9B3  魑 */
	{ 0x7236, 0x9B58, },	/* 82-22  E9B4  魘 */
	{ 0x7237, 0x9B74, },	/* 82-23  E9B5  魴 */
	{ 0x7238, 0x9B93, },	/* 82-24  E9B6  鮓 */
	{ 0x7239, 0x9B83, },	/* 82-25  E9B7  鮃 */
	{ 0x723A, 0x9B91, },	/* 82-26  E9B8  鮑 */
	{ 0x723B, 0x9B96, },	/* 82-27  E9B9  鮖 */
	{ 0x723C, 0x9B97, },	/* 82-28  E9BA  鮗 */
	{ 0x723D, 0x9B9F, },	/* 82-29  E9BB  鮟 */
	{ 0x723E, 0x9BA0, },	/* 82-30  E9BC  鮠 */
	{ 0x723F, 0x9BA8, },	/* 82-31  E9BD  鮨 */
	{ 0x7240, 0x9BB4, },	/* 82-32  E9BE  鮴 */
	{ 0x7241, 0x9BC0, },	/* 82-33  E9BF  鯀 */
	{ 0x7242, 0x9BCA, },	/* 82-34  E9C0  鯊 */
	{ 0x7243, 0x9BB9, },	/* 82-35  E9C1  鮹 */
	{ 0x7244, 0x9BC6, },	/* 82-36  E9C2  鯆 */
	{ 0x7245, 0x9BCF, },	/* 82-37  E9C3  鯏 */
	{ 0x7246, 0x9BD1, },	/* 82-38  E9C4  鯑 */
	{ 0x7247, 0x9BD2, },	/* 82-39  E9C5  鯒 */
	{ 0x7248, 0x9BE3, },	/* 82-40  E9C6  鯣 */
	{ 0x7249, 0x9BE2, },	/* 82-41  E9C7  鯢 */
	{ 0x724A, 0x9BE4, },	/* 82-42  E9C8  鯤 */
	{ 0x724B, 0x9BD4, },	/* 82-43  E9C9  鯔 */
	{ 0x724C, 0x9BE1, },	/* 82-44  E9CA  鯡 */
	{ 0x724D, 0x9C3A, },	/* 82-45  E9CB  鰺 */
	{ 0x724E, 0x9BF2, },	/* 82-46  E9CC  鯲 */
	{ 0x724F, 0x9BF1, },	/* 82-47  E9CD  鯱 */
	{ 0x7250, 0x9BF0, },	/* 82-48  E9CE  鯰 */
	{ 0x7251, 0x9C15, },	/* 82-49  E9CF  鰕 */
	{ 0x7252, 0x9C14, },	/* 82-50  E9D0  鰔 */
	{ 0x7253, 0x9C09, },	/* 82-51  E9D1  鰉 */
	{ 0x7254, 0x9C13, },	/* 82-52  E9D2  鰓 */
	{ 0x7255, 0x9C0C, },	/* 82-53  E9D3  鰌 */
	{ 0x7256, 0x9C06, },	/* 82-54  E9D4  鰆 */
	{ 0x7257, 0x9C08, },	/* 82-55  E9D5  鰈 */
	{ 0x7258, 0x9C12, },	/* 82-56  E9D6  鰒 */
	{ 0x7259, 0x9C0A, },	/* 82-57  E9D7  鰊 */
	{ 0x725A, 0x9C04, },	/* 82-58  E9D8  鰄 */
	{ 0x725B, 0x9C2E, },	/* 82-59  E9D9  鰮 */
	{ 0x725C, 0x9C1B, },	/* 82-60  E9DA  鰛 */
	{ 0x725D, 0x9C25, },	/* 82-61  E9DB  鰥 */
	{ 0x725E, 0x9C24, },	/* 82-62  E9DC  鰤 */
	{ 0x725F, 0x9C21, },	/* 82-63  E9DD  鰡 */
	{ 0x7260, 0x9C30, },	/* 82-64  E9DE  鰰 */
	{ 0x7261, 0x9C47, },	/* 82-65  E9DF  鱇 */
	{ 0x7262, 0x9C32, },	/* 82-66  E9E0  鰲 */
	{ 0x7263, 0x9C46, },	/* 82-67  E9E1  鱆 */
	{ 0x7264, 0x9C3E, },	/* 82-68  E9E2  鰾 */
	{ 0x7265, 0x9C5A, },	/* 82-69  E9E3  鱚 */
	{ 0x7266, 0x9C60, },	/* 82-70  E9E4  鱠 */
	{ 0x7267, 0x9C67, },	/* 82-71  E9E5  鱧 */
	{ 0x7268, 0x9C76, },	/* 82-72  E9E6  鱶 */
	{ 0x7269, 0x9C78, },	/* 82-73  E9E7  鱸 */
	{ 0x726A, 0x9CE7, },	/* 82-74  E9E8  鳧 */
	{ 0x726B, 0x9CEC, },	/* 82-75  E9E9  鳬 */
	{ 0x726C, 0x9CF0, },	/* 82-76  E9EA  鳰 */
	{ 0x726D, 0x9D09, },	/* 82-77  E9EB  鴉 */
	{ 0x726E, 0x9D08, },	/* 82-78  E9EC  鴈 */
	{ 0x726F, 0x9CEB, },	/* 82-79  E9ED  鳫 */
	{ 0x7270, 0x9D03, },	/* 82-80  E9EE  鴃 */
	{ 0x7271, 0x9D06, },	/* 82-81  E9EF  鴆 */
	{ 0x7272, 0x9D2A, },	/* 82-82  E9F0  鴪 */
	{ 0x7273, 0x9D26, },	/* 82-83  E9F1  鴦 */
	{ 0x7274, 0x9DAF, },	/* 82-84  E9F2  鶯 */
	{ 0x7275, 0x9D23, },	/* 82-85  E9F3  鴣 */
	{ 0x7276, 0x9D1F, },	/* 82-86  E9F4  鴟 */
	{ 0x7277, 0x9D44, },	/* 82-87  E9F5  鵄 */
	{ 0x7278, 0x9D15, },	/* 82-88  E9F6  鴕 */
	{ 0x7279, 0x9D12, },	/* 82-89  E9F7  鴒 */
	{ 0x727A, 0x9D41, },	/* 82-90  E9F8  鵁 */
	{ 0x727B, 0x9D3F, },	/* 82-91  E9F9  鴿 */
	{ 0x727C, 0x9D3E, },	/* 82-92  E9FA  鴾 */
	{ 0x727D, 0x9D46, },	/* 82-93  E9FB  鵆 */
	{ 0x727E, 0x9D48, },	/* 82-94  E9FC  鵈 */
	{ 0x7321, 0x9D5D, },	/* 83-01  EA40  鵝 */
	{ 0x7322, 0x9D5E, },	/* 83-02  EA41  鵞 */
	{ 0x7323, 0x9D64, },	/* 83-03  EA42  鵤 */
	{ 0x7324, 0x9D51, },	/* 83-04  EA43  鵑 */
	{ 0x7325, 0x9D50, },	/* 83-05  EA44  鵐 */
	{ 0x7326, 0x9D59, },	/* 83-06  EA45  鵙 */
	{ 0x7327, 0x9D72, },	/* 83-07  EA46  鵲 */
	{ 0x7328, 0x9D89, },	/* 83-08  EA47  鶉 */
	{ 0x7329, 0x9D87, },	/* 83-09  EA48  鶇 */
	{ 0x732A, 0x9DAB, },	/* 83-10  EA49  鶫 */
	{ 0x732B, 0x9D6F, },	/* 83-11  EA4A  鵯 */
	{ 0x732C, 0x9D7A, },	/* 83-12  EA4B  鵺 */
	{ 0x732D, 0x9D9A, },	/* 83-13  EA4C  鶚 */
	{ 0x732E, 0x9DA4, },	/* 83-14  EA4D  鶤 */
	{ 0x732F, 0x9DA9, },	/* 83-15  EA4E  鶩 */
	{ 0x7330, 0x9DB2, },	/* 83-16  EA4F  鶲 */
	{ 0x7331, 0x9DC4, },	/* 83-17  EA50  鷄 */
	{ 0x7332, 0x9DC1, },	/* 83-18  EA51  鷁 */
	{ 0x7333, 0x9DBB, },	/* 83-19  EA52  鶻 */
	{ 0x7334, 0x9DB8, },	/* 83-20  EA53  鶸 */
	{ 0x7335, 0x9DBA, },	/* 83-21  EA54  鶺 */
	{ 0x7336, 0x9DC6, },	/* 83-22  EA55  鷆 */
	{ 0x7337, 0x9DCF, },	/* 83-23  EA56  鷏 */
	{ 0x7338, 0x9DC2, },	/* 83-24  EA57  鷂 */
	{ 0x7339, 0x9DD9, },	/* 83-25  EA58  鷙 */
	{ 0x733A, 0x9DD3, },	/* 83-26  EA59  鷓 */
	{ 0x733B, 0x9DF8, },	/* 83-27  EA5A  鷸 */
	{ 0x733C, 0x9DE6, },	/* 83-28  EA5B  鷦 */
	{ 0x733D, 0x9DED, },	/* 83-29  EA5C  鷭 */
	{ 0x733E, 0x9DEF, },	/* 83-30  EA5D  鷯 */
	{ 0x733F, 0x9DFD, },	/* 83-31  EA5E  鷽 */
	{ 0x7340, 0x9E1A, },	/* 83-32  EA5F  鸚 */
	{ 0x7341, 0x9E1B, },	/* 83-33  EA60  鸛 */
	{ 0x7342, 0x9E1E, },	/* 83-34  EA61  鸞 */
	{ 0x7343, 0x9E75, },	/* 83-35  EA62  鹵 */
	{ 0x7344, 0x9E79, },	/* 83-36  EA63  鹹 */
	{ 0x7345, 0x9E7D, },	/* 83-37  EA64  鹽 */
	{ 0x7346, 0x9E81, },	/* 83-38  EA65  麁 */
	{ 0x7347, 0x9E88, },	/* 83-39  EA66  麈 */
	{ 0x7348, 0x9E8B, },	/* 83-40  EA67  麋 */
	{ 0x7349, 0x9E8C, },	/* 83-41  EA68  麌 */
	{ 0x734A, 0x9E92, },	/* 83-42  EA69  麒 */
	{ 0x734B, 0x9E95, },	/* 83-43  EA6A  麕 */
	{ 0x734C, 0x9E91, },	/* 83-44  EA6B  麑 */
	{ 0x734D, 0x9E9D, },	/* 83-45  EA6C  麝 */
	{ 0x734E, 0x9EA5, },	/* 83-46  EA6D  麥 */
	{ 0x734F, 0x9EA9, },	/* 83-47  EA6E  麩 */
	{ 0x7350, 0x9EB8, },	/* 83-48  EA6F  麸 */
	{ 0x7351, 0x9EAA, },	/* 83-49  EA70  麪 */
	{ 0x7352, 0x9EAD, },	/* 83-50  EA71  麭 */
	{ 0x7353, 0x9761, },	/* 83-51  EA72  靡 */
	{ 0x7354, 0x9ECC, },	/* 83-52  EA73  黌 */
	{ 0x7355, 0x9ECE, },	/* 83-53  EA74  黎 */
	{ 0x7356, 0x9ECF, },	/* 83-54  EA75  黏 */
	{ 0x7357, 0x9ED0, },	/* 83-55  EA76  黐 */
	{ 0x7358, 0x9ED4, },	/* 83-56  EA77  黔 */
	{ 0x7359, 0x9EDC, },	/* 83-57  EA78  黜 */
	{ 0x735A, 0x9EDE, },	/* 83-58  EA79  點 */
	{ 0x735B, 0x9EDD, },	/* 83-59  EA7A  黝 */
	{ 0x735C, 0x9EE0, },	/* 83-60  EA7B  黠 */
	{ 0x735D, 0x9EE5, },	/* 83-61  EA7C  黥 */
	{ 0x735E, 0x9EE8, },	/* 83-62  EA7D  黨 */
	{ 0x735F, 0x9EEF, },	/* 83-63  EA7E  黯 */
	{ 0x7360, 0x9EF4, },	/* 83-64  EA80  黴 */
	{ 0x7361, 0x9EF6, },	/* 83-65  EA81  黶 */
	{ 0x7362, 0x9EF7, },	/* 83-66  EA82  黷 */
	{ 0x7363, 0x9EF9, },	/* 83-67  EA83  黹 */
	{ 0x7364, 0x9EFB, },	/* 83-68  EA84  黻 */
	{ 0x7365, 0x9EFC, },	/* 83-69  EA85  黼 */
	{ 0x7366, 0x9EFD, },	/* 83-70  EA86  黽 */
	{ 0x7367, 0x9F07, },	/* 83-71  EA87  鼇 */
	{ 0x7368, 0x9F08, },	/* 83-72  EA88  鼈 */
	{ 0x7369, 0x76B7, },	/* 83-73  EA89  皷 */
	{ 0x736A, 0x9F15, },	/* 83-74  EA8A  鼕 */
	{ 0x736B, 0x9F21, },	/* 83-75  EA8B  鼡 */
	{ 0x736C, 0x9F2C, },	/* 83-76  EA8C  鼬 */
	{ 0x736D, 0x9F3E, },	/* 83-77  EA8D  鼾 */
	{ 0x736E, 0x9F4A, },	/* 83-78  EA8E  齊 */
	{ 0x736F, 0x9F52, },	/* 83-79  EA8F  齒 */
	{ 0x7370, 0x9F54, },	/* 83-80  EA90  齔 */
	{ 0x7371, 0x9F63, },	/* 83-81  EA91  齣 */
	{ 0x7372, 0x9F5F, },	/* 83-82  EA92  齟 */
	{ 0x7373, 0x9F60, },	/* 83-83  EA93  齠 */
	{ 0x7374, 0x9F61, },	/* 83-84  EA94  齡 */
	{ 0x7375, 0x9F66, },	/* 83-85  EA95  齦 */
	{ 0x7376, 0x9F67, },	/* 83-86  EA96  齧 */
	{ 0x7377, 0x9F6C, },	/* 83-87  EA97  齬 */
	{ 0x7378, 0x9F6A, },	/* 83-88  EA98  齪 */
	{ 0x7379, 0x9F77, },	/* 83-89  EA99  齷 */
	{ 0x737A, 0x9F72, },	/* 83-90  EA9A  齲 */
	{ 0x737B, 0x9F76, },	/* 83-91  EA9B  齶 */
	{ 0x737C, 0x9F95, },	/* 83-92  EA9C  龕 */
	{ 0x737D, 0x9F9C, },	/* 83-93  EA9D  龜 */
	{ 0x737E, 0x9FA0, },	/* 83-94  EA9E  龠 */
	{ 0x7421, 0x582F, },	/* 84-01  EA9F  堯 */
	{ 0x7422, 0x69C7, },	/* 84-02  EAA0  槇 */
	{ 0x7423, 0x9059, },	/* 84-03  EAA1  遙 */
	{ 0x7424, 0x7464, },	/* 84-04  EAA2  瑤 */
	{ 0x7425, 0x51DC, },	/* 84-05  EAA3  凜 */
	{ 0x7426, 0x7199, },	/* 84-06  EAA4  熙 */

	{ 0x2141, 0xFF5E, },	/* 01-33  8160  ～ [FULLWIDTH TILDE] */
	{ 0x2142, 0x2225, },	/* 01-34  8161  ∥ [PARALLEL TO] */
	{ 0x213D, 0x2014, },	/* 01-29  815C  — [EM DASH] */
	{ 0x215D, 0xFF0D, },	/* 01-61  817C  － [FULLWIDTH HYPHEN-MINUS] */

	{ 0,      0,      },	/* terminater */
};
