/***************************************************************************

  memmap.h

  This include file contains definitions of memory addresses, I/O ports,
  dip switch settings, used by the emulation

***************************************************************************/

/***************************************************************************

Lady Bug memory map (preliminary)

0000-5fff ROM
6000-6fff RAM
d000-d3ff video RAM
d400-d7ff color RAM (4 bits wide)

memory mapped ports:

read:
9000      IN0
9001      IN1
9002      DSW1
9003      DSW2
8000      interrupt enable? (toggle)?

write:
7000-73ff sprites
a000      watchdog reset?
b000      sound port 1
c000      sound port 2

interrupts:
There is no vblank interrupt. The vblank status is read from IN1.
Coin insertion in left slot generates an interrupt, in right slot a NMI.

***************************************************************************/


#define ROM_END 0x5fff

#define VIDEO_RAM_START 0xd000
#define VIDEO_RAM_SIZE 0x400
#define COLOR_RAM_START (VIDEO_RAM_START+VIDEO_RAM_SIZE)

#define SPRITE_BASE 0x7000

#define SOUND_PORT_1 0xb000
#define SOUND_PORT_2 0xc000


/*
 * IN0 (all bits are inverted)
 * bit 7 : TILT if this is 0 coins are not accepted
 * bit 6 : START 2
 * bit 5 : START 1
 * bit 4 : FIRE player 1
 * bit 3 : UP player 1
 * bit 2 : RIGHT player 1
 * bit 1 : DOWN player 1
 * bit 0 : LEFT player 1
 */
#define IN0_PORT 0x9000
#define IN0_TILT (1<<7)
#define IN0_START2 (1<<6)
#define IN0_START1 (1<<5)
#define IN0_FIRE (1<<4)
#define IN0_UP (1<<3)
#define IN0_RIGHT (1<<2)
#define IN0_DOWN (1<<1)
#define IN0_LEFT (1<<0)

/*
 * IN1 (player input bits are inverted)
 * bit 7 : VBLANK
 * bit 6 : VBLANK inverted
 * bit 5 :
 * bit 4 : FIRE player 2 (TABLE only)
 * bit 3 : UP player 2 (TABLE only)
 * bit 2 : RIGHT player 2 (TABLE only)
 * bit 1 : DOWN player 2 (TABLE only)
 * bit 0 : LEFT player 2 (TABLE only)
 */
#define IN1_PORT 0x9001
#define IN1_VBLANK (1<<7)
#define IN1_NOT_VBLANK (1<<6)
#define IN1_UNKNOWN2 (1<<5)
#define IN1_FIRE (1<<4)
#define IN1_UP (1<<3)
#define IN1_RIGHT (1<<2)
#define IN1_DOWN (1<<1)
#define IN1_LEFT (1<<0)

/*
 * DSW1 (all bits are inverted)
 * bit 7 : DIP SWITCH 8  0 = 5 lives 1 = 3 lives
 * bit 6 : DIP SWITCH 7  Free Play
 * bit 5 : DIP SWITCH 6  TABLE or STANDUP (0 = STANDUP)
 * bit 4 : DIP SWITCH 5  Pause
 * bit 3 : DIP SWITCH 4  RACK TEST
 * bit 2 : DIP SWITCH 3  0 = 3 letter initials 1 = 10 letter initials
 * bit 1 : DIP SWITCH 2\ Difficulty level
 * bit 0 : DIP SWITCH 1/ 11 = 1st (easy) 10 = 2nd 01 = 3rd 00 = 4th (hard)
 */
#define DSW1_PORT 0x9002
#define DSW1_SW8 (1<<7)
#define DSW1_SW7 (1<<6)
#define DSW1_SW6 (1<<5)
#define DSW1_SW5 (1<<4)
#define DSW1_SW4 (1<<3)
#define DSW1_SW3 (1<<2)
#define DSW1_SW2 (1<<1)
#define DSW1_SW1 (1<<0)

#define DSW1_RACK_TEST (DSW1_SW4)

/*
 * DSW2 (all bits are inverted)
 * bit 7 : DIP SWITCH 8\
 * bit 6 : DIP SWITCH 7| Left coin slot
 * bit 5 : DIP SWITCH 6|
 * bit 4 : DIP SWITCH 5/
 * bit 3 : DIP SWITCH 4\
 * bit 2 : DIP SWITCH 3| Right coin slot
 * bit 1 : DIP SWITCH 2|
 * bit 0 : DIP SWITCH 1/
 *                       1111 = 1 coin 1 play
 *                       1110 = 1 coin 2 plays
 *                       1101 = 1 coin 3 plays
 *                       1100 = 1 coin 4 plays
 *                       1011 = 1 coin 5 plays
 *                       1010 = 2 coins 1 play
 *                       1001 = 2 coins 3 plays
 *                       1000 = 3 coins 1 play
 *                       0111 = 3 coins 2 plays
 *                       0110 = 4 coins 1 play
 *                 all others = 1 coin 1 play
 */
#define DSW2_PORT 0x9003
