#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Z80.h"
#include "machine.h"
#include "memmap.h"
#include "roms.h"
#include "osdepend.h"
#include "sndhrdw.h"


#define SND_CLOCK 4000000	/* 4 Mhz */


unsigned char samples[32] =	/* a simple sine (sort of) wave */
	{ 0x00,0x00,0x00,0x00,0x22,0x22,0x22,0x22,0x44,0x44,0x44,0x44,0x22,0x22,0x22,0x22,
	0x00,0x00,0x00,0x00,0xdd,0xdd,0xdd,0xdd,0xbb,0xbb,0xbb,0xbb,0xdd,0xdd,0xdd,0xdd };
/*
	{ 0x00,0x18,0x30,0x47,0x5a,0x6a,0x76,0x7d,0x7f,0x7d,0x76,0x6a,0x5a,0x47,0x30,0x18,
	0x00,0xe8,0xd0,0xb9,0xa6,0x96,0x8a,0x83,0x80,0x83,0x8a,0x96,0xa6,0xb9,0xd0,0xe8 };

	{ 0x80,0x88,0x90,0x98,0xa0,0xa8,0xb0,0xb8,0xc0,0xc8,0xd0,0xd8,0xe0,0xe8,0xf0,0xf8,
	0x00,0x08,0x10,0x18,0x20,0x28,0x30,0x38,0x40,0x48,0x50,0x58,0x60,0x68,0x70,0x78 };
*/


/***************************************************************************

  Initialize the sound hardware. Returns 0 if successful.

***************************************************************************/
int sh_init(const char *gamename)
{
/*
#include <math.h>
double i;

for (i = 0;i < 32;i++)
	printf("0x%02x,",(int)(128*(sin(2*i*PI/32)))&0xff);
*/
	return 0;
}



int sh_start(void)
{
	int i;


	for (i = 0;i < 6;i++)
		osd_play_sample(i,samples,32,1000,0,1);
	return 0;
}



void sh_stop(void)
{
}



/***************************************************************************

  Handle a write to memory.
  This function is called when the emulated code writes to RAM.

  Arguments:
  dword A - Memory address to write to.
  byte V - Value to write into memory.

  If the address given concerns the sound hardware, the write is performed
  (together with additional operations which might be required by the sound
  hardware) and the function returns non zero. Otherwise, it returns 0.

***************************************************************************/
int soundchanged;
int freqlo[6],freqhi[6],vol[6];

int sh_wrmem(dword A,byte V)
{
int voice;
static int lasttone[2];


if (A == SOUND_PORT_1 || A == SOUND_PORT_2)
{
	soundchanged = 1;
	if (A == SOUND_PORT_1) voice = 0;
	else voice = 1;

	if (V & 0x80)
	{
		switch ((V>>4)& 0x07)
		{
			case 0x0:
				freqlo[3*voice+0] = V&0x0f;
				lasttone[voice] = 0;
				break;
			case 0x1:
				vol[3*voice+0] = 0x0f-(V&0x0f);
				break;
			case 0x2:
				freqlo[3*voice+1] = V&0x0f;
				lasttone[voice] = 1;
				break;
			case 0x3:
				vol[3*voice+1] = 0x0f-(V&0x0f);
				break;
			case 0x4:
				freqlo[3*voice+2] = V&0x0f;
				lasttone[voice] = 2;
				break;
			case 0x5:
				vol[3*voice+2] = 0x0f-(V&0x0f);
				break;
			case 0x6:
				break;
			case 0x7:
				break;
		}
	}
	else freqhi[3*voice+lasttone[voice]] = V&0x3f;

	return 1;
}
	else return 0;
}



/***************************************************************************

  Execute an OUT instruction.

  If the port given concerns the sound hardware, the sound hardware processes
  it and the function returns non zero. Otherwise, it returns 0.

***************************************************************************/
int sh_doout(byte A,byte V)
{
	return 0;
}



/***************************************************************************

  Read a data port IN.

***************************************************************************/
int sh_doin(byte A,byte *V)
{
	return 0;
}



void sh_update(void)
{
	if (play_sound == 0) return;

	if (soundchanged)
	{
		int voice;


		soundchanged = 0;

		for (voice = 0;voice < 6;voice++)
		{
			int freq,volume;


			freq = freqlo[voice] | (freqhi[voice] << 4);
			if (freq) freq = SND_CLOCK / freq;

			volume = vol[voice];
			volume = (volume << 4) | volume;

			osd_adjust_sample(voice,freq,volume);
		}
	}

	osd_update_audio();
}
