#include "roms.h"


const struct RomModule ladybugrom[] =
{
	{ "lb1.cpu", 0x0000, 0x1000 },
	{ "lb2.cpu", 0x1000, 0x1000 },
	{ "lb3.cpu", 0x2000, 0x1000 },
	{ "lb4.cpu", 0x3000, 0x1000 },
	{ "lb5.cpu", 0x4000, 0x1000 },
	{ "lb6.cpu", 0x5000, 0x1000 },
	{ 0 }	/* end of table */
};


const struct DSW ladybugdsw[] =
{
	{ 0, 0x80, "LIVES", { "5", "3" }, 1 },
	{ 0, 0x03, "DIFFICULTY", { "HARDEST", "HARD", "MEDIUM", "EASY" }, 1 },
	{ 0, 0x04, "INITIALS", { "3 LETTERS", "10 LETTERS" } },
	{ -1 }
};



const struct GameInfo gameinfo[] =
{
	{ 0, ladybugrom, ladybugdsw, { 0xdf , 0xff } }	/* generic entry */
};




/* Here comes the definition of the names of the ROMs to load for the various games. */
/* We load character data at 0x0000-0x1fff sprite data at 0x2000-0x3fff. */
const struct RomModule ladybuggfx[] =
{
	{ "lb9.vid",  0x0000, 0x1000 },
	{ "lb10.vid", 0x1000, 0x1000 },
	{ "lb8.cpu",  0x2000, 0x1000 },
	{ "lb7.cpu",  0x3000, 0x1000 },
	{ 0 }	/* end of table */
};



struct GfxLayout charlayout =
{
	8,8,	/* 8*8 characters */
	512,	/* 512 characters */
	2,	/* 2 bits per pixel */
	512*8*8,	/* the two bitplanes are separated */
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	{ 0, 1, 2, 3, 4, 5, 6, 7 },
	8*8	/* every char takes 8 consecutive bytes */
};
struct GfxLayout spritelayout =
{
	16,16,	/* 16*16 sprites */
	128,	/* 128 sprites */
	2,	/* 2 bits per pixel */
	1,	/* the two bitplanes are packed in two consecutive bits */
	{ 23*16, 22*16, 21*16, 20*16, 19*16, 18*16, 17*16, 16*16,
			7*16, 6*16, 5*16, 4*16, 3*16, 2*16, 1*16, 0*16 },
	{ 8*16+14, 8*16+12, 8*16+10, 8*16+8, 8*16+6, 8*16+4, 8*16+2, 8*16+0,
			14, 12, 10, 8, 6, 4, 2, 0 },
	64*8	/* every sprite takes 64 consecutive bytes */
};



/* "What is the palette doing here", you might ask, "it's not a ROM!" */
/* Well, actually the palette and lookup table were stored in PROMs, whose */
/* image, unfortunately, is usually unavailable. So we have to supply our */
/* own. */
const unsigned char ladybugpalette[3 * TOTAL_COLORS] =
{
	0x00,0x00,0x00,	/* BLACK */
	0xdb,0x00,0x00,	/* RED */
	0xdb,0x49,0x00,	/* LTRED */
	0x00,0x92,0x00,	/* DKGRN */
	0xdb,0x92,0x00,	/* ORANGE */
	0x00,0xdb,0x00,	/* GREEN */
	0xdb,0xdb,0x00,	/* YELLOW */
	0xdb,0x92,0x49,	/* ORANGE2 */
	0x49,0xdb,0x49,	/* GRN2 */
	0xdb,0xdb,0x49,	/* YELLOW2 */
	0xdb,0x00,0x92,	/* PURPLE2 */
	0x92,0x92,0x92,	/* GRAY */
	0x92,0xdb,0x92,	/* LTGRN */
	0x00,0x00,0xdb,	/* BLUE */
	0x92,0x49,0xdb,	/* PURPLE */
	0x00,0x92,0xdb,	/* LTBLUE */
	0x92,0x92,0xdb,	/* LTPURPLE */
	0xdb,0x92,0xdb,	/* PINK */
	0x92,0xdb,0xdb,	/* CYAN */
	0xdb,0xdb,0xdb	/* WHITE */
};

enum {BLACK,RED,LTRED,DKGRN,ORANGE,GREEN,YELLOW,ORANGE2,GRN2,YELLOW2,
		PURPLE2,GRAY,LTGRN,BLUE,PURPLE,LTBLUE,LTPURPLE,PINK,CYAN,WHITE};

const unsigned char ladybugcolortable[4 * COLOR_CODES] =
{
	/* characters */
	BLACK,LTPURPLE,PINK,GRN2,	/* maze walls, doors */
	BLACK,RED,GREEN,YELLOW,		/* Lady Bug */
	BLACK,CYAN,WHITE,GRAY,		/* logo on title screen; CREDIT #; coin; dots */
	BLACK,WHITE,GRAY,ORANGE2,	/* top scores */
	BLACK,GREEN,LTGRN,DKGRN,	/* score */
	BLACK,GRN2,LTBLUE,PINK,		/* 2x 3x 5x; timer; PART # */
	BLACK,WHITE,YELLOW,PINK,	/* EXTRA; skull; timer */
	BLACK,BLACK,LTRED,PINK,		/* SPECIAL */

	/* sprites */
	BLACK,GREEN,RED,YELLOW,		/* Lady Bug; cucumber; parsley; red peper */
	BLACK,GREEN,PURPLE,WHITE,	/* 1st level monster; egg plant */
	BLACK,GREEN,PURPLE2,WHITE,	/* 2nd level monster; sweet potato */
	BLACK,YELLOW,ORANGE,WHITE,	/* 4th level monster */
	BLACK,LTGRN,GREEN,WHITE,	/* 3rd level monster; japanese radish; turnip; celery; horseradish */
	BLACK,YELLOW,ORANGE,WHITE,	/* 5th level monster; pumpkin; bamboo shoot; potato */
	BLACK,LTGRN,ORANGE,YELLOW,	/* 6th level monster; onion */
	BLACK,YELLOW,ORANGE,WHITE,	/* 7th level monster */
	BLACK,GREEN,CYAN,GRN2,		/* 8th level monster */
	BLACK,LTGRN,WHITE,YELLOW,	/* dead Lady Bug; chinese cabbage */
	BLACK,YELLOW2,ORANGE,WHITE,	/* mushroom */
	BLACK,GREEN,ORANGE,LTPURPLE,	/* carrot */
	BLACK,GREEN,RED,WHITE,		/* radish; tomato */
	BLACK,GREEN,BLUE,WHITE,
	BLACK,GREEN,YELLOW,WHITE,
	BLACK,YELLOW2,ORANGE,LTPURPLE	/* scores */
};



const struct GameVidInfo gamevidinfo[] =
{
	{ 0, ladybuggfx, &charlayout, &spritelayout, ladybugpalette, ladybugcolortable }	/* generic entry */
};
