
//
//	PAT dll
//
//	pat.dll		ASCII/S-JIS
//	patnt.dll	UNICODE
//

#pragma	once

#include <windows.h>

//	__cdecl
typedef	DWORD (__cdecl *DLLFUNCV)(void);
typedef	DWORD (__cdecl *DLLFUNCD1)(DWORD);
typedef	DWORD (__cdecl *DLLFUNCD2)(DWORD, DWORD);
typedef	DWORD (__cdecl *DLLFUNCD4)(DWORD, DWORD, DWORD, DWORD);
typedef	DWORD (__cdecl *DLLFUNCD5)(DWORD, DWORD, DWORD, DWORD, DWORD);

typedef void (__cdecl *WRITECALLBACK)(DWORD, DWORD);

class CPATDLL
{
private:
	HMODULE	hDll;
	
	DLLFUNCV	pat_init;
	DLLFUNCV	pat_reset;
	DLLFUNCD1	pat_load;
	DLLFUNCD2	pat_loadm;
	DLLFUNCD1	pat_isenable;
	DLLFUNCD1	pat_enable;
	DLLFUNCD1	pat_disable;
	DLLFUNCV	pat_disableall;
	DLLFUNCV	pat_run;
	DLLFUNCD4	pat_setmemory;
	DLLFUNCD5	pat_setmemorycb;
	DLLFUNCD1	pat_getname;
	DLLFUNCV	pat_getnumberofcodes;
	
public:
	CPATDLL(LPCTSTR lpFilename) {
		hDll = LoadLibrary(lpFilename);
		if (hDll) {
		
		pat_init = (DLLFUNCV) GetProcAddress(hDll, "pat_init");
		pat_reset = (DLLFUNCV) GetProcAddress(hDll, "pat_reset");
		pat_load = (DLLFUNCD1) GetProcAddress(hDll, "pat_load");
		pat_loadm = (DLLFUNCD2) GetProcAddress(hDll, "pat_loadm");
		pat_isenable = (DLLFUNCD1) GetProcAddress(hDll, "pat_isenable");
		pat_enable = (DLLFUNCD1) GetProcAddress(hDll, "pat_enable");
		pat_disable = (DLLFUNCD1) GetProcAddress(hDll, "pat_disable");
		pat_disableall = (DLLFUNCV) GetProcAddress(hDll, "pat_disableall");
		pat_run = (DLLFUNCV) GetProcAddress(hDll, "pat_run");
		pat_setmemory = (DLLFUNCD4) GetProcAddress(hDll, "pat_setmemory");
		pat_setmemorycb = (DLLFUNCD5) GetProcAddress(hDll, "pat_setmemorycb");
		pat_getname = (DLLFUNCD1) GetProcAddress(hDll, "pat_getname");
		pat_getnumberofcodes = (DLLFUNCV) GetProcAddress(hDll, "pat_getnumberofcodes");
		
		}
	}
	
	~CPATDLL() {
		if (hDll) {
			FreeLibrary(hDll);
			hDll = NULL;
		}
	}
	
	//	DLL̑݊mF
	BOOL IsDll(void) {
		return (hDll ? TRUE : FALSE);
	}
	
	//	
	BOOL Init(void) {
		return (hDll && pat_init) ? pat_init() : FALSE;
	}
	
	//	Zbg
	//	SetMemory̓e͕ێ
	//	R[h͔j
	BOOL Reset(void) {
		return (hDll && pat_reset) ? pat_reset() : FALSE;
	}
	
	//	[h(t@C)
	BOOL Load(LPTSTR f) {
		return (hDll && pat_reset) ? pat_load((DWORD) f) : FALSE;
	}
	
	//	[h()
	//	m = AhX
	//	s = TCY
	BOOL LoadMemory(LPVOID m, DWORD s) {
		return (hDll && pat_loadm) ? pat_loadm((DWORD) m, s) : FALSE;
	}
	
	//	R[hLf
	BOOL IsEnable(DWORD no) {
		return (hDll && pat_isenable) ? pat_isenable(no) : FALSE;
	}
	
	//	R[hL
	BOOL Enable(DWORD no) {
		return (hDll && pat_enable) ? pat_enable(no) : FALSE;
	}
	
	//	R[h
	BOOL Disable(DWORD no) {
		return (hDll && pat_disable) ? pat_disable(no) : FALSE;
	}
	
	//	SR[h
	BOOL DisableAll(void) {
		return (hDll && pat_disableall) ? pat_disableall() : FALSE;
	}
	
	//	R[hs(Lꂽ)
	BOOL Run(void) {
		return (hDll && pat_run) ? pat_run() : FALSE;
	}
	
	//	R[haa(t)bbbb(s`e)ݒ
	//	aa0x00`0xff܂œo^\(ő64KB*256)
	//	aa>0xffaabbbb̃tAhX(1̂)
	//	m͎ۂ̃io񂪂郁ւ̃AhX
	BOOL SetMemory(DWORD t, DWORD m, DWORD s, DWORD e) {
		return (hDll && pat_setmemory) ? pat_setmemory(t, m, s, e) : FALSE;
	}
	
	//	ύXꂽ̂m肽ꍇ(}bvhio)
	//	Ă΂ꂽ֐
	//	void __cdecl myio(DWORD adrs, DWORD data)
	//	pӂ
	//	SetMemoty(0, iomap, 0xfd00, 0xffff, (DWORD) myio)Ƃꍇ
	//	͈͓̔ŕύXꍇmyio()Ă΂
	BOOL SetMemory(DWORD t, DWORD m, DWORD s, DWORD e, DWORD cb) {
		return (hDll && pat_setmemorycb) ? pat_setmemorycb(t, m, s, e, cb) : FALSE;
	}
	
	//	#R[h擾
	LPTSTR GetName(DWORD no) {
		return (LPTSTR) ((hDll && pat_getname) ? pat_getname(no) : NULL);
	}
	
	//	R[h擾
	DWORD GetNumberOfCodes(void) {
		return (hDll && pat_getnumberofcodes) ? pat_getnumberofcodes() : 0;
	}
	
};

