
#include <windows.h>

#include "pat4c.h"

static HMODULE	hDll;

	DLLFUNCV	pat_init;
	DLLFUNCV	pat_reset;
	DLLFUNCD1	pat_load;
	DLLFUNCD2	pat_loadm;
	DLLFUNCD1	pat_isenable;
	DLLFUNCD1	pat_enable;
	DLLFUNCD1	pat_disable;
	DLLFUNCV	pat_disableall;
	DLLFUNCV	pat_run;
	DLLFUNCD4	pat_setmemory;
	DLLFUNCD1	pat_getname;
	DLLFUNCV	pat_getnumberofcodes;

BOOL CreatePatFunc(void)
{
	DWORD	check = 1;
#if _DEBUG
	hDll = LoadLibrary("patd.dll");
#else
	hDll = LoadLibrary("pat.dll");
#endif
	if (!hDll)
		return FALSE;
	
		pat_init = (DLLFUNCV) GetProcAddress(hDll, "pat_init");
		check &= pat_init ? 1 : 0;
		pat_reset = (DLLFUNCV) GetProcAddress(hDll, "pat_reset");
		check &= pat_reset ? 1 : 0;
		pat_load = (DLLFUNCD1) GetProcAddress(hDll, "pat_load");
		check &= pat_load ? 1 : 0;
		pat_loadm = (DLLFUNCD2) GetProcAddress(hDll, "pat_loadm");
		check &= pat_loadm  ? 1 : 0;
		pat_isenable = (DLLFUNCD1) GetProcAddress(hDll, "pat_isenable");
		check &= pat_isenable ? 1 : 0;
		pat_enable = (DLLFUNCD1) GetProcAddress(hDll, "pat_enable");
		check &=  pat_enable ? 1 : 0;
		pat_disable = (DLLFUNCD1) GetProcAddress(hDll, "pat_disable");
		check &=  pat_disable ? 1 : 0;
		pat_disableall = (DLLFUNCV) GetProcAddress(hDll, "pat_disableall");
		check &= pat_disableall ? 1 : 0;
		pat_run = (DLLFUNCV) GetProcAddress(hDll, "pat_run");
		check &= pat_run ? 1 : 0;
		pat_setmemory = (DLLFUNCD4) GetProcAddress(hDll, "pat_setmemory");
		check &= pat_setmemory ? 1 : 0;
		pat_getname = (DLLFUNCD1) GetProcAddress(hDll, "pat_getname");
		check &= pat_getname ? 1 : 0;
		pat_getnumberofcodes = (DLLFUNCV) GetProcAddress(hDll, "pat_getnumberofcodes");
		check &= pat_getnumberofcodes ? 1 : 0;
	
	if (!check) {
		FreeLibrary(hDll);
		hDll = NULL;
		return FALSE;
	}
	
	return TRUE;
}

BOOL pat_isdll(void)
{
	return (hDll ? TRUE : FALSE);
}

void ReleasePatDll(void)
{
	if (hDll) {
		FreeLibrary(hDll);
		hDll = NULL;
	}
}
