/************************************************************************/
/* QUASI88 --- PC-8801 emulator						*/
/*	Copyright (c) 1998-2012 Showzoh Fukunaga			*/
/*	All rights reserved.						*/
/*									*/
/*	  ̃\tǵAUNIX + X Window System ̊œ삷A	*/
/*	PC-8801 ̃G~[^łB					*/
/*									*/
/*	  ̃\tg̍쐬ɂAMarat Fayzullin fMSXA	*/
/*	Nicola Salmoria (MAME/XMAME project)  MAME/XMAMEA	*/
/*	݂뎁 PC6001V ̃\[XQlɂĂ炢܂B	*/
/*									*/
/*	Ӂ							*/
/*	  TEhhCóAMAME/XMAME ̃\[X𗬗pĂ܂B	*/
/*	̃̕\[X̒쌠́AMAME/XMAME `[邢̓\[X	*/
/*	LڂĂ钘҂ɂ܂B					*/
/*	  FMWFl[^́Afmgen ̃\[X𗬗pĂ܂B	*/
/*	̃̕\[X̒쌠́A cisc ɂ܂B		*/
/*									*/
/************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "quasi88.h"
#include "initval.h"

#include "pc88main.h"
#include "pc88sub.h"
#include "graph.h"
#include "memory.h"
#include "file-op.h"

#include "emu.h"
#include "drive.h"
#include "event.h"
#include "keyboard.h"
#include "monitor.h"
#include "snddrv.h"
#include "wait.h"
#include "status.h"
#include "suspend.h"
#include "snapshot.h"
#include "soundbd.h"
#include "screen.h"
#include "menu.h"
#include "pause.h"
#include "z80.h"
#include "intr.h"

#ifdef USE_PAT
#include "pat4c.h"
#endif

int	verbose_level	= DEFAULT_VERBOSE;	/* 璷x		*/
int	verbose_proc    = FALSE;		/* ̐is󋵂̕\	*/
int	verbose_z80	= FALSE;		/* Z80G[\	*/
int	verbose_io	= FALSE;		/* I/OANZX\*/
int	verbose_pio	= FALSE;		/* PIO ̕sgp\ */
int	verbose_fdc	= FALSE;		/* FDC[Wُ	*/
int	verbose_wait	= FALSE;		/* EGCgُ̈ */
int	verbose_suspend = FALSE;		/* TXyḧُ */
int	verbose_snd	= FALSE;		/* TEh̃bZ[W	*/

static	void	imagefile_all_open(int stateload);
static	void	imagefile_all_close(void);
static	void	status_override(void);

/***********************************************************************
 *
 *			QUASI88 C֐
 *
 ************************************************************************/
void	quasi88(void)
{
    quasi88_start();
    quasi88_main();
    quasi88_stop(TRUE);
}

/* =========================== C̏ ========================== */

#define	SET_PROC(n)	proc = n; if (verbose_proc) printf("\n"); fflush(NULL);
static	int	proc = 0;

void	quasi88_start(void)
{
    stateload_init();			/* Xe[g[h֘A	*/
    drive_init();			/* fBXÑ[N	*/
    /*  ́AXe[g[hJn܂łɏĂ		*/

    SET_PROC(1);

					/* G~[gp̊m	*/
    if (memory_allocate() == FALSE) { quasi88_exit(-1); }

    if (resume_flag) {			/* Xe[g[h		*/
	SET_PROC(2);
	if (stateload() == FALSE) {
	    fprintf(stderr, "stateload: Failed ! (filename = %s)\n",
		    filename_get_state());
	    quasi88_exit(-1);
	}
	if (verbose_proc) printf("Stateload...OK\n"); fflush(NULL);
    }
    SET_PROC(3);

					/* OtBbNVXe	*/
    if (screen_init() == FALSE) { quasi88_exit(-1); }
    SET_PROC(4);

					/* VXeCxg	*/
    event_init();			/* (screen_init ̌ŁI)	*/

    					/* TEhhCo	*/
    if (xmame_sound_start() == FALSE) {	quasi88_exit(-1); }
    SET_PROC(5);

   					/* EGCgp^C}[	*/
    if (wait_vsync_init() == FALSE) { quasi88_exit(-1); }
    SET_PROC(6);


    set_signal();			/* INTVOȉݒ	*/

    imagefile_all_open(resume_flag);	/* C[Wt@CSĊJ	*/

    					/* G~p[N	*/
    pc88main_init((resume_flag) ? INIT_STATELOAD : INIT_POWERON);
    pc88sub_init ((resume_flag) ? INIT_STATELOAD : INIT_POWERON);

    key_record_playback_init();		/* L[͋L^/Đ 	*/

    screen_snapshot_init();		/* XibvVbg֘A   */


    debuglog_init();
    profiler_init();

    emu_breakpoint_init();

    if (verbose_proc) printf("Running QUASI88...\n");
}

/* ======================== C̃C[v ======================= */

void	quasi88_main(void)
{
    for (;;) {

	/* Ỉ܂ŁAJԂĂё */

	if (quasi88_loop() == QUASI88_LOOP_EXIT) {
	    break;
	}

    }

    /* quasi88_loop() ́A 1t[ (VSYNC 11/60b) ɁA
       QUASI88_LOOP_ONE ԂĂB
       ̖߂l𔻒fāAȂ炩̏Ă悢B

       ܂A̎ QUASI88_LOOP_BUSY ԂĂ邱Ƃ邪A
       ̏ꍇ͋CɂɁAJԂĂяo𑱍s邱 */

}

/* ========================== ČЕt ========================= */

void	quasi88_stop(int normal_exit)
{
    if (normal_exit) {
	if (verbose_proc) printf("Shutting down.....\n");
    }

    /* ȑꍇAverbose ɂڍו\Ȃ΁AG[\ */
#define ERR_DISP(n)	((proc == (n)) && (verbose_proc == 0))

    switch (proc) {
    case 6:			/*  ɏIĂ */
	profiler_exit();
	debuglog_exit();
	screen_snapshot_exit();
	key_record_playback_exit();
	pc88main_term();
	pc88sub_term();
	imagefile_all_close();
	wait_vsync_exit();
	/* FALLTHROUGH */

    case 5:			/* ^C}[̏NG */
	if (ERR_DISP(5)) printf("timer initialize failed!\n");
	xmame_sound_stop();
	/* FALLTHROUGH */

    case 4:			/* TEh̏NG */
	if (ERR_DISP(4)) printf("sound system initialize failed!\n");
	event_exit();
	screen_exit();
	/* FALLTHROUGH */

    case 3:			/* OtBbN̏NG */
	if (ERR_DISP(3)) printf("graphic system initialize failed!\n");
	/* FALLTHROUGH */

    case 2:			/* Xe[g[hNG */
	/* FALLTHROUGH */

    case 1:			/* ̏NG */
	if (ERR_DISP(2)) printf("memory allocate failed!\n");
	memory_free();
	/* FALLTHROUGH */

    case 0:			/* I łɊ */
	break;
    }

    proc = 0;	/* ̊֐𑱂ČĂł薳悤ɁANAĂ */
}


/***********************************************************************
 * QUASI88 rI֐
 *	exit() ̑ɌĂڂB
 ************************************************************************/

#define	MAX_ATEXIT	(32)
static	void (*exit_function[MAX_ATEXIT])(void);

/*
 * ֐ő MAX_ATEXIT Ao^łBœo^֐́A
 * quasi88_exit() ĂяoɁAo^ƋtŁAĂяoB
 */
void	quasi88_atexit(void (*function)(void))
{
    int i;
    for (i=0; i<MAX_ATEXIT; i++) {
	if (exit_function[i] == NULL) {
	    exit_function[i] = function;
	    return;
	}
    }
    printf("quasi88_atexit: out of array\n");
    quasi88_exit(-1);
}

/*
 * quasi88 IB
 * quasi88_atexit() œo^֐ĂяoɁA exit() 
 */
void	quasi88_exit(int status)
{
    int i;

    quasi88_stop(FALSE);

    for (i=MAX_ATEXIT-1; i>=0; i--) {
	if (exit_function[i]) {
	    (*exit_function[i])();
	    exit_function[i] = NULL;
	}
    }

    exit(status);
}





/***********************************************************************
 * QUASI88C[v
 *	QUASI88_LOOP_EXIT Ԃ܂ŁAɌĂяoƁB
 * ߂l
 *	QUASI88_LOOP_EXIT c I
 *	QUASI88_LOOP_ONE  c 1t[oߎ (EFCgmȂΖ1/60b)
 *	QUASI88_LOOP_BUSY c LȊÓAȂ炩̃^C~O
 ************************************************************************/
int	quasi88_event_flags = EVENT_MODE_CHANGED;
static	int mode	= EXEC;		/* ݂̃[h */
static	int next_mode	= EXEC;		/* [hؑ֗v́A[h */

int	quasi88_loop(void)
{
    static enum {
	INIT,
	MAIN,
	WAIT,
    } step = INIT, step_after_wait = INIT;

    int stat;

    switch (step) {

    /* ======================== CjV ======================== */
    case INIT:
	profiler_lapse( PROF_LAPSE_RESET );

	/* [hύX́AKɗB[hύXtONA */
	quasi88_event_flags &= ~EVENT_MODE_CHANGED;
	mode = next_mode;

	/* OIȃ[hύX̏ */
	switch (mode) {
#ifndef	USE_MONITOR
	case MONITOR:	/* 肦ȂǁAÔ */
	    mode = PAUSE;
	    break;
#endif
	case QUIT:	/* QUIT ȂAC[vI */
	    return FALSE;
	}

	/* [hʃCjV */
	if (mode == EXEC) { xmame_sound_resume(); }
	else              { xmame_sound_suspend();}

	screen_switch();
	event_switch();
	keyboard_switch();

	switch (mode) {
	case EXEC:	emu_init();		break;

	case MENU:	menu_init();		break;
#ifdef	USE_MONITOR
	case MONITOR:	monitor_init();		break;
#endif
	case PAUSE:	pause_init();		break;
	}

	status_override();

	wait_vsync_switch();


	/* CjVAMAIN ɑJ */
	step = MAIN;

	/* Jڂ邽߁AU֐𔲂 (FALLTHROUGHł) */
	return QUASI88_LOOP_BUSY;


    /* ======================== C ======================== */
    case MAIN:
	switch (mode) {

	case EXEC:	profiler_lapse( PROF_LAPSE_RESET );
			emu_main();
#ifdef USE_PAT
		if (pat_isdll())
			pat_run();
#endif
		break;
#ifdef	USE_MONITOR
	case MONITOR:	monitor_main();		break;
#endif
	case MENU:	menu_main();		break;

	case PAUSE:	pause_main();		break;
	}

	/* [hύXĂA(WAIT) INIT ֑Jڂ */
	/* łȂ΁A            (WAIT) MAIN ֑Jڂ */
	if (quasi88_event_flags & EVENT_MODE_CHANGED) {
	    step_after_wait = INIT;
	} else {
	    step_after_wait = MAIN;
	}

	/* `^C~OȂ΂ŕ`B̌ WAIT   */
	/* łȂ΁A                WAIT ɑJ */
	if (quasi88_event_flags & EVENT_FRAME_UPDATE) {
	    quasi88_event_flags &= ~EVENT_FRAME_UPDATE;
	    screen_update();
	    step = WAIT;
	} else {
	    step = step_after_wait;
	}

	/* j^[JڎÍA WAIT ɑ INIT  */
	if (quasi88_event_flags & (EVENT_DEBUG | EVENT_QUIT)) {
	    step = INIT;
	}

	/* Jڂ邽߁AU֐𔲂 (WAITFALLTHROUGHł) */
	return QUASI88_LOOP_BUSY;


    /* ======================== EFCg ======================== */
    case WAIT:
	stat = WAIT_JUST;

	switch (mode) {
	case EXEC:
	    profiler_lapse( PROF_LAPSE_IDLE );
	    if (! no_wait) { stat = wait_vsync_update(); }
	    break;

	case MENU:
	case PAUSE:
	    /* Esound ̏ꍇA MENU/PAUSE ł stream 𗬂ĂȂ
	       NɁA MENU/PAUSE ĂȂقłȂȂB
	       Â܂܂ƁẢ݂ςȂɂȂ̂ŁA
	       𗬂悤ɂȂƁB */
	    xmame_sound_update();		/* TEho */
	    xmame_update_video_and_audio();	/* TEho 2 */
	    stat = wait_vsync_update();
	    break;
	}

	if (stat == WAIT_YET) { return QUASI88_LOOP_BUSY; }


	/* EFCgԂɁAt[XLbv̗L */
	if (mode == EXEC) {
	    frameskip_check((stat == WAIT_JUST) ? TRUE : FALSE);
	}

	/* EFCgA (INIT  MAIN) ɑJ */
	step = step_after_wait;
	return QUASI88_LOOP_ONE;
    }

    /* ɂ͗Ȃ ! */
    return QUASI88_LOOP_EXIT;
}



/*======================================================================
 * QUASI88 ̃[h
 *	[hƂ QUASI88 ̏Ԃ̂ƂŁA EXEC (s)APAUSE (ꎞ~)A
 *	MENU (j[)A MONITOR (Θb^fobK)A QUIT(I) B
 *======================================================================*/
/* QUASI88̃[hݒ肷 */
static	void	set_mode(int newmode)
{
    if (mode != newmode) {

	if (mode == MENU) {		/* j[瑼[h̐ؑւ */
	    q8tk_event_quit();		/* Q8TK ̏IK{            */
	}

	next_mode = newmode;
	quasi88_event_flags |= EVENT_MODE_CHANGED;
	CPU_BREAKOFF();
    }
}

/* QUASI88̃[h؂ւ */
void	quasi88_exec(void)
{
    set_mode(EXEC);
    set_emu_exec_mode(GO);
}

void	quasi88_exec_step(void)
{
    set_mode(EXEC);
    set_emu_exec_mode(STEP);
}

void	quasi88_exec_trace(void)
{
    set_mode(EXEC);
    set_emu_exec_mode(TRACE);
}

void	quasi88_exec_trace_change(void)
{
    set_mode(EXEC);
    set_emu_exec_mode(TRACE_CHANGE);
}

void	quasi88_menu(void)
{
    set_mode(MENU);
}

void	quasi88_pause(void)
{
    set_mode(PAUSE);
}

void	quasi88_monitor(void)
{
#ifdef	USE_MONITOR
    set_mode(MONITOR);
#else
    set_mode(PAUSE);
#endif
}

void	quasi88_debug(void)
{
#ifdef	USE_MONITOR
    set_mode(MONITOR);
    quasi88_event_flags |= EVENT_DEBUG;
#else
    set_mode(PAUSE);
#endif
}

void	quasi88_quit(void)
{
    set_mode(QUIT);
    quasi88_event_flags |= EVENT_QUIT;
}

/* QUASI88̃[h擾 */
int	quasi88_is_exec(void)
{
  return (mode == EXEC) ? TRUE : FALSE;
}
int	quasi88_is_menu(void)
{
  return (mode == MENU) ? TRUE : FALSE;
}
int	quasi88_is_pause(void)
{
  return (mode == PAUSE) ? TRUE : FALSE;
}
int	quasi88_is_monitor(void)
{
  return (mode == MONITOR) ? TRUE : FALSE;
}





/***********************************************************************
 *	K؂ȈʒuɈړ
 ************************************************************************/
void	wait_vsync_switch(void)
{
    long dt;

    /* dt < 1000000us (1sec) łȂƃ_ */
    if (quasi88_is_exec()) {
	dt = (long)((1000000.0 / (CONST_VSYNC_FREQ * wait_rate/100)));
	wait_vsync_setup(dt, wait_by_sleep);
    } else {
	dt = (long)(1000000.0 / CONST_VSYNC_FREQ);
	wait_vsync_setup(dt, TRUE);
    }
}


static	void	status_override(void)
{
    static int first_fime = TRUE;

    if (first_fime) {

	/* EMU[hŋNꍇ̂݁AXe[^X̕\ς */
	if (mode == EXEC) {

	    status_message(0, STATUS_INFO_TIME, Q_TITLE " " Q_VERSION);

	    if (resume_flag == 0) {
		if (status_imagename == FALSE) {
		    status_message_default(1, "<F12> key to MENU");
		}
	    } else {
		status_message(1, STATUS_INFO_TIME, "State-Load Successful");
	    }
	}
	first_fime = FALSE;
    }
}



/***********************************************************************
 *	fobOp
 ************************************************************************/
#include "debug.c"



/***********************************************************************
 *	GȊ֐
 ************************************************************************/
#include "utility.c"



/***********************************************************************
 *			t@C^Ǘ
 ************************************************************************/
#include "fname.c"




/***********************************************************************
 * e퓮p[^̕ύX
 *	̊֐́AV[gJbgL[A@ˑ̃Cxg
 *	ȂǂĂяo邱Ƃ *ꉞ* z肵ĂB
 *
 *	j[ʂ̕\ɌĂяoƁAj[\ƐHႢ
 *	̂ŁAj[͌ĂяoȂ悤ɁBG~sɌĂяô
 *	ԈSB[A܂B
 *
 *	if( mode == EXEC ){
 *	    quasi88_disk_insert_and_reset( file, FALSE );
 *	}
 *
 ************************************************************************/

/***********************************************************************
 * QUASI88 ÑZbg֐
 ************************************************************************/
void	quasi88_get_reset_cfg(T_RESET_CFG *cfg)
{
    cfg->boot_basic	= boot_basic;
    cfg->boot_dipsw	= boot_dipsw;
    cfg->boot_from_rom	= boot_from_rom;
    cfg->boot_clock_4mhz= boot_clock_4mhz;
    cfg->set_version	= set_version;
    cfg->baudrate_sw	= baudrate_sw;
    cfg->use_extram	= use_extram;
    cfg->use_jisho_rom	= use_jisho_rom;
    cfg->sound_board	= sound_board;
}

void	quasi88_reset(const T_RESET_CFG *cfg)
{
    int sb_changed = FALSE;
    int empty[2];

    if (verbose_proc) printf("Reset QUASI88...start\n");

    pc88main_term();
    pc88sub_term();

    if (cfg) {
	if (sound_board	!= cfg->sound_board) {
	    sb_changed = TRUE;
	}

	boot_basic	= cfg->boot_basic;
	boot_dipsw	= cfg->boot_dipsw;
	boot_from_rom	= cfg->boot_from_rom;
	boot_clock_4mhz	= cfg->boot_clock_4mhz;
	set_version	= cfg->set_version;
	baudrate_sw	= cfg->baudrate_sw;
	use_extram	= cfg->use_extram;
	use_jisho_rom	= cfg->use_jisho_rom;
	sound_board	= cfg->sound_board;
    }

    /* ̍ĊmۂKvȂA */
    if (memory_allocate_additional() == FALSE) {
	quasi88_exit(-1);	/* sI */
    }

    /* TEho͂̃Zbg */
    if (sb_changed == FALSE) {
	xmame_sound_reset();
    } else {
	menu_sound_restart(FALSE);	/* TEhhCo̍ď */
    }

    /* [N̏ */
    pc88main_init(INIT_RESET);
    pc88sub_init(INIT_RESET);

    /* FDC̏ */
    empty[0] = drive_check_empty(0);
    empty[1] = drive_check_empty(1);
    drive_reset();
    if (empty[0]) drive_set_empty(0);
    if (empty[1]) drive_set_empty(1);

    /*if (xmame_has_sound()) xmame_sound_reset();*/

#ifdef USE_PAT
	if (pat_isdll())
		pat_disableall();
#endif
    emu_reset();

    if (verbose_proc) printf("Reset QUASI88...done\n");
}



/***********************************************************************
 * QUASI88 ÑXe[g[h֐
 *	TODO ŁAt@CwH
 ************************************************************************/
int	quasi88_stateload(int serial)
{
    int now_board, success;

    if (serial >= 0) {			/* AԎw肠 (>=0) Ȃ */
	filename_set_state_serial(serial);	/* AԂݒ肷 */
    }

    if (verbose_proc) printf("Stateload...start (%s)\n",filename_get_state());

    if (stateload_check_file_exist() == FALSE) {	/* t@CȂ */
	if (quasi88_is_exec()) {
	    status_message(1, STATUS_INFO_TIME, "State-Load file not found !");
	} /* j[ł̓_CAO\̂ŁAXe[^X\͖ɂ */

	if (verbose_proc) printf("State-file not found\n");
	return FALSE;
    }


    pc88main_term();			/* Ô߁A[NIԂ */
    pc88sub_term();
    imagefile_all_close();		/* C[Wt@CSĕ */

    /*xmame_sound_reset();*/		/* Ô߁ATEhZbg */
    /*quasi88_reset();*/		/* Ô߁AS[NZbg */


    now_board = sound_board;

    success = stateload();		/* Xe[g[hs */

    if (now_board != sound_board) { 	/* TEh{[hς */
	menu_sound_restart(FALSE);	/* TEhhCo̍ď */
    }

    if (verbose_proc) {
	if (success) printf("Stateload...done\n");
	else         printf("Stateload...Failed, Reset start\n");
    }


    if (success) {			/* Xe[g[hEEE */

	imagefile_all_open(TRUE);		/* C[Wt@CSĊJ*/

	pc88main_init(INIT_STATELOAD);
	pc88sub_init(INIT_STATELOAD);

    } else {				/* Xe[g[hsEEE */

	quasi88_reset(NULL);			/* Ƃ肠Zbg */
    }


    if (quasi88_is_exec()) {
	if (success) {
	    status_message(1, STATUS_INFO_TIME, "State-Load Successful");
	} else {
	    status_message(1, STATUS_INFO_TIME, "State-Load Failed !  Reset done ...");
	}

	/* quasi88_loop ̓Ԃ INIT ɂ邽߁A[hύXƂ */
	quasi88_event_flags |= EVENT_MODE_CHANGED;
    }
    /* j[ł̓_CAO\̂ŁAXe[^X\͖ɂ */

    return success;
}



/***********************************************************************
 * QUASI88 ÑXe[gZ[u֐
 *	TODO ŁAt@CwH
 ************************************************************************/
int	quasi88_statesave(int serial)
{
    int success;

    if (serial >= 0) {			/* AԎw肠 (>=0) Ȃ */
	filename_set_state_serial(serial);	/* AԂݒ肷 */
    }

    if (verbose_proc) printf("Statesave...start (%s)\n",filename_get_state());

    success = statesave();		/* Xe[gZ[us */

    if (verbose_proc) {
	if (success) printf("Statesave...done\n");
	else         printf("Statesave...Failed, Reset done\n");
    }


    if (quasi88_is_exec()) {
	if (success) {
	    status_message(1, STATUS_INFO_TIME, "State-Save Successful");
	} else {
	    status_message(1, STATUS_INFO_TIME, "State-Save Failed !");
	}
    }	/* j[ł̓_CAO\̂ŁAXe[^X\͖ɂ */

    return success;
}



/***********************************************************************
 * ʃXibvVbgۑ
 *	TODO ŁAt@CwH
 ************************************************************************/
int	quasi88_screen_snapshot(void)
{
    int success;

    success = screen_snapshot_save();


    if (success) {
	status_message(1, STATUS_INFO_TIME, "Screen Capture Saved");
    } else {
	status_message(1, STATUS_INFO_TIME, "Screen Capture Failed !");
    }

    return success;
}



/***********************************************************************
 * TEhf[^̃t@Co
 *	TODO ŁAt@CwH
 ************************************************************************/
int	quasi88_waveout(int start)
{
    int success;

    if (start) {
	success = waveout_save_start();

	if (success) {
	    status_message(1, STATUS_INFO_TIME, "Sound Record Start ...");
	} else {
	    status_message(1, STATUS_INFO_TIME, "Sound Record Failed !");
	}

    } else {

	success = TRUE;

	waveout_save_stop();
	status_message(1, STATUS_INFO_TIME, "Sound Record Stopped");
    }

    return success;
}



/***********************************************************************
 * hbOAhhbv
 *	TODO ߂lHv
 ************************************************************************/
int	quasi88_drag_and_drop(const char *filename)
{
    if (quasi88_is_exec() ||
	quasi88_is_pause()) {

#ifdef USE_PAT
	if (pat_isdll()) {
	char szExt[_MAX_EXT];
	_splitpath( filename, NULL, NULL, NULL, szExt);
	if (!lstrcmpi(szExt, ".pat")) {
		LoadPat(filename);
		return TRUE;
	}
	}
#endif

	if (quasi88_disk_insert_all(filename, FALSE)) {

	    status_message(1, STATUS_INFO_TIME, "Disk Image Set and Reset");
	    quasi88_reset(NULL);

	    if (quasi88_is_pause()) {
		quasi88_exec();
	    }

	} else {

	    status_message(1, STATUS_WARN_TIME, "D&D Failed !  Disk Unloaded ...");
	}

	return TRUE;
    }

    return FALSE;
}



/***********************************************************************
 * EFCg̔䗦ݒ
 * EFCg̗Lݒ
 ************************************************************************/
int	quasi88_cfg_now_wait_rate(void)
{
    return wait_rate;
}
void	quasi88_cfg_set_wait_rate(int rate)
{
    int time = STATUS_INFO_TIME;
    char str[32];
    long dt;

    if (rate < 5)    rate = 5;
    if (rate > 5000) rate = 5000;

    if (wait_rate != rate) {
	wait_rate = rate;

	if (quasi88_is_exec()) {

	    sprintf(str, "WAIT  %4d[%%]", wait_rate);

	    status_message(1, time, str);
	    /*  EFCgύX̂ŁA\Ԃ̓EFCg{ɂȂ */

	    dt = (long)((1000000.0 / (CONST_VSYNC_FREQ * wait_rate / 100)));
	    wait_vsync_setup(dt, wait_by_sleep);
	}
    }
}
int	quasi88_cfg_now_no_wait(void)
{
    return no_wait;
}
void	quasi88_cfg_set_no_wait(int enable)
{
    int time = STATUS_INFO_TIME;
    char str[32];
    long dt;

    if (no_wait != enable) {
	no_wait = enable;

	if (quasi88_is_exec()) {

	    if (no_wait) { sprintf(str, "WAIT  OFF");    time *= 10; }
	    else           sprintf(str, "WAIT  ON");

	    status_message(1, time, str);
	    /*  EFCgȂȂ̂ŁA\Ԃ͎ۂ̂Ƃs */

	    dt = (long)((1000000.0 / (CONST_VSYNC_FREQ * wait_rate / 100)));
	    wait_vsync_setup(dt, wait_by_sleep);
	}
    }
}



/***********************************************************************
 * fBXNC[Wt@Cݒ
 *	EhCuɑ}
 *	EwhCuɑ}
 *	E΃hCũC[Wt@CA}
 *	EhCuo
 *	EwhCuo
 ************************************************************************/
int	quasi88_disk_insert_all(const char *filename, int ro)
{
    int success;

    quasi88_disk_eject_all();

    success = quasi88_disk_insert(DRIVE_1, filename, 0, ro);

    if (success) {

	if (disk_image_num(DRIVE_1) > 1) {
	    quasi88_disk_insert_A_to_B(DRIVE_1, DRIVE_2, 1);
	}
    }

    if (quasi88_is_exec()) {
	status_message_default(1, NULL);
    }
    return success;
}
int	quasi88_disk_insert(int drv, const char *filename, int image, int ro)
{
    int success = FALSE;

    quasi88_disk_eject(drv);

    if (strlen(filename) < QUASI88_MAX_FILENAME) {

	if (disk_insert(drv, filename, image, ro) == 0) success = TRUE;
	else                                            success = FALSE;

	if (success) {

	    if (drv == DRIVE_1) boot_from_rom = FALSE;

	    strcpy(file_disk[ drv ], filename);
	    readonly_disk[ drv ] = ro;

	    if (filename_synchronize) {
		filename_init_state(TRUE);
		filename_init_snap(TRUE);
		filename_init_wav(TRUE);
	    }
	}
    }

    if (quasi88_is_exec()) {
	status_message_default(1, NULL);
    }
    return success;
}
int	quasi88_disk_insert_A_to_B(int src, int dst, int img)
{
    int success;

    quasi88_disk_eject(dst);

    if (disk_insert_A_to_B(src, dst, img) == 0) success = TRUE;
    else                                        success = FALSE;

    if (success) {
	strcpy(file_disk[ dst ], file_disk[ src ]);
	readonly_disk[ dst ] = readonly_disk[ src ];

	if (filename_synchronize) {
	    filename_init_state(TRUE);
	    filename_init_snap(TRUE);
	    filename_init_wav(TRUE);
	}
    }

    if (quasi88_is_exec()) {
	status_message_default(1, NULL);
    }
    return success;
}
void	quasi88_disk_eject_all(void)
{
    int drv;

    for (drv = 0; drv<2; drv++) {
	quasi88_disk_eject(drv);
    }

    boot_from_rom = TRUE;

    if (quasi88_is_exec()) {
	status_message_default(1, NULL);
    }
}
void	quasi88_disk_eject(int drv)
{
    if (disk_image_exist(drv)) {
	disk_eject(drv);
	memset(file_disk[ drv ], 0, QUASI88_MAX_FILENAME);

	if (filename_synchronize) {
	    filename_init_state(TRUE);
	    filename_init_snap(TRUE);
	    filename_init_wav(TRUE);
	}
    }

    if (quasi88_is_exec()) {
	status_message_default(1, NULL);
    }
}

/***********************************************************************
 * fBXNC[Wt@Cݒ
 *	EhCuꎞIɋ̏Ԃɂ
 *	EhCũC[WύX
 *	EhCũC[WÕC[WɕύX
 *	EhCũC[W̃C[WɕύX
 ************************************************************************/
enum { TYPE_SELECT, TYPE_EMPTY, TYPE_NEXT, TYPE_PREV };

static void disk_image_sub(int drv, int type, int img)
{
    int d;
    char str[48];

    if (disk_image_exist(drv)) {
	switch (type) {

	case TYPE_EMPTY:
	    drive_set_empty(drv);
	    sprintf(str, "DRIVE %d:  <<<< Eject >>>>         ", drv + 1);
	    break;

	case TYPE_NEXT:
	case TYPE_PREV:
	    if (type == TYPE_NEXT) d = +1;
	    else                   d = -1;

	    img = disk_image_selected(drv) + d;
	    /* FALLTHROUGH */

	default:
	    if (img < 0) img = disk_image_num(drv)-1;
	    if (img >= disk_image_num(drv)) img = 0;

	    drive_unset_empty(drv);
	    disk_change_image(drv, img);

	    sprintf(str, "DRIVE %d:  %-16s   %s  ",
		    drv + 1,
		    drive[drv].image[ disk_image_selected(drv) ].name,
		    (drive[drv].image[ disk_image_selected(drv) ].protect)
							? "(p)" : "   ");
	    break;
	}
    } else {
	sprintf(str, "DRIVE %d:   --  No Disk  --        ", drv + 1);
    }

    if (quasi88_is_exec()) {
	status_message_default(1, NULL);
    }
    status_message(1, STATUS_INFO_TIME, str);
}
void	quasi88_disk_image_select(int drv, int img)
{
    disk_image_sub(drv, TYPE_SELECT, img);
}
void	quasi88_disk_image_empty(int drv)
{
    disk_image_sub(drv, TYPE_EMPTY, 0);
}
void	quasi88_disk_image_next(int drv)
{
    disk_image_sub(drv, TYPE_NEXT, 0);
}
void	quasi88_disk_image_prev(int drv)
{
    disk_image_sub(drv, TYPE_PREV, 0);
}






/*======================================================================
 * e[vC[Wt@Cݒ
 *		E[hpe[vC[Wt@CZbg
 *		E[hpe[vC[Wt@C߂
 *		E[hpe[vC[Wt@CO
 *		EZ[upe[vC[Wt@CZbg
 *		EZ[upe[vC[Wt@CO
 *======================================================================*/
int	quasi88_load_tape_insert(const char *filename)
{
    quasi88_load_tape_eject();

    if (strlen(filename) < QUASI88_MAX_FILENAME &&
	sio_open_tapeload(filename)) {

	strcpy(file_tape[ CLOAD ], filename);
	return TRUE;

    }
    return FALSE;
}
int	quasi88_load_tape_rewind(void)
{
    if (sio_tape_rewind()) {

	return TRUE;

    }
    quasi88_load_tape_eject();
    return FALSE;
}
void	quasi88_load_tape_eject(void)
{
    sio_close_tapeload();
    memset(file_tape[ CLOAD ], 0, QUASI88_MAX_FILENAME);
}

int	quasi88_save_tape_insert(const char *filename)
{
    quasi88_save_tape_eject();

    if (strlen(filename) < QUASI88_MAX_FILENAME &&
	sio_open_tapesave(filename)) {

	strcpy(file_tape[ CSAVE ], filename);
	return TRUE;

    }
    return FALSE;
}
void	quasi88_save_tape_eject(void)
{
    sio_close_tapesave();
    memset(file_tape[ CSAVE ], 0, QUASI88_MAX_FILENAME);
}

/*======================================================================
 * VAEpC[Wt@Cݒ
 *		EVA͗pt@CZbg
 *		EVA͗pt@CO
 *		EVAo͗pt@CZbg
 *		EVAo͗pt@CO
 *		Ev^o͗pt@CZbg
 *		Ev^͗pt@CZbg
 *======================================================================*/
int	quasi88_serial_in_connect( const char *filename )
{
  quasi88_serial_in_remove();

  if( strlen( filename ) < QUASI88_MAX_FILENAME &&
      sio_open_serialin( filename ) ){

    strcpy( file_sin, filename );
    return TRUE;

  }
  return FALSE;
}
void	quasi88_serial_in_remove( void )
{
  sio_close_serialin();
  memset( file_sin, 0, QUASI88_MAX_FILENAME );
}
int	quasi88_serial_out_connect( const char *filename )
{
  quasi88_serial_out_remove();

  if( strlen( filename ) < QUASI88_MAX_FILENAME &&
      sio_open_serialout( filename ) ){

    strcpy( file_sout, filename );
    return TRUE;

  }
  return FALSE;
}
void	quasi88_serial_out_remove( void )
{
  sio_close_serialout();
  memset( file_sout, 0, QUASI88_MAX_FILENAME );
}
int	quasi88_printer_connect( const char *filename )
{
  quasi88_printer_remove();

  if( strlen( filename ) < QUASI88_MAX_FILENAME &&
      printer_open( filename ) ){

    strcpy( file_prn, filename );
    return TRUE;

  }
  return FALSE;
}
void	quasi88_printer_remove( void )
{
  printer_close();
  memset( file_prn, 0, QUASI88_MAX_FILENAME );
}
