
//
//	[}ϊdll
//
#pragma	once

#include <windows.h>

//	__cdecl
typedef	DWORD (__cdecl *DLLFUNCV)(void);
typedef	DWORD (__cdecl *DLLFUNCLPV)(LPVOID);
typedef	DWORD (__cdecl *DLLFUNCD1)(DWORD);
typedef	DWORD (__cdecl *DLLFUNCD2)(DWORD, DWORD);

class CROMAJIDLL
{
private:
	HMODULE	hDll;
	
	DLLFUNCLPV	romaji_init;
	DLLFUNCV	romaji_reset;
	DLLFUNCD1	romaji_input;
	DLLFUNCD2	romaji_output;
	DLLFUNCV	romaji_isempty;
	
public:
	CROMAJIDLL(LPCTSTR lpFilename) {
		hDll = LoadLibrary(lpFilename);
		if (hDll) {
		
		romaji_init = (DLLFUNCLPV) GetProcAddress(hDll, "romaji_init");
		romaji_reset = (DLLFUNCV) GetProcAddress(hDll, "romaji_reset");
		romaji_input = (DLLFUNCD1) GetProcAddress(hDll, "romaji_input");
		romaji_output = (DLLFUNCD2) GetProcAddress(hDll, "romaji_output");
		romaji_isempty = (DLLFUNCV) GetProcAddress(hDll, "romaji_isempty");
			
		}
	}
	
	~CROMAJIDLL() {
		if (hDll) {
			FreeLibrary(hDll);
			hDll = NULL;
		}
	}
	
	//	DLL̑݊mF
	BOOL IsDll(void) {
		return (hDll ? TRUE : FALSE);
	}
	
	//	
	//	p	zL[obt@̃|C^
	//	p = keystate:M88
	//	p = m_abtKeyboardState:X88
	//	p = key_status:CPS
	BOOL Init(LPVOID p) {
		return (hDll && romaji_init) ? romaji_init(p) : FALSE;
	}
	
	//	Zbg
	//	[}ϊ[hւ̊JnI
	BOOL Reset(void) {
		return (hDll && romaji_reset) ? romaji_reset() : FALSE;
	}
	
	//	zL[
	//	WM_KEYDOWN̎
	//	RETURN
	//	TRUE	[}ƂėLȃL[R[h
	//	FALSE	G[͗Lȕł͂Ȃ(ʏ폈)
	BOOL Input(DWORD s) {
		return (hDll && romaji_input) ? romaji_input(s) : FALSE;
	}
	
	//	zL[obt@ւ̏o
	//	on	KEY DOWN̎̃tO
	//	on = 0x01:M88
	//	on = 0x80:X88,CSP
	//	s	(Ǝ肱ڂ&)
	//	RETURN
	//	o͂鉼zL[
	//	0x00 = o͂Ȃ
	//	bit9 = SHIFTL[
	//	bit10 = 1:DOWN 0:UP
	DWORD Output(DWORD on, DWORD s) {
		return (hDll && romaji_output) ? romaji_output(on, s) : 0;
	}
	
	//	[}obt@󂩂ǂ
	BOOL IsEmpty(void) {
		return (hDll && romaji_isempty) ? romaji_isempty() : TRUE;
	}
};

