; RSRSNES 0.20 Debugger
; 
;Unlike in 0.10 and earlier versions of RSRSNES, I'm trying to standardize
; calls to the debugging routines, so I can create a more user-friendly 
; system, aka ZSNES's debug mode.  Consequently, I have a consolidated
; message system (accessed via DebugEvent) that can easily be redirected to
; a GUI or TUI.  The TUI is implemented in TUI.ASM

dEffectiveAddress dd 0       ;Stores last used effective data address

BeepString db 7,'$'
dBeep PROC
  pusha
  mov edx,OFFSET BeepString
  mov ah,09h
  int 21h
  popa
  ret
ENDP


INCLUDE EVENTS.ASM
;eax=EventID
DebugEvent PROC
  IFDEF VIDEOON
    ret
  ENDIF
  cmp [DMAOn],0
  je NoDMA
  ret
  NoDMA:
  push edx
  push ebx
  shl eax,6
  lea edx,[dEvents+eax]
  mov ebx,13
  call tuiWPrint
  pop ebx
  pop edx
  ret
ENDP

INCLUDE OPCODES.ASM

dRegNames db ' A:',13,' X:',13,' Y:',13,' D:',13,' DB:',13,' S:',13,' PC:'
          db 13,' PB:',13,'',13,'NVMXDIZC E',13,0
dHEXString db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
Debug65816Regs PROC         ;Display 65816's registers
  IFDEF VIDEOON
    ret
  ENDIF
  push eax
  push ebx
  push edx
  IFDEF TUI                   ;TUI version
    ;In the TUI version, the registers are dumped to Window 10
    mov ebx,10                  ;Set window number
    call tuiWinCLS              ;Clear the window
    mov edx,OFFSET dRegNames    ;Print the register names
    call tuiWPrint              ;
    mov edx,OFFSET dHEXString
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPX],5
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPY],0
    mov ax,WORD PTR [eAL]
    call tuiHexStringW
    call tuiWPrint
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPX],5
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPY],(128*1)
    mov ax,WORD PTR [eXL]
    call tuiHexStringW
    call tuiWPrint
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPX],5
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPY],(128*2)
    mov ax,WORD PTR [eYL]
    call tuiHexStringW
    call tuiWPrint
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPX],5
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPY],(128*3)
    mov ax,WORD PTR [eDL]
    call tuiHexStringW
    call tuiWPrint
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPX],5
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPY],(128*4)
    mov al,BYTE PTR [eDB]
    call tuiHexStringB
    call tuiWPrint
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPX],5
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPY],(128*5)
    mov ax,WORD PTR [eSL]
    call tuiHexStringW
    call tuiWPrint
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPX],5
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPY],(128*6)
    mov ax,WORD PTR [ePCL]
    call tuiHexStringW
    call tuiWPrint
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPX],5
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPY],(128*7)
    mov al,BYTE PTR [ePB]
    call tuiHexStringB
    call tuiWPrint
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPX],0
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPY],(128*10)
    mov al,BYTE PTR [eP]
    call tuiBinStringB
    call tuiWPrint
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPX],9
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinPY],(128*10)
    mov al,'0'
    add al,BYTE PTR [ePe]
    mov [edx],al
    mov BYTE PTR [edx+1],0
    call tuiWPrint
  ENDIF
  pop edx
  pop ebx
  pop eax
  ret
ENDP

;esi=Memory Pointer (65816 program mem map)
DebugMemDump PROC
  IFDEF VIDEOON
    ret
  ENDIF
  push esi
  push edx
  push ecx
  push ebx

  mov cl,8
  mov ch,4
  mov edx,OFFSET dHEXString
  mov ebx,11
  call tuiWinCLS              ;Clear the window

  ;display line address
  mov BYTE PTR [edx],' '
  inc edx
  mov eax,esi
  shr eax,16
  call tuiHEXStringB
  mov BYTE PTR [edx+2],':'
  mov BYTE PTR [edx+3],0
  dec edx
  call tuiWPrint
  mov eax,esi
  call tuiHEXStringW
  mov BYTE PTR [edx+4],32
  mov BYTE PTR [edx+5],179
  mov BYTE PTR [edx+6],32
  mov BYTE PTR [edx+7],0
  call tuiWPrint

  DebugMemDumpLoop:
  MemReadP
  inc esi
  call tuiHEXStringB
  mov BYTE PTR [edx+2],32
  mov BYTE PTR [edx+3],0
  call tuiWPrint
  dec cl
  jnz DebugMemDumpLoop
  mov BYTE PTR [edx],13
  mov BYTE PTR [edx+1],0
  call tuiWPrint
  ;display line address
  mov BYTE PTR [edx],' '
  inc edx
  mov eax,esi
  shr eax,16
  call tuiHEXStringB
  mov BYTE PTR [edx+2],':'
  mov BYTE PTR [edx+3],0
  dec edx
  call tuiWPrint
  mov eax,esi
  call tuiHEXStringW
  mov BYTE PTR [edx+4],32
  mov BYTE PTR [edx+5],179
  mov BYTE PTR [edx+6],32
  mov BYTE PTR [edx+7],0
  call tuiWPrint
  mov cl,8
  dec ch
  jnz DebugMemDumpLoop

  pop ebx  
  pop ecx
  pop edx
  pop esi
  ret
ENDP


dRegWinTitle db 'Regs',0
dMemWinTitle db 'Memory Dump',0
dOpcWinTitle db 'Current Opcode',0
dMsgWinTitle db 'Messages',0
dAllWinTitle db 'RSRSNes 0.20 Debug Mode',0
dAllWinKeys  db 'ESC: QUIT   SPACE: Single Step   T/H/F: Batch execute 10/100/5000 opcodes',13,'F1:  Help menu  F5: Reset ROM',0
DebugReset PROC            ;reset TUI window sizes and locations for Debugger
  IFDEF VIDEOON
    ret
  ENDIF
  IFDEF TUI
    call tuiConstruct                ;Initialize the TUI

    mov DWORD PTR [ebp+TUIMEM+0280h+tWinH],13                   ;Window 10
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinW],12                   ;=Registers
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinZ],4
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinTitle],OFFSET dRegWinTitle
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinXY],292
    mov DWORD PTR [ebp+TUIMEM+0280h+tWinType],1

    mov DWORD PTR [ebp+TUIMEM+02C0h+tWinH],6                    ;Window 11
    mov DWORD PTR [ebp+TUIMEM+02C0h+tWinW],37                   ;=Memory Dump
    mov DWORD PTR [ebp+TUIMEM+02C0h+tWinZ],3
    mov DWORD PTR [ebp+TUIMEM+02C0h+tWinTitle],OFFSET dMemWinTitle
    mov DWORD PTR [ebp+TUIMEM+02C0h+tWinXY],2562
    mov DWORD PTR [ebp+TUIMEM+02C0h+tWinType],1

    mov DWORD PTR [ebp+TUIMEM+0300h+tWinH],5                    ;Window 12
    mov DWORD PTR [ebp+TUIMEM+0300h+tWinW],64                   ;=Opcode Decode
    mov DWORD PTR [ebp+TUIMEM+0300h+tWinZ],2
    mov DWORD PTR [ebp+TUIMEM+0300h+tWinTitle],OFFSET dOpcWinTitle
    mov DWORD PTR [ebp+TUIMEM+0300h+tWinXY],162
    mov DWORD PTR [ebp+TUIMEM+0300h+tWinType],1

    mov DWORD PTR [ebp+TUIMEM+0340h+tWinH],8                    ;Window 13
    mov DWORD PTR [ebp+TUIMEM+0340h+tWinW],64                   ;=Messages
    mov DWORD PTR [ebp+TUIMEM+0340h+tWinZ],1
    mov DWORD PTR [ebp+TUIMEM+0340h+tWinTitle],OFFSET dMsgWinTitle
    mov DWORD PTR [ebp+TUIMEM+0340h+tWinXY],962
    mov DWORD PTR [ebp+TUIMEM+0340h+tWinType],1

    mov DWORD PTR [ebp+TUIMEM+0380h+tWinH],25                   ;Window 14
    mov DWORD PTR [ebp+TUIMEM+0380h+tWinW],80                   ;=background
    mov DWORD PTR [ebp+TUIMEM+0380h+tWinZ],15
    mov DWORD PTR [ebp+TUIMEM+0380h+tWinTitle],OFFSET dAllWinTitle
    mov DWORD PTR [ebp+TUIMEM+0380h+tWinXY],0
    mov DWORD PTR [ebp+TUIMEM+0380h+tWinType],1

    mov ebx,14
    call tuiWinCLS
    mov DWORD PTR [ebp+TUIMEM+0380h+tWinPX],2
    mov DWORD PTR [ebp+TUIMEM+0380h+tWinPY],128*21
    mov edx,OFFSET dAllWinKeys
    call tuiWPrint

  ENDIF
  ret
ENDP

;IN: eax=Opcode
DebugOpcode PROC
  IFDEF VIDEOON
    ret
  ENDIF
  push esi
  push edx
  push ebx
  push eax
  shl eax,4
  add eax,OFFSET dOp00
  mov edx,eax
  mov ebx,12
  call tuiWinCLS              ;Clear the window
  mov DWORD PTR [ebp+TUIMEM+0300h+tWinPX],2
  mov DWORD PTR [ebp+TUIMEM+0300h+tWinPY],128
  call tuiWPrint
  pop eax
  pop ebx
  pop edx
  pop esi
  ret
ENDP

;IN:  al=8-bit byte read
dRDS db 'r',0,0,0
DebugRead PROC
  IFDEF VIDEOON
    ret
  ENDIF
  push ebx
  push edx
  mov edx,OFFSET dRDS
  inc edx
  call tuiHexStringB
  dec edx
  mov ebx,12
  call tuiWPrint
  pop edx
  pop ebx
  ret
ENDP
;IN:  al=8-bit byte written
dWDS db 'w',0,0,0
DebugWrite PROC
  IFDEF VIDEOON
    ret
  ENDIF
  push ebx
  push edx
  mov edx,OFFSET dWDS
  inc edx
  call tuiHexStringB
  dec edx
  mov ebx,12
  call tuiWPrint
  pop edx
  pop ebx
  ret
ENDP
