; DPMI interface, File Interface, general I/O

;Memory required:  SNES Mem..........8388608
;                  TUI mem............262144
;                  Video mem.........1000000
;                  Total:------------9650752->10000000

ALLOC_SIZE EQU 10000000              ;Total memory needed
SNESSMC EQU 0                        ;Offset of SMC file header
SNESMEM EQU 512                      ;complete memory map for SNES starts at
                                     ;XMS offset 0 (offset from ebp)
TUIMEM EQU 8388608+SNESMEM           ;XMS offset for TUI buffers
VIDMEM EQU TUIMEM+262144             ;XMS offset for Video buffers
SVRAM EQU VIDMEM                     ;XMS offset for SNES VRAM (inside VIDMEM)

mMsgInit db 'Initializing DPMI Memory...',13,10,'$'
mMsgFail db 'Unable to allocate memory (Error #1001)',13,10,'$'
mMsgExtF db 'Unable to allocate enough memory (Error #1002)',13,10,'$'
mMsgFile db 'Unable to open xxxxxxxx.xxx (Error #t2001)',13,10,'$'
mMsgWind db 'Windows 95 prevents direct XMS access.  You must restart in DOS mode.',13,10,'$'

mERROR dd 0                          ;returns memory allocation errors

mSTART dd 0                          ;holds pointer to memory map

;ͻ
;                      Memory Initialization                          
;ͼ

;Routine to allocate RAM and setup memory maps
mMemorySetup PROC
  mov ah,9                           ;
  mov edx,OFFSET mMsgInit            ;
  int 21h                            ;Display Initializtion message
  mov edx,-1                         ;allocate all available RAM
  mov ax,0EE42h                      ;DOS32 memory allocate
  int 31h                            ;Call DOS32
  cmp eax,0                          ;check for error
  jnz enfmem                         ;zero=error
  mov ah,9                           ;
  mov edx,OFFSET mMsgFail            ;
  int 21h                            ;Display Allocation error message
  mov [mERROR],1001                  ;set error code
  ret                                ;
  enfmem:                            ;
  mov ebx,edx                        ;EDX = offset
  cmp eax,ALLOC_SIZE+1000000         ;Test for minimum needed RAM (with extra)
  ja PlentyORAM
  mov ah,9                           ;
  mov edx,OFFSET mMsgExtF            ;
  int 21h                            ;Display Not enough memory error message
  mov [mERROR],1002                  ;set error code
  ret                                ;
  PlentyORAM:         ;Memory is now allocated for sure, ebx holds pointer
  mov [mSTART],ebx                   ;preserve memory pointer
  mov ebp,ebx                        ;set the universal RAM pointer
  ret
ENDP

;ͻ
;                              File I/O                               
;ͼ
;in:  edx=filename, null terminated  edi=buffer  ecx=max size esi=info record
;out:  data into [edi], file info into [esi]
fioFILENAME EQU 0                    ;Name of the file loaded (not implemented)
fioFILESIZE EQU 16                   ;Full size of the file
fioFILELEN  EQU 20                   ;Length of data loaded
fioERROR EQU 24                      ;nonzero on error
fioPADDING EQU 28                    ;Extra space to pad record to 32 bytes

mFilehandle dw 0

LoadFile PROC NEAR                 ;Load the contents of a file into memory
  push ecx
  push ebx
  push edx
  mov DWORD PTR [esi+fioERROR],0     ;intialize error flag
  mov ah,3Dh                         ;
  mov al,00h                         ;opening flags.  0 = read only
  int 21h                            ;open the file
  jnc NoFileOpenError                ;exit if error
  mov DWORD PTR [esi+fioERROR],2001  ;Unable to open file, display error msg
  ret                                ;
  NoFileOpenError:                   ;
  mov [mFilehandle],ax               ;save the file handle
  mov bx,ax                          ;
  mov ax,4202h                       ;
  mov edx,0                          ;
  int 21h                            ;set file pointer to end of file
  jnc NoSetPosError1                 ;
  mov DWORD PTR [esi+fioERROR],2002  ;Unable to set file position
  NoSetPosError1:                    ;
  mov [esi+fioFILESIZE],eax          ;
  mov bx,[mFilehandle]               ;
  mov ax,4200h                       ;
  mov edx,0                          ;
  int 21h                            ;set file pointer to start of file
  jnc NoSetPosError2                 ;
  mov DWORD PTR [esi+fioERROR],2002  ;Unable to set file position, display error msg
  ret                                ;
  NoSetPosError2:                    ;
  mov eax,[esi+fioFILESIZE]          ;
  mov [esi+fioFILELEN],eax           ;set file length loaded
  push ecx                           ;
  cmp ecx,eax                        ;
  mov ecx,eax                        ;set count to file length
  jae NotTooBig                      ;
  pop ecx                            ;if file is too big, trim length count
  push ecx                           ;
  mov [esi+fioFILELEN],ecx           ;
  NotTooBig:                         ;
  pop eax                            ;

  mov edx,edi                        ;EDX -> receive buffer
  mov bx,[mFilehandle]               ; BX = handle
  mov ah,3Fh
  int 21h                            ; Read file

  mov bx,[mFilehandle]               ; Close the file
  mov ah,3Eh
  int 21h
                                     ;read errors currently ignored
  pop edx                            ;restore registers
  pop ebx                            ;
  pop ecx                            ;
  ret                                ;done
ENDP
