;Misc. SNES functions

DMAJTable dd DMA0, DMA1, DMA2, DMA3, DMA4, DMAX, DMAX, DMAX
DMAOn dd 0

;in:  edx=DMA channel enabled
DMATransfer PROC     ;Execute a DMA transfer
  push edx                              ;Preserve registers
  push ecx                              ;
  push ebx                              ;
  push eax                              ;
  push esi                              ;
  push edi                              ;
  IFDEF DEBUGON
    mov eax,7
    call DebugEvent             ;generate debug event
  ENDIF

  mov [DMAOn],1                         ;Flag DMA transfer (cuts off events)
                                        ;
  shl edx,4                             ;calculate r43xx offset for channel
  movzx ebx,BYTE PTR [r43DATA+edx+1]    ;initialize dest. address
  mov bh,21h                            ;Destination must be in $21xx
  mov esi,DWORD PTR [r43DATA+edx+2]     ;initialize source address
  and esi,0FFFFFFh                      ;mask out extra byte from source
  movzx eax,WORD PTR [r43DATA+edx+5]    ;get transfer size (total bytes)
  mov dl,[r43DATA+edx+0]                ;get channel's control byte
  mov ecx,1                             ;preset Read mode to increment
  test dl,8                             ;check for decrement mode
  jz DMANoDecrement                     ;
  dec ecx                               ;set decriment mode if detected
  dec ecx                               ;
  DMANoDecrement:                       ;
  test dl,16                            ;check for fixed read mode
  jz DMANoFixedRead                     ;
  xor ecx,ecx                           ;set fixed read mode if detected
  DMANoFixedRead:                       ;
  and edx,7                             ;mask DMA mode bits
  shl edx,2                             ;convert mode bits to jumptable offset
  jmp [DMAJTable+edx]                   ;execute DMA transfer

  DMAX:                                 ;Illegal DMA Mode jumpoint
  jmp EndDMA                            ;done with DMA

  DMA0:                                 ;R+WR+W mode
  mov edx,ecx                           ;preserve Read Update info
  DMA0Loop:                             ;
  mov edi,esi                           ;Get Source address
  call SNESFullMemRead                  ;Read data
  add esi,edx                           ;update read pointer
  mov edi,ebx                           ;get Destination address
  call SNESFullMemWrite                 ;Write data
  dec eax                               ;decrement count
  jz EndDMA                             ;check for end of DMA
  mov edi,esi                           ;Get Source address
  call SNESFullMemRead                  ;Read data
  add esi,edx                           ;update read pointer
  mov edi,ebx                           ;get Destination address
  call SNESFullMemWrite                 ;Write data
  dec eax                               ;decrement count
  jz EndDMA                             ;check for end of DMA
  jmp DMA0Loop                          ;next DMA cycle

  DMA1:                                 ;R+W+R+W- mode
  mov edx,ecx                           ;preserve Read Update info
  DMA1Loop:                             ;
  mov edi,esi                           ;Get Source address
  call SNESFullMemRead                  ;Read data
  add esi,edx                           ;update read pointer
  mov edi,ebx                           ;get Destination address
  call SNESFullMemWrite                 ;Write data
  inc ebx                               ;update write address
  dec eax                               ;decrement count
  jz EndDMA                             ;check for end of DMA
  mov edi,esi                           ;Get Source address
  call SNESFullMemRead                  ;Read data
  add esi,edx                           ;update read pointer
  mov edi,ebx                           ;get Destination address
  call SNESFullMemWrite                 ;Write data
  dec ebx                               ;update write address
  dec eax                               ;decrement count
  jz EndDMA                             ;check for end of DMA
  jmp DMA1Loop                          ;next DMA cycle

  DMA2:                                 ;R+W mode
  mov edx,ecx                           ;preserve Read Update info
  DMA2Loop:                             ;
  mov edi,esi                           ;Get Source address
  call SNESFullMemRead                  ;Read data
  add esi,edx                           ;update read pointer
  mov edi,ebx                           ;get Destination address
  call SNESFullMemWrite                 ;Write data
  dec eax                               ;decrement count
  jz EndDMA                             ;check for end of DMA
  jmp DMA2Loop                          ;next DMA cycle

  DMA3:                                 ;R+WR+W+R+WR+W- mode
  mov edx,ecx                           ;preserve Read Update info
  DMA3Loop:                             ;
  mov edi,esi                           ;Get Source address
  call SNESFullMemRead                  ;Read data
  add esi,edx                           ;update read pointer
  mov edi,ebx                           ;get Destination address
  call SNESFullMemWrite                 ;Write data
  dec eax                               ;decrement count
  jz EndDMA                             ;check for end of DMA
  mov edi,esi                           ;Get Source address
  call SNESFullMemRead                  ;Read data
  add esi,edx                           ;update read pointer
  mov edi,ebx                           ;get Destination address
  call SNESFullMemWrite                 ;Write data
  inc ebx                               ;update write address
  dec eax                               ;decrement count
  jz EndDMA                             ;check for end of DMA
  mov edi,esi                           ;Get Source address
  call SNESFullMemRead                  ;Read data
  add esi,edx                           ;update read pointer
  mov edi,ebx                           ;get Destination address
  call SNESFullMemWrite                 ;Write data
  dec eax                               ;decrement count
  jz EndDMA                             ;check for end of DMA
  mov edi,esi                           ;Get Source address
  call SNESFullMemRead                  ;Read data
  add esi,edx                           ;update read pointer
  mov edi,ebx                           ;get Destination address
  call SNESFullMemWrite                 ;Write data
  dec ebx                               ;update write address
  dec eax                               ;decrement count
  jz EndDMA                             ;check for end of DMA
  jmp DMA3Loop                          ;next DMA cycle

  DMA4:                                 ;R+W+R+W+R+W+R+W-3 mode
  mov edx,ecx                           ;preserve Read Update info
  DMA4Loop:                             ;
  mov edi,esi                           ;Get Source address
  call SNESFullMemRead                  ;Read data
  add esi,edx                           ;update read pointer
  mov edi,ebx                           ;get Destination address
  call SNESFullMemWrite                 ;Write data
  inc ebx                               ;update write address
  dec eax                               ;decrement count
  jz EndDMA                             ;check for end of DMA
  mov edi,esi                           ;Get Source address
  call SNESFullMemRead                  ;Read data
  add esi,edx                           ;update read pointer
  mov edi,ebx                           ;get Destination address
  call SNESFullMemWrite                 ;Write data
  inc ebx                               ;update write address
  dec eax                               ;decrement count
  jz EndDMA                             ;check for end of DMA
  mov edi,esi                           ;Get Source address
  call SNESFullMemRead                  ;Read data
  add esi,edx                           ;update read pointer
  mov edi,ebx                           ;get Destination address
  call SNESFullMemWrite                 ;Write data
  inc ebx                               ;update write address
  dec eax                               ;decrement count
  jz EndDMA                             ;check for end of DMA
  mov edi,esi                           ;Get Source address
  call SNESFullMemRead                  ;Read data
  add esi,edx                           ;update read pointer
  mov edi,ebx                           ;get Destination address
  call SNESFullMemWrite                 ;Write data
  sub ebx,3                             ;update write address
  dec eax                               ;decrement count
  jz EndDMA                             ;check for end of DMA
  jmp DMA4Loop                          ;next DMA cycle

  EndDMA:                               ;
  mov [DMAOn],0                         ;Unflag DMA transfer (cuts on events)                                      
  pop edi                               ;Restore registers
  pop esi                               ;
  pop eax                               ;
  pop ebx                               ;
  pop ecx                               ;
  pop edx                               ;
  ret                                   ;done
ENDP

;Variables for Memory Mapped Registers
r2100 db 0  ;Screen Display Register  x000bbbb x1=Off bbbb=brightness
r2101 db 0  ;OAM Size Register  sssnnbbb  s=size n=name  b=base
r2102 db 0  ;OAM Address Register  aaaaaaaa r000000m
r2103 db 0  ;"
r2102B dw 0 ;Converted OAM address
r2104 dw 0  ;OAM data register
r2105 db 0  ;Screen mode register
r2106 db 0  ;Screen pixelation register
r2107 db 0  ;BG1 VRAM location reg.
r2108 db 0  ;BG2 "
r2109 db 0  ;BG3 "
r210A db 0  ;BG4 "
r210B db 0  ;BG1/2 VRAM location reg.
r210C db 0  ;BG3/4 VRAM location reg.
r210D dw 0  ;BG1 horiz. scroll reg.
r210E dw 0  ;BG1 vert. scroll reg.
r210F dw 0  ;BG2 horiz. scroll reg.
r2110 dw 0  ;BG2 vert. scroll reg.
r2111 dw 0  ;BG3 horiz. scroll reg.
r2112 dw 0  ;BG3 vert. scroll reg.
r2113 dw 0  ;BG4 horiz. scroll reg.
r2114 dw 0  ;BG4 vert. scroll reg.
r2115 db 0  ;Video port control
r2116 db 0  ;Video port address
r2117 db 0  ;"
r2118 db 0  ;Video port data
r2119 db 0  ;"
r211A db 0  ;MODE7 Settings register
r211B db 0  ;M7A
r211C db 0  ;M7B
r211D db 0  ;M7C
r211E db 0  ;M7D
r211F dw 0  ;M7X
r2120 dw 0  ;M7Y
r2121 db 0  ;Color LUT index
r2122 dw 0  ;Color data register
r2123 db 0  ;Window mask settings reg. BG2/1
r2124 db 0  ;Window mask settings reg. BG4/3
r2125 db 0  ;Window mask settings reg. color Window 2/1
r2126 db 0  ;Window 1 left position
r2127 db 0  ;Window 1 right position
r2128 db 0  ;Window 2 left position
r2129 db 0  ;Window 2 right position
r212A db 0  ;Mask logic settings W1/2
r212B db 0  ;Mask logic settings for windows & OBJ Windows
r212C db 0  ;Main screen designation
r212D db 0  ;Sub-screen designation
r212E db 0  ;Window mask main screen designation
r212F db 0  ;Window mask sub screen designation
r2130 db 0  ;Fixed color addition or screen addition register
r2131 db 0  ;Addition/subtraction for screens, BGs, & OBJs
r2132 db 0  ;Fixed color data for fixed color +/-
r2133 db 0  ;Screen mode/video select register
r2134 db 0  ;Multiplication result low
r2135 db 0  ;Multiplication result mid
r2136 db 0  ;Multiplication result high
r2137 db 0  ;Software latch for horizontal/vertical counter
r2138 db 0  ;Read data from OAM
r2139 db 0  ;Read data from VRAM
r213A db 0  ;"
r213B db 0  ;Read data from CG-RAM (color)
r213C dw 0  ;Horizontal scanline location
r213D dw 0  ;Vertical scanline location
r213E db 0  ;PPU status flag & version number
r213F db 0  ;PPU status flag & version number
r2140 db 0  ;APUI00
r2141 db 0  ;APUI01
r2142 db 0  ;APUI02
r2143 db 0  ;APUI03
;------------------
r2180 db 0  ;Read/Write WRAM reg.  (whatever the hell THAT is)
r2181 db 0  ;WRAM data register (low)
r2182 db 0  ;WRAM data register (mid)
r2183 db 0  ;WRAM data register (high)
;------------------
r4200 db 0  ;Counter enable
r4201 db 0  ;Programmable I/O port
r4202 db 0  ;Multiplicand 'A'
r4203 db 0  ;Multiplier 'B'
r4204 db 0  ;Dividend 'C'
r4205 db 0  ;"
r4206 dw 0  ;Divisor B  (byte oprand with one byte padding)
r4207 db 0  ;Video horizontal IRQ beam position/pointer
r4208 db 0  ;"
r4209 db 0  ;Video vertical IRQ beam position/pointer
r420A db 0  ;"
r420B db 0  ;DMA enable register
r420C db 0  ;HDMA enable register
r420D db 0  ;Cycle speed register
r4210 db 0  ;NMI register
r4211 db 0  ;Video IRQ register
r4212 db 0  ;Status register
r4213 db 0  ;Programmable I/O port
r4214 db 0  ;Quotient of divide result
r4215 db 0  ;"
r4216 db 0  ;Multiplication or divide result
r4217 db 0  ;"
r4218 db 0  ;Joypad #1 status register Low
r4219 db 0  ;Joypad #1 status register High
r421A db 0  ;Joypad #2 status register Low
r421B db 0  ;Joypad #2 status register High
r421C db 0  ;Joypad #3 status register Low
r421D db 0  ;Joypad #3 status register High
r421E db 0  ;Joypad #4 status register Low
r421F db 0  ;Joypad #4 status register High
