; RSRSNes 0.20
; (C) 1997 Realtime Simulations and Roleplaying games, Inc.
; Programming by Grog
; Special thanks to Yoshi, of course
; More thanks to Sneese, for their soundskip method
; More thanks to NafetS, for "lea" among others
;  Written for TASM 4.0 or greater
;  Last update:  1/6/97

  .386
  .MODEL FLAT
  .STACK 1000h

  TUI EQU ON

  .DATA
  testSTR db 'Loading SONIC.SMC...',0
  testFILE db 'SONIC.SMC',0,0,0,0,0,0,0
  testINPUT db 32 DUP (0)
  testFILEH db 32 DUP (0)
  .CODE

Start:
  call Construct                   ;Initialize DPMI, SMC, etc
  call InitSNES                    ;Reset all SNES registers to power-on stats
  call Reset65816                  ;Reset 65816

  IFDEF VIDEOON                    ;
    call InitVideo                 ;Switch to graphics mode
    call FullSNESEmu               ;Run the emulation
  ENDIF                            ;

 IFNDEF VIDEOON
  mov edx,OFFSET testFILE
  mov ecx,65536
  mov edi,ebp
  add edi,SNESSMC+32768
  mov esi,OFFSET testFILEH
  call LoadFile

  call Reset65816                  ;Reset 65816

  call Debug65816Regs
  mov esi,0FFE0h
  call DebugMemDump

  mov ebx,13
  call tuiWinCLS

  call tuiPaint

  EmuLoop:
  call Debug65816Regs
  mov ebx,13
  call tuiWinCLS
  call OpEmu
  call tuiPaint
  call tuiGetch
  cmp al,'q'
  je Exit
  cmp al,'Q'
  je Exit
  cmp al,27
  je Exit
  cmp al,'t'
  je Auto10
  cmp al,'h'
  je Auto100
  cmp al,'f'
  je Auto5000
  cmp al,'d'
  je AutoDebug
  cmp al,'n'
  je NMICall
  cmp al,'s'
  je NMIFlagSet

  jmp EmuLoop

  NMICall:
  call eNMI
  jmp EmuLoop
  NMIFlagSet:
  or [r4210],080h
  jmp EmuLoop

  AutoDebug:
  mov ecx,20485
  jmp AutoLoop1
  Auto10:
  mov ecx,9
  jmp AutoLoop1
  Auto100:
  mov ecx,99
  jmp AutoLoop1
  Auto5000:
  mov ecx,4999
  jmp AutoLoop1

  AutoLoop1:
  push ecx
  call OpEmu
  mov ebx,13
  call tuiWinCLS
  pop ecx
  dec ecx
  jnz AutoLoop1
  jmp EmuLoop
 ENDIF

Exit:                               ;
  IFDEF VIDEOON                    ;
    call StopVideo                 ;Switch to text mode
  ENDIF                            ;
  call Destruct                    ;Shut down DPMI, etc
  mov ax,4C00h                     ;dos standard exit function
  int 21h                          ;return to DOS

Construct PROC                     ;Routine to initialize RSRSNes
  call mMemorySetup                ;allocate memory
  ;call CommandLine                 ;Parse the command line
  ;call ROMLoad
  IFDEF DEBUGON
    call DebugReset                  ;Initialize the debugger
  ENDIF
  ;Perform any other general initializations here
  ret
ENDP
Destruct PROC
  ;Perform any general shutdown procedures here
  IFDEF DEBUGON
    call tuiDestruct
  ENDIF
  ret
ENDP
BEEP MACRO
  call dBeep
ENDM

INCLUDE 65816.ASM       ;65816 emulation core
INCLUDE SNESMEM.ASM     ;SNES Memory map emulation
INCLUDE DEBUG.ASM       ;Debugging mode routines
INCLUDE MEM.ASM         ;DPMI, File, I/O routines
INCLUDE TUI.ASM         ;Textmode User Interface routines
INCLUDE MISC.ASM        ;Assorted SNES functions (ie DMA, I/O, NMI trigger)
INCLUDE VIDEO.ASM       ;Video related functions and variables

Tester db 'Starting the great test...$',0
FullSNESEmu PROC  ;This is the main SNES emu loop (in Vmode) for now

  mov edx,OFFSET testFILE          ;SMC filename
  mov ecx,65536                    ;Maximum chars to load   (32k ROM)
  mov edi,ebp                      ;
  add edi,SNESSMC+32768            ;Get pointer to SNES ROM space (32k ROMs!)
  mov esi,OFFSET testFILEH         ;Get pointer to SMC header buffer
  call LoadFile                    ;Load the ROM
  call Reset65816                  ;Reset 65816

  mov edx,OFFSET Tester
  mov ah,09
  int 21h

  VSyncLoop:
  mov ecx,15000                    ;Opcodes to execute between VSyncs
  FEmuLoop:                        ;
  push ecx
  call OpEmu                       ;Execute a 65816 opcode
  pop ecx
  dec ecx                          ;decrement count
  jnz FEmuLoop                     ;Next 65816 opcode
  ;KB i/o here                     ;
  mov ah,01h
  int 16h
  jz VRefresh                      ;Next VSync cycle
  mov ah,00h
  int 16h
  cmp al,'q'                       ;Q key
  je ExitF                         ;
  cmp al,'Q'                       ;Q key
  je ExitF                         ;
  cmp al,27                        ;ESC key
  je ExitF                         ;
  cmp al,'f'
  je ForceSC
  VRefresh:
  ;Render screen here
  test [r4200],80h
  jz NoNMITick
  call eNMI
  NoNMITick:
  test [r2100],128
  jnz NoScreenDraw
  call vModeX
  NoScreenDraw:
  jmp VSyncLoop
  ExitF:
  ret
  ForceSC:
  mov esi,[vBG1]
  mov ecx,960
  mov eax,0
  SCLoop:
  mov [esi],ax
  inc esi
  inc esi
;  inc eax
  dec ecx
  jnz SCLoop
  jmp VRefresh
ENDP

END Start
