MIRRORRAM EQU 7E0000h           ;offset into SNESMEM of mirrored RAM


InitSNES PROC                 ;Procedure to initialize SNES registers
  IFDEF DEBUGON
    ;set event parameter here for SNES Initialize event
    mov eax,0
    call DebugEvent             ;generate debug event
  ENDIF
  ;clear registers here
  ;reset SPU registers
  ;clear memory here
  ret
ENDP

SNESFullMemRead PROC
  ;data is in ecx, pointer is in edi
  test edi,8000h
  jnz MemRead1
  push ebx
  mov ebx,edi
  cmp bh,20h
  ja MemRead2
  and ebx,65535
  mov cl,BYTE PTR [ebx+ebp+SNESMEM+MIRRORRAM]
  pop ebx
  ret
  MemRead2:
  cmp bh,21h
  jne MemRead3
  call rRead21
  pop ebx
  ret
  MemRead3:
  cmp bh,42h
  jne MemRead4
  call rRead42
  pop ebx
  ret
  MemRead4:
  cmp bh,43h
  jne MemRead5
  call rRead43
  pop ebx
  ret
  MemRead5:
  and ebx,32767
  mov cl,BYTE PTR [ebx+ebp+SNESMEM+MIRRORRAM]   ;How's that for fast?
  pop ebx
  ret
  MemRead1:
  mov cl,BYTE PTR [edi+ebp+SNESMEM]   ;How's that for fast?
  ret
ENDP
SNESFullMemWrite PROC
  ;data is in ecx, pointer is in edi
  test edi,8000h
  jnz MemWrite1
  push ebx
  mov ebx,edi
  cmp bh,20h
  ja MemWrite2
  and ebx,65535
  mov BYTE PTR [ebx+ebp+SNESMEM+MIRRORRAM],cl
  pop ebx
  ret
  MemWrite2:
  cmp bh,21h
  jne MemWrite3
  call rWrite21
  pop ebx
  ret
  MemWrite3:
  cmp bh,42h
  jne MemWrite4
  call rWrite42
  pop ebx
  ret
  MemWrite4:
  cmp bh,43h
  jne MemWrite5
  call rWrite43
  pop ebx
  ret
  MemWrite5:
  and ebx,32767
  mov BYTE PTR [ebx+ebp+SNESMEM+MIRRORRAM],cl   ;How's that for fast?
  pop ebx
  ret
  MemWrite1:
  mov BYTE PTR [edi+ebp+SNESMEM],cl   ;How's that for fast?
  ret
ENDP


;ͻ
;                    $2100-$21FF Read and Write                       
;ͼ
rRead21 PROC
  IFDEF DEBUGON
    push eax
    mov eax,1
    call DebugEvent
    pop eax
  ENDIF
  mov ebx,edi
  movzx ebx,bl
  shl ebx,2
  jmp [rJ21+ebx]
  EndR21:
  ret
ENDP

rWrite21 PROC
  IFDEF DEBUGON
    push eax
    mov eax,4
    call DebugEvent
    pop eax
  ENDIF
  mov ebx,edi
  movzx ebx,bl
  shl ebx,2
  jmp [wJ21+ebx]
  EndW21:
  ret
ENDP

r21xx:
  jmp EndR21

w21xx:
  jmp EndW21

w2100:
  mov [r2100],cl
  jmp EndW21
w2105:
  mov BYTE PTR [vTILESIZE],cl
  push ecx
  and cl,07h
  mov [vMODE],cl
  pop ecx
  jmp EndW21
w2107:
  push ecx
  mov [vSC1],cl
  shr cl,2
  movzx ecx,cl
  shl ecx,11    
  add ecx,ebp
  add ecx,SVRAM
  mov [vBG1],ecx
  pop ecx
  jmp EndW21
w2108:
  push ecx
  mov [vSC2],cl
  shr cl,2
  movzx ecx,cl
  shl ecx,11    
  add ecx,ebp
  add ecx,SVRAM
  mov [vBG2],ecx
  pop ecx
  jmp EndW21
w2109:
  push ecx
  mov [vSC3],cl
  shr cl,2
  movzx ecx,cl
  shl ecx,11    
  add ecx,ebp
  add ecx,SVRAM
  mov [vBG3],ecx
  pop ecx
  jmp EndW21
w210A:
  push ecx
  mov [vSC4],cl
  shr cl,2
  movzx ecx,cl
  shl ecx,11    
  add ecx,ebp
  add ecx,SVRAM
  mov [vBG4],ecx
  pop ecx
  jmp EndW21
w210B:
  push ecx
  and cl,0fh
  movzx ecx,cl
  shl ecx,13
  add ecx,ebp
  add ecx,SVRAM
  mov [vTILE1],ecx
  pop ecx
  push ecx
  and cl,0f0h
  movzx ecx,cl
  shl ecx,9
  add ecx,ebp
  add ecx,SVRAM
  mov [vTILE2],ecx
  pop ecx
  jmp EndW21
w210C:
  push ecx
  and cl,0fh
  movzx ecx,cl
  shl ecx,13
  add ecx,ebp
  add ecx,SVRAM
  mov [vTILE3],ecx
  pop ecx
  push ecx
  and cl,0f0h
  movzx ecx,cl
  shl ecx,9
  add ecx,ebp
  add ecx,SVRAM
  mov [vTILE4],ecx
  pop ecx
  jmp EndW21
w2115:
  mov [r2115],cl
  jmp EndW21
w2116:
  mov [r2116],cl
  jmp EndW21
w2117:
  mov [r2117],cl
  shl WORD PTR [r2116],1
  jmp EndW21
w2118:
  movzx ebx,WORD PTR [r2116]
  mov [ebp+ebx+SVRAM],cl
  test [r2115],80h
  jnz SHORT w2118S
  ;implement multi-size increments!
  inc WORD PTR [r2116]
  inc WORD PTR [r2116]
  w2118S:
  jmp EndW21
w2119:
  movzx ebx,WORD PTR [r2116]
  inc ebx
  mov [ebp+ebx+SVRAM],cl
  test [r2115],80h
  jz SHORT w2119S
  ;implement multi-size increments!
  inc WORD PTR [r2116]
  inc WORD PTR [r2116]
  w2119S:
  jmp EndW21
w2121:
  mov [r2121],cl
  jmp EndW21
w2122:
  cmp BYTE PTR [r2122],0
  jnz SHORT w2122S
  xor ebx,ebx
  mov bl,[r2121]
  shl ebx,1
  mov BYTE PTR [vCLUT+ebx],cl
  mov BYTE PTR [r2122],1
  jmp EndW21
  w2122S:
  xor ebx,ebx
  mov bl,[r2121]
  shl ebx,1
  mov BYTE PTR [vCLUT+ebx+1],cl
  mov BYTE PTR [r2122],0
  IFDEF VIDEOON
    push ecx
    push edx
    push eax
    mov eax,ecx
    mov cx,[vCLUT+ebx]
    mov dh,cl
    and dh,31
    shl dh,1
    shl cx,4
    and ch,62
    shr al,1
    mov cl,al
    xor ebx,ebx
    mov bl,[r2121]
    mov ax,1010h
    int 10h
    pop eax
    pop edx
    pop ecx
  ENDIF
  inc [r2121]
  jmp EndW21
w212C:
  mov [r212C],cl
  jmp EndW21


rJ21 dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx
     dd r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx,r21xx

wJ21 dd w2100,w21xx,w21xx,w21xx,w21xx,w2105,w21xx,w2107,w2108,w2109,w210A,w210B,w210C,w21xx,w21xx,w21xx
     dd w21xx,w21xx,w21xx,w21xx,w21xx,w2115,w2116,w2117,w2118,w2119,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx
     dd w21xx,w2121,w2122,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w212C,w21xx,w21xx,w21xx
     dd w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx
     dd w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx
     dd w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx
     dd w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx
     dd w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx
     dd w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx
     dd w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx
     dd w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx
     dd w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx
     dd w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx
     dd w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx
     dd w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx
     dd w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx,w21xx

;ͻ
;                    $4200-$42FF Read and Write                       
;ͼ
rRead42 PROC
  IFDEF DEBUGON
    push eax
    mov eax,2
    call DebugEvent
    pop eax
  ENDIF
  mov ebx,edi
  movzx ebx,bl
  shl ebx,2
  jmp [rJ42+ebx]
  EndR42:
  ret
ENDP

rWrite42 PROC
  IFDEF DEBUGON
    push eax
    mov eax,5
    call DebugEvent
    pop eax
  ENDIF
  mov ebx,edi
  movzx ebx,bl
  shl ebx,2
  jmp [wJ42+ebx]
  EndW42:
  ret
ENDP

r42xx:
  jmp EndR42
rd4210:
  mov cl,[r4210]
  and [r4210],7fh
  jmp EndR42


w42xx:
  jmp EndW42

w4200:
  mov [r4200],cl
  jmp EndW42

w420B:   ;DMA enable register [MDMAEN]
  push edx                            ;preserve registers
  mov edx,7                           ;Start with DMA channel 7
  w420BLoop1:                         ;
  btr ecx,edx                         ;Check for enabled DMA Channel and clear
  jnc w420BNoDMA                      ;
  call DMATransfer                    ;if enabled, do DMA transfer
  w420BNoDMA:                         ;
  dec edx                             ;next DMA channel
  jns w420BLoop1                      ;
  pop edx                             ;restore registers
  jmp EndW42                          ;done







rJ42 dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd rd4210,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx
     dd r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx,r42xx

wJ42 dd w4200,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w420B,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx
     dd w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx,w42xx

;ͻ
;                    $4300-$43FF Read and Write                       
;ͼ
r43DATA db 256 DUP (0)

rRead43 PROC
  IFDEF DEBUGON
    push eax
    mov eax,3
    call DebugEvent
    pop eax
  ENDIF
  mov ebx,edi
  movzx ebx,bl
  movzx ecx,BYTE PTR [r43DATA+ebx]
  ret
ENDP

rWrite43 PROC
  IFDEF DEBUGON
    push eax
    mov eax,6
    call DebugEvent
    pop eax
  ENDIF
  mov ebx,edi
  movzx ebx,bl
  mov BYTE PTR [r43DATA+ebx],cl
  ret
ENDP

