;  Textmode User Interface routines for the RSRSNES 0.20 debugger

TUI EQU ON                                    ;Let compiler know TUI is in use
tuiBUFFER EQU 1024                            ;Offset into TUIMEM of Buffers

tuiVPTR dd 0                                  ;Pointer to Text Mode VRAM
tuiCOLOR db 17h                               ;Current color attribute
tuiTEMPSTR db '0123456789ABCDEF'              ;temporary string space

tuiMouseOnF dd 1                              ;Mouse On flag
tuiMouseX dd 0                                ;Mouse pointer X
tuiMouseY dd 0                                ;Mouse pointer Y
tuiMouseB dd 0                                ;Mouse button status

;Window Descriptor Table  (offsets into a window record)
tWinXY EQU 0                                  ;XY VRAM offset of Window
tWinW EQU 4                                   ;Window Width
tWinH EQU 8                                   ;Window Height
tWinID EQU 12                                 ;Window's ID number
tWinEvents EQU 16                             ;Window Message mask
tWinHDC EQU 20                                ;Window buffer offset
tWinType EQU 24                               ;Window type
tWinZ EQU 28                                  ;Z Order of window
tWinBufW EQU 32                               ;Scroll mode Virtual Width
tWinBufH EQU 36                               ;Scroll mode Virtual Height
tWinTitle EQU 40                              ;Pointer to Window's Title
tWinPY EQU 44                                 ;Cursor Y
tWinPX EQU 48                                 ;Cursor X
tWinExtra EQU 44                              ;Padding to 64 bytes

tWin_Visible EQU 1                            ;Window type flags
tWin_Scroll EQU 2                             ;enables backbuffering/scrolling
tWin_HotSpot EQU 4                            ;enables Hotspot detection
tWin_Edit EQU 8                               ;enables keyboard input

                                              ;
tuiConstruct PROC
  call tuiGETVIDPTR
  ;create initial windows/menus/screen objects here
  call tuiResetWindows
  call tuiMouseOn
  ;call tuiDrawScreen
ENDP
tuiDestruct PROC
  call tuiCLS
  call tuiMouseOff
ENDP

tuiGETVIDPTR PROC                           ;Procedure to get Text Mode VRAM PTR
  mov ax,0EE02h                               ;
  int 31h                                     ;
  neg ebx                                     ;Get PTR to physical offset 0
  add ebx,0b8000h                             ;Add text mode VRAM physical PTR
  mov [tuiVPTR],ebx                           ;Get relative pointer to VRAM

  ret                                         ;done
ENDP

tuiCLS PROC                                 ;Procedure to clear TXT screen
  cld                                         ;clear direction flag
  push edi                                    ;preserve registers
  push ecx                                    ;
  push eax                                    ;
  mov eax,07000700h                           ;set output DWord
  mov edi,[tuiVPTR]                           ;get VRAM pointer
  mov ecx,1000                                ;number of DWORDs to fill screen
  rep STOSD                                   ;clear screen
  pop eax                                     ;restore registers
  pop ecx                                     ;
  pop edi                                     ;
  ret                                         ;done
ENDP


;IN: edx=String pointer  cl=max width ch=color (0==no change) ebx=XY offset
;ebx is updated to end of text
tuiPrint PROC                               ;Procedure to display text
  push edi                                    ;preserve registers
  push eax                                    ;
  push ecx                                    ;
  push edx                                    ;
  mov edi,[tuiVPTR]                           ;get VRAM pointer
  tuiPrintLoop:                               ;
  mov al,BYTE PTR [edx]                       ;Get char from string
  inc edx                                     ;increment input ptr
  dec cl                                      ;decrement max width count
  js tuiPrintDone                             ;check for max width
  cmp al,0                                    ;check for NULL terminator
  jz tuiPrintDone                             ;
  mov BYTE PTR [edi+ebx],al                   ;store char to screen
  inc ebx                                     ;increment screen offset ptr
  cmp ch,0                                    ;check for color
  jz tuiPrintNoColor                          ;
  mov BYTE PTR [edi+ebx],ch                   ;store color to screen
  tuiPrintNoColor:                            ;
  inc ebx                                     ;increment screen offset ptr
  jmp SHORT tuiPrintLoop                      ;get next string char
  tuiPrintDone:                               ;
  pop edx                                     ;restore registers
  pop ecx                                     ;
  pop eax                                     ;
  pop edi                                     ;
  ret                                         ;done
ENDP

;IN:  eax=number  cl=digits ch=color ebx=XY offset
tuiPrintDNumB PROC                          ;Prints a BYTE in decimal
  push eax                                    ;preserve registers
  push edx                                    ;
  push ecx                                    ;
  push ebx                                    ;
  mov edx,OFFSET tuiTEMPSTR                   ;get temporary string buffer
  mov BYTE PTR [edx+3],0                      ;set NULL terminator
  mov ebx,eax                                 ;duplicate input number
  mov cl,100                                  ;set first divisor
  mov ch,0                                    ;init empty placeholder count
  div cl                                      ;Hundreds division
  cmp al,0                                    ;check for empty placeholder
  jnz tuiPrintDNumB_H                         ;
  inc ch                                      ;skip empty placeholder in outpt
  tuiPrintDNumB_H:                            ;
  add al,48                                   ;convert Hundreds into ASCII
  mov BYTE PTR [edx],al                       ;save digit
  mov al,ah                                   ;duplicate remainder (tens,ones)
  xor ah,ah                                   ;clear upper byte
  mov cl,10                                   ;set second divisor
  div cl                                      ;Tens division
  cmp al,0                                    ;check for empty placeholder
  jnz tuiPrintDNumB_T                         ;
  cmp ch,0                                    ;check for hundreds placeholder
  jz tuiPrintDNumB_T                          ;
  inc ch                                      ;skip empty placeholder in outpt  tuiPrintDNumB_T:                            ;
  tuiPrintDNumB_T:
  add al,48                                   ;convert Tens into ASCII
  mov BYTE PTR [edx+1],al                     ;save digit
  add ah,48                                   ;convert Ones into ASCII
  mov BYTE PTR [edx+2],ah                     ;save digit
  movzx ecx,ch
  add edx,ecx                                 ;set outpt to first nonzero dgt
  pop ebx                                     ;restore registers
  pop ecx                                     ;
  call tuiPrint                               ;print number
  pop edx                                     ;restore registers
  pop eax                                     ;
  ret                                         ;done
ENDP

;IN: edx=Title pointer cl=width ch=height ebx=screen location
;Min. width=8  Min. Height=3

tuiDrawWindow PROC                          ;Draw a standard window
  push ebx                                    ;preserve registers
  push eax                                    ;
  push edi                                    ;
  push esi                                    ;
                                              ;
  push edx                                    ;preserve title pointer
                                              ;
  and ebx,-2                                  ;ensure proper VRAM alignment
  add ebx,[tuiVPTR]                           ;add in VRAM pointer
  cmp cl,8                                    ;check window width
  jnb tuiDWNoMinW                             ;
  mov cl,8                                    ;set to minimum if necessary
  tuiDWNoMinW:                                ;
  cmp ch,3                                    ;check window height
  jnb tuiDWNoMinH                             ;
  mov ch,3                                    ;set to minimum if necessary
  tuiDWNoMinH:                                ;
  mov edi,0                                   ;initialize output pointer
  mov eax,1700h                               ;initialize output word
  mov edx,ecx                                 ;initialize counters
  mov esi,ecx                                 ;calculate output increments
  and esi,255                                 ;   |
  shl esi,1                                   ;   |
  neg esi                                     ;   |
  add esi,160                                 ;   |
  and esi,255                                 ;done calculating output inc

  tuiDWHLoop1:                                ;
  mov WORD PTR [ebx+edi],ax                   ;store output byte
  inc edi                                     ;increment output pointer
  inc edi                                     ;
  dec dl                                      ;decrement width count
  jnz tuiDWHLoop1                             ;check for width
  mov dl,cl                                   ;reset width count
  add edi,esi                                 ;increment output to next line
  dec dh                                      ;decrement height count
  jnz tuiDWHLoop1                             ;check for height

  mov ah,[tuiCOLOR]                           ;get border color
  mov al,186                                  ;set output char
  mov edx,ecx                                 ;initialize counters
  mov edi,ebx                                 ;initialize output ptr
  mov esi,ecx                                 ;Calculate end of line
  and esi,255                                 ;
  dec esi                                     ;
  shl esi,1                                   ;

  tuiDWHLoop2:                                ;
  mov WORD PTR [edi],ax                       ;store output byte
  mov WORD PTR [edi+esi],ax                   ;store output byte
  add edi,160                                 ;increment output pointer
  dec dh                                      ;decrement height count
  jnz tuiDWHLoop2                             ;check for height

  sub edi,160                                 ;Calculate end of window
  sub edi,ebx                                 ;
  mov esi,edi                                 ;
  mov edi,ebx                                 ;initialize output ptr
  mov al,205                                  ;set output char
  mov edx,ecx                                 ;initialize counters

  tuiDWHLoop3:                                ;
  mov WORD PTR [edi],ax                       ;store output byte
  mov WORD PTR [edi+esi],ax                   ;store output byte
  add edi,2                                   ;increment output pointer
  dec dl                                      ;decrement width count
  jnz tuiDWHLoop3                             ;check for height

  sub edi,2                                   ;Draw corners
  mov BYTE PTR [ebx],201                      ;
  mov BYTE PTR [ebx+esi],200                  ;
  mov BYTE PTR [edi],187                      ;
  mov BYTE PTR [edi+esi],188                  ;
                                              
  mov BYTE PTR [ebx+4],'['                    ;Draw controls
  mov BYTE PTR [ebx+6],254                    ;
  mov BYTE PTR [ebx+8],']'                    ;
  and ah,0f0h                                 ;
  or ah,0Ch                                   ;
  mov BYTE PTR [ebx+7],ah                     ;

  pop edx                                     ;restore title pointer
  or ah,0fh                                   ;
  mov ch,ah                                   ;set Title color
  sub ebx,[tuiVPTR]                           ;get window starint offset
  add ebx,12                                  ;set title starting offset
  sub cl,6                                    ;set max title width
  call tuiPrint                               ;Print title

  pop esi                                     ;restore registers
  pop edi                                     ;
  pop eax                                     ;
  pop ebx                                     ;
  ret                                         ;done
ENDP

tuiPaint PROC                               ;Redraw all visible windows
  call tuiCLS                                 ;clear the screen
  mov ecx,16                                  ;ZOrder loop
  tuiPaintLoop1:                              ;
  mov edx,16                                  ;Window loop
  tuiPaintLoop2:                              ;
  mov ebx,edx                                 ;
  shl ebx,6                                   ;get Window Record pointer
  mov eax,[ebp+ebx+TUIMEM+tWinZ]              ;get Window edx's Z order
  cmp eax,ecx                                 ;check for current Z
  je tuiPaintDrawWin                          ;if current Z, draw window
  tuiPaintDrawDone:                           ;
  dec edx                                     ;get next window
  jns tuiPaintLoop2                           ;
  dec ecx                                     ;get next Z
  jns tuiPaintLoop1                           ;
  jmp tuiPaint2

  tuiPaintDrawWin:                            ;routine to render a Window
  mov [tuiCOLOR],17h                          ;preset border color
  mov eax,[ebp+ebx+TUIMEM+tWinType]           ;Get Window Type info
  test eax,1                                  ;check if its visible
  jz tuiPaintDrawDone                         ;if not, we're done drawing
  push ecx                                    ;preserve Z
  push edx                                    ;preserve Window
  push eax                                    ;preserve Window Type info
  push ebx                                    ;preserve the Window Record ptr
  cmp ecx,1                                   ;if Z=1, highlight window border
  jne tuiPaintNotZ1                           ;
  mov [tuiCOLOR],6Eh                          ;
  tuiPaintNotZ1:                              ;
  mov edx,[ebp+ebx+TUIMEM+tWinTitle]          ;get the Title pointer
  mov ecx,[ebp+ebx+TUIMEM+tWinW]              ;get the Window Width
  mov eax,[ebp+ebx+TUIMEM+tWinH]              ;get the Window Height
  mov ch,al                                   ;
  mov eax,[ebp+ebx+TUIMEM+tWinXY]             ;Get the Window's XY pointer
  mov ebx,eax                                 ;
  call tuiDrawWindow                          ;Draw the window shell
  pop ebx                                     ;restore the Window Record ptr
  pop eax                                     ;restore the Window Type info
  ;Done drawing window shell

  mov edx,ebx                                 ;Calculate buffer offset
  shl edx,6                                   ;
  add edx,TUIMEM+tuiBUFFER                    ;
  add edx,ebp                                 ;
  call tuiWTextPaint                          ;render window's text
  pop edx                                     ;Restore Window
  pop ecx                                     ;Restore Z
  jmp tuiPaintDrawDone                        ;
  tuiPaint2:
;  cmp [tuiMouseOnF],0
  je NoMousePointer
  mov ebx,[tuiMouseY]
  add ebx,[tuiMouseX]
  add ebx,[tuiVPTR]
  mov al,BYTE PTR [ebx+1]
  not al
  mov BYTE PTR [ebx+1],al
  NoMousePointer:
  ret                                         ;done
ENDP                                          ;

tuiResetWindows PROC                        ;Clear all window records
  push edi                                    ;preserve registers
  push eax                                    ;
  push ecx                                    ;
  mov edi,TUIMEM                              ;
  add edi,ebp                                 ;get pointer to Window records
  mov ecx,256                                 ;number of Dwords to clear
  cld                                         ;clear direction flag
  xor eax,eax                                 ;clear output Dword
  rep stosd                                   ;clear memory
  pop ecx                                     ;restore registers
  pop eax                                     ;
  pop edi                                     ;
  ret                                         ;done
ENDP

;In:  ebx: HWind
tuiWinCLS PROC                              ;Clear a Window 
  push eax
  push ebx                                    ;preserve registers
  push ecx                                    ;
  push edi                                    ;

  shl ebx,6                                   ;get Window Register pointer
  mov DWORD PTR [ebp+ebx+TUIMEM+tWinPX],0     ;reset Window cursor
  mov DWORD PTR [ebp+ebx+TUIMEM+tWinPY],0     ;
  shl ebx,6                                   ;get Window Buffer pointer
  mov edi,ebx                                 ;
  add edi,ebp                                 ;
  add edi,TUIMEM+tuiBUFFER                    ;
  cld                                         ;
  mov ecx,1024                                ;size of Window buffer (4096)
  xor eax,eax                                 ;clear output dword
  rep stosd                                   ;clear buffer
                                              
  pop edi                                     ;restore registers
  pop ecx                                     ;
  pop ebx                                     ;
  pop eax
  ret                                         ;done
ENDP

;IN:  edx=string  ebx=HWind
tuiWPrint PROC                              ;Print to a window
  push eax
  push ebx                                    ;preserve registers
  push ecx                                    ;
  push edx
  push edi                                    ;

  shl ebx,6                                   ;get Window Register pointer
  mov eax,[ebp+ebx+TUIMEM+tWinPX]             ;get Window cursor
  add eax,[ebp+ebx+TUIMEM+tWinPY]             ;

  mov edi,ebx                                 ;
  shl edi,6                                   ;get Window Buffer pointer
  add edi,ebp                                 ;
  add edi,TUIMEM+tuiBUFFER                    ;
  add edi,eax                                 ;

  tuiWPrintLoop1:                             ;
  mov al,BYTE PTR [edx]                       ;get char to print
  inc edx                                     ;increment input pointer
  cmp al,13                                   ;check for carrage return
  jne tuiWPrintNEOL                           ;
  mov DWORD PTR [ebp+ebx+TUIMEM+tWinPX],0     ;On Carrage return, clear PX
  add DWORD PTR [ebp+ebx+TUIMEM+tWinPY],128   ;increment PY (no checking!)
  mov eax,[ebp+ebx+TUIMEM+tWinPX]             ;get Window cursor
  add eax,[ebp+ebx+TUIMEM+tWinPY]             ;
  mov edi,ebx                                 ;
  shl edi,6                                   ;get Window Buffer pointer
  add edi,ebp                                 ;
  add edi,TUIMEM+tuiBUFFER                    ;
  add edi,eax                                 ;
  jmp tuiWPrintLoop1                          ;
  tuiWPrintNEOL:                              ;
  cmp al,0                                    ;check for end of string
  je tuiWPrintDone                            ;
  mov BYTE PTR [edi],al                       ;Store char
  inc edi                                     ;increment output pointer
  inc DWORD PTR [ebp+ebx+TUIMEM+tWinPX]       ;On Carrage return, clear PX
  jmp tuiWPrintLoop1                          ;
  tuiWPrintDone:                              ;
                                                  
  pop edi                                     ;restore registers
  pop edx
  pop ecx                                     ;
  pop ebx                                     ;
  pop eax
  ret                                         ;done
ENDP

;IN:  edx=buffer start  ebx=record offset
tuiWTextPaint PROC                          ;Draw a window's text
  push eax                                    ;preserve registers
  push ecx                                    ;
  push edx                                    ;
  push edi                                    ;
  push esi                                    ;
  mov edi,[ebp+ebx+TUIMEM+tWinXY]             ;get screen pointer
  add edi,[tuiVPTR]                           ;
  add edi,162                                 ;
  mov ecx,[ebp+ebx+TUIMEM+tWinW]              ;Get Width and Height
  mov ch,[ebp+ebx+TUIMEM+tWinH]               ;
  sub cl,2                                    ;
  sub ch,2                                    ;
  ;scrollbar test here?                       ;
  mov esi,0                                   ;init X output
  tuiWTPaintLoop1:                            ;
  mov al,[edx+esi]                            ;
  mov [edi+esi*2],al                          ;draw char
  inc esi                                     ;
  dec cl                                      ;next column
  jnz tuiWTPaintLoop1                         ;
  mov cl,[ebp+ebx+TUIMEM+tWinW]               ;reset width counter
  sub cl,2                                    ;
  ;scrollbar test here?                       ;
  add edx,128                                 ;Update output to next row
  add edi,160                                 ;
  xor esi,esi                                 ;reset X output
  dec ch                                      ;next row
  jnz tuiWTPaintLoop1                         ;
  pop esi                                     ;restore registers
  pop edi                                     ;
  pop edx                                     ;
  pop ecx                                     ;
  pop eax                                     ;
  ret                                         ;done
ENDP

; IN: AL=byte   EDX=buffer
HEXDIGITS db '0123456789ABCDEF'               ;Digits for Hex conversion
tuiHexStringB PROC                          ;Convert al into a HEX string
  push ebx                                    ;preserve registers
  push ecx                                    ;
  movzx ebx,al                                ;
  and bl,15                                   ;
  mov cl,[OFFSET HEXDIGITS+ebx]               ;
  mov [edx+1],cl                              ;Low nibble
  mov bl,al                                   ;
  shr ebx,4                                   ;
  mov cl,[OFFSET HEXDIGITS+ebx]               ;
  mov [edx],cl                                ;High nibble
  mov BYTE PTR [edx+2],0                      ;NULL termination
  pop ecx                                     ;restore registers
  pop ebx                                     ;
  ret                                         ;done
ENDP
tuiHexStringW PROC                          ;Convert ax into a HEX string
  push ebx                                    ;preserve registers
  push ecx                                    ;
  movzx ebx,al                                ;
  and bl,15                                   ;
  mov cl,[OFFSET HEXDIGITS+ebx]               ;
  mov [edx+3],cl                              ;
  mov bl,al                                   ;
  shr ebx,4                                   ;
  mov cl,[OFFSET HEXDIGITS+ebx]               ;
  mov [edx+2],cl                              ;
  mov bl,ah                                   ;
  and bl,15                                   ;
  mov cl,[OFFSET HEXDIGITS+ebx]               ;
  mov [edx+1],cl                              ;
  mov bl,ah                                   ;
  shr ebx,4                                   ;
  mov cl,[OFFSET HEXDIGITS+ebx]               ;
  mov [edx],cl                                ;
  mov BYTE PTR [edx+4],0                      ;
  pop ecx                                     ;restore registers
  pop ebx                                     ;
  ret                                         ;done
ENDP
tuiBinStringB PROC
  push ebx                                    ;preserve registers
  test eax,128                                ;
  setnz bl                                    ;
  add bl,48                                   ;
  mov [edx+0],bl                              ;Bit 7
  test eax,64                                 ;
  setnz bl                                    ;
  add bl,48                                   ;
  mov [edx+1],bl                              ;Bit 6
  test eax,32                                 ;
  setnz bl                                    ;
  add bl,48                                   ;
  mov [edx+2],bl                              ;Bit 5
  test eax,16                                 ;
  setnz bl                                    ;
  add bl,48                                   ;
  mov [edx+3],bl                              ;Bit 4
  test eax,8                                  ;
  setnz bl                                    ;
  add bl,48                                   ;
  mov [edx+4],bl                              ;Bit 3
  test eax,4                                  ;
  setnz bl                                    ;
  add bl,48                                   ;
  mov [edx+5],bl                              ;Bit 2
  test eax,2                                  ;
  setnz bl                                    ;
  add bl,48                                   ;
  mov [edx+6],bl                              ;Bit 1
  test eax,1                                  ;
  setnz bl                                    ;
  add bl,48                                   ;
  mov [edx+7],bl                              ;Bit 0
  mov BYTE PTR [edx+8],0                      ;NULL terminator
  pop ebx                                     ;
  ret                                         ;done
ENDP

tuiINKEY PROC
  mov ah,01h
  int 16h
  ret
ENDP
tuiGETCH PROC
  GetchLoop:
  call tuiMouseUpdate
  mov ah,1
  int 16h
  jz GetchLoop
  mov ah,0
  int 16h
  ret
ENDP

tuiMouseOn PROC
  mov eax,0
  int 33h
  cmp ax,0
  jne tuiMouseOnCheck
  mov [tuiMouseOnF],0
;  ret
  tuiMouseOnCheck:
  mov eax,3
  xor edx,edx
  mov ecx,edx
  int 33h
  shr ecx,7
  mov eax,edx
  shr eax,1
  shl edx,3
  add eax,edx
  mov [tuiMouseOnF],1
  mov [tuiMouseX],ecx
  mov [tuiMouseY],eax
  ret
ENDP
tuiMouseOff PROC
  mov [tuiMouseOnF],0
  ret
ENDP
tuiMouseCheckMsg db 'Mouse read!',0
tuiMouseGet PROC
  mov eax,3
  xor edx,edx
  mov ecx,edx
  int 33h
  shr ecx,2
  mov eax,edx
  shl eax,2
  shl edx,4
  add eax,edx
  mov [tuiMouseX],ecx
  mov [tuiMouseY],eax
  mov [tuiMouseB],ebx
;  mov ebx,14
;  mov edx,OFFSET tuiMouseCheckMsg
;  call tuiWPrint
  ret
ENDP
tuiMouseUpdate PROC
  cmp [tuiMouseOnF],0
;  je NoMousePointerU
  mov ebx,[tuiMouseY]
  add ebx,[tuiMouseX]
  add ebx,[tuiVPTR]
  mov al,BYTE PTR [ebx+1]
  not al
  mov BYTE PTR [ebx+1],al
  call tuiMouseGet
  mov ebx,[tuiMouseY]
  add ebx,[tuiMouseX]
  add ebx,[tuiVPTR]
  mov al,BYTE PTR [ebx+1]
  not al
  mov BYTE PTR [ebx+1],al
  NoMousePointerU:
  ret
ENDP
