; *****************************************************************************
; *****************************************************************************
;
;                 Tweak video display to 256x224 pixels
;
; *****************************************************************************
; *****************************************************************************

TweakVideo PROC NEAR
  mov     dx,03D4h                ; out 3d4,11
  mov     al,11h
  out     dx,al
  mov     dx,3D5h                 ; in 3d5
  in      al,dx
  push    eax                      ; and save it
  mov     dx,3D4h                 ; out 3d4,11
  mov     al,11h
  out     dx,al
  pop     eax                      ; out old value & 7F to 3D5
  and     al,07Fh
  mov     dx,3D5h
  out     dx,al
  mov     ebx,OFFSET TweakTable
Tweak1:
  cmp     WORD PTR [ebx],-1            ; check for end
  je      Tweak2
  call    TweakRegister           ; do the tweak
  add     ebx,4
  jmp     Tweak1
Tweak2:                                 ; we've finished tweaking
  ret
ENDP

TweakRegister PROC NEAR
  mov     cx,[ebx]                 ; get port number
  cmp     cx,03C0h
  je      TwAttCon                ; ATTCON ADDR (3c0) is different
  cmp     cx,03C2h
  je      TwMiscEn                ; MISC (3c2) is different
  cmp     cx,03C3h
  je      TwMiscEn                ; ENABLE (3c3) is different

  mov     dx,[ebx]                 ; out port,index
  mov     al,[ebx+2]
  out     dx,al
  inc     dx                      ; out port+1,value
  mov     al,[ebx+3]
  out     dx,al
  ret
TwAttCon:
  mov     dx,03Dah                ; read status addr
  in      al,dx                   ; reset r/w flipflop
  mov     dx,03C0h                ; out attrcon,index | 20
  mov     al,[ebx+2]
  or      al,020h
  out     dx,al
  mov     al,[ebx+3]                ; out attrcon,value
  out     dx,al
  ret
TwMiscEn:                               ; these are just out port,value
  mov     dx,[ebx]
  mov     al,[ebx+3]
  out     dx,al
  ret

TweakTable:
; port 03c2 register 0 value 227
 dw 03c2h
 db 0,227
; port 03d4 register 0 value 95
 dw 03d4h
 db 0,95
; port 03d4 register 1 value 63
 dw 03d4h
 db 1,63
; port 03d4 register 2 value 64
 dw 03d4h
 db 2,64
; port 03d4 register 3 value 130
 dw 03d4h
 db 3,130
; port 03d4 register 4 value 74
 dw 03d4h
 db 4,74
; port 03d4 register 5 value 154
 dw 03d4h
 db 5,154
; port 03d4 register 6 value 35
 dw 03d4h
 db 6,35
; port 03d4 register 7 value 178
 dw 03d4h
 db 7,178
; port 03d4 register 8 value 0
 dw 03d4h
 db 8,0
; port 03d4 register 9 value 97
 dw 03d4h
 db 9,97
; port 03d4 register 16 value 0
 dw 03d4h
 db 16,0
; port 03d4 register 17 value 172
 dw 03d4h
 db 17,172
; port 03d4 register 18 value 191
 dw 03d4h
 db 18,191
; port 03d4 register 19 value 32
 dw 03d4h
 db 19,32
; port 03d4 register 20 value 64
 dw 03d4h
 db 20,64
; port 03d4 register 21 value 1
 dw 03d4h
 db 21,1
; port 03d4 register 22 value 10
 dw 03d4h
 db 22,10
; port 03d4 register 23 value 163
 dw 03d4h
 db 23,163
; port 03c4 register 1 value 1
 dw 03c4h
 db 1,1
; port 03c4 register 4 value 14
 dw 03c4h
 db 4,14
; port 03ce register 5 value 64
 dw 03ceh
 db 5,64
; port 03ce register 6 value 5
 dw 03ceh
 db 6,5
; port 03c0 register 16 value 65
 dw 03c0h
 db 16,65
; port 03c0 register 19 value 0
 dw 03c0h
 db 19,0
; port 03c0 register 19 value 0
 dw 03c0h
 db 19,0
        dw      -1
ENDP

