;Screen Rendering engine
;No register preservation;  these are level-1 functions

vMODE db 0   ;current SNES Video mode (from $2105)
vBG1 dd 0    ;pointers into VRAM for BG maps  (from $2107-$210A)
vBG2 dd 0
vBG3 dd 0
vBG4 dd 0
vTILE1 dd 0  ;pointers into VRAM for BG tiles (from $210B-$210C)
vTILE2 dd 0
vTILE3 dd 0
vTILE4 dd 0
vTILESIZE db 0 ;current tile sizes (from $2105)
vSC1 db 0    ;Screen sizes
vSC2 db 0
vSC3 db 0
vSC4 db 0
vCOLOR db 0
vCLUT dw 256 DUP (32767)
vZERO dw 0
vSCREEN dw 0A000h
vTH db 0  ;vertical tile count
vTV db 0  ;horizontal tile count
vLN db 0  ;render line #
vBGC dd 0   ;currently rendering BG SC pointer
vTILEC dd 0 ;currently rendering BG Tile pointer
vBGCHOff dw 0 ;Currently rendering BG offset
vBG1HOff dw 0 ;background offset (for scrolling)
vBG2HOff dw 0 ;
vBG3HOff dw 0 ;
vBG4HOff dw 0 ;
vBGCVOff dw 0 ;Currently rendering BG offset
vBG1VOff dw 0 ;background offset (for scrolling)
vBG2VOff dw 0 ;
vBG3VOff dw 0 ;
vBG4VOff dw 0 ;
vColorOr db 0 ;forced palette mask (for mode 0)
vForcePix db 0 ;flag to force color 0 output (for lowest priority BG)
vSPTILE dd 0  ;Sprite tile pointer
vSPDATA1 db 512 dup (0)  ;buffer for OAM data
vSPDATA2 db 32 dup (0)   ;buffer for extended OAM data
mRelativeVRAM dd 0       ;pointer to physical VRAM address (0A0000h)

InitVideo PROC
  mov ax,0EE02h                               ;
  int 31h                                     ;
  neg ebx                                     ;Get PTR to physical offset 0
  add ebx,0a0000h                             ;Add text mode VRAM physical PTR
  mov [mRelativeVRAM],ebx                     ;Get relative pointer to VRAM
  mov ax,0013h                                ;
  int 10h                                     ;Enter graphics mode
  call TweakVideo                             ;Straigt from NESA (converted for TASM)
  ret                                         ;done
ENDP

StopVideo PROC
  mov ax,0003h                                ;
  int 10h                                     ;Switch back to text mode
  ret                                         ;done
ENDP

RendPix MACRO
  LOCAL SkipPix,ForcePix
  cmp [vForcePix],0
  jne SHORT ForcePix
  or cl,[vColorOr]
  test cl,1111b
  jz SHORT SkipPix
  ForcePix:
  mov [ebp],cl  ;output pixel
  SkipPix:
ENDM

;Expects cl=plane1 ch=plane2 dl=plane3 dh=plane4 ah=palette mask
;al=08h bh=04h bl=02h
;Cycles on 486DX: 23/31    (best/worst)
PixPut MACRO       ;new macro to render a row of a tile
  LOCAL vPSA,vPSB,vPSC,vPSD
  and ah,070h         ;mask out non-palette bits      =1
  shr cl,1            ;test bit from tile             =3
  jnc vPSA            ;if not set, skip               =3/1
  inc ah                ;set output bit               =1
  vPSA:
  shr ch,1            ;test bit from tile             =3
  jnc vPSB            ;if not set, skip               =3/1
  or ah,bl              ;set output bit               =1
  vPSB:
  shr dl,1            ;test bit from tile             =3
  jnc vPSC            ;if not set, skip               =3/1
  or ah,bh              ;set output bit               =1
  vPSC:
  shr dh,1            ;test bit from tile             =3
  jnc vPSD            ;if not set, skip               =3/1
  or ah,al              ;set output bit               =1
  vPSD:
  mov [ebp],ah        ;store pixel to buffer in XMS   =1
  inc ebp             ;increment pixel pointer        =1
ENDM


;Render BG1 (8x8 tiles, 4-bit color)
vRBGC PROC NEAR
  mov ebx,[vBGC]        ;get pointer to BG1 SC
  mov edx,[vTILEC]      ;get pointer to BG1 tiles
  mov bp,[vBGCVOff]     ;set screen output pointer (centered)
  add bp,[vBGCHOff]
  movzx ebp,bp
  add ebp,[mRelativeVRAM] 
  xor esi,esi           ;clear SC pointer
  xor edi,edi           ;clear tile pointer
  mov WORD PTR [vTH],1C20h          ;tile count  (vert/horiz)
  xor eax,eax           ;clear eax high
  B1VRend:              ;Vertical tile loop
  B1HRend:              ;Horizontal tile loop
  mov ebx,[vBGC]              ;get pointer to BG1 SC
  mov ax,WORD PTR [ebx+esi]   ;get tile SC
  inc esi
  inc esi                        ;increment tile pointer
  mov cx,ax                      ;preserve tile info
  and ax,1023                    ;mask tile ID
  shl ax,5                       ;convert to tile offset
  mov edi,eax                    ;set tilepixel pointer

;worry about mirroring here

  and cx,7168            ;mask palette info
  shr cx,6               ;set palette info into color mask (CL) 
  mov [vLN],8            ;init scanline count
  RendTile:
  mov ax,[edx+edi]    ;get two planes of tile row
  mov bx,[edx+edi+16] ;get two planes of tile row
  inc edi
  inc edi
  and cl,240             ;clear color planes
  mov ch,bh              ;dup plane 3
  and ch,80h             ;mask plane 3 pixel
  shr ch,4               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,bl              ;dup plane 2
  and ch,80h             ;mask plane 2 pixel
  shr ch,5               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,ah              ;dup plane 1
  and ch,80h             ;mask plane 1 pixel
  shr ch,6               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,80h             ;mask plane 0 pixel
  shr ch,7               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel
  inc ebp                 ;set output to next pixel position
  and cl,240             ;clear color planes
  mov ch,bh              ;dup plane 3
  and ch,40h             ;mask plane 3 pixel
  shr ch,3               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,bl              ;dup plane 2
  and ch,40h             ;mask plane 2 pixel
  shr ch,4               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,ah              ;dup plane 1
  and ch,40h             ;mask plane 1 pixel
  shr ch,5               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,40h             ;mask plane 0 pixel
  shr ch,6               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel
  inc ebp                 ;set output to next pixel position
  and cl,240             ;clear color planes
  mov ch,bh              ;dup plane 3
  and ch,20h             ;mask plane 3 pixel
  shr ch,2               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,bl              ;dup plane 2
  and ch,20h             ;mask plane 2 pixel
  shr ch,3               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,ah              ;dup plane 1
  and ch,20h             ;mask plane 1 pixel
  shr ch,4               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,20h             ;mask plane 0 pixel
  shr ch,5               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel
  inc ebp                 ;set output to next pixel position
  and cl,240             ;clear color planes
  mov ch,bh              ;dup plane 3
  and ch,10h             ;mask plane 3 pixel
  shr ch,1               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,bl              ;dup plane 2
  and ch,10h             ;mask plane 2 pixel
  shr ch,2               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,ah              ;dup plane 1
  and ch,10h             ;mask plane 1 pixel
  shr ch,3               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,10h             ;mask plane 0 pixel
  shr ch,4               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel
  inc ebp                 ;set output to next pixel position
  and cl,240             ;clear color planes
  mov ch,bh              ;dup plane 3
  and ch,08h             ;mask plane 3 pixel
  or cl,ch               ;meld bit to final color
  mov ch,bl              ;dup plane 2
  and ch,08h             ;mask plane 2 pixel
  shr ch,1               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,ah              ;dup plane 1
  and ch,08h             ;mask plane 1 pixel
  shr ch,2               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,08h             ;mask plane 0 pixel
  shr ch,3               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel
  inc ebp                 ;set output to next pixel position
  and cl,240             ;clear color planes
  mov ch,bh              ;dup plane 3
  and ch,04h             ;mask plane 3 pixel
  shl ch,1               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,bl              ;dup plane 2
  and ch,04h             ;mask plane 2 pixel
  or cl,ch               ;meld bit to final color
  mov ch,ah              ;dup plane 1
  and ch,04h             ;mask plane 1 pixel
  shr ch,1               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,04h             ;mask plane 0 pixel
  shr ch,2               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel
  inc ebp                 ;set output to next pixel position
  and cl,240             ;clear color planes
  mov ch,bh              ;dup plane 3
  and ch,02h             ;mask plane 3 pixel
  shl ch,2               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,bl              ;dup plane 2
  and ch,02h             ;mask plane 2 pixel
  shl ch,1               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,ah              ;dup plane 1
  and ch,02h             ;mask plane 1 pixel
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,02h             ;mask plane 0 pixel
  shr ch,1               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel
  inc ebp                 ;set output to next pixel position
  and cl,240             ;clear color planes
  mov ch,bh              ;dup plane 3
  and ch,01h             ;mask plane 3 pixel
  shl ch,3               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,bl              ;dup plane 2
  and ch,01h             ;mask plane 2 pixel
  shl ch,2               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,ah              ;dup plane 1
  and ch,01h             ;mask plane 1 pixel
  shl ch,1               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,01h             ;mask plane 0 pixel
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel

  add ebp,249             ;next output line
  dec [vLN]              ;decrement scanline count
  jnz RendTile           ;if more scanlines, render them
  sub ebp,2040            ;backup output to next tile postion
  dec [vTH]              ;
  jnz B1HRend            ;Loop to Horizontal
  mov [vTH],20h          ;reset horizontal total
  add ebp,1792            ;go to next output row
  dec [vTV]              ;
  jnz B1VRend            ;Loop to vertical

  mov [vForcePix],0
  ret
ENDP

;Render BG1 (8x8 tiles, 2-bit color)
vRBGCm2B PROC NEAR
  mov ebx,[vBGC]        ;get pointer to BG1 SC
  mov edx,[vTILEC]      ;get pointer to BG1 tiles

  movzx ebp,WORD PTR [vBGCHOff]     ;set screen output pointer (centered)
;  add bp,[vBGCVOff]
  add ebp,[mRelativeVRAM]
  xor esi,esi           ;clear SC pointer
  xor edi,edi           ;clear tile pointer
  mov WORD PTR [vTH],1C20h          ;tile count  (vert/horiz)
  xor eax,eax           ;clear eax high
  B1m2BVRend:              ;Vertical tile loop
  B1m2BHRend:              ;Horizontal tile loop
  mov ebx,[vBGC]              ;get pointer to BG1 SC
  mov ax,WORD PTR [ebx+esi]   ;get tile SC
  inc esi
  inc esi                        ;increment tile pointer
  mov cx,ax                      ;preserve tile info
  and ax,1023                    ;mask tile ID
  shl ax,4                       ;convert to tile offset
  mov edi,eax                    ;set tilepixel pointer

;worry about mirroring here

  and cx,7168            ;mask palette info
  shr cx,5               ;set palette info into color mask (CL) 
  mov [vLN],8            ;init scanline count
  RendTilem2B:
  mov ax,[edx+edi]    ;get two planes of tile row
  inc edi
  inc edi
  and cl,224             ;clear color planes
  mov ch,ah              ;dup plane 1
  and ch,80h             ;mask plane 1 pixel
  shr ch,6               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,80h             ;mask plane 0 pixel
  shr ch,7               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel
  inc ebp                 ;set output to next pixel position
  and cl,224             ;clear color planes
  mov ch,ah              ;dup plane 1
  and ch,40h             ;mask plane 1 pixel
  shr ch,5               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,40h             ;mask plane 0 pixel
  shr ch,6               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel
  inc ebp                 ;set output to next pixel position
  and cl,224             ;clear color planes
  mov ch,ah              ;dup plane 1
  and ch,20h             ;mask plane 1 pixel
  shr ch,4               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,20h             ;mask plane 0 pixel
  shr ch,5               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel
  inc ebp                 ;set output to next pixel position
  and cl,224             ;clear color planes
  mov ch,ah              ;dup plane 1
  and ch,10h             ;mask plane 1 pixel
  shr ch,3               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,10h             ;mask plane 0 pixel
  shr ch,4               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel
  inc ebp                 ;set output to next pixel position
  and cl,224             ;clear color planes
  mov ch,ah              ;dup plane 1
  and ch,08h             ;mask plane 1 pixel
  shr ch,2               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,08h             ;mask plane 0 pixel
  shr ch,3               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel
  inc ebp                 ;set output to next pixel position
  and cl,224             ;clear color planes
  mov ch,ah              ;dup plane 1
  and ch,04h             ;mask plane 1 pixel
  shr ch,1               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,04h             ;mask plane 0 pixel
  shr ch,2               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel
  inc ebp                 ;set output to next pixel position
  and cl,224             ;clear color planes
  mov ch,ah              ;dup plane 1
  and ch,02h             ;mask plane 1 pixel
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,02h             ;mask plane 0 pixel
  shr ch,1               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel
  inc ebp                 ;set output to next pixel position
  and cl,224             ;clear color planes
  mov ch,ah              ;dup plane 1
  and ch,01h             ;mask plane 1 pixel
  shl ch,1               ;move bit to proper color bit
  or cl,ch               ;meld bit to final color
  mov ch,al              ;dup plane 0
  and ch,01h             ;mask plane 0 pixel
  or cl,ch               ;meld bit to final color
  RendPix         ;output pixel

  add ebp,249             ;next output line
  dec [vLN]              ;decrement scanline count
  jnz RendTilem2B        ;if more scanlines, render them
  sub ebp,2040            ;backup output to next tile postion
  dec [vTH]              ;
  jnz B1m2BHRend            ;Loop to Horizontal
  mov [vTH],20h          ;reset horizontal total
  add ebp,1792            ;go to next output row
  dec [vTV]              ;
  jnz B1m2BVRend            ;Loop to vertical

  mov [vForcePix],0
  ret
ENDP


;Render a screen, assuming 32x32 for now
vModeX PROC NEAR
  push ebp
  mov [vForcePix],1
  cmp [vMODE],0
  jne vNotMode0
    test [r212C],1h
    jz SHORT vM0B2
      mov [vColorOr],0h
      mov eax,[vBG1]
      mov [vBGC],eax
      mov eax,[vTILE1]
      mov [vTILEC],eax
      mov ax,[vBG1HOff]
      mov [vBGCHOff],ax
      mov ax,[vBG1VOff]
      mov [vBGCVOff],ax
      call vRBGCm2B
    vM0B2:
    test [r212C],2h
    jz SHORT vM0B3
      mov [vColorOr],20h
      mov eax,[vBG2]
      mov [vBGC],eax
      mov eax,[vTILE2]
      mov [vTILEC],eax
      mov ax,[vBG2HOff]
      mov [vBGCHOff],ax
      mov ax,[vBG2VOff]
      mov [vBGCVOff],ax
      call vRBGCm2B
    vM0B3:
    test [r212C],4h
    jz SHORT vM0B4
      mov [vColorOr],40h
      mov eax,[vBG3]
      mov [vBGC],eax
      mov eax,[vTILE3]
      mov [vTILEC],eax
      mov ax,[vBG3HOff]
      mov [vBGCHOff],ax
      mov ax,[vBG3VOff]
      mov [vBGCVOff],ax
      call vRBGCm2B
    vM0B4:
    test [r212C],8h
    jz SHORT vM0BD
      mov [vColorOr],60h
      mov eax,[vBG4]
      mov [vBGC],eax
      mov eax,[vTILE4]
      mov [vTILEC],eax
      mov ax,[vBG4HOff]
      mov [vBGCHOff],ax
      mov ax,[vBG4VOff]
      mov [vBGCVOff],ax
      call vRBGCm2B
    vM0BD:
  vNotMode0:
  cmp [vMODE],1
  jne vNotMode1
    mov [vColorOr],0
    test [r212C],1h
    jz SHORT vM1B2
      mov eax,[vBG1]
      mov [vBGC],eax
      mov eax,[vTILE1]
      mov [vTILEC],eax
      mov ax,[vBG1HOff]
      mov [vBGCHOff],ax
      mov ax,[vBG1VOff]
      mov [vBGCVOff],ax
      call vRBGC
    vM1B2:
    test [r212C],2h
    jz SHORT vM1B3
      mov eax,[vBG2]
      mov [vBGC],eax
      mov eax,[vTILE2]
      mov [vTILEC],eax
      mov ax,[vBG2HOff]
      mov [vBGCHOff],ax
      mov ax,[vBG2VOff]
      mov [vBGCVOff],ax
      call vRBGC
    vM1B3:
    test [r212C],4h
    jz SHORT vM1B4
      mov eax,[vBG3]
      mov [vBGC],eax
      mov eax,[vTILE3]
      mov [vTILEC],eax
      mov ax,[vBG3HOff]
      mov [vBGCHOff],ax
      mov ax,[vBG3VOff]
      mov [vBGCVOff],ax
      call vRBGCm2B
    vM1B4:
    test [r212C],10h
    jz SHORT vM1B5
;      call vSPRend
    vM1B5:
  vNotMode1:
  pop ebp
  ret
ENDP

INCLUDE TWEAK.ASM
