; May 22, 1997
; Today is an exciting day! Today I finally really got working on the
; assembly version of the 65c816 emulator.  I learned even more about
; optimizing assembler (I thought I already knew it all ;-)).  I feel
; that FauxSNES will be developed on schedule!

; May 23, 1997
; I have set a goal for myself to get at least 25 opcodes done a
; day. If I follow this schedule then I should finish this annoying
; chore by April 3, 1997 at the latest. After that I will start
; writing sound opcodes immediatly in assembly (no need to waste
; time by doing them in C first like I did here). I have seen the
; newest version of Snes96 (v0.7) and it's speed raises my hopes
; of making this thing real time.
; I also discovered that I was stupid enough to leave out the Pm
; and Px tests!

; May 24, 1997
; I think I'm going insane.

; May 27, 1997
; I haven't worked on this for 2 days... better get started if I want
; to catch up...

; May 28, 1997
; I got 67 done yesterday, I hope to get quit a few done today too.
; Finishing ahead of schedule is always nice.

; June 10, 1997
; I've been looking for a good text editor to help me with optimizations
; and bug fixing for the last while and have found nothing... so I'm gonna
; start to work hoping to get this done soon...

BITS 32

EXTERN _CartRom      ; Pointer to the SNES's ROM 00-3f:8000-ffff, 40-7d:0000-ffff
EXTERN _SnesRam      ; Pointer to the SNES's RAM 00-3f:0000-1fff, 7e-7f:0000-ffff
EXTERN _SnesReg      ; Pointer to the SNES's register memory 00-3f:2100-4fff
EXTERN _A            ; The A register (general purpose)
EXTERN _PC           ; Program Counter (this and PB make up the IP)
EXTERN _X            ; The X register (general purpose)
EXTERN _Y            ; The Y register (general purpose)
EXTERN _PB           ; Program bank register (this and PC make up the IP)
EXTERN _DB           ; Data bank register
EXTERN _P            ; The processor status byte (actually a word, I use smsw
                     ; and lmsw so I don't have to manualy keep track of the
                     ; math status bits)
EXTERN _PE           ; The emulation flag
EXTERN _D            ; Direct page register
EXTERN _PI           ; The interrupt flag
EXTERN _S            ; The stack pointer (bank is always 0)
EXTERN _Pm           ; Used to determine the size of A
EXTERN _Px           ; Used to determine the size of X,Y

GLOBAL __adc_i;
GLOBAL __adc_d;
GLOBAL __adc_dx;
GLOBAL __adc_pd;
GLOBAL __adc_pdx;
GLOBAL __adc_pd_y;
GLOBAL __adc_bd;
GLOBAL __adc_a;
GLOBAL __adc_ax;
GLOBAL __adc_ay;
GLOBAL __adc_al;
GLOBAL __adc_alx;
GLOBAL __adc_ds;
GLOBAL __adc_pds_y;
GLOBAL __and_i;
GLOBAL __and_d;
GLOBAL __and_dx;
GLOBAL __and_pd;
GLOBAL __and_pdx;
GLOBAL __and_pd_y;
GLOBAL __and_bd;
GLOBAL __and_a;
GLOBAL __and_ax;
GLOBAL __and_ay;
GLOBAL __and_al;
GLOBAL __and_alx;
GLOBAL __and_ds;
GLOBAL __and_pds_y;
GLOBAL __asl_A;
GLOBAL __asl_d;
GLOBAL __asl_dx;
GLOBAL __asl_a;
GLOBAL __asl_ax;
GLOBAL __bit_i;
GLOBAL __bit_d;
GLOBAL __bit_dx;
GLOBAL __bit_a;
GLOBAL __bit_ax;
GLOBAL __cmp_i;
GLOBAL __cmp_d;
GLOBAL __cmp_dx;
GLOBAL __cmp_pd;
GLOBAL __cmp_pdx;
GLOBAL __cmp_pd_y;
GLOBAL __cmp_bd;
GLOBAL __cmp_a;
GLOBAL __cmp_ax;
GLOBAL __cmp_ay;
GLOBAL __cmp_al;
GLOBAL __cmp_alx;
GLOBAL __cmp_ds;
GLOBAL __cmp_pds_y;
GLOBAL __cpx_i;
GLOBAL __cpx_d;
GLOBAL __cpx_a;
GLOBAL __cpy_i;
GLOBAL __cpy_d;
GLOBAL __cpy_a;
GLOBAL __dec_A;
GLOBAL __dec_d;
GLOBAL __dec_dx;
GLOBAL __dec_a;
GLOBAL __dec_ax;
GLOBAL __eor_i;
GLOBAL __eor_d;
GLOBAL __eor_dx;
GLOBAL __eor_pd;
GLOBAL __eor_pdx;
GLOBAL __eor_pd_y;
GLOBAL __eor_bd;
GLOBAL __eor_a;
GLOBAL __eor_ax;
GLOBAL __eor_ay;
GLOBAL __eor_al;
GLOBAL __eor_alx;
GLOBAL __eor_ds;
GLOBAL __eor_pds_y;
GLOBAL __inc_A;
GLOBAL __inc_d;
GLOBAL __inc_dx;
GLOBAL __inc_a;
GLOBAL __inc_ax;
GLOBAL __lda_i;
GLOBAL __lda_d;
GLOBAL __lda_dx;
GLOBAL __lda_pd;
GLOBAL __lda_pdx;
GLOBAL __lda_pd_y;
GLOBAL __lda_bd;
GLOBAL __lda_a;
GLOBAL __lda_ax;
GLOBAL __lda_ay;
GLOBAL __lda_al;
GLOBAL __lda_alx;
GLOBAL __lda_ds;
GLOBAL __lda_pds_y;
GLOBAL __ldx_i;
GLOBAL __ldx_d;
GLOBAL __ldx_dy;
GLOBAL __ldx_a;
GLOBAL __ldx_ay;
GLOBAL __ldy_i;
GLOBAL __ldy_d;
GLOBAL __ldy_dx;
GLOBAL __ldy_a;
GLOBAL __ldy_ax;
GLOBAL __lsr_A;
GLOBAL __lsr_d;
GLOBAL __lsr_dx;
GLOBAL __lsr_a;
GLOBAL __lsr_ax;
GLOBAL __ora_i;
GLOBAL __ora_d;
GLOBAL __ora_dx;
GLOBAL __ora_pd;
GLOBAL __ora_pdx;
GLOBAL __ora_pd_y;
GLOBAL __ora_bd;
GLOBAL __ora_a;
GLOBAL __ora_ax;
GLOBAL __ora_ay;
GLOBAL __ora_al;
GLOBAL __ora_alx;
GLOBAL __ora_ds;
GLOBAL __ora_pds_y;
GLOBAL __rol_A;
GLOBAL __rol_d;
GLOBAL __rol_dx;
GLOBAL __rol_a;
GLOBAL __rol_ax;
GLOBAL __ror_A;
GLOBAL __ror_d;
GLOBAL __ror_dx;
GLOBAL __ror_a;
GLOBAL __ror_ax;
GLOBAL __sbc_i;
GLOBAL __sbc_d;
GLOBAL __sbc_dx;
GLOBAL __sbc_pd;
GLOBAL __sbc_pdx;
GLOBAL __sbc_pd_y;
GLOBAL __sbc_bd;
GLOBAL __sbc_a;
GLOBAL __sbc_ax;
GLOBAL __sbc_ay;
GLOBAL __sbc_al;
GLOBAL __sbc_alx;
GLOBAL __sbc_ds;
GLOBAL __sbc_pds_y;
GLOBAL __sta_d;
GLOBAL __sta_dx;
GLOBAL __sta_pd;
GLOBAL __sta_pdx;
GLOBAL __sta_pd_y;
GLOBAL __sta_bd;
GLOBAL __sta_a;
GLOBAL __sta_ax;
GLOBAL __sta_ay;
GLOBAL __sta_al;
GLOBAL __sta_alx;
GLOBAL __sta_ds;
GLOBAL __sta_pds_y;
GLOBAL __stx_d;
GLOBAL __stx_dy;
GLOBAL __stx_a;
GLOBAL __sty_d;
GLOBAL __sty_dx;
GLOBAL __sty_a;
GLOBAL __stz_d;
GLOBAL __stz_dx;
GLOBAL __stz_a;
GLOBAL __stz_ax;
GLOBAL __trb_d;
GLOBAL __trb_a;
GLOBAL __tsb_d;
GLOBAL __tsb_a;
GLOBAL __bcc;
GLOBAL __bcs;
GLOBAL __beq;
GLOBAL __bmi;
GLOBAL __bne;
GLOBAL __bpl;
GLOBAL __bra;
GLOBAL __bvc;
GLOBAL __bvs;
GLOBAL __clc;
GLOBAL __cld;
GLOBAL __cli;
GLOBAL __clv;
GLOBAL __dex;
GLOBAL __dey;
GLOBAL __inx;
GLOBAL __iny;
GLOBAL __nop;
GLOBAL __pea;
GLOBAL __pei; 
GLOBAL __per;
GLOBAL __pha;
GLOBAL __phb;
GLOBAL __phd;
GLOBAL __phk;
GLOBAL __php;
GLOBAL __phx;
GLOBAL __phy;
GLOBAL __pla;
GLOBAL __plb;
GLOBAL __pld;
GLOBAL __plp;
GLOBAL __plx;
GLOBAL __ply;
GLOBAL __sec;
GLOBAL __sed;
GLOBAL __sei;
GLOBAL __tax;
GLOBAL __tay;
GLOBAL __tcd;
GLOBAL __tcs;
GLOBAL __tdc;
GLOBAL __tsc;
GLOBAL __tsx;
GLOBAL __txa;
GLOBAL __txs;
GLOBAL __txy;
GLOBAL __tya;
GLOBAL __tyx;
GLOBAL __xce;
GLOBAL __sep;
GLOBAL __brl;
GLOBAL __jmp_al;
GLOBAL __rep;
GLOBAL __xba;
GLOBAL __jsr_a;
GLOBAL __rts;

GLOBAL _SNESgetbyte;
GLOBAL _SNESgetword;
GLOBAL _SNESsetbyte;
GLOBAL _SNESsetword;

SECTION .text

%macro GetFlags 0
  pushf
  pop ax
  mov [_P], ax
%endmacro

%macro SetFlags 0
  mov bx, [_P]
  push bx
  popf
%endmacro

; April 25, 1997

; prototype: extern unsigned char SNESgetbyte(unsigned long seg, unsigned short offs);
_SNESgetbyte:
		push ebp
		mov ebp, esp
		mov esi, DWORD [ebp+8]
		cmp esi, 03f0000h
		jge .highbank
    mov si, WORD [ebp+12]
		cmp si, 08000h
		jge .rom
    and esi, 0000ffffh
		cmp si, 01fffh
		jg  .reg
    mov edi, [_SnesRam]
		add di, si
    xor ax, ax
		mov al, BYTE [edi]
    jmp .gotit
.reg
		xor ax, ax
		mov edi, [_SnesReg]
		sub si, 02100h
		add di, si
		mov al, BYTE [edi]
		jmp .gotit
.rom
		mov di, si
		xor ax, ax
		and esi, 0FF0000h
		and di, 07FFFh
		shr esi, 1
		or si, di
		mov edi, [_CartRom]
		add edi, esi
		mov al, BYTE [edi]
		jmp .gotit
.highbank
		xor ax, ax
		cmp esi, 07E0000h
		jl  .gotit
		and esi, 0010000h
		mov si, WORD [ebp+12]
		mov edi, [_SnesRam]
		add edi, esi
		mov al, BYTE [edi]
.gotit
		pop ebp
		ret

; prototype: extern void SNESsetbyte(unsigned long seg, unsigned short offs, unsigned char val);
_SNESsetbyte:
		push ebp
		mov ebp, esp
		mov esi, DWORD [ebp+8]
		cmp esi, 03f0000h
    jge .highbank
    mov si, WORD [ebp+12]
    mov al, BYTE [ebp+13]
    cmp si, 08000h
		jge .rom
    and esi, 0000ffffh
    cmp si, 01fffh
    jg  .reg
    mov edi, [_SnesRam]
    add di, si
    mov BYTE [edi], al
    jmp .gotit
.reg
    mov edi, [_SnesReg]
    sub si, 02100h
    add di, si
    mov BYTE [edi], al
    jmp .gotit
.rom
    jmp .gotit
.highbank
    cmp esi, 07E0000h
    jl  .gotit
    and esi, 0010000h
		mov si, WORD [ebp+12]
    mov edi, [_SnesRam]
    add edi, esi
    mov BYTE [edi], al
.gotit
    pop ebp
    ret

; prototype: extern void SNESsetword(unsigned long seg, unsigned short offs, unsigned short val);
_SNESsetword:
    push ebp
    mov ebp, esp
    mov esi, DWORD [ebp+8]
    cmp esi, 03f0000h
    jge .highbank
    mov si, WORD [ebp+12]
    mov ax, WORD [ebp+13]
    cmp si, 08000h
    jge .rom
    and esi, 0000ffffh
		cmp si, 01fffh
    jg  .reg
    mov edi, [_SnesRam]
    add di, si
    mov BYTE [edi], al
    inc edi
    mov BYTE [edi], ah
    jmp .gotit
.reg
    mov edi, [_SnesReg]
    sub si, 02100h
    add di, si
    mov BYTE [edi], al
    inc edi
    mov BYTE [edi], ah
    jmp .gotit
.rom
    jmp .gotit
.highbank
    cmp esi, 07E0000h
		jl  .gotit
    and esi, 0010000h
    mov si, WORD [ebp+12]
    mov edi, [_SnesRam]
    add edi, esi
    mov BYTE [edi], al
    inc edi
    mov BYTE [edi], ah
.gotit
    pop ebp
    ret

; prototype: extern unsigned short SNESgetword(unsigned long seg, unsigned short offs);
_SNESgetword:
    push ebp
    mov ebp, esp
    mov esi, DWORD [ebp+8]
    cmp esi, 03f0000h
    jge .highbank
    mov si, WORD [ebp+12]
		cmp si, 08000h
    jge .rom
    and esi, 0000ffffh
    cmp si, 01fffh
    jg  .reg
    mov edi, [_SnesRam]
    add di, si
    xor ax, ax
    mov al, BYTE [edi]
    inc edi
    mov ah, BYTE [edi]
    jmp .gotit
.reg
    xor ax, ax
    mov edi, [_SnesReg]
    sub si, 02100h
    add di, si
    mov al, BYTE [edi]
    inc edi
    mov ah, BYTE [edi]
		jmp .gotit
.rom
    mov di, si
    xor ax, ax
    and esi, 0FF0000h
    and di, 07FFFh
    shr esi, 1
    or si, di
    mov edi, [_CartRom]
    add edi, esi
    mov al, BYTE [edi]
    inc edi
    mov ah, BYTE [edi]
    jmp .gotit
.highbank
    xor ax, ax
    cmp esi, 07E0000h
    jl  .gotit
    and esi, 0010000h
    mov si, WORD [ebp+12]
		mov edi, [_SnesRam]
    add edi, esi
    mov al, BYTE [edi]
    inc edi
    mov ah, BYTE [edi]
.gotit
    pop ebp
    ret

; May 22, 1997

; This won't function properly in C, so don't call it
_SNESget24bit:
    push ebp
    mov ebp, esp
    mov esi, DWORD [ebp+8]
		cmp esi, 03f0000h
    jge .highbank
    mov si, WORD [ebp+12]
    cmp si, 08000h
		jge .rom
    and esi, 0000ffffh
    cmp si, 01fffh
    jg  .reg
    mov edi, [_SnesRam]
    add di, si
    xor cx, cx
    mov al, BYTE [edi]
    inc edi
    mov ah, BYTE [edi]
    inc edi
    mov cl, BYTE [edi]
    jmp .gotit
.reg
    xor cx, cx
    mov edi, [_SnesReg]
		sub si, 02100h
    add di, si
    mov al, BYTE [edi]
    inc edi
		mov ah, BYTE [edi]
    inc edi
    mov cl, BYTE [edi]
    jmp .gotit
.rom
    mov di, si
    xor cx, cx
    and esi, 0FF0000h
    and di, 07FFFh
    shr esi, 1
    or si, di
    mov edi, [_CartRom]
    add edi, esi
    mov al, BYTE [edi]
    inc edi
    mov ah, BYTE [edi]
		inc edi
    mov cl, BYTE [edi]
    jmp .gotit
.highbank
		xor cx, cx
    cmp esi, 07E0000h
    jl  .gotit
    and esi, 0010000h
    mov si, WORD [ebp+12]
    mov edi, [_SnesRam]
    add edi, esi
    mov al, BYTE [edi]
    inc edi
    mov ah, BYTE [edi]
    inc edi
		mov cl, BYTE [edi]
.gotit
		pop ebp
		ret

; This won't function properly in C either
_SNESgetptr:
		push ebp
		mov ebp, esp
		mov esi, DWORD [ebp+8]
		cmp esi, 03f0000h
		jge .highbank
		mov si, WORD [ebp+12]
		cmp si, 08000h
		jge .rom
		and esi, 0000ffffh
		cmp si, 01fffh
		jg  .reg
		mov edi, [_SnesRam]
		add di, si
		jmp .gotit
.reg
		mov edi, [_SnesReg]
		sub si, 02100h
		add di, si
		jmp .gotit
.rom
		mov di, si
		and esi, 0FF0000h
		and di, 07FFFh
		shr esi, 1
		or si, di
		mov edi, [_CartRom]
		add edi, esi
		jmp .gotit
.highbank
		cmp esi, 07E0000h
		jl  .gotit
		and esi, 0010000h
		mov si, WORD [ebp+12]
		mov edi, [_SnesRam]
		add edi, esi
.gotit
		pop ebp
		ret


; What follows will soon be 256 different functions for the SNES's opcodes
; this is gonna be a pain in the ass

; adc: immediate addressing mode
__adc_i:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
    adc WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
		add WORD[_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
    adc BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; adc: direct addressing mode
__adc_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
		cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
    adc WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
    adc BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; adc: direct indexed with X addressing mode
__adc_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
		push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
    adc WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
		push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
    adc BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; adc: direct indirect addressing mode
__adc_pd:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
		push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
    adc WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
		push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
    adc BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; adc: direct indexed indirect,X addressing mode
__adc_pdx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
		push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
    adc WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
		push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
    adc BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; adc: direct indexed indirect,Y addressing mode
__adc_pd_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
    add ax, WORD [_Y]
    adc ecx, 0
    shl ecx, 16
		push ax
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
    adc WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
		add ax, WORD [_Y]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
    adc BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; adc: direct indirect long addressing mode
__adc_bd:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
		cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
    adc WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
    adc BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; adc: absolute addressing mode
__adc_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
		add esp, 6
    SetFlags
    adc WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
		adc BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; adc: absolute,X addressing mode
__adc_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
		add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
    adc WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
		add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
    adc BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; adc: absolute,Y addressing mode
__adc_ay:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
		je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
    adc WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
		add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
    adc BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; adc: absolute long addressing mode
__adc_al:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetword
		add esp, 6
    SetFlags
    adc WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
    adc BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; adc: absolute long,X addressing mode
__adc_alx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
		xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
    adc cx, 0
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
    adc WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
		push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
    adc cx, 0
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
    adc BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; adc: stack relative addressing mode
__adc_ds:
		mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
		adc WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
    adc BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; adc: stack relative indirect indexed addressing mode
__adc_pds_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
    adc WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
		push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
    adc BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; FINALLY!!!! The end of the adc's! Now it's just copy 'n past
; 'n some editing!!

; May 23, 1997

; and: immediate addressing mode
__and_i:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
		and WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD[_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; and: direct addressing mode
__and_d:
		mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; and: direct indexed with X addressing mode
__and_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; and: direct indexed indirect,X addressing mode
__and_pdx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; and: direct indexed indirect,Y addressing mode
__and_pd_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
    add ax, WORD [_Y]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetword
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
    add ax, WORD [_Y]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetbyte
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; and: direct indirect long addressing mode
__and_bd:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; and: absolute addressing mode
__and_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; and: absolute,X addressing mode
__and_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; and: absolute,Y addressing mode
__and_ay:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; and: absolute long addressing mode
__and_al:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetword
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetbyte
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; and: absolute long,X addressing mode
__and_alx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
    adc cx, 0
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetword
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
    adc cx, 0
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetbyte
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; and: stack relative addressing mode
__and_ds:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; and: stack relative indirect indexed addressing mode
__and_pds_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetword
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetbyte
    add esp, 6
    and WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; asl: Accumulator addressing mode
__asl_A:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    shl WORD [_A], 1
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    shl BYTE [_A+1], 1
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; asl: direct addressing mode
__asl_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    shl ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    ; push ax
    ; push bx
    ; push ecx
    ; call _SNESsetword
    ; add esp, 8
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    shl al, 1
    GetFlags
    mov [edi], al
    ; push ax
    ; push bx
    ; push ecx
    ; call _SNESsetbyte
    ; add esp, 8
    add WORD [_PC], 1
.emuskip
    ret

; asl: direct indexed with X addressing mode
__asl_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    shl ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    shl al, 1
    GetFlags
    mov [edi], al
    add WORD [_PC], 1
.emuskip
    ret

; asl: absolute addressing mode
__asl_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    shl ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    shl al, 1
    GetFlags
    mov [edi], al
    add WORD [_PC], 2
.emuskip
    ret

; asl: absolute,X addressing mode
__asl_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    shl ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    shl al, 1
    GetFlags
    mov [edi], al
    add WORD [_PC], 2
.emuskip
    ret

; bit: immediate addressing mode
__bit_i:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, WORD [_A]
    and bx, ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD[_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov bx, WORD [_A]
    and bx, ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; bit: direct addressing mode
__bit_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, WORD [_A]
    and bx, ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov bx, WORD [_A]
    and bx, ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; bit: direct indexed with X addressing mode
__bit_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, WORD [_A]
    and bx, ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov bx, WORD [_A]
    and bx, ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; bit: absolute addressing mode
__bit_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, WORD [_A]
    and bx, ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov bx, WORD [_A]
    and bx, ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; bit: absolute,X addressing mode
__bit_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, WORD [_A]
    and bx, ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov bx, WORD [_A]
    and bx, ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; May 24, 1997

; cmp: immediate addressing mode
__cmp_i:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_A]
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD[_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_A+1]
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; cmp: direct addressing mode
__cmp_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_A]
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_A+1]
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; cmp: direct indexed with X addressing mode
__cmp_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_A]
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_A+1]
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; cmp: direct indexed indirect,X addressing mode
__cmp_pdx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_A]
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_A+1]
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; cmp: direct indexed indirect,Y addressing mode
__cmp_pd_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
    add ax, WORD [_Y]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_A]
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
    add ax, WORD [_Y]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_A+1]
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; cmp: direct indirect long addressing mode
__cmp_bd:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_A]
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_A+1]
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; cmp: absolute addressing mode
__cmp_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_A]
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_A+1]
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; cmp: absolute,X addressing mode
__cmp_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_A]
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_A+1]
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; cmp: absolute,Y addressing mode
__cmp_ay:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_A]
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_A+1]
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; cmp: absolute long addressing mode
__cmp_al:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_A]
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_A+1]
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; cmp: absolute long,X addressing mode
__cmp_alx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
    adc cx, 0
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_A]
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
    adc cx, 0
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_A+1]
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; cmp: stack relative addressing mode
__cmp_ds:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_A]
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_A+1]
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; cmp: stack relative indirect indexed addressing mode
__cmp_pds_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_A]
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_A+1]
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; cpx: immediate addressing mode
__cpx_i:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Px]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_X]
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD[_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_X+1]
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; cpx: direct addressing mode
__cpx_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Px]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_X]
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_X+1]
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; cpx: absolute addressing mode
__cpx_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Px]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_X]
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_X+1]
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; cpy: immediate addressing mode
__cpy_i:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Px]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_Y]
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD[_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_Y+1]
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; cpy: direct addressing mode
__cpy_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Px]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_Y]
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_Y+1]
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; cpy: absolute addressing mode
__cpy_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Px]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    cmp ax, WORD [_Y]
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    cmp al, BYTE [_Y+1]
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; dec: Accumulator addressing mode
__dec_A:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    dec WORD [_A]
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    dec BYTE [_A+1], 
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; dec: direct addressing mode
__dec_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    dec ax
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    dec al
    GetFlags
    mov [edi], al
    add WORD [_PC], 1
.emuskip
    ret

; dec: direct indexed with X addressing mode
__dec_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    dec ax
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    dec al
    GetFlags
    mov [edi], al
    add WORD [_PC], 1
.emuskip
    ret

; dec: absolute addressing mode
__dec_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    dec ax
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    dec al
    GetFlags
    mov [edi], al
    add WORD [_PC], 2
.emuskip
    ret

; dec: absolute,X addressing mode
__dec_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    dec ax
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    dec al
    GetFlags
    mov [edi], al
    add WORD [_PC], 2
.emuskip
    ret

; May 27, 1997

; eor: immediate addressing mode
__eor_i:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD[_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; eor: direct addressing mode
__eor_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; eor: direct indexed with X addressing mode
__eor_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; eor: direct indexed indirect,X addressing mode
__eor_pdx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; eor: direct indexed indirect,Y addressing mode
__eor_pd_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
    add ax, WORD [_Y]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetword
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
    add ax, WORD [_Y]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetbyte
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; eor: direct indirect long addressing mode
__eor_bd:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; eor: absolute addressing mode
__eor_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; eor: absolute,X addressing mode
__eor_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; eor: absolute,Y addressing mode
__eor_ay:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; eor: absolute long addressing mode
__eor_al:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetword
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetbyte
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; eor: absolute long,X addressing mode
__eor_alx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
    adc cx, 0
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetword
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
    adc cx, 0
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetbyte
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; eor: stack relative addressing mode
__eor_ds:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; eor: stack relative indirect indexed addressing mode
__eor_pds_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetword
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetbyte
    add esp, 6
    xor WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; inc: Accumulator addressing mode
__inc_A:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    inc WORD [_A]
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    inc BYTE [_A+1], 
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; inc: direct addressing mode
__inc_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    inc ax
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    inc al
    GetFlags
    mov [edi], al
    add WORD [_PC], 1
.emuskip
    ret

; inc: direct indexed with X addressing mode
__inc_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    inc ax
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    inc al
    GetFlags
    mov [edi], al
    add WORD [_PC], 1
.emuskip
    ret

; inc: absolute addressing mode
__inc_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    inc ax
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    inc al
    GetFlags
    mov [edi], al
    add WORD [_PC], 2
.emuskip
    ret

; inc: absolute,X addressing mode
__inc_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    inc ax
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    inc al
    GetFlags
    mov [edi], al
    add WORD [_PC], 2
.emuskip
    ret

; lda: immediate addressing mode
__lda_i:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD[_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; lda: direct addressing mode
__lda_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
		add esp, 6
    add ax, WORD [_D]
    push ax
		xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
		xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; lda: direct indexed with X addressing mode
__lda_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; lda: direct indexed indirect,X addressing mode
__lda_pdx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; lda: direct indexed indirect,Y addressing mode
__lda_pd_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
    add ax, WORD [_Y]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetword
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
    add ax, WORD [_Y]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetbyte
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; lda: direct indirect long addressing mode
__lda_bd:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; lda: absolute addressing mode
__lda_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; lda: absolute,X addressing mode
__lda_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; lda: absolute,Y addressing mode
__lda_ay:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; lda: absolute long addressing mode
__lda_al:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetword
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetbyte
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; lda: absolute long,X addressing mode
__lda_alx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
    adc cx, 0
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetword
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
    adc cx, 0
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetbyte
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; lda: stack relative addressing mode
__lda_ds:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; lda: stack relative indirect indexed addressing mode
__lda_pds_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetword
    add esp, 6
		mov WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
    adc ecx, 0
    shl ecx, 16
		push ax
    push ecx
		call _SNESgetbyte
		add esp, 6
		mov WORD [_A], ax
    GetFlags
		add WORD [_PC], 1
.emuskip
		ret

; ldx: immediate addressing mode
__ldx_i:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6

		mov WORD [_X], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD[_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6

		mov WORD [_X], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; ldx: direct addressing mode
__ldx_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6

		mov WORD [_X], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
		push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6

		mov WORD [_X], ax
    GetFlags
		add WORD [_PC], 1
.emuskip
		ret

; ldx: direct indexed with Y addressing mode
__ldx_dy:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
		add WORD [_PC], 1
		mov cx, WORD [_PC]
		push cx
		mov ecx, DWORD [_PB]
		push ecx
		call _SNESgetbyte
		add esp, 6
		add ax, WORD [_D]
		add ax, WORD [_Y]
		push ax
		xor ecx, ecx
		push ecx
		call _SNESgetword
		add esp, 6

		mov WORD [_X], ax
    GetFlags
		add WORD [_PC], 1
		jmp .emuskip
.emu
		add WORD [_PC], 1
		mov cx, WORD [_PC]
		push cx
		mov ecx, DWORD [_PB]
		push ecx
		call _SNESgetbyte
		add esp, 6
		add ax, WORD [_D]
		add ax, WORD [_Y]
		push ax
		xor ecx, ecx
		push ecx
		call _SNESgetbyte
		add esp, 6

		mov WORD [_X], ax
    GetFlags
		add WORD [_PC], 1
.emuskip
		ret

; ldx: absolute addressing mode
__ldx_a:
		mov cx, WORD [_PE]
		cmp cx, 1
		je  .emu
		mov cx, WORD [_Pm]
		cmp cx, 1
		je  .emu
		add WORD [_PC], 1
		mov cx, WORD [_PC]
		push cx
		mov ecx, DWORD [_PB]
		push ecx
		call _SNESgetword
		add esp, 6
		push ax
		mov ecx, DWORD [_DB]
		push ecx
		call _SNESgetword
		add esp, 6

		mov WORD [_X], ax
    GetFlags
		add WORD [_PC], 2
		jmp .emuskip
.emu
		add WORD [_PC], 1
		mov cx, WORD [_PC]
		push cx
		mov ecx, DWORD [_PB]
		push ecx
		call _SNESgetword
		add esp, 6
		push ax
		mov ecx, DWORD [_DB]
		push ecx
		call _SNESgetbyte
		add esp, 6

		mov WORD [_X], ax
    GetFlags
		add WORD [_PC], 2
.emuskip
		ret

; ldx: absolute,Y addressing mode
__ldx_ay:
		mov cx, WORD [_PE]
		cmp cx, 1
		je  .emu
		mov cx, WORD [_Pm]
		cmp cx, 1
		je  .emu
		add WORD [_PC], 1
		mov cx, WORD [_PC]
		push cx
		mov ecx, DWORD [_PB]
		push ecx
		call _SNESgetword
		add esp, 6
		add ax, WORD [_Y]
		push ax
		mov ecx, DWORD [_DB]
		push ecx
		call _SNESgetword
		add esp, 6

		mov WORD [_X], ax
    GetFlags
		add WORD [_PC], 2
		jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
		add ax, WORD [_Y]
		push ax
    mov ecx, DWORD [_DB]
    push ecx
		call _SNESgetbyte
		add esp, 6

		mov WORD [_X], ax
    GetFlags
		add WORD [_PC], 2
.emuskip
		ret

; ldy: immediate addressing mode
__ldy_i:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6

		mov WORD [_Y], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD[_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6

		mov WORD [_Y], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; ldy: direct addressing mode
__ldy_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6

		mov WORD [_Y], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
		push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6

		mov WORD [_Y], ax
    GetFlags
		add WORD [_PC], 1
.emuskip
		ret

; ldy: direct indexed with Y addressing mode
__ldy_dy:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
		add WORD [_PC], 1
		mov cx, WORD [_PC]
		push cx
		mov ecx, DWORD [_PB]
		push ecx
		call _SNESgetbyte
		add esp, 6
		add ax, WORD [_D]
		add ax, WORD [_X]
		push ax
		xor ecx, ecx
		push ecx
		call _SNESgetword
		add esp, 6

		mov WORD [_Y], ax
    GetFlags
		add WORD [_PC], 1
		jmp .emuskip
.emu
		add WORD [_PC], 1
		mov cx, WORD [_PC]
		push cx
		mov ecx, DWORD [_PB]
		push ecx
		call _SNESgetbyte
		add esp, 6
		add ax, WORD [_D]
		add ax, WORD [_X]
		push ax
		xor ecx, ecx
		push ecx
		call _SNESgetbyte
		add esp, 6

		mov WORD [_Y], ax
    GetFlags
		add WORD [_PC], 1
.emuskip
		ret

; ldy: absolute addressing mode
__ldy_a:
		mov cx, WORD [_PE]
		cmp cx, 1
		je  .emu
		mov cx, WORD [_Pm]
		cmp cx, 1
		je  .emu
		add WORD [_PC], 1
		mov cx, WORD [_PC]
		push cx
		mov ecx, DWORD [_PB]
		push ecx
		call _SNESgetword
		add esp, 6
		push ax
		mov ecx, DWORD [_DB]
		push ecx
		call _SNESgetword
		add esp, 6

		mov WORD [_Y], ax
    GetFlags
		add WORD [_PC], 2
		jmp .emuskip
.emu
		add WORD [_PC], 1
		mov cx, WORD [_PC]
		push cx
		mov ecx, DWORD [_PB]
		push ecx
		call _SNESgetword
		add esp, 6
		push ax
		mov ecx, DWORD [_DB]
		push ecx
		call _SNESgetbyte
		add esp, 6

		mov WORD [_Y], ax
    GetFlags
		add WORD [_PC], 2
.emuskip
		ret

; ldy: absolute,Y addressing mode
__ldy_ay:
		mov cx, WORD [_PE]
		cmp cx, 1
		je  .emu
		mov cx, WORD [_Pm]
		cmp cx, 1
		je  .emu
		add WORD [_PC], 1
		mov cx, WORD [_PC]
		push cx
		mov ecx, DWORD [_PB]
		push ecx
		call _SNESgetword
		add esp, 6
		add ax, WORD [_X]
		push ax
		mov ecx, DWORD [_DB]
		push ecx
		call _SNESgetword
		add esp, 6

		mov WORD [_Y], ax
    GetFlags
		add WORD [_PC], 2
		jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
		add ax, WORD [_X]
		push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    
		mov WORD [_Y], ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; lsr: Accumulator addressing mode
__lsr_A:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    shl WORD [_A], 1
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    shl BYTE [_A+1], 1
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; lsr: direct addressing mode
__lsr_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
		shr ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    ; push ax
    ; push bx
    ; push ecx
    ; call _SNESsetword
    ; add esp, 8
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
		shr al, 1
    GetFlags
    mov [edi], al
    ; push ax
    ; push bx
    ; push ecx
    ; call _SNESsetbyte
    ; add esp, 8
    add WORD [_PC], 1
.emuskip
    ret

; lsr: direct indexed with X addressing mode
__lsr_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
		shr ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
		shr al, 1
    GetFlags
    mov [edi], al
    add WORD [_PC], 1
.emuskip
    ret

; lsr: absolute addressing mode
__lsr_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
		shr ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		shr al, 1
    GetFlags
    mov [edi], al
    add WORD [_PC], 2
.emuskip
    ret

; lsr: absolute,X addressing mode
__lsr_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    shr ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		shr al, 1
    GetFlags
    mov [edi], al
    add WORD [_PC], 2
.emuskip
    ret

; ora: immediate addressing mode
__ora_i:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD[_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; ora: direct addressing mode
__ora_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; ora: direct indexed with X addressing mode
__ora_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; ora: direct indexed indirect,X addressing mode
__ora_pdx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; ora: direct indexed indirect,Y addressing mode
__ora_pd_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
    add ax, WORD [_Y]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetword
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
    add ax, WORD [_Y]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetbyte
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; ora: direct indirect long addressing mode
__ora_bd:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; ora: absolute addressing mode
__ora_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; ora: absolute,X addressing mode
__ora_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; ora: absolute,Y addressing mode
__ora_ay:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; ora: absolute long addressing mode
__ora_al:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetword
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetbyte
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; ora: absolute long,X addressing mode
__ora_alx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
    adc cx, 0
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetword
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
    adc cx, 0
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetbyte
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; ora: stack relative addressing mode
__ora_ds:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; ora: stack relative indirect indexed addressing mode
__ora_pds_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetword
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
    adc ecx, 0
		shl ecx, 16
    push ax
    push ecx
    call _SNESgetbyte
    add esp, 6
		or  WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
.emuskip
		ret

; rol: Accumulator addressing mode
__rol_A:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    shl WORD [_A], 1
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    shl BYTE [_A+1], 1
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; rol: direct addressing mode
__rol_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
		rol ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    ; push ax
    ; push bx
    ; push ecx
    ; call _SNESsetword
    ; add esp, 8
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
		rol al, 1
    GetFlags
    mov [edi], al
    ; push ax
    ; push bx
    ; push ecx
    ; call _SNESsetbyte
    ; add esp, 8
    add WORD [_PC], 1
.emuskip
    ret

; rol: direct indexed with X addressing mode
__rol_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
		rol ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
		rol al, 1
    GetFlags
    mov [edi], al
    add WORD [_PC], 1
.emuskip
    ret

; rol: absolute addressing mode
__rol_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
		rol ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		rol al, 1
    GetFlags
    mov [edi], al
    add WORD [_PC], 2
.emuskip
    ret

; rol: absolute,X addressing mode
__rol_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    rol ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
		push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		rol al, 1
    GetFlags
    mov [edi], al
    add WORD [_PC], 2
.emuskip
    ret

; ror: Accumulator addressing mode
__ror_A:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    shl WORD [_A], 1
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    shl BYTE [_A+1], 1
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; ror: direct addressing mode
__ror_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
		ror ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    ; push ax
    ; push bx
    ; push ecx
    ; call _SNESsetword
    ; add esp, 8
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
		ror al, 1
    GetFlags
    mov [edi], al
    ; push ax
    ; push bx
    ; push ecx
    ; call _SNESsetbyte
    ; add esp, 8
    add WORD [_PC], 1
.emuskip
    ret

; ror: direct indexed with X addressing mode
__ror_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
		ror ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    mov bx, ax
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
		ror al, 1
    GetFlags
    mov [edi], al
    add WORD [_PC], 1
.emuskip
    ret

; ror: absolute addressing mode
__ror_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
		ror ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		ror al, 1
    GetFlags
    mov [edi], al
    add WORD [_PC], 2
.emuskip
    ret

; ror: absolute,X addressing mode
__ror_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
		ror ax, 1
    GetFlags
    dec edi
    mov [edi], al
    inc edi
    mov [edi], ah
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
		push ecx
    call _SNESgetword
    add esp, 6
		add ax, WORD [_X]
    mov bx, ax
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		ror al, 1
    GetFlags
    mov [edi], al
    add WORD [_PC], 2
.emuskip
    ret

; May 28, 1997

; sbc: immediate addressing mode
__sbc_i:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
		sbb WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
		add WORD[_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
		sbb BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; sbc: direct addressing mode
__sbc_d:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
		cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
		sbb WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
		sbb BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; sbc: direct indexed with X addressing mode
__sbc_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
		cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
		push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
		sbb WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
		jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
		push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
		sbb BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; sbc: direct indexed indirect,X addressing mode
__sbc_pdx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
		push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
		push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
		sbb WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
		push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
		push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
		sbb BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; sbc: direct indexed indirect,Y addressing mode
__sbc_pd_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
		add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
    add ax, WORD [_Y]
		adc ecx, 0
    shl ecx, 16
		push ax
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
		sbb WORD [_A], ax
    GetFlags
		add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
		add ax, WORD [_Y]
		adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
		sbb BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; sbc: direct indirect long addressing mode
__sbc_bd:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
		cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
		call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
		sbb WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
		add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
		sbb BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; sbc: absolute addressing mode
__sbc_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
		cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
		add esp, 6
    SetFlags
		sbb WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
		add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
		sbb BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; sbc: absolute,X addressing mode
__sbc_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
		add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
		sbb WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
		add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
		sbb BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; sbc: absolute,Y addressing mode
__sbc_ay:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
		je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
		add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
		sbb WORD [_A], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
		add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
		add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
		sbb BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; sbc: absolute long addressing mode
__sbc_al:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
		je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetword
		add esp, 6
    SetFlags
		sbb WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
		add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
		sbb BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; sbc: absolute long,X addressing mode
__sbc_alx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
		xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
		adc cx, 0
		push ax
    shl ecx, 16
		push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
		sbb WORD [_A], ax
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
		push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
		add ax, WORD [_X]
		adc cx, 0
		push ax
		shl ecx, 16
		push ecx
		call _SNESgetbyte
    add esp, 6
    SetFlags
		sbb BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; sbc: stack relative addressing mode
__sbc_ds:
		mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
		mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
		sbb WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
		push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
		sbb BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; sbc: stack relative indirect indexed addressing mode
__sbc_pds_y:
		mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
		mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
		adc ecx, 0
    shl ecx, 16
    push ax
		push ecx
    call _SNESgetword
    add esp, 6
    SetFlags
    sbb WORD [_A], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
		push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
		shr ecx, 16
		add ax, WORD [_S]
		add ax, WORD [_X]
		adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
    call _SNESgetbyte
    add esp, 6
    SetFlags
    sbb BYTE [_A+1], al
    GetFlags
    add WORD [_PC], 1
.emuskip
		ret

; sta: direct addressing mode
__sta_d:
		mov cx, WORD [_PE]
		cmp cx, 1
		je  .emu
		mov cx, WORD [_Pm]
		cmp cx, 1
		je  .emu
		add WORD [_PC], 1
		mov cx, WORD [_PC]
		push cx
		mov ecx, DWORD [_PB]
		push ecx
		call _SNESgetbyte
		add esp, 6
		add ax, WORD [_D]
		push ax
		xor ecx, ecx
		push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
		xchg ah, al
		mov WORD [edi], ax
    GetFlags
		add WORD [_PC], 1
		jmp .emuskip
.emu
		add WORD [_PC], 1
		mov cx, WORD [_PC]
		push cx
		mov ecx, DWORD [_PB]
		push ecx
		call _SNESgetbyte
		add esp, 6
		add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
    mov BYTE [edi], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; sta: direct indexed with X addressing mode
__sta_dx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
		xchg ah, al
		mov WORD [edi], ax
    GetFlags
		add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    xor ecx, ecx
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
    mov BYTE [edi], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; sta: direct indexed indirect,X addressing mode
__sta_pdx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
		xchg ah, al
		mov WORD [edi], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
    mov BYTE [edi], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; sta: direct indexed indirect,Y addressing mode
__sta_pd_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
    add ax, WORD [_Y]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
		xchg ah, al
		mov WORD [edi], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_D]
    add ax, WORD [_Y]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
    mov BYTE [edi], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; sta: direct indirect long addressing mode
__sta_bd:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
		xchg ah, al
		mov WORD [edi], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_D]
    push ax
    xor ecx, ecx
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
    mov BYTE [edi], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; sta: absolute addressing mode
__sta_a:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
		xchg ah, al
		mov WORD [edi], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    push ax
    mov ecx, DWORD [_DB]
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
    mov BYTE [edi], al
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; sta: absolute,X addressing mode
__sta_ax:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
		xchg ah, al
		mov WORD [edi], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_X]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
    mov BYTE [edi], al
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; sta: absolute,Y addressing mode
__sta_ay:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
		xchg ah, al
		mov WORD [edi], ax
    GetFlags
    add WORD [_PC], 2
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetword
    add esp, 6
    add ax, WORD [_Y]
    push ax
    mov ecx, DWORD [_DB]
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
    mov BYTE [edi], al
    GetFlags
    add WORD [_PC], 2
.emuskip
    ret

; sta: absolute long addressing mode
__sta_al:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
		xchg ah, al
		mov WORD [edi], ax
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    push ax
    shl ecx, 16
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
    mov BYTE [edi], al
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; sta: absolute long,X addressing mode
__sta_alx:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
    adc cx, 0
    push ax
    shl ecx, 16
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
		xchg ah, al
		mov WORD [edi], ax
    GetFlags
    add WORD [_PC], 3
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    xor ecx, ecx
    call _SNESget24bit
    add esp, 6
    add ax, WORD [_X]
    adc cx, 0
    push ax
    shl ecx, 16
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
    mov BYTE [edi], al
    GetFlags
    add WORD [_PC], 3
.emuskip
    ret

; sta: stack relative addressing mode
__sta_ds:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
		xchg ah, al
		mov WORD [edi], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    add ax, WORD [_S]
    push ax
    xor ecx, ecx
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
    mov BYTE [edi], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret

; sta: stack relative indirect indexed addressing mode
__sta_pds_y:
    mov cx, WORD [_PE]
    cmp cx, 1
    je  .emu
    mov cx, WORD [_Pm]
    cmp cx, 1
    je  .emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
		xchg ah, al
		mov WORD [edi], ax
    GetFlags
    add WORD [_PC], 1
    jmp .emuskip
.emu
    add WORD [_PC], 1
    mov cx, WORD [_PC]
    push cx
    mov ecx, DWORD [_PB]
    push ecx
    call _SNESgetbyte
    add esp, 6
    mov ecx, DWORD [_DB]
    shr ecx, 16
    add ax, WORD [_S]
    add ax, WORD [_X]
    adc ecx, 0
    shl ecx, 16
    push ax
    push ecx
		call _SNESgetptr
		add esp, 6
		mov ax, WORD [_A]
    mov BYTE [edi], al
    GetFlags
    add WORD [_PC], 1
.emuskip
    ret


