/*
  Copyright 1997 , Mr. Grim (Michael Kreitzer)
*/

#include <stdio.h>
#include "general.h"
#include "opcodes.h"

char tempbyte;
short  tempint;

void init_opcodes(void)
{
  short index;

  for (index = 0; index < 256; index++)
  {
    Opcode[index] = debug;
  }

  Opcode[0x69] = _adc_i;
  Opcode[0x65] = _adc_d;
  Opcode[0x75] = _adc_dx;
  Opcode[0x72] = _adc_pd;
  Opcode[0x61] = _adc_pdx;
  Opcode[0x71] = _adc_pd_y;
  Opcode[0x67] = _adc_bd;
  Opcode[0x6D] = _adc_a;
  Opcode[0x7D] = _adc_ax;
  Opcode[0x79] = _adc_ay;
  Opcode[0x6F] = _adc_al;
  Opcode[0x7F] = _adc_alx;
  Opcode[0x63] = _adc_ds;
  Opcode[0x73] = _adc_pds_y;
  Opcode[0x29] = _and_i;
  Opcode[0x25] = _and_d;
  Opcode[0x35] = _and_dx;
  Opcode[0x32] = _and_pd;
  Opcode[0x21] = _and_pdx;
  Opcode[0x31] = _and_pd_y;
  Opcode[0x27] = _and_bd;
  Opcode[0x2D] = _and_a;
  Opcode[0x3D] = _and_ax;
  Opcode[0x39] = _and_ay;
  Opcode[0x2F] = _and_al;
  Opcode[0x3F] = _and_alx;
  Opcode[0x23] = _and_ds;
  Opcode[0x33] = _and_pds_y;
  Opcode[0x0A] = _asl_A;
  Opcode[0x06] = _asl_d;
  Opcode[0x16] = _asl_dx;
  Opcode[0x0E] = _asl_a;
  Opcode[0x1E] = _asl_ax;
  Opcode[0x89] = _bit_i;
  Opcode[0x24] = _bit_d;
  Opcode[0x34] = _bit_dx;
  Opcode[0x2C] = _bit_a;
  Opcode[0x3C] = _bit_ax;
  Opcode[0xC9] = _cmp_i;
  Opcode[0xC5] = _cmp_d;
  Opcode[0xD5] = _cmp_dx;
  Opcode[0xD2] = _cmp_pd;
  Opcode[0xC1] = _cmp_pdx;
  Opcode[0xD1] = _cmp_pd_y;
  Opcode[0xC7] = _cmp_bd;
  Opcode[0xCD] = _cmp_a;
  Opcode[0xDD] = _cmp_ax;
  Opcode[0xD9] = _cmp_ay;
  Opcode[0xCF] = _cmp_al;
  Opcode[0xDF] = _cmp_alx;
  Opcode[0xC3] = _cmp_ds;
  Opcode[0xD3] = _cmp_pds_y;
  Opcode[0xE0] = _cpx_i;
  Opcode[0xE4] = _cpx_d;
  Opcode[0xEC] = _cpx_a;
  Opcode[0xC0] = _cpy_i;
  Opcode[0xC4] = _cpy_d;
  Opcode[0xCC] = _cpy_a;
  Opcode[0x3A] = _dec_A;
  Opcode[0xC6] = _dec_d;
  Opcode[0xD6] = _dec_dx;
  Opcode[0xCE] = _dec_a;
  Opcode[0xDE] = _dec_ax;
  Opcode[0x49] = _eor_i;
  Opcode[0x45] = _eor_d;
  Opcode[0x55] = _eor_dx;
  Opcode[0x52] = _eor_pd;
  Opcode[0x41] = _eor_pdx;
  Opcode[0x51] = _eor_pd_y;
  Opcode[0x47] = _eor_bd;
  Opcode[0x4D] = _eor_a;
  Opcode[0x5D] = _eor_ax;
  Opcode[0x59] = _eor_ay;
  Opcode[0x4F] = _eor_al;
  Opcode[0x5F] = _eor_alx;
  Opcode[0x43] = _eor_ds;
  Opcode[0x53] = _eor_pds_y;
  Opcode[0x1A] = _inc_A;
  Opcode[0xE6] = _inc_d;
  Opcode[0xF6] = _inc_dx;
  Opcode[0xEE] = _inc_a;
  Opcode[0xFE] = _inc_ax;
  Opcode[0xA9] = _lda_i;
  Opcode[0xA5] = _lda_d;
  Opcode[0xB5] = _lda_dx;
  Opcode[0xB2] = _lda_pd;
  Opcode[0xA1] = _lda_pdx;
  Opcode[0xB1] = _lda_pd_y;
  Opcode[0xA7] = _lda_bd;
  Opcode[0xAD] = _lda_a;
  Opcode[0xBD] = _lda_ax;
  Opcode[0xB9] = _lda_ay;
  Opcode[0xAF] = _lda_al;
  Opcode[0xBF] = _lda_alx;
  Opcode[0xA3] = _lda_ds;
  Opcode[0xB3] = _lda_pds_y;
  Opcode[0xA2] = _ldx_i;
  Opcode[0xA6] = _ldx_d;
  Opcode[0xB6] = _ldx_dy;
  Opcode[0xAE] = _ldx_a;
  Opcode[0xBE] = _ldx_ay;
  Opcode[0xA0] = _ldy_i;
  Opcode[0xA4] = _ldy_d;
  Opcode[0xB4] = _ldy_dx;
  Opcode[0xAC] = _ldy_a;
  Opcode[0xBC] = _ldy_ax;
  Opcode[0x4A] = _lsr_A;
  Opcode[0x46] = _lsr_d;
  Opcode[0x56] = _lsr_dx;
  Opcode[0x4E] = _lsr_a;
  Opcode[0x5E] = _lsr_ax;
  Opcode[0x09] = _ora_i;
  Opcode[0x05] = _ora_d;
  Opcode[0x15] = _ora_dx;
  Opcode[0x12] = _ora_pd;
  Opcode[0x01] = _ora_pdx;
  Opcode[0x11] = _ora_pd_y;
  Opcode[0x07] = _ora_bd;
  Opcode[0x0D] = _ora_a;
  Opcode[0x1D] = _ora_ax;
  Opcode[0x19] = _ora_ay;
  Opcode[0x0F] = _ora_al;
  Opcode[0x1F] = _ora_alx;
  Opcode[0x03] = _ora_ds;
  Opcode[0x13] = _ora_pds_y;
  Opcode[0x2A] = _rol_A;
  Opcode[0x26] = _rol_d;
  Opcode[0x36] = _rol_dx;
  Opcode[0x2E] = _rol_a;
  Opcode[0x3E] = _rol_ax;
  Opcode[0x6A] = _ror_A;
  Opcode[0x66] = _ror_d;
  Opcode[0x76] = _ror_dx;
  Opcode[0x6E] = _ror_a;
  Opcode[0x7E] = _ror_ax;
  Opcode[0xE9] = _sbc_i;
  Opcode[0xE5] = _sbc_d;
  Opcode[0xF5] = _sbc_dx;
  Opcode[0xF2] = _sbc_pd;
  Opcode[0xE1] = _sbc_pdx;
  Opcode[0xF1] = _sbc_pd_y;
  Opcode[0xE7] = _sbc_bd;
  Opcode[0xED] = _sbc_a;
  Opcode[0xFD] = _sbc_ax;
  Opcode[0xF9] = _sbc_ay;
  Opcode[0xEF] = _sbc_al;
  Opcode[0xFF] = _sbc_alx;
  Opcode[0xE3] = _sbc_ds;
  Opcode[0xF3] = _sbc_pds_y;
  Opcode[0x85] = _sta_d;
  Opcode[0x95] = _sta_dx;
  Opcode[0x92] = _sta_pd;
  Opcode[0x81] = _sta_pdx;
  Opcode[0x91] = _sta_pd_y;
  Opcode[0x87] = _sta_bd;
  Opcode[0x8D] = _sta_a;
  Opcode[0x9D] = _sta_ax;
  Opcode[0x99] = _sta_ay;
  Opcode[0x8F] = _sta_al;
  Opcode[0x9F] = _sta_alx;
  Opcode[0x83] = _sta_ds;
  Opcode[0x93] = _sta_pds_y;
  Opcode[0x86] = _stx_d;
  Opcode[0x96] = _stx_dy;
  Opcode[0x8E] = _stx_a;
  Opcode[0x84] = _sty_d;
  Opcode[0x94] = _sty_dx;
  Opcode[0x8C] = _sty_a;
  Opcode[0x64] = _stz_d;
  Opcode[0x74] = _stz_dx;
  Opcode[0x9C] = _stz_a;
  Opcode[0x9E] = _stz_ax;
  Opcode[0x14] = _trb_d;
  Opcode[0x1C] = _trb_a;
  Opcode[0x04] = _tsb_d;
  Opcode[0x0C] = _tsb_a;
  Opcode[0x90] = _bcc;
  Opcode[0xB0] = _bcs;
  Opcode[0xF0] = _beq;
  Opcode[0x30] = _bmi;
  Opcode[0xD0] = _bne;
  Opcode[0x10] = _bpl;
  Opcode[0x80] = _bra;
  Opcode[0x50] = _bvc;
  Opcode[0x70] = _bvs;
  Opcode[0x18] = _clc;
  Opcode[0xD8] = _cld;
  Opcode[0x58] = _cli;
  Opcode[0xB8] = _clv;
  Opcode[0xCA] = _dex;
  Opcode[0x88] = _dey;
  Opcode[0xE8] = _inx;
  Opcode[0xC8] = _iny;
  Opcode[0xEA] = _nop;
  Opcode[0xF4] = _pea;
  Opcode[0xD4] = _pei;
  Opcode[0x62] = _per;
  Opcode[0x48] = _pha;
  Opcode[0x8B] = _phb;
  Opcode[0x0B] = _phd;
  Opcode[0x4B] = _phk;
  Opcode[0x08] = _php;
  Opcode[0xDA] = _phx;
  Opcode[0x5A] = _phy;
  Opcode[0x68] = _pla;
  Opcode[0xAB] = _plb;
  Opcode[0x2B] = _pld;
  Opcode[0x28] = _plp;
  Opcode[0xFA] = _plx;
  Opcode[0x7A] = _ply;
  Opcode[0x38] = _sec;
  Opcode[0xF8] = _sed;
  Opcode[0x78] = _sei;
  Opcode[0xAA] = _tax;
  Opcode[0xA8] = _tay;
  Opcode[0x5B] = _tcd;
  Opcode[0x1B] = _tcs;
  Opcode[0x7B] = _tdc;
  Opcode[0x3B] = _tsc;
  Opcode[0xBA] = _tsx;
  Opcode[0x8A] = _txa;
  Opcode[0x9A] = _txs;
  Opcode[0x9B] = _txy;
  Opcode[0x98] = _tya;
  Opcode[0xBB] = _tyx;
  Opcode[0xFB] = _xce;
  Opcode[0xE2] = _sep;
  Opcode[0x82] = _brl;
  Opcode[0x5C] = _jmp_al;
  Opcode[0xC2] = _rep;
  Opcode[0xEB] = _xba;
  Opcode[0x20] = _jsr_a;
  Opcode[0x60] = _rts;
} 

void _adc_i(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetbyte(PC, PB);
    PC++;
    A += tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    At = (long)A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  t += 2;
}

void _adc_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, 0);
    A += tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _adc_dx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte+X, 0);
    A += tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _adc_pd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, DB);
    A += tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, DB);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}
  
void _adc_pdx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte+X, DB);
    A += tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, DB);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 6;
}

void _adc_pd_y(void)
{
  long At;
  long mem;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetbyte((unsigned int)(mem & 0x0000ffff), mem >> 16);
    A += tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (A == 0) P |= 0x02;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetword((unsigned int)(mem & 0x0000ffff), mem >> 16);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _adc_bd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, 0);
    A += tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 6;
}

void _adc_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint, DB);
    A += tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _adc_ax(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint+X, DB);
    A += tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _adc_ay(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint+Y, DB);
    A += tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _adc_al(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(tempint, tempbyte);
    A += tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(tempint, tempbyte);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _adc_alx(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    A += tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _adc_ds(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(S+tempbyte, 0);
    A += tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(S+tempbyte, 0);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _adc_pds_y(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    A += tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 7;
}

void _and_i(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetbyte(PC, PB);
    PC++;
    A &= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    At = (long)A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  t += 2;
}

void _and_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, 0);
    A &= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _and_dx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte+X, 0);
    A &= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _and_pd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, DB);
    A &= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, DB);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}
  
void _and_pdx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte+X, DB);
    A &= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, DB);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 6;
}

void _and_pd_y(void)
{
  long At;
  long mem;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetbyte((unsigned int)(mem & 0x0000ffff), mem >> 16);
    A &= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetword((unsigned int)(mem & 0x0000ffff), mem >> 16);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _and_bd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, 0);
    A &= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 6;
}

void _and_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint, DB);
    A &= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _and_ax(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint+X, DB);
    A &= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _and_ay(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint+Y, DB);
    A &= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _and_al(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(tempint, tempbyte);
    A &= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(tempint, tempbyte);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _and_alx(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    A &= tempint;
    if (A == 0) P |= 0x02;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _and_ds(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(S+tempbyte, 0);
    A &= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(S+tempbyte, 0);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _and_pds_y(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    A &= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 7;
}

void _asl_A(void)
{
  if (PE == 1 || (P & 0x20))  
  {
    P &= 0xFFFE | (0x0001 & (A >> 8));
    A <<= 1;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);
  }
  else
  {
    P &= 0xFFFE | (0x0001 & (A >> 16));
    A <<= 1;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);
  }

  PC++;
  t += 2;
}

void _asl_d(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = SNESgetbyte(D+tempbyte, PB);
    P &= 0xFFFE | (0x0001 & (int)(tempbyte >> 8));
    tempbyte <<= 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, PB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC++;
  t += 2;
}

void _asl_dx(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = SNESgetbyte(D+tempbyte+X, PB);
    P &= 0xFFFE | (0x0001 & (int)(tempbyte >> 8));
    tempbyte <<= 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, PB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC++;
  t += 2;
}

void _asl_a(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte = SNESgetbyte(tempint, DB);
    P &= 0xFFFE | (0x0001 & (int)(tempbyte >> 8));
    tempbyte <<= 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC += 2;
  t += 2;
}

void _asl_ax(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte = SNESgetbyte(tempint+X, DB);
    P &= 0xFFFE | (0x0001 & (int)(tempbyte >> 8));
    tempbyte <<= 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC += 2;
  t += 2;
}

void _bit_i(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = A & (int)tempbyte;
    P = P & ((0x8000 & (int)tempbyte) | 0x7FFF);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC++;
    tempint  = A & tempint;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
  }

  PC++;
  t += 2;
}

void _bit_d(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = SNESgetbyte(D+tempbyte, PB);
    tempbyte = A & (int)tempbyte;
    P = P & ((0x8000 & (int)tempbyte) | 0x7FFF);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, PB);
    tempint  = A & tempint;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
  }

  PC++;
  t += 2;
}

void _bit_dx(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = SNESgetbyte(D+tempbyte+X, PB);
    tempbyte = A & (int)tempbyte;
    P = P & ((0x8000 & (int)tempbyte) | 0x7FFF);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, PB);
    tempint  = A & tempint;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
  }

  PC++;
  t += 2;
}

void _bit_a(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte = SNESgetbyte(tempint, DB);
    tempbyte = A & (int)tempbyte;
    P = P & ((0x8000 & (int)tempbyte) | 0x7FFF);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    tempint  = A & tempint;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
  }

  PC += 2;
  t += 2;
}

void _bit_ax(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte = SNESgetbyte(tempint+X, DB);
    tempbyte = A & (int)tempbyte;
    P = P & ((0x8000 & (int)tempbyte) | 0x7FFF);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    tempint  = A & tempint;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
  }

  PC += 2;
  t += 2;
}

void _cmp_i(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte  = SNESgetbyte(PC, PB);
    PC++;
    tempbyte =  A - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  t += 2;
}

void _cmp_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte  = SNESgetbyte(D+tempbyte, 0);
    tempbyte =  A - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _cmp_dx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte  = SNESgetbyte(D+tempbyte+X, 0);
    tempbyte =  A - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _cmp_pd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte  = SNESgetbyte(D+tempbyte, DB);
    tempbyte =  A - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, DB);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}
  
void _cmp_pdx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte  = SNESgetbyte(D+tempbyte+X, DB);
    tempbyte =  A - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, DB);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 6;
}

void _cmp_pd_y(void)
{
  long At;
  long mem;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempbyte  = SNESgetbyte((unsigned int)(mem & 0x0000ffff), mem >> 16);
    tempbyte =  A - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetword((unsigned int)(mem & 0x0000ffff), mem >> 16);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _cmp_bd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte  = SNESgetbyte(D+tempbyte, 0);
    tempbyte =  A - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 6;
}

void _cmp_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte  = SNESgetbyte(tempint, DB);
    tempbyte =  A - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _cmp_ax(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte  = SNESgetbyte(tempint+X, DB);
    tempbyte =  A - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _cmp_ay(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte  = SNESgetbyte(tempint+Y, DB);
    tempbyte =  A - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _cmp_al(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte  = SNESgetbyte(tempint, tempbyte);
    tempbyte =  A - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(tempint, tempbyte);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _cmp_alx(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempbyte  = SNESgetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    tempbyte =  A - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _cmp_ds(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte  = SNESgetbyte(S+tempbyte, 0);
    tempbyte =  A - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(S+tempbyte, 0);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _cmp_pds_y(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempbyte  = SNESgetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    tempbyte =  A - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 7;
}

void _cpx_i(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempbyte  = SNESgetbyte(PC, PB);
    PC++;
    tempbyte =  X - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    if (tempint == X) P |= 0x02;
    tempint = X - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  t += 2;
}

void _cpx_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte  = SNESgetbyte(D+tempbyte, 0);
    tempbyte =  X - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    tempint = X - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _cpx_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte  = SNESgetbyte(tempint, DB);
    tempbyte =  X - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    tempint = X - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _cpy_i(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempbyte  = SNESgetbyte(PC, PB);
    PC++;
    tempbyte =  Y - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempint = Y - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  t += 2;
}

void _cpy_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte  = SNESgetbyte(D+tempbyte, 0);
    tempbyte =  Y - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    tempint = Y - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _cpy_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte  = SNESgetbyte(tempint, DB);
    tempbyte =  Y - tempbyte;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    tempint = Y - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _dec_A(void)
{
  if (PE == 1 || (P & 0x20))  
  {
    A -= 1;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);
  }
  else
  {
    A -= 1;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);
  }

  PC++;
  t += 2;
}

void _dec_d(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = SNESgetbyte(D+tempbyte, PB);
    tempbyte -= 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, PB);
    tempint -= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC++;
  t += 2;
}

void _dec_dx(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = SNESgetbyte(D+tempbyte+X, PB);
    tempbyte -= 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, PB);
    tempint -= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC++;
  t += 2;
}

void _dec_a(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte = SNESgetbyte(tempint, DB);
    tempbyte -= 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    tempint -= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC += 2;
  t += 2;
}

void _dec_ax(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte = SNESgetbyte(tempint+X, DB);
    tempbyte -= 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    tempint -= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC += 2;
  t += 2;
}

void _eor_i(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetbyte(PC, PB);
    PC++;
    A ^= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    At = (long)A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  t += 2;
}

void _eor_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, 0);
    A ^= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _eor_dx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte+X, 0);
    A ^= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _eor_pd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, DB);
    A ^= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, DB);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}
  
void _eor_pdx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte+X, DB);
    A ^= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, DB);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 6;
}

void _eor_pd_y(void)
{
  long At;
  long mem;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetbyte((unsigned int)(mem & 0x0000ffff), mem >> 16);
    A ^= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetword((unsigned int)(mem & 0x0000ffff), mem >> 16);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _eor_bd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, 0);
    A ^= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 6;
}

void _eor_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint, DB);
    A ^= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _eor_ax(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint+X, DB);
    A ^= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _eor_ay(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint+Y, DB);
    A ^= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _eor_al(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(tempint, tempbyte);
    A ^= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(tempint, tempbyte);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _eor_alx(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    A ^= tempint;
    if (A == 0) P |= 0x02;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _eor_ds(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(S+tempbyte, 0);
    A ^= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(S+tempbyte, 0);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _eor_pds_y(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    A ^= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 7;
}

void _inc_A(void)
{
  if (PE == 1 || (P & 0x20))  
  {
    A += 1;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);
  }
  else
  {
    A += 1;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);
  }

  PC++;
  t += 2;
}

void _inc_d(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = SNESgetbyte(D+tempbyte, PB);
    tempbyte += 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, PB);
    tempint += 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC++;
  t += 2;
}

void _inc_dx(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = SNESgetbyte(D+tempbyte+X, PB);
    tempbyte += 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, PB);
    tempint += 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC++;
  t += 2;
}

void _inc_a(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte = SNESgetbyte(tempint, DB);
    tempbyte += 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    tempint += 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC += 2;
  t += 2;
}

void _inc_ax(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte = SNESgetbyte(tempint+X, DB);
    tempbyte += 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    tempint += 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC += 2;
  t += 2;
}

void _lda_i(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetbyte(PC, PB);
    PC++;
    A = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    P &= ((0x8000 & (short)tempbyte) | 0x7FFF);
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  t += 2;
}

void _lda_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, 0);
    A = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _lda_dx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte+X, 0);
    A = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _lda_pd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, DB);
    A = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, DB);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}
  
void _lda_pdx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte+X, DB);
    A = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, DB);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 6;
}

void _lda_pd_y(void)
{
  long At;
  long mem;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetbyte((unsigned int)(mem & 0x0000ffff), mem >> 16);
    A = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetword((unsigned int)(mem & 0x0000ffff), mem >> 16);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _lda_bd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, 0);
    A = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 6;
}

void _lda_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint, DB);
    A = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _lda_ax(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint+X, DB);
    A = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    P &= ((0x8000 & (short)tempbyte) | 0x7FFF);
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _lda_ay(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint+Y, DB);
    A = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _lda_al(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(tempint, tempbyte);
    A = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(tempint, tempbyte);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _lda_alx(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    A = tempint;
    if (A == 0) P |= 0x02;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _lda_ds(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(S+tempbyte, 0);
    A = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(S+tempbyte, 0);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _lda_pds_y(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    A = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 7;
}
    
void _ldx_i(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempint  = SNESgetbyte(PC, PB);
    PC++;
    X = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    At = tempint;
    X = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  t += 2;
}

void _ldx_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, 0);
    X = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = tempint;
    X = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _ldx_dy(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte+Y, 0);
    X = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+Y, 0);
    At = tempint;
    X = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _ldx_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint, DB);
    X = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = tempint;
    X = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _ldx_ay(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint+Y, DB);
    X = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    At = tempint;
    X = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _ldy_i(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempint  = SNESgetbyte(PC, PB);
    PC++;
    Y = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    At = tempint;
    Y = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  t += 2;
}

void _ldy_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, 0);
    Y = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = tempint;
    Y = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _ldy_dx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte+X, 0);
    Y = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    At = tempint;
    Y = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _ldy_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint, DB);
    Y = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = tempint;
    Y = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _ldy_ax(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint+X, DB);
    Y = tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    At = tempint;
    Y = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _lsr_A(void)
{
  if (PE == 1 || (P & 0x20))  
  {
    P &= 0xFFFE | (0x0001 & (A));
    A >>= 1;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);
  }
  else
  {
    P &= 0xFFFE | (0x0001 & (A));
    A >>= 1;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);
  }

  PC++;
  t += 2;
}

void _lsr_d(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = SNESgetbyte(D+tempbyte, PB);
    P &= 0xFFFE | (0x0001 & (int)tempbyte);
    tempbyte >>= 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, PB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC++;
  t += 2;
}

void _lsr_dx(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = SNESgetbyte(D+tempbyte+X, PB);
    P &= 0xFFFE | (0x0001 & (int)(tempbyte));
    tempbyte >>= 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, PB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC++;
  t += 2;
}

void _lsr_a(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte = SNESgetbyte(tempint, DB);
    P &= 0xFFFE | (0x0001 & (int)(tempbyte));
    tempbyte >>= 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC += 2;
  t += 2;
}

void _lsr_ax(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte = SNESgetbyte(tempint+X, DB);
    P &= 0xFFFE | (0x0001 & (int)(tempbyte));
    tempbyte >>= 1;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC += 2;
  t += 2;
}

void _ora_i(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetbyte(PC, PB);
    PC++;
    A |= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    At = (long)A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  t += 2;
}

void _ora_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, 0);
    A |= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _ora_dx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte+X, 0);
    A |= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _ora_pd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, DB);
    A |= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, DB);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}
  
void _ora_pdx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte+X, DB);
    A |= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, DB);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 6;
}

void _ora_pd_y(void)
{
  long At;
  long mem;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetbyte((unsigned int)(mem & 0x0000ffff), mem >> 16);
    A |= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetword((unsigned int)(mem & 0x0000ffff), mem >> 16);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _ora_bd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, 0);
    A |= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 6;
}

void _ora_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint, DB);
    A |= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _ora_ax(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint+X, DB);
    A |= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _ora_ay(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint+Y, DB);
    A |= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _ora_al(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(tempint, tempbyte);
    A |= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(tempint, tempbyte);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _ora_alx(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    A |= tempint;
    if (A == 0) P |= 0x02;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _ora_ds(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(S+tempbyte, 0);
    A |= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(S+tempbyte, 0);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _ora_pds_y(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    A |= tempint;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 7;
}

void _rol_A(void)
{
  if (PE == 1 || (P & 0x20))  
  {
    P &= 0xFFFE | (0x0001 & (A >> 8));
    A <<= 1;
    A |= (P & 0x0001);
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);
  }
  else
  {
    P &= 0xFFFE | (0x0001 & (A >> 16));
    A <<= 1;
    A |= (P & 0x0001);
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);
  }

  PC++;
  t += 2;
}

void _rol_d(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = SNESgetbyte(D+tempbyte, PB);
    P &= 0xFFFE | (0x0001 & (int)(tempbyte >> 8));
    tempbyte <<= 1;
    tempbyte |= (P & 0x0001);
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, PB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    tempint |= (P & 0x0001);
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC++;
  t += 2;
}

void _rol_dx(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = SNESgetbyte(D+tempbyte+X, PB);
    P &= 0xFFFE | (0x0001 & (int)(tempbyte >> 8));
    tempbyte <<= 1;
    tempbyte |= (P & 0x0001);
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, PB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    tempint |= (P & 0x0001);
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC++;
  t += 2;
}

void _rol_a(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte = SNESgetbyte(tempint, DB);
    P &= 0xFFFE | (0x0001 & (int)(tempbyte >> 8));
    tempbyte <<= 1;
    tempbyte |= (P & 0x0001);
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    tempint |= (P & 0x0001);
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC += 2;
  t += 2;
}

void _rol_ax(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte = SNESgetbyte(tempint+X, DB);
    P &= 0xFFFE | (0x0001 & (int)(tempbyte >> 8));
    tempbyte <<= 1;
    tempbyte |= (P & 0x0001);
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    tempint |= (P & 0x0001);
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC += 2;
  t += 2;
}

void _ror_A(void)
{
  if (PE == 1 || (P & 0x20))  
  {
    P &= 0xFFFE | (0x0001 & (A));
    A >>= 1;
    A |= (P & 0x0001) << 8;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);
  }
  else
  {
    P &= 0xFFFE | (0x0001 & (A));
    A >>= 1;
    A |= (P & 0x0001) << 16;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);
  }

  PC++;
  t += 2;
}

void _ror_d(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = SNESgetbyte(D+tempbyte, PB);
    P &= 0xFFFE | (0x0001 & (int)tempbyte);
    tempbyte >>= 1;
    tempbyte |= (P & 0x0001) << 8;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, PB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    tempint |= (P & 0x0001) << 16;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC++;
  t += 2;
}

void _ror_dx(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempbyte = SNESgetbyte(D+tempbyte+X, PB);
    P &= 0xFFFE | (0x0001 & (int)(tempbyte));
    tempbyte >>= 1;
    tempbyte |= (P & 0x0001) << 8;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, PB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    tempint |= (P & 0x0001) << 16;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC++;
  t += 2;
}

void _ror_a(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte = SNESgetbyte(tempint, DB);
    P &= 0xFFFE | (0x0001 & (int)(tempbyte));
    tempbyte >>= 1;
    tempbyte |= (P & 0x0001) << 8;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    tempint |= (P & 0x0001) << 16;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC += 2;
  t += 2;
}

void _ror_ax(void)
{
  PC++;
  
  if (PE == 1 || (P & 0x20))  
  {
    tempint  = SNESgetword(PC, PB);
    tempbyte = SNESgetbyte(tempint+X, DB);
    P &= 0xFFFE | (0x0001 & (int)(tempbyte));
    tempbyte >>= 1;
    tempbyte |= (P & 0x0001) << 8;
    P = P & ((int)((0x80 & tempbyte) | 0x7F) << 8);
    if (tempbyte == 0) P |= 0x02; else P &= (!0x02);
    SNESsetbyte(PC, PB, tempbyte);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    tempint |= (P & 0x0001) << 16;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);
  }

  PC += 2;
  t += 2;
}

void _sbc_i(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetbyte(PC, PB);
    PC++;
    A -= tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC -= 2;
    At = (long)A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  t += 2;
}

void _sbc_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, 0);
    A -= tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _sbc_dx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte+X, 0);
    A -= tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _sbc_pd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, DB);
    A -= tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, DB);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}
  
void _sbc_pdx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte+X, DB);
    A -= tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, DB);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 6;
}

void _sbc_pd_y(void)
{
  long At;
  long mem;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetbyte((unsigned int)(mem & 0x0000ffff), mem >> 16);
    A -= tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (A == 0) P |= 0x02;
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetword((unsigned int)(mem & 0x0000ffff), mem >> 16);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _sbc_bd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(D+tempbyte, 0);
    A -= tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 6;
}

void _sbc_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint, DB);
    A -= tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _sbc_ax(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint+X, DB);
    A -= tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _sbc_ay(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetbyte(tempint+Y, DB);
    A -= tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00FF;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC += 2;
  t += 4;
}

void _sbc_al(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(tempint, tempbyte);
    A -= tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(tempint, tempbyte);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _sbc_alx(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    A -= tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 5;
}

void _sbc_ds(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetbyte(S+tempbyte, 0);
    A -= tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(S+tempbyte, 0);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 4;
}

void _sbc_pds_y(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    A -= tempint;
    if (A > 0xff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    if (tempbyte == 0) P |= 0x02; else P &= 0xFD;
    if (tempbyte & 0x80) P |= 0x80; else P &= 0x7F;
    A &= 0x00ff;
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  }
  
  PC++;
  t += 7;
}

void _sta_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(D+tempbyte, 0, A);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, 0, A);
  }
  
  PC++;
  t += 4;
}

void _sta_dx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(D+tempbyte+X, 0, A);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte+X, 0, A);
  }
  
  PC++;
  t += 4;
}

void _sta_pd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(D+tempbyte, DB, A);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, DB, A);
  }
  
  PC++;
  t += 5;
}
  
void _sta_pdx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(D+tempbyte+X, DB, A);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte+X, DB, A);
  }
  
  PC++;
  t += 6;
}

void _sta_pd_y(void)
{
  long At;
  long mem;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    SNESsetbyte((unsigned int)(mem & 0x0000ffff), mem >> 16, A);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    SNESsetword((unsigned int)(mem & 0x0000ffff), mem >> 16, A);
  }
  
  PC++;
  t += 5;
}

void _sta_bd(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(D+tempbyte, 0, A);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, 0, A);
  }
  
  PC++;
  t += 6;
}

void _sta_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetbyte(tempint, DB, A);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint, DB, A);
  }
  
  PC += 2;
  t += 4;
}

void _sta_ax(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetbyte(tempint+X, DB, A);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint+X, DB, A);
  }
  
  PC++;
  t += 4;
}

void _sta_ay(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetbyte(tempint+Y, DB, A);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint+Y, DB, A);
  }
  
  PC++;
  t += 4;
}

void _sta_al(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(tempint, tempbyte, A);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(tempint, tempbyte, A);
  }
  
  PC++;
  t += 5;
}

void _sta_alx(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    SNESsetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16), A);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    SNESsetword((int)(addr & 0x0000FFFF), (char)(addr >> 16), A);
  }
  
  PC++;
  t += 5;
}

void _sta_ds(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(S+tempbyte, 0, A);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(S+tempbyte, 0, A);
  }
  
  PC++;
  t += 4;
}

void _sta_pds_y(void)
{
  long At;
  long addr;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    SNESsetbyte((int)(addr & 0x0000FFFF), (char)(addr >> 16), A);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    SNESsetword((int)(addr & 0x0000FFFF), (char)(addr >> 16), A);
  }
  
  PC++;
  t += 7;
}

void _stx_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(D+tempbyte, 0, X);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, 0, X);
  }
  
  PC++;
  t += 4;
}

void _stx_dy(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(D+tempbyte+Y, 0, X);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte+Y, 0, X);
  }
  
  PC++;
  t += 4;
}

void _stx_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetbyte(tempint, DB, X);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint, DB, X);
  }
  
  PC += 2;
  t += 4;
}

void _sty_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(D+tempbyte, 0, Y);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, 0, Y);
  }
  
  PC++;
  t += 4;
}

void _sty_dx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(D+tempbyte+X, 0, Y);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte+X, 0, Y);
  }
  
  PC++;
  t += 4;
}

void _sty_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x10))
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetbyte(tempint, DB, Y);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint, DB, Y);
  }
  
  PC += 2;
  t += 4;
}

void _stz_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(D+tempbyte, 0, 0);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, 0, 0);
  }
  
  PC++;
  t += 4;
}

void _stz_dx(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(D+tempbyte+X, 0, 0);
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte+X, 0, 0);
  }
  
  PC++;
  t += 4;
}

void _stz_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetbyte(tempint, DB, 0);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint, DB, 0);
  }
  
  PC += 2;
  t += 4;
}

void _stz_ax(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetbyte(tempint+X, DB, 0);
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint+X, DB, 0);
  }
  
  PC += 2;
  t += 4;
}

void _trb_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(D+tempbyte, 0, !A & SNESgetbyte(D+tempbyte, 0));
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, 0, !A & SNESgetword(D+tempbyte, 0));
  }
  
  PC++;
  t += 4;
}

void _trb_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetbyte(tempint, DB, !A & SNESgetbyte(tempint, DB));
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint, DB, !A & SNESgetword(tempint, DB));
  }
  
  PC++;
  t += 4;
}

void _tsb_d(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetbyte(D+tempbyte, 0, A | SNESgetbyte(D+tempbyte, 0));
  }
  else
  {
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, 0, A | SNESgetword(D+tempbyte, 0));
  }
  
  PC++;
  t += 4;
}

void _tsb_a(void)
{
  long At;
  
  PC++;
  if ((PE == 1) || (P & 0x20))
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetbyte(tempint, DB, A | SNESgetbyte(tempint, DB));
  }
  else
  {
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint, DB, A | SNESgetword(tempint, DB));
  }
  
  PC++;
  t += 4;
}

void _bcc(void)
{
  if (!(P & 0x01))
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _bcs(void)
{
  if (P & 0x01)
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _beq(void)
{
  if (P & 0x02)
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _bmi(void)
{
  if (P & 0x80)
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _bne(void)
{
  if (!(P & 0x02))
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _bpl(void)
{
  if (!(P & 0x80))
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _bra(void)
{
  PC++;
  PC += (signed char)SNESgetbyte(PC, PB);
  PC++;
}

void _bvc(void)
{
  if (!(P & 0x40))
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _bvs(void)
{
  if (P & 0x40)
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _clc(void)
{
  P &= 0xFE;
  PC++;
}

void _cld(void)
{
  P &= 0xF7;
  PC++;
}

void _cli(void)
{
  P &= 0xFB;
  PC++;
}

void _clv(void)
{
  P &= 0xBF;
  PC++;
}

void _dex(void)
{
  X--;
  PC++;
}

void _dey(void)
{
  Y--;
  PC++;
}

void _inx(void)
{
  X++;
  PC++;
}

void _iny(void)
{
  Y++;
  PC++;
}

void _nop(void)
{
  PC++;
  return;
}

void _pea(void)
{
  PC++;
  SNESsetbyte(S, 0, SNESgetbyte(PC, PB));
  S -= 2;
  PC += 2;
}

void _pei(void)
{
  PC++;
  tempbyte = SNESgetbyte(PC, PB);
  SNESsetbyte(S, 0, SNESgetword(D+tempbyte, 0));
  S -= 2;
  PC += 1;
}

void _per(void)
{
  PC++;
  tempbyte = SNESgetbyte(PC, PB);
  SNESsetbyte(S, 0, SNESgetword(PC+tempbyte, PB));
  S -= 2;
  PC += 1;
}

void _pha(void)
{
  PC++;
  if (PE == 1 || (P & 0x20))
  {
    SNESsetbyte(S, 0, (char)A);
    S -= 1;
  }
  else
  {
    SNESsetword(S, 0, A);
    S -= 2;
  }
}

void _phb(void)
{
  PC++;
  SNESsetbyte(S, 0, DB);
  S -= 1;
}

void _phd(void)
{
  PC++;
  SNESsetword(S, 0, D);
  S -= 2;
}

void _phk(void)
{
  PC++;
  SNESsetbyte(S, 0, PB);
  S -= 1;
}

void _php(void)
{
  PC++;
  SNESsetbyte(S, 0, P);
  S -= 1;
}

void _phx(void)
{
  PC++;
  if (PE == 1 || (P & 0x10))
  {
    SNESsetbyte(S, 0, (char)X);
    S -= 1;
  }
  else
  {
    SNESsetword(S, 0, X);
    S -= 2;
  }
}

void _phy(void)
{
  PC++;
  if (PE == 1 || (P & 0x10))
  {
    SNESsetbyte(S, 0, (char)Y);
    S -= 1;
  }
  else
  {
    SNESsetword(S, 0, Y);
    S -= 2;
  }
}

void _pla(void)
{
  PC++;
  if (PE == 1 || (P & 0x20))
  {
    S += 1;
    A = SNESgetbyte(S, 0);
  }
  else
  {
    S += 2;
    A = SNESgetword(S, 0);
  }
}

void _plb(void)
{
  S += 1;
  DB = SNESgetbyte(S, 0);
  PC++;
}

void _pld(void)
{
  S += 2;
  D = SNESgetword(S, 0);
  PC++;
}

void _plp(void)
{ 
  S += 1;
  P = SNESgetbyte(S, 0);
  PC++;
}

void _plx(void)
{
  PC++;
  if (PE == 1 || (P & 0x10))
  {
    S += 1;
    X = SNESgetbyte(S, 0);
  }
  else
  {
    S += 2;
    X = SNESgetword(S, 0);
  }
}

void _ply(void)
{
  PC++;
  if (PE == 1 || (P & 0x10))
  {
    S += 1;
    Y = SNESgetbyte(S, 0);
  }
  else
  {
    S += 2;
    Y = SNESgetword(S, 0);
  }
}

void _sec(void)
{
  PC++;
  P |= 0x01;
}

void _sed(void)
{
  PC++;
  P |= 0x08;
}

void _sei(void)
{
  PC++;
  P |= 0x04;
}

void _tax(void)
{
  PC++;
  X = A;
}

void _tay(void)
{
  PC++;
  Y = A;
}

void _tcd(void)
{
  PC++;
  D = A;
}

void _tcs(void)
{
  PC++;
  S = A;
}

void _tdc(void)
{
  PC++;
  A = D;
}

void _tsc(void)
{
  PC++;
  A = S;
}

void _tsx(void)
{
  X = S;
  PC++;
}

void _txa(void)
{
  A = X;
  PC++;
}

void _txs(void)
{
  if (PE == 1)
  {
    S = 0x0100 + (A & 0x00FF);
  }
  else
  {
    S = A;
  }

  PC++;
}

void _txy(void)
{
  PC++;
  Y = X;
}

void _tya(void)
{ 
  PC++;
  A = Y;
}

void _tyx(void)
{
  PC++;
  X = Y;
}

void _xce(void)
{
  PE = P & 0x01;
  P |= PE & 0x01;

  if (PE == 1)
  {
    P |= 0x30;
    S = (S & 0x00FF) | 0x0100;
  }

  PC++;
}

void _brl(void)
{
  PC++;
  tempint = SNESgetword(PC, PB);
  PC += tempint;
  PC+=2;
}

void _jmp_al(void)
{
 PC++;
 tempint = SNESgetword(PC,PB);
 PB=SNESgetbyte(PC+2,PB);
 PC=tempint;
}

void _sep(void)
{
  PC++;
  P = P | SNESgetbyte(PC, PB);
  PC++;
}

void _rep(void)
{
  PC++;
  P = P & !SNESgetbyte(PC, PB);
  PC++;
}

void _xba(void)
{
  A = ((A & 0x00FF) << 8) | ((A & 0xFF00) >> 8);
  PC++;
}

void _jsr_a(void)
{
  SNESsetword(S, 0, PC);
  S -= 2;
  PC = SNESgetword(PC+1, PB);
}

void _rts(void)
{
  S += 2;
  PC = SNESgetword(S, 0) + 3;
}

void debug(void)
{
  printf("unimplemented opcode: 0x%X\n", (int)SNESgetbyte(PC, PB));
  printf("PE=0x%X, P=0x%X, A=0x%X, X=0x%X, Y=0x%X, D=0x%X, DB=0x%X,\n", (int)PE, (int)P, (int)A, (int)X, (int)Y, (int)D, (int)DB);
  printf("PC=0x%X, PB=0x%X, S=0x%X\n", (int)PC, (int)PB, (int)S);
  exit(1);
}


