////////////////////////////////////////////////////////////////////
// adc.cpp: All the ADC opcodes.
//
// 7-17-97 Mr. Grim
//   Started...
////////////////////////////////////////////////////////////////////

#include "Opcodes.h"
#include "OpDefine.h"

// Byte Size ADC's first.. =) //////////////////////////////////////
void B_adc_i(void)
{
  Immediate();
  _adc_b();
  
  IP++;
  CPUTicks += 2;
}

void B_adc_d(void)
{
  Direct();
  _adc_b();
  
  IP++;
  CPUTicks += 3;
}

void B_adc_dx(void)
{
  DirIndexX();
  _adc_b();
  
  IP++;
  CPUTicks += 4;
}

void B_adc_pd(void)
{
  DirectInd();
  _adc_b();
  
  IP++;
  CPUTicks += 5;
}

void B_adc_pdx(void)
{
  DirIndexInd();
  _adc_b();
  
  IP++;
  CPUTicks += 6;
}

void B_adc_pd_y(void)
{
  IndirectY();
  _adc_b();
  
  IP++;
  CPUTicks += 5;
}

void B_adc_bd(void)
{
  DirectIndL();
  _adc_b();
  
  IP++;
  CPUTicks += 6;
}

void B_adc_a(void)
{
  Absolute();
  _adc_b();
  
  IP += 2;
  CPUTicks += 4;
}

void B_adc_ax(void)
{
  AbsoluteX();
  _adc_b();
  
  IP += 2;
  CPUTicks += 4;
}

void B_adc_ay(void)
{
  AbsoluteY();
  _adc_b();
  
  IP += 2;
  CPUTicks += 4;
}

void B_adc_al(void)
{
  AbsoluteLong();
  _adc_b();
  
  IP++;
  CPUTicks += 5;
}

void B_adc_alx(void)
{
  AbsoluteLongX();
  _adc_b();
  
  IP++;
  CPUTicks += 5;
}

void B_adc_ds(void)
{
  StackRel();
  _adc_b();
  
  IP++;
  CPUTicks += 4;
}

void B_adc_pds_y(void)
{
  StackRelIndIndexY();
  _adc_b();
  
  IP++;
  CPUTicks += 7;
}

// Word size opcodes ////////////////////////////////////////////////
void W_adc_i(void)
{
  Immediate();
  _adc_w();
  
  IP += 2;
  CPUTicks += 2;
}

void W_adc_d(void)
{
  Direct();
  _adc_w();
  
  IP++;
  CPUTicks += 3;
}

void W_adc_dx(void)
{
  DirIndexX();
  _adc_w();
  
  IP++;
  CPUTicks += 4;
}

void W_adc_pd(void)
{
  DirectInd();
  _adc_w();
  
  IP++;
  CPUTicks += 5;
}

void W_adc_pdx(void)
{
  DirIndexInd();
  _adc_w();
  
  IP++;
  CPUTicks += 6;
}

void W_adc_pd_y(void)
{
  IndirectY();
  _adc_w();
  
  IP++;
  CPUTicks += 5;
}

void W_adc_bd(void)
{
  DirectIndL();
  _adc_w();
  
  IP++;
  CPUTicks += 6;
}

void W_adc_a(void)
{
  Absolute();
  _adc_w();
  
  IP += 2;
  CPUTicks += 4;
}

void W_adc_ax(void)
{
  AbsoluteX();
  _adc_w();
  
  IP += 2;
  CPUTicks += 4;
}

void W_adc_ay(void)
{
  AbsoluteY();
  _adc_w();
  
  IP += 2;
  CPUTicks += 4;
}

void W_adc_al(void)
{
  AbsoluteLong();
  _adc_w();
  
  IP ++;
  CPUTicks += 5;
}

void W_adc_alx(void)
{
  AbsoluteLongX();
  _adc_w();
  
  IP++;
  CPUTicks += 5;
}

void W_adc_ds(void)
{
  StackRel();
  _adc_w();
  
  IP++;
  CPUTicks += 4;
}

void W_adc_pds_y(void)
{
  StackRelIndIndexY();
  _adc_w();
  
  IP++;
  CPUTicks += 7;
}

