//////////////////////////////////////////////////////////////////////
// OpDefine.cpp: Several opcode inline fxn's to ease the creating
//               of the opcodes and make optimizing easier
//
// 7-15-97 Mr. Grim
//   Started.. this will be the FINAL opcodes file after several
//   tries to make a fast easy to maintain one..
//
// 7-16-97 Mr. Grim
//   Finished Addressing modes.. I'm afraid there are still some 
//   errors...
//////////////////////////////////////////////////////////////////////

#include "OpDefine.h"
#include "SNES.h"

// SNES Memory Routines //////////////////////////////////////////////
void *SnesMap(unsigned long Seg, unsigned short Ofs)
{
  void *final_ptr;

  Seg &= 0x7F0000;

  if (Seg <= 0x3F0000)
  {
    if (Ofs <= 0x1FFF)
    {
      // SNES RAM
      final_ptr = SnesRam + Ofs;
      return final_ptr;
    }
    else if (Ofs <= 0x41FF)
    {
      // SNES Register
      Ofs -= 0x2100;
      final_ptr = SnesReg + Ofs;
      return final_ptr;
    }
    else
    {
      // SNES ROM
      final_ptr = SnesRom + (Seg >> 1) + (Ofs & 0x7FFF);
      return final_ptr;
    }
  }
  else if (Seg = 0x700000)
  {
    // SNES S-RAM
    final_ptr = SnesSram + Ofs;
    return final_ptr;
  }
  else if (Seg >= 0x7E0000)
  {
    // SNES RAM
    final_ptr = SnesRam + (Seg - 0x7E0000) + Ofs;
    return final_ptr;
  }

  return NULL;
}

void *SnesMapLo(unsigned short Ofs)
{
  void *final_ptr;

  if (Ofs <= 0x1FFF)
  {
    // SNES RAM
    final_ptr = SnesRam + Ofs;
    return final_ptr;
  }
  else if (Ofs <= 0x41FF)
  {
    // SNES Register
    Ofs -= 0x2100;
    final_ptr = SnesReg + Ofs;
    return final_ptr;
  }
  else
  {
    // SNES ROM
    final_ptr = SnesRom + (Ofs & 0x7FFF);
    return final_ptr;
  }

  return NULL;
}

Word SnesGetWord(void *ptr)
{
  Byte LoByte, HiByte;

  LoByte = (Byte)*ptr;
  HiByte = (Byte)*(ptr + 1);

  return ((Word)HiByte << 8) + (Word)LoByte;
}

Byte SnesGetByte(void *ptr)
{ 
  return (Byte)*ptr;
}


// SNES Addressing Modes ////////////////////////////////////////////
// i
void Immediate(void)
{
  IP++;
  AddrPtr = SnesRom + IP;
}

// a
void Absolute(void)
{
  IP++;
  TempWord = SnesGetWord(SnesRom + IP);
  
  AddrPtr = SnesMap(DB, TempWord);
}

// al
void AbsoluteLong(void)
{
  IP++;
  TempWord = SnesGetWord(SnesRom + IP);

  IP += 2;
  TempByte = SnesGetByte(SnesRom + IP);

  AddrPtr = SnesMap((unsigned long)TempByte << 16, TempWord);
}

// d
void Direct(void)
{
  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  AddrPtr = SnesMapLo(D + (signed short)TempByte);
}

// (d), y
void IndirectY(void)
{
  unsigned long mem = 0;

  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  mem = D + (signed short)TempByte;
  mem += DB;
  mem += (signed long)Y.x.y;

  AddrPtr = SnesMap(mem & 0xFF0000, (unsigned short)(mem & 0x00FFFF));
}

// [d], y
void DirIndIndexL(void)
{
  unsigned long mem = 0;

  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  mem = D + (signed short)TempByte;
  mem += (signed long)Y.x.y;

  AddrPtr = SnesMap(mem & 0xFF0000, (unsigned short)(mem & 0x00FFFF));
}


// (d, x)
void DirIndexInd(void)
{
  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  AddrPtr = SnesMap(DB, D+(signed short)TempByte+(signed short)X.x.x);
}

// d, x
void DirIndexX(void)   
{
  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  AddrPtr = SnesMapLo(D+(signed short)TempByte+(signed short)X.x.x);
}

// d, y
void DirIndexY(void)
{
  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  AddrPtr = SnesMapLo(D+(signed short)TempByte+(signed short)Y.x.y);
}
 
// a, x
void AbsoluteX(void)
{
  IP++;
  TempWord = SnesGetWord(SnesRom + IP);

  AddrPtr = SnesMap(DB, TempWord+(signed short)X.x.x);
}

// a, y
void AbsoluteY(void)
{
  IP++;
  TempWord = SnesGetWord(SnesRom + IP);

  AddrPtr = SnesMap(DB, TempWord+(signed short)Y.x.y);
}

// al, x
void AbsoluteLongX(void)
{
  unsigned long mem = 0;

  IP++;
  TempWord = SnesGetWord(SnesRom + IP);
  IP += 2;
  TempByte = SnesGetByte(SnesRom + IP);

  mem = ((unsigned long)TempByte << 16) + TempWord;
  mem += (signed short)X.x.x;

  AddrPtr = SnesMap(mem & 0xFF0000, (unsigned short)(mem & 0x00FFFF));
}

// (a)
void AbsoluteInd(void)
{
  IP++;
  TempWord = SnesGetWord(SnesRom + IP);

  AddrPtr = SnesMapLo(TempWord);
}

// (d)
void DirectInd(void)
{
  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  AddrPtr = SnesMap(DB, D+(signed short)TempByte);
}

// [d]
void DirectIndL(void)
{
  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  AddrPtr = SnesMapLo(D+(signed short)TempByte);
}

// (a, x)
void AbsoluteIndexInd(void)
{
  IP++;
  TempWord = SnesGetWord(SnesRom + IP);

  AddrPtr = SnesMapLo(TempWord+(signed short)X.x.x);
}

// d, s
void StackRel(void)
{
  IP++;
  TempByte = SnesGetByte(SnesRom + IP);
 
  AddrPtr = SnesMapLo(S+(signed short)TempByte);
}

// (d, s), y
void StackRelIndIndex(void)
{
  unsigned long mem = 0;

  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  mem = S + (signed short)TempByte;
  mem += DB;
  mem += (signed long)Y.x.y;

  AddrPtr = SnesMap(mem & 0xFF0000, (unsigned short)(mem & 0x00FFFF));
}
