//////////////////////////////////////////////////////////////////////
// OpDefine.cpp: Several opcode inline fxn's to ease the creating
//               of the opcodes and make optimizing easier
//
// 7-15-97 Mr. Grim
//   Started.. this will be the FINAL opcodes file after several
//   tries to make a fast easy to maintain one..
//
// 7-16-97 Mr. Grim
//   Finished Addressing modes.. I'm afraid there are still some 
//   errors...
//
// 7-17-97 Mr. Grim
//   Fixed Errors.. Did flags and adc functions
//////////////////////////////////////////////////////////////////////

#include <dos.h>      // For NULL
#include "OpDefine.h"
#include "SNES.h"

// SNES Memory Routines //////////////////////////////////////////////
char *SnesMap(unsigned long Seg, unsigned short Ofs)
{
  char *final_ptr;

  Seg &= 0x7F0000;

  if (Seg <= 0x3F0000)
  {
    if (Ofs <= 0x1FFF)
    {
      // SNES RAM
      final_ptr = (void *)(SnesRam + Ofs);
      return final_ptr;
    }
    else if (Ofs <= 0x41FF)
    {
      // SNES Register
      Ofs -= 0x2100;
      final_ptr = (void *)(SnesReg + Ofs);
      return final_ptr;
    }
    else
    {
      // SNES ROM
      final_ptr = (void *)(SnesRom + (Seg >> 1) + (Ofs & 0x7FFF));
      return final_ptr;
    }
  }
  else if (Seg = 0x700000)
  {
    // SNES S-RAM
    final_ptr = (void *)(SnesSram + Ofs);
    return final_ptr;
  }
  else if (Seg >= 0x7E0000)
  {
    // SNES RAM
    final_ptr = (void *)(SnesRam + (Seg - 0x7E0000) + Ofs);
    return final_ptr;
  }

  return NULL;
}

char *SnesMapLo(unsigned short Ofs)
{
  char *final_ptr;

  if (Ofs <= 0x1FFF)
  {
    // SNES RAM
    final_ptr = (void *)(SnesRam + Ofs);
    return final_ptr;
  }
  else if (Ofs <= 0x41FF)
  {
    // SNES Register
    Ofs -= 0x2100;
    final_ptr = (void *)(SnesReg + Ofs);
    return final_ptr;
  }
  else
  {
    // SNES ROM
    final_ptr = (void *)(SnesRom + (Ofs & 0x7FFF));
    return final_ptr;
  }

  return NULL;
}

Word SnesGetWord(char *ptr)
{
  Byte LoByte, HiByte;

  LoByte = (Byte)*(Byte *)ptr;
  HiByte = (Byte)*(Byte *)(ptr + 1);

  return ((Word)HiByte << 8) + (Word)LoByte;
}

Byte SnesGetByte(char *ptr)
{ 
  return (Byte)*(Byte *)ptr;
}


// SNES Addressing Modes ////////////////////////////////////////////
// i
void Immediate(void)
{
  IP++;
  AddrPtr = SnesRom + IP;
}

// a
void Absolute(void)
{
  IP++;
  TempWord = SnesGetWord(SnesRom + IP);
  
  AddrPtr = SnesMap(DB, TempWord);
}

// al
void AbsoluteLong(void)
{
  IP++;
  TempWord = SnesGetWord(SnesRom + IP);

  IP += 2;
  TempByte = SnesGetByte(SnesRom + IP);

  AddrPtr = SnesMap((unsigned long)TempByte << 16, TempWord);
}

// d
void Direct(void)
{
  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  AddrPtr = SnesMapLo(D + TempByte);
}

// (d), y
void IndirectY(void)
{
  unsigned long mem = 0;

  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  mem = D + TempByte;
  mem += DB;
  mem += Y.x.y;

  AddrPtr = SnesMap(mem & 0xFF0000, (unsigned short)(mem & 0x00FFFF));
}

// [d], y
void DirIndIndexL(void)
{
  unsigned long mem = 0;

  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  mem = D + TempByte;
  mem += Y.x.y;

  AddrPtr = SnesMap(mem & 0xFF0000, (unsigned short)(mem & 0x00FFFF));
}


// (d, x)
void DirIndexInd(void)
{
  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  AddrPtr = SnesMap(DB, D+TempByte+X.x.x);
}

// d, x
void DirIndexX(void)   
{
  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  AddrPtr = SnesMapLo(D+TempByte+X.x.x);
}

// d, y
void DirIndexY(void)
{
  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  AddrPtr = SnesMapLo(D+TempByte+Y.x.y);
}
 
// a, x
void AbsoluteX(void)
{
  IP++;
  TempWord = SnesGetWord(SnesRom + IP);

  AddrPtr = SnesMap(DB, TempWord+X.x.x);
}

// a, y
void AbsoluteY(void)
{
  IP++;
  TempWord = SnesGetWord(SnesRom + IP);

  AddrPtr = SnesMap(DB, TempWord+Y.x.y);
}

// al, x
void AbsoluteLongX(void)
{
  unsigned long mem = 0;

  IP++;
  TempWord = SnesGetWord(SnesRom + IP);
  IP += 2;
  TempByte = SnesGetByte(SnesRom + IP);

  mem = ((unsigned long)TempByte << 16) + TempWord;
  mem += X.x.x;

  AddrPtr = SnesMap(mem & 0xFF0000, (unsigned short)(mem & 0x00FFFF));
}

// (a)
void AbsoluteInd(void)
{
  IP++;
  TempWord = SnesGetWord(SnesRom + IP);

  AddrPtr = SnesMapLo(TempWord);
}

// (d)
void DirectInd(void)
{
  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  AddrPtr = SnesMap(DB, D+TempByte);
}

// [d]
void DirectIndL(void)
{
  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  AddrPtr = SnesMapLo(D+TempByte);
}

// (a, x)
void AbsoluteIndexInd(void)
{
  IP++;
  TempWord = SnesGetWord(SnesRom + IP);

  AddrPtr = SnesMapLo(TempWord+X.x.x);
}

// d, s
void StackRel(void)
{
  IP++;
  TempByte = SnesGetByte(SnesRom + IP);
 
  AddrPtr = SnesMapLo(S+TempByte);
}

// (d, s), y
void StackRelIndIndex(void)
{
  unsigned long mem = 0;

  IP++;
  TempByte = SnesGetByte(SnesRom + IP);

  mem = S + TempByte;
  mem += DB;
  mem += Y.x.y;

  AddrPtr = SnesMap(mem & 0xFF0000, (unsigned short)(mem & 0x00FFFF));
}

// Falgs ////////////////////////////////////////////////////////////
void GetFlags_cznv_B(Byte val1, Byte val2, Word val3)
{
  if(val3>0xFF) P|=0x01; else P&=0xFE;
  if(val3==0x00) P|=0x02; else P&=0xFD;
  if(val3&0x80) P|=0x80; else P&=0x7F;
  if((val1&0x80)==(val2&0x80))
  {
    if((val1&0x80)!=(val3&0x80)) P|=0x40; else P&=0xBF;
  }
  else 
  {
    P&=0xBF;
  }
} 

void GetFlags_znv_B(Byte val1, Byte val2, Word val3)
{
  if(val3==0x00) P|=0x02; else P&=0xFD;
  if(val3&0x80) P|=0x80; else P&=0x7F;
  if((val1&0x80)==(val2&0x80))
  {
    if((val1&0x80)!=(val3&0x80)) P|=0x40; else P&=0xBF;
  }
  else 
  {
    P&=0xBF;
  }
} 

void GetFlags_czn_B(Word val1)
{
  if(val1>0xFF) P|=0x01; else P&=0xFE;
  if(val1==0x00) P|=0x02; else P&=0xFD;
  if(val1&0x80) P|=0x80; else P&=0x7F;
} 

void GetFlags_cz_B(Word val1)
{
  if(val1>0xFF) P|=0x01; else P&=0xFE;
  if(val1==0x00) P|=0x02; else P&=0xFD;
} 

void GetFlags_zn_B(Word val1)
{
  if(val1==0x00) P|=0x02; else P&=0xFD;
  if(val1&0x80) P|=0x80; else P&=0x7F;
} 

void GetFlags_z_B(Word val1)
{
  if(val1==0x00) P|=0x02; else P&=0xFD;
} 

void GetFlags_cznv_W(Word val1, Word val2, unsigned long val3)
{
  if(val3>0xFFFF) P|=0x01; else P&=0xFE;
  if(val3==0x0000) P|=0x02; else P&=0xFD;
  if(val3&0x8000) P|=0x80; else P&=0x7F;
  if((val1&0x8000)==(val2&0x8000))
  {
    if((val1&0x8000)!=(val3&0x8000)) P|=0x40; else P&=0xBF;
  }
  else 
  {
    P&=0xBF;
  }
} 

void GetFlags_znv_W(Word val1, Word val2, unsigned long val3)
{
  if(val3==0x0000) P|=0x02; else P&=0xFD;
  if(val3&0x8000) P|=0x80; else P&=0x7F;
  if((val1&0x8000)==(val2&0x8000))
  {
    if((val1&0x8000)!=(val3&0x8000)) P|=0x40; else P&=0xBF;
  }
  else 
  {
    P&=0xBF;
  }
} 

void GetFlags_czn_W(unsigned long val1)
{
  if(val1>0xFFFF) P|=0x01; else P&=0xFE;
  if(val1==0x0000) P|=0x02; else P&=0xFD;
  if(val1&0x8000) P|=0x80; else P&=0x7F;
} 

void GetFlags_cz_W(unsigned long val1)
{
  if(val1>0xFFFF) P|=0x01; else P&=0xFE;
  if(val1==0x0000) P|=0x02; else P&=0xFD;
} 

void GetFlags_zn_W(unsigned long val1)
{
  if(val1==0x0000) P|=0x02; else P&=0xFD;
  if(val1&0x8000) P|=0x80; else P&=0x7F;
} 

void GetFlags_z_W(unsigned long val1)
{
  if(val1==0x0000) P|=0x02; else P&=0xFD;
} 

// Opcodes //////////////////////////////////////////////////////////
void _adc_b(void)
{
  Word result;
  Byte add_to;

  add_to = SnesGetByte(AddrPtr);
  result = A.h.al + add_to + (P&0x01);

  GetFlags_cznv_B(A.h.al, add_to, result);

  A.h.al = (Byte)result;
}

void _adc_w(void)
{
  unsigned long result;
  Word add_to;

  add_to = SnesGetWord(AddrPtr);
  result = A.x.a + add_to + (P&0x01);

  GetFlags_cznv_W(A.x.ax, add_to, result);

  A.x.ax = (Word)result;
}

void _and_b(void)
{
  Word result;
  Byte and_to;

  and_to = SnesGetByte(AddrPtr);
  result = A.h.al & and_to;

  GetFlags_zn_B(result);

  A.h.al = (Byte)result;
}

void _and_w(void)
{
  unsigned long result;
  Word and_to;

  and_to = SnesGetWord(AddrPtr);
  result = A.x.a & and_to;

  GetFlags_zn_W(result);

  A.x.ax = (Word)result;
}
