/***************************************************************************
FILE: 65c816.cpp
PURPOSE: This is the main CPU emulation engine.
Copyright 1997 Jeff Slutter
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <dos.h>
#include <malloc.h>
#include <memory.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <time.h>
#include "SNESstructures.h"
#include "SNESmemory.h"
#include "65c816.h"
#include "SNESregisters.h"

#include "65c816opcodes\opcodes.h"

void wait(long int d);

void (*Opcode[258])();        //I know that there are only 255 opcodes, but less than this, and it overwrites CartROM...

void InitEngine()
{
  int i,j;

  for (i=0;i<=255;i++) Opcode[i]=debug;
	Opcode[0x00]=nop;
	Opcode[0x01]=ora_d_ix_in;	//0x01 ORA (d,x)
	Opcode[0x02]=nop;
	Opcode[0x03]=ora_s_r;		//0x03 ORA d,s
	Opcode[0x04]=tsb_d;			//0x04 TSB d
	Opcode[0x05]=ora_d;			//0x05 ORA d
	Opcode[0x06]=asl_d;			//0x06 ASL d
	Opcode[0x07]=nop;
	Opcode[0x08]=php;			//0x08 PHP
	Opcode[0x09]=ora_im;		//0x09 ORA #
	Opcode[0x0A]=asl_accum;		//0x0A ASL A
	Opcode[0x0B]=phd;			//0x0B PHD
	Opcode[0x0C]=tsb_a;			//0x0C TSB a
	Opcode[0x0D]=ora_a;			//0x0D ORA a
	Opcode[0x0E]=asl_a;			//0x0E ASL a
	Opcode[0x0F]=ora_al;		//0x0F ORA al

	Opcode[0x10]=bpl;			//0x10 BPL
	Opcode[0x11]=ora_d_in_ix;	//0x11 ORA (d),y
	Opcode[0x12]=ora_d_in;		//0x12 ORA (d)
	Opcode[0x13]=ora_s_r_in_ix;	//0x13 ORA (d,s),y
	Opcode[0x14]=trb_d;			//0x14 TRB d
	Opcode[0x15]=ora_d_ix_x;	//0x15 ORA d,x
	Opcode[0x16]=asl_d_ix_x;	//0x16 ASL d,x
	Opcode[0x17]=ora_d_in_ix_l;	//0x17 ORA [d],y
	Opcode[0x18]=clc;			//0x18 CLC
	Opcode[0x19]=ora_a_ix_y;	//0x19 ORA a,y
	Opcode[0x1A]=inc_accum;		//0x1A INC A
	Opcode[0x1B]=tcs;			//0x1B TCS
	Opcode[0x1C]=trb_a;			//0x1C TRB a
	Opcode[0x1D]=ora_a_ix_x;	//0x1D ORA a,x
	Opcode[0x1E]=asl_a_ix_x;	//0x1E ASL a,x
	Opcode[0x1F]=ora_a_l_ix_x;	//0x1F ORA al,x
	
	Opcode[0x20]=jsr_a;
	Opcode[0x21]=and_d_ix_in;	//0x21 AND (d,x)
	Opcode[0x22]=jsl_al;
	Opcode[0x23]=and_s_r;		//0x23 AND d,s
	Opcode[0x24]=bit_d;			//0x24 BIT d
	Opcode[0x25]=and_d;			//0x25 AND d
	Opcode[0x26]=rol_d;			//0x26 ROL d
	Opcode[0x27]=and_d_in_l;	//0x27 AND [d]
	Opcode[0x28]=plp;			//0x28 PLP
	Opcode[0x29]=and_im;		//0x29 AND #
	Opcode[0x2A]=rol_accum;		//0x2A ROL A
	Opcode[0x2B]=pld;			//0x2B PLD
	Opcode[0x2C]=bit_a;			//0x2C BIT a
	Opcode[0x2D]=and_a;			//0x2D AND a
	Opcode[0x2E]=rol_a;			//0x2E ROL a
	Opcode[0x2F]=and_al;		//0x2F AND al

	Opcode[0x30]=bmi;			//0x30 BMI
	Opcode[0x31]=and_d_in_ix;	//0x31 AND (d),y
	Opcode[0x32]=and_d_in;		//0x32 AND (d)
	Opcode[0x33]=and_s_r_in_ix;	//0x33 AND (d,s),y
	Opcode[0x34]=bit_d_ix_x;	//0x34 BIT d,x
	Opcode[0x35]=and_d_ix_x;	//0x35 AND d,x
	Opcode[0x36]=rol_d_ix_x;	//0x36 ROL d,x
	Opcode[0x37]=nop;
	Opcode[0x38]=sec;			//0x38 SEC
	Opcode[0x39]=and_a_ix_y;	//0x39 AND a,y
	Opcode[0x3A]=dec_accum;		//0x3A DEC A
	Opcode[0x3B]=tsc;			//0x3B TSC
	Opcode[0x3C]=bit_a_ix_x;	//0x3C BIT a,x
	Opcode[0x3D]=and_a_ix_x;	//0x3D AND a,x
	Opcode[0x3E]=rol_a_ix_x;	//0x3E ROL a,x
	Opcode[0x3F]=and_a_l_ix_x;	//0x3F AND al,x

	Opcode[0x40]=rti;
	Opcode[0x41]=eor_d_ix_in;	//0x41 EOR (d,x)
	Opcode[0x42]=nop;
	Opcode[0x43]=eor_s_r;		//0x43 EOR d,s
	Opcode[0x44]=nop;
	Opcode[0x45]=eor_d;			//0x45 EOR d
	Opcode[0x46]=lsr_d;			//0x46 LSR d
	Opcode[0x47]=eor_d_in_l;	//0x47 EOR [d]
	Opcode[0x48]=pha;			//0x48 PHA
	Opcode[0x49]=eor_im;		//0x49 EOR #
	Opcode[0x4A]=lsr_accum;		//0x4A LSR A
	Opcode[0x4B]=phk;			//0x4B PHK
	Opcode[0x4C]=nop;
	Opcode[0x4D]=eor_a;			//0x4D EOR a
	Opcode[0x4E]=lsr_a;			//0x4E LSR a
	Opcode[0x4F]=eor_al;		//0x4F EOR al
	
	Opcode[0x50]=bvc;			//0x50 BVC
	Opcode[0x51]=eor_d_in_ix;	//0x51 EOR (d),y
	Opcode[0x52]=eor_d_in;		//0x52 EOR (d)
	Opcode[0x53]=eor_s_r_in_ix;	//0x53 EOR (d,s),y
	Opcode[0x54]=nop;
	Opcode[0x55]=eor_d_ix_x;	//0x55 EOR d,x
	Opcode[0x56]=lsr_d_ix_x;	//0x56 LSR d,x
	Opcode[0x57]=nop;
	Opcode[0x58]=cli;			//0x58 CLI
	Opcode[0x59]=eor_a_ix_y;	//0x59 EOR a,y
	Opcode[0x5A]=phy;			//0x5A PHY
	Opcode[0x5B]=tcd;			//0x5B TCD
	Opcode[0x5C]=jmp_al;
	Opcode[0x5D]=eor_a_ix_x;	//0x5D EOR a,x
	Opcode[0x5E]=lsr_a_ix_x;	//0x5E LSR a,x
	Opcode[0x5F]=eor_a_l_ix_x;	//0x5F EOR al,x
	
	Opcode[0x60]=rts;
	Opcode[0x61]=adc_d_ix_in;	//0x61 ADC (d,x)
	Opcode[0x62]=per;			//0x62 PER
	Opcode[0x63]=adc_s_r;		//0x63 ADC d,s
	Opcode[0x64]=stz_d;			//0x64 STZ d
	Opcode[0x65]=adc_d;			//0x65 ADC d
	Opcode[0x66]=ror_d;			//0x66 ROR d
	Opcode[0x67]=adc_d_in_l;	//0x67 ADC [d]
	Opcode[0x68]=nop;
	Opcode[0x69]=adc_im;		//0x69 ADC #
	Opcode[0x6A]=ror_accum;		//0x6A ROR A
	Opcode[0x6B]=pla;			//0x6B PLA
	Opcode[0x6C]=nop;
	Opcode[0x6D]=adc_a;			//0x6D ADC a
	Opcode[0x6E]=ror_a;			//0x6E ROR a
	Opcode[0x6F]=adc_al;		//0x6F ADC al

	Opcode[0x70]=bvs;			//0x70 BVS
	Opcode[0x71]=adc_d_in_ix;	//0x71 ADC (d),y
	Opcode[0x72]=adc_d_in;		//0x72 ADC (d)
	Opcode[0x73]=adc_s_r_in_ix;	//0x73 ADC (d,s),y
	Opcode[0x74]=stz_d_ix_y;	//0x74 STZ d,x
	Opcode[0x75]=adc_d_ix_x;	//0x75 ADC d,x
	Opcode[0x76]=ror_d_ix_x;	//0x76 ROR d,x
	Opcode[0x77]=nop;
	Opcode[0x78]=sei;			//0x78 SEI
	Opcode[0x79]=adc_a_ix_y;	//0x79 ADC a,y
	Opcode[0x7A]=ply;			//0x7A PLY
	Opcode[0x7B]=tdc;			//0x7B TDC
	Opcode[0x7C]=nop;
	Opcode[0x7D]=adc_a_ix_x;	//0x7D ADC a,x
	Opcode[0x7E]=ror_a_ix_x;	//0x7E ROR a,x
	Opcode[0x7F]=adc_a_l_ix_x;	//0x7F ADC al,x

	Opcode[0x80]=bra;			//0x80 BRA
	Opcode[0x81]=sta_d_ix_in;	//0x81 STA (d,x)
	Opcode[0x82]=nop;
	Opcode[0x83]=sta_s_r;		//0x83 STA d,s
	Opcode[0x84]=sty_d;			//0x84 STY d
	Opcode[0x85]=sta_d;			//0x85 STA d
	Opcode[0x86]=stx_d;			//0x86 STX d
	Opcode[0x87]=nop;
	Opcode[0x88]=dey;			//0x88 DEY
	Opcode[0x89]=bit_im;		//0x89 BIT #
	Opcode[0x8A]=txa;			//0x8A TXA
	Opcode[0x8B]=phb;			//0x8B PHB
	Opcode[0x8C]=sty_a;			//0x8C STY a
	Opcode[0x8D]=sta_a;			//0x8D STA a
	Opcode[0x8E]=stx_a;			//0x8E STX a
	Opcode[0x8F]=sta_al;		//0x8F STA al
	
	Opcode[0x90]=bcc;			//0x90 BCC
	Opcode[0x91]=sta_d_in_ix;	//0x91 STA (d),y
	Opcode[0x92]=sta_d_in;		//0x92 STA (d)
	Opcode[0x93]=sta_s_r_in_ix;	//0x93 STA (d,s),y
	Opcode[0x94]=sty_d_ix_y;	//0x94 STY d,x
	Opcode[0x95]=sta_d_ix_x;	//0x95 STA d,x
	Opcode[0x96]=stx_d_ix_y;	//0x96 STX d,y
	Opcode[0x97]=sta_d_in_ix_l;	//0x97 STA [d],y
	Opcode[0x98]=tya;			//0x98 TYA
	Opcode[0x99]=sta_a_ix_y;	//0x99 STA a,y
	Opcode[0x9A]=txs;			//0x9A TXS
	Opcode[0x9B]=txy;			//0x9B TXY
	Opcode[0x9C]=stz_a;			//0x9C STZ a
	Opcode[0x9D]=sta_a_ix_x;	//0x9D STA a,x
	Opcode[0x9E]=nop;
	Opcode[0x9F]=sta_a_l_ix_x;	//0x9F STA al,x
	
	Opcode[0xA0]=ldy_im;		//0xA0 LDY #
	Opcode[0xA1]=lda_d_ix_in;	//0xA1 LDA (d,x)
	Opcode[0xA2]=ldx_im;		//0xA2 LDX #
	Opcode[0xA3]=lda_s_r;		//0xA3 LDA d,s
	Opcode[0xA4]=ldy_d;			//0xA4 LDY d
	Opcode[0xA5]=lda_d;			//0xA5 LDA d
	Opcode[0xA6]=ldx_d;			//0xA6 LDX d
	Opcode[0xA7]=nop;
	Opcode[0xA8]=tay;			//0xA8 TAY
	Opcode[0xA9]=lda_im;		//0xA9 LDA #
	Opcode[0xAA]=tax;			//0xAA TAX
	Opcode[0xAB]=plb;			//0xAB PLB
	Opcode[0xAC]=ldy_a;			//0xAC LDY a
	Opcode[0xAD]=lda_a;			//0xAD LDA a
	Opcode[0xAE]=ldx_a;			//0xAE LDX a
	Opcode[0xAF]=lda_al;		//0xAF LDA al
	
	
	Opcode[0xB0]=bcs;			//0xB0 BCS
	Opcode[0xB1]=lda_d_in_ix;	//0xB1 LDA (d),y
	Opcode[0xB2]=lda_d_in;		//0xB2 LDA (d)
	Opcode[0xB3]=lda_s_r_in_ix;	//0xB3 LDA (d,s),y
	Opcode[0xB4]=ldy_d_ix_x;	//0xB4 LDY d,x
	Opcode[0xB5]=lda_d_ix_x;	//0xB5 LDA d,x
	Opcode[0xB6]=ldx_d_ix_y;	//0xB6 LDX d,y
	Opcode[0xB7]=lda_d_in_ix_l;	//0xB7 LDA [d],y
	Opcode[0xB8]=clv;			//0xB8 CLV
	Opcode[0xB9]=lda_a_ix_y;	//0xB9 LDA a,y
	Opcode[0xBA]=tsx;			//0xBA TSX
	Opcode[0xBB]=tyx;			//0xBB TYX
	Opcode[0xBC]=ldy_a_ix_x;	//0xBC LDY a,x
	Opcode[0xBD]=lda_a_ix_x;	//0xBD LDA a,x
	Opcode[0xBE]=ldx_a_ix_y;	//0xBE LDX a,y
	Opcode[0xBF]=lda_a_l_ix_x;	//0xBF LDA al,x
		
	Opcode[0xC0]=nop;
	Opcode[0xC1]=cmp_d_ix_in;	//0xC1 CMP (d,x)
	Opcode[0xC2]=rep;
	Opcode[0xC3]=cmp_s_r;		//0xC3 CMP d,s
	Opcode[0xC4]=nop;
	Opcode[0xC5]=cmp_d;			//0xC5 CMP d
	Opcode[0xC6]=dec_d;			//0xC6 DEC d
	Opcode[0xC7]=cmp_d_in_l;	//0xC7 CMP [d]
	Opcode[0xC8]=iny;			//0xC8 INY
	Opcode[0xC9]=cmp_im;		//0xC9 CMP #
	Opcode[0xCA]=dex;			//0xCA DEX
	Opcode[0xCB]=nop;
	Opcode[0xCC]=nop;
	Opcode[0xCD]=cmp_a;			//0xCD CMP a
	Opcode[0xCE]=dec_a;			//0xCE DEC a
	Opcode[0xCF]=cmp_al;		//0xCF CMP al

	Opcode[0xD0]=bne;			//0xD0 BNE
	Opcode[0xD1]=cmp_d_in_ix;	//0xD1 CMP (d),y
	Opcode[0xD2]=cmp_d_in;		//0xD2 CMP (d)
	Opcode[0xD3]=cmp_s_r_in_ix;	//0xD3 CMP (d,s),y
	Opcode[0xD4]=pei;			//0xD4 PEI
	Opcode[0xD5]=cmp_d_ix_x;	//0xD5 CMP d,x
	Opcode[0xD6]=dec_d_ix_x;	//0xD6 DEC d,x
	Opcode[0xD7]=nop;
	Opcode[0xD8]=cld;			//0xD8 CLD
	Opcode[0xD9]=cmp_a_ix_y;	//0xD9 CMP a,y
	Opcode[0xDA]=phx;			//0xDA PHX
	Opcode[0xDB]=stp;
	Opcode[0xDC]=nop;
	Opcode[0xDD]=cmp_a_ix_x;	//0xDD CMP a,x
	Opcode[0xDE]=dec_a_ix_x;	//0xDE DEC a,x
	Opcode[0xDF]=cmp_a_l_ix_x;	//0xDF CMP al,x
	
	Opcode[0xE0]=cpx_im;		//0xE0 CPX #
	Opcode[0xE1]=sbc_d_ix_in;	//0xE1 SBC (d,x)
	Opcode[0xE2]=sep;
	Opcode[0xE3]=sbc_s_r;		//0xE3 SBC d,s
	Opcode[0xE4]=cpx_d;			//0xE4 CPX d
	Opcode[0xE5]=sbc_d;			//0xE5 SBC d
	Opcode[0xE6]=inc_d;			//0xE6 INC d
	Opcode[0xE7]=nop;
	Opcode[0xE8]=inx;			//0xE8 INX
	Opcode[0xE9]=sbc_im;		//0xE9 SBC #
	Opcode[0xEA]=nop;			//0xEA NOP
	Opcode[0xEB]=xba;
	Opcode[0xEC]=cpx_a;			//0xEC CPX a
	Opcode[0xED]=sbc_a;			//0xED SBC a
	Opcode[0xEE]=inc_a;			//0xEE INC a
	Opcode[0xEF]=sbc_al;		//0xEF SBC al
		
	Opcode[0xF0]=beq;			//0xF0 BEQ
	Opcode[0xF1]=sbc_d_in_ix;	//0xF1 SBC (d),y
	Opcode[0xF2]=sbc_d_in;		//0xF2 SBC (d)
	Opcode[0xF3]=sbc_s_r_in_ix;	//0xF3 SBC (d,s),y
	Opcode[0xF4]=pea;			//0xF4 PEA
	Opcode[0xF5]=sbc_d_ix_x;	//0xF5 SBC d,x
	Opcode[0xF6]=inc_d_ix_x;	//0xF6 INC d,x
	Opcode[0xF7]=sbc_d_in_ix_l;	//0xF7 SBC [d],y
	Opcode[0xF8]=sed;			//0xF8 SED			
	Opcode[0xF9]=sbc_a_ix_y;	//0xF9 SBC a,y
	Opcode[0xFA]=plx;			//0xFA PLX
	Opcode[0xFB]=xce;			//0xFB XCE
	Opcode[0xFC]=nop;
	Opcode[0xFD]=sbc_a_ix_x;	//0xFD SBC a,x
	Opcode[0xFE]=inc_a_ix_x;	//0xFE INC a,x
	Opcode[0xFF]=sbc_a_l_ix_x;	//0xFF SBC al,x
	


  P.M=1;
  P.X=1;
  P.D=0;
  P.I=0;
  P.C=0;
  P.E=1;
  D=X=Y=A=0;
  PB=DB=0;
  S=0x0100;
}

void BeginEmulation ()
{
  unsigned int Reset;
  Test1();
  puts("EMULATION BEGUN!!!");
  puts("Init Screen - Nope");
  Reset=(int)SNESgetword(0xfffc,0);
  if (Reset<0x7fffl)
  {
    printf("File header is corrupted.  Cannot start game in RAM, defaulting to reset at 0x8000");
    Reset=0x8000;
  }
  PC=Reset;
  NMI=SNESgetword(0xfffa,0);
  clock();
  //printf ("%X, %X %X\n",PC,(int)SNESgetbyte(0xfffc,0),(int)SNESgetbyte(0xfffd,0));
}

void Test1()
{
  //int i;

  //for (i=0xFFC0;i<0xFFFF;i++) printf("%x %c ",i,SNESgetbyte(i,0));

  printf("NMI Vector: 0x%X\nReset Vector: 0x%X\n",SNESgetword(0xfffa,0),SNESgetword(0xfffc,0));
}

void wait(long int d)
{
	long int i;
	i=0;
	do
	{
		i++;
		
	}while(i!=d);
}