/***************************************************************************
FILE: adc.cpp
PURPOSE: Add Memory to Accumulator with Carry
Copyright 1997 Jeff Slutter
***************************************************************************/

#include "opcodes.h"

//0x69
// ADC #
// 2 Bytes
// 2 Cycles
void adc_im()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=immediateVb();
		result=(A&0xFF)+B+P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result==0x00) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	else
	{
		Double result;
		Word W;

		W=immediateVw();
		result=(A&0xFFFF)+W+P.C;
		if(result>0xFFFF) P.C=1; else P.C=0; 
		if(result==0x0000) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	t+=2;
}

//0x65
// ADC d
// 2 Bytes
// 3 Cycles
void adc_d()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=directVb();
		result=(A&0xFF)+B+P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result==0x00) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	else
	{
		Double result;
		Word W;

		W=directVw();
		result=(A&0xFFFF)+W+P.C;
		if(result>0xFFFF) P.C=1; else P.C=0; 
		if(result==0x0000) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	t+=3;
}

//0x75
// ADC d,x
// 2 Bytes
// 4 Cycles
void adc_d_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=direct_indexed_xVb();
		result=(A&0xFF)+B+P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result==0x00) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	else
	{
		Double result;
		Word W;

		W=direct_indexed_xVw();
		result=(A&0xFFFF)+W+P.C;
		if(result>0xFFFF) P.C=1; else P.C=0; 
		if(result==0x0000) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	t+=4;
}

//0x72
// ADC (d)
// 2 Bytes
// 5 Cycles
void adc_d_in()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=direct_indirVb();
		result=(A&0xFF)+B+P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result==0x00) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	else
	{
		Double result;
		Word W;

		W=direct_indirVw();
		result=(A&0xFFFF)+W+P.C;
		if(result>0xFFFF) P.C=1; else P.C=0; 
		if(result==0x0000) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	t+=5;
}

//0x61
// ADC (d,x)
// 2 Bytes
// 6 Cycles
void adc_d_ix_in()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=direct_indexed_indirVb();
		result=(A&0xFF)+B+P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result==0x00) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	else
	{
		Double result;
		Word W;

		W=direct_indexed_indirVw();
		result=(A&0xFFFF)+W+P.C;
		if(result>0xFFFF) P.C=1; else P.C=0; 
		if(result==0x0000) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	t+=6;
}

//0x71
// ADC (d),y
// Bytes 2
// Cycles 5
void adc_d_in_ix()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=direct_indir_indexed_yVb();
		result=(A&0xFF)+B+P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result==0x00) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	else
	{
		Double result;
		Word W;

		W=direct_indir_indexed_yVw();
		result=(A&0xFFFF)+W+P.C;
		if(result>0xFFFF) P.C=1; else P.C=0; 
		if(result==0x0000) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	t+=5;
}

//0x67
// ADC [d]
// Bytes 2
// Cycles 6
void adc_d_in_l()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=direct_indir_longVb();
		result=(A&0xFF)+B+P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result==0x00) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	else
	{
		Double result;
		Word W;

		W=direct_indir_longVw();
		result=(A&0xFFFF)+W+P.C;
		if(result>0xFFFF) P.C=1; else P.C=0; 
		if(result==0x0000) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	t+=6;
}

//0x6D
// ADC a
//Bytes 3
//Cycles 4
void adc_a()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=absoluteVb();
		result=(A&0xFF)+B+P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result==0x00) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	else
	{
		Double result;
		Word W;

		W=absoluteVw();
		result=(A&0xFFFF)+W+P.C;
		if(result>0xFFFF) P.C=1; else P.C=0; 
		if(result==0x0000) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	t+=4;
}

//0x7D
//ADC a,x
//Bytes 3
//Cycles 4
void adc_a_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=absolute_XindexedVb();
		result=(A&0xFF)+B+P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result==0x00) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	else
	{
		Double result;
		Word W;

		W=absolute_XindexedVw();
		result=(A&0xFFFF)+W+P.C;
		if(result>0xFFFF) P.C=1; else P.C=0; 
		if(result==0x0000) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	t+=4;
}


//0x79
//ADC a,y
//Bytes 3
//Cycles 4
void adc_a_ix_y()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=absolute_YindexedVb();
		result=(A&0xFF)+B+P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result==0x00) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	else
	{
		Double result;
		Word W;

		W=absolute_YindexedVw();
		result=(A&0xFFFF)+W+P.C;
		if(result>0xFFFF) P.C=1; else P.C=0; 
		if(result==0x0000) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	t+=4;
}

//0x6F
//ADC al
//Bytes 4
//Cycles 5
void adc_al()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=absolute_longVb();
		result=(A&0xFF)+B+P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result==0x00) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	else
	{
		Double result;
		Word W;

		W=absolute_longVw();
		result=(A&0xFFFF)+W+P.C;
		if(result>0xFFFF) P.C=1; else P.C=0; 
		if(result==0x0000) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	t+=5;
}

//0x7F
//ADC al,x
//Bytes 4
//Cycles 5
void adc_a_l_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=absolute_long_indexedVb();
		result=(A&0xFF)+B+P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result==0x00) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	else
	{
		Double result;
		Word W;

		W=absolute_long_indexedVw();
		result=(A&0xFFFF)+W+P.C;
		if(result>0xFFFF) P.C=1; else P.C=0; 
		if(result==0x0000) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	t+=5;
}

//0x63
//ADC d,s
//Bytes 2
//Cycles 4
void adc_s_r()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=stack_relativeVb();
		result=(A&0xFF)+B+P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result==0x00) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	else
	{
		Double result;
		Word W;

		W=stack_relativeVw();
		result=(A&0xFFFF)+W+P.C;
		if(result>0xFFFF) P.C=1; else P.C=0; 
		if(result==0x0000) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	t+=4;
}

//0x73
//ADC (d,s),y
//Bytes 2
//Cycles 7
void adc_s_r_in_ix()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=stack_relative_indir_indexedVb();
		result=(A&0xFF)+B+P.C;
		if(result>0xFF) P.C=1; else P.C=0;
		if(result==0x00) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	else
	{
		Double result;
		Word W;

		W=stack_relative_indir_indexedVw();
		result=(A&0xFFFF)+W+P.C;
		if(result>0xFFFF) P.C=1; else P.C=0; 
		if(result==0x0000) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; else P.V=0;
		}
		else P.V=0;
		A=(Word)result;
	}
	t+=7;
}