/***************************************************************************
FILE: AddressingModes.cpp
PURPOSE: Addressing modes mapping routines.  *SLOW*
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "AddressingModes.h"


Double special()
{
 return 0;
}

/////////////////////////////////////////////Immediate Addressing -> #
Double immediate()
{
 return PC+(PB<<16);
}

Byte immediateVb()
{
 Byte result;
 result=SNESgetbyte(PC,PB);
 PC++;
 return result;
}

Word immediateVw()
{
 Word result;
 result=SNESgetword(PC,PB);
 PC+=2;
 return result;
}

/////////////////////////////////////////////Absolute -> a
Double absolute()
{
 Double result;
 result=SNESgetword(PC,PB)+(PB<<16);
 PC+=2;
 return result;
}

Byte absoluteVb()
{
 Byte result;
 result=SNESgetbyte(SNESgetword(PC,PB)&0xFFFF,PB);
 PC+=2;
 return result;
}

Word absoluteVw()
{
 Word result;
 result=SNESgetword(SNESgetword(PC,PB)&0xFFFF,PB);
 PC+=2;
 return result;
}

/////////////////////////////////////////////Absolute Long -> al
Double absolute_long()
{
 Double result;
 result=SNESgetword(PC,PB)&0xFFFF+(SNESgetbyte(PC+2,PB)<<16);
 PC+=3;
 return result;
}

Byte absolute_longVb()
{
 Byte result;
 result=SNESgetbyte(SNESgetword(PC,PB)&0xFFFF,SNESgetbyte(PC+2,PB));
 PC+=3;
 return result;
}

Word absolute_longVw()
{
 Word result;
 result=SNESgetword(SNESgetword(PC,PB)&0xFFFF,SNESgetbyte(PC+2,PB));
 PC+=3;
 return result;
}

/////////////////////////////////////////////Direct -> d
Double direct()
{
	Double result;
	result=(SNESgetbyte(PC,PB)+D)&0xFFFF;
	PC++;
	return result;
}

Byte directVb()
{
	Byte result;
	result=SNESgetbyte(SNESgetbyte(PC,PB)+D,0);
	PC++;
	return result;
}

Word directVw()
{
	Word result;
	result=SNESgetword(SNESgetbyte(PC,PB)+D,0);
	PC++;
	return result;
}

/////////////////////////////////////////////Accumulator -> A
Word accumulatorV()
{
 return A;
}

/////////////////////////////////////////////Implied -> i
Double implied()
{
 return 0;
}

/////////////////////////////////////////////Direct Indirect Indexed -> (d),y
Double direct_indir_indexed_y()
{
	Double result;
	result=((SNESgetword(SNESgetbyte(PC,PB)+D,0)+Y)&0xFFFF)+(DB<<16);
	PC++;
	return result;
}

Byte direct_indir_indexed_yVb()
{
	Byte result;
	result=SNESgetbyte(((SNESgetword(SNESgetbyte(PC,PB)+D,0)+Y)&0xFFFF),DB);
	PC++;
	return result;
}

Word direct_indir_indexed_yVw()
{
	Word result;
	result=SNESgetword(((SNESgetword(SNESgetbyte(PC,PB)+D,0)+Y)&0xFFFF),DB);
	PC++;
	return result;
}

/////////////////////////////////////////////Direct Indirect Indexed Long -> [d],y
Double dir_indir_indexed_long()
{
 Word tmpaddr;
 tmpaddr=SNESgetbyte(PC,PB)+D;
 PC++;
 return ((SNESgetword(tmpaddr,0)+Y)&0xFFFF)+SNESgetbyte(tmpaddr+2,0)<<16;
}

Byte dir_indir_indexed_longVb()
{
 Word tmpaddr;
 tmpaddr=SNESgetbyte(PC,PB)+D;
 PC++;
 return SNESgetbyte(((SNESgetword(tmpaddr,0)+Y)&0xFFFF),SNESgetbyte(tmpaddr+2,0));
}

Word dir_indir_indexed_longVw()
{
 Word tmpaddr;
 tmpaddr=SNESgetbyte(PC,PB)+D;
 PC++;
 return SNESgetword(((SNESgetword(tmpaddr,0)+Y)&0xFFFF),SNESgetbyte(tmpaddr+2,0));
}

/////////////////////////////////////////////Direct Indexed Indirect -> (d,x)
Double direct_indexed_indir()
{
	Double result;
	result=SNESgetword((D+SNESgetbyte(PC,PB)+X)&0xFFFF,0)+DB<<16;
	PC++;
	return result;
}

Byte direct_indexed_indirVb()
{
 Byte result;
 result=SNESgetbyte(SNESgetword((D+SNESgetbyte(PC,PB)+X)&0xFFFF,0),DB);
 PC++;
 return result;
}

Word direct_indexed_indirVw()
{
 Word result;
 result=SNESgetword(SNESgetword((D+SNESgetbyte(PC,PB)+X)&0xFFFF,0),DB);
 PC++;
 return result;
}

/////////////////////////////////////////////Direct Indexed with X -> d,x
Double direct_indexed_x()
{
 Double result;
 result=(D+SNESgetbyte(PC,PB)+X)&0xFFFF;
 PC++;
 return result;
}

Byte direct_indexed_xVb()
{
	Byte result;
	result=SNESgetbyte(D+SNESgetbyte(PC,PB)+X,0);
	PC++;
	return result;
}

Word direct_indexed_xVw()
{
 Word result;
 result=SNESgetword(D+SNESgetbyte(PC,PB)+X,0);
 PC++;
 return result;
}

/////////////////////////////////////////////Direct Indexed with Y -> d,y
Double direct_indexed_y()
{
 Double result;
 result=(D+SNESgetbyte(PC,PB)+Y)&0xFFFF;
 PC++;
 return result;
}

Byte direct_indexed_yVb()
{
 Byte result;
 result=SNESgetbyte(D+SNESgetbyte(PC,PB)+Y,0);
 PC++;
 return result;
}

Word direct_indexed_yVw()
{
 Word result;
 result=SNESgetword(D+SNESgetbyte(PC,PB)+Y,0);
 PC++;
 return result;
}

/////////////////////////////////////////////Absolute Indexed with X -> a,x
Double absolute_Xindexed()
{
 Double result;
 result=SNESgetword(PC,PB)&0xFFFF+(PB<<16)+X;
 PC+=2;
 return result;
}

Byte absolute_XindexedVb()
{
 Byte result;
 result=SNESgetbyte(SNESgetword(PC,PB)&0xFFFF+X,DB);
 PC+=2;
 return result;
}

Word absolute_XindexedVw()
{
 Word result;
 result=SNESgetbyte(SNESgetword(PC,PB)&0xFFFF+X,DB);
 PC+=2;
 return result;
}

/////////////////////////////////////////////Absolute Indexed with Y -> a,y
Double absolute_Yindexed()
{
 Double result;
 result=SNESgetword(PC,PB)&0xFFFF+(PB<<16)+X;
 PC+=2;
 return result;
}

Byte absolute_YindexedVb()
{
 Byte result;
 result=SNESgetbyte(SNESgetword(PC,PB)&0xFFFF+X,DB);
 PC+=2;
 return result;
}

Word absolute_YindexedVw()
{
 Word result;
 result=SNESgetbyte(SNESgetword(PC,PB)&0xFFFF+X,DB);
 PC+=2;
 return result;
}

/////////////////////////////////////////////Absolute Long Indexed with X -> al,x
Double absolute_long_indexed()
{
 Double result;
 result=SNESgetword(PC,PB)&0xFFFF+(SNESgetbyte(PC+2,PB)<<16)+Y;
 PC+=3;
 return result;
}

Byte absolute_long_indexedVb()
{
 Byte result;
 result=SNESgetbyte(SNESgetword(PC,PB)&0xFFFF+X,SNESgetbyte(PC+2,PB));
 PC+=3;
 return result;
}

Word absolute_long_indexedVw()
{
 Word result;
 result=SNESgetword(SNESgetword(PC,PB)&0xFFFF+X,SNESgetbyte(PC+2,PB));
 PC+=3;
 return result;
}

/////////////////////////////////////////////Program Counter Relative -> r
Double relative()
{
 Double result;
 result=(PC+1) + (signed char)SNESgetbyte(PC,PB)+(PB<<16);
 return result;
}

/////////////////////////////////////////////Program Counter Relative Long -> rl

/////////////////////////////////////////////Absolute Indirect -> (a)
Byte absolute_indir()
{
	Byte result;
	result=SNESgetbyte(PC+2,PB);
	PC=SNESgetword(PC,PB)&0xFFFF;
	PB=0x00;
	return result;
}

/////////////////////////////////////////////Direct Indirect -> (d)
Double direct_indir()
{
 Double result;
 result=SNESgetword((D+SNESgetbyte(PC,PB))&0xFFFF,0)+DB<<16;
 PC++;
 return result;
}

Byte direct_indirVb()
{
 Byte result;
 result=SNESgetbyte(SNESgetword((D+SNESgetbyte(PC,PB))&0xFFFF,0),DB);
 PC++;
 return result;
}

Word direct_indirVw()
{
 Word result;
 result=SNESgetword(SNESgetword((D+SNESgetbyte(PC,PB))&0xFFFF,0),DB);
 PC++;
 return result;
}

/////////////////////////////////////////////Direct Indirect Long -> [d]
Double direct_indir_long()
{
 Word myaddr;
 myaddr=(D+SNESgetbyte(PC,PB))&0xFFFF;
 PC++;
 return SNESgetword(myaddr,00)+(SNESgetbyte(myaddr+2,00)<<16);
}

Word direct_indir_longVw()
{
 Word myaddr;
 myaddr=(D+SNESgetbyte(PC,PB))&0xFFFF;
 PC++;
 return SNESgetword(SNESgetword(myaddr,00),SNESgetbyte(myaddr+2,00));
}

Byte direct_indir_longVb()
{
 Word myaddr;
 myaddr=(D+SNESgetbyte(PC,PB))&0xFFFF;
 PC++;
 return SNESgetbyte(SNESgetword(myaddr,00),SNESgetbyte(myaddr+2,00));
}

/////////////////////////////////////////////Absolute Indexed Indirect -> (a,x)
Double absolute_indexed_indir()
{
	Double ret;
	ret=PC+2;
	PC=X+SNESgetword(PC,PB);
	PB=0;
	return ret;
}
/////////////////////////////////////////////Stack -> s

/////////////////////////////////////////////Stack Relative -> d,s
Double stack_relative()
{
	Double myaddr;
	myaddr=(S+SNESgetbyte(PC,PB))&0xFFFF;
	PC++;
	return myaddr;
}

Word stack_relativeVw()
{
	Word result;
	result=SNESgetword(S+SNESgetbyte(PC,PB)&0xFFFF,0x00);
	PC++;
	return result;
}

Byte stack_relativeVb()
{
	Byte result;
	result=SNESgetbyte(S+SNESgetbyte(PC,PB)&0xFFFF,0x00);
	PC++;
	return result;
}

/////////////////////////////////////////////Stack Relative Indirect Indexed -> (d,s),y
Double stack_relative_indir_indexed()
{
	Double result;
	result=S+SNESgetbyte(PC,PB)+(DB<<16)+Y;
	PC++;
	return result;
}

Word stack_relative_indir_indexedVw()
{
	Word result;
	result=SNESgetword(S+SNESgetbyte(PC,PB)+Y,DB);
	PC++;
	return result;
}

Byte stack_relative_indir_indexedVb()
{
	Byte result;
	result=SNESgetbyte(S+SNESgetbyte(PC,PB)+Y,DB);
	PC++;
	return result;
}

/////////////////////////////////////////////Block Source Bank, Destination Bank -> xyc
void block_src_bank_dest_bank(Double *src,Double *dest)
{
	DB=SNESgetbyte(PC,PB);	
	*dest=(DB<<16)+(Y&0xFFFF);
	*src=(SNESgetbyte(PC+1,PB)<<16)+(X&0xFFFF);
	PC+=2;
}