/***************************************************************************
FILE: asl.cpp
PURPOSE: Shift one bit left (memory or accumulator)
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0x0A
//ASL A
//Bytes 1
//Cycles 2
void asl_accum()
{
	PC++;
	if(P.M==1)
	{
		Byte B;
		
		B=A&0xFF;
		if(B&0x80) P.C=1; else P.C=0;
		B=B<<1;
		A=B|(A&0xFF00);
		if(B=0) P.Z=1; else P.Z=0;
		if(B&0x80) P.N=1; else P.N=0;
	}
	else
	{
		if(A&0x8000) P.C=1; else P.C=0;
		A=A<<1;
		if(A=0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=2;
}

//0x06
//ASL d
//Bytes 2
//Cycles 5
void asl_d()
{
	PC++;
	if(P.M==1)
	{
		Byte B;
		Double addr;
		long int offset;
		MemType mt;


		addr=direct();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(B&0x80) P.C=1; else P.C=0;
		B=B<<1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		if(B=0) P.Z=1; else P.Z=0;
		if(B&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(W&0x8000) P.C=1; else P.C=0;
		W=W<<1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		if(W=0) P.Z=1; else P.Z=0;
		if(W&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0x16
//ASL d,x
//Bytes 2
//Cycles 6
void asl_d_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Byte B;
		Double addr;
		long int offset;
		MemType mt;


		addr=direct_indexed_x();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(B&0x80) P.C=1; else P.C=0;
		B=B<<1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		if(B=0) P.Z=1; else P.Z=0;
		if(B&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_x();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(W&0x8000) P.C=1; else P.C=0;
		W=W<<1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		if(W=0) P.Z=1; else P.Z=0;
		if(W&0x8000) P.N=1; else P.N=0;
	}
	t+=6;
}

//0x0E
//ASL a
//Bytes 3
//Cycles 6
void asl_a()
{
	PC++;
	if(P.M==1)
	{
		Byte B;
		Double addr;
		long int offset;
		MemType mt;


		addr=absolute();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(B&0x80) P.C=1; else P.C=0;
		B=B<<1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		if(B=0) P.Z=1; else P.Z=0;
		if(B&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(W&0x8000) P.C=1; else P.C=0;
		W=W<<1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		if(W=0) P.Z=1; else P.Z=0;
		if(W&0x8000) P.N=1; else P.N=0;
	}
	t+=6;
}

//0x1E
//ASL a,x
//Bytes 3
//Cycles 7
void asl_a_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Byte B;
		Double addr;
		long int offset;
		MemType mt;


		addr=absolute_Xindexed();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(B&0x80) P.C=1; else P.C=0;
		B=B<<1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		if(B=0) P.Z=1; else P.Z=0;
		if(B&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_Xindexed();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(W&0x8000) P.C=1; else P.C=0;
		W=W<<1;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		if(W=0) P.Z=1; else P.Z=0;
		if(W&0x8000) P.N=1; else P.N=0;
	}
	t+=7;
}

