/***************************************************************************
FILE: cmp.cpp
PURPOSE: Compare memory and accumulator
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0xC9
//CMP #
//Bytes 2
//Cycles 2
void cmp_im()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		result=(Byte)((A&0xFF)-immediateVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((A&0xFFFF)-immediateVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=2;
}

//0xC5
//CMP d
//Bytes 2
//Cycles 3
void cmp_d()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		result=(Byte)((A&0xFF)-directVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((A&0xFFFF)-directVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=3;
}

//0xD5
//CMP d,x
//Bytes 2
//Cycles 4
void cmp_d_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		result=(Byte)((A&0xFF)-direct_indexed_xVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((A&0xFFFF)-direct_indexed_xVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=4;
}

//0xD2
//CMP (d)
//Bytes 2
//Cycles 5
void cmp_d_in()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		result=(Byte)((A&0xFF)-direct_indirVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((A&0xFFFF)-direct_indirVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=5;
}

//0xC1
//CMP (d,x)
//Bytes 2
//Cycles 6
void cmp_d_ix_in()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		result=(Byte)((A&0xFF)-direct_indexed_indirVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((A&0xFFFF)-direct_indexed_indirVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=6;
}

//0xD1
//CMP (d),y
//Bytes 2
//Cycles 5
void cmp_d_in_ix()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		result=(Byte)((A&0xFF)-direct_indir_indexed_yVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((A&0xFFFF)-direct_indir_indexed_yVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=5;
}

//0xC7
//CMP [d]
//Bytes 2
//Cycles 6
void cmp_d_in_l()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		result=(Byte)((A&0xFF)-direct_indir_longVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((A&0xFFFF)-direct_indir_longVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=6;
}

//0xCD
//CMP a
//Bytes 3
//Cycles 4
void cmp_a()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		result=(Byte)((A&0xFF)-absoluteVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((A&0xFFFF)-absoluteVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=4;
}

//0xDD
//CMP a,x
//Bytes 3
//Cycles 4
void cmp_a_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		result=(Byte)((A&0xFF)-absolute_XindexedVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((A&0xFFFF)-absolute_XindexedVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=4;
}

//0xD9
//CMP a,y
//Bytes 3
//Cycles 4
void cmp_a_ix_y()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		result=(Byte)((A&0xFF)-absolute_YindexedVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((A&0xFFFF)-absolute_YindexedVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=4;
}

//0xCF
//CMP al
//Bytes 4
//Cycles 5
void cmp_al()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		result=(Byte)((A&0xFF)-absolute_longVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((A&0xFFFF)-absolute_longVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=5;
}

//0xDF
//CMP al,x
//Bytes 4
//Cycles 5
void cmp_a_l_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		result=(Byte)((A&0xFF)-absolute_long_indexedVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((A&0xFFFF)-absolute_long_indexedVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=5;
}

//0xC3
//CMP d,s
//Bytes 2
//Cycles 4
void cmp_s_r()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		result=(Byte)((A&0xFF)-stack_relativeVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((A&0xFFFF)-stack_relativeVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=4;
}

//0xD3
//CMP (d,s),y
//Bytes 2
//Cycles 7
void cmp_s_r_in_ix()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		result=(Byte)((A&0xFF)-stack_relative_indir_indexedVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((A&0xFFFF)-stack_relative_indir_indexedVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=7;
}