/***************************************************************************
FILE: cpx.cpp
PURPOSE: Compare memory and index X
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0xE0
//CPX #
//Bytes 2
//Cycles 2
void cpx_im()
{
	PC++;
	if(P.X==1)
	{
		Word result;
		result=(Byte)((X&0xFF)-immediateVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((X&0xFFFF)-immediateVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=2;
}

//0xE4
//CPX d
//Bytes 2
//Cycles 3
void cpx_d()
{
	PC++;
	if(P.X==1)
	{
		Word result;
		result=(Byte)((X&0xFF)-directVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((X&0xFFFF)-directVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=3;
}

//0xEC
//CPX a
//Bytes 3
//Cycles 4
void cpx_a()
{
	PC++;
	if(P.X==1)
	{
		Word result;
		result=(Byte)((X&0xFF)-absoluteVb());
		if((result&0xFF)==0) P.Z=1; else P.Z=0;
		if((result&0x80)==1) P.N=1; else P.N=0;
		if(result>0xFF) P.C=1; else P.C=0;
	}
	else
	{
		Double result;
		result=(Word)((X&0xFFFF)-absoluteVw());
		if((result&0xFFFF)==0) P.Z=1; else P.Z=0;
		if((result&0x8000)==1) P.N=1; else P.N=0;
		if(result>0xFFFF) P.C=1; else P.C=0;
	}
	t+=4;
}

