/***************************************************************************
FILE: eor.cpp
PURPOSE: exclusive or memory and accumulator
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0x49
//EOR #
//Bytes 2
//Cycles 2
void eor_im()
{
	PC++;
	if(P.M==1)
	{
		A=((A&0xFF)^immediateVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=A^immediateVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=2;
}

//0x45
//EOR d
//Bytes 2
//Cycles 3
void eor_d()
{
	PC++;
	if(P.M==1)
	{
		A=((A&0xFF)^directVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=A^directVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=3;
}

//0x55
//EOR d,x
//Bytes 2
//Cycles 4
void eor_d_ix_x()
{
	PC++;
	if(P.M==1)
	{
		A=((A&0xFF)^direct_indexed_xVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=A^direct_indexed_xVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x52
//EOR (d)
//Bytes 2
//Cycles 5
void eor_d_in()
{
	PC++;
	if(P.M==1)
	{
		A=((A&0xFF)^direct_indirVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=A^direct_indirVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0x41
//EOR (d,x)
//Bytes 2
//Cycles 6
void eor_d_ix_in()
{
	PC++;
	if(P.M==1)
	{
		A=((A&0xFF)^direct_indexed_indirVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=A^direct_indexed_indirVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=6;
}

//0x51
//EOR (d),y
//Bytes 2
//Cycles 5
void eor_d_in_ix()
{
	PC++;
	if(P.M==1)
	{
		A=((A&0xFF)^direct_indir_indexed_yVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=A^direct_indir_indexed_yVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0x47
//EOR [d]
//Bytes 2
//Cycles 6
void eor_d_in_l()
{
	PC++;
	if(P.M==1)
	{
		A=((A&0xFF)^direct_indir_longVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=A^direct_indir_longVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=6;
}

//0x4D
//EOR a
//Bytes 3
//Cycles 4
void eor_a()
{
	PC++;
	if(P.M==1)
	{
		A=((A&0xFF)^absoluteVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=A^absoluteVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x5D
//EOR a,x
//Bytes 3
//Cycles 4
void eor_a_ix_x()
{
	PC++;
	if(P.M==1)
	{
		A=((A&0xFF)^absolute_XindexedVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=A^absolute_XindexedVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x59
//EOR a,y
//Bytes 3
//Cycles 4
void eor_a_ix_y()
{
	PC++;
	if(P.M==1)
	{
		A=((A&0xFF)^absolute_YindexedVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=A^absolute_YindexedVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x4F
//EOR al
//Bytes 4
//Cycles 5
void eor_al()
{
	PC++;
	if(P.M==1)
	{
		A=((A&0xFF)^absolute_longVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=A^absolute_longVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0x5F
//EOR al,x
//Bytes 4
//Cycles 5
void eor_a_l_ix_x()
{
	PC++;
	if(P.M==1)
	{
		A=((A&0xFF)^absolute_long_indexedVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=A^absolute_long_indexedVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0x43
//EOR d,s
//Bytes 2
//Cycles 4
void eor_s_r()
{
	PC++;
	if(P.M==1)
	{
		A=((A&0xFF)^stack_relativeVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=A^stack_relativeVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x53
//EOR (d,s),y
//Bytes 2
//Cycles 7
void eor_s_r_in_ix()
{
	PC++;
	if(P.M==1)
	{
		A=((A&0xFF)^stack_relative_indir_indexedVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=A^stack_relative_indir_indexedVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=7;
}