/***************************************************************************
FILE: inc.cpp
PURPOSE: increment memory or accumulator by one
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0x1A
//INC A
//Bytes 1
//Cycles 2
void inc_accum()
{
	PC++;
	if(P.M==1)
	{
		A++;
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A++;
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=2;
}

//0xE6
//INC d
//Bytes 2
//Cycles 5
void inc_d()
{
	PC++;
	if(P.M==1)
	{
		Byte B;
		Double Addr;
		MemType mt;
		long int realoff;

		Addr=direct();
		B=SNESgetbyte((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF));
		B++;
		SnesMap((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF),&mt,&realoff);
		SNESsetbyte(mt,realoff,B);
		if(B==0) P.Z=1; else P.Z=0;
		if(B&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Word W;
		Double Addr;
		MemType mt;
		long int realoff;

		Addr=direct();
		W=SNESgetword((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF));
		W++;
		SnesMap((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF),&mt,&realoff);
		SNESsetword(mt,realoff,W);
		if(W==0) P.Z=1; else P.Z=0;
		if(W&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0xF6
//INC d,x
//Bytes 2
//Cycles 6
void inc_d_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Byte B;
		Double Addr;
		MemType mt;
		long int realoff;

		Addr=direct_indexed_x();
		B=SNESgetbyte((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF));
		B++;
		SnesMap((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF),&mt,&realoff);
		SNESsetbyte(mt,realoff,B);
		if(B==0) P.Z=1; else P.Z=0;
		if(B&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Word W;
		Double Addr;
		MemType mt;
		long int realoff;

		Addr=direct_indexed_x();
		W=SNESgetword((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF));
		W++;
		SnesMap((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF),&mt,&realoff);
		SNESsetword(mt,realoff,W);
		if(W==0) P.Z=1; else P.Z=0;
		if(W&0x8000) P.N=1; else P.N=0;
	}
	t+=6;
}

//0xEE
//INC a
//Bytes 3
//Cycles 6
void inc_a()
{
	PC++;
	if(P.M==1)
	{
		Byte B;
		Double Addr;
		MemType mt;
		long int realoff;

		Addr=absolute();
		B=SNESgetbyte((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF));
		B++;
		SnesMap((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF),&mt,&realoff);
		SNESsetbyte(mt,realoff,B);
		if(B==0) P.Z=1; else P.Z=0;
		if(B&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Word W;
		Double Addr;
		MemType mt;
		long int realoff;

		Addr=absolute();
		W=SNESgetword((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF));
		W++;
		SnesMap((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF),&mt,&realoff);
		SNESsetword(mt,realoff,W);
		if(W==0) P.Z=1; else P.Z=0;
		if(W&0x8000) P.N=1; else P.N=0;
	}
	t+=6;
}

//0xFE
//INC a,x
//Bytes 3
//Cycles 7
void inc_a_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Byte B;
		Double Addr;
		MemType mt;
		long int realoff;

		Addr=absolute_Xindexed();
		B=SNESgetbyte((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF));
		B++;
		SnesMap((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF),&mt,&realoff);
		SNESsetbyte(mt,realoff,B);
		if(B==0) P.Z=1; else P.Z=0;
		if(B&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Word W;
		Double Addr;
		MemType mt;
		long int realoff;

		Addr=absolute_Xindexed();
		W=SNESgetword((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF));
		W++;
		SnesMap((Word)Addr&0xFFFF,(Byte)((Addr>>16)&0xFF),&mt,&realoff);
		SNESsetword(mt,realoff,W);
		if(W==0) P.Z=1; else P.Z=0;
		if(W&0x8000) P.N=1; else P.N=0;
	}
	t+=7;
}