/***************************************************************************
FILE: lda.cpp
PURPOSE: load accumulator with memory
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0xA9
//LDA #
//Bytes 2
//Cycles 2
void lda_im()
{
	PC++;
	if(P.M==1)
	{
		A=(immediateVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=immediateVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=2;
}

//0xA5
//LDA d
//Bytes 2
//Cycles 3
void lda_d()
{
	PC++;
	if(P.M==1)
	{
		A=(directVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=directVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=3;
}

//0xB5
//LDA d,x
//Bytes 2
//Cycles 4
void lda_d_ix_x()
{
	PC++;
	if(P.M==1)
	{
		A=(direct_indexed_xVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=direct_indexed_xVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0xB2
//LDA (d)
//Bytes 2
//Cycles 5
void lda_d_in()
{
	PC++;
	if(P.M==1)
	{
		A=(direct_indirVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=direct_indirVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0xA1
//LDA (d,x)
//Bytes 2
//Cycles 6
void lda_d_ix_in()
{
	PC++;
	if(P.M==1)
	{
		A=(direct_indexed_indirVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=direct_indexed_indirVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=6;
}

//0xB1
//LDA (d),y
//Bytes 2
//Cycles 5
void lda_d_in_ix()
{
	PC++;
	if(P.M==1)
	{
		A=(direct_indir_indexed_yVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=direct_indir_indexed_yVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0xB7
//LDA [d],y
//Bytes 2
//Cycles 6
void lda_d_in_ix_l()
{
	PC++;
	if(P.M==1)
	{
		A=(dir_indir_indexed_longVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=dir_indir_indexed_longVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0xAD
//LDA a
//Bytes 3
//Cycles 4
void lda_a()
{
	PC++;
	if(P.M==1)
	{
		A=(absoluteVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=absoluteVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0xBD
//LDA a,x
//Bytes 3
//Cycles 4
void lda_a_ix_x()
{
	PC++;
	if(P.M==1)
	{
		A=(absolute_XindexedVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=absolute_XindexedVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0xB9
//LDA a,y
//Bytes 3
//Cycles 4
void lda_a_ix_y()
{
	PC++;
	if(P.M==1)
	{
		A=(absolute_YindexedVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=absolute_YindexedVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0xAF
//LDA al
//Bytes 4
//Cycles 5
void lda_al()
{
	PC++;
	if(P.M==1)
	{
		A=(absolute_longVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=absolute_longVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0xBF
//LDA al,x
//Bytes 4
//Cycles 5
void lda_a_l_ix_x()
{
	PC++;
	if(P.M==1)
	{
		A=(absolute_long_indexedVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=absolute_long_indexedVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0xA3
//LDA d,s
//Bytes 2
//Cycles 4
void lda_s_r()
{
	PC++;
	if(P.M==1)
	{
		A=(stack_relativeVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=stack_relativeVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0xB3
//LDA (d,s),y
//Bytes 2
//Cycles 7
void lda_s_r_in_ix()
{
	PC++;
	if(P.M==1)
	{
		A=(stack_relative_indir_indexedVb())|(A&0xFF00);
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=stack_relative_indir_indexedVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=7;
}