/***************************************************************************
FILE: ldy.cpp
PURPOSE: load Y with memory
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0xA0
//LDY #
//Bytes 2
//Cycles 2
void ldy_im()
{
	PC++;
	if(P.X==1)
	{
		Y=(immediateVb())|(Y&0xFF00);
		if(Y&0xFF==0) P.Z=1; else P.Z=0;
		if(Y&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Y=immediateVw();
		if(Y&0xFFFF==0) P.Z=1; else P.Z=0;
		if(Y&0x8000) P.N=1; else P.N=0;
	}
	t+=2;
}

//0xA4
//LDY d
//Bytes 2
//Cycles 3
void ldy_d()
{
	PC++;
	if(P.X==1)
	{
		Y=(directVb())|(Y&0xFF00);
		if(Y&0xFF==0) P.Z=1; else P.Z=0;
		if(Y&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Y=directVw();
		if(Y&0xFFFF==0) P.Z=1; else P.Z=0;
		if(Y&0x8000) P.N=1; else P.N=0;
	}
	t+=3;
}

//0xB4
//LDY d,x
//Bytes 2
//Cycles 4
void ldy_d_ix_x()
{
	PC++;
	if(P.X==1)
	{
		Y=(direct_indexed_xVb())|(Y&0xFF00);
		if(Y&0xFF==0) P.Z=1; else P.Z=0;
		if(Y&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Y=direct_indexed_xVw();
		if(Y&0xFFFF==0) P.Z=1; else P.Z=0;
		if(Y&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0xAC
//LDY a
//Bytes 3
//Cycles 4
void ldy_a()
{
	PC++;
	if(P.X==1)
	{
		Y=(absoluteVb())|(Y&0xFF00);
		if(Y&0xFF==0) P.Z=1; else P.Z=0;
		if(Y&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Y=absoluteVw();
		if(Y&0xFFFF==0) P.Z=1; else P.Z=0;
		if(Y&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0xBC
//LDY a,x
//Bytes 3
//Cycles 4
void ldy_a_ix_x()
{
	PC++;
	if(P.X==1)
	{
		Y=(absolute_XindexedVb())|(Y&0xFF00);
		if(Y&0xFF==0) P.Z=1; else P.Z=0;
		if(Y&0x80) P.N=1; else P.N=0;
	}
	else
	{
		Y=absolute_XindexedVw();
		if(Y&0xFFFF==0) P.Z=1; else P.Z=0;
		if(Y&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}
