/***************************************************************************
FILE: ora.cpp
PURPOSE: OR memory with accumulator
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0x09
//ORA #
//Bytes 2
//Cycles 2
void ora_im()
{
	PC++;
	if(P.M==1)
	{
		A|=(0xFF&immediateVb());
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A|=immediateVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=2;
}

//0x05
//ORA d
//Bytes 2
//Cycles 3
void ora_d()
{
	PC++;
	if(P.M==1)
	{
		A|=(0xFF&directVb());
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A|=directVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=3;
}

//0x15
//ORA d,x
//Bytes 2
//Cycles 4
void ora_d_ix_x()
{
	PC++;
	if(P.M==1)
	{
		A|=(0xFF&direct_indexed_xVb());
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A|=direct_indexed_xVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x12
//ORA (d)
//Bytes 2
//Cycles 5
void ora_d_in()
{
	PC++;
	if(P.M==1)
	{
		A|=(0xFF&direct_indirVb());
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A|=direct_indirVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0x01
//ORA (d,x)
//Bytes 2
//Cycles 6
void ora_d_ix_in()
{
	PC++;
	if(P.M==1)
	{
		A|=(0xFF&direct_indexed_indirVb());
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A|=direct_indexed_indirVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=6;
}

//0x11
//ORA (d),y
//Bytes 2
//Cycles 5
void ora_d_in_ix()
{
	PC++;
	if(P.M==1)
	{
		A|=(0xFF&direct_indir_indexed_yVb());
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A|=direct_indir_indexed_yVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0x17
//ORA [d],y
//Bytes 2
//Cycles 6
void ora_d_in_ix_l()
{
	PC++;
	if(P.M==1)
	{
		A|=(0xFF&dir_indir_indexed_longVb());
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A|=dir_indir_indexed_longVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=6;
}

//0x0D
//ORA a
//Bytes 3
//Cycles 4
void ora_a()
{
	PC++;
	if(P.M==1)
	{
		A|=(0xFF&absoluteVb());
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A|=absoluteVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x1D
//ORA a,x
//Bytes 3
//Cycles 4
void ora_a_ix_x()
{
	PC++;
	if(P.M==1)
	{
		A|=(0xFF&absolute_XindexedVb());
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A|=absolute_XindexedVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x19
//ORA a,y
//Bytes 3
//Cycles 4
void ora_a_ix_y()
{
	PC++;
	if(P.M==1)
	{
		A|=(0xFF&absolute_YindexedVb());
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A|=absolute_YindexedVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x0F
//ORA al
//Bytes 4
//Cycles 5
void ora_al()
{
	PC++;
	if(P.M==1)
	{
		A|=(0xFF&absolute_longVb());
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A|=absolute_longVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x1F
//ORA al,x
//Bytes 4
//Cycles 5
void ora_a_l_ix_x()
{
	PC++;
	if(P.M==1)
	{
		A|=(0xFF&absolute_long_indexedVb());
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A|=absolute_long_indexedVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0x03
//ORA d,s
//Bytes 2
//Cycles 4
void ora_s_r()
{
	PC++;
	if(P.M==1)
	{
		A|=(0xFF&stack_relativeVb());
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A|=stack_relativeVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x13
//ORA (d,s),y
//Bytes 2
//Cycles 7
void ora_s_r_in_ix()
{
	PC++;
	if(P.M==1)
	{
		A|=(0xFF&stack_relative_indir_indexedVb());
		if(A&0xFF==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A|=stack_relative_indir_indexedVw();
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=7;
}