/***************************************************************************
FILE: ror.cpp
PURPOSE: Rotate one bit right
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"


//0x6A
//ROR A
//Bytes 1
//Cycles 2
void ror_accum()
{
	PC++;
	if(P.M==1)
	{
		Byte tempPC;
		Byte B;

		B=(Byte)A&0xFF;
		if(P.C==1) {tempPC=1;P.N=1;} else {tempPC=0;P.N=0;}
		if(B&0x01) P.C=1; else P.C=0;
		B=B>>1;
		if(tempPC) B|=0x80;
		A=B|(A&0xFF00);
		if(B&0xFF==0) P.Z=1; else P.Z=0;
	}
	else
	{
		Byte tempPC;
				
		if(P.C==1) {tempPC=1;P.N=1;} else {tempPC=0;P.N=0;}
		if(A&0x01) P.C=1; else P.C=0;
		A=A>>1;
		if(tempPC) A|=0x8000;
		if(A&0xFFFF==0) P.Z=1; else P.Z=0;
	}
	t+=2;
}

//0x66
//ROR d
//Bytes 2
//Cycles 5
void ror_d()
{
	PC++;
	if(P.M==1)
	{
		Byte tempPC;
		Byte B;
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) {tempPC=1;P.N=1;} else {tempPC=0;P.N=0;}
		if(B&0x01) P.C=1; else P.C=0;
		B=B>>1;
		if(tempPC) B|=0x80;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		if(B&0xFF==0) P.Z=1; else P.Z=0;
	}
	else
	{
		Byte tempPC;
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) {tempPC=1;P.N=1;} else {tempPC=0;P.N=0;}
		if(W&0x01) P.C=1; else P.C=0;
		W=W>>1;
		if(tempPC) W|=0x8000;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		if(W&0xFFFF==0) P.Z=1; else P.Z=0;
	}
	t+=5;
}

//0x76
//ROR d,x
//Bytes 2
//Cycles 6
void ror_d_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Byte tempPC;
		Byte B;
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_x();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) {tempPC=1;P.N=1;} else {tempPC=0;P.N=0;}
		if(B&0x01) P.C=1; else P.C=0;
		B=B>>1;
		if(tempPC) B|=0x80;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		if(B&0xFF==0) P.Z=1; else P.Z=0;
	}
	else
	{
		Byte tempPC;
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_x();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) {tempPC=1;P.N=1;} else {tempPC=0;P.N=0;}
		if(W&0x01) P.C=1; else P.C=0;
		W=W>>1;
		if(tempPC) W|=0x8000;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		if(W&0xFFFF==0) P.Z=1; else P.Z=0;
	}
	t+=6;
}

//0x6E
//ROR a
//Bytes 3
//Cycles 6
void ror_a()
{
	PC++;
	if(P.M==1)
	{
		Byte tempPC;
		Byte B;
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) {tempPC=1;P.N=1;} else {tempPC=0;P.N=0;}
		if(B&0x01) P.C=1; else P.C=0;
		B=B>>1;
		if(tempPC) B|=0x80;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		if(B&0xFF==0) P.Z=1; else P.Z=0;
	}
	else
	{
		Byte tempPC;
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) {tempPC=1;P.N=1;} else {tempPC=0;P.N=0;}
		if(W&0x01) P.C=1; else P.C=0;
		W=W>>1;
		if(tempPC) W|=0x8000;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		if(W&0xFFFF==0) P.Z=1; else P.Z=0;
	}
	t+=6;
}

//0x7E
//ROR a,x
//Bytes 3
//Cycles 7
void ror_a_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Byte tempPC;
		Byte B;
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_Xindexed();
		B=SNESgetbyte((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) {tempPC=1;P.N=1;} else {tempPC=0;P.N=0;}
		if(B&0x01) P.C=1; else P.C=0;
		B=B>>1;
		if(tempPC) B|=0x80;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,B);
		if(B&0xFF==0) P.Z=1; else P.Z=0;
	}
	else
	{
		Byte tempPC;
		Word W;
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_Xindexed();
		W=SNESgetword((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF));
		if(P.C==1) {tempPC=1;P.N=1;} else {tempPC=0;P.N=0;}
		if(W&0x01) P.C=1; else P.C=0;
		W=W>>1;
		if(tempPC) W|=0x8000;
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,W);
		if(W&0xFFFF==0) P.Z=1; else P.Z=0;
	}
	t+=7;
}
