/***************************************************************************
FILE: sta.cpp
PURPOSE: Store accumulator in memory
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0x85
//STA d
//Bytes 2
//Cycles 3
void sta_d()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(A&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,A);
	}
	t+=3;
}

//0x95
//STA d,x
//Bytes 2
//Cycles 4
void sta_d_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_x();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(A&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_x();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,A);
	}
	t+=4;
}

//0x92
//STA (d)
//Bytes 2
//Cycles 5
void sta_d_in()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indir();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(A&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indir();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,A);
	}
	t+=5;
}

//0x81
//STA (d,x)
//Bytes 2
//Cycles 6
void sta_d_ix_in()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_indir();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(A&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_indir();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,A);
	}
	t+=6;
}

//0x91
//STA (d),y
//Bytes 2
//Cycles 6
void sta_d_in_ix()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indir_indexed_y();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(A&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indir_indexed_y();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,A);
	}
	t+=6;
}

//0x97
//STA [d],y
//Bytes 2
//Cycles 6
void sta_d_in_ix_l()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=dir_indir_indexed_long();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(A&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=dir_indir_indexed_long();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,A);
	}
	t+=6;
}

//0x8D
//STA a
//Bytes 3
//Cycles 4
void sta_a()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(A&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,A);
	}
	t+=4;
}

//0x9D
//STA a,x
//Bytes 3
//Cycles 5
void sta_a_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_Xindexed();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(A&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_Xindexed();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,A);
	}
	t+=5;
}

//0x99
//STA a,y
//Bytes 3
//Cycles 5
void sta_a_ix_y()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_Yindexed();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(A&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_Yindexed();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,A);
	}
	t+=5;
}

//0x8F
//STA al
//Bytes 4
//Cycles 5
void sta_al()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_long();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(A&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_long();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,A);
	}
	t+=5;
}

//0x9F
//STA al,x
//Bytes 4
//Cycles 5
void sta_a_l_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_long_indexed();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(A&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute_long_indexed();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,A);
	}
	t+=5;
}

//0x83
//STA d,s
//Bytes 2
//Cycles 4
void sta_s_r()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=stack_relative();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(A&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=stack_relative();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,A);
	}
	t+=4;
}

//0x93
//STA (d,s),y
//Bytes 2
//Cycles 7
void sta_s_r_in_ix()
{
	PC++;
	if(P.M==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=stack_relative_indir_indexed();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(A&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=stack_relative_indir_indexed();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,A);
	}
	t+=7;
}