/***************************************************************************
FILE: sty.cpp
PURPOSE: Store Y in memory 
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0x84
//STY d
//Bytes 2
//Cycles 3
void sty_d()
{
	PC++;
	if(P.X==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(Y&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,Y);
	}
	t+=3;
}


//0x94
//STY d,x
//Bytes 2
//Cycles 4
void sty_d_ix_y()
{
	PC++;
	if(P.X==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_x();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(Y&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=direct_indexed_x();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,Y);
	}
	t+=4;
}

//0x8C
//STY a
//Bytes 3
//Cycles 4
void sty_a()
{
	PC++;
	if(P.X==1)
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetbyte(mt,offset,(Byte)(Y&0xFF));
	}
	else
	{
		Double addr;
		long int offset;
		MemType mt;

		addr=absolute();
		SnesMap((Word)addr&0xFFFF,(Byte)((addr>>16)&0xFF),&mt,&offset);
		SNESsetword(mt,offset,Y);
	}
	t+=4;
}