switch (byte)
{
  case 0x69:
    long At;
  
    PC++;

    tempint  = SNESgetword(PC, PB);
    PC += 2;
    At = (long)A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    t += 2;
    break;
  case 0x65:
    long At;
  
    PC++;

    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 4;
    break;
  case 0x75:
    long At;
  
    PC++;

    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 4;
    break;
  case 0x72:
    long At;
  
    PC++;

    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, DB);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 5;
    break;
  case 0x61:
    long At;
  
    PC++;

    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, DB);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 6;
    break;
  case 0x71:
    long At;
    long mem;
  
    PC++;
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetword((unsigned int)(mem & 0x0000ffff), mem >> 16);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 5;
    break;
  case 0x67:
    long At;
  
    PC++;

    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 6;
    break;
  case 0x6D:
    long At;
  
    PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC += 2;
    t += 4;
    break;
  case 0x7D:
    long At;
  
    PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC += 2;
    t += 4;
    break;
  case 0x79:
    long At;
  
    PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC += 2;
    t += 4;
    break;
  case 0x6F:
    long At;
  
    PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(tempint, tempbyte);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 5;
    break;
  case 0x7F:
    long At;
    long addr;
  
    PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 5;
    break;
  case 0x63:
    long At;
  
    PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(S+tempbyte, 0);
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 4;
    break;
case 0x73:
    long At;
    long addr;
  
    PC++;
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 7;
    break;
  case 0x29:
    long At;
  
    PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    At = (long)A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    t += 2;
    break;
  case 0x25:
    long At;
  
    PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 4;
    break;
  case 0x35:
    long At;
  
    PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 4;
    break;
  case 0x32:
    long At;
  
    PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, DB);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;

    PC++;
    t += 5;
    break;
  case 0x21:  
    long At;
  
    PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, DB);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 6;
    break;
  case 0x31:
    long At;
    long mem;
  
    PC++;
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetword((unsigned int)(mem & 0x0000ffff), mem >> 16);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 5;
    break;
  case 0x27:
    long At;
  
    PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 6;
    break;
  case 0x2D:
    long At;
  
    PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC += 2;
    t += 4;
    break;
  case 0x3D:
    long At;
  
    PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC += 2;
    t += 4;
    break;
  case 0x39:
    long At;
  
    PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC += 2;
    t += 4;
    break;
  case 0x2F:
    long At;
  
    PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(tempint, tempbyte);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 5;
    break;
  case 0x3F:
    long At;
    long addr;
  
    PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 5;
    break;
  case 0x23:
    long At;
  
    PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(S+tempbyte, 0);
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 4;
    break;
  case 0x33:
    long At;
    long addr;
  
    PC++;
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A & tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
    PC++;
    t += 7;
    break;
  case 0x0A:
    P &= 0xFFFE | (0x0001 & (A >> 16));
    A <<= 1;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);

    PC++;
    t += 2;
    break;
  case 0x06:
    PC++;
  
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, PB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

    PC++;
    t += 2;
    break;
  case 0x16:
    PC++;
  
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, PB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

    PC++;
    t += 2;
    break;
  case 0x0E:
    PC++;
  
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

    PC += 2;
    t += 2;
    break;

void _asl_ax(void)
{
  PC++;
  
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC += 2;
  t += 2;
}

void _bit_i(void)
{
  PC++;
  
    tempint  = SNESgetword(PC, PB);
    PC++;
    tempint  = A & tempint;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);

  PC++;
  t += 2;
}

void _bit_d(void)
{
  PC++;
  
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, PB);
    tempint  = A & tempint;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);

  PC++;
  t += 2;
}

void _bit_dx(void)
{
  PC++;
  
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, PB);
    tempint  = A & tempint;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);

  PC++;
  t += 2;
}

void _bit_a(void)
{
  PC++;
  
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    tempint  = A & tempint;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);

  PC += 2;
  t += 2;
}

void _bit_ax(void)
{
  PC++;
  
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    tempint  = A & tempint;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);

  PC += 2;
  t += 2;
}

void _cmp_i(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  t += 2;
}

void _cmp_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _cmp_dx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _cmp_pd(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, DB);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}
  
void _cmp_pdx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, DB);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 6;
}

void _cmp_pd_y(void)
{
  long At;
  long mem;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetword((unsigned int)(mem & 0x0000ffff), mem >> 16);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _cmp_bd(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 6;
}

void _cmp_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _cmp_ax(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _cmp_ay(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _cmp_al(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(tempint, tempbyte);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _cmp_alx(void)
{
  long At;
  long addr;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _cmp_ds(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(S+tempbyte, 0);
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _cmp_pds_y(void)
{
  long At;
  long addr;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    tempint = A - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 7;
}

void _cpx_i(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    if (tempint == X) P |= 0x02;
    tempint = X - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  t += 2;
}

void _cpx_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    tempint = X - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _cpx_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    tempint = X - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _cpy_i(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempint = Y - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  t += 2;
}

void _cpy_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    tempint = Y - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _cpy_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    tempint = Y - tempint;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _dec_A(void)
{
    A -= 1;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);

  PC++;
  t += 2;
}

void _dec_d(void)
{
  PC++;
  
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, PB);
    tempint -= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC++;
  t += 2;
}

void _dec_dx(void)
{
  PC++;
  
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, PB);
    tempint -= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC++;
  t += 2;
}

void _dec_a(void)
{
  PC++;
  
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    tempint -= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC += 2;
  t += 2;
}

void _dec_ax(void)
{
  PC++;
  
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    tempint -= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC += 2;
  t += 2;
}

void _eor_i(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    At = (long)A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  t += 2;
}

void _eor_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _eor_dx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _eor_pd(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, DB);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}
  
void _eor_pdx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, DB);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 6;
}

void _eor_pd_y(void)
{
  long At;
  long mem;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetword((unsigned int)(mem & 0x0000ffff), mem >> 16);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _eor_bd(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 6;
}

void _eor_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _eor_ax(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _eor_ay(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _eor_al(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(tempint, tempbyte);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _eor_alx(void)
{
  long At;
  long addr;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _eor_ds(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(S+tempbyte, 0);
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _eor_pds_y(void)
{
  long At;
  long addr;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A ^ tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 7;
}

void _inc_A(void)
{
    A += 1;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);

  PC++;
  t += 2;
}

void _inc_d(void)
{
  PC++;
  
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, PB);
    tempint += 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC++;
  t += 2;
}

void _inc_dx(void)
{
  PC++;
  
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, PB);
    tempint += 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC++;
  t += 2;
}

void _inc_a(void)
{
  PC++;
  
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    tempint += 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC += 2;
  t += 2;
}

void _inc_ax(void)
{
  PC++;
  
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    tempint += 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC += 2;
  t += 2;
}

void _lda_i(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  t += 2;
}

void _lda_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _lda_dx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _lda_pd(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, DB);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}
  
void _lda_pdx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, DB);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 6;
}

void _lda_pd_y(void)
{
  long At;
  long mem;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetword((unsigned int)(mem & 0x0000ffff), mem >> 16);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _lda_bd(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 6;
}

void _lda_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _lda_ax(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _lda_ay(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _lda_al(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(tempint, tempbyte);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _lda_alx(void)
{
  long At;
  long addr;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _lda_ds(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(S+tempbyte, 0);
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _lda_pds_y(void)
{
  long At;
  long addr;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 7;
}
    
void _ldx_i(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    At = tempint;
    X = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  t += 2;
}

void _ldx_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = tempint;
    X = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _ldx_dy(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+Y, 0);
    At = tempint;
    X = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _ldx_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = tempint;
    X = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _ldx_ay(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    At = tempint;
    X = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _ldy_i(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    At = tempint;
    Y = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  t += 2;
}

void _ldy_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = tempint;
    Y = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _ldy_dx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    At = tempint;
    Y = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _ldy_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = tempint;
    Y = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _ldy_ax(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    At = tempint;
    Y = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _lsr_A(void)
{
    P &= 0xFFFE | (0x0001 & (A));
    A >>= 1;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);

  PC++;
  t += 2;
}

void _lsr_d(void)
{
  PC++;
  
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, PB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC++;
  t += 2;
}

void _lsr_dx(void)
{
  PC++;
  
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, PB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC++;
  t += 2;
}

void _lsr_a(void)
{
  PC++;
  
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC += 2;
  t += 2;
}

void _lsr_ax(void)
{
  PC++;
  
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC += 2;
  t += 2;
}

void _ora_i(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    At = (long)A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  t += 2;
}

void _ora_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _ora_dx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _ora_pd(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, DB);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}
  
void _ora_pdx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, DB);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 6;
}

void _ora_pd_y(void)
{
  long At;
  long mem;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetword((unsigned int)(mem & 0x0000ffff), mem >> 16);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _ora_bd(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 6;
}

void _ora_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _ora_ax(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _ora_ay(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _ora_al(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(tempint, tempbyte);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _ora_alx(void)
{
  long At;
  long addr;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _ora_ds(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(S+tempbyte, 0);
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _ora_pds_y(void)
{
  long At;
  long addr;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A | tempint;
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 7;
}

void _rol_A(void)
{
    P &= 0xFFFE | (0x0001 & (A >> 16));
    A <<= 1;
    A |= (P & 0x0001);
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);

  PC++;
  t += 2;
}

void _rol_d(void)
{
  PC++;
  
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, PB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    tempint |= (P & 0x0001);
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC++;
  t += 2;
}

void _rol_dx(void)
{
  PC++;
  
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, PB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    tempint |= (P & 0x0001);
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC++;
  t += 2;
}

void _rol_a(void)
{
  PC++;
  
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    tempint |= (P & 0x0001);
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC += 2;
  t += 2;
}

void _rol_ax(void)
{
  PC++;
  
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    P &= 0xFFFE | (0x0001 & (tempint >> 16));
    tempint <<= 1;
    tempint |= (P & 0x0001);
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC += 2;
  t += 2;
}

void _ror_A(void)
{
    P &= 0xFFFE | (0x0001 & (A));
    A >>= 1;
    A |= (P & 0x0001) << 16;
    P = P & ((0x8000 & A) | 0x7FFF);
    if (A == 0) P |= 0x02; else P &= (!0x02);

  PC++;
  t += 2;
}

void _ror_d(void)
{
  PC++;
  
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, PB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    tempint |= (P & 0x0001) << 16;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC++;
  t += 2;
}

void _ror_dx(void)
{
  PC++;
  
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, PB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    tempint |= (P & 0x0001) << 16;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC++;
  t += 2;
}

void _ror_a(void)
{
  PC++;
  
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    tempint |= (P & 0x0001) << 16;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC += 2;
  t += 2;
}

void _ror_ax(void)
{
  PC++;
  
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    P &= 0xFFFE | (0x0001 & (tempint));
    tempint >>= 1;
    tempint |= (P & 0x0001) << 16;
    P = P & ((0x8000 & tempint) | 0x7FFF);
    if (tempint == 0) P |= 0x02; else P &= (!0x02);
    SNESsetword(PC, PB, tempint);

  PC += 2;
  t += 2;
}

void _sbc_i(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC -= 2;
    At = (long)A + tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  t += 2;
}

void _sbc_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _sbc_dx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, 0);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _sbc_pd(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, DB);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}
  
void _sbc_pdx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte+X, DB);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 6;
}

void _sbc_pd_y(void)
{
  long At;
  long mem;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    tempint  = SNESgetword((unsigned int)(mem & 0x0000ffff), mem >> 16);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _sbc_bd(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(D+tempbyte, 0);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 6;
}

void _sbc_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint, DB);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _sbc_ax(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+X, DB);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _sbc_ay(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    tempint  = SNESgetword(tempint+Y, DB);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC += 2;
  t += 4;
}

void _sbc_al(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(tempint, tempbyte);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _sbc_alx(void)
{
  long At;
  long addr;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 5;
}

void _sbc_ds(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    tempint  = SNESgetword(S+tempbyte, 0);
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 4;
}

void _sbc_pds_y(void)
{
  long At;
  long addr;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    tempint  = SNESgetword((int)(addr & 0x0000FFFF), (char)(addr >> 16));
    At = A - tempint;
    if (At > 0x0000ffff) 
    {
      P |= 0x01;
      P |= 0x40;
    }
    else
    {
      P &= 0xFE;
      P &= 0xBF;
    }
    A = (unsigned int)At;
    if (tempint == 0) P |= 0x02; else P &= 0xFD;
    if (tempint & 0x8000) P |= 0x80; else P &= 0x7F;
  
  PC++;
  t += 7;
}

void _sta_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, 0, A);
  
  PC++;
  t += 4;
}

void _sta_dx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte+X, 0, A);
  
  PC++;
  t += 4;
}

void _sta_pd(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, DB, A);
  
  PC++;
  t += 5;
}
  
void _sta_pdx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte+X, DB, A);
  
  PC++;
  t += 6;
}

void _sta_pd_y(void)
{
  long At;
  long mem;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    mem = ((long)DB << 16) + D + tempbyte + Y;
    SNESsetword((unsigned int)(mem & 0x0000ffff), mem >> 16, A);
  
  PC++;
  t += 5;
}

void _sta_bd(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, 0, A);
  
  PC++;
  t += 6;
}

void _sta_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint, DB, A);
  
  PC += 2;
  t += 4;
}

void _sta_ax(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint+X, DB, A);
  
  PC++;
  t += 4;
}

void _sta_ay(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint+Y, DB, A);
  
  PC++;
  t += 4;
}

void _sta_al(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(tempint, tempbyte, A);
  
  PC++;
  t += 5;
}

void _sta_alx(void)
{
  long At;
  long addr;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    PC += 2;
    tempbyte = SNESgetbyte(PC, PB);
    addr = (long)((long)tempbyte << 16) + tempint;
    addr += X;
    SNESsetword((int)(addr & 0x0000FFFF), (char)(addr >> 16), A);
  
  PC++;
  t += 5;
}

void _sta_ds(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(S+tempbyte, 0, A);
  
  PC++;
  t += 4;
}

void _sta_pds_y(void)
{
  long At;
  long addr;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    addr = ((long)DB << 16) + S + tempbyte + Y;
    SNESsetword((int)(addr & 0x0000FFFF), (char)(addr >> 16), A);
  
  PC++;
  t += 7;
}

void _stx_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, 0, X);
  
  PC++;
  t += 4;
}

void _stx_dy(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte+Y, 0, X);
  
  PC++;
  t += 4;
}

void _stx_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint, DB, X);
  
  PC += 2;
  t += 4;
}

void _sty_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, 0, Y);
  
  PC++;
  t += 4;
}

void _sty_dx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte+X, 0, Y);
  
  PC++;
  t += 4;
}

void _sty_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint, DB, Y);
  
  PC += 2;
  t += 4;
}

void _stz_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, 0, 0);
  
  PC++;
  t += 4;
}

void _stz_dx(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte+X, 0, 0);
  
  PC++;
  t += 4;
}

void _stz_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint, DB, 0);
  
  PC += 2;
  t += 4;
}

void _stz_ax(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint+X, DB, 0);
  
  PC += 2;
  t += 4;
}

void _trb_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, 0, !A & SNESgetword(D+tempbyte, 0));
  
  PC++;
  t += 4;
}

void _trb_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint, DB, !A & SNESgetword(tempint, DB));
  
  PC++;
  t += 4;
}

void _tsb_d(void)
{
  long At;
  
  PC++;
    tempbyte = SNESgetbyte(PC, PB);
    SNESsetword(D+tempbyte, 0, A | SNESgetword(D+tempbyte, 0));
  
  PC++;
  t += 4;
}

void _tsb_a(void)
{
  long At;
  
  PC++;
    tempint  = SNESgetword(PC, PB);
    SNESsetword(tempint, DB, A | SNESgetword(tempint, DB));
  
  PC++;
  t += 4;
}

void _bcc(void)
{
  if (!(P & 0x01))
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _bcs(void)
{
  if (P & 0x01)
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _beq(void)
{
  if (P & 0x02)
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _bmi(void)
{
  if (P & 0x80)
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _bne(void)
{
  if (!(P & 0x02))
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _bpl(void)
{
  if (!(P & 0x80))
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _bra(void)
{
  PC++;
  PC += (signed char)SNESgetbyte(PC, PB);
  PC++;
}

void _bvc(void)
{
  if (!(P & 0x40))
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _bvs(void)
{
  if (P & 0x40)
  {
    PC++;
    PC += (signed char)SNESgetbyte(PC, PB);
    PC++;
  }
  else
    PC += 2;
}

void _clc(void)
{
  P &= 0xFE;
  PC++;
}

void _cld(void)
{
  P &= 0xF7;
  PC++;
}

void _cli(void)
{
  P &= 0xFB;
  PC++;
}

void _clv(void)
{
  P &= 0xBF;
  PC++;
}

void _dex(void)
{
  X--;
  PC++;
}

void _dey(void)
{
  Y--;
  PC++;
}

void _inx(void)
{
  X++;
  PC++;
}

void _iny(void)
{
  Y++;
  PC++;
}

void _nop(void)
{
  PC++;
  return;
}

void _pea(void)
{
  PC++;
  SNESsetbyte(S, 0, SNESgetbyte(PC, PB));
  S -= 2;
  PC += 2;
}

void _pei(void)
{
  PC++;
  tempbyte = SNESgetbyte(PC, PB);
  SNESsetbyte(S, 0, SNESgetword(D+tempbyte, 0));
  S -= 2;
  PC += 1;
}

void _per(void)
{
  PC++;
  tempbyte = SNESgetbyte(PC, PB);
  SNESsetbyte(S, 0, SNESgetword(PC+tempbyte, PB));
  S -= 2;
  PC += 1;
}

void _pha(void)
{
  PC++;
    SNESsetword(S, 0, A);
    S -= 2;
}

void _phb(void)
{
  PC++;
  SNESsetbyte(S, 0, DB);
  S -= 1;
}

void _phd(void)
{
  PC++;
  SNESsetword(S, 0, D);
  S -= 2;
}

void _phk(void)
{
  PC++;
  SNESsetbyte(S, 0, (char)(PB >> 16));
  S -= 1;
}

void _php(void)
{
  PC++;
  SNESsetbyte(S, 0, P);
  S -= 1;
}

void _phx(void)
{
  PC++;
    SNESsetword(S, 0, X);
    S -= 2;
}

void _phy(void)
{
  PC++;
    SNESsetword(S, 0, Y);
    S -= 2;
}

void _pla(void)
{
  PC++;
    S += 2;
    A = SNESgetword(S, 0);
}

void _plb(void)
{
  S += 1;
  DB = SNESgetbyte(S, 0);
  PC++;
}

void _pld(void)
{
  S += 2;
  D = SNESgetword(S, 0);
  PC++;
}

void _plp(void)
{ 
  S += 1;
  P = SNESgetbyte(S, 0);
  if (PE != 1)
  {
    if ((P & 0x20) || (P & 0x10))
    {
      if ((P & 0x20) && (P & 0x10))
      {
        init_all_byte();
      }
      else if (P & 0x20)
      {
        init_a_byte();
      }
      else if (P & 0x10)
      {
        init_x_byte();
      }
    }
    else
      init_all_word();
  }
  PC++;
}

void _plx(void)
{
  PC++;
    S += 2;
    X = SNESgetword(S, 0);
}

void _ply(void)
{
  PC++;
    S += 2;
    Y = SNESgetword(S, 0);
}

void _sec(void)
{
  PC++;
  P |= 0x01;
}

void _sed(void)
{
  PC++;
  P |= 0x08;
}

void _sei(void)
{
  PC++;
  P |= 0x04;
}

void _tax(void)
{
  PC++;
  X = A;
}

void _tay(void)
{
  PC++;
  Y = A;
}

void _tcd(void)
{
  PC++;
  D = A;
}

void _tcs(void)
{
  PC++;
  S = A;
}

void _tdc(void)
{
  PC++;
  A = D;
}

void _tsc(void)
{
  PC++;
  A = S;
}

void _tsx(void)
{
  X = S;
  PC++;
}

void _txa(void)
{
  A = X;
  PC++;
}

void _txs(void)
{
    S = A;

  PC++;
}

void _txy(void)
{
  PC++;
  Y = X;
}

void _tya(void)
{ 
  PC++;
  A = Y;
}

void _tyx(void)
{
  PC++;
  X = Y;
}

void _xce(void)
{
  PE = P & 0x01;
  P |= PE & 0x01;

  if (PE == 1)
  {
    P |= 0x30;
    S = (S & 0x00FF) | 0x0100;
    init_emu();
  }
  else
  {
    if ((P & 0x20) || (P & 0x10))
    {
      if ((P & 0x20) && (P & 0x10))
      {
        init_all_byte();
      }
      else if (P & 0x20)
      {
        init_a_byte();
      }
      else if (P & 0x10)
      {
        init_x_byte();
      }
    }
    else
      init_all_word();
  }

  PC++;
}

void _brl(void)
{
  PC++;
  tempint = SNESgetword(PC, PB);
  PC += tempint;
  PC+=2;
}

void _jmp_al(void)
{
 PC++;
 tempint = SNESgetword(PC,PB);
 PB=(long)SNESgetbyte(PC+2,PB) << 16;
 PC=tempint;
}

void _sep(void)
{
  PC++;
  P = P | SNESgetbyte(PC, PB);
  if (PE != 1)
  {
    if ((P & 0x20) || (P & 0x10))
    {
      if ((P & 0x20) && (P & 0x10))
      {
        init_all_byte();
      }
      else if (P & 0x20)
      {
        init_a_byte();
      }
      else if (P & 0x10)
      {
        init_x_byte();
      }
    }
    else
      init_all_word();
  }
  PC++;
}

void _rep(void)
{
  PC++;
  P = P & !SNESgetbyte(PC, PB);
  if (!PE)
  {
    if ((P & 0x20) || (P & 0x10))
    {
      if ((P & 0x20) && (P & 0x10))
      {
        init_all_byte();
      }
      else if (P & 0x20)
      {
        init_a_byte();
      }
      else if (P & 0x10)
      {
        init_x_byte();
      }
    }
    else
      init_all_word();
  }
  PC++;
}

void _xba(void)
{
  A = ((A & 0x00FF) << 8) | ((A & 0xFF00) >> 8);
  PC++;
}

void _jsr_a(void)
{
  SNESsetword(S, 0, PC);
  S -= 2;
  PC = SNESgetword(PC+1, PB);
}

void _rts(void)
{
  S += 2;
  PC = SNESgetword(S, 0) + 3;
}


