#ifndef __General_H__
#define __General_H__

#define true -1
#define false 0

#define HLtype short

#define HiROM 0 
#define LoROM 1

#define MemType short

#define SnesRom 0
#define SnesRam 1
#define SnesVRam 2
#define SnesSRam 3
#define SnesPort 4 
#define SnesDMA 5 
#define SnesInvalid 6

#define SNESgetbyte(offs,seg) (unsigned char)CartROM[((int)(seg & 0x7F0000)) + (int)offs]
#define SNESgetword(offs,seg) ((unsigned char)CartROM[((int)(seg & 0x7F0000)) + (int)offs]) | ((unsigned char)CartROM[((int)(seg & 0x7F0000)) + (int)offs + 1] << 8) 

typedef struct {
  short int BaseAddress;
  short int SCSize;
  int dirty;
} bginfo;

typedef struct {
   char ROM_Title[21];           
   char dummy;                   
   unsigned char ROM_Type;       
   unsigned char ROM_Size;       
   unsigned char SRAM_Size;      
   unsigned char Country_Code;   
   unsigned char License;        
   unsigned char ROM_Version;    
   unsigned short int Complement;
   unsigned short int Checksum;  
} SNESRomInfoStruct;

/* Registers */
extern unsigned short A, X, Y, D;
extern unsigned char DB, PB, P;
extern unsigned char PE;
extern unsigned short PC, S;
extern unsigned long t;

/* General Variables */
extern SNESRomInfoStruct GameInfo;
extern long int fileheader;
extern HLtype ROMType;
extern short LoROMovr, HiROMovr, override;
extern long ops_done;

/* Opcode Function */
void debugerr();
void AllocateRAM (void);
void ReadRom(char *File);
void FreeBuffers (void);
void SNESsetword(unsigned short soffs, unsigned char seg, unsigned short byte);
void SNESsetbyte(unsigned short offs, unsigned char seg, unsigned char byte);
void init_opcodes(void);

/* Stuff */
extern unsigned char *CartROM, *SnesVRAM;
extern char port4212;
extern short TrippedNMI;

extern short PCinc[256];

#endif
