#ifndef __OpDefine_h__
#define __OpDefine_h__

// Just some stuff... ///////////////////////////////////////////////
typedef unsigned char  Byte;
typedef unsigned short Word;

// Global CPU variables /////////////////////////////////////////////
struct X_x {
  Word x;
};

struct X_h {
  Byte xh;
  Byte xl;
};

union X_t {
  X_x x;
  X_h h;
};

struct Y_x {
  Word y;
};

struct Y_h {
  Byte yh;
  Byte yl;
};

union Y_t {
  Y_x x;
  Y_h h;
};

struct A_x {
  Word a;
};

struct A_h {
  Byte ah;
  Byte al;
};

union A_t {
  A_x x;
  A_h h;
};

A_t A;
X_t X;
Y_t Y;

Word D;
Word PC;
Word S;

unsigned long PB;
unsigned long DB;

unsigned long IP;

Byte P;

char *AddrPtr;

Word TempWord;
Byte TempByte;

// Memory Functions /////////////////////////////////////////////////
void *SnesMap(unsigned long Seg, unsigned short Ofs);
void *SnesMapLo(unsigned short Ofs);

Word SnesGetWord(void *ptr);
Byte SnesGetByte(void *ptr);

// Flags ////////////////////////////////////////////////////////////
void GetFlags_cznv_B(Byte val, Byte val2, Word val3);
void GetFlags_znv_B(Byte val, Byte val2, Word val3);
void GetFlags_czn_B(Word val);
void GetFlags_cz_B(Word val);
void GetFlags_nz_B(Word val);
void GetFlags_z_B(Word val);
void GetFlags_cznv_W(Word val, Word val2, unsigned long val3);
void GetFlags_znv_W(Word val, Word val2, unsigned long val3);
void GetFlags_czn_W(unsigned long val);
void GetFlags_cz_W(unsigned long val);
void GetFlags_nz_W(unsigned long val);
void GetFlags_z_W(unsigned long val);

// Addressing Mode Functions ////////////////////////////////////////
void Immediate(void);
void Absolute(void);
void AbsoluteLong(void);
void Direct(void);
void IndirectY(void);
void DirIndIndexL(void);
void DirIndexInd(void);
void DirIndexX(void);
void DirIndexY(void);
void AbsoluteX(void);
void AbsoluteY(void);
void AbsoluteLongX(void);
void AbsoluteInd(void);
void DirectInd(void);
void DirectIndL(void);
void AbsoluteIndexInd(void);
void StackRel(void);
void StackRelIndIndex(void);

// Opcodes.. ////////////////////////////////////////////////////////
void _adc_b(void);
void _adc_w(void);

#endif
