#include <stdio.h>
#include "general.h"

void debugerr()
{
  printf("error\n");
}

#pragma warn -sig     /*  I hate "Conversion may lose significant digits"*/
void AllocateRAM (void)
{
  int i;
  fputs("Getting memory...",stdout);
  fputs("SNES ROM...",stdout);
  if ((CartROM=(unsigned char*)calloc(4194309,1))==NULL)
  {
    puts("\nCouldn't allocate memory for cartridge ROM image!!\n");
    exit(255);
  }
  fputs("VRAM...\n",stdout);
  if ((SnesVRAM=(unsigned char*)calloc(65540,1))==NULL)
  {
    puts("\nCouldn't allocate memory for cartridge video RAM!!\n");
    exit(255);
  }
}

/*unsigned char SNESgetbyte(unsigned short int offs, unsigned char seg)
{
  return (unsigned char)CartROM[((int)(seg & 0x7F) << 16) + (int)offs];
}

unsigned short int SNESgetword(unsigned short int offs, unsigned char seg)  
{
  return ((unsigned char)CartROM[((int)(seg & 0x7F) << 16) + (int)offs]) |
         ((unsigned char)CartROM[((int)(seg & 0x7F) << 16) + (int)offs + 1] << 8);
}*/

void SNESsetbyte(unsigned short offs, unsigned char seg, unsigned char byte)
{
  long int realoffs;

  realoffs = (int)offs + ((int)(seg * 0x7F0000));

  CartROM[realoffs]=byte;
}

void SNESsetword(unsigned short soffs, unsigned char seg, unsigned short byte)
{
  long int offs;

  offs = (int)soffs + ((int)(seg * 0x7F0000));

  CartROM[offs]=byte&0xff;
  CartROM[offs+1]=byte>>8;
}

void FreeBuffers (void)
{
  int i;

  free(CartROM);
  free(SnesVRAM);
  printf("Opcodes executed: %i\n", ops_done);
  printf("PE=0x%X, P=0x%X, A=0x%X, X=0x%X, Y=0x%X, D=0x%X, DB=0x%X,\n", (int)PE, (int)P, (int)A, (int)X, (int)Y, (int)D, (int)DB);
  printf("PC=0x%X, PB=0x%X, S=0x%X\n", (int)PC, (int)PB, (int)S);
  puts("All allocated memory freed.");
}
