/***************************************************************************
FILE: and.cpp
PURPOSE: AND memory with accumulator
Copyright 1997 Jeff Slutter
***************************************************************************/

#include "opcodes.h"

//0x29
//AND #
//Bytes 2
//Cycles 2
void and_im()
{
	PC++;
	if (P.M==1)
	{
		A=(0xFF&A) & immediateVb();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=(0xFFFF&A) & immediateVw();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=2;
 }


//0x25
//AND d
//Bytes 2
//Cycles 3
void and_d()
{
	PC++;
	if (P.M==1)
	{
		A=(0xFF&A) & directVb();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=(0xFFFF&A) & directVw();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=3;
}

//0x35
//AND d,x
//Bytes 2
//Cycles 4
void and_d_ix_x()
{
	PC++;
	if (P.M==1)
	{
		A=(0xFF&A) & direct_indexed_xVb();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=(0xFFFF&A) & direct_indexed_xVw();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x32
//AND (d)
//Bytes 2
//Cycles 5
void and_d_in()
{
	PC++;
	if (P.M==1)
	{
		A=(0xFF&A) & direct_indirVb();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=(0xFFFF&A) & direct_indirVw();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0x21
//AND (d,x)
//Bytes 2
//Cycles 6
void and_d_ix_in()
{
	PC++;
	if (P.M==1)
	{
		A=(0xFF&A) & direct_indexed_indirVb();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=(0xFFFF&A) & direct_indexed_indirVw();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=6;
}

//0x31
//AND (d),y
//Bytes 2
//Cycles 5
void and_d_in_ix()
{
	PC++;
	if (P.M==1)
	{
		A=(0xFF&A) & direct_indir_indexed_yVb();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=(0xFFFF&A) & direct_indir_indexed_yVw();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0x27
//AND [d]
//Bytes 2
//Cycles 6
void and_d_in_l()
{
	PC++;
	if (P.M==1)
	{
		A=(0xFF&A) & direct_indir_longVb();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=(0xFFFF&A) & direct_indir_longVw();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=6;
}

//0x2D
//AND a
//Bytes 3
//Cycles 4
void and_a()
{
	PC++;
	if (P.M==1)
	{
		A=(0xFF&A) & absoluteVb();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=(0xFFFF&A) & absoluteVw();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x3D
//AND a,x
//Bytes 3
//Cycles 4
void and_a_ix_x()
{
	PC++;
	if (P.M==1)
	{
		A=(0xFF&A) & absolute_XindexedVb();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=(0xFFFF&A) & absolute_XindexedVw();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x39
//AND a,y
//Bytes 3
//Cycles 4
void and_a_ix_y()
{
	PC++;
	if (P.M==1)
	{
		A=(0xFF&A) & absolute_YindexedVb();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=(0xFFFF&A) & absolute_YindexedVw();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x2F
//AND al
//Bytes 4
//Cycles 5
void and_al()
{
	PC++;
	if (P.M==1)
	{
		A=(0xFF&A) & absolute_longVb();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=(0xFFFF&A) & absolute_longVw();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0x3F
//AND al,x
//Bytes 4
//Cycles 5
void and_a_l_ix_x()
{
	PC++;
	if (P.M==1)
	{
		A=(0xFF&A) & absolute_long_indexedVb();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=(0xFFFF&A) & absolute_long_indexedVw();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=5;
}

//0x23
//AND d,s
//Bytes 2
//Cycles 4
void and_s_r()
{
	PC++;
	if (P.M==1)
	{
		A=(0xFF&A) & stack_relativeVb();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=(0xFFFF&A) & stack_relativeVw();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0x33
//AND (d,s),y
//Bytes 2
//Cycles 7
void and_s_r_in_ix()
{
	PC++;
	if (P.M==1)
	{
		A=(0xFF&A) & stack_relative_indir_indexedVb();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x80) P.N=1; else P.N=0;
	}
	else
	{
		A=(0xFFFF&A) & stack_relative_indir_indexedVw();
		if(A==0) P.Z=1; else P.Z=0;
		if(A&0x8000) P.N=1; else P.N=0;
	}
	t+=7;
}