/***************************************************************************
FILE: bit.cpp
PURPOSE: Bit test
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//Need to Do:
//I need to work on the overflow flag


//0x89
//BIT #
//Bytes 2
//Cycles 2
void bit_im()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=immediateVb();
		result=(A&0xFF)&B;
		if(result==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; P.V=0;
		}else P.V=0;
	}
	else
	{
		Double result;
		Word W;

		W=immediateVw();
		result=(A&0xFFFF)&W;
		if(result==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; P.V=0;
		}else P.V=0;
	}
	t+=2;
}

//0x24
//BIT d
//Bytes 2
//Cycles 3
void bit_d()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=directVb();
		result=(A&0xFF)&B;
		if(result==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; P.V=0;
		}else P.V=0;
	}
	else
	{
		Double result;
		Word W;

		W=directVw();
		result=(A&0xFFFF)&W;
		if(result==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; P.V=0;
		}else P.V=0;
	}
	t+=3;
}

//0x34
//BIT d,x
//Bytes 2
//Cycles 4
void bit_d_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=direct_indexed_xVb();
		result=(A&0xFF)&B;
		if(result==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; P.V=0;
		}else P.V=0;
	}
	else
	{
		Double result;
		Word W;

		W=direct_indexed_xVw();
		result=(A&0xFFFF)&W;
		if(result==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; P.V=0;
		}else P.V=0;
	}
	t+=4;
}

//0x2C
//BIT a
//Bytes 3
//Cycles 4
void bit_a()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=absoluteVb();
		result=(A&0xFF)&B;
		if(result==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; P.V=0;
		}else P.V=0;
	}
	else
	{
		Double result;
		Word W;

		W=absoluteVw();
		result=(A&0xFFFF)&W;
		if(result==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; P.V=0;
		}else P.V=0;
	}
	t+=4;
}

//0x3C
//BIT a,x
//Bytes 3
//Cycles 4
void bit_a_ix_x()
{
	PC++;
	if(P.M==1)
	{
		Word result;
		Byte B;

		B=absolute_XindexedVb();
		result=(A&0xFF)&B;
		if(result==0) P.Z=1; else P.Z=0;
		if(result&0x80) P.N=1; else P.N=0;
		if((A&0x80)==(B&0x80))
		{
			if((A&0x80)!=(result&0x80)) P.V=1; P.V=0;
		}else P.V=0;
	}
	else
	{
		Double result;
		Word W;

		W=absolute_XindexedVw();
		result=(A&0xFFFF)&W;
		if(result==0) P.Z=1; else P.Z=0;
		if(result&0x8000) P.N=1; else P.N=0;
		if((A&0x8000)==(W&0x8000))
		{
			if((A&0x8000)!=((Word)result&0x8000)) P.V=1; P.V=0;
		}else P.V=0;
	}
	t+=4;
}

