/***************************************************************************
FILE: ldx.cpp
PURPOSE: load X with memory
Copyright 1997 Jeff Slutter
***************************************************************************/
#include "opcodes.h"

//0xA2
//LDX #
//Bytes 2
//Cycles 2
void ldx_im()
{
	PC++;
	if(P.X==1)
	{
		X=(immediateVb())|(X&0xFF00);
		if(X&0xFF==0) P.Z=1; else P.Z=0;
		if(X&0x80) P.N=1; else P.N=0;
	}
	else
	{
		X=immediateVw();
		if(X&0xFFFF==0) P.Z=1; else P.Z=0;
		if(X&0x8000) P.N=1; else P.N=0;
	}
	t+=2;
}

//0xA6
//LDX d
//Bytes 2
//Cycles 3
void ldx_d()
{
	PC++;
	if(P.X==1)
	{
		X=(directVb())|(X&0xFF00);
		if(X&0xFF==0) P.Z=1; else P.Z=0;
		if(X&0x80) P.N=1; else P.N=0;
	}
	else
	{
		X=directVw();
		if(X&0xFFFF==0) P.Z=1; else P.Z=0;
		if(X&0x8000) P.N=1; else P.N=0;
	}
	t+=3;
}

//0xB6
//LDX d,y
//Bytes 2
//Cycles 4
void ldx_d_ix_y()
{
	PC++;
	if(P.X==1)
	{
		X=(direct_indexed_yVb())|(X&0xFF00);
		if(X&0xFF==0) P.Z=1; else P.Z=0;
		if(X&0x80) P.N=1; else P.N=0;
	}
	else
	{
		X=direct_indexed_yVw();
		if(X&0xFFFF==0) P.Z=1; else P.Z=0;
		if(X&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0xAE
//LDX a
//Bytes 3
//Cycles 4
void ldx_a()
{
	PC++;
	if(P.X==1)
	{
		X=(absoluteVb())|(X&0xFF00);
		if(X&0xFF==0) P.Z=1; else P.Z=0;
		if(X&0x80) P.N=1; else P.N=0;
	}
	else
	{
		X=absoluteVw();
		if(X&0xFFFF==0) P.Z=1; else P.Z=0;
		if(X&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}

//0xBE
//LDX a,y
//Bytes 3
//Cycles 4
void ldx_a_ix_y()
{
	PC++;
	if(P.X==1)
	{
		X=(absolute_YindexedVb())|(X&0xFF00);
		if(X&0xFF==0) P.Z=1; else P.Z=0;
		if(X&0x80) P.N=1; else P.N=0;
	}
	else
	{
		X=absolute_YindexedVw();
		if(X&0xFFFF==0) P.Z=1; else P.Z=0;
		if(X&0x8000) P.N=1; else P.N=0;
	}
	t+=4;
}
